/* -*- C++ -*- */
#ifndef APP_H
#define APP_H

#include <kmainwindow.h>
#include <kparts/part.h>
#include <kactionclasses.h>
#include <kcmdlineargs.h>
#include <apt-front/cache/observer.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <libept/view.h>
#include <libept/commitprogress.h>
#include <libept/application.h>

class QVBox;
class QWidgetStack;
class QSplitter;
class KAction;
class KPushButton;
namespace ept {
class AcqProgressWidget;
}

using namespace aptFront;
using namespace ept;

class App : public KMainWindow, Application {
    Q_OBJECT
public:
    void setupActions();
    ExtTerminalInterface *terminal();
	App( KCmdLineArgs *a );
protected slots:
    void delayed();
protected:
    friend class WaitForLister;

    QWidgetStack *m_stack;
    QVBox *m_all;

    // stacked widgets
    ept::AcqProgressWidget *m_progress;
    ept::CommitProgress *m_commitProgress;
};

#endif
