// KDE includes
 
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kuniqueapplication.h>

#include "app.h"

static KCmdLineOptions options[] =
{
    { "+command", I18N_NOOP("Command"), 0 },
    KCmdLineLastOption
};

int main(int argc, char *argv[])
{
    QString description = i18n("Adept Batch");
    
    KAboutData aboutData( "adept_batch", 
                          I18N_NOOP("Adept Batch"),
                          "2.0 Destroyer",
                          description.latin1(),
                          KAboutData::License_BSD,
                          I18N_NOOP("(c) 2006 Peter Rockai"),
                          0,
                          "http://web.mornfall.net/adept.html");

    aboutData.addAuthor ( "Peter Rockai",
                          I18N_NOOP("developer"),
                          "me at mornfall dot net",
                          "http://web.mornfall.net");

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); 

    KApplication app;
    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
    App *ta = new App( args );

    app.setMainWidget( ta );
    ta->show();

    return app.exec();
}
