/** -*- C++ -*-
    @file libept/acqprogress.h
    @author Peter Rockai <me@mornfall.net>
*/

#ifndef ACQPROGRESS_H
#define ACQPROGRESS_H

#include <klocale.h>
#include <kdialogbase.h>
#include <klistview.h>
#include <kprogress.h>

#include <vector>
#include <apt-pkg/acquire.h>
#include <apt-front/progresscallback.h>

class AcqStatus;
class QLabel;
class QProgressBar;
class QSpacer;
class QGridLayout;

namespace ept {

class AcqStatus : public KListView, public aptFront::ProgressCallback
{
    Q_OBJECT
protected:
    class ItemProgress: public KProgress {
    public:
        ItemProgress( QWidget *parent, const char *name = 0 )
            : KProgress( parent, name ), m_spin( 0 ) {}
        void setStatus( const std::string &s,
                        int prog = 0 ) {
            m_status = s;
            if (m_status == "hit"
                || m_status == "ignored"
                || m_status == "done")
                prog = 100;
            if (m_status == "waiting") {
                prog = 0;
            }
            if (m_status == "progress" && prog != 100)
                setFormat( i18n( "downloading (%p%)" ) );
            else if (prog == 100) // who cares about hit/ignore anyway?
                setFormat( i18n( "done (%p%)" ) );
            else
                setFormat( m_status );
            setProgress( prog );
        }
    protected:
        std::string m_status;
        int m_spin;
    };
    class Item : public KListViewItem {
    protected:
        ItemProgress *m_prog;
        int m_pbcol;
        unsigned long m_id;
        pkgAcquire::ItemDesc m_item;

    public:
        Item (KListView *parent, pkgAcquire::ItemDesc &item,
              bool hit = false);
        virtual ~Item ();

        virtual void paintCell (QPainter *p, const QColorGroup &cg,
                                int column, int width, int alignment);

        void setProgress (int);
        virtual int compare (QListViewItem *i, int col, bool ascend) const;
        virtual void pulse (pkgAcquire::Worker *);
        void setStatus( const std::string &, int = 0 );

        void setup() {
            KListViewItem::setup();
            setHeight( height() + 6 );
        }
    };
    unsigned long ID;
    unsigned long m_idOffset;
    std::vector <Item *> m_items;
    bool m_continue;
    
public:
    
    enum Status { StWaiting, StDownloading, StDone };
    
    AcqStatus (QWidget *parent, const char *name);
    Item *findItem (pkgAcquire::ItemDesc &Itm);
    
    virtual bool MediaChange (string Media,string Drive);
    virtual void IMSHit (pkgAcquire::ItemDesc &Itm);
    virtual void Fetch (pkgAcquire::ItemDesc &Itm);
    virtual void Done (pkgAcquire::ItemDesc &Itm);
    virtual void Fail (pkgAcquire::ItemDesc &Itm);
    virtual void Start ();
    virtual void Stop ();
    void addLine (QWidget *l, QWidget *s, QWidget *prog);
    void clear();

    bool Pulse (pkgAcquire *Owner);
    
public slots:
    void cancel();

signals:
    void statusChanged (AcqStatus::Status st);
    void totalProgress (int percent);
    
    //AcqTextStatus(unsigned int &ScreenWidth,unsigned int Quiet);
};

class AcqStatusDialog : public KDialogBase
{
	Q_OBJECT
protected:
	aptFront::SharedPtr<AcqStatus> m_status;
public:
    aptFront::SharedPtr<aptFront::ProgressCallback> callback() { return m_status.data(); };
    AcqStatusDialog (QWidget *parent, const char *name, bool modal);
public slots:
    void statusChange (AcqStatus::Status st);
};
}
#endif
