import os.path, os

from apport.hookutils import *

def installed_packages(report):
    packages=['vmbuilder', 'euca2ools', 'ec2-api-tools', 'ec2-ami-tools', 'eucalyptus-common', 'eucalyptus-sc', 
	'eucalyptus-cloud', 'eucalyptus-walrus', 'eucalyptus-java-common', 'eucalyptus-cc',
	'eucalyptus-nc', 'eucalyptus-gl', 'uec-component-listener']

    version = ''
    versions = ''
    for package in packages:
	try:
		version = packaging.get_versions(package)
	except (ValueError, AttributeError):
		version = 'N/A'
	if version is None:
		version = 'N/A'
	versions += '%s %s\n' %(package, version)
    report['EucalyptusInstalledVersions'] = versions

def add_info(report, ui):
    # Report on the versions that are installed, including: vmbuilder, ec2-api-tools
    # ec2-ami-tools, euca2ools, and eucalyptus*
    installed_packages(report)

    attach_file_if_exists(report, '/etc/eucalyptus/eucalyptus.conf', key='eucalyptus.conf')
    attach_file_if_exists(report, '/etc/eucalyptus/eucalyptus.local.conf', key='eucalyptus.local.conf')
    attach_file_if_exists(report, '/etc/eucalyptus/eucalyptus-cc.conf')

    logd = "/var/log/eucalyptus/"
    response = ui.yesno("Would you like to attach Eucalyptus log files in %s to this bug report?  These log files can be helpful to developers, but may contain sensitive data." % (logd))
    if response == None: #use canceled
        raise StopIteration
    if response == True:
        logs = { "Axis2c" : "axis2c.log",
                 "CC" : "cc.log",
                 "CloudDebug" : "cloud-debug.log",
                 "CloudOutput" : "cloud-output.log",
                 "HTTPDError" : "httpd-cc_error_log" }

        for (name,fname) in logs.iteritems():
            fpath = "%s/%s" % (logd, fname)
            if not os.path.exists(fpath): continue
            report["Eucalyptus%sLog" % name ] = (fpath, True)
