/*
 *
 *   (C) Copyright IBM Corp. 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libmac.so
 *
 *   File: segments.h
 */

#ifndef _MAC_SEGMENTS_H_
#define _MAC_SEGMENTS_H_


int             mac_can_set_volume( DISKSEG *seg, boolean flag );

int             mac_can_delete( DISKSEG *seg );

int             mac_can_expand( DISKSEG *seg,
                                sector_count_t  *expand_limit,
                                list_anchor_t          expansion_points );

int             mac_can_expand_by( DISKSEG *seg, sector_count_t *size);

int             mac_can_shrink( DISKSEG *seg,
                                sector_count_t   * shrink_limit,
                                list_anchor_t            shrink_points );

int             mac_can_shrink_by( DISKSEG *seg, sector_count_t *size );

int             mac_discover( list_anchor_t input_objects, list_anchor_t output_objects, boolean final_call);

int             mac_assign( storage_object_t * input_object, option_array_t * options );

int             mac_can_unassign( LOGICALDISK *ld );

int             mac_unassign( LOGICALDISK *ld );

int             mac_create( list_anchor_t          input_objects,
                            option_array_t * options,
                            list_anchor_t          new_objects);

int             mac_destroy( DISKSEG * seg, list_anchor_t child_objects );

int             mac_discard(list_anchor_t objects);

int             mac_expand( DISKSEG          *seg,
                            storage_object_t *expand_object,
                            list_anchor_t           objects,
                            option_array_t   *options );

int             mac_shrink( DISKSEG          * seg,
                            storage_object_t * shrink_object,
                            list_anchor_t            objects,
                            option_array_t   * options );

int             mac_add_sectors_to_kill_list( DISKSEG       *seg,
                                              lsn_t          lsn,
                                              sector_count_t count);

int             mac_commit_changes( DISKSEG *seg, uint commit_phase );

int             mac_read( DISKSEG *seg, lsn_t lsn, sector_count_t count, void *buffer );

int             mac_write( DISKSEG *seg, lsn_t lsn, sector_count_t count, void *buffer );

void            mac_set_volume(storage_object_t * object, boolean flag);

int             mac_get_info( DISKSEG *seg, char * name, extended_info_array_t  ** info_array );

void            delete_all_mac_segment_private_data(void);

#endif

