/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libcsm.so
 *
 *   File: options.h
 */

#ifndef   CSM_OPTIONS_HEADER
        #define   CSM_OPTIONS_HEADER                        1


//
// Assign
//
        #define CSM_ASSIGN_OPTION_COUNT                     3
        #define CSM_ASSIGN_OPTION_NODE_ID_INDEX             0
        #define CSM_ASSIGN_OPTION_NODE_ID_STRING            "Node"
        #define CSM_ASSIGN_OPTION_TYPE_INDEX                1
        #define CSM_ASSIGN_OPTION_TYPE_STRING               "Type"
        #define CSM_ASSIGN_OPTION_CONTAINER_NAME_INDEX      2
        #define CSM_ASSIGN_OPTION_CONTAINER_NAME_STRING     "Name"

//
//  Seg Info
//
        #define SEG_INFO_COUNT                              4
        #define SEG_INFO_NAME_INDEX                         0
        #define SEG_INFO_SIZE_INDEX                         1
        #define SEG_INFO_START_INDEX                        2
        #define SEG_INFO_TYPE_INDEX                         3


//
//  Metadata Info
//
        #define HEADER_INFO_COUNT                           6
        #define HEADER_INFO_HDRSIZE_INDEX                   0
        #define HEADER_INFO_ALTLBA_INDEX                    1
        #define HEADER_INFO_START_INDEX                     2
        #define HEADER_INFO_END_INDEX                       3
        #define HEADER_INFO_DISK_GUID_INDEX                 4
        #define HEADER_INFO_NODE_CUID_INDEX                 5


//
//  Container Set Info
//
        #define CONTAINER_SETINFO_COUNT                     3
        #define CONTAINER_SETINFO_TYPE_INDEX                0
        #define CONTAINER_SETINFO_TYPE_STRING               "Type"
        #define CONTAINER_SETINFO_NODE_ID_INDEX             1
        #define CONTAINER_SETINFO_NODE_ID_STRING            "Node"
        #define CONTAINER_SETINFO_NAME_INDEX                2
        #define CONTAINER_SETINFO_NAME_STRING               "Name"


//
//  Container Get Info
//
        #define CONTAINER_GETINFO_COUNT                     3
        #define CONTAINER_GETINFO_TYPE_INDEX                0
        #define CONTAINER_GETINFO_TYPE_STRING               "Type"
        #define CONTAINER_GETINFO_NODE_ID_INDEX             1
        #define CONTAINER_GETINFO_NODE_ID_STRING            "Node"
        #define CONTAINER_GETINFO_NAME_INDEX                2
        #define CONTAINER_GETINFO_NAME_STRING               "Name"


//
// Expand Container Option Info
//
        #define CSM_EXPAND_CONTAINER_OPTION_COUNT           0


//
// Shrink Container Option Info
//
        #define CSM_SHRINK_CONTAINER_OPTION_COUNT           0

//
//  Plugin Info
//
        #define PLUGIN_INFO_COUNT                           6
        #define PLUGIN_INFO_SNAME_INDEX                     0
        #define PLUGIN_INFO_LNAME_INDEX                     1
        #define PLUGIN_INFO_TYPE_INDEX                      2
        #define PLUGIN_INFO_VERSION_INDEX                   3
        #define PLUGIN_INFO_REQENGSVCVERSION_INDEX          4
        #define PLUGIN_INFO_REQPLUGAPIVERSION_INDEX         5





void        prune_acceptable_disks( list_anchor_t list );

int         csm_get_option_count(task_context_t * task);

int         csm_init_task(task_context_t * context);

int         csm_set_option( task_context_t * context, u_int32_t index, value_t * value, u_int32_t * info );

int         csm_get_segment_info( storage_object_t  * object, extended_info_array_t **info);

int         csm_get_metadata_info(storage_object_t * object, extended_info_array_t **info_array);

int         csm_get_plugin_info( char * descriptor_name, extended_info_array_t * * info );

int         csm_set_objects( task_context_t * context,
                             list_anchor_t    declined_objects,
                             task_effect_t  * effect );
#endif

