/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include <frontend.h>
#include <glib.h>
#include <ncurses.h>
#include <panel.h>

#include "common.h"
#include "container.h"
#include "window.h"
#include "menu.h"
#include "dialog.h"
#include "clist.h"
#include "task.h"
#include "logging.h"

/**
 *	get_container_name - return the container name for a given handle
 *	@container: the container handle
 *
 *	This routine returns a dynamically allocated string containing
 *	the name of the container corresponding to the handle given.
 */
gchar *get_container_name(object_handle_t container)
{
	gchar *name = NULL;

	if (container) {
		int rc;
		handle_object_info_t *info;

		rc = evms_get_info(container, &info);
		if (rc == 0) {
			name = g_strdup(info->info.container.name);
			evms_free(info);
		} else {
			log_error("%s: evms_get_info() returned error %d.\n", __FUNCTION__, rc);
		}
	}
	return name;
}
