/*
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libebackend/libebackend.h>

#include "e-google-chooser-button.h"
#include "e-google-chooser-dialog.h"
#include "module-cal-config-google.h"

/* Module Entry Points */
void e_module_load (GTypeModule *type_module);
void e_module_unload (GTypeModule *type_module);

G_MODULE_EXPORT void
e_module_load (GTypeModule *type_module)
{
	e_google_chooser_type_register (type_module);
	e_google_chooser_button_type_register (type_module);
	e_google_chooser_dialog_type_register (type_module);
	e_cal_config_google_type_register (type_module);
#ifdef HAVE_GDATA_0_15_1
	e_cal_config_gtasks_type_register (type_module);
#endif
}

G_MODULE_EXPORT void
e_module_unload (GTypeModule *type_module)
{
}
