/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.os.SystemClock;
import android.webkit.WebView;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.WebElement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebElementCreator {
    private List<WebElement> webElements;
    private Sleeper sleeper;
    private boolean isFinished = false;

    public WebElementCreator(Sleeper sleeper) {
        this.sleeper = sleeper;
        this.webElements = new CopyOnWriteArrayList<WebElement>();
    }

    public void prepareForStart() {
        this.setFinished(false);
        this.webElements.clear();
    }

    public ArrayList<WebElement> getWebElementsFromWebViews() {
        this.waitForWebElementsToBeCreted();
        return new ArrayList<WebElement>(this.webElements);
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished(boolean isFinished) {
        this.isFinished = isFinished;
    }

    public void createWebElementAndAddInList(String webData, WebView webView) {
        WebElement webElement = this.createWebElementAndSetLocation(webData, webView);
        if (webElement != null) {
            this.webElements.add(webElement);
        }
    }

    private void setLocation(WebElement webElement, WebView webView, int x, int y, int width, int height) {
        float scale = webView.getScale();
        int[] locationOfWebViewXY = new int[2];
        webView.getLocationOnScreen(locationOfWebViewXY);
        int locationX = (int)((double)locationOfWebViewXY[0] + ((double)x + Math.floor(width / 2)) * (double)scale);
        int locationY = (int)((double)locationOfWebViewXY[1] + ((double)y + Math.floor(height / 2)) * (double)scale);
        webElement.setLocationX(locationX);
        webElement.setLocationY(locationY);
    }

    private WebElement createWebElementAndSetLocation(String information, WebView webView) {
        String[] data = information.split(";,");
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        try {
            x = Math.round(Float.valueOf(data[5]).floatValue());
            y = Math.round(Float.valueOf(data[6]).floatValue());
            width = Math.round(Float.valueOf(data[7]).floatValue());
            height = Math.round(Float.valueOf(data[8]).floatValue());
        }
        catch (Exception ignored) {
            // empty catch block
        }
        WebElement webElement = null;
        try {
            webElement = new WebElement(data[0], data[1], data[2], data[3], data[4]);
            this.setLocation(webElement, webView, x, y, width, height);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return webElement;
    }

    private boolean waitForWebElementsToBeCreted() {
        long endTime = SystemClock.uptimeMillis() + 5000L;
        while (SystemClock.uptimeMillis() < endTime) {
            if (this.isFinished) {
                return true;
            }
            this.sleeper.sleepMini();
        }
        return false;
    }
}

