/* tpf-logger.c generated by valac 0.16.0, the Vala compiler
 * generated from tpf-logger.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_ACCOUNT_FAVOURITES (account_favourites_get_type ())
typedef struct _AccountFavourites AccountFavourites;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_LOGGER_IFACE (logger_iface_get_type ())
#define LOGGER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER_IFACE, LoggerIface))
#define IS_LOGGER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER_IFACE))
#define LOGGER_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_LOGGER_IFACE, LoggerIfaceIface))

typedef struct _LoggerIface LoggerIface;
typedef struct _LoggerIfaceIface LoggerIfaceIface;

#define TYPE_LOGGER_IFACE_PROXY (logger_iface_proxy_get_type ())
typedef GDBusProxy LoggerIfaceProxy;
typedef GDBusProxyClass LoggerIfaceProxyClass;

#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;
typedef struct _LoggerPrivate LoggerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _LoggerPrepareData LoggerPrepareData;
typedef struct _LoggerGetFavouriteContactsData LoggerGetFavouriteContactsData;
typedef struct _LoggerAddFavouriteContactData LoggerAddFavouriteContactData;
typedef struct _LoggerRemoveFavouriteContactData LoggerRemoveFavouriteContactData;

struct _AccountFavourites {
	char* account_path;
	gchar** ids;
	gint ids_length1;
	gint _ids_size_;
};

struct _LoggerIfaceIface {
	GTypeInterface parent_iface;
	void (*get_favourite_contacts) (LoggerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	AccountFavourites* (*get_favourite_contacts_finish) (LoggerIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*add_favourite_contact) (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_favourite_contact_finish) (LoggerIface* self, GAsyncResult* _res_, GError** error);
	void (*remove_favourite_contact) (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_favourite_contact_finish) (LoggerIface* self, GAsyncResult* _res_, GError** error);
};

struct _Logger {
	GObject parent_instance;
	LoggerPrivate * priv;
};

struct _LoggerClass {
	GObjectClass parent_class;
};

struct _LoggerPrivate {
	guint _logger_watch_id;
	gchar* _account_path;
};

struct _LoggerPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Logger* self;
	gboolean result;
	gboolean retval;
	LoggerIface* _tmp0_;
	GDBusConnection* _tmp1_;
	GDBusConnection* dbus_conn;
	GDBusConnection* _tmp2_;
	LoggerIface* _tmp3_;
	LoggerIface* _tmp4_;
	LoggerIface* _tmp5_;
	GDBusConnection* _tmp6_;
	guint _tmp7_;
	LoggerIface* _tmp8_;
	GError * _inner_error_;
};

struct _LoggerGetFavouriteContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Logger* self;
	gchar** result;
	gint result_length1;
	LoggerIface* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	LoggerIface* _tmp3_;
	LoggerIface* _tmp4_;
	LoggerIface* logger;
	LoggerIface* _tmp5_;
	gint _tmp6_;
	AccountFavourites* _tmp7_;
	AccountFavourites* favs;
	gint favs_length1;
	gint _favs_size_;
	AccountFavourites* _tmp8_;
	gint _tmp8__length1;
	AccountFavourites* account_collection;
	gint account_collection_length1;
	gint _account_collection_size_;
	gint account_it;
	AccountFavourites _tmp9_;
	AccountFavourites account;
	AccountFavourites _tmp10_;
	const char* _tmp11_;
	const gchar* _tmp12_;
	AccountFavourites _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GError * _inner_error_;
};

struct _LoggerAddFavouriteContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Logger* self;
	gchar* id;
	LoggerIface* _tmp0_;
	LoggerIface* _tmp1_;
	LoggerIface* _tmp2_;
	LoggerIface* logger;
	LoggerIface* _tmp3_;
	const gchar* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	const gchar* _tmp7_;
	GError * _inner_error_;
};

struct _LoggerRemoveFavouriteContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Logger* self;
	gchar* id;
	LoggerIface* _tmp0_;
	LoggerIface* _tmp1_;
	LoggerIface* _tmp2_;
	LoggerIface* logger;
	LoggerIface* _tmp3_;
	const gchar* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	const gchar* _tmp7_;
	GError * _inner_error_;
};


static gpointer logger_parent_class = NULL;
static LoggerIface* logger__logger;
static LoggerIface* logger__logger = NULL;

GType account_favourites_get_type (void) G_GNUC_CONST;
AccountFavourites* account_favourites_dup (const AccountFavourites* self);
void account_favourites_free (AccountFavourites* self);
void account_favourites_copy (const AccountFavourites* self, AccountFavourites* dest);
void account_favourites_destroy (AccountFavourites* self);
static gchar** _vala_array_dup2 (gchar** self, int length);
GType logger_iface_proxy_get_type (void) G_GNUC_CONST;
guint logger_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType logger_iface_get_type (void) G_GNUC_CONST;
void logger_iface_get_favourite_contacts (LoggerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
AccountFavourites* logger_iface_get_favourite_contacts_finish (LoggerIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
void logger_iface_add_favourite_contact (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_iface_add_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error);
void logger_iface_remove_favourite_contact (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_iface_remove_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_INT_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void logger_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_logger_iface_favourite_contacts_changed (LoggerIface* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void logger_iface_proxy_get_favourite_contacts_async (LoggerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static AccountFavourites* logger_iface_proxy_get_favourite_contacts_finish (LoggerIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void logger_iface_proxy_add_favourite_contact_async (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void logger_iface_proxy_add_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error);
static void logger_iface_proxy_remove_favourite_contact_async (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void logger_iface_proxy_remove_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error);
static void logger_iface_proxy_logger_iface_interface_init (LoggerIfaceIface* iface);
static void _dbus_logger_iface_get_favourite_contacts (LoggerIface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _vala_AccountFavourites_array_free (AccountFavourites* array, gint array_length);
static void _dbus_logger_iface_get_favourite_contacts_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_logger_iface_add_favourite_contact (LoggerIface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_logger_iface_add_favourite_contact_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_logger_iface_remove_favourite_contact (LoggerIface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_logger_iface_remove_favourite_contact_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void logger_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* logger_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean logger_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_logger_iface_favourite_contacts_changed (GObject* _sender, const char* account_path, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer* _data);
static void _logger_iface_unregister_object (gpointer user_data);
GType logger_get_type (void) G_GNUC_CONST;
#define LOGGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LOGGER, LoggerPrivate))
enum  {
	LOGGER_DUMMY_PROPERTY,
	LOGGER_ACCOUNT_PATH
};
Logger* logger_new (const gchar* account_path);
Logger* logger_construct (GType object_type, const gchar* account_path);
static void logger_prepare_data_free (gpointer _data);
void logger_prepare (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean logger_prepare_finish (Logger* self, GAsyncResult* _res_, GError** error);
static gboolean logger_prepare_co (LoggerPrepareData* _data_);
static void logger_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _logger_logger_vanished (Logger* self, GDBusConnection* conn, const gchar* name);
static void __logger_logger_vanished_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda2_ (Logger* self, const char* ap, gchar** a, int a_length1, gchar** r, int r_length1);
static void ___lambda2__logger_iface_favourite_contacts_changed (LoggerIface* _sender, const char* account_path, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self);
static void logger_get_favourite_contacts_data_free (gpointer _data);
void logger_get_favourite_contacts (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** logger_get_favourite_contacts_finish (Logger* self, GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean logger_get_favourite_contacts_co (LoggerGetFavouriteContactsData* _data_);
static void logger_get_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void logger_add_favourite_contact_data_free (gpointer _data);
void logger_add_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_add_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static gboolean logger_add_favourite_contact_co (LoggerAddFavouriteContactData* _data_);
static void logger_add_favourite_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void logger_remove_favourite_contact_data_free (gpointer _data);
void logger_remove_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_remove_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static gboolean logger_remove_favourite_contact_co (LoggerRemoveFavouriteContactData* _data_);
static void logger_remove_favourite_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* logger_get_account_path (Logger* self);
static void logger_set_account_path (Logger* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__BOXED_INT_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void logger_finalize (GObject* obj);
static void _vala_logger_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_logger_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _logger_iface_dbus_arg_info_get_favourite_contacts_result = {-1, "result", "a(oas)"};
static const GDBusArgInfo * const _logger_iface_dbus_arg_info_get_favourite_contacts_in[] = {NULL};
static const GDBusArgInfo * const _logger_iface_dbus_arg_info_get_favourite_contacts_out[] = {&_logger_iface_dbus_arg_info_get_favourite_contacts_result, NULL};
static const GDBusMethodInfo _logger_iface_dbus_method_info_get_favourite_contacts = {-1, "GetFavouriteContacts", (GDBusArgInfo **) (&_logger_iface_dbus_arg_info_get_favourite_contacts_in), (GDBusArgInfo **) (&_logger_iface_dbus_arg_info_get_favourite_contacts_out)};
static const GDBusArgInfo _logger_iface_dbus_arg_info_add_favourite_contact_account_path = {-1, "account_path", "o"};
static const GDBusArgInfo _logger_iface_dbus_arg_info_add_favourite_contact_id = {-1, "id", "s"};
static const GDBusArgInfo * const _logger_iface_dbus_arg_info_add_favourite_contact_in[] = {&_logger_iface_dbus_arg_info_add_favourite_contact_account_path, &_logger_iface_dbus_arg_info_add_favourite_contact_id, NULL};
static const GDBusArgInfo * const _logger_iface_dbus_arg_info_add_favourite_contact_out[] = {NULL};
static const GDBusMethodInfo _logger_iface_dbus_method_info_add_favourite_contact = {-1, "AddFavouriteContact", (GDBusArgInfo **) (&_logger_iface_dbus_arg_info_add_favourite_contact_in), (GDBusArgInfo **) (&_logger_iface_dbus_arg_info_add_favourite_contact_out)};
static const GDBusArgInfo _logger_iface_dbus_arg_info_remove_favourite_contact_account_path = {-1, "account_path", "o"};
static const GDBusArgInfo _logger_iface_dbus_arg_info_remove_favourite_contact_id = {-1, "id", "s"};
static const GDBusArgInfo * const _logger_iface_dbus_arg_info_remove_favourite_contact_in[] = {&_logger_iface_dbus_arg_info_remove_favourite_contact_account_path, &_logger_iface_dbus_arg_info_remove_favourite_contact_id, NULL};
static const GDBusArgInfo * const _logger_iface_dbus_arg_info_remove_favourite_contact_out[] = {NULL};
static const GDBusMethodInfo _logger_iface_dbus_method_info_remove_favourite_contact = {-1, "RemoveFavouriteContact", (GDBusArgInfo **) (&_logger_iface_dbus_arg_info_remove_favourite_contact_in), (GDBusArgInfo **) (&_logger_iface_dbus_arg_info_remove_favourite_contact_out)};
static const GDBusMethodInfo * const _logger_iface_dbus_method_info[] = {&_logger_iface_dbus_method_info_get_favourite_contacts, &_logger_iface_dbus_method_info_add_favourite_contact, &_logger_iface_dbus_method_info_remove_favourite_contact, NULL};
static const GDBusArgInfo _logger_iface_dbus_arg_info_favourite_contacts_changed_account_path = {-1, "account_path", "o"};
static const GDBusArgInfo _logger_iface_dbus_arg_info_favourite_contacts_changed_added = {-1, "added", "as"};
static const GDBusArgInfo _logger_iface_dbus_arg_info_favourite_contacts_changed_removed = {-1, "removed", "as"};
static const GDBusArgInfo * const _logger_iface_dbus_arg_info_favourite_contacts_changed[] = {&_logger_iface_dbus_arg_info_favourite_contacts_changed_account_path, &_logger_iface_dbus_arg_info_favourite_contacts_changed_added, &_logger_iface_dbus_arg_info_favourite_contacts_changed_removed, NULL};
static const GDBusSignalInfo _logger_iface_dbus_signal_info_favourite_contacts_changed = {-1, "FavouriteContactsChanged", (GDBusArgInfo **) (&_logger_iface_dbus_arg_info_favourite_contacts_changed)};
static const GDBusSignalInfo * const _logger_iface_dbus_signal_info[] = {&_logger_iface_dbus_signal_info_favourite_contacts_changed, NULL};
static const GDBusPropertyInfo * const _logger_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _logger_iface_dbus_interface_info = {-1, "org.freedesktop.Telepathy.Logger.DRAFT", (GDBusMethodInfo **) (&_logger_iface_dbus_method_info), (GDBusSignalInfo **) (&_logger_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_logger_iface_dbus_property_info)};
static const GDBusInterfaceVTable _logger_iface_dbus_interface_vtable = {logger_iface_dbus_interface_method_call, logger_iface_dbus_interface_get_property, logger_iface_dbus_interface_set_property};

static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void account_favourites_copy (const AccountFavourites* self, AccountFavourites* dest) {
	const char* _tmp0_;
	char* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = (*self).account_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).account_path);
	(*dest).account_path = _tmp1_;
	_tmp2_ = (*self).ids;
	_tmp2__length1 = (*self).ids_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	(*dest).ids = (_vala_array_free ((*dest).ids, (*dest).ids_length1, (GDestroyNotify) g_free), NULL);
	(*dest).ids = _tmp3_;
	(*dest).ids_length1 = _tmp3__length1;
	(*dest)._ids_size_ = (*dest).ids_length1;
}


void account_favourites_destroy (AccountFavourites* self) {
	_g_free0 ((*self).account_path);
	(*self).ids = (_vala_array_free ((*self).ids, (*self).ids_length1, (GDestroyNotify) g_free), NULL);
}


AccountFavourites* account_favourites_dup (const AccountFavourites* self) {
	AccountFavourites* dup;
	dup = g_new0 (AccountFavourites, 1);
	account_favourites_copy (self, dup);
	return dup;
}


void account_favourites_free (AccountFavourites* self) {
	account_favourites_destroy (self);
	g_free (self);
}


GType account_favourites_get_type (void) {
	static volatile gsize account_favourites_type_id__volatile = 0;
	if (g_once_init_enter (&account_favourites_type_id__volatile)) {
		GType account_favourites_type_id;
		account_favourites_type_id = g_boxed_type_register_static ("AccountFavourites", (GBoxedCopyFunc) account_favourites_dup, (GBoxedFreeFunc) account_favourites_free);
		g_once_init_leave (&account_favourites_type_id__volatile, account_favourites_type_id);
	}
	return account_favourites_type_id__volatile;
}


void logger_iface_get_favourite_contacts (LoggerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LOGGER_IFACE_GET_INTERFACE (self)->get_favourite_contacts (self, _callback_, _user_data_);
}


AccountFavourites* logger_iface_get_favourite_contacts_finish (LoggerIface* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return LOGGER_IFACE_GET_INTERFACE (self)->get_favourite_contacts_finish (self, _res_, result_length1, error);
}


void logger_iface_add_favourite_contact (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LOGGER_IFACE_GET_INTERFACE (self)->add_favourite_contact (self, account_path, id, _callback_, _user_data_);
}


void logger_iface_add_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error) {
	LOGGER_IFACE_GET_INTERFACE (self)->add_favourite_contact_finish (self, _res_, error);
}


void logger_iface_remove_favourite_contact (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LOGGER_IFACE_GET_INTERFACE (self)->remove_favourite_contact (self, account_path, id, _callback_, _user_data_);
}


void logger_iface_remove_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error) {
	LOGGER_IFACE_GET_INTERFACE (self)->remove_favourite_contact_finish (self, _res_, error);
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED_INT_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_INT_BOXED_INT) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_INT_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED_INT_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_int (param_values + 3), g_value_get_boxed (param_values + 4), g_value_get_int (param_values + 5), data2);
}


static void logger_iface_base_init (LoggerIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("favourite_contacts_changed", TYPE_LOGGER_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_INT_BOXED_INT, G_TYPE_NONE, 5, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_INT, G_TYPE_STRV, G_TYPE_INT);
	}
}


GType logger_iface_get_type (void) {
	static volatile gsize logger_iface_type_id__volatile = 0;
	if (g_once_init_enter (&logger_iface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LoggerIfaceIface), (GBaseInitFunc) logger_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType logger_iface_type_id;
		logger_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "LoggerIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (logger_iface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (logger_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) logger_iface_proxy_get_type);
		g_type_set_qdata (logger_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Telepathy.Logger.DRAFT");
		g_type_set_qdata (logger_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) logger_iface_register_object);
		g_once_init_leave (&logger_iface_type_id__volatile, logger_iface_type_id);
	}
	return logger_iface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (LoggerIfaceProxy, logger_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_LOGGER_IFACE, logger_iface_proxy_logger_iface_interface_init) )
static void logger_iface_proxy_class_init (LoggerIfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = logger_iface_proxy_g_signal;
}


static void _dbus_handle_logger_iface_favourite_contacts_changed (LoggerIface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	char* account_path = NULL;
	GVariant* _tmp0_;
	gchar** added = NULL;
	int added_length1;
	GVariant* _tmp1_;
	gchar** _tmp2_;
	int _tmp2__length;
	int _tmp2__size;
	int _tmp2__length1;
	GVariantIter _tmp3_;
	GVariant* _tmp4_;
	gchar** removed = NULL;
	int removed_length1;
	GVariant* _tmp5_;
	gchar** _tmp6_;
	int _tmp6__length;
	int _tmp6__size;
	int _tmp6__length1;
	GVariantIter _tmp7_;
	GVariant* _tmp8_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	account_path = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	added_length1 = 0;
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp2_ = g_new (gchar*, 5);
	_tmp2__length = 0;
	_tmp2__size = 4;
	_tmp2__length1 = 0;
	g_variant_iter_init (&_tmp3_, _tmp1_);
	for (; (_tmp4_ = g_variant_iter_next_value (&_tmp3_)) != NULL; _tmp2__length1++) {
		if (_tmp2__size == _tmp2__length) {
			_tmp2__size = 2 * _tmp2__size;
			_tmp2_ = g_renew (gchar*, _tmp2_, _tmp2__size + 1);
		}
		_tmp2_[_tmp2__length++] = g_variant_dup_string (_tmp4_, NULL);
		g_variant_unref (_tmp4_);
	}
	added_length1 = _tmp2__length1;
	_tmp2_[_tmp2__length] = NULL;
	added = _tmp2_;
	g_variant_unref (_tmp1_);
	removed_length1 = 0;
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp6_ = g_new (gchar*, 5);
	_tmp6__length = 0;
	_tmp6__size = 4;
	_tmp6__length1 = 0;
	g_variant_iter_init (&_tmp7_, _tmp5_);
	for (; (_tmp8_ = g_variant_iter_next_value (&_tmp7_)) != NULL; _tmp6__length1++) {
		if (_tmp6__size == _tmp6__length) {
			_tmp6__size = 2 * _tmp6__size;
			_tmp6_ = g_renew (gchar*, _tmp6_, _tmp6__size + 1);
		}
		_tmp6_[_tmp6__length++] = g_variant_dup_string (_tmp8_, NULL);
		g_variant_unref (_tmp8_);
	}
	removed_length1 = _tmp6__length1;
	_tmp6_[_tmp6__length] = NULL;
	removed = _tmp6_;
	g_variant_unref (_tmp5_);
	g_signal_emit_by_name (self, "favourite-contacts-changed", account_path, added, added_length1, removed, removed_length1);
	_g_free0 (account_path);
	added = (_vala_array_free (added, added_length1, (GDestroyNotify) g_free), NULL);
	removed = (_vala_array_free (removed, removed_length1, (GDestroyNotify) g_free), NULL);
}


static void logger_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "FavouriteContactsChanged") == 0) {
		_dbus_handle_logger_iface_favourite_contacts_changed ((LoggerIface*) proxy, parameters);
	}
}


static void logger_iface_proxy_init (LoggerIfaceProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void logger_iface_proxy_get_favourite_contacts_async (LoggerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Telepathy.Logger.DRAFT", "GetFavouriteContacts");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static AccountFavourites* logger_iface_proxy_get_favourite_contacts_finish (LoggerIface* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	AccountFavourites* _result;
	int _result_length1;
	GVariant* _tmp9_;
	AccountFavourites* _tmp10_;
	int _tmp10__length;
	int _tmp10__size;
	int _tmp10__length1;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp9_ = g_variant_iter_next_value (&_reply_iter);
	_tmp10_ = g_new (AccountFavourites, 5);
	_tmp10__length = 0;
	_tmp10__size = 4;
	_tmp10__length1 = 0;
	g_variant_iter_init (&_tmp11_, _tmp9_);
	for (; (_tmp12_ = g_variant_iter_next_value (&_tmp11_)) != NULL; _tmp10__length1++) {
		AccountFavourites _tmp13_;
		GVariantIter _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		gchar** _tmp17_;
		int _tmp17__length;
		int _tmp17__size;
		int _tmp17__length1;
		GVariantIter _tmp18_;
		GVariant* _tmp19_;
		if (_tmp10__size == _tmp10__length) {
			_tmp10__size = 2 * _tmp10__size;
			_tmp10_ = g_renew (AccountFavourites, _tmp10_, _tmp10__size + 1);
		}
		g_variant_iter_init (&_tmp14_, _tmp12_);
		_tmp15_ = g_variant_iter_next_value (&_tmp14_);
		_tmp13_.account_path = g_variant_dup_string (_tmp15_, NULL);
		g_variant_unref (_tmp15_);
		_tmp16_ = g_variant_iter_next_value (&_tmp14_);
		_tmp17_ = g_new (gchar*, 5);
		_tmp17__length = 0;
		_tmp17__size = 4;
		_tmp17__length1 = 0;
		g_variant_iter_init (&_tmp18_, _tmp16_);
		for (; (_tmp19_ = g_variant_iter_next_value (&_tmp18_)) != NULL; _tmp17__length1++) {
			if (_tmp17__size == _tmp17__length) {
				_tmp17__size = 2 * _tmp17__size;
				_tmp17_ = g_renew (gchar*, _tmp17_, _tmp17__size + 1);
			}
			_tmp17_[_tmp17__length++] = g_variant_dup_string (_tmp19_, NULL);
			g_variant_unref (_tmp19_);
		}
		_tmp13_.ids_length1 = _tmp17__length1;
		_tmp17_[_tmp17__length] = NULL;
		_tmp13_.ids = _tmp17_;
		g_variant_unref (_tmp16_);
		_tmp10_[_tmp10__length++] = _tmp13_;
		g_variant_unref (_tmp12_);
	}
	_result_length1 = _tmp10__length1;
	_result = _tmp10_;
	g_variant_unref (_tmp9_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void logger_iface_proxy_add_favourite_contact_async (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Telepathy.Logger.DRAFT", "AddFavouriteContact");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (account_path));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void logger_iface_proxy_add_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void logger_iface_proxy_remove_favourite_contact_async (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Telepathy.Logger.DRAFT", "RemoveFavouriteContact");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (account_path));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void logger_iface_proxy_remove_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void logger_iface_proxy_logger_iface_interface_init (LoggerIfaceIface* iface) {
	iface->get_favourite_contacts = logger_iface_proxy_get_favourite_contacts_async;
	iface->get_favourite_contacts_finish = logger_iface_proxy_get_favourite_contacts_finish;
	iface->add_favourite_contact = logger_iface_proxy_add_favourite_contact_async;
	iface->add_favourite_contact_finish = logger_iface_proxy_add_favourite_contact_finish;
	iface->remove_favourite_contact = logger_iface_proxy_remove_favourite_contact_async;
	iface->remove_favourite_contact_finish = logger_iface_proxy_remove_favourite_contact_finish;
}


static void _dbus_logger_iface_get_favourite_contacts (LoggerIface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	logger_iface_get_favourite_contacts (self, (GAsyncReadyCallback) _dbus_logger_iface_get_favourite_contacts_ready, invocation);
}


static void _vala_AccountFavourites_array_free (AccountFavourites* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			account_favourites_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_logger_iface_get_favourite_contacts_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	AccountFavourites* result;
	int result_length1 = 0;
	AccountFavourites* _tmp20_;
	GVariantBuilder _tmp21_;
	int _tmp22_;
	invocation = _user_data_;
	result = logger_iface_get_favourite_contacts_finish ((LoggerIface*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp20_ = result;
	g_variant_builder_init (&_tmp21_, G_VARIANT_TYPE ("a(oas)"));
	for (_tmp22_ = 0; _tmp22_ < result_length1; _tmp22_++) {
		GVariantBuilder _tmp23_;
		gchar** _tmp24_;
		GVariantBuilder _tmp25_;
		int _tmp26_;
		g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp23_, g_variant_new_object_path ((*_tmp20_).account_path));
		_tmp24_ = (*_tmp20_).ids;
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("as"));
		for (_tmp26_ = 0; _tmp26_ < (*_tmp20_).ids_length1; _tmp26_++) {
			g_variant_builder_add_value (&_tmp25_, g_variant_new_string (*_tmp24_));
			_tmp24_++;
		}
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		g_variant_builder_add_value (&_tmp21_, g_variant_builder_end (&_tmp23_));
		_tmp20_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp21_));
	result = (_vala_AccountFavourites_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_logger_iface_add_favourite_contact (LoggerIface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	char* account_path = NULL;
	GVariant* _tmp27_;
	gchar* id = NULL;
	GVariant* _tmp28_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp27_ = g_variant_iter_next_value (&_arguments_iter);
	account_path = g_variant_dup_string (_tmp27_, NULL);
	g_variant_unref (_tmp27_);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp28_, NULL);
	g_variant_unref (_tmp28_);
	logger_iface_add_favourite_contact (self, account_path, id, (GAsyncReadyCallback) _dbus_logger_iface_add_favourite_contact_ready, invocation);
	_g_free0 (account_path);
	_g_free0 (id);
}


static void _dbus_logger_iface_add_favourite_contact_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	logger_iface_add_favourite_contact_finish ((LoggerIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_logger_iface_remove_favourite_contact (LoggerIface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	char* account_path = NULL;
	GVariant* _tmp29_;
	gchar* id = NULL;
	GVariant* _tmp30_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	account_path = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp30_, NULL);
	g_variant_unref (_tmp30_);
	logger_iface_remove_favourite_contact (self, account_path, id, (GAsyncReadyCallback) _dbus_logger_iface_remove_favourite_contact_ready, invocation);
	_g_free0 (account_path);
	_g_free0 (id);
}


static void _dbus_logger_iface_remove_favourite_contact_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	logger_iface_remove_favourite_contact_finish ((LoggerIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void logger_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetFavouriteContacts") == 0) {
		_dbus_logger_iface_get_favourite_contacts (object, parameters, invocation);
	} else if (strcmp (method_name, "AddFavouriteContact") == 0) {
		_dbus_logger_iface_add_favourite_contact (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveFavouriteContact") == 0) {
		_dbus_logger_iface_remove_favourite_contact (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* logger_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean logger_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_logger_iface_favourite_contacts_changed (GObject* _sender, const char* account_path, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp31_;
	GVariantBuilder _tmp32_;
	int _tmp33_;
	gchar** _tmp34_;
	GVariantBuilder _tmp35_;
	int _tmp36_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (account_path));
	_tmp31_ = added;
	g_variant_builder_init (&_tmp32_, G_VARIANT_TYPE ("as"));
	for (_tmp33_ = 0; _tmp33_ < added_length1; _tmp33_++) {
		g_variant_builder_add_value (&_tmp32_, g_variant_new_string (*_tmp31_));
		_tmp31_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp32_));
	_tmp34_ = removed;
	g_variant_builder_init (&_tmp35_, G_VARIANT_TYPE ("as"));
	for (_tmp36_ = 0; _tmp36_ < removed_length1; _tmp36_++) {
		g_variant_builder_add_value (&_tmp35_, g_variant_new_string (*_tmp34_));
		_tmp34_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp35_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Telepathy.Logger.DRAFT", "FavouriteContactsChanged", _arguments, NULL);
}


guint logger_iface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_logger_iface_dbus_interface_info), &_logger_iface_dbus_interface_vtable, data, _logger_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "favourite-contacts-changed", (GCallback) _dbus_logger_iface_favourite_contacts_changed, data);
	return result;
}


static void _logger_iface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_logger_iface_favourite_contacts_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


Logger* logger_construct (GType object_type, const gchar* account_path) {
	Logger * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (account_path != NULL, NULL);
	_tmp0_ = account_path;
	self = (Logger*) g_object_new (object_type, "account-path", _tmp0_, NULL);
	return self;
}


Logger* logger_new (const gchar* account_path) {
	return logger_construct (TYPE_LOGGER, account_path);
}


static void logger_prepare_data_free (gpointer _data) {
	LoggerPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (LoggerPrepareData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void logger_prepare (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LoggerPrepareData* _data_;
	Logger* _tmp0_;
	_data_ = g_slice_new0 (LoggerPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, logger_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, logger_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	logger_prepare_co (_data_);
}


gboolean logger_prepare_finish (Logger* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	LoggerPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void logger_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LoggerPrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	logger_prepare_co (_data_);
}


static void __logger_logger_vanished_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	_logger_logger_vanished (self, connection, name);
}


static void __lambda2_ (Logger* self, const char* ap, gchar** a, int a_length1, gchar** r, int r_length1) {
	const char* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (ap != NULL);
	_tmp0_ = ap;
	_tmp1_ = self->priv->_account_path;
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
		return;
	}
	_tmp2_ = a;
	_tmp2__length1 = a_length1;
	_tmp3_ = r;
	_tmp3__length1 = r_length1;
	g_signal_emit_by_name (self, "favourite-contacts-changed", _tmp2_, _tmp2__length1, _tmp3_, _tmp3__length1);
}


static void ___lambda2__logger_iface_favourite_contacts_changed (LoggerIface* _sender, const char* account_path, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self) {
	__lambda2_ (self, account_path, added, added_length1, removed, removed_length1);
}


static gboolean logger_prepare_co (LoggerPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->retval = FALSE;
	_data_->_tmp0_ = logger__logger;
	if (_data_->_tmp0_ == NULL) {
		_data_->_state_ = 1;
		g_bus_get (G_BUS_TYPE_SESSION, NULL, logger_prepare_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->dbus_conn = _data_->_tmp1_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp2_ = _data_->dbus_conn;
		_data_->_state_ = 2;
		g_async_initable_new_async (TYPE_LOGGER_IFACE_PROXY, 0, NULL, logger_prepare_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.Telepathy.Logger", "g-connection", _data_->_tmp2_, "g-object-path", "/org/freedesktop/Telepathy/Logger", "g-interface-name", "org.freedesktop.Telepathy.Logger.DRAFT", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp4_ = (LoggerIface*) _data_->_tmp3_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->dbus_conn);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (logger__logger);
		logger__logger = _data_->_tmp4_;
		_data_->_tmp5_ = logger__logger;
		if (_data_->_tmp5_ == NULL) {
			g_signal_emit_by_name (_data_->self, "invalidated");
			_data_->result = _data_->retval;
			_g_object_unref0 (_data_->dbus_conn);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp6_ = _data_->dbus_conn;
		_data_->_tmp7_ = 0U;
		_data_->_tmp7_ = g_bus_watch_name_on_connection_with_closures (_data_->_tmp6_, "org.freedesktop.Telepathy.Logger", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((__logger_logger_vanished_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __logger_logger_vanished_gbus_name_vanished_callback, g_object_ref (_data_->self), g_object_unref)));
		_data_->self->priv->_logger_watch_id = _data_->_tmp7_;
		_data_->retval = TRUE;
		_g_object_unref0 (_data_->dbus_conn);
	}
	_data_->_tmp8_ = logger__logger;
	g_signal_connect_object (_data_->_tmp8_, "favourite-contacts-changed", (GCallback) ___lambda2__logger_iface_favourite_contacts_changed, _data_->self, 0);
	_data_->result = _data_->retval;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _logger_logger_vanished (Logger* self, GDBusConnection* conn, const gchar* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	_g_object_unref0 (logger__logger);
	logger__logger = NULL;
	g_signal_emit_by_name (self, "invalidated");
}


static void logger_get_favourite_contacts_data_free (gpointer _data) {
	LoggerGetFavouriteContactsData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (LoggerGetFavouriteContactsData, _data_);
}


void logger_get_favourite_contacts (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LoggerGetFavouriteContactsData* _data_;
	Logger* _tmp0_;
	_data_ = g_slice_new0 (LoggerGetFavouriteContactsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, logger_get_favourite_contacts);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, logger_get_favourite_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	logger_get_favourite_contacts_co (_data_);
}


gchar** logger_get_favourite_contacts_finish (Logger* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	gchar** result;
	LoggerGetFavouriteContactsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void logger_get_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LoggerGetFavouriteContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	logger_get_favourite_contacts_co (_data_);
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean logger_get_favourite_contacts_co (LoggerGetFavouriteContactsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = logger__logger;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_new0 (gchar*, 0 + 1);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp2__length1 = 0;
		_data_->result_length1 = _data_->_tmp2__length1;
		_data_->result = _data_->_tmp2_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = logger__logger;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->logger = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->logger;
	_data_->_tmp6_ = 0;
	_data_->_state_ = 1;
	logger_iface_get_favourite_contacts (_data_->_tmp5_, logger_get_favourite_contacts_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = logger_iface_get_favourite_contacts_finish (_data_->_tmp5_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
	_data_->favs = _data_->_tmp7_;
	_data_->favs_length1 = _data_->_tmp6_;
	_data_->_favs_size_ = _data_->favs_length1;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->logger);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->favs;
	_data_->_tmp8__length1 = _data_->favs_length1;
	{
		_data_->account_collection_length1 = 0;
		_data_->_account_collection_size_ = 0;
		_data_->account_collection = _data_->_tmp8_;
		_data_->account_collection_length1 = _data_->_tmp8__length1;
		for (_data_->account_it = 0; _data_->account_it < _data_->_tmp8__length1; _data_->account_it = _data_->account_it + 1) {
			memset (&_data_->_tmp9_, 0, sizeof (AccountFavourites));
			account_favourites_copy (&_data_->account_collection[_data_->account_it], &_data_->_tmp9_);
			_data_->account = _data_->_tmp9_;
			{
				_data_->_tmp10_ = _data_->account;
				_data_->_tmp11_ = _data_->_tmp10_.account_path;
				_data_->_tmp12_ = _data_->self->priv->_account_path;
				if (g_strcmp0 (_data_->_tmp11_, _data_->_tmp12_) == 0) {
					_data_->_tmp13_ = _data_->account;
					_data_->_tmp14_ = _data_->_tmp13_.ids;
					_data_->_tmp14__length1 = _data_->_tmp13_.ids_length1;
					_data_->_tmp15_ = (_data_->_tmp14_ != NULL) ? _vala_array_dup3 (_data_->_tmp14_, _data_->_tmp14__length1) : ((gpointer) _data_->_tmp14_);
					_data_->_tmp15__length1 = _data_->_tmp14__length1;
					_data_->_tmp16_ = _data_->_tmp15_;
					_data_->_tmp16__length1 = _data_->_tmp15__length1;
					_data_->result_length1 = _data_->_tmp16__length1;
					_data_->result = _data_->_tmp16_;
					account_favourites_destroy (&_data_->account);
					_data_->favs = (_vala_AccountFavourites_array_free (_data_->favs, _data_->favs_length1), NULL);
					_g_object_unref0 (_data_->logger);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				account_favourites_destroy (&_data_->account);
			}
		}
	}
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = g_new0 (gchar*, 0 + 1);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp18__length1 = 0;
	_data_->result_length1 = _data_->_tmp18__length1;
	_data_->result = _data_->_tmp18_;
	_data_->favs = (_vala_AccountFavourites_array_free (_data_->favs, _data_->favs_length1), NULL);
	_g_object_unref0 (_data_->logger);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->favs = (_vala_AccountFavourites_array_free (_data_->favs, _data_->favs_length1), NULL);
	_g_object_unref0 (_data_->logger);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void logger_add_favourite_contact_data_free (gpointer _data) {
	LoggerAddFavouriteContactData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (LoggerAddFavouriteContactData, _data_);
}


void logger_add_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LoggerAddFavouriteContactData* _data_;
	Logger* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (LoggerAddFavouriteContactData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, logger_add_favourite_contact);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, logger_add_favourite_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->id = _tmp2_;
	logger_add_favourite_contact_co (_data_);
}


void logger_add_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error) {
	LoggerAddFavouriteContactData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void logger_add_favourite_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LoggerAddFavouriteContactData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	logger_add_favourite_contact_co (_data_);
}


static gboolean logger_add_favourite_contact_co (LoggerAddFavouriteContactData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = logger__logger;
	if (_data_->_tmp0_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = logger__logger;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->logger = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->logger;
	_data_->_tmp4_ = _data_->self->priv->_account_path;
	_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->id;
	_data_->_state_ = 1;
	logger_iface_add_favourite_contact (_data_->_tmp3_, _data_->_tmp6_, _data_->_tmp7_, logger_add_favourite_contact_ready, _data_);
	return FALSE;
	_state_1:
	logger_iface_add_favourite_contact_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
	_g_free0 (_data_->_tmp6_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->logger);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->logger);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void logger_remove_favourite_contact_data_free (gpointer _data) {
	LoggerRemoveFavouriteContactData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (LoggerRemoveFavouriteContactData, _data_);
}


void logger_remove_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LoggerRemoveFavouriteContactData* _data_;
	Logger* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (LoggerRemoveFavouriteContactData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, logger_remove_favourite_contact);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, logger_remove_favourite_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->id = _tmp2_;
	logger_remove_favourite_contact_co (_data_);
}


void logger_remove_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error) {
	LoggerRemoveFavouriteContactData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void logger_remove_favourite_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LoggerRemoveFavouriteContactData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	logger_remove_favourite_contact_co (_data_);
}


static gboolean logger_remove_favourite_contact_co (LoggerRemoveFavouriteContactData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = logger__logger;
	if (_data_->_tmp0_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = logger__logger;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->logger = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->logger;
	_data_->_tmp4_ = _data_->self->priv->_account_path;
	_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->id;
	_data_->_state_ = 1;
	logger_iface_remove_favourite_contact (_data_->_tmp3_, _data_->_tmp6_, _data_->_tmp7_, logger_remove_favourite_contact_ready, _data_);
	return FALSE;
	_state_1:
	logger_iface_remove_favourite_contact_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
	_g_free0 (_data_->_tmp6_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->logger);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->logger);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


const gchar* logger_get_account_path (Logger* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_account_path;
	result = _tmp0_;
	return result;
}


static void logger_set_account_path (Logger* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_account_path);
	self->priv->_account_path = _tmp1_;
	g_object_notify ((GObject *) self, "account-path");
}


static void g_cclosure_user_marshal_VOID__BOXED_INT_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_INT_BOXED_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), g_value_get_boxed (param_values + 3), g_value_get_int (param_values + 4), data2);
}


static void logger_class_init (LoggerClass * klass) {
	logger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LoggerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_logger_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_logger_set_property;
	G_OBJECT_CLASS (klass)->finalize = logger_finalize;
	/**
	   * D-Bus object path of the {@link TelepathyGLib.Account} to watch for
	   * favourite contacts.
	   *
	   * @since 0.6.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), LOGGER_ACCOUNT_PATH, g_param_spec_string ("account-path", "account-path", "account-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("invalidated", TYPE_LOGGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("favourite_contacts_changed", TYPE_LOGGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT_BOXED_INT, G_TYPE_NONE, 4, G_TYPE_STRV, G_TYPE_INT, G_TYPE_STRV, G_TYPE_INT);
}


static void logger_instance_init (Logger * self) {
	self->priv = LOGGER_GET_PRIVATE (self);
}


static void logger_finalize (GObject* obj) {
	Logger * self;
	guint _tmp0_;
	self = LOGGER (obj);
	_tmp0_ = self->priv->_logger_watch_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->_logger_watch_id;
		g_bus_unwatch_name (_tmp1_);
	}
	_g_free0 (self->priv->_account_path);
	G_OBJECT_CLASS (logger_parent_class)->finalize (obj);
}


GType logger_get_type (void) {
	static volatile gsize logger_type_id__volatile = 0;
	if (g_once_init_enter (&logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Logger), 0, (GInstanceInitFunc) logger_instance_init, NULL };
		GType logger_type_id;
		logger_type_id = g_type_register_static (G_TYPE_OBJECT, "Logger", &g_define_type_info, 0);
		g_once_init_leave (&logger_type_id__volatile, logger_type_id);
	}
	return logger_type_id__volatile;
}


static void _vala_logger_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Logger * self;
	self = LOGGER (object);
	switch (property_id) {
		case LOGGER_ACCOUNT_PATH:
		g_value_set_string (value, logger_get_account_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_logger_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Logger * self;
	self = LOGGER (object);
	switch (property_id) {
		case LOGGER_ACCOUNT_PATH:
		logger_set_account_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



