/*****************************************************************************
 *
 * frame - Touch Frame Library
 *
 * Copyright (C) 2011-2012 Canonical Ltd.
 *
 * This library is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef FRAME_TOUCH_H_
#define FRAME_TOUCH_H_

#include <stdint.h>

#include <map>
#include <memory>

#include "oif/frame.h"
#include "property.h"
#include "typedefs.h"

struct UFTouch_ {
  virtual ~UFTouch_() {}
};

namespace oif {
namespace frame {

class UFTouch : public UFTouch_, public Property<UFTouchProperty> {
 public:
  UFTouch(UFTouchState state, UFTouchId id, float x, float y,
           uint64_t time);
  UFTouch(const UFTouch& touch, UFTouchState new_state);

  UFTouchId id() const { return id_; }
  UFTouchState state() const { return state_; }

  void SetValue(UFAxisType type, float value);
  UFStatus GetValue(UFAxisType type, float* value) const;

  UFTouch(const UFTouch&) = delete;
  UFTouch& operator=(const UFTouch&) = delete;

 private:
  const UFTouchId id_;
  const UFTouchState state_;
  std::map<UFAxisType, float> values_;
};

} // namespace frame
} // namespace oif

#endif // FRAME_TOUCH_H_
