#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <regex.h>

#include "string.h"
#include "protocol.h"
#include "network.h"
#include "log.h"
#include "version.h"

enum { ANON, PLAIN };
enum { CLIENT, SERVER };

char *User="test", *Password="test", auth_type = ANON, exchange = CLIENT;

/*
   query       = header payload
   header      = content-length: separator size CR LF
   separator   = space or tab
   space       = " "
   tab         = "\t"
   size        = 0..2147483647
   payload     = *OCTET

   response    = header return-code payload
   return-code = number separator msg CR LF
   number      = digit digit digit
   digit       = 0..9
   msg         = *ALPHANUM
*/

int BuildFrame(tPayload *Payload)
{
  if(exchange == CLIENT) {
     if(auth_type == ANON) {
       printf("AUTHENTICATE ANONYMOUS\r\n");
     } else {
       printf("AUTHENTICATE PLAIN\r\n");
       printf("%c%s%c%s\r\n", '\0', User, '\0', Password);
     }
  } else {
     printf("CAPABILITIES BLABLA\r\n");
     printf("OK \r\n");
  }

  printf("Content-length: %ld\r\n", Payload->size);
  printf(Payload->payload);

  return 0;
}

void PrintUsage(char *Message, ...) {
   if(Message) {
      va_list     argp;
      va_start(argp, Message);
      vprintf(Message, argp);
      va_end(argp);
   }

   printf("usage: tsp-build-proto [-atsch?] [-u userid] [-p password]\n");
   printf("  where options are :\n");
   printf("    -a    anonymous. \n");
   printf("    -t    plain text. \n");
   printf("    -c    client exchange. \n");
   printf("    -s    server exchange. \n");
   printf("    -u x  userid. \n");
   printf("    -p x  password. \n");
   printf("    -h    help. \n");
   printf("    -?    help. \n");
   printf("\n");
   exit(1);
}

void ParseArguments(int argc, char *argv[]) {
    int ch;

   while ((ch = getopt(argc, argv, "atu:p:sch?")) != -1) {
      switch (ch) {
      case 'a':
         auth_type = ANON;
         break;
      case 't':
         auth_type = PLAIN;
         break;
      case 's':
         exchange = SERVER;
         break;
      case 'c':
         exchange = CLIENT;
         break;
      case 'u':
         User = optarg;
         break;
      case 'p':
         Password = optarg;
         break;
      case '?':
      case 'h':
         PrintUsage(NULL);
      default:
         PrintUsage("Invalid option");
      }
   }
}

int main(int argc, char *argv[])
{
   tPayload Payload;
   char Buffer[4000];

   memset(&Payload, 0, sizeof(Payload));
   ParseArguments(argc, argv);
   while(fgets(Buffer, sizeof Buffer, stdin))
      Payload.payload = tspAddPayloadString(&Payload, Buffer);
   BuildFrame(&Payload);
}

