@echo off
Rem #$Id: windows2003.bat,v 1.1.2.4 2003/09/16 17:14:53 jpicard Exp $
Rem
Rem  Copyright (c) 2001-2003 Hexago Inc. All rights reserved.
Rem 
Rem **************************************
Rem * Tunnel Server Protocol version 1.0 *
Rem * Host configuration script          *
Rem * Windows XP is supported            *
Rem **************************************
Rem * This script keeps a log

set LOG=NUL
set LOG2=NUL
if     %TSP_VERBOSE% == 2 set LOG2=CON
if not %TSP_VERBOSE% == 0 set LOG=CON

date /T > %LOG%
time /T > %LOG%

Rem ***** Script an IPv6 tunnel "on-line" **********

:begin
echo Testing IPv6 presence
ping -6 -n 1 ::1
if errorlevel 1 goto fail0
echo IPv4 tunnel server address configured : %TSP_SERVER_ADDRESS_IPV4% > %LOG%
netsh.exe interface ipv6 add route prefix=::/0 interface=2 nexthop=::%TSP_SERVER_ADDRESS_IPV4% publish=yes > %LOG2%
if errorlevel 1 goto fail1

:second
echo IPv6 host address configured : %TSP_CLIENT_ADDRESS_IPV6% > %LOG%
netsh.exe interface ipv6 add address interface=2 address=%TSP_CLIENT_ADDRESS_IPV6% > %LOG2%
if errorlevel 1 goto fail2
if %TSP_HOST_TYPE% == router GOTO router_config
goto success

:router_config
echo This computer will be configured as IPv6 router and it will do router advertisements for autoconfiguration > %LOG%
echo Configuring IPv6_forwading on every internal interfaces > %LOG%
netsh.exe interface ipv6 set interface interface=2 forwarding=enabled > %LOG2%
netsh.exe interface ipv6 set interface interface=3 forwarding=enabled > %LOG2%
netsh.exe interface ipv6 set interface interface=4 forwarding=enabled > %LOG2%
netsh.exe interface ipv6 set interface interface=5 forwarding=enabled > %LOG2%
netsh.exe interface ipv6 set interface interface=6 forwarding=enabled > %LOG2%
netsh.exe interface ipv6 set interface interface=7 forwarding=enabled > %LOG2%
netsh.exe interface ipv6 set interface interface=8 forwarding=enabled > %LOG2%

echo Configuring routing advertisement on the specified interface > %LOG%
netsh.exe interface ipv6 set interface=%TSP_HOME_INTERFACE% advertise=enabled > %LOG2% 

echo You got the IPv6 prefix : %TSP_PREFIX%::/%TSP_PREFIXLEN% > %LOG%
echo Your network interface %TSP_HOME_INTERFACE% will advertise %TSP_PREFIX%:0001::/64 > %LOG%
netsh.exe interface ipv6 add route prefix=%TSP_PREFIX%:0001::/64 interface=%TSP_HOME_INTERFACE% siteprefixlength=64 publish=yes validlifetime=86400 > %LOG2%
if errorlevel 1 goto fail4
goto success

:fail0
echo Failed : IPv6 not installed. Use the command "netsh interface ipv6 install" to enable it. 
goto end

:fail1
Echo Failed : not possible to use IPv4 tunnel server address > %LOG%
goto end

:fail2
Echo Failed : not possible to use IPv6 host address > %LOG%
goto end

:fail4
Echo Failed : not possible to advertise the prefix %TSP_PREFIX%:0001::/64 on interface %TSP_HOME_INTERFACE% > %LOG%
goto end

:success
Echo Success ! Now, you're ready to use IPv6 connectivity to Internet IPv6
Echo Your host is configured to use this IPv6 address : %TSP_CLIENT_ADDRESS_IPV6%
if %TSP_HOST_TYPE% == router GOTO success2
goto end

:success2
Echo The tunnel server uses this IPv6 address : %TSP_SERVER_ADDRESS_IPV6%
Echo The prefix advertised is %TSP_PREFIX%:0001::/64 on interface %TSP_HOME_INTERFACE%
goto end


:end

Echo End of the script

