#! /usr/bin/env python
#
# FIXME: strip "TryExec" from the extracted menu files (and noDisplay)
#
import os, tarfile, sys, xdg.Menu

ARCH = "i386"
errorFile = None

def getTarballs(debName):
	"""
	Extract the tarballs from the deb and return the name of the temp files where they are stored.
	"""
	
	dataPath = os.tempnam()
	command = ("/usr/bin/ar", "p", debName, "data.tar.gz")
	dataOut, dataError = os.popen3(command)[1:]
	dataFile = open(dataPath, "w")
	dataFile.write(dataOut.read())
	dataFile.close()
	dataOut.close()
	error = dataError.read()
	if error != "":
		dataPath = None
		errorFile.write("ERROR: Bad archive encountered:" + debName + "\n")
		errorFile.write(error + "\n")
	
	controlPath = os.tempnam()
	command = ("/usr/bin/ar", "p", debName, "control.tar.gz")
	controlOut, controlError = os.popen3(command)[1:]
	controlFile = open(controlPath, "w")
	controlFile.write(controlOut.read())
	controlFile.close()
	controlOut.close()
	error = controlError.read()
	if error != "":
		controlPath = None
		if dataPath is not None:
			errorFile.write("ERROR: Bad archive encountered:" + debName + "\n")
			errorFile.write(error + "\n")
	
	return (dataPath, controlPath)

def getFiles(dataPath, controlPath, section, outputdir):
	try:
		os.makedirs(outputdir)
		os.makedirs(os.path.join(outputdir, "icons"))
	except:
		pass
	
	try:
		controlFile = tarfile.open(controlPath)
		control = controlFile.extractfile("control")
		controlText = control.read()
		control.close()
		controlFile.close()
	except:
		errorFile.write("ERROR: Couldn't open control tarball.\n")
		return
	lines = controlText.split("\n")
	for line in lines:
		if line.startswith("Package:"):
			package = line.split()[-1]
	if package is None:
		errorFile.write("ERROR: No package name found.\n")
	
	try:
		dataFile = tarfile.open(dataPath)
	except:
		errorFile.write("ERROR: Couldn't open tarball. Package: " + package + "\n")
		return
		
	desktopPaths = []
	iconPaths = []
	try:
		for filename in dataFile.getnames():
			if  filename.endswith(".desktop"):
				desktopPaths.append(filename)
			if "usr/share/pixmaps" in filename:
				iconPaths.append(filename)
	except:
		errorFile.write("ERROR: Choked on tarball. Package: " + package + "\n")
		return # too many bad debs. take this line out if you fix that
			
	for path in [x for x in desktopPaths if "usr/share/applications" in x]:
		file = dataFile.extractfile(path)
		desktop = os.path.join(outputdir, os.path.split(path)[-1])
		outfile = open(desktop, "w")
		outfile.write(file.read())
		outfile.close()
		file.close()
		menuEntry = xdg.Menu.MenuEntry(desktop)
		menuEntry.DesktopEntry.set("X-AppInstall-Package", package)
		menuEntry.DesktopEntry.set("X-AppInstall-Section", section)
		menuEntry.save()
		
		iconName = menuEntry.DesktopEntry.getIcon()
		if iconName.strip() is not None:
			if os.path.split(iconName)[0] != '':
				menuEntry.DesktopEntry.set("Icon", iconName.replace("/", "_"))
				menuEntry.save()
				try:
					if iconName.startswith('/'):
						extractName = iconName[1:]
					else:
						extractName = "usr/share/pixmaps/" + iconName
					iconFile = dataFile.extractfile(extractName)
					outicon = open(os.path.join(outputdir, "icons", iconName.replace("/", "_")), "w")
					outicon.write(iconFile.read())
					outicon.close()
					iconFile.close()
				except:
					errorFile.write("ERROR: Icon \"" + iconName + "\" for " + package + " could not be obtained.\n")
			for iconPath in [ipath for ipath in iconPaths if iconName in ipath or not "usr/share/pixmaps" in ipath]:
				try:
					iconFile = dataFile.extractfile(iconPath)
					outicon = open(os.path.join(outputdir, "icons", os.path.split(iconPath)[-1]), "w")
					outicon.write(iconFile.read())
					outicon.close()
					iconFile.close()
				except:
					errorFile.write("ERROR: Icon for " + package + " could not be obtained.\n")

def processDeb(debPath, section, outputdir=os.path.join(os.getcwd(), "menu-data")):
	data, control = getTarballs(debPath)
	if data is None or control is None:
		return
	getFiles(data, control, section, outputdir)
	os.remove(data)
	os.remove(control)

def scavenge(pooldir):
	sections = ("main", "restricted", "universe", "multiverse")
	for section in sections:
		sectdir = os.path.join(pooldir, section)
		print sectdir
		partialpaths = [os.path.join(sectdir, x) for x in os.listdir(sectdir)]
		for subdir in [dir for dir in partialpaths if os.path.isdir(dir)]:
			fullpaths = [os.path.join(subdir, x) for x in os.listdir(subdir)]
			for subsubdir in [dir for dir in fullpaths if os.path.isdir(dir)]:
				packages = {}
				for deb in [filename for filename in os.listdir(subsubdir) if filename.lower().endswith(ARCH + ".deb") or filename.lower().endswith("all.deb")]:
					print deb				
					name = deb.split("_")[0]
					if not packages.has_key(name) or deb > packages[name]:
						packages[name] = os.path.join(subsubdir, deb)
				for name in packages.keys():
					processDeb(packages[name], section)

if __name__ == "__main__":
	try:
		pooldir = sys.argv[1]
	except:
		print "Usage: getMenuData.py pooldir"
		sys.exit()
	global errorFile
	errorFile = open("error.log", "w")
	scavenge(pooldir)
	#processDeb("abiword-common_2.2.7-3ubuntu4_all.deb", "main")
