#!/usr/bin/env python

from distutils.core import setup
import glob
import os
import os.path
import re

# look/set what version we have
changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)
        f=open("AppInstall/Version.py","w")
        f.write("VERSION=\"%s\"\n" % version)
        f.close()

GETTEXT_NAME="gnome-app-install"

HELPFILES = []
print "Setting up help files..."
for filepath in glob.glob("help/*"):
    lang = filepath[len("help/"):]
    print " Language: %s" % lang
    path_xml = "share/gnome/help/gnome-app-install/" + lang
    path_figures = "share/gnome/help/gnome-app-install/" + lang + "/figures/"
    HELPFILES.append((path_xml, (glob.glob("%s/*.xml" % filepath))))
    HELPFILES.append((path_figures, (glob.glob("%s/figures/*.png" % \
                                     filepath))))
HELPFILES.append(('share/omf/gnome-app-install', glob.glob("help/*/*.omf")))


I18NFILES = []
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    I18NFILES.append((targetpath, [filepath]))

os.system("intltool-merge -d po data/gnome-app-install.schemas.in"\
          " build/gnome-app-install.schemas")

# HACK: make sure that the mo files are generated and up-to-date
os.system("cd po; make update-po")
os.system("cd data; make")
    
setup(name='gnome-app-install',
      version=version,
      packages=['AppInstall'],
      scripts=['gnome-app-install'],
      data_files=[('share/gnome-app-install/',
                   ["data/gnome-app-install.glade",
		    "data/featured.txt",
                    "data/template.html"]
                  ),
                  ('share/gconf/schemas',
                   glob.glob("build/*.schemas")
                  ),
                  ('share/gnome-app-install/channels',
                   glob.glob("channels/*.list")
                  ),
                  ('share/applications',
                   ["data/gnome-app-install.desktop"]
                  ),
                  ('share/gnome-app-install/desktop',
                   glob.glob("menu-data/*.desktop")+
                   glob.glob("menu-data-additional/*.desktop")+
                   glob.glob("menu-data/*.menu")+
                   # FIXME: maybe move this into the channels dir?
                   glob.glob("channels/*.desktop")
                  ),
                  ('share/gnome-app-install/icons',
                   glob.glob("menu-data/icons/*")+
                   glob.glob("menu-data-additional/icons/*")
                  )
                   ]
                  +HELPFILES + I18NFILES,
      )


