from AppInstall.Menu import SHOW_ALL, SHOW_ONLY_SUPPORTED, SHOW_ONLY_FREE, SHOW_ONLY_MAIN, SHOW_ONLY_PROPRIETARY, SHOW_ONLY_THIRD_PARTY, SHOW_ONLY_INSTALLED

from gettext import gettext as _
import subprocess

class Distribution(object):
    def __init__(self):
        # Dictonary of all available filters with corresponding choser name
        # and tooltip
        # The installed filter will be automatically added in non-installer mode
        # The primary and secondary filters are separated
        self.filters_primary = {
            SHOW_ALL : (_("All available applications"),
                        _("Show all applications including ones which are "
                          "unsupported and possibly restricted by law or "
                          "copyright"))
            }
        self.filters_secondary = {}
        # List of components whose applications should not be installed
        # before asking for a confirmation
        self.components_ask = []
        # Dictonary that provides dialog messages that are shown,
        # before a component gets activated or when it requires to be confirmed
        self.components_activation = {
            None : [_("Enable the installation of software from the %s "
                      "component of Ubuntu?"),
                    _("%s is not officially supported with security "
                      "updates.")],
              }
        self.dependencies_map = []
        self.comp_depend_map = {}

    def get_components_ask(self):
        """
        Returns a list of components whose applications should not be installed
        before asking for a confirmation
        """
        return self.components_ask

    def get_components_ask_msgs(self):
        """
        Returns a dictonary that provides dialog messages that are shown,
        before a component gets activated or when it requires to be confirmed
        """ 
        return self.components_activation

    def get_codename(self):
        """
        Return the distribution codename of the current running distro
        as returned by lsb_release
        """
        return subprocess.Popen(["lsb_release","-c","-s"],stdout=subprocess.PIPE).communicate()[0].strip()

    def get_comp_dependencies(self, comp):
        if self.comp_depend_map.has_key(comp):
            return self.comp_depend_map[comp]
        else:
            return None

if __name__ == "__main__":
    d = Distribution()
    print "code: '%s'" % d.get_codename()
