/* equation-parser.c generated by valac 0.29.1, the Vala compiler
 * generated from equation-parser.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 * Copyright (C) 2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Operator Associativity. */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ASSOCIATIVITY (associativity_get_type ())

#define TYPE_PRECEDENCE (precedence_get_type ())

#define TYPE_PARSE_NODE (parse_node_get_type ())
#define PARSE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSE_NODE, ParseNode))
#define PARSE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSE_NODE, ParseNodeClass))
#define IS_PARSE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSE_NODE))
#define IS_PARSE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSE_NODE))
#define PARSE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSE_NODE, ParseNodeClass))

typedef struct _ParseNode ParseNode;
typedef struct _ParseNodeClass ParseNodeClass;
typedef struct _ParseNodePrivate ParseNodePrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;

#define TYPE_LEXER_TOKEN (lexer_token_get_type ())
#define LEXER_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXER_TOKEN, LexerToken))
#define LEXER_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXER_TOKEN, LexerTokenClass))
#define IS_LEXER_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXER_TOKEN))
#define IS_LEXER_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXER_TOKEN))
#define LEXER_TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXER_TOKEN, LexerTokenClass))

typedef struct _LexerToken LexerToken;
typedef struct _LexerTokenClass LexerTokenClass;
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RNODE (rnode_get_type ())
#define RNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RNODE, RNode))
#define RNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RNODE, RNodeClass))
#define IS_RNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RNODE))
#define IS_RNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RNODE))
#define RNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RNODE, RNodeClass))

typedef struct _RNode RNode;
typedef struct _RNodeClass RNodeClass;
typedef struct _RNodePrivate RNodePrivate;

#define TYPE_ERROR_CODE (error_code_get_type ())
typedef struct _LexerTokenPrivate LexerTokenPrivate;

#define TYPE_LEXER_TOKEN_TYPE (lexer_token_type_get_type ())

#define TYPE_LR_NODE (lr_node_get_type ())
#define LR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LR_NODE, LRNode))
#define LR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LR_NODE, LRNodeClass))
#define IS_LR_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LR_NODE))
#define IS_LR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LR_NODE))
#define LR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LR_NODE, LRNodeClass))

typedef struct _LRNode LRNode;
typedef struct _LRNodeClass LRNodeClass;
typedef struct _LRNodePrivate LRNodePrivate;

#define TYPE_CONSTANT_NODE (constant_node_get_type ())
#define CONSTANT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSTANT_NODE, ConstantNode))
#define CONSTANT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSTANT_NODE, ConstantNodeClass))
#define IS_CONSTANT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSTANT_NODE))
#define IS_CONSTANT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSTANT_NODE))
#define CONSTANT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSTANT_NODE, ConstantNodeClass))

typedef struct _ConstantNode ConstantNode;
typedef struct _ConstantNodeClass ConstantNodeClass;
typedef struct _ConstantNodePrivate ConstantNodePrivate;
typedef struct _ParserPrivate ParserPrivate;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_ASSIGN_NODE (assign_node_get_type ())
#define ASSIGN_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSIGN_NODE, AssignNode))
#define ASSIGN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSIGN_NODE, AssignNodeClass))
#define IS_ASSIGN_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSIGN_NODE))
#define IS_ASSIGN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSIGN_NODE))
#define ASSIGN_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSIGN_NODE, AssignNodeClass))

typedef struct _AssignNode AssignNode;
typedef struct _AssignNodeClass AssignNodeClass;
typedef struct _AssignNodePrivate AssignNodePrivate;

#define TYPE_ASSIGN_FUNCTION_NODE (assign_function_node_get_type ())
#define ASSIGN_FUNCTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSIGN_FUNCTION_NODE, AssignFunctionNode))
#define ASSIGN_FUNCTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSIGN_FUNCTION_NODE, AssignFunctionNodeClass))
#define IS_ASSIGN_FUNCTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSIGN_FUNCTION_NODE))
#define IS_ASSIGN_FUNCTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSIGN_FUNCTION_NODE))
#define ASSIGN_FUNCTION_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSIGN_FUNCTION_NODE, AssignFunctionNodeClass))

typedef struct _AssignFunctionNode AssignFunctionNode;
typedef struct _AssignFunctionNodeClass AssignFunctionNodeClass;
typedef struct _AssignFunctionNodePrivate AssignFunctionNodePrivate;

#define TYPE_FUNCTION_MANAGER (function_manager_get_type ())
#define FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_MANAGER, FunctionManager))
#define FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_MANAGER, FunctionManagerClass))
#define IS_FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_MANAGER))
#define IS_FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_MANAGER))
#define FUNCTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_MANAGER, FunctionManagerClass))

typedef struct _FunctionManager FunctionManager;
typedef struct _FunctionManagerClass FunctionManagerClass;

#define TYPE_NAME_NODE (name_node_get_type ())
#define NAME_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NAME_NODE, NameNode))
#define NAME_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NAME_NODE, NameNodeClass))
#define IS_NAME_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NAME_NODE))
#define IS_NAME_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NAME_NODE))
#define NAME_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NAME_NODE, NameNodeClass))

typedef struct _NameNode NameNode;
typedef struct _NameNodeClass NameNodeClass;
typedef struct _NameNodePrivate NameNodePrivate;

#define TYPE_VARIABLE_NODE (variable_node_get_type ())
#define VARIABLE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_NODE, VariableNode))
#define VARIABLE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_NODE, VariableNodeClass))
#define IS_VARIABLE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_NODE))
#define IS_VARIABLE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_NODE))
#define VARIABLE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_NODE, VariableNodeClass))

typedef struct _VariableNode VariableNode;
typedef struct _VariableNodeClass VariableNodeClass;
typedef struct _VariableNodePrivate VariableNodePrivate;

#define TYPE_VARIABLE_WITH_POWER_NODE (variable_with_power_node_get_type ())
#define VARIABLE_WITH_POWER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_WITH_POWER_NODE, VariableWithPowerNode))
#define VARIABLE_WITH_POWER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_WITH_POWER_NODE, VariableWithPowerNodeClass))
#define IS_VARIABLE_WITH_POWER_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_WITH_POWER_NODE))
#define IS_VARIABLE_WITH_POWER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_WITH_POWER_NODE))
#define VARIABLE_WITH_POWER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_WITH_POWER_NODE, VariableWithPowerNodeClass))

typedef struct _VariableWithPowerNode VariableWithPowerNode;
typedef struct _VariableWithPowerNodeClass VariableWithPowerNodeClass;
typedef struct _VariableWithPowerNodePrivate VariableWithPowerNodePrivate;

#define TYPE_FUNCTION_NAME_NODE (function_name_node_get_type ())
#define FUNCTION_NAME_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_NAME_NODE, FunctionNameNode))
#define FUNCTION_NAME_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_NAME_NODE, FunctionNameNodeClass))
#define IS_FUNCTION_NAME_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_NAME_NODE))
#define IS_FUNCTION_NAME_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_NAME_NODE))
#define FUNCTION_NAME_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_NAME_NODE, FunctionNameNodeClass))

typedef struct _FunctionNameNode FunctionNameNode;
typedef struct _FunctionNameNodeClass FunctionNameNodeClass;
typedef struct _FunctionNameNodePrivate FunctionNameNodePrivate;

#define TYPE_FUNCTION_ARGUMENTS_NODE (function_arguments_node_get_type ())
#define FUNCTION_ARGUMENTS_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_ARGUMENTS_NODE, FunctionArgumentsNode))
#define FUNCTION_ARGUMENTS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_ARGUMENTS_NODE, FunctionArgumentsNodeClass))
#define IS_FUNCTION_ARGUMENTS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_ARGUMENTS_NODE))
#define IS_FUNCTION_ARGUMENTS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_ARGUMENTS_NODE))
#define FUNCTION_ARGUMENTS_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_ARGUMENTS_NODE, FunctionArgumentsNodeClass))

typedef struct _FunctionArgumentsNode FunctionArgumentsNode;
typedef struct _FunctionArgumentsNodeClass FunctionArgumentsNodeClass;
typedef struct _FunctionArgumentsNodePrivate FunctionArgumentsNodePrivate;

#define TYPE_FUNCTION_DESCRIPTION_NODE (function_description_node_get_type ())
#define FUNCTION_DESCRIPTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_DESCRIPTION_NODE, FunctionDescriptionNode))
#define FUNCTION_DESCRIPTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_DESCRIPTION_NODE, FunctionDescriptionNodeClass))
#define IS_FUNCTION_DESCRIPTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_DESCRIPTION_NODE))
#define IS_FUNCTION_DESCRIPTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_DESCRIPTION_NODE))
#define FUNCTION_DESCRIPTION_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_DESCRIPTION_NODE, FunctionDescriptionNodeClass))

typedef struct _FunctionDescriptionNode FunctionDescriptionNode;
typedef struct _FunctionDescriptionNodeClass FunctionDescriptionNodeClass;
typedef struct _FunctionDescriptionNodePrivate FunctionDescriptionNodePrivate;

#define TYPE_FUNCTION_NODE (function_node_get_type ())
#define FUNCTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_NODE, FunctionNode))
#define FUNCTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_NODE, FunctionNodeClass))
#define IS_FUNCTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_NODE))
#define IS_FUNCTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_NODE))
#define FUNCTION_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_NODE, FunctionNodeClass))

typedef struct _FunctionNode FunctionNode;
typedef struct _FunctionNodeClass FunctionNodeClass;
typedef struct _FunctionNodePrivate FunctionNodePrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_EXPRESSION_PARSER (expression_parser_get_type ())
#define EXPRESSION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPRESSION_PARSER, ExpressionParser))
#define EXPRESSION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPRESSION_PARSER, ExpressionParserClass))
#define IS_EXPRESSION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPRESSION_PARSER))
#define IS_EXPRESSION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPRESSION_PARSER))
#define EXPRESSION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPRESSION_PARSER, ExpressionParserClass))

typedef struct _ExpressionParser ExpressionParser;
typedef struct _ExpressionParserClass ExpressionParserClass;

#define TYPE_UNARY_MINUS_NODE (unary_minus_node_get_type ())
#define UNARY_MINUS_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNARY_MINUS_NODE, UnaryMinusNode))
#define UNARY_MINUS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNARY_MINUS_NODE, UnaryMinusNodeClass))
#define IS_UNARY_MINUS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNARY_MINUS_NODE))
#define IS_UNARY_MINUS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNARY_MINUS_NODE))
#define UNARY_MINUS_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNARY_MINUS_NODE, UnaryMinusNodeClass))

typedef struct _UnaryMinusNode UnaryMinusNode;
typedef struct _UnaryMinusNodeClass UnaryMinusNodeClass;
typedef struct _UnaryMinusNodePrivate UnaryMinusNodePrivate;

#define TYPE_ABSOLUTE_VALUE_NODE (absolute_value_node_get_type ())
#define ABSOLUTE_VALUE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSOLUTE_VALUE_NODE, AbsoluteValueNode))
#define ABSOLUTE_VALUE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSOLUTE_VALUE_NODE, AbsoluteValueNodeClass))
#define IS_ABSOLUTE_VALUE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSOLUTE_VALUE_NODE))
#define IS_ABSOLUTE_VALUE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSOLUTE_VALUE_NODE))
#define ABSOLUTE_VALUE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSOLUTE_VALUE_NODE, AbsoluteValueNodeClass))

typedef struct _AbsoluteValueNode AbsoluteValueNode;
typedef struct _AbsoluteValueNodeClass AbsoluteValueNodeClass;
typedef struct _AbsoluteValueNodePrivate AbsoluteValueNodePrivate;

#define TYPE_FLOOR_NODE (floor_node_get_type ())
#define FLOOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLOOR_NODE, FloorNode))
#define FLOOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FLOOR_NODE, FloorNodeClass))
#define IS_FLOOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLOOR_NODE))
#define IS_FLOOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FLOOR_NODE))
#define FLOOR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FLOOR_NODE, FloorNodeClass))

typedef struct _FloorNode FloorNode;
typedef struct _FloorNodeClass FloorNodeClass;
typedef struct _FloorNodePrivate FloorNodePrivate;

#define TYPE_CEILING_NODE (ceiling_node_get_type ())
#define CEILING_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CEILING_NODE, CeilingNode))
#define CEILING_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CEILING_NODE, CeilingNodeClass))
#define IS_CEILING_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CEILING_NODE))
#define IS_CEILING_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CEILING_NODE))
#define CEILING_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CEILING_NODE, CeilingNodeClass))

typedef struct _CeilingNode CeilingNode;
typedef struct _CeilingNodeClass CeilingNodeClass;
typedef struct _CeilingNodePrivate CeilingNodePrivate;

#define TYPE_FRACTIONAL_COMPONENT_NODE (fractional_component_node_get_type ())
#define FRACTIONAL_COMPONENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FRACTIONAL_COMPONENT_NODE, FractionalComponentNode))
#define FRACTIONAL_COMPONENT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FRACTIONAL_COMPONENT_NODE, FractionalComponentNodeClass))
#define IS_FRACTIONAL_COMPONENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FRACTIONAL_COMPONENT_NODE))
#define IS_FRACTIONAL_COMPONENT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FRACTIONAL_COMPONENT_NODE))
#define FRACTIONAL_COMPONENT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FRACTIONAL_COMPONENT_NODE, FractionalComponentNodeClass))

typedef struct _FractionalComponentNode FractionalComponentNode;
typedef struct _FractionalComponentNodeClass FractionalComponentNodeClass;
typedef struct _FractionalComponentNodePrivate FractionalComponentNodePrivate;

#define TYPE_ROUND_NODE (round_node_get_type ())
#define ROUND_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUND_NODE, RoundNode))
#define ROUND_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUND_NODE, RoundNodeClass))
#define IS_ROUND_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUND_NODE))
#define IS_ROUND_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUND_NODE))
#define ROUND_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUND_NODE, RoundNodeClass))

typedef struct _RoundNode RoundNode;
typedef struct _RoundNodeClass RoundNodeClass;
typedef struct _RoundNodePrivate RoundNodePrivate;

#define TYPE_PERCENT_NODE (percent_node_get_type ())
#define PERCENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PERCENT_NODE, PercentNode))
#define PERCENT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PERCENT_NODE, PercentNodeClass))
#define IS_PERCENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PERCENT_NODE))
#define IS_PERCENT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PERCENT_NODE))
#define PERCENT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PERCENT_NODE, PercentNodeClass))

typedef struct _PercentNode PercentNode;
typedef struct _PercentNodeClass PercentNodeClass;
typedef struct _PercentNodePrivate PercentNodePrivate;

#define TYPE_FACTORIAL_NODE (factorial_node_get_type ())
#define FACTORIAL_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACTORIAL_NODE, FactorialNode))
#define FACTORIAL_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACTORIAL_NODE, FactorialNodeClass))
#define IS_FACTORIAL_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACTORIAL_NODE))
#define IS_FACTORIAL_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACTORIAL_NODE))
#define FACTORIAL_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACTORIAL_NODE, FactorialNodeClass))

typedef struct _FactorialNode FactorialNode;
typedef struct _FactorialNodeClass FactorialNodeClass;
typedef struct _FactorialNodePrivate FactorialNodePrivate;

#define TYPE_ADD_NODE (add_node_get_type ())
#define ADD_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_NODE, AddNode))
#define ADD_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_NODE, AddNodeClass))
#define IS_ADD_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_NODE))
#define IS_ADD_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_NODE))
#define ADD_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_NODE, AddNodeClass))

typedef struct _AddNode AddNode;
typedef struct _AddNodeClass AddNodeClass;
typedef struct _AddNodePrivate AddNodePrivate;

#define TYPE_SUBTRACT_NODE (subtract_node_get_type ())
#define SUBTRACT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBTRACT_NODE, SubtractNode))
#define SUBTRACT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBTRACT_NODE, SubtractNodeClass))
#define IS_SUBTRACT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBTRACT_NODE))
#define IS_SUBTRACT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBTRACT_NODE))
#define SUBTRACT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBTRACT_NODE, SubtractNodeClass))

typedef struct _SubtractNode SubtractNode;
typedef struct _SubtractNodeClass SubtractNodeClass;
typedef struct _SubtractNodePrivate SubtractNodePrivate;

#define TYPE_MULTIPLY_NODE (multiply_node_get_type ())
#define MULTIPLY_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTIPLY_NODE, MultiplyNode))
#define MULTIPLY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTIPLY_NODE, MultiplyNodeClass))
#define IS_MULTIPLY_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTIPLY_NODE))
#define IS_MULTIPLY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTIPLY_NODE))
#define MULTIPLY_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTIPLY_NODE, MultiplyNodeClass))

typedef struct _MultiplyNode MultiplyNode;
typedef struct _MultiplyNodeClass MultiplyNodeClass;
typedef struct _MultiplyNodePrivate MultiplyNodePrivate;

#define TYPE_DIVIDE_NODE (divide_node_get_type ())
#define DIVIDE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIVIDE_NODE, DivideNode))
#define DIVIDE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIVIDE_NODE, DivideNodeClass))
#define IS_DIVIDE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIVIDE_NODE))
#define IS_DIVIDE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIVIDE_NODE))
#define DIVIDE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIVIDE_NODE, DivideNodeClass))

typedef struct _DivideNode DivideNode;
typedef struct _DivideNodeClass DivideNodeClass;
typedef struct _DivideNodePrivate DivideNodePrivate;

#define TYPE_MODULUS_DIVIDE_NODE (modulus_divide_node_get_type ())
#define MODULUS_DIVIDE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODULUS_DIVIDE_NODE, ModulusDivideNode))
#define MODULUS_DIVIDE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODULUS_DIVIDE_NODE, ModulusDivideNodeClass))
#define IS_MODULUS_DIVIDE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODULUS_DIVIDE_NODE))
#define IS_MODULUS_DIVIDE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODULUS_DIVIDE_NODE))
#define MODULUS_DIVIDE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODULUS_DIVIDE_NODE, ModulusDivideNodeClass))

typedef struct _ModulusDivideNode ModulusDivideNode;
typedef struct _ModulusDivideNodeClass ModulusDivideNodeClass;
typedef struct _ModulusDivideNodePrivate ModulusDivideNodePrivate;

#define TYPE_XPOW_YNODE (xpow_ynode_get_type ())
#define XPOW_YNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XPOW_YNODE, XPowYNode))
#define XPOW_YNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XPOW_YNODE, XPowYNodeClass))
#define IS_XPOW_YNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XPOW_YNODE))
#define IS_XPOW_YNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XPOW_YNODE))
#define XPOW_YNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XPOW_YNODE, XPowYNodeClass))

typedef struct _XPowYNode XPowYNode;
typedef struct _XPowYNodeClass XPowYNodeClass;

#define TYPE_ROOT_NODE (root_node_get_type ())
#define ROOT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROOT_NODE, RootNode))
#define ROOT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROOT_NODE, RootNodeClass))
#define IS_ROOT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROOT_NODE))
#define IS_ROOT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROOT_NODE))
#define ROOT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROOT_NODE, RootNodeClass))

typedef struct _RootNode RootNode;
typedef struct _RootNodeClass RootNodeClass;
typedef struct _RootNodePrivate RootNodePrivate;
typedef struct _XPowYNodePrivate XPowYNodePrivate;

#define TYPE_XPOW_YINTEGER_NODE (xpow_yinteger_node_get_type ())
#define XPOW_YINTEGER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XPOW_YINTEGER_NODE, XPowYIntegerNode))
#define XPOW_YINTEGER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XPOW_YINTEGER_NODE, XPowYIntegerNodeClass))
#define IS_XPOW_YINTEGER_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XPOW_YINTEGER_NODE))
#define IS_XPOW_YINTEGER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XPOW_YINTEGER_NODE))
#define XPOW_YINTEGER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XPOW_YINTEGER_NODE, XPowYIntegerNodeClass))

typedef struct _XPowYIntegerNode XPowYIntegerNode;
typedef struct _XPowYIntegerNodeClass XPowYIntegerNodeClass;
typedef struct _XPowYIntegerNodePrivate XPowYIntegerNodePrivate;

#define TYPE_NOT_NODE (not_node_get_type ())
#define NOT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOT_NODE, NotNode))
#define NOT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOT_NODE, NotNodeClass))
#define IS_NOT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOT_NODE))
#define IS_NOT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOT_NODE))
#define NOT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOT_NODE, NotNodeClass))

typedef struct _NotNode NotNode;
typedef struct _NotNodeClass NotNodeClass;
typedef struct _NotNodePrivate NotNodePrivate;

#define TYPE_AND_NODE (and_node_get_type ())
#define AND_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AND_NODE, AndNode))
#define AND_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AND_NODE, AndNodeClass))
#define IS_AND_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AND_NODE))
#define IS_AND_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AND_NODE))
#define AND_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AND_NODE, AndNodeClass))

typedef struct _AndNode AndNode;
typedef struct _AndNodeClass AndNodeClass;
typedef struct _AndNodePrivate AndNodePrivate;

#define TYPE_OR_NODE (or_node_get_type ())
#define OR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OR_NODE, OrNode))
#define OR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OR_NODE, OrNodeClass))
#define IS_OR_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OR_NODE))
#define IS_OR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OR_NODE))
#define OR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OR_NODE, OrNodeClass))

typedef struct _OrNode OrNode;
typedef struct _OrNodeClass OrNodeClass;
typedef struct _OrNodePrivate OrNodePrivate;

#define TYPE_XOR_NODE (xor_node_get_type ())
#define XOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XOR_NODE, XorNode))
#define XOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XOR_NODE, XorNodeClass))
#define IS_XOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XOR_NODE))
#define IS_XOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XOR_NODE))
#define XOR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XOR_NODE, XorNodeClass))

typedef struct _XorNode XorNode;
typedef struct _XorNodeClass XorNodeClass;
typedef struct _XorNodePrivate XorNodePrivate;

#define TYPE_CONVERT_NODE (convert_node_get_type ())
#define CONVERT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONVERT_NODE, ConvertNode))
#define CONVERT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONVERT_NODE, ConvertNodeClass))
#define IS_CONVERT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONVERT_NODE))
#define IS_CONVERT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONVERT_NODE))
#define CONVERT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONVERT_NODE, ConvertNodeClass))

typedef struct _ConvertNode ConvertNode;
typedef struct _ConvertNodeClass ConvertNodeClass;
typedef struct _ConvertNodePrivate ConvertNodePrivate;

#define TYPE_CONVERT_BASE_NODE (convert_base_node_get_type ())
#define CONVERT_BASE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONVERT_BASE_NODE, ConvertBaseNode))
#define CONVERT_BASE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONVERT_BASE_NODE, ConvertBaseNodeClass))
#define IS_CONVERT_BASE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONVERT_BASE_NODE))
#define IS_CONVERT_BASE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONVERT_BASE_NODE))
#define CONVERT_BASE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONVERT_BASE_NODE, ConvertBaseNodeClass))

typedef struct _ConvertBaseNode ConvertBaseNode;
typedef struct _ConvertBaseNodeClass ConvertBaseNodeClass;
typedef struct _ConvertBaseNodePrivate ConvertBaseNodePrivate;

#define TYPE_CONVERT_NUMBER_NODE (convert_number_node_get_type ())
#define CONVERT_NUMBER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONVERT_NUMBER_NODE, ConvertNumberNode))
#define CONVERT_NUMBER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONVERT_NUMBER_NODE, ConvertNumberNodeClass))
#define IS_CONVERT_NUMBER_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONVERT_NUMBER_NODE))
#define IS_CONVERT_NUMBER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONVERT_NUMBER_NODE))
#define CONVERT_NUMBER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONVERT_NUMBER_NODE, ConvertNumberNodeClass))

typedef struct _ConvertNumberNode ConvertNumberNode;
typedef struct _ConvertNumberNodeClass ConvertNumberNodeClass;
typedef struct _ConvertNumberNodePrivate ConvertNumberNodePrivate;

#define TYPE_LEXER (lexer_get_type ())
#define LEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXER, Lexer))
#define LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXER, LexerClass))
#define IS_LEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXER))
#define IS_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXER))
#define LEXER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXER, LexerClass))

typedef struct _Lexer Lexer;
typedef struct _LexerClass LexerClass;
typedef struct _ParamSpecParser ParamSpecParser;

typedef enum  {
	ASSOCIATIVITY_LEFT,
	ASSOCIATIVITY_RIGHT
} Associativity;

typedef enum  {
	PRECEDENCE_UNKNOWN = 0,
	PRECEDENCE_ADD_SUBTRACT = 1,
	PRECEDENCE_MULTIPLY = 2,
	PRECEDENCE_MOD = 3,
	PRECEDENCE_DIVIDE = 3,
	PRECEDENCE_NOT = 4,
	PRECEDENCE_ROOT = 5,
	PRECEDENCE_FUNCTION = 6,
	PRECEDENCE_BOOLEAN = 7,
	PRECEDENCE_PERCENTAGE = 8,
	PRECEDENCE_UNARY_MINUS = 9,
	PRECEDENCE_POWER = 9,
	PRECEDENCE_FACTORIAL = 10,
	PRECEDENCE_NUMBER_VARIABLE = 11,
	PRECEDENCE_DEPTH
} Precedence;

struct _ParseNode {
	GObject parent_instance;
	ParseNodePrivate * priv;
	Parser* parser;
	ParseNode* parent;
	ParseNode* left;
	ParseNode* right;
	LexerToken* token;
	guint precedence;
	Associativity associativity;
	gchar* value;
};

struct _ParseNodeClass {
	GObjectClass parent_class;
	Number* (*solve) (ParseNode* self);
};

struct _RNode {
	ParseNode parent_instance;
	RNodePrivate * priv;
};

struct _RNodeClass {
	ParseNodeClass parent_class;
	Number* (*solve_r) (RNode* self, Number* r);
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

typedef enum  {
	LEXER_TOKEN_TYPE_UNKNOWN,
	LEXER_TOKEN_TYPE_PL_DECIMAL,
	LEXER_TOKEN_TYPE_PL_DIGIT,
	LEXER_TOKEN_TYPE_PL_HEX,
	LEXER_TOKEN_TYPE_PL_SUPER_DIGIT,
	LEXER_TOKEN_TYPE_PL_SUPER_MINUS,
	LEXER_TOKEN_TYPE_PL_SUB_DIGIT,
	LEXER_TOKEN_TYPE_PL_FRACTION,
	LEXER_TOKEN_TYPE_PL_DEGREE,
	LEXER_TOKEN_TYPE_PL_MINUTE,
	LEXER_TOKEN_TYPE_PL_SECOND,
	LEXER_TOKEN_TYPE_PL_LETTER,
	LEXER_TOKEN_TYPE_PL_EOS,
	LEXER_TOKEN_TYPE_PL_SKIP,
	LEXER_TOKEN_TYPE_ADD,
	LEXER_TOKEN_TYPE_SUBTRACT,
	LEXER_TOKEN_TYPE_MULTIPLY,
	LEXER_TOKEN_TYPE_DIVIDE,
	LEXER_TOKEN_TYPE_MOD,
	LEXER_TOKEN_TYPE_L_FLOOR,
	LEXER_TOKEN_TYPE_R_FLOOR,
	LEXER_TOKEN_TYPE_L_CEILING,
	LEXER_TOKEN_TYPE_R_CEILING,
	LEXER_TOKEN_TYPE_ROOT,
	LEXER_TOKEN_TYPE_ROOT_3,
	LEXER_TOKEN_TYPE_ROOT_4,
	LEXER_TOKEN_TYPE_NOT,
	LEXER_TOKEN_TYPE_AND,
	LEXER_TOKEN_TYPE_OR,
	LEXER_TOKEN_TYPE_XOR,
	LEXER_TOKEN_TYPE_IN,
	LEXER_TOKEN_TYPE_NUMBER,
	LEXER_TOKEN_TYPE_SUP_NUMBER,
	LEXER_TOKEN_TYPE_NSUP_NUMBER,
	LEXER_TOKEN_TYPE_SUB_NUMBER,
	LEXER_TOKEN_TYPE_FUNCTION,
	LEXER_TOKEN_TYPE_VARIABLE,
	LEXER_TOKEN_TYPE_ASSIGN,
	LEXER_TOKEN_TYPE_L_R_BRACKET,
	LEXER_TOKEN_TYPE_R_R_BRACKET,
	LEXER_TOKEN_TYPE_L_S_BRACKET,
	LEXER_TOKEN_TYPE_R_S_BRACKET,
	LEXER_TOKEN_TYPE_L_C_BRACKET,
	LEXER_TOKEN_TYPE_R_C_BRACKET,
	LEXER_TOKEN_TYPE_ABS,
	LEXER_TOKEN_TYPE_POWER,
	LEXER_TOKEN_TYPE_FACTORIAL,
	LEXER_TOKEN_TYPE_PERCENTAGE,
	LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR
} LexerTokenType;

struct _LexerToken {
	GObject parent_instance;
	LexerTokenPrivate * priv;
	gchar* text;
	guint start_index;
	guint end_index;
	LexerTokenType type;
};

struct _LexerTokenClass {
	GObjectClass parent_class;
};

struct _LRNode {
	ParseNode parent_instance;
	LRNodePrivate * priv;
};

struct _LRNodeClass {
	ParseNodeClass parent_class;
	Number* (*solve_lr) (LRNode* self, Number* left, Number* r);
};

struct _ConstantNode {
	ParseNode parent_instance;
	ConstantNodePrivate * priv;
};

struct _ConstantNodeClass {
	ParseNodeClass parent_class;
};

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Parser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ParserPrivate * priv;
	gint number_base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _ParserClass {
	GTypeClass parent_class;
	void (*finalize) (Parser *self);
	gboolean (*variable_is_defined) (Parser* self, const gchar* name);
	Number* (*get_variable) (Parser* self, const gchar* name);
	void (*set_variable) (Parser* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Parser* self, const gchar* name);
	Number* (*convert) (Parser* self, Number* x, const gchar* x_units, const gchar* z_units);
};

struct _AssignNode {
	RNode parent_instance;
	AssignNodePrivate * priv;
};

struct _AssignNodeClass {
	RNodeClass parent_class;
};

struct _AssignFunctionNode {
	ParseNode parent_instance;
	AssignFunctionNodePrivate * priv;
};

struct _AssignFunctionNodeClass {
	ParseNodeClass parent_class;
};

struct _NameNode {
	ParseNode parent_instance;
	NameNodePrivate * priv;
};

struct _NameNodeClass {
	ParseNodeClass parent_class;
};

struct _VariableNode {
	ParseNode parent_instance;
	VariableNodePrivate * priv;
};

struct _VariableNodeClass {
	ParseNodeClass parent_class;
};

struct _VariableWithPowerNode {
	ParseNode parent_instance;
	VariableWithPowerNodePrivate * priv;
};

struct _VariableWithPowerNodeClass {
	ParseNodeClass parent_class;
};

struct _FunctionNameNode {
	NameNode parent_instance;
	FunctionNameNodePrivate * priv;
};

struct _FunctionNameNodeClass {
	NameNodeClass parent_class;
};

struct _FunctionArgumentsNode {
	NameNode parent_instance;
	FunctionArgumentsNodePrivate * priv;
};

struct _FunctionArgumentsNodeClass {
	NameNodeClass parent_class;
};

struct _FunctionDescriptionNode {
	NameNode parent_instance;
	FunctionDescriptionNodePrivate * priv;
};

struct _FunctionDescriptionNodeClass {
	NameNodeClass parent_class;
};

struct _FunctionNode {
	ParseNode parent_instance;
	FunctionNodePrivate * priv;
};

struct _FunctionNodeClass {
	ParseNodeClass parent_class;
};

struct _UnaryMinusNode {
	RNode parent_instance;
	UnaryMinusNodePrivate * priv;
};

struct _UnaryMinusNodeClass {
	RNodeClass parent_class;
};

struct _AbsoluteValueNode {
	RNode parent_instance;
	AbsoluteValueNodePrivate * priv;
};

struct _AbsoluteValueNodeClass {
	RNodeClass parent_class;
};

struct _FloorNode {
	RNode parent_instance;
	FloorNodePrivate * priv;
};

struct _FloorNodeClass {
	RNodeClass parent_class;
};

struct _CeilingNode {
	RNode parent_instance;
	CeilingNodePrivate * priv;
};

struct _CeilingNodeClass {
	RNodeClass parent_class;
};

struct _FractionalComponentNode {
	RNode parent_instance;
	FractionalComponentNodePrivate * priv;
};

struct _FractionalComponentNodeClass {
	RNodeClass parent_class;
};

struct _RoundNode {
	RNode parent_instance;
	RoundNodePrivate * priv;
};

struct _RoundNodeClass {
	RNodeClass parent_class;
};

struct _PercentNode {
	RNode parent_instance;
	PercentNodePrivate * priv;
};

struct _PercentNodeClass {
	RNodeClass parent_class;
};

struct _FactorialNode {
	RNode parent_instance;
	FactorialNodePrivate * priv;
};

struct _FactorialNodeClass {
	RNodeClass parent_class;
};

struct _AddNode {
	LRNode parent_instance;
	AddNodePrivate * priv;
	gboolean do_percentage;
};

struct _AddNodeClass {
	LRNodeClass parent_class;
};

struct _SubtractNode {
	LRNode parent_instance;
	SubtractNodePrivate * priv;
	gboolean do_percentage;
};

struct _SubtractNodeClass {
	LRNodeClass parent_class;
};

struct _MultiplyNode {
	LRNode parent_instance;
	MultiplyNodePrivate * priv;
};

struct _MultiplyNodeClass {
	LRNodeClass parent_class;
};

struct _DivideNode {
	LRNode parent_instance;
	DivideNodePrivate * priv;
};

struct _DivideNodeClass {
	LRNodeClass parent_class;
};

struct _ModulusDivideNode {
	LRNode parent_instance;
	ModulusDivideNodePrivate * priv;
};

struct _ModulusDivideNodeClass {
	LRNodeClass parent_class;
};

struct _RootNode {
	RNode parent_instance;
	RootNodePrivate * priv;
};

struct _RootNodeClass {
	RNodeClass parent_class;
};

struct _RootNodePrivate {
	gint n;
};

struct _XPowYNode {
	LRNode parent_instance;
	XPowYNodePrivate * priv;
};

struct _XPowYNodeClass {
	LRNodeClass parent_class;
};

struct _XPowYIntegerNode {
	ParseNode parent_instance;
	XPowYIntegerNodePrivate * priv;
};

struct _XPowYIntegerNodeClass {
	ParseNodeClass parent_class;
};

struct _NotNode {
	RNode parent_instance;
	NotNodePrivate * priv;
};

struct _NotNodeClass {
	RNodeClass parent_class;
};

struct _AndNode {
	LRNode parent_instance;
	AndNodePrivate * priv;
};

struct _AndNodeClass {
	LRNodeClass parent_class;
};

struct _OrNode {
	LRNode parent_instance;
	OrNodePrivate * priv;
};

struct _OrNodeClass {
	LRNodeClass parent_class;
};

struct _XorNode {
	LRNode parent_instance;
	XorNodePrivate * priv;
};

struct _XorNodeClass {
	LRNodeClass parent_class;
};

struct _ConvertNode {
	LRNode parent_instance;
	ConvertNodePrivate * priv;
};

struct _ConvertNodeClass {
	LRNodeClass parent_class;
};

struct _ConvertBaseNode {
	ParseNode parent_instance;
	ConvertBaseNodePrivate * priv;
};

struct _ConvertBaseNodeClass {
	ParseNodeClass parent_class;
};

struct _ConvertNumberNode {
	ParseNode parent_instance;
	ConvertNumberNodePrivate * priv;
};

struct _ConvertNumberNodeClass {
	ParseNodeClass parent_class;
};

struct _ParserPrivate {
	gchar* input;
	ParseNode* root;
	ParseNode* right_most;
	Lexer* lexer;
	guint depth_level;
	ErrorCode error;
	gchar* error_token;
	gint error_token_start;
	gint error_token_end;
	guint representation_base;
};

struct _ParamSpecParser {
	GParamSpec parent_instance;
};


static gpointer parse_node_parent_class = NULL;
static gpointer rnode_parent_class = NULL;
static gpointer lr_node_parent_class = NULL;
static gpointer constant_node_parent_class = NULL;
static gpointer assign_node_parent_class = NULL;
static gpointer assign_function_node_parent_class = NULL;
static gpointer name_node_parent_class = NULL;
static gpointer variable_node_parent_class = NULL;
static gpointer variable_with_power_node_parent_class = NULL;
static gpointer function_name_node_parent_class = NULL;
static gpointer function_arguments_node_parent_class = NULL;
static gpointer function_description_node_parent_class = NULL;
static gpointer function_node_parent_class = NULL;
static gpointer unary_minus_node_parent_class = NULL;
static gpointer absolute_value_node_parent_class = NULL;
static gpointer floor_node_parent_class = NULL;
static gpointer ceiling_node_parent_class = NULL;
static gpointer fractional_component_node_parent_class = NULL;
static gpointer round_node_parent_class = NULL;
static gpointer percent_node_parent_class = NULL;
static gpointer factorial_node_parent_class = NULL;
static gpointer add_node_parent_class = NULL;
static gpointer subtract_node_parent_class = NULL;
static gpointer multiply_node_parent_class = NULL;
static gpointer divide_node_parent_class = NULL;
static gpointer modulus_divide_node_parent_class = NULL;
static gpointer root_node_parent_class = NULL;
static gpointer xpow_ynode_parent_class = NULL;
static gpointer xpow_yinteger_node_parent_class = NULL;
static gpointer not_node_parent_class = NULL;
static gpointer and_node_parent_class = NULL;
static gpointer or_node_parent_class = NULL;
static gpointer xor_node_parent_class = NULL;
static gpointer convert_node_parent_class = NULL;
static gpointer convert_base_node_parent_class = NULL;
static gpointer convert_number_node_parent_class = NULL;
static gpointer parser_parent_class = NULL;

GType associativity_get_type (void) G_GNUC_CONST;
GType precedence_get_type (void) G_GNUC_CONST;
GType parse_node_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_parser (GValue* value, gpointer v_object);
void value_take_parser (GValue* value, gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
GType lexer_token_get_type (void) G_GNUC_CONST;
enum  {
	PARSE_NODE_DUMMY_PROPERTY
};
ParseNode* parse_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* value);
ParseNode* parse_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* value);
Number* parse_node_solve (ParseNode* self);
static Number* parse_node_real_solve (ParseNode* self);
static void parse_node_finalize (GObject* obj);
GType rnode_get_type (void) G_GNUC_CONST;
enum  {
	RNODE_DUMMY_PROPERTY
};
RNode* rnode_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* rnode_real_solve (ParseNode* base);
Number* rnode_solve_r (RNode* self, Number* r);
void number_check_flags (void);
const gchar* number_get_error (void);
GType error_code_get_type (void) G_GNUC_CONST;
void parser_set_error (Parser* self, ErrorCode errorno, const gchar* token, guint token_start, guint token_end);
GType lexer_token_type_get_type (void) G_GNUC_CONST;
void number_set_error (const gchar* value);
static Number* rnode_real_solve_r (RNode* self, Number* r);
GType lr_node_get_type (void) G_GNUC_CONST;
enum  {
	LR_NODE_DUMMY_PROPERTY
};
LRNode* lr_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* lr_node_real_solve (ParseNode* base);
Number* lr_node_solve_lr (LRNode* self, Number* left, Number* r);
static Number* lr_node_real_solve_lr (LRNode* self, Number* left, Number* r);
GType constant_node_get_type (void) G_GNUC_CONST;
enum  {
	CONSTANT_NODE_DUMMY_PROPERTY
};
ConstantNode* constant_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
ConstantNode* constant_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* constant_node_real_solve (ParseNode* base);
Number* mp_set_from_string (const gchar* str, gint default_base);
GType angle_unit_get_type (void) G_GNUC_CONST;
GType assign_node_get_type (void) G_GNUC_CONST;
enum  {
	ASSIGN_NODE_DUMMY_PROPERTY
};
AssignNode* assign_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
AssignNode* assign_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* assign_node_real_solve_r (RNode* base, Number* r);
void parser_set_variable (Parser* self, const gchar* name, Number* x);
GType assign_function_node_get_type (void) G_GNUC_CONST;
enum  {
	ASSIGN_FUNCTION_NODE_DUMMY_PROPERTY
};
AssignFunctionNode* assign_function_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
AssignFunctionNode* assign_function_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* assign_function_node_real_solve (ParseNode* base);
GType function_manager_get_type (void) G_GNUC_CONST;
FunctionManager* function_manager_get_default_function_manager (void);
gboolean function_manager_add_function_with_properties (FunctionManager* self, const gchar* name, const gchar* arguments, const gchar* description, Parser* root_parser);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
GType name_node_get_type (void) G_GNUC_CONST;
enum  {
	NAME_NODE_DUMMY_PROPERTY
};
NameNode* name_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text);
NameNode* name_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text);
GType variable_node_get_type (void) G_GNUC_CONST;
enum  {
	VARIABLE_NODE_DUMMY_PROPERTY
};
VariableNode* variable_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
VariableNode* variable_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* variable_node_real_solve (ParseNode* base);
Number* parser_get_variable (Parser* self, const gchar* name);
Number* number_multiply (Number* self, Number* y);
GType variable_with_power_node_get_type (void) G_GNUC_CONST;
enum  {
	VARIABLE_WITH_POWER_NODE_DUMMY_PROPERTY
};
VariableWithPowerNode* variable_with_power_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text);
VariableWithPowerNode* variable_with_power_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text);
static Number* variable_with_power_node_real_solve (ParseNode* base);
gint super_atoi (const gchar* data);
Number* number_xpowy_integer (Number* self, gint64 n);
GType function_name_node_get_type (void) G_GNUC_CONST;
enum  {
	FUNCTION_NAME_NODE_DUMMY_PROPERTY
};
FunctionNameNode* function_name_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* name);
FunctionNameNode* function_name_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* name);
GType function_arguments_node_get_type (void) G_GNUC_CONST;
enum  {
	FUNCTION_ARGUMENTS_NODE_DUMMY_PROPERTY
};
FunctionArgumentsNode* function_arguments_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* arguments);
FunctionArgumentsNode* function_arguments_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* arguments);
GType function_description_node_get_type (void) G_GNUC_CONST;
enum  {
	FUNCTION_DESCRIPTION_NODE_DUMMY_PROPERTY
};
FunctionDescriptionNode* function_description_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* description);
FunctionDescriptionNode* function_description_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* description);
GType function_node_get_type (void) G_GNUC_CONST;
enum  {
	FUNCTION_NODE_DUMMY_PROPERTY
};
FunctionNode* function_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text);
FunctionNode* function_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text);
static Number* function_node_real_solve (ParseNode* base);
GType expression_parser_get_type (void) G_GNUC_CONST;
ExpressionParser* expression_parser_new (const gchar* expression, Parser* root_parser);
ExpressionParser* expression_parser_construct (GType object_type, const gchar* expression, Parser* root_parser);
Number* parser_parse (Parser* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
static void _vala_array_add1 (Number*** array, int* length, int* size, Number* value);
static void _vala_array_add2 (Number*** array, int* length, int* size, Number* value);
Number* function_manager_evaluate_function (FunctionManager* self, const gchar* name, Number** arguments, int arguments_length1, Parser* parser);
GType unary_minus_node_get_type (void) G_GNUC_CONST;
enum  {
	UNARY_MINUS_NODE_DUMMY_PROPERTY
};
UnaryMinusNode* unary_minus_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
UnaryMinusNode* unary_minus_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* unary_minus_node_real_solve_r (RNode* base, Number* r);
Number* number_invert_sign (Number* self);
GType absolute_value_node_get_type (void) G_GNUC_CONST;
enum  {
	ABSOLUTE_VALUE_NODE_DUMMY_PROPERTY
};
AbsoluteValueNode* absolute_value_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
AbsoluteValueNode* absolute_value_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* absolute_value_node_real_solve_r (RNode* base, Number* r);
Number* number_abs (Number* self);
GType floor_node_get_type (void) G_GNUC_CONST;
enum  {
	FLOOR_NODE_DUMMY_PROPERTY
};
FloorNode* floor_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
FloorNode* floor_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* floor_node_real_solve_r (RNode* base, Number* r);
Number* number_floor (Number* self);
GType ceiling_node_get_type (void) G_GNUC_CONST;
enum  {
	CEILING_NODE_DUMMY_PROPERTY
};
CeilingNode* ceiling_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
CeilingNode* ceiling_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* ceiling_node_real_solve_r (RNode* base, Number* r);
Number* number_ceiling (Number* self);
GType fractional_component_node_get_type (void) G_GNUC_CONST;
enum  {
	FRACTIONAL_COMPONENT_NODE_DUMMY_PROPERTY
};
FractionalComponentNode* fractional_component_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
FractionalComponentNode* fractional_component_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* fractional_component_node_real_solve_r (RNode* base, Number* r);
Number* number_fractional_part (Number* self);
GType round_node_get_type (void) G_GNUC_CONST;
enum  {
	ROUND_NODE_DUMMY_PROPERTY
};
RoundNode* round_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
RoundNode* round_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* round_node_real_solve_r (RNode* base, Number* r);
Number* number_round (Number* self);
GType percent_node_get_type (void) G_GNUC_CONST;
enum  {
	PERCENT_NODE_DUMMY_PROPERTY
};
PercentNode* percent_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
PercentNode* percent_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* percent_node_real_solve_r (RNode* base, Number* r);
Number* number_divide_integer (Number* self, gint64 y);
GType factorial_node_get_type (void) G_GNUC_CONST;
enum  {
	FACTORIAL_NODE_DUMMY_PROPERTY
};
FactorialNode* factorial_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
FactorialNode* factorial_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* factorial_node_real_solve_r (RNode* base, Number* r);
Number* number_factorial (Number* self);
GType add_node_get_type (void) G_GNUC_CONST;
enum  {
	ADD_NODE_DUMMY_PROPERTY
};
AddNode* add_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
AddNode* add_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* add_node_real_solve_lr (LRNode* base, Number* l, Number* r);
Number* number_add (Number* self, Number* y);
static void add_node_finalize (GObject* obj);
GType subtract_node_get_type (void) G_GNUC_CONST;
enum  {
	SUBTRACT_NODE_DUMMY_PROPERTY
};
SubtractNode* subtract_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
SubtractNode* subtract_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* subtract_node_real_solve_lr (LRNode* base, Number* l, Number* r);
Number* number_subtract (Number* self, Number* y);
static void subtract_node_finalize (GObject* obj);
GType multiply_node_get_type (void) G_GNUC_CONST;
enum  {
	MULTIPLY_NODE_DUMMY_PROPERTY
};
MultiplyNode* multiply_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
MultiplyNode* multiply_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* multiply_node_real_solve_lr (LRNode* base, Number* l, Number* r);
GType divide_node_get_type (void) G_GNUC_CONST;
enum  {
	DIVIDE_NODE_DUMMY_PROPERTY
};
DivideNode* divide_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
DivideNode* divide_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* divide_node_real_solve_lr (LRNode* base, Number* l, Number* r);
Number* number_divide (Number* self, Number* y);
GType modulus_divide_node_get_type (void) G_GNUC_CONST;
enum  {
	MODULUS_DIVIDE_NODE_DUMMY_PROPERTY
};
ModulusDivideNode* modulus_divide_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
ModulusDivideNode* modulus_divide_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* modulus_divide_node_real_solve (ParseNode* base);
GType xpow_ynode_get_type (void) G_GNUC_CONST;
Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod);
static Number* modulus_divide_node_real_solve_lr (LRNode* base, Number* l, Number* r);
Number* number_modulus_divide (Number* self, Number* y);
GType root_node_get_type (void) G_GNUC_CONST;
#define ROOT_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ROOT_NODE, RootNodePrivate))
enum  {
	ROOT_NODE_DUMMY_PROPERTY
};
RootNode* root_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, gint n);
RootNode* root_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, gint n);
static Number* root_node_real_solve_r (RNode* base, Number* r);
Number* number_root (Number* self, gint64 n);
static void root_node_finalize (GObject* obj);
enum  {
	XPOW_YNODE_DUMMY_PROPERTY
};
XPowYNode* xpow_ynode_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
XPowYNode* xpow_ynode_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* xpow_ynode_real_solve_lr (LRNode* base, Number* l, Number* r);
Number* number_xpowy (Number* self, Number* y);
GType xpow_yinteger_node_get_type (void) G_GNUC_CONST;
enum  {
	XPOW_YINTEGER_NODE_DUMMY_PROPERTY
};
XPowYIntegerNode* xpow_yinteger_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
XPowYIntegerNode* xpow_yinteger_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* xpow_yinteger_node_real_solve (ParseNode* base);
gint64 number_to_integer (Number* self);
GType not_node_get_type (void) G_GNUC_CONST;
enum  {
	NOT_NODE_DUMMY_PROPERTY
};
NotNode* not_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
NotNode* not_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* not_node_real_solve_r (RNode* base, Number* r);
gboolean mp_is_overflow (Number* x, gint wordlen);
Number* number_not (Number* self, gint wordlen);
GType and_node_get_type (void) G_GNUC_CONST;
enum  {
	AND_NODE_DUMMY_PROPERTY
};
AndNode* and_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
AndNode* and_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* and_node_real_solve_lr (LRNode* base, Number* l, Number* r);
Number* number_and (Number* self, Number* y);
GType or_node_get_type (void) G_GNUC_CONST;
enum  {
	OR_NODE_DUMMY_PROPERTY
};
OrNode* or_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
OrNode* or_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* or_node_real_solve_lr (LRNode* base, Number* l, Number* r);
Number* number_or (Number* self, Number* y);
GType xor_node_get_type (void) G_GNUC_CONST;
enum  {
	XOR_NODE_DUMMY_PROPERTY
};
XorNode* xor_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
XorNode* xor_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* xor_node_real_solve_lr (LRNode* base, Number* l, Number* r);
Number* number_xor (Number* self, Number* y);
GType convert_node_get_type (void) G_GNUC_CONST;
enum  {
	CONVERT_NODE_DUMMY_PROPERTY
};
ConvertNode* convert_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
ConvertNode* convert_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* convert_node_real_solve_lr (LRNode* base, Number* l, Number* r);
Number* parser_convert (Parser* self, Number* x, const gchar* x_units, const gchar* z_units);
GType convert_base_node_get_type (void) G_GNUC_CONST;
enum  {
	CONVERT_BASE_NODE_DUMMY_PROPERTY
};
ConvertBaseNode* convert_base_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* value);
ConvertBaseNode* convert_base_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* value);
static Number* convert_base_node_real_solve (ParseNode* base);
void parser_set_representation_base (Parser* self, guint new_base);
GType convert_number_node_get_type (void) G_GNUC_CONST;
enum  {
	CONVERT_NUMBER_NODE_DUMMY_PROPERTY
};
ConvertNumberNode* convert_number_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
ConvertNumberNode* convert_number_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity);
static Number* convert_number_node_real_solve (ParseNode* base);
GType lexer_get_type (void) G_GNUC_CONST;
#define PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PARSER, ParserPrivate))
enum  {
	PARSER_DUMMY_PROPERTY
};
Parser* parser_new (const gchar* input, gint number_base, gint wordlen, AngleUnit angle_units);
Parser* parser_construct (GType object_type, const gchar* input, gint number_base, gint wordlen, AngleUnit angle_units);
Lexer* lexer_new (const gchar* input, Parser* parser, gint number_base);
Lexer* lexer_construct (GType object_type, const gchar* input, Parser* parser, gint number_base);
gboolean parser_create_parse_tree (Parser* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
void lexer_scan (Lexer* self);
static gboolean parser_statement (Parser* self);
LexerToken* lexer_get_next_token (Lexer* self);
gboolean parser_variable_is_defined (Parser* self, const gchar* name);
static gboolean parser_real_variable_is_defined (Parser* self, const gchar* name);
static Number* parser_real_get_variable (Parser* self, const gchar* name);
static void parser_real_set_variable (Parser* self, const gchar* name, Number* x);
gboolean parser_function_is_defined (Parser* self, const gchar* name);
static gboolean parser_real_function_is_defined (Parser* self, const gchar* name);
static Number* parser_real_convert (Parser* self, Number* x, const gchar* x_units, const gchar* z_units);
static Precedence parser_get_precedence (Parser* self, LexerTokenType type);
static Associativity parser_get_associativity_p (Parser* self, Precedence type);
static Associativity parser_get_associativity (Parser* self, LexerToken* token);
static guint parser_make_precedence_p (Parser* self, Precedence p);
static guint parser_make_precedence_t (Parser* self, LexerTokenType type);
static gboolean parser_cmp_nodes (Parser* self, ParseNode* left, ParseNode* right);
static void parser_insert_into_tree_all (Parser* self, ParseNode* node, gboolean unary_function);
static void parser_insert_into_tree (Parser* self, ParseNode* node);
static void parser_insert_into_tree_unary (Parser* self, ParseNode* node);
static void parser_destroy_all_nodes (Parser* self, ParseNode* node);
static gboolean parser_check_variable (Parser* self, const gchar* name);
static gboolean parser_expression (Parser* self);
static gboolean parser_check_base (Parser* self);
void lexer_roll_back (Lexer* self);
static gboolean parser_unit (Parser* self);
static gboolean parser_function_definition (Parser* self);
static gboolean parser_expression_1 (Parser* self);
static gboolean parser_expression_2 (Parser* self);
static gboolean parser_variable (Parser* self);
static gboolean parser_function_invocation (Parser* self);
gint sub_atoi (const gchar* data);
static gboolean parser_term (Parser* self);
static gboolean parser_term_2 (Parser* self);
static void parser_finalize (Parser* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType associativity_get_type (void) {
	static volatile gsize associativity_type_id__volatile = 0;
	if (g_once_init_enter (&associativity_type_id__volatile)) {
		static const GEnumValue values[] = {{ASSOCIATIVITY_LEFT, "ASSOCIATIVITY_LEFT", "left"}, {ASSOCIATIVITY_RIGHT, "ASSOCIATIVITY_RIGHT", "right"}, {0, NULL, NULL}};
		GType associativity_type_id;
		associativity_type_id = g_enum_register_static ("Associativity", values);
		g_once_init_leave (&associativity_type_id__volatile, associativity_type_id);
	}
	return associativity_type_id__volatile;
}


GType precedence_get_type (void) {
	static volatile gsize precedence_type_id__volatile = 0;
	if (g_once_init_enter (&precedence_type_id__volatile)) {
		static const GEnumValue values[] = {{PRECEDENCE_UNKNOWN, "PRECEDENCE_UNKNOWN", "unknown"}, {PRECEDENCE_ADD_SUBTRACT, "PRECEDENCE_ADD_SUBTRACT", "add-subtract"}, {PRECEDENCE_MULTIPLY, "PRECEDENCE_MULTIPLY", "multiply"}, {PRECEDENCE_MOD, "PRECEDENCE_MOD", "mod"}, {PRECEDENCE_DIVIDE, "PRECEDENCE_DIVIDE", "divide"}, {PRECEDENCE_NOT, "PRECEDENCE_NOT", "not"}, {PRECEDENCE_ROOT, "PRECEDENCE_ROOT", "root"}, {PRECEDENCE_FUNCTION, "PRECEDENCE_FUNCTION", "function"}, {PRECEDENCE_BOOLEAN, "PRECEDENCE_BOOLEAN", "boolean"}, {PRECEDENCE_PERCENTAGE, "PRECEDENCE_PERCENTAGE", "percentage"}, {PRECEDENCE_UNARY_MINUS, "PRECEDENCE_UNARY_MINUS", "unary-minus"}, {PRECEDENCE_POWER, "PRECEDENCE_POWER", "power"}, {PRECEDENCE_FACTORIAL, "PRECEDENCE_FACTORIAL", "factorial"}, {PRECEDENCE_NUMBER_VARIABLE, "PRECEDENCE_NUMBER_VARIABLE", "number-variable"}, {PRECEDENCE_DEPTH, "PRECEDENCE_DEPTH", "depth"}, {0, NULL, NULL}};
		GType precedence_type_id;
		precedence_type_id = g_enum_register_static ("Precedence", values);
		g_once_init_leave (&precedence_type_id__volatile, precedence_type_id);
	}
	return precedence_type_id__volatile;
}


static gpointer _parser_ref0 (gpointer self) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self ? parser_ref (self) : NULL;
#line 1410 "equation-parser.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self ? g_object_ref (self) : NULL;
#line 1417 "equation-parser.c"
}


ParseNode* parse_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* value) {
	ParseNode * self = NULL;
	Parser* _tmp0_ = NULL;
	Parser* _tmp1_ = NULL;
	LexerToken* _tmp2_ = NULL;
	LexerToken* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	Associativity _tmp5_ = 0;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ParseNode*) g_object_new (object_type, NULL);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = _parser_ref0 (_tmp0_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_parser_unref0 (self->parser);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->parser = _tmp1_;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = token;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->token);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->token = _tmp3_;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = precedence;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->precedence = _tmp4_;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = associativity;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->associativity = _tmp5_;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = value;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (self->value);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->value = _tmp7_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 1469 "equation-parser.c"
}


ParseNode* parse_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* value) {
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return parse_node_construct (TYPE_PARSE_NODE, parser, token, precedence, associativity, value);
#line 1476 "equation-parser.c"
}


static Number* parse_node_real_solve (ParseNode* self) {
	Number* result = NULL;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = NULL;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 1486 "equation-parser.c"
}


Number* parse_node_solve (ParseNode* self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return PARSE_NODE_GET_CLASS (self)->solve (self);
#line 1495 "equation-parser.c"
}


static void parse_node_class_init (ParseNodeClass * klass) {
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parse_node_parent_class = g_type_class_peek_parent (klass);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = parse_node_real_solve;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	G_OBJECT_CLASS (klass)->finalize = parse_node_finalize;
#line 1506 "equation-parser.c"
}


static void parse_node_instance_init (ParseNode * self) {
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->parent = NULL;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->left = NULL;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->right = NULL;
#line 1517 "equation-parser.c"
}


static void parse_node_finalize (GObject* obj) {
	ParseNode * self;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PARSE_NODE, ParseNode);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_parser_unref0 (self->parser);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->parent);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->left);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->right);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->token);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (self->value);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	G_OBJECT_CLASS (parse_node_parent_class)->finalize (obj);
#line 1539 "equation-parser.c"
}


GType parse_node_get_type (void) {
	static volatile gsize parse_node_type_id__volatile = 0;
	if (g_once_init_enter (&parse_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ParseNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) parse_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ParseNode), 0, (GInstanceInitFunc) parse_node_instance_init, NULL };
		GType parse_node_type_id;
		parse_node_type_id = g_type_register_static (G_TYPE_OBJECT, "ParseNode", &g_define_type_info, 0);
		g_once_init_leave (&parse_node_type_id__volatile, parse_node_type_id);
	}
	return parse_node_type_id__volatile;
}


RNode* rnode_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	RNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (RNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 1575 "equation-parser.c"
}


static Number* rnode_real_solve (ParseNode* base) {
	RNode * self;
	Number* result = NULL;
	Number* r = NULL;
	ParseNode* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* z = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (RNode*) base;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = ((ParseNode*) self)->right;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = parse_node_solve (_tmp0_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	r = _tmp1_;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = r;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp2_ == NULL) {
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = NULL;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (r);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 1609 "equation-parser.c"
	}
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = r;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = rnode_solve_r (self, _tmp3_);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	z = _tmp4_;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	number_check_flags ();
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = number_get_error ();
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = _tmp5_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp6_ != NULL) {
#line 1625 "equation-parser.c"
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp7_ = NULL;
		ParseNode* _tmp8_ = NULL;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp9_ = NULL;
		ParseNode* _tmp10_ = NULL;
		Parser* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		ParseNode* _tmp24_ = NULL;
		LexerToken* _tmp25_ = NULL;
		guint _tmp26_ = 0U;
		ParseNode* _tmp27_ = NULL;
		LexerToken* _tmp28_ = NULL;
		guint _tmp29_ = 0U;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = ((ParseNode*) self)->right;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmpleft = _tmp8_;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = ((ParseNode*) self)->right;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmpright = _tmp10_;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 1657 "equation-parser.c"
			ParseNode* _tmp11_ = NULL;
			ParseNode* _tmp12_ = NULL;
			ParseNode* _tmp13_ = NULL;
			ParseNode* _tmp14_ = NULL;
			ParseNode* _tmp15_ = NULL;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp11_ = tmpleft;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp12_ = _tmp11_->left;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp12_ != NULL)) {
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 1671 "equation-parser.c"
			}
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp13_ = tmpleft;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp14_ = _tmp13_->left;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp15_ = _g_object_ref0 (_tmp14_);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpleft);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpleft = _tmp15_;
#line 1683 "equation-parser.c"
		}
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 1687 "equation-parser.c"
			ParseNode* _tmp16_ = NULL;
			ParseNode* _tmp17_ = NULL;
			ParseNode* _tmp18_ = NULL;
			ParseNode* _tmp19_ = NULL;
			ParseNode* _tmp20_ = NULL;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp16_ = tmpright;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp17_ = _tmp16_->right;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp17_ != NULL)) {
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 1701 "equation-parser.c"
			}
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp18_ = tmpright;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp19_ = _tmp18_->right;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpright);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpright = _tmp20_;
#line 1713 "equation-parser.c"
		}
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp21_ = ((ParseNode*) self)->parser;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp22_ = number_get_error ();
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp23_ = _tmp22_;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp24_ = tmpleft;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp25_ = _tmp24_->token;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp26_ = _tmp25_->start_index;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp27_ = tmpright;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp28_ = _tmp27_->token;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp29_ = _tmp28_->end_index;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp21_, ERROR_CODE_MP, _tmp23_, _tmp26_, _tmp29_);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp30_ = number_get_error ();
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp31_ = _tmp30_;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		number_set_error (NULL);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmpright);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmpleft);
#line 1745 "equation-parser.c"
	}
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = z;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (r);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 1753 "equation-parser.c"
}


static Number* rnode_real_solve_r (RNode* self, Number* r) {
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_critical ("Type `%s' does not implement abstract method `rnode_solve_r'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return NULL;
#line 1762 "equation-parser.c"
}


Number* rnode_solve_r (RNode* self, Number* r) {
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return RNODE_GET_CLASS (self)->solve_r (self, r);
#line 1771 "equation-parser.c"
}


static void rnode_class_init (RNodeClass * klass) {
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	rnode_parent_class = g_type_class_peek_parent (klass);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = rnode_real_solve;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = rnode_real_solve_r;
#line 1782 "equation-parser.c"
}


static void rnode_instance_init (RNode * self) {
}


GType rnode_get_type (void) {
	static volatile gsize rnode_type_id__volatile = 0;
	if (g_once_init_enter (&rnode_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rnode_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RNode), 0, (GInstanceInitFunc) rnode_instance_init, NULL };
		GType rnode_type_id;
		rnode_type_id = g_type_register_static (TYPE_PARSE_NODE, "RNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rnode_type_id__volatile, rnode_type_id);
	}
	return rnode_type_id__volatile;
}


LRNode* lr_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	LRNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (LRNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 1822 "equation-parser.c"
}


static Number* lr_node_real_solve (ParseNode* base) {
	LRNode * self;
	Number* result = NULL;
	Number* l = NULL;
	ParseNode* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* r = NULL;
	ParseNode* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* z = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (LRNode*) base;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = ((ParseNode*) self)->left;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = parse_node_solve (_tmp0_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	l = _tmp1_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = ((ParseNode*) self)->right;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = parse_node_solve (_tmp2_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	r = _tmp3_;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = l;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp5_ == NULL) {
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = TRUE;
#line 1863 "equation-parser.c"
	} else {
		Number* _tmp6_ = NULL;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = r;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = _tmp6_ == NULL;
#line 1870 "equation-parser.c"
	}
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp4_) {
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = NULL;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (r);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (l);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 1882 "equation-parser.c"
	}
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp7_ = l;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp8_ = r;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = lr_node_solve_lr (self, _tmp7_, _tmp8_);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	z = _tmp9_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	number_check_flags ();
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp10_ = number_get_error ();
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp11_ = _tmp10_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp11_ != NULL) {
#line 1900 "equation-parser.c"
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp12_ = NULL;
		ParseNode* _tmp13_ = NULL;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp14_ = NULL;
		ParseNode* _tmp15_ = NULL;
		Parser* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		ParseNode* _tmp29_ = NULL;
		LexerToken* _tmp30_ = NULL;
		guint _tmp31_ = 0U;
		ParseNode* _tmp32_ = NULL;
		LexerToken* _tmp33_ = NULL;
		guint _tmp34_ = 0U;
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = ((ParseNode*) self)->left;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmpleft = _tmp13_;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = ((ParseNode*) self)->right;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmpright = _tmp15_;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 1932 "equation-parser.c"
			ParseNode* _tmp16_ = NULL;
			ParseNode* _tmp17_ = NULL;
			ParseNode* _tmp18_ = NULL;
			ParseNode* _tmp19_ = NULL;
			ParseNode* _tmp20_ = NULL;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp16_ = tmpleft;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp17_ = _tmp16_->left;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp17_ != NULL)) {
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 1946 "equation-parser.c"
			}
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp18_ = tmpleft;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp19_ = _tmp18_->left;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpleft);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpleft = _tmp20_;
#line 1958 "equation-parser.c"
		}
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 1962 "equation-parser.c"
			ParseNode* _tmp21_ = NULL;
			ParseNode* _tmp22_ = NULL;
			ParseNode* _tmp23_ = NULL;
			ParseNode* _tmp24_ = NULL;
			ParseNode* _tmp25_ = NULL;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp21_ = tmpright;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp22_ = _tmp21_->right;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp22_ != NULL)) {
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 1976 "equation-parser.c"
			}
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp23_ = tmpright;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp24_ = _tmp23_->right;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp25_ = _g_object_ref0 (_tmp24_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpright);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpright = _tmp25_;
#line 1988 "equation-parser.c"
		}
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp26_ = ((ParseNode*) self)->parser;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp27_ = number_get_error ();
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp28_ = _tmp27_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp29_ = tmpleft;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp30_ = _tmp29_->token;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp31_ = _tmp30_->start_index;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp32_ = tmpright;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp33_ = _tmp32_->token;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp34_ = _tmp33_->end_index;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp26_, ERROR_CODE_MP, _tmp28_, _tmp31_, _tmp34_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp35_ = number_get_error ();
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp36_ = _tmp35_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		number_set_error (NULL);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmpright);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmpleft);
#line 2020 "equation-parser.c"
	}
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = z;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (r);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (l);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 2030 "equation-parser.c"
}


static Number* lr_node_real_solve_lr (LRNode* self, Number* left, Number* r) {
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_critical ("Type `%s' does not implement abstract method `lr_node_solve_lr'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return NULL;
#line 2039 "equation-parser.c"
}


Number* lr_node_solve_lr (LRNode* self, Number* left, Number* r) {
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return LR_NODE_GET_CLASS (self)->solve_lr (self, left, r);
#line 2048 "equation-parser.c"
}


static void lr_node_class_init (LRNodeClass * klass) {
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	lr_node_parent_class = g_type_class_peek_parent (klass);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = lr_node_real_solve;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = lr_node_real_solve_lr;
#line 2059 "equation-parser.c"
}


static void lr_node_instance_init (LRNode * self) {
}


GType lr_node_get_type (void) {
	static volatile gsize lr_node_type_id__volatile = 0;
	if (g_once_init_enter (&lr_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LRNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lr_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LRNode), 0, (GInstanceInitFunc) lr_node_instance_init, NULL };
		GType lr_node_type_id;
		lr_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "LRNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&lr_node_type_id__volatile, lr_node_type_id);
	}
	return lr_node_type_id__volatile;
}


ConstantNode* constant_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	ConstantNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ConstantNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 2099 "equation-parser.c"
}


ConstantNode* constant_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return constant_node_construct (TYPE_CONSTANT_NODE, parser, token, precedence, associativity);
#line 2106 "equation-parser.c"
}


static Number* constant_node_real_solve (ParseNode* base) {
	ConstantNode * self;
	Number* result = NULL;
	LexerToken* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Parser* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Number* _tmp4_ = NULL;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ConstantNode*) base;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = ((ParseNode*) self)->token;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = _tmp0_->text;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = ((ParseNode*) self)->parser;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = _tmp2_->number_base;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = mp_set_from_string (_tmp1_, _tmp3_);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp4_;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 2134 "equation-parser.c"
}


static void constant_node_class_init (ConstantNodeClass * klass) {
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	constant_node_parent_class = g_type_class_peek_parent (klass);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = constant_node_real_solve;
#line 2143 "equation-parser.c"
}


static void constant_node_instance_init (ConstantNode * self) {
}


GType constant_node_get_type (void) {
	static volatile gsize constant_node_type_id__volatile = 0;
	if (g_once_init_enter (&constant_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConstantNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) constant_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConstantNode), 0, (GInstanceInitFunc) constant_node_instance_init, NULL };
		GType constant_node_type_id;
		constant_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "ConstantNode", &g_define_type_info, 0);
		g_once_init_leave (&constant_node_type_id__volatile, constant_node_type_id);
	}
	return constant_node_type_id__volatile;
}


AssignNode* assign_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	AssignNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (AssignNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 2183 "equation-parser.c"
}


AssignNode* assign_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return assign_node_construct (TYPE_ASSIGN_NODE, parser, token, precedence, associativity);
#line 2190 "equation-parser.c"
}


static Number* assign_node_real_solve_r (RNode* base, Number* r) {
	AssignNode * self;
	Number* result = NULL;
	Parser* _tmp0_ = NULL;
	ParseNode* _tmp1_ = NULL;
	LexerToken* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (AssignNode*) base;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = ((ParseNode*) self)->parser;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = ((ParseNode*) self)->left;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = _tmp1_->token;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = _tmp2_->text;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = r;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_set_variable (_tmp0_, _tmp3_, _tmp4_);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = r;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp6_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 2228 "equation-parser.c"
}


static void assign_node_class_init (AssignNodeClass * klass) {
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	assign_node_parent_class = g_type_class_peek_parent (klass);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = assign_node_real_solve_r;
#line 2237 "equation-parser.c"
}


static void assign_node_instance_init (AssignNode * self) {
}


GType assign_node_get_type (void) {
	static volatile gsize assign_node_type_id__volatile = 0;
	if (g_once_init_enter (&assign_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssignNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assign_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssignNode), 0, (GInstanceInitFunc) assign_node_instance_init, NULL };
		GType assign_node_type_id;
		assign_node_type_id = g_type_register_static (TYPE_RNODE, "AssignNode", &g_define_type_info, 0);
		g_once_init_leave (&assign_node_type_id__volatile, assign_node_type_id);
	}
	return assign_node_type_id__volatile;
}


AssignFunctionNode* assign_function_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	AssignFunctionNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (AssignFunctionNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 2277 "equation-parser.c"
}


AssignFunctionNode* assign_function_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return assign_function_node_construct (TYPE_ASSIGN_FUNCTION_NODE, parser, token, precedence, associativity);
#line 2284 "equation-parser.c"
}


static Number* assign_function_node_real_solve (ParseNode* base) {
	AssignFunctionNode * self;
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ParseNode* _tmp3_ = NULL;
	gchar* function_name = NULL;
	ParseNode* _tmp9_ = NULL;
	ParseNode* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* arguments = NULL;
	ParseNode* _tmp13_ = NULL;
	ParseNode* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* description = NULL;
	ParseNode* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp20_ = NULL;
	FunctionManager* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	Parser* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (AssignFunctionNode*) base;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = ((ParseNode*) self)->left;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp3_ == NULL) {
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = TRUE;
#line 2325 "equation-parser.c"
	} else {
		ParseNode* _tmp4_ = NULL;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = ((ParseNode*) self)->right;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = _tmp4_ == NULL;
#line 2332 "equation-parser.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp2_) {
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp1_ = TRUE;
#line 2338 "equation-parser.c"
	} else {
		ParseNode* _tmp5_ = NULL;
		ParseNode* _tmp6_ = NULL;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = ((ParseNode*) self)->left;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = _tmp5_->left;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp1_ = _tmp6_ == NULL;
#line 2348 "equation-parser.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp1_) {
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp0_ = TRUE;
#line 2354 "equation-parser.c"
	} else {
		ParseNode* _tmp7_ = NULL;
		ParseNode* _tmp8_ = NULL;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = ((ParseNode*) self)->left;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = _tmp7_->right;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp0_ = _tmp8_ == NULL;
#line 2364 "equation-parser.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp0_) {
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = NULL;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 2372 "equation-parser.c"
	}
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = ((ParseNode*) self)->left;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp10_ = _tmp9_->left;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp11_ = _tmp10_->value;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	function_name = _tmp12_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp13_ = ((ParseNode*) self)->left;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp14_ = _tmp13_->right;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp15_ = _tmp14_->value;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	arguments = _tmp16_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp17_ = ((ParseNode*) self)->right;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp18_ = _tmp17_->value;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp19_ = g_strdup (_tmp18_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	description = _tmp19_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp20_ = function_manager_get_default_function_manager ();
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	function_manager = _tmp20_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp21_ = function_manager;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp22_ = function_name;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp23_ = arguments;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp24_ = description;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp25_ = ((ParseNode*) self)->parser;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp26_ = function_manager_add_function_with_properties (_tmp21_, _tmp22_, _tmp23_, _tmp24_, _tmp25_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp26_) {
#line 2420 "equation-parser.c"
		Number* _tmp27_ = NULL;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp27_ = number_new_integer ((gint64) 0);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = _tmp27_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (function_manager);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (description);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (arguments);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (function_name);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 2436 "equation-parser.c"
	}
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = NULL;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (function_manager);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (description);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (arguments);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (function_name);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 2450 "equation-parser.c"
}


static void assign_function_node_class_init (AssignFunctionNodeClass * klass) {
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	assign_function_node_parent_class = g_type_class_peek_parent (klass);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = assign_function_node_real_solve;
#line 2459 "equation-parser.c"
}


static void assign_function_node_instance_init (AssignFunctionNode * self) {
}


GType assign_function_node_get_type (void) {
	static volatile gsize assign_function_node_type_id__volatile = 0;
	if (g_once_init_enter (&assign_function_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssignFunctionNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assign_function_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssignFunctionNode), 0, (GInstanceInitFunc) assign_function_node_instance_init, NULL };
		GType assign_function_node_type_id;
		assign_function_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "AssignFunctionNode", &g_define_type_info, 0);
		g_once_init_leave (&assign_function_node_type_id__volatile, assign_function_node_type_id);
	}
	return assign_function_node_type_id__volatile;
}


NameNode* name_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text) {
	NameNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = text;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (NameNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 2502 "equation-parser.c"
}


NameNode* name_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text) {
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return name_node_construct (TYPE_NAME_NODE, parser, token, precedence, associativity, text);
#line 2509 "equation-parser.c"
}


static void name_node_class_init (NameNodeClass * klass) {
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	name_node_parent_class = g_type_class_peek_parent (klass);
#line 2516 "equation-parser.c"
}


static void name_node_instance_init (NameNode * self) {
}


GType name_node_get_type (void) {
	static volatile gsize name_node_type_id__volatile = 0;
	if (g_once_init_enter (&name_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NameNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) name_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NameNode), 0, (GInstanceInitFunc) name_node_instance_init, NULL };
		GType name_node_type_id;
		name_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "NameNode", &g_define_type_info, 0);
		g_once_init_leave (&name_node_type_id__volatile, name_node_type_id);
	}
	return name_node_type_id__volatile;
}


VariableNode* variable_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	VariableNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (VariableNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 2556 "equation-parser.c"
}


VariableNode* variable_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return variable_node_construct (TYPE_VARIABLE_NODE, parser, token, precedence, associativity);
#line 2563 "equation-parser.c"
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_vala_c = _tmp1_;
#line 1017 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = _vala_c;
#line 1017 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp2_ != ((gunichar) 0)) {
#line 2585 "equation-parser.c"
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp4_ - ((gchar*) self));
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (c) {
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 2600 "equation-parser.c"
		}
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2604 "equation-parser.c"
	} else {
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (c) {
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 2612 "equation-parser.c"
		}
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2616 "equation-parser.c"
	}
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (c) {
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 2622 "equation-parser.c"
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 857 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 857 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 858 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = str;
#line 858 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 859 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = str;
#line 859 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 2644 "equation-parser.c"
}


static Number* variable_node_real_solve (ParseNode* base) {
	VariableNode * self;
	Number* result = NULL;
	Number* ans = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* value = NULL;
	Number* _tmp5_ = NULL;
	gint index = 0;
	gunichar c = 0U;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (VariableNode*) base;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = ((ParseNode*) self)->parser;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = ((ParseNode*) self)->token;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = _tmp1_->text;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = parser_get_variable (_tmp0_, _tmp2_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	ans = _tmp3_;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = ans;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp4_ != NULL) {
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = ans;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 2681 "equation-parser.c"
	}
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = number_new_integer ((gint64) 1);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	value = _tmp5_;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	index = 0;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	while (TRUE) {
#line 2691 "equation-parser.c"
		LexerToken* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
		Number* t = NULL;
		Parser* _tmp10_ = NULL;
		gunichar _tmp11_ = 0U;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = ((ParseNode*) self)->token;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = _tmp6_->text;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = string_get_next_char (_tmp7_, &index, &_tmp8_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		c = _tmp8_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp9_) {
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			break;
#line 2719 "equation-parser.c"
		}
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = ((ParseNode*) self)->parser;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = c;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = g_unichar_to_string (_tmp11_);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = _tmp12_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = parser_get_variable (_tmp10_, _tmp13_);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = _tmp14_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_tmp13_);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		t = _tmp15_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp16_ = t;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp16_ == NULL) {
#line 2741 "equation-parser.c"
			Parser* _tmp17_ = NULL;
			LexerToken* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			LexerToken* _tmp20_ = NULL;
			guint _tmp21_ = 0U;
			LexerToken* _tmp22_ = NULL;
			guint _tmp23_ = 0U;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp17_ = ((ParseNode*) self)->parser;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp18_ = ((ParseNode*) self)->token;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp19_ = _tmp18_->text;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp20_ = ((ParseNode*) self)->token;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp21_ = _tmp20_->start_index;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp22_ = ((ParseNode*) self)->token;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp23_ = _tmp22_->end_index;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_set_error (_tmp17_, ERROR_CODE_UNKNOWN_VARIABLE, _tmp19_, _tmp21_, _tmp23_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = NULL;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (t);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (value);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (ans);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 2775 "equation-parser.c"
		}
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp24_ = value;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp25_ = t;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp26_ = number_multiply (_tmp24_, _tmp25_);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (value);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		value = _tmp26_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (t);
#line 2789 "equation-parser.c"
	}
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = value;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (ans);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 2797 "equation-parser.c"
}


static void variable_node_class_init (VariableNodeClass * klass) {
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	variable_node_parent_class = g_type_class_peek_parent (klass);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = variable_node_real_solve;
#line 2806 "equation-parser.c"
}


static void variable_node_instance_init (VariableNode * self) {
}


GType variable_node_get_type (void) {
	static volatile gsize variable_node_type_id__volatile = 0;
	if (g_once_init_enter (&variable_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VariableNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableNode), 0, (GInstanceInitFunc) variable_node_instance_init, NULL };
		GType variable_node_type_id;
		variable_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "VariableNode", &g_define_type_info, 0);
		g_once_init_leave (&variable_node_type_id__volatile, variable_node_type_id);
	}
	return variable_node_type_id__volatile;
}


VariableWithPowerNode* variable_with_power_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text) {
	VariableWithPowerNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = text;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (VariableWithPowerNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 2851 "equation-parser.c"
}


VariableWithPowerNode* variable_with_power_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text) {
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return variable_with_power_node_construct (TYPE_VARIABLE_WITH_POWER_NODE, parser, token, precedence, associativity, text);
#line 2858 "equation-parser.c"
}


static Number* variable_with_power_node_real_solve (ParseNode* base) {
	VariableWithPowerNode * self;
	Number* result = NULL;
	gint pow = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Number* ans = NULL;
	Parser* _tmp2_ = NULL;
	LexerToken* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* value = NULL;
	Number* _tmp10_ = NULL;
	gint index = 0;
	gunichar c = 0U;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (VariableWithPowerNode*) base;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = ((ParseNode*) self)->value;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = super_atoi (_tmp0_);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	pow = _tmp1_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (((ParseNode*) self)->value);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNode*) self)->value = NULL;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = ((ParseNode*) self)->parser;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = ((ParseNode*) self)->token;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = _tmp3_->text;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = parser_get_variable (_tmp2_, _tmp4_);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	ans = _tmp5_;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = ans;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp6_ != NULL) {
#line 2906 "equation-parser.c"
		Number* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		Number* _tmp9_ = NULL;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = ans;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = pow;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = number_xpowy_integer (_tmp7_, (gint64) _tmp8_);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = _tmp9_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (ans);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 2922 "equation-parser.c"
	}
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp10_ = number_new_integer ((gint64) 1);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	value = _tmp10_;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	index = 0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	while (TRUE) {
#line 2932 "equation-parser.c"
		LexerToken* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gunichar _tmp13_ = 0U;
		gboolean _tmp14_ = FALSE;
		Number* t = NULL;
		Parser* _tmp15_ = NULL;
		gunichar _tmp16_ = 0U;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		gint i = 0;
		gint _tmp29_ = 0;
		gunichar next = 0U;
		LexerToken* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gunichar _tmp32_ = 0U;
		gboolean _tmp33_ = FALSE;
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = ((ParseNode*) self)->token;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = _tmp11_->text;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = string_get_next_char (_tmp12_, &index, &_tmp13_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		c = _tmp13_;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp14_) {
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			break;
#line 2967 "equation-parser.c"
		}
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = ((ParseNode*) self)->parser;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp16_ = c;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp17_ = g_unichar_to_string (_tmp16_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp18_ = _tmp17_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp19_ = parser_get_variable (_tmp15_, _tmp18_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp20_ = _tmp19_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_tmp18_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		t = _tmp20_;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp21_ = t;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp21_ == NULL) {
#line 2989 "equation-parser.c"
			Parser* _tmp22_ = NULL;
			LexerToken* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			LexerToken* _tmp25_ = NULL;
			guint _tmp26_ = 0U;
			LexerToken* _tmp27_ = NULL;
			guint _tmp28_ = 0U;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp22_ = ((ParseNode*) self)->parser;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp23_ = ((ParseNode*) self)->token;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp24_ = _tmp23_->text;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp25_ = ((ParseNode*) self)->token;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp26_ = _tmp25_->start_index;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp27_ = ((ParseNode*) self)->token;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp28_ = _tmp27_->end_index;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_set_error (_tmp22_, ERROR_CODE_UNKNOWN_VARIABLE, _tmp24_, _tmp26_, _tmp28_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = NULL;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (t);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (value);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (ans);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 3023 "equation-parser.c"
		}
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp29_ = index;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		i = _tmp29_;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp30_ = ((ParseNode*) self)->token;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp31_ = _tmp30_->text;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp33_ = string_get_next_char (_tmp31_, &i, &_tmp32_);
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		next = _tmp32_;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp33_) {
#line 3039 "equation-parser.c"
			Number* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			Number* _tmp36_ = NULL;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp34_ = t;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp35_ = pow;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp36_ = number_xpowy_integer (_tmp34_, (gint64) _tmp35_);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (t);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			t = _tmp36_;
#line 3053 "equation-parser.c"
		}
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp37_ = value;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp38_ = t;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp39_ = number_multiply (_tmp37_, _tmp38_);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (value);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		value = _tmp39_;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (t);
#line 3067 "equation-parser.c"
	}
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	number_check_flags ();
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp40_ = number_get_error ();
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp41_ = _tmp40_;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp41_ != NULL) {
#line 3077 "equation-parser.c"
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp42_ = NULL;
		ParseNode* _tmp43_ = NULL;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp44_ = NULL;
		ParseNode* _tmp45_ = NULL;
		Parser* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		ParseNode* _tmp59_ = NULL;
		LexerToken* _tmp60_ = NULL;
		guint _tmp61_ = 0U;
		ParseNode* _tmp62_ = NULL;
		LexerToken* _tmp63_ = NULL;
		guint _tmp64_ = 0U;
		const gchar* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp42_ = ((ParseNode*) self)->left;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp43_ = _g_object_ref0 (_tmp42_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmpleft = _tmp43_;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp44_ = ((ParseNode*) self)->right;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp45_ = _g_object_ref0 (_tmp44_);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmpright = _tmp45_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 3109 "equation-parser.c"
			ParseNode* _tmp46_ = NULL;
			ParseNode* _tmp47_ = NULL;
			ParseNode* _tmp48_ = NULL;
			ParseNode* _tmp49_ = NULL;
			ParseNode* _tmp50_ = NULL;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp46_ = tmpleft;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp47_ = _tmp46_->left;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp47_ != NULL)) {
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 3123 "equation-parser.c"
			}
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp48_ = tmpleft;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp49_ = _tmp48_->left;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp50_ = _g_object_ref0 (_tmp49_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpleft);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpleft = _tmp50_;
#line 3135 "equation-parser.c"
		}
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 3139 "equation-parser.c"
			ParseNode* _tmp51_ = NULL;
			ParseNode* _tmp52_ = NULL;
			ParseNode* _tmp53_ = NULL;
			ParseNode* _tmp54_ = NULL;
			ParseNode* _tmp55_ = NULL;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp51_ = tmpright;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp52_ = _tmp51_->right;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp52_ != NULL)) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 3153 "equation-parser.c"
			}
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp53_ = tmpright;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp54_ = _tmp53_->right;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp55_ = _g_object_ref0 (_tmp54_);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpright);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpright = _tmp55_;
#line 3165 "equation-parser.c"
		}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp56_ = ((ParseNode*) self)->parser;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp57_ = number_get_error ();
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp58_ = _tmp57_;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp59_ = tmpleft;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp60_ = _tmp59_->token;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp61_ = _tmp60_->start_index;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp62_ = tmpright;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp63_ = _tmp62_->token;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp64_ = _tmp63_->end_index;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp56_, ERROR_CODE_MP, _tmp58_, _tmp61_, _tmp64_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp65_ = number_get_error ();
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp66_ = _tmp65_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		number_set_error (NULL);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmpright);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmpleft);
#line 3197 "equation-parser.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = value;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (ans);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 3205 "equation-parser.c"
}


static void variable_with_power_node_class_init (VariableWithPowerNodeClass * klass) {
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	variable_with_power_node_parent_class = g_type_class_peek_parent (klass);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = variable_with_power_node_real_solve;
#line 3214 "equation-parser.c"
}


static void variable_with_power_node_instance_init (VariableWithPowerNode * self) {
}


GType variable_with_power_node_get_type (void) {
	static volatile gsize variable_with_power_node_type_id__volatile = 0;
	if (g_once_init_enter (&variable_with_power_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VariableWithPowerNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_with_power_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableWithPowerNode), 0, (GInstanceInitFunc) variable_with_power_node_instance_init, NULL };
		GType variable_with_power_node_type_id;
		variable_with_power_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "VariableWithPowerNode", &g_define_type_info, 0);
		g_once_init_leave (&variable_with_power_node_type_id__volatile, variable_with_power_node_type_id);
	}
	return variable_with_power_node_type_id__volatile;
}


FunctionNameNode* function_name_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* name) {
	FunctionNameNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = name;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FunctionNameNode*) name_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 3259 "equation-parser.c"
}


FunctionNameNode* function_name_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* name) {
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return function_name_node_construct (TYPE_FUNCTION_NAME_NODE, parser, token, precedence, associativity, name);
#line 3266 "equation-parser.c"
}


static void function_name_node_class_init (FunctionNameNodeClass * klass) {
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	function_name_node_parent_class = g_type_class_peek_parent (klass);
#line 3273 "equation-parser.c"
}


static void function_name_node_instance_init (FunctionNameNode * self) {
}


GType function_name_node_get_type (void) {
	static volatile gsize function_name_node_type_id__volatile = 0;
	if (g_once_init_enter (&function_name_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionNameNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_name_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionNameNode), 0, (GInstanceInitFunc) function_name_node_instance_init, NULL };
		GType function_name_node_type_id;
		function_name_node_type_id = g_type_register_static (TYPE_NAME_NODE, "FunctionNameNode", &g_define_type_info, 0);
		g_once_init_leave (&function_name_node_type_id__volatile, function_name_node_type_id);
	}
	return function_name_node_type_id__volatile;
}


FunctionArgumentsNode* function_arguments_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* arguments) {
	FunctionArgumentsNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (arguments != NULL, NULL);
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = arguments;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FunctionArgumentsNode*) name_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 3318 "equation-parser.c"
}


FunctionArgumentsNode* function_arguments_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* arguments) {
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return function_arguments_node_construct (TYPE_FUNCTION_ARGUMENTS_NODE, parser, token, precedence, associativity, arguments);
#line 3325 "equation-parser.c"
}


static void function_arguments_node_class_init (FunctionArgumentsNodeClass * klass) {
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	function_arguments_node_parent_class = g_type_class_peek_parent (klass);
#line 3332 "equation-parser.c"
}


static void function_arguments_node_instance_init (FunctionArgumentsNode * self) {
}


GType function_arguments_node_get_type (void) {
	static volatile gsize function_arguments_node_type_id__volatile = 0;
	if (g_once_init_enter (&function_arguments_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionArgumentsNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_arguments_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionArgumentsNode), 0, (GInstanceInitFunc) function_arguments_node_instance_init, NULL };
		GType function_arguments_node_type_id;
		function_arguments_node_type_id = g_type_register_static (TYPE_NAME_NODE, "FunctionArgumentsNode", &g_define_type_info, 0);
		g_once_init_leave (&function_arguments_node_type_id__volatile, function_arguments_node_type_id);
	}
	return function_arguments_node_type_id__volatile;
}


FunctionDescriptionNode* function_description_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* description) {
	FunctionDescriptionNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (description != NULL, NULL);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = description;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FunctionDescriptionNode*) name_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 3377 "equation-parser.c"
}


FunctionDescriptionNode* function_description_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* description) {
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return function_description_node_construct (TYPE_FUNCTION_DESCRIPTION_NODE, parser, token, precedence, associativity, description);
#line 3384 "equation-parser.c"
}


static void function_description_node_class_init (FunctionDescriptionNodeClass * klass) {
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	function_description_node_parent_class = g_type_class_peek_parent (klass);
#line 3391 "equation-parser.c"
}


static void function_description_node_instance_init (FunctionDescriptionNode * self) {
}


GType function_description_node_get_type (void) {
	static volatile gsize function_description_node_type_id__volatile = 0;
	if (g_once_init_enter (&function_description_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionDescriptionNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_description_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionDescriptionNode), 0, (GInstanceInitFunc) function_description_node_instance_init, NULL };
		GType function_description_node_type_id;
		function_description_node_type_id = g_type_register_static (TYPE_NAME_NODE, "FunctionDescriptionNode", &g_define_type_info, 0);
		g_once_init_leave (&function_description_node_type_id__volatile, function_description_node_type_id);
	}
	return function_description_node_type_id__volatile;
}


FunctionNode* function_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text) {
	FunctionNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = text;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FunctionNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 3434 "equation-parser.c"
}


FunctionNode* function_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* text) {
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return function_node_construct (TYPE_FUNCTION_NODE, parser, token, precedence, associativity, text);
#line 3441 "equation-parser.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 3464 "equation-parser.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 3472 "equation-parser.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 3484 "equation-parser.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 3508 "equation-parser.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 3514 "equation-parser.c"
	} else {
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 3518 "equation-parser.c"
	}
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 3522 "equation-parser.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 3534 "equation-parser.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 3544 "equation-parser.c"
	}
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 3550 "equation-parser.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 3564 "equation-parser.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 3574 "equation-parser.c"
	}
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 3580 "equation-parser.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 3589 "equation-parser.c"
	}
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 3609 "equation-parser.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 3622 "equation-parser.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 3653 "equation-parser.c"
				goto __catch6_g_regex_error;
			}
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			return NULL;
#line 3662 "equation-parser.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 3678 "equation-parser.c"
				goto __catch6_g_regex_error;
			}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			return NULL;
#line 3689 "equation-parser.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 3703 "equation-parser.c"
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 3717 "equation-parser.c"
	}
	__finally6:
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return NULL;
#line 3728 "equation-parser.c"
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 3752 "equation-parser.c"
}


static void _vala_array_add1 (Number*** array, int* length, int* size, Number* value) {
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if ((*length) == (*size)) {
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*array = g_renew (Number*, *array, (*size) + 1);
#line 3763 "equation-parser.c"
	}
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	(*array)[(*length)++] = value;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	(*array)[*length] = NULL;
#line 3769 "equation-parser.c"
}


static void _vala_array_add2 (Number*** array, int* length, int* size, Number* value) {
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if ((*length) == (*size)) {
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*array = g_renew (Number*, *array, (*size) + 1);
#line 3780 "equation-parser.c"
	}
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	(*array)[(*length)++] = value;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	(*array)[*length] = NULL;
#line 3786 "equation-parser.c"
}


static Number* function_node_real_solve (ParseNode* base) {
	FunctionNode * self;
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	ParseNode* _tmp1_ = NULL;
	gchar* name = NULL;
	ParseNode* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gint pow = 0;
	const gchar* _tmp9_ = NULL;
	gint _tmp12_ = 0;
	Number** args = NULL;
	Number** _tmp16_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	ParseNode* _tmp17_ = NULL;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp78_ = NULL;
	Number* tmp = NULL;
	FunctionManager* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	Number** _tmp81_ = NULL;
	gint _tmp81__length1 = 0;
	Parser* _tmp82_ = NULL;
	Number* _tmp83_ = NULL;
	Number* _tmp84_ = NULL;
	const gchar* _tmp88_ = NULL;
	const gchar* _tmp89_ = NULL;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FunctionNode*) base;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = ((ParseNode*) self)->right;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp1_ == NULL) {
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp0_ = TRUE;
#line 3828 "equation-parser.c"
	} else {
		ParseNode* _tmp2_ = NULL;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = ((ParseNode*) self)->left;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 3835 "equation-parser.c"
	}
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp0_) {
#line 3839 "equation-parser.c"
		Parser* _tmp3_ = NULL;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = ((ParseNode*) self)->parser;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp3_, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = NULL;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 3849 "equation-parser.c"
	}
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = ((ParseNode*) self)->left;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = _tmp4_->value;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	name = _tmp6_;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp7_ = name;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp7_ == NULL) {
#line 3863 "equation-parser.c"
		Parser* _tmp8_ = NULL;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = ((ParseNode*) self)->parser;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp8_, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = NULL;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (name);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 3875 "equation-parser.c"
	}
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	pow = 1;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = ((ParseNode*) self)->value;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp9_ != NULL) {
#line 3883 "equation-parser.c"
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = ((ParseNode*) self)->value;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = super_atoi (_tmp10_);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		pow = _tmp11_;
#line 3892 "equation-parser.c"
	}
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp12_ = pow;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp12_ < 0) {
#line 3898 "equation-parser.c"
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = name;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = g_strconcat (_tmp13_, "⁻¹", NULL);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (name);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		name = _tmp14_;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = pow;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		pow = -_tmp15_;
#line 3914 "equation-parser.c"
	}
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp16_ = g_new0 (Number*, 0 + 1);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	args = _tmp16_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	args_length1 = 0;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_args_size_ = args_length1;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp17_ = ((ParseNode*) self)->right;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, TYPE_FUNCTION_ARGUMENTS_NODE)) {
#line 3928 "equation-parser.c"
		gchar* argument_list = NULL;
		ParseNode* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* temp = NULL;
		gchar* _tmp21_ = NULL;
		gint depth = 0;
		gchar** arguments = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gchar** _tmp44_ = NULL;
		gint arguments_length1 = 0;
		gint _arguments_size_ = 0;
		gchar** _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp18_ = ((ParseNode*) self)->right;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp19_ = _tmp18_->value;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		argument_list = _tmp20_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp21_ = g_strdup ("");
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		temp = _tmp21_;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		depth = 0;
#line 3958 "equation-parser.c"
		{
			gint i = 0;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			i = 0;
#line 3963 "equation-parser.c"
			{
				gboolean _tmp22_ = FALSE;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp22_ = TRUE;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				while (TRUE) {
#line 3970 "equation-parser.c"
					gint _tmp24_ = 0;
					const gchar* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					gchar* ss = NULL;
					const gchar* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					gchar* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					const gchar* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!_tmp22_) {
#line 3985 "equation-parser.c"
						gint _tmp23_ = 0;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp23_ = i;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						i = _tmp23_ + 1;
#line 3991 "equation-parser.c"
					}
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp22_ = FALSE;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp24_ = i;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp25_ = argument_list;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp26_ = strlen (_tmp25_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp27_ = _tmp26_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!(_tmp24_ < _tmp27_)) {
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						break;
#line 4007 "equation-parser.c"
					}
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp28_ = argument_list;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp29_ = i;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp30_ = string_substring (_tmp28_, (glong) _tmp29_, (glong) 1);
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					ss = _tmp30_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp31_ = ss;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (g_strcmp0 (_tmp31_, "(") == 0) {
#line 4021 "equation-parser.c"
						gint _tmp32_ = 0;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp32_ = depth;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						depth = _tmp32_ + 1;
#line 4027 "equation-parser.c"
					} else {
						const gchar* _tmp33_ = NULL;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp33_ = ss;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (g_strcmp0 (_tmp33_, ")") == 0) {
#line 4034 "equation-parser.c"
							gint _tmp34_ = 0;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp34_ = depth;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							depth = _tmp34_ - 1;
#line 4040 "equation-parser.c"
						} else {
							gboolean _tmp35_ = FALSE;
							const gchar* _tmp36_ = NULL;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp36_ = ss;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (g_strcmp0 (_tmp36_, ";") == 0) {
#line 4048 "equation-parser.c"
								gint _tmp37_ = 0;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp37_ = depth;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp35_ = _tmp37_ != 0;
#line 4054 "equation-parser.c"
							} else {
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp35_ = FALSE;
#line 4058 "equation-parser.c"
							}
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (_tmp35_) {
#line 4062 "equation-parser.c"
								gchar* _tmp38_ = NULL;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp38_ = g_strdup ("$");
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_free0 (ss);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								ss = _tmp38_;
#line 4070 "equation-parser.c"
							}
						}
					}
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp39_ = temp;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp40_ = ss;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp41_ = g_strconcat (_tmp39_, _tmp40_, NULL);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_free0 (temp);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					temp = _tmp41_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_free0 (ss);
#line 4086 "equation-parser.c"
				}
			}
		}
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp42_ = temp;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp44_ = _tmp43_ = g_strsplit_set (_tmp42_, ";", 0);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		arguments = _tmp44_;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		arguments_length1 = _vala_array_length (_tmp43_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_arguments_size_ = arguments_length1;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp45_ = arguments;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp45__length1 = arguments_length1;
#line 4104 "equation-parser.c"
		{
			gchar** argument_collection = NULL;
			gint argument_collection_length1 = 0;
			gint _argument_collection_size_ = 0;
			gint argument_it = 0;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			argument_collection = _tmp45_;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			argument_collection_length1 = _tmp45__length1;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			for (argument_it = 0; argument_it < _tmp45__length1; argument_it = argument_it + 1) {
#line 4116 "equation-parser.c"
				gchar* _tmp46_ = NULL;
				gchar* argument = NULL;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp46_ = g_strdup (argument_collection[argument_it]);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				argument = _tmp46_;
#line 4123 "equation-parser.c"
				{
					const gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
					ExpressionParser* argument_parser = NULL;
					const gchar* _tmp51_ = NULL;
					Parser* _tmp52_ = NULL;
					ExpressionParser* _tmp53_ = NULL;
					guint representation_base = 0U;
					ErrorCode error_code = 0;
					gchar* error_token = NULL;
					guint error_start = 0U;
					guint error_end = 0U;
					Number* ans = NULL;
					ExpressionParser* _tmp54_ = NULL;
					guint _tmp55_ = 0U;
					ErrorCode _tmp56_ = 0;
					gchar* _tmp57_ = NULL;
					guint _tmp58_ = 0U;
					guint _tmp59_ = 0U;
					Number* _tmp60_ = NULL;
					gboolean _tmp61_ = FALSE;
					ErrorCode _tmp62_ = 0;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp47_ = argument;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp48_ = string_replace (_tmp47_, "$", ";");
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp49_ = _tmp48_;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp50_ = string_strip (_tmp49_);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_free0 (argument);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					argument = _tmp50_;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_free0 (_tmp49_);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp51_ = argument;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp52_ = ((ParseNode*) self)->parser;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp53_ = expression_parser_new (_tmp51_, _tmp52_);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					argument_parser = _tmp53_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp54_ = argument_parser;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp60_ = parser_parse ((Parser*) _tmp54_, &_tmp55_, &_tmp56_, &_tmp57_, &_tmp58_, &_tmp59_);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					representation_base = _tmp55_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					error_code = _tmp56_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_free0 (error_token);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					error_token = _tmp57_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					error_start = _tmp58_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					error_end = _tmp59_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					ans = _tmp60_;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp62_ = error_code;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp62_ == ERROR_CODE_NONE) {
#line 4192 "equation-parser.c"
						Number* _tmp63_ = NULL;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp63_ = ans;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp61_ = _tmp63_ != NULL;
#line 4198 "equation-parser.c"
					} else {
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp61_ = FALSE;
#line 4202 "equation-parser.c"
					}
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp61_) {
#line 4206 "equation-parser.c"
						Number** _tmp64_ = NULL;
						gint _tmp64__length1 = 0;
						Number* _tmp65_ = NULL;
						Number* _tmp66_ = NULL;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp64_ = args;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp64__length1 = args_length1;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp65_ = ans;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp66_ = _g_object_ref0 (_tmp65_);
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_vala_array_add1 (&args, &args_length1, &_args_size_, _tmp66_);
#line 4221 "equation-parser.c"
					} else {
						Parser* _tmp67_ = NULL;
						const gchar* _tmp68_ = NULL;
						guint _tmp69_ = 0U;
						guint _tmp70_ = 0U;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp67_ = ((ParseNode*) self)->parser;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp68_ = error_token;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp69_ = error_start;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp70_ = error_end;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_set_error (_tmp67_, ERROR_CODE_UNKNOWN_VARIABLE, _tmp68_, _tmp69_, _tmp70_);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = NULL;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (ans);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_free0 (error_token);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_parser_unref0 (argument_parser);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_free0 (argument);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_free0 (temp);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_free0 (argument_list);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_free0 (name);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 4259 "equation-parser.c"
					}
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (ans);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_free0 (error_token);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_parser_unref0 (argument_parser);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_free0 (argument);
#line 4269 "equation-parser.c"
				}
			}
		}
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (temp);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (argument_list);
#line 4279 "equation-parser.c"
	} else {
		Number* ans = NULL;
		ParseNode* _tmp71_ = NULL;
		Number* _tmp72_ = NULL;
		Number* _tmp73_ = NULL;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp71_ = ((ParseNode*) self)->right;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp72_ = parse_node_solve (_tmp71_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		ans = _tmp72_;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp73_ = ans;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp73_ != NULL) {
#line 4295 "equation-parser.c"
			Number** _tmp74_ = NULL;
			gint _tmp74__length1 = 0;
			Number* _tmp75_ = NULL;
			Number* _tmp76_ = NULL;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp74_ = args;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp74__length1 = args_length1;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp75_ = ans;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp76_ = _g_object_ref0 (_tmp75_);
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp76_);
#line 4310 "equation-parser.c"
		} else {
			Parser* _tmp77_ = NULL;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp77_ = ((ParseNode*) self)->parser;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_set_error (_tmp77_, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = NULL;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (ans);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (name);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 4327 "equation-parser.c"
		}
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (ans);
#line 4331 "equation-parser.c"
	}
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp78_ = function_manager_get_default_function_manager ();
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	function_manager = _tmp78_;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp79_ = function_manager;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp80_ = name;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp81_ = args;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp81__length1 = args_length1;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp82_ = ((ParseNode*) self)->parser;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp83_ = function_manager_evaluate_function (_tmp79_, _tmp80_, _tmp81_, _tmp81__length1, _tmp82_);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	tmp = _tmp83_;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp84_ = tmp;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp84_ != NULL) {
#line 4355 "equation-parser.c"
		Number* _tmp85_ = NULL;
		gint _tmp86_ = 0;
		Number* _tmp87_ = NULL;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp85_ = tmp;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp86_ = pow;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp87_ = number_xpowy_integer (_tmp85_, (gint64) _tmp86_);
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmp);
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmp = _tmp87_;
#line 4369 "equation-parser.c"
	}
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	number_check_flags ();
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp88_ = number_get_error ();
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp89_ = _tmp88_;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp89_ != NULL) {
#line 4379 "equation-parser.c"
		Parser* _tmp90_ = NULL;
		const gchar* _tmp91_ = NULL;
		const gchar* _tmp92_ = NULL;
		const gchar* _tmp93_ = NULL;
		const gchar* _tmp94_ = NULL;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp90_ = ((ParseNode*) self)->parser;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp91_ = number_get_error ();
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp92_ = _tmp91_;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp90_, ERROR_CODE_MP, _tmp92_, (guint) 0, (guint) 0);
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp93_ = number_get_error ();
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp94_ = _tmp93_;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		number_set_error (NULL);
#line 4399 "equation-parser.c"
	}
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = tmp;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (function_manager);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (name);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 4411 "equation-parser.c"
}


static void function_node_class_init (FunctionNodeClass * klass) {
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	function_node_parent_class = g_type_class_peek_parent (klass);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = function_node_real_solve;
#line 4420 "equation-parser.c"
}


static void function_node_instance_init (FunctionNode * self) {
}


GType function_node_get_type (void) {
	static volatile gsize function_node_type_id__volatile = 0;
	if (g_once_init_enter (&function_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionNode), 0, (GInstanceInitFunc) function_node_instance_init, NULL };
		GType function_node_type_id;
		function_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "FunctionNode", &g_define_type_info, 0);
		g_once_init_leave (&function_node_type_id__volatile, function_node_type_id);
	}
	return function_node_type_id__volatile;
}


UnaryMinusNode* unary_minus_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	UnaryMinusNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (UnaryMinusNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 4460 "equation-parser.c"
}


UnaryMinusNode* unary_minus_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return unary_minus_node_construct (TYPE_UNARY_MINUS_NODE, parser, token, precedence, associativity);
#line 4467 "equation-parser.c"
}


static Number* unary_minus_node_real_solve_r (RNode* base, Number* r) {
	UnaryMinusNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (UnaryMinusNode*) base;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = r;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = number_invert_sign (_tmp0_);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp1_;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 4488 "equation-parser.c"
}


static void unary_minus_node_class_init (UnaryMinusNodeClass * klass) {
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	unary_minus_node_parent_class = g_type_class_peek_parent (klass);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = unary_minus_node_real_solve_r;
#line 4497 "equation-parser.c"
}


static void unary_minus_node_instance_init (UnaryMinusNode * self) {
}


GType unary_minus_node_get_type (void) {
	static volatile gsize unary_minus_node_type_id__volatile = 0;
	if (g_once_init_enter (&unary_minus_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnaryMinusNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unary_minus_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnaryMinusNode), 0, (GInstanceInitFunc) unary_minus_node_instance_init, NULL };
		GType unary_minus_node_type_id;
		unary_minus_node_type_id = g_type_register_static (TYPE_RNODE, "UnaryMinusNode", &g_define_type_info, 0);
		g_once_init_leave (&unary_minus_node_type_id__volatile, unary_minus_node_type_id);
	}
	return unary_minus_node_type_id__volatile;
}


AbsoluteValueNode* absolute_value_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	AbsoluteValueNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (AbsoluteValueNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 4537 "equation-parser.c"
}


AbsoluteValueNode* absolute_value_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return absolute_value_node_construct (TYPE_ABSOLUTE_VALUE_NODE, parser, token, precedence, associativity);
#line 4544 "equation-parser.c"
}


static Number* absolute_value_node_real_solve_r (RNode* base, Number* r) {
	AbsoluteValueNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (AbsoluteValueNode*) base;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = r;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = number_abs (_tmp0_);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp1_;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 4565 "equation-parser.c"
}


static void absolute_value_node_class_init (AbsoluteValueNodeClass * klass) {
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	absolute_value_node_parent_class = g_type_class_peek_parent (klass);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = absolute_value_node_real_solve_r;
#line 4574 "equation-parser.c"
}


static void absolute_value_node_instance_init (AbsoluteValueNode * self) {
}


GType absolute_value_node_get_type (void) {
	static volatile gsize absolute_value_node_type_id__volatile = 0;
	if (g_once_init_enter (&absolute_value_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AbsoluteValueNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) absolute_value_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AbsoluteValueNode), 0, (GInstanceInitFunc) absolute_value_node_instance_init, NULL };
		GType absolute_value_node_type_id;
		absolute_value_node_type_id = g_type_register_static (TYPE_RNODE, "AbsoluteValueNode", &g_define_type_info, 0);
		g_once_init_leave (&absolute_value_node_type_id__volatile, absolute_value_node_type_id);
	}
	return absolute_value_node_type_id__volatile;
}


FloorNode* floor_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	FloorNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FloorNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 4614 "equation-parser.c"
}


FloorNode* floor_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return floor_node_construct (TYPE_FLOOR_NODE, parser, token, precedence, associativity);
#line 4621 "equation-parser.c"
}


static Number* floor_node_real_solve_r (RNode* base, Number* r) {
	FloorNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FloorNode*) base;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = r;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = number_floor (_tmp0_);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp1_;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 4642 "equation-parser.c"
}


static void floor_node_class_init (FloorNodeClass * klass) {
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	floor_node_parent_class = g_type_class_peek_parent (klass);
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = floor_node_real_solve_r;
#line 4651 "equation-parser.c"
}


static void floor_node_instance_init (FloorNode * self) {
}


GType floor_node_get_type (void) {
	static volatile gsize floor_node_type_id__volatile = 0;
	if (g_once_init_enter (&floor_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FloorNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) floor_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FloorNode), 0, (GInstanceInitFunc) floor_node_instance_init, NULL };
		GType floor_node_type_id;
		floor_node_type_id = g_type_register_static (TYPE_RNODE, "FloorNode", &g_define_type_info, 0);
		g_once_init_leave (&floor_node_type_id__volatile, floor_node_type_id);
	}
	return floor_node_type_id__volatile;
}


CeilingNode* ceiling_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	CeilingNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (CeilingNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 4691 "equation-parser.c"
}


CeilingNode* ceiling_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return ceiling_node_construct (TYPE_CEILING_NODE, parser, token, precedence, associativity);
#line 4698 "equation-parser.c"
}


static Number* ceiling_node_real_solve_r (RNode* base, Number* r) {
	CeilingNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (CeilingNode*) base;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = r;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = number_ceiling (_tmp0_);
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp1_;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 4719 "equation-parser.c"
}


static void ceiling_node_class_init (CeilingNodeClass * klass) {
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	ceiling_node_parent_class = g_type_class_peek_parent (klass);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = ceiling_node_real_solve_r;
#line 4728 "equation-parser.c"
}


static void ceiling_node_instance_init (CeilingNode * self) {
}


GType ceiling_node_get_type (void) {
	static volatile gsize ceiling_node_type_id__volatile = 0;
	if (g_once_init_enter (&ceiling_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CeilingNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ceiling_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CeilingNode), 0, (GInstanceInitFunc) ceiling_node_instance_init, NULL };
		GType ceiling_node_type_id;
		ceiling_node_type_id = g_type_register_static (TYPE_RNODE, "CeilingNode", &g_define_type_info, 0);
		g_once_init_leave (&ceiling_node_type_id__volatile, ceiling_node_type_id);
	}
	return ceiling_node_type_id__volatile;
}


FractionalComponentNode* fractional_component_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	FractionalComponentNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FractionalComponentNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 4768 "equation-parser.c"
}


FractionalComponentNode* fractional_component_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return fractional_component_node_construct (TYPE_FRACTIONAL_COMPONENT_NODE, parser, token, precedence, associativity);
#line 4775 "equation-parser.c"
}


static Number* fractional_component_node_real_solve_r (RNode* base, Number* r) {
	FractionalComponentNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FractionalComponentNode*) base;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = r;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = number_fractional_part (_tmp0_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp1_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 4796 "equation-parser.c"
}


static void fractional_component_node_class_init (FractionalComponentNodeClass * klass) {
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	fractional_component_node_parent_class = g_type_class_peek_parent (klass);
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = fractional_component_node_real_solve_r;
#line 4805 "equation-parser.c"
}


static void fractional_component_node_instance_init (FractionalComponentNode * self) {
}


GType fractional_component_node_get_type (void) {
	static volatile gsize fractional_component_node_type_id__volatile = 0;
	if (g_once_init_enter (&fractional_component_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FractionalComponentNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fractional_component_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FractionalComponentNode), 0, (GInstanceInitFunc) fractional_component_node_instance_init, NULL };
		GType fractional_component_node_type_id;
		fractional_component_node_type_id = g_type_register_static (TYPE_RNODE, "FractionalComponentNode", &g_define_type_info, 0);
		g_once_init_leave (&fractional_component_node_type_id__volatile, fractional_component_node_type_id);
	}
	return fractional_component_node_type_id__volatile;
}


RoundNode* round_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	RoundNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (RoundNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 4845 "equation-parser.c"
}


RoundNode* round_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return round_node_construct (TYPE_ROUND_NODE, parser, token, precedence, associativity);
#line 4852 "equation-parser.c"
}


static Number* round_node_real_solve_r (RNode* base, Number* r) {
	RoundNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (RoundNode*) base;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = r;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = number_round (_tmp0_);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp1_;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 4873 "equation-parser.c"
}


static void round_node_class_init (RoundNodeClass * klass) {
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	round_node_parent_class = g_type_class_peek_parent (klass);
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = round_node_real_solve_r;
#line 4882 "equation-parser.c"
}


static void round_node_instance_init (RoundNode * self) {
}


GType round_node_get_type (void) {
	static volatile gsize round_node_type_id__volatile = 0;
	if (g_once_init_enter (&round_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RoundNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) round_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RoundNode), 0, (GInstanceInitFunc) round_node_instance_init, NULL };
		GType round_node_type_id;
		round_node_type_id = g_type_register_static (TYPE_RNODE, "RoundNode", &g_define_type_info, 0);
		g_once_init_leave (&round_node_type_id__volatile, round_node_type_id);
	}
	return round_node_type_id__volatile;
}


PercentNode* percent_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	PercentNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (PercentNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 4922 "equation-parser.c"
}


PercentNode* percent_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return percent_node_construct (TYPE_PERCENT_NODE, parser, token, precedence, associativity);
#line 4929 "equation-parser.c"
}


static Number* percent_node_real_solve_r (RNode* base, Number* r) {
	PercentNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (PercentNode*) base;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = r;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = number_divide_integer (_tmp0_, (gint64) 100);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp1_;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 4950 "equation-parser.c"
}


static void percent_node_class_init (PercentNodeClass * klass) {
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	percent_node_parent_class = g_type_class_peek_parent (klass);
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = percent_node_real_solve_r;
#line 4959 "equation-parser.c"
}


static void percent_node_instance_init (PercentNode * self) {
}


GType percent_node_get_type (void) {
	static volatile gsize percent_node_type_id__volatile = 0;
	if (g_once_init_enter (&percent_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PercentNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) percent_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PercentNode), 0, (GInstanceInitFunc) percent_node_instance_init, NULL };
		GType percent_node_type_id;
		percent_node_type_id = g_type_register_static (TYPE_RNODE, "PercentNode", &g_define_type_info, 0);
		g_once_init_leave (&percent_node_type_id__volatile, percent_node_type_id);
	}
	return percent_node_type_id__volatile;
}


FactorialNode* factorial_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	FactorialNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FactorialNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 4999 "equation-parser.c"
}


FactorialNode* factorial_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return factorial_node_construct (TYPE_FACTORIAL_NODE, parser, token, precedence, associativity);
#line 5006 "equation-parser.c"
}


static Number* factorial_node_real_solve_r (RNode* base, Number* r) {
	FactorialNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (FactorialNode*) base;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = r;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = number_factorial (_tmp0_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp1_;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 5027 "equation-parser.c"
}


static void factorial_node_class_init (FactorialNodeClass * klass) {
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	factorial_node_parent_class = g_type_class_peek_parent (klass);
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = factorial_node_real_solve_r;
#line 5036 "equation-parser.c"
}


static void factorial_node_instance_init (FactorialNode * self) {
}


GType factorial_node_get_type (void) {
	static volatile gsize factorial_node_type_id__volatile = 0;
	if (g_once_init_enter (&factorial_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FactorialNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) factorial_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FactorialNode), 0, (GInstanceInitFunc) factorial_node_instance_init, NULL };
		GType factorial_node_type_id;
		factorial_node_type_id = g_type_register_static (TYPE_RNODE, "FactorialNode", &g_define_type_info, 0);
		g_once_init_leave (&factorial_node_type_id__volatile, factorial_node_type_id);
	}
	return factorial_node_type_id__volatile;
}


AddNode* add_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	AddNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (AddNode*) lr_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 5076 "equation-parser.c"
}


AddNode* add_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return add_node_construct (TYPE_ADD_NODE, parser, token, precedence, associativity);
#line 5083 "equation-parser.c"
}


static Number* add_node_real_solve_lr (LRNode* base, Number* l, Number* r) {
	AddNode * self;
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (AddNode*) base;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->do_percentage;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp0_) {
#line 5101 "equation-parser.c"
		Number* per = NULL;
		Number* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp1_ = r;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = number_new_integer ((gint64) 100);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = _tmp2_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = number_add (_tmp1_, _tmp3_);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = _tmp4_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (_tmp3_);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		per = _tmp5_;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = per;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = number_divide_integer (_tmp6_, (gint64) 100);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (per);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		per = _tmp7_;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = l;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = per;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = _tmp10_;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (per);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 5147 "equation-parser.c"
	} else {
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = l;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = r;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = number_add (_tmp11_, _tmp12_);
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = _tmp13_;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 5162 "equation-parser.c"
	}
}


static void add_node_class_init (AddNodeClass * klass) {
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	add_node_parent_class = g_type_class_peek_parent (klass);
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = add_node_real_solve_lr;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	G_OBJECT_CLASS (klass)->finalize = add_node_finalize;
#line 5174 "equation-parser.c"
}


static void add_node_instance_init (AddNode * self) {
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->do_percentage = FALSE;
#line 5181 "equation-parser.c"
}


static void add_node_finalize (GObject* obj) {
	AddNode * self;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADD_NODE, AddNode);
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	G_OBJECT_CLASS (add_node_parent_class)->finalize (obj);
#line 5191 "equation-parser.c"
}


GType add_node_get_type (void) {
	static volatile gsize add_node_type_id__volatile = 0;
	if (g_once_init_enter (&add_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AddNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) add_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AddNode), 0, (GInstanceInitFunc) add_node_instance_init, NULL };
		GType add_node_type_id;
		add_node_type_id = g_type_register_static (TYPE_LR_NODE, "AddNode", &g_define_type_info, 0);
		g_once_init_leave (&add_node_type_id__volatile, add_node_type_id);
	}
	return add_node_type_id__volatile;
}


SubtractNode* subtract_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	SubtractNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (SubtractNode*) lr_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 5227 "equation-parser.c"
}


SubtractNode* subtract_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return subtract_node_construct (TYPE_SUBTRACT_NODE, parser, token, precedence, associativity);
#line 5234 "equation-parser.c"
}


static Number* subtract_node_real_solve_lr (LRNode* base, Number* l, Number* r) {
	SubtractNode * self;
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (SubtractNode*) base;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->do_percentage;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp0_) {
#line 5252 "equation-parser.c"
		Number* per = NULL;
		Number* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp1_ = r;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = number_new_integer ((gint64) (-100));
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = _tmp2_;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = number_add (_tmp1_, _tmp3_);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = _tmp4_;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (_tmp3_);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		per = _tmp5_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = per;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = number_divide_integer (_tmp6_, (gint64) (-100));
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (per);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		per = _tmp7_;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = l;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = per;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = _tmp10_;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (per);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 5298 "equation-parser.c"
	} else {
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = l;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = r;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = number_subtract (_tmp11_, _tmp12_);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = _tmp13_;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 5313 "equation-parser.c"
	}
}


static void subtract_node_class_init (SubtractNodeClass * klass) {
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	subtract_node_parent_class = g_type_class_peek_parent (klass);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = subtract_node_real_solve_lr;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	G_OBJECT_CLASS (klass)->finalize = subtract_node_finalize;
#line 5325 "equation-parser.c"
}


static void subtract_node_instance_init (SubtractNode * self) {
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->do_percentage = FALSE;
#line 5332 "equation-parser.c"
}


static void subtract_node_finalize (GObject* obj) {
	SubtractNode * self;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUBTRACT_NODE, SubtractNode);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	G_OBJECT_CLASS (subtract_node_parent_class)->finalize (obj);
#line 5342 "equation-parser.c"
}


GType subtract_node_get_type (void) {
	static volatile gsize subtract_node_type_id__volatile = 0;
	if (g_once_init_enter (&subtract_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SubtractNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) subtract_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SubtractNode), 0, (GInstanceInitFunc) subtract_node_instance_init, NULL };
		GType subtract_node_type_id;
		subtract_node_type_id = g_type_register_static (TYPE_LR_NODE, "SubtractNode", &g_define_type_info, 0);
		g_once_init_leave (&subtract_node_type_id__volatile, subtract_node_type_id);
	}
	return subtract_node_type_id__volatile;
}


MultiplyNode* multiply_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	MultiplyNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (MultiplyNode*) lr_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 5378 "equation-parser.c"
}


MultiplyNode* multiply_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return multiply_node_construct (TYPE_MULTIPLY_NODE, parser, token, precedence, associativity);
#line 5385 "equation-parser.c"
}


static Number* multiply_node_real_solve_lr (LRNode* base, Number* l, Number* r) {
	MultiplyNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (MultiplyNode*) base;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = l;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = r;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = number_multiply (_tmp0_, _tmp1_);
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp2_;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 5411 "equation-parser.c"
}


static void multiply_node_class_init (MultiplyNodeClass * klass) {
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	multiply_node_parent_class = g_type_class_peek_parent (klass);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = multiply_node_real_solve_lr;
#line 5420 "equation-parser.c"
}


static void multiply_node_instance_init (MultiplyNode * self) {
}


GType multiply_node_get_type (void) {
	static volatile gsize multiply_node_type_id__volatile = 0;
	if (g_once_init_enter (&multiply_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MultiplyNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multiply_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultiplyNode), 0, (GInstanceInitFunc) multiply_node_instance_init, NULL };
		GType multiply_node_type_id;
		multiply_node_type_id = g_type_register_static (TYPE_LR_NODE, "MultiplyNode", &g_define_type_info, 0);
		g_once_init_leave (&multiply_node_type_id__volatile, multiply_node_type_id);
	}
	return multiply_node_type_id__volatile;
}


DivideNode* divide_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	DivideNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (DivideNode*) lr_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 5460 "equation-parser.c"
}


DivideNode* divide_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return divide_node_construct (TYPE_DIVIDE_NODE, parser, token, precedence, associativity);
#line 5467 "equation-parser.c"
}


static Number* divide_node_real_solve_lr (LRNode* base, Number* l, Number* r) {
	DivideNode * self;
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (DivideNode*) base;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = l;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = r;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = number_divide (_tmp0_, _tmp1_);
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	z = _tmp2_;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = number_get_error ();
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = _tmp3_;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp4_ != NULL) {
#line 5500 "equation-parser.c"
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp5_ = NULL;
		ParseNode* _tmp6_ = NULL;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp7_ = NULL;
		ParseNode* _tmp8_ = NULL;
		Parser* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		ParseNode* _tmp22_ = NULL;
		LexerToken* _tmp23_ = NULL;
		guint _tmp24_ = 0U;
		ParseNode* _tmp25_ = NULL;
		LexerToken* _tmp26_ = NULL;
		guint _tmp27_ = 0U;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = ((ParseNode*) self)->right;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmpleft = _tmp6_;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = ((ParseNode*) self)->right;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmpright = _tmp8_;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 5532 "equation-parser.c"
			ParseNode* _tmp9_ = NULL;
			ParseNode* _tmp10_ = NULL;
			ParseNode* _tmp11_ = NULL;
			ParseNode* _tmp12_ = NULL;
			ParseNode* _tmp13_ = NULL;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp9_ = tmpleft;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp10_ = _tmp9_->left;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp10_ != NULL)) {
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 5546 "equation-parser.c"
			}
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp11_ = tmpleft;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp12_ = _tmp11_->left;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp13_ = _g_object_ref0 (_tmp12_);
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpleft);
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpleft = _tmp13_;
#line 5558 "equation-parser.c"
		}
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 5562 "equation-parser.c"
			ParseNode* _tmp14_ = NULL;
			ParseNode* _tmp15_ = NULL;
			ParseNode* _tmp16_ = NULL;
			ParseNode* _tmp17_ = NULL;
			ParseNode* _tmp18_ = NULL;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp14_ = tmpright;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp15_ = _tmp14_->right;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp15_ != NULL)) {
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 5576 "equation-parser.c"
			}
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp16_ = tmpright;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp17_ = _tmp16_->right;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp18_ = _g_object_ref0 (_tmp17_);
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpright);
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpright = _tmp18_;
#line 5588 "equation-parser.c"
		}
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp19_ = ((ParseNode*) self)->parser;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp20_ = number_get_error ();
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp21_ = _tmp20_;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp22_ = tmpleft;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp23_ = _tmp22_->token;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp24_ = _tmp23_->start_index;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp25_ = tmpright;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp26_ = _tmp25_->token;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp27_ = _tmp26_->end_index;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp19_, ERROR_CODE_MP, _tmp21_, _tmp24_, _tmp27_);
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp28_ = number_get_error ();
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp29_ = _tmp28_;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		number_set_error (NULL);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmpright);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmpleft);
#line 5620 "equation-parser.c"
	}
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = z;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 5626 "equation-parser.c"
}


static void divide_node_class_init (DivideNodeClass * klass) {
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	divide_node_parent_class = g_type_class_peek_parent (klass);
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = divide_node_real_solve_lr;
#line 5635 "equation-parser.c"
}


static void divide_node_instance_init (DivideNode * self) {
}


GType divide_node_get_type (void) {
	static volatile gsize divide_node_type_id__volatile = 0;
	if (g_once_init_enter (&divide_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DivideNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) divide_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DivideNode), 0, (GInstanceInitFunc) divide_node_instance_init, NULL };
		GType divide_node_type_id;
		divide_node_type_id = g_type_register_static (TYPE_LR_NODE, "DivideNode", &g_define_type_info, 0);
		g_once_init_leave (&divide_node_type_id__volatile, divide_node_type_id);
	}
	return divide_node_type_id__volatile;
}


ModulusDivideNode* modulus_divide_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	ModulusDivideNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ModulusDivideNode*) lr_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 5675 "equation-parser.c"
}


ModulusDivideNode* modulus_divide_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return modulus_divide_node_construct (TYPE_MODULUS_DIVIDE_NODE, parser, token, precedence, associativity);
#line 5682 "equation-parser.c"
}


static Number* modulus_divide_node_real_solve (ParseNode* base) {
	ModulusDivideNode * self;
	Number* result = NULL;
	ParseNode* _tmp0_ = NULL;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ModulusDivideNode*) base;
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = ((ParseNode*) self)->left;
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_XPOW_YNODE)) {
#line 5696 "equation-parser.c"
		Number* base_value = NULL;
		ParseNode* _tmp1_ = NULL;
		ParseNode* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		Number* exponent = NULL;
		ParseNode* _tmp4_ = NULL;
		ParseNode* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* mod = NULL;
		ParseNode* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		Number* _tmp11_ = NULL;
		Number* z = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp1_ = ((ParseNode*) self)->left;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = _tmp1_->left;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = parse_node_solve (_tmp2_);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		base_value = _tmp3_;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = ((ParseNode*) self)->left;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = _tmp4_->right;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = parse_node_solve (_tmp5_);
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		exponent = _tmp6_;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = ((ParseNode*) self)->right;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = parse_node_solve (_tmp7_);
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		mod = _tmp8_;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = base_value;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp11_ == NULL) {
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp10_ = TRUE;
#line 5746 "equation-parser.c"
		} else {
			Number* _tmp12_ = NULL;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp12_ = exponent;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp10_ = _tmp12_ == NULL;
#line 5753 "equation-parser.c"
		}
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp10_) {
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp9_ = TRUE;
#line 5759 "equation-parser.c"
		} else {
			Number* _tmp13_ = NULL;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp13_ = mod;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp9_ = _tmp13_ == NULL;
#line 5766 "equation-parser.c"
		}
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp9_) {
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = NULL;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (mod);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (exponent);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (base_value);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 5780 "equation-parser.c"
		}
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = base_value;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = exponent;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp16_ = mod;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp17_ = number_modular_exponentiation (_tmp14_, _tmp15_, _tmp16_);
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		z = _tmp17_;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		number_check_flags ();
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp18_ = number_get_error ();
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp19_ = _tmp18_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp19_ != NULL) {
#line 5800 "equation-parser.c"
			ParseNode* tmpleft = NULL;
			ParseNode* _tmp20_ = NULL;
			ParseNode* _tmp21_ = NULL;
			ParseNode* tmpright = NULL;
			ParseNode* _tmp22_ = NULL;
			ParseNode* _tmp23_ = NULL;
			Parser* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			ParseNode* _tmp37_ = NULL;
			LexerToken* _tmp38_ = NULL;
			guint _tmp39_ = 0U;
			ParseNode* _tmp40_ = NULL;
			LexerToken* _tmp41_ = NULL;
			guint _tmp42_ = 0U;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp20_ = ((ParseNode*) self)->left;
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp21_ = _g_object_ref0 (_tmp20_);
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpleft = _tmp21_;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp22_ = ((ParseNode*) self)->right;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp23_ = _g_object_ref0 (_tmp22_);
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpright = _tmp23_;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			while (TRUE) {
#line 5832 "equation-parser.c"
				ParseNode* _tmp24_ = NULL;
				ParseNode* _tmp25_ = NULL;
				ParseNode* _tmp26_ = NULL;
				ParseNode* _tmp27_ = NULL;
				ParseNode* _tmp28_ = NULL;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp24_ = tmpleft;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp25_ = _tmp24_->left;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (!(_tmp25_ != NULL)) {
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					break;
#line 5846 "equation-parser.c"
				}
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp26_ = tmpleft;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp27_ = _tmp26_->left;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp28_ = _g_object_ref0 (_tmp27_);
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (tmpleft);
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				tmpleft = _tmp28_;
#line 5858 "equation-parser.c"
			}
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			while (TRUE) {
#line 5862 "equation-parser.c"
				ParseNode* _tmp29_ = NULL;
				ParseNode* _tmp30_ = NULL;
				ParseNode* _tmp31_ = NULL;
				ParseNode* _tmp32_ = NULL;
				ParseNode* _tmp33_ = NULL;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp29_ = tmpright;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp30_ = _tmp29_->right;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (!(_tmp30_ != NULL)) {
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					break;
#line 5876 "equation-parser.c"
				}
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp31_ = tmpright;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp32_ = _tmp31_->right;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp33_ = _g_object_ref0 (_tmp32_);
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (tmpright);
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				tmpright = _tmp33_;
#line 5888 "equation-parser.c"
			}
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp34_ = ((ParseNode*) self)->parser;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp35_ = number_get_error ();
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp36_ = _tmp35_;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp37_ = tmpleft;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp38_ = _tmp37_->token;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp39_ = _tmp38_->start_index;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp40_ = tmpright;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp41_ = _tmp40_->token;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp42_ = _tmp41_->end_index;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_set_error (_tmp34_, ERROR_CODE_MP, _tmp36_, _tmp39_, _tmp42_);
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp43_ = number_get_error ();
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp44_ = _tmp43_;
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			number_set_error (NULL);
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpright);
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpleft);
#line 5920 "equation-parser.c"
		}
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = z;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (mod);
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (exponent);
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (base_value);
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 5932 "equation-parser.c"
	} else {
		Number* l = NULL;
		ParseNode* _tmp45_ = NULL;
		Number* _tmp46_ = NULL;
		Number* r = NULL;
		ParseNode* _tmp47_ = NULL;
		Number* _tmp48_ = NULL;
		gboolean _tmp49_ = FALSE;
		Number* _tmp50_ = NULL;
		Number* z = NULL;
		Number* _tmp52_ = NULL;
		Number* _tmp53_ = NULL;
		Number* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp45_ = ((ParseNode*) self)->left;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp46_ = parse_node_solve (_tmp45_);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		l = _tmp46_;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp47_ = ((ParseNode*) self)->right;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp48_ = parse_node_solve (_tmp47_);
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		r = _tmp48_;
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp50_ = l;
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp50_ == NULL) {
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp49_ = TRUE;
#line 5966 "equation-parser.c"
		} else {
			Number* _tmp51_ = NULL;
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp51_ = r;
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp49_ = _tmp51_ == NULL;
#line 5973 "equation-parser.c"
		}
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp49_) {
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = NULL;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (r);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (l);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 5985 "equation-parser.c"
		}
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp52_ = l;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp53_ = r;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp54_ = lr_node_solve_lr ((LRNode*) self, _tmp52_, _tmp53_);
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		z = _tmp54_;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		number_check_flags ();
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp55_ = number_get_error ();
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp56_ = _tmp55_;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp56_ != NULL) {
#line 6003 "equation-parser.c"
			ParseNode* tmpleft = NULL;
			ParseNode* _tmp57_ = NULL;
			ParseNode* _tmp58_ = NULL;
			ParseNode* tmpright = NULL;
			ParseNode* _tmp59_ = NULL;
			ParseNode* _tmp60_ = NULL;
			Parser* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
			const gchar* _tmp73_ = NULL;
			ParseNode* _tmp74_ = NULL;
			LexerToken* _tmp75_ = NULL;
			guint _tmp76_ = 0U;
			ParseNode* _tmp77_ = NULL;
			LexerToken* _tmp78_ = NULL;
			guint _tmp79_ = 0U;
			const gchar* _tmp80_ = NULL;
			const gchar* _tmp81_ = NULL;
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp57_ = ((ParseNode*) self)->left;
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp58_ = _g_object_ref0 (_tmp57_);
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpleft = _tmp58_;
#line 636 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp59_ = ((ParseNode*) self)->right;
#line 636 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp60_ = _g_object_ref0 (_tmp59_);
#line 636 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpright = _tmp60_;
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			while (TRUE) {
#line 6035 "equation-parser.c"
				ParseNode* _tmp61_ = NULL;
				ParseNode* _tmp62_ = NULL;
				ParseNode* _tmp63_ = NULL;
				ParseNode* _tmp64_ = NULL;
				ParseNode* _tmp65_ = NULL;
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp61_ = tmpleft;
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp62_ = _tmp61_->left;
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (!(_tmp62_ != NULL)) {
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					break;
#line 6049 "equation-parser.c"
				}
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp63_ = tmpleft;
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp64_ = _tmp63_->left;
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp65_ = _g_object_ref0 (_tmp64_);
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (tmpleft);
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				tmpleft = _tmp65_;
#line 6061 "equation-parser.c"
			}
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			while (TRUE) {
#line 6065 "equation-parser.c"
				ParseNode* _tmp66_ = NULL;
				ParseNode* _tmp67_ = NULL;
				ParseNode* _tmp68_ = NULL;
				ParseNode* _tmp69_ = NULL;
				ParseNode* _tmp70_ = NULL;
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp66_ = tmpright;
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp67_ = _tmp66_->right;
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (!(_tmp67_ != NULL)) {
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					break;
#line 6079 "equation-parser.c"
				}
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp68_ = tmpright;
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp69_ = _tmp68_->right;
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp70_ = _g_object_ref0 (_tmp69_);
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (tmpright);
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				tmpright = _tmp70_;
#line 6091 "equation-parser.c"
			}
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp71_ = ((ParseNode*) self)->parser;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp72_ = number_get_error ();
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp73_ = _tmp72_;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp74_ = tmpleft;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp75_ = _tmp74_->token;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp76_ = _tmp75_->start_index;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp77_ = tmpright;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp78_ = _tmp77_->token;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp79_ = _tmp78_->end_index;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_set_error (_tmp71_, ERROR_CODE_MP, _tmp73_, _tmp76_, _tmp79_);
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp80_ = number_get_error ();
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp81_ = _tmp80_;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			number_set_error (NULL);
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpright);
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpleft);
#line 6123 "equation-parser.c"
		}
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = z;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (r);
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (l);
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 6133 "equation-parser.c"
	}
}


static Number* modulus_divide_node_real_solve_lr (LRNode* base, Number* l, Number* r) {
	ModulusDivideNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ModulusDivideNode*) base;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = l;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = r;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = number_modulus_divide (_tmp0_, _tmp1_);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp2_;
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 6160 "equation-parser.c"
}


static void modulus_divide_node_class_init (ModulusDivideNodeClass * klass) {
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	modulus_divide_node_parent_class = g_type_class_peek_parent (klass);
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = modulus_divide_node_real_solve;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = modulus_divide_node_real_solve_lr;
#line 6171 "equation-parser.c"
}


static void modulus_divide_node_instance_init (ModulusDivideNode * self) {
}


GType modulus_divide_node_get_type (void) {
	static volatile gsize modulus_divide_node_type_id__volatile = 0;
	if (g_once_init_enter (&modulus_divide_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ModulusDivideNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) modulus_divide_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ModulusDivideNode), 0, (GInstanceInitFunc) modulus_divide_node_instance_init, NULL };
		GType modulus_divide_node_type_id;
		modulus_divide_node_type_id = g_type_register_static (TYPE_LR_NODE, "ModulusDivideNode", &g_define_type_info, 0);
		g_once_init_leave (&modulus_divide_node_type_id__volatile, modulus_divide_node_type_id);
	}
	return modulus_divide_node_type_id__volatile;
}


RootNode* root_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, gint n) {
	RootNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (RootNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = n;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->n = _tmp4_;
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 6216 "equation-parser.c"
}


RootNode* root_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, gint n) {
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return root_node_construct (TYPE_ROOT_NODE, parser, token, precedence, associativity, n);
#line 6223 "equation-parser.c"
}


static Number* root_node_real_solve_r (RNode* base, Number* r) {
	RootNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (RootNode*) base;
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = r;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = self->priv->n;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = number_root (_tmp0_, (gint64) _tmp1_);
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp2_;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 6247 "equation-parser.c"
}


static void root_node_class_init (RootNodeClass * klass) {
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	root_node_parent_class = g_type_class_peek_parent (klass);
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_type_class_add_private (klass, sizeof (RootNodePrivate));
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = root_node_real_solve_r;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	G_OBJECT_CLASS (klass)->finalize = root_node_finalize;
#line 6260 "equation-parser.c"
}


static void root_node_instance_init (RootNode * self) {
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv = ROOT_NODE_GET_PRIVATE (self);
#line 6267 "equation-parser.c"
}


static void root_node_finalize (GObject* obj) {
	RootNode * self;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ROOT_NODE, RootNode);
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	G_OBJECT_CLASS (root_node_parent_class)->finalize (obj);
#line 6277 "equation-parser.c"
}


GType root_node_get_type (void) {
	static volatile gsize root_node_type_id__volatile = 0;
	if (g_once_init_enter (&root_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RootNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) root_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RootNode), 0, (GInstanceInitFunc) root_node_instance_init, NULL };
		GType root_node_type_id;
		root_node_type_id = g_type_register_static (TYPE_RNODE, "RootNode", &g_define_type_info, 0);
		g_once_init_leave (&root_node_type_id__volatile, root_node_type_id);
	}
	return root_node_type_id__volatile;
}


XPowYNode* xpow_ynode_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	XPowYNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (XPowYNode*) lr_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 6313 "equation-parser.c"
}


XPowYNode* xpow_ynode_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return xpow_ynode_construct (TYPE_XPOW_YNODE, parser, token, precedence, associativity);
#line 6320 "equation-parser.c"
}


static Number* xpow_ynode_real_solve_lr (LRNode* base, Number* l, Number* r) {
	XPowYNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (XPowYNode*) base;
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = l;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = r;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = number_xpowy (_tmp0_, _tmp1_);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp2_;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 6346 "equation-parser.c"
}


static void xpow_ynode_class_init (XPowYNodeClass * klass) {
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	xpow_ynode_parent_class = g_type_class_peek_parent (klass);
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = xpow_ynode_real_solve_lr;
#line 6355 "equation-parser.c"
}


static void xpow_ynode_instance_init (XPowYNode * self) {
}


GType xpow_ynode_get_type (void) {
	static volatile gsize xpow_ynode_type_id__volatile = 0;
	if (g_once_init_enter (&xpow_ynode_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XPowYNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xpow_ynode_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XPowYNode), 0, (GInstanceInitFunc) xpow_ynode_instance_init, NULL };
		GType xpow_ynode_type_id;
		xpow_ynode_type_id = g_type_register_static (TYPE_LR_NODE, "XPowYNode", &g_define_type_info, 0);
		g_once_init_leave (&xpow_ynode_type_id__volatile, xpow_ynode_type_id);
	}
	return xpow_ynode_type_id__volatile;
}


XPowYIntegerNode* xpow_yinteger_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	XPowYIntegerNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (XPowYIntegerNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL);
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 6395 "equation-parser.c"
}


XPowYIntegerNode* xpow_yinteger_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return xpow_yinteger_node_construct (TYPE_XPOW_YINTEGER_NODE, parser, token, precedence, associativity);
#line 6402 "equation-parser.c"
}


static Number* xpow_yinteger_node_real_solve (ParseNode* base) {
	XPowYIntegerNode * self;
	Number* result = NULL;
	Number* val = NULL;
	ParseNode* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint64 pow = 0LL;
	ParseNode* _tmp8_ = NULL;
	LexerToken* _tmp9_ = NULL;
	Number* _tmp18_ = NULL;
	Number* z = NULL;
	Number* _tmp19_ = NULL;
	gint64 _tmp20_ = 0LL;
	Number* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (XPowYIntegerNode*) base;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = ((ParseNode*) self)->left;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = parse_node_solve (_tmp0_);
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	val = _tmp1_;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = val;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp2_ == NULL) {
#line 6435 "equation-parser.c"
		ParseNode* _tmp3_ = NULL;
		LexerToken* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		Number* _tmp7_ = NULL;
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = ((ParseNode*) self)->left;
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = _tmp3_->token;
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = _tmp4_->text;
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = super_atoi (_tmp5_);
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (val);
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		val = _tmp7_;
#line 6455 "equation-parser.c"
	}
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp8_ = ((ParseNode*) self)->right;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = _tmp8_->token;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp9_ != NULL) {
#line 6463 "equation-parser.c"
		ParseNode* _tmp10_ = NULL;
		LexerToken* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = ((ParseNode*) self)->right;
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = _tmp10_->token;
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = _tmp11_->text;
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = super_atoi (_tmp12_);
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		pow = (gint64) _tmp13_;
#line 6478 "equation-parser.c"
	} else {
		ParseNode* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		gint64 _tmp17_ = 0LL;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = ((ParseNode*) self)->right;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = parse_node_solve (_tmp14_);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp16_ = _tmp15_;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp17_ = number_to_integer (_tmp16_);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		pow = _tmp17_;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (_tmp16_);
#line 6496 "equation-parser.c"
	}
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp18_ = val;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp18_ == NULL) {
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = NULL;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (val);
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 6508 "equation-parser.c"
	}
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp19_ = val;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp20_ = pow;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp21_ = number_xpowy_integer (_tmp19_, _tmp20_);
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	z = _tmp21_;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	number_check_flags ();
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp22_ = number_get_error ();
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp23_ = _tmp22_;
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp23_ != NULL) {
#line 6526 "equation-parser.c"
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp24_ = NULL;
		ParseNode* _tmp25_ = NULL;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp26_ = NULL;
		ParseNode* _tmp27_ = NULL;
		Parser* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		ParseNode* _tmp41_ = NULL;
		LexerToken* _tmp42_ = NULL;
		guint _tmp43_ = 0U;
		ParseNode* _tmp44_ = NULL;
		LexerToken* _tmp45_ = NULL;
		guint _tmp46_ = 0U;
		const gchar* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
#line 718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp24_ = ((ParseNode*) self)->left;
#line 718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp25_ = _g_object_ref0 (_tmp24_);
#line 718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmpleft = _tmp25_;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp26_ = ((ParseNode*) self)->right;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp27_ = _g_object_ref0 (_tmp26_);
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmpright = _tmp27_;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 6558 "equation-parser.c"
			ParseNode* _tmp28_ = NULL;
			ParseNode* _tmp29_ = NULL;
			ParseNode* _tmp30_ = NULL;
			ParseNode* _tmp31_ = NULL;
			ParseNode* _tmp32_ = NULL;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp28_ = tmpleft;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp29_ = _tmp28_->left;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp29_ != NULL)) {
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 6572 "equation-parser.c"
			}
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp30_ = tmpleft;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp31_ = _tmp30_->left;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp32_ = _g_object_ref0 (_tmp31_);
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpleft);
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpleft = _tmp32_;
#line 6584 "equation-parser.c"
		}
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 6588 "equation-parser.c"
			ParseNode* _tmp33_ = NULL;
			ParseNode* _tmp34_ = NULL;
			ParseNode* _tmp35_ = NULL;
			ParseNode* _tmp36_ = NULL;
			ParseNode* _tmp37_ = NULL;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp33_ = tmpright;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp34_ = _tmp33_->right;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp34_ != NULL)) {
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 6602 "equation-parser.c"
			}
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp35_ = tmpright;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp36_ = _tmp35_->right;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp37_ = _g_object_ref0 (_tmp36_);
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (tmpright);
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			tmpright = _tmp37_;
#line 6614 "equation-parser.c"
		}
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp38_ = ((ParseNode*) self)->parser;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp39_ = number_get_error ();
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp40_ = _tmp39_;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp41_ = tmpleft;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp42_ = _tmp41_->token;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp43_ = _tmp42_->start_index;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp44_ = tmpright;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp45_ = _tmp44_->token;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp46_ = _tmp45_->end_index;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp38_, ERROR_CODE_MP, _tmp40_, _tmp43_, _tmp46_);
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp47_ = number_get_error ();
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp48_ = _tmp47_;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		number_set_error (NULL);
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmpright);
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmpleft);
#line 6646 "equation-parser.c"
	}
#line 726 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = z;
#line 726 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (val);
#line 726 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 6654 "equation-parser.c"
}


static void xpow_yinteger_node_class_init (XPowYIntegerNodeClass * klass) {
#line 685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	xpow_yinteger_node_parent_class = g_type_class_peek_parent (klass);
#line 685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = xpow_yinteger_node_real_solve;
#line 6663 "equation-parser.c"
}


static void xpow_yinteger_node_instance_init (XPowYIntegerNode * self) {
}


/**
 * This class is a XPowY in which the right token is an nsup number.
 */
GType xpow_yinteger_node_get_type (void) {
	static volatile gsize xpow_yinteger_node_type_id__volatile = 0;
	if (g_once_init_enter (&xpow_yinteger_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XPowYIntegerNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xpow_yinteger_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XPowYIntegerNode), 0, (GInstanceInitFunc) xpow_yinteger_node_instance_init, NULL };
		GType xpow_yinteger_node_type_id;
		xpow_yinteger_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "XPowYIntegerNode", &g_define_type_info, 0);
		g_once_init_leave (&xpow_yinteger_node_type_id__volatile, xpow_yinteger_node_type_id);
	}
	return xpow_yinteger_node_type_id__volatile;
}


NotNode* not_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	NotNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (NotNode*) rnode_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 6706 "equation-parser.c"
}


NotNode* not_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return not_node_construct (TYPE_NOT_NODE, parser, token, precedence, associativity);
#line 6713 "equation-parser.c"
}


static Number* not_node_real_solve_r (RNode* base, Number* r) {
	NotNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Parser* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	Number* _tmp6_ = NULL;
	Parser* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Number* _tmp9_ = NULL;
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (NotNode*) base;
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = r;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = ((ParseNode*) self)->parser;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = _tmp1_->wordlen;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = mp_is_overflow (_tmp0_, _tmp2_);
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (!_tmp3_) {
#line 6742 "equation-parser.c"
		Parser* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = ((ParseNode*) self)->parser;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp4_, ERROR_CODE_OVERFLOW, NULL, (guint) 0, (guint) 0);
#line 742 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = number_new_integer ((gint64) 0);
#line 742 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = _tmp5_;
#line 742 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 6755 "equation-parser.c"
	}
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = r;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp7_ = ((ParseNode*) self)->parser;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp8_ = _tmp7_->wordlen;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = number_not (_tmp6_, _tmp8_);
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp9_;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 6769 "equation-parser.c"
}


static void not_node_class_init (NotNodeClass * klass) {
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	not_node_parent_class = g_type_class_peek_parent (klass);
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((RNodeClass *) klass)->solve_r = not_node_real_solve_r;
#line 6778 "equation-parser.c"
}


static void not_node_instance_init (NotNode * self) {
}


GType not_node_get_type (void) {
	static volatile gsize not_node_type_id__volatile = 0;
	if (g_once_init_enter (&not_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) not_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotNode), 0, (GInstanceInitFunc) not_node_instance_init, NULL };
		GType not_node_type_id;
		not_node_type_id = g_type_register_static (TYPE_RNODE, "NotNode", &g_define_type_info, 0);
		g_once_init_leave (&not_node_type_id__volatile, not_node_type_id);
	}
	return not_node_type_id__volatile;
}


AndNode* and_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	AndNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (AndNode*) lr_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 6818 "equation-parser.c"
}


AndNode* and_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return and_node_construct (TYPE_AND_NODE, parser, token, precedence, associativity);
#line 6825 "equation-parser.c"
}


static Number* and_node_real_solve_lr (LRNode* base, Number* l, Number* r) {
	AndNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (AndNode*) base;
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = l;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = r;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = number_and (_tmp0_, _tmp1_);
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp2_;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 6851 "equation-parser.c"
}


static void and_node_class_init (AndNodeClass * klass) {
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	and_node_parent_class = g_type_class_peek_parent (klass);
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = and_node_real_solve_lr;
#line 6860 "equation-parser.c"
}


static void and_node_instance_init (AndNode * self) {
}


GType and_node_get_type (void) {
	static volatile gsize and_node_type_id__volatile = 0;
	if (g_once_init_enter (&and_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AndNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) and_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AndNode), 0, (GInstanceInitFunc) and_node_instance_init, NULL };
		GType and_node_type_id;
		and_node_type_id = g_type_register_static (TYPE_LR_NODE, "AndNode", &g_define_type_info, 0);
		g_once_init_leave (&and_node_type_id__volatile, and_node_type_id);
	}
	return and_node_type_id__volatile;
}


OrNode* or_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	OrNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (OrNode*) lr_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 6900 "equation-parser.c"
}


OrNode* or_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return or_node_construct (TYPE_OR_NODE, parser, token, precedence, associativity);
#line 6907 "equation-parser.c"
}


static Number* or_node_real_solve_lr (LRNode* base, Number* l, Number* r) {
	OrNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (OrNode*) base;
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = l;
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = r;
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = number_or (_tmp0_, _tmp1_);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp2_;
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 6933 "equation-parser.c"
}


static void or_node_class_init (OrNodeClass * klass) {
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	or_node_parent_class = g_type_class_peek_parent (klass);
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = or_node_real_solve_lr;
#line 6942 "equation-parser.c"
}


static void or_node_instance_init (OrNode * self) {
}


GType or_node_get_type (void) {
	static volatile gsize or_node_type_id__volatile = 0;
	if (g_once_init_enter (&or_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (OrNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) or_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OrNode), 0, (GInstanceInitFunc) or_node_instance_init, NULL };
		GType or_node_type_id;
		or_node_type_id = g_type_register_static (TYPE_LR_NODE, "OrNode", &g_define_type_info, 0);
		g_once_init_leave (&or_node_type_id__volatile, or_node_type_id);
	}
	return or_node_type_id__volatile;
}


XorNode* xor_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	XorNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (XorNode*) lr_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 6982 "equation-parser.c"
}


XorNode* xor_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return xor_node_construct (TYPE_XOR_NODE, parser, token, precedence, associativity);
#line 6989 "equation-parser.c"
}


static Number* xor_node_real_solve_lr (LRNode* base, Number* l, Number* r) {
	XorNode * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
#line 782 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (XorNode*) base;
#line 782 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 782 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = l;
#line 784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = r;
#line 784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = number_xor (_tmp0_, _tmp1_);
#line 784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp2_;
#line 784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 7015 "equation-parser.c"
}


static void xor_node_class_init (XorNodeClass * klass) {
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	xor_node_parent_class = g_type_class_peek_parent (klass);
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = xor_node_real_solve_lr;
#line 7024 "equation-parser.c"
}


static void xor_node_instance_init (XorNode * self) {
}


GType xor_node_get_type (void) {
	static volatile gsize xor_node_type_id__volatile = 0;
	if (g_once_init_enter (&xor_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XorNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xor_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XorNode), 0, (GInstanceInitFunc) xor_node_instance_init, NULL };
		GType xor_node_type_id;
		xor_node_type_id = g_type_register_static (TYPE_LR_NODE, "XorNode", &g_define_type_info, 0);
		g_once_init_leave (&xor_node_type_id__volatile, xor_node_type_id);
	}
	return xor_node_type_id__volatile;
}


ConvertNode* convert_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	ConvertNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ConvertNode*) lr_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 7064 "equation-parser.c"
}


ConvertNode* convert_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return convert_node_construct (TYPE_CONVERT_NODE, parser, token, precedence, associativity);
#line 7071 "equation-parser.c"
}


static Number* convert_node_real_solve_lr (LRNode* base, Number* l, Number* r) {
	ConvertNode * self;
	Number* result = NULL;
	gchar* from = NULL;
	ParseNode* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* to = NULL;
	ParseNode* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	Number* tmp = NULL;
	Number* _tmp20_ = NULL;
	Number* ans = NULL;
	Parser* _tmp21_ = NULL;
	Number* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	Number* _tmp25_ = NULL;
	Number* _tmp26_ = NULL;
#line 795 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ConvertNode*) base;
#line 795 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (l != NULL, NULL);
#line 795 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = ((ParseNode*) self)->left;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = _tmp0_->value;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp1_ != NULL) {
#line 7105 "equation-parser.c"
		ParseNode* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		ParseNode* _tmp5_ = NULL;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = ((ParseNode*) self)->left;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = _tmp2_->value;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (from);
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		from = _tmp4_;
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = ((ParseNode*) self)->left;
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_tmp5_->value);
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_->value = NULL;
#line 7126 "equation-parser.c"
	} else {
		ParseNode* _tmp6_ = NULL;
		LexerToken* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = ((ParseNode*) self)->left;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = _tmp6_->token;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = _tmp7_->text;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (from);
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		from = _tmp9_;
#line 7144 "equation-parser.c"
	}
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp10_ = ((ParseNode*) self)->right;
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp11_ = _tmp10_->value;
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp11_ != NULL) {
#line 7152 "equation-parser.c"
		ParseNode* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		ParseNode* _tmp15_ = NULL;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = ((ParseNode*) self)->right;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = _tmp12_->value;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (to);
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		to = _tmp14_;
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = ((ParseNode*) self)->right;
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_tmp15_->value);
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_->value = NULL;
#line 7173 "equation-parser.c"
	} else {
		ParseNode* _tmp16_ = NULL;
		LexerToken* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp16_ = ((ParseNode*) self)->right;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp17_ = _tmp16_->token;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp18_ = _tmp17_->text;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp19_ = g_strdup (_tmp18_);
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (to);
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		to = _tmp19_;
#line 7191 "equation-parser.c"
	}
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp20_ = number_new_integer ((gint64) 1);
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	tmp = _tmp20_;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp21_ = ((ParseNode*) self)->parser;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp22_ = tmp;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp23_ = from;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp24_ = to;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp25_ = parser_convert (_tmp21_, _tmp22_, _tmp23_, _tmp24_);
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	ans = _tmp25_;
#line 818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp26_ = ans;
#line 818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp26_ == NULL) {
#line 7213 "equation-parser.c"
		Parser* _tmp27_ = NULL;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp27_ = ((ParseNode*) self)->parser;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp27_, ERROR_CODE_UNKNOWN_CONVERSION, NULL, (guint) 0, (guint) 0);
#line 7219 "equation-parser.c"
	}
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = ans;
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (tmp);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (to);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (from);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 7231 "equation-parser.c"
}


static void convert_node_class_init (ConvertNodeClass * klass) {
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	convert_node_parent_class = g_type_class_peek_parent (klass);
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((LRNodeClass *) klass)->solve_lr = convert_node_real_solve_lr;
#line 7240 "equation-parser.c"
}


static void convert_node_instance_init (ConvertNode * self) {
}


GType convert_node_get_type (void) {
	static volatile gsize convert_node_type_id__volatile = 0;
	if (g_once_init_enter (&convert_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConvertNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) convert_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConvertNode), 0, (GInstanceInitFunc) convert_node_instance_init, NULL };
		GType convert_node_type_id;
		convert_node_type_id = g_type_register_static (TYPE_LR_NODE, "ConvertNode", &g_define_type_info, 0);
		g_once_init_leave (&convert_node_type_id__volatile, convert_node_type_id);
	}
	return convert_node_type_id__volatile;
}


ConvertBaseNode* convert_base_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* value) {
	ConvertBaseNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = value;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ConvertBaseNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 7283 "equation-parser.c"
}


ConvertBaseNode* convert_base_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity, const gchar* value) {
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return convert_base_node_construct (TYPE_CONVERT_BASE_NODE, parser, token, precedence, associativity, value);
#line 7290 "equation-parser.c"
}


static Number* convert_base_node_real_solve (ParseNode* base) {
	ConvertBaseNode * self;
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	ParseNode* _tmp23_ = NULL;
	Number* _tmp24_ = NULL;
#line 832 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ConvertBaseNode*) base;
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = ((ParseNode*) self)->value;
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (g_strcmp0 (_tmp1_, "hex") == 0) {
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp0_ = TRUE;
#line 7309 "equation-parser.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = ((ParseNode*) self)->value;
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "hexadecimal") == 0;
#line 7316 "equation-parser.c"
	}
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp0_) {
#line 7320 "equation-parser.c"
		Parser* _tmp3_ = NULL;
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = ((ParseNode*) self)->parser;
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_representation_base (_tmp3_, (guint) 16);
#line 7326 "equation-parser.c"
	} else {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_ = NULL;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = ((ParseNode*) self)->value;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (g_strcmp0 (_tmp5_, "dec") == 0) {
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp4_ = TRUE;
#line 7336 "equation-parser.c"
		} else {
			const gchar* _tmp6_ = NULL;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp6_ = ((ParseNode*) self)->value;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp4_ = g_strcmp0 (_tmp6_, "decimal") == 0;
#line 7343 "equation-parser.c"
		}
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp4_) {
#line 7347 "equation-parser.c"
			Parser* _tmp7_ = NULL;
#line 837 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp7_ = ((ParseNode*) self)->parser;
#line 837 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_set_representation_base (_tmp7_, (guint) 10);
#line 7353 "equation-parser.c"
		} else {
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_ = NULL;
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp9_ = ((ParseNode*) self)->value;
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (g_strcmp0 (_tmp9_, "oct") == 0) {
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp8_ = TRUE;
#line 7363 "equation-parser.c"
			} else {
				const gchar* _tmp10_ = NULL;
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp10_ = ((ParseNode*) self)->value;
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp8_ = g_strcmp0 (_tmp10_, "octal") == 0;
#line 7370 "equation-parser.c"
			}
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp8_) {
#line 7374 "equation-parser.c"
				Parser* _tmp11_ = NULL;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp11_ = ((ParseNode*) self)->parser;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				parser_set_representation_base (_tmp11_, (guint) 8);
#line 7380 "equation-parser.c"
			} else {
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_ = NULL;
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp13_ = ((ParseNode*) self)->value;
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (g_strcmp0 (_tmp13_, "bin") == 0) {
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp12_ = TRUE;
#line 7390 "equation-parser.c"
				} else {
					const gchar* _tmp14_ = NULL;
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp14_ = ((ParseNode*) self)->value;
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp12_ = g_strcmp0 (_tmp14_, "binary") == 0;
#line 7397 "equation-parser.c"
				}
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (_tmp12_) {
#line 7401 "equation-parser.c"
					Parser* _tmp15_ = NULL;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp15_ = ((ParseNode*) self)->parser;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					parser_set_representation_base (_tmp15_, (guint) 2);
#line 7407 "equation-parser.c"
				} else {
					Parser* _tmp16_ = NULL;
					LexerToken* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					LexerToken* _tmp19_ = NULL;
					guint _tmp20_ = 0U;
					LexerToken* _tmp21_ = NULL;
					guint _tmp22_ = 0U;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp16_ = ((ParseNode*) self)->parser;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp17_ = ((ParseNode*) self)->token;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp18_ = _tmp17_->text;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp19_ = ((ParseNode*) self)->token;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp20_ = _tmp19_->start_index;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp21_ = ((ParseNode*) self)->token;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp22_ = _tmp21_->end_index;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					parser_set_error (_tmp16_, ERROR_CODE_UNKNOWN_CONVERSION, _tmp18_, _tmp20_, _tmp22_);
#line 845 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = NULL;
#line 845 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 7436 "equation-parser.c"
				}
			}
		}
	}
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp23_ = ((ParseNode*) self)->left;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp24_ = parse_node_solve (_tmp23_);
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp24_;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 7449 "equation-parser.c"
}


static void convert_base_node_class_init (ConvertBaseNodeClass * klass) {
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	convert_base_node_parent_class = g_type_class_peek_parent (klass);
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = convert_base_node_real_solve;
#line 7458 "equation-parser.c"
}


static void convert_base_node_instance_init (ConvertBaseNode * self) {
}


GType convert_base_node_get_type (void) {
	static volatile gsize convert_base_node_type_id__volatile = 0;
	if (g_once_init_enter (&convert_base_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConvertBaseNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) convert_base_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConvertBaseNode), 0, (GInstanceInitFunc) convert_base_node_instance_init, NULL };
		GType convert_base_node_type_id;
		convert_base_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "ConvertBaseNode", &g_define_type_info, 0);
		g_once_init_leave (&convert_base_node_type_id__volatile, convert_base_node_type_id);
	}
	return convert_base_node_type_id__volatile;
}


ConvertNumberNode* convert_number_node_construct (GType object_type, Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
	ConvertNumberNode * self = NULL;
	Parser* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Associativity _tmp3_ = 0;
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser;
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = precedence;
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = associativity;
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ConvertNumberNode*) parse_node_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL);
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 7498 "equation-parser.c"
}


ConvertNumberNode* convert_number_node_new (Parser* parser, LexerToken* token, guint precedence, Associativity associativity) {
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return convert_number_node_construct (TYPE_CONVERT_NUMBER_NODE, parser, token, precedence, associativity);
#line 7505 "equation-parser.c"
}


static Number* convert_number_node_real_solve (ParseNode* base) {
	ConvertNumberNode * self;
	Number* result = NULL;
	gchar* from = NULL;
	ParseNode* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* to = NULL;
	ParseNode* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	Number* tmp = NULL;
	ParseNode* _tmp20_ = NULL;
	ParseNode* _tmp21_ = NULL;
	LexerToken* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	Parser* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	Number* _tmp26_ = NULL;
	Number* _tmp27_ = NULL;
	Number* ans = NULL;
	Parser* _tmp28_ = NULL;
	Number* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	Number* _tmp32_ = NULL;
	Number* _tmp33_ = NULL;
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (ConvertNumberNode*) base;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = ((ParseNode*) self)->left;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = _tmp0_->value;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp1_ != NULL) {
#line 7542 "equation-parser.c"
		ParseNode* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		ParseNode* _tmp5_ = NULL;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = ((ParseNode*) self)->left;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = _tmp2_->value;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (from);
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		from = _tmp4_;
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = ((ParseNode*) self)->left;
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_tmp5_->value);
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_->value = NULL;
#line 7563 "equation-parser.c"
	} else {
		ParseNode* _tmp6_ = NULL;
		LexerToken* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = ((ParseNode*) self)->left;
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = _tmp6_->token;
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = _tmp7_->text;
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (from);
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		from = _tmp9_;
#line 7581 "equation-parser.c"
	}
#line 870 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp10_ = ((ParseNode*) self)->right;
#line 870 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp11_ = _tmp10_->value;
#line 870 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp11_ != NULL) {
#line 7589 "equation-parser.c"
		ParseNode* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		ParseNode* _tmp15_ = NULL;
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = ((ParseNode*) self)->right;
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = _tmp12_->value;
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (to);
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		to = _tmp14_;
#line 873 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = ((ParseNode*) self)->right;
#line 873 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_tmp15_->value);
#line 873 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_->value = NULL;
#line 7610 "equation-parser.c"
	} else {
		ParseNode* _tmp16_ = NULL;
		LexerToken* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp16_ = ((ParseNode*) self)->right;
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp17_ = _tmp16_->token;
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp18_ = _tmp17_->text;
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp19_ = g_strdup (_tmp18_);
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (to);
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		to = _tmp19_;
#line 7628 "equation-parser.c"
	}
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp20_ = ((ParseNode*) self)->left;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp21_ = _tmp20_->left;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp22_ = _tmp21_->token;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp23_ = _tmp22_->text;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp24_ = ((ParseNode*) self)->parser;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp25_ = _tmp24_->number_base;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp26_ = mp_set_from_string (_tmp23_, _tmp25_);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	tmp = _tmp26_;
#line 879 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp27_ = tmp;
#line 879 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp27_ == NULL) {
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = NULL;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmp);
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (to);
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (from);
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 7660 "equation-parser.c"
	}
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp28_ = ((ParseNode*) self)->parser;
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp29_ = tmp;
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp30_ = from;
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp31_ = to;
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp32_ = parser_convert (_tmp28_, _tmp29_, _tmp30_, _tmp31_);
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	ans = _tmp32_;
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp33_ = ans;
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp33_ == NULL) {
#line 7678 "equation-parser.c"
		Parser* _tmp34_ = NULL;
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp34_ = ((ParseNode*) self)->parser;
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_set_error (_tmp34_, ERROR_CODE_UNKNOWN_CONVERSION, NULL, (guint) 0, (guint) 0);
#line 7684 "equation-parser.c"
	}
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = ans;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (tmp);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (to);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (from);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 7696 "equation-parser.c"
}


static void convert_number_node_class_init (ConvertNumberNodeClass * klass) {
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	convert_number_node_parent_class = g_type_class_peek_parent (klass);
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParseNodeClass *) klass)->solve = convert_number_node_real_solve;
#line 7705 "equation-parser.c"
}


static void convert_number_node_instance_init (ConvertNumberNode * self) {
}


GType convert_number_node_get_type (void) {
	static volatile gsize convert_number_node_type_id__volatile = 0;
	if (g_once_init_enter (&convert_number_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConvertNumberNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) convert_number_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConvertNumberNode), 0, (GInstanceInitFunc) convert_number_node_instance_init, NULL };
		GType convert_number_node_type_id;
		convert_number_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "ConvertNumberNode", &g_define_type_info, 0);
		g_once_init_leave (&convert_number_node_type_id__volatile, convert_number_node_type_id);
	}
	return convert_number_node_type_id__volatile;
}


Parser* parser_construct (GType object_type, const gchar* input, gint number_base, gint wordlen, AngleUnit angle_units) {
	Parser* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Lexer* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	AngleUnit _tmp8_ = 0;
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = (Parser*) g_type_create_instance (object_type);
#line 908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = input;
#line 908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (self->priv->input);
#line 908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->input = _tmp1_;
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = input;
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = number_base;
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = lexer_new (_tmp2_, self, _tmp3_);
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->priv->lexer);
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->lexer = _tmp4_;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->priv->root);
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->root = NULL;
#line 911 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->depth_level = (guint) 0;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->priv->right_most);
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->right_most = NULL;
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = number_base;
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->number_base = _tmp5_;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = number_base;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->representation_base = (guint) _tmp6_;
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp7_ = wordlen;
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->wordlen = _tmp7_;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp8_ = angle_units;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->angle_units = _tmp8_;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->error = ERROR_CODE_NONE;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (self->priv->error_token);
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->error_token = NULL;
#line 919 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->error_token_start = 0;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->error_token_end = 0;
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return self;
#line 7796 "equation-parser.c"
}


Parser* parser_new (const gchar* input, gint number_base, gint wordlen, AngleUnit angle_units) {
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return parser_construct (TYPE_PARSER, input, number_base, wordlen, angle_units);
#line 7803 "equation-parser.c"
}


gboolean parser_create_parse_tree (Parser* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end) {
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint _vala_error_start = 0U;
	guint _vala_error_end = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	Lexer* _tmp1_ = NULL;
	gboolean ret = FALSE;
	gboolean _tmp2_ = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp3_ = NULL;
	LexerToken* _tmp4_ = NULL;
	LexerToken* _tmp5_ = NULL;
	LexerTokenType _tmp6_ = 0;
	LexerToken* _tmp23_ = NULL;
	LexerTokenType _tmp24_ = 0;
	gboolean _tmp37_ = FALSE;
#line 923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->number_base;
#line 925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_representation_base = (guint) _tmp0_;
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = self->priv->lexer;
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	lexer_scan (_tmp1_);
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = parser_statement (self);
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	ret = _tmp2_;
#line 932 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = self->priv->lexer;
#line 932 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = lexer_get_next_token (_tmp3_);
#line 932 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp4_;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = token;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = _tmp5_->type;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp6_ == LEXER_TOKEN_TYPE_ASSIGN) {
#line 7852 "equation-parser.c"
		Lexer* _tmp7_ = NULL;
		LexerToken* _tmp8_ = NULL;
		LexerToken* _tmp9_ = NULL;
		LexerTokenType _tmp10_ = 0;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = self->priv->lexer;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = lexer_get_next_token (_tmp7_);
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp8_;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = token;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = _tmp9_->type;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp10_ != LEXER_TOKEN_TYPE_PL_EOS) {
#line 7871 "equation-parser.c"
			ErrorCode _tmp11_ = 0;
			ErrorCode _tmp18_ = 0;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp11_ = self->priv->error;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp11_ == ERROR_CODE_NONE) {
#line 7882 "equation-parser.c"
				LexerToken* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				LexerToken* _tmp14_ = NULL;
				guint _tmp15_ = 0U;
				LexerToken* _tmp16_ = NULL;
				guint _tmp17_ = 0U;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp12_ = token;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp13_ = _tmp12_->text;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp14_ = token;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp15_ = _tmp14_->start_index;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp16_ = token;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp17_ = _tmp16_->end_index;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				parser_set_error (self, ERROR_CODE_INVALID, _tmp13_, _tmp15_, _tmp17_);
#line 7903 "equation-parser.c"
			}
#line 942 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp18_ = self->priv->error;
#line 942 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_vala_error_code = _tmp18_;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp19_ = self->priv->error_token;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp20_ = g_strdup (_tmp19_);
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (_vala_error_token);
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_vala_error_token = _tmp20_;
#line 944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp21_ = self->priv->error_token_start;
#line 944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_vala_error_start = (guint) _tmp21_;
#line 945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp22_ = self->priv->error_token_end;
#line 945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_vala_error_end = (guint) _tmp22_;
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (representation_base) {
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				*representation_base = _vala_representation_base;
#line 7933 "equation-parser.c"
			}
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (error_code) {
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				*error_code = _vala_error_code;
#line 7939 "equation-parser.c"
			}
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (error_token) {
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				*error_token = _vala_error_token;
#line 7945 "equation-parser.c"
			} else {
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_free0 (_vala_error_token);
#line 7949 "equation-parser.c"
			}
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (error_start) {
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				*error_start = _vala_error_start;
#line 7955 "equation-parser.c"
			}
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (error_end) {
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				*error_end = _vala_error_end;
#line 7961 "equation-parser.c"
			}
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 7965 "equation-parser.c"
		}
	}
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp23_ = token;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp24_ = _tmp23_->type;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp24_ != LEXER_TOKEN_TYPE_PL_EOS) {
#line 7974 "equation-parser.c"
		ErrorCode _tmp25_ = 0;
		ErrorCode _tmp32_ = 0;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp25_ = self->priv->error;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp25_ == ERROR_CODE_NONE) {
#line 7985 "equation-parser.c"
			LexerToken* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			LexerToken* _tmp28_ = NULL;
			guint _tmp29_ = 0U;
			LexerToken* _tmp30_ = NULL;
			guint _tmp31_ = 0U;
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp26_ = token;
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp27_ = _tmp26_->text;
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp28_ = token;
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp29_ = _tmp28_->start_index;
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp30_ = token;
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp31_ = _tmp30_->end_index;
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_set_error (self, ERROR_CODE_INVALID, _tmp27_, _tmp29_, _tmp31_);
#line 8006 "equation-parser.c"
		}
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp32_ = self->priv->error;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_code = _tmp32_;
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp33_ = self->priv->error_token;
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp34_ = g_strdup (_tmp33_);
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_vala_error_token);
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_token = _tmp34_;
#line 957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp35_ = self->priv->error_token_start;
#line 957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_start = (guint) _tmp35_;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp36_ = self->priv->error_token_end;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_end = (guint) _tmp36_;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = FALSE;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (representation_base) {
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*representation_base = _vala_representation_base;
#line 8036 "equation-parser.c"
		}
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_code) {
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_code = _vala_error_code;
#line 8042 "equation-parser.c"
		}
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_token) {
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_token = _vala_error_token;
#line 8048 "equation-parser.c"
		} else {
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (_vala_error_token);
#line 8052 "equation-parser.c"
		}
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_start) {
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_start = _vala_error_start;
#line 8058 "equation-parser.c"
		}
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_end) {
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_end = _vala_error_end;
#line 8064 "equation-parser.c"
		}
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8068 "equation-parser.c"
	}
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp37_ = ret;
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (!_tmp37_) {
#line 8074 "equation-parser.c"
		ErrorCode _tmp38_ = 0;
		ErrorCode _tmp39_ = 0;
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp38_ = self->priv->error;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp38_ == ERROR_CODE_NONE) {
#line 966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_set_error (self, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
#line 8087 "equation-parser.c"
		}
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp39_ = self->priv->error;
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_code = _tmp39_;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp40_ = self->priv->error_token;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp41_ = g_strdup (_tmp40_);
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_vala_error_token);
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_token = _tmp41_;
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp42_ = self->priv->error_token_start;
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_start = (guint) _tmp42_;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp43_ = self->priv->error_token_end;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_end = (guint) _tmp43_;
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = FALSE;
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (representation_base) {
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*representation_base = _vala_representation_base;
#line 8117 "equation-parser.c"
		}
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_code) {
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_code = _vala_error_code;
#line 8123 "equation-parser.c"
		}
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_token) {
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_token = _vala_error_token;
#line 8129 "equation-parser.c"
		} else {
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (_vala_error_token);
#line 8133 "equation-parser.c"
		}
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_start) {
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_start = _vala_error_start;
#line 8139 "equation-parser.c"
		}
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_end) {
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_end = _vala_error_end;
#line 8145 "equation-parser.c"
		}
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8149 "equation-parser.c"
	}
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_code = ERROR_CODE_NONE;
#line 976 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (_vala_error_token);
#line 976 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_token = NULL;
#line 977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_start = (guint) 0;
#line 978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_end = (guint) 0;
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = TRUE;
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (representation_base) {
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*representation_base = _vala_representation_base;
#line 8169 "equation-parser.c"
	}
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (error_code) {
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*error_code = _vala_error_code;
#line 8175 "equation-parser.c"
	}
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (error_token) {
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*error_token = _vala_error_token;
#line 8181 "equation-parser.c"
	} else {
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_vala_error_token);
#line 8185 "equation-parser.c"
	}
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (error_start) {
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*error_start = _vala_error_start;
#line 8191 "equation-parser.c"
	}
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (error_end) {
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*error_end = _vala_error_end;
#line 8197 "equation-parser.c"
	}
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8201 "equation-parser.c"
}


void parser_set_error (Parser* self, ErrorCode errorno, const gchar* token, guint token_start, guint token_end) {
	ErrorCode _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	gint _tmp5_ = 0;
	const gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gint _tmp8_ = 0;
#line 983 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (self != NULL);
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = errorno;
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->error = _tmp0_;
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = token;
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (self->priv->error_token);
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->error_token = _tmp2_;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = self->priv->input;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = token_start;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = g_utf8_strlen (_tmp3_, (gssize) _tmp4_);
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->error_token_start = _tmp5_;
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = self->priv->input;
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp7_ = token_end;
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp8_ = g_utf8_strlen (_tmp6_, (gssize) _tmp7_);
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->error_token_end = _tmp8_;
#line 8245 "equation-parser.c"
}


void parser_set_representation_base (Parser* self, guint new_base) {
	guint _tmp0_ = 0U;
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (self != NULL);
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = new_base;
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->representation_base = _tmp0_;
#line 8257 "equation-parser.c"
}


static gboolean parser_real_variable_is_defined (Parser* self, const gchar* name) {
	gboolean result = FALSE;
#line 996 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = FALSE;
#line 998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8269 "equation-parser.c"
}


gboolean parser_variable_is_defined (Parser* self, const gchar* name) {
#line 996 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 996 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return PARSER_GET_CLASS (self)->variable_is_defined (self, name);
#line 8278 "equation-parser.c"
}


static Number* parser_real_get_variable (Parser* self, const gchar* name) {
	Number* result = NULL;
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = NULL;
#line 1003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8290 "equation-parser.c"
}


Number* parser_get_variable (Parser* self, const gchar* name) {
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return PARSER_GET_CLASS (self)->get_variable (self, name);
#line 8299 "equation-parser.c"
}


static void parser_real_set_variable (Parser* self, const gchar* name, Number* x) {
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (name != NULL);
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (x != NULL);
#line 8308 "equation-parser.c"
}


void parser_set_variable (Parser* self, const gchar* name, Number* x) {
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (self != NULL);
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	PARSER_GET_CLASS (self)->set_variable (self, name, x);
#line 8317 "equation-parser.c"
}


static gboolean parser_real_function_is_defined (Parser* self, const gchar* name) {
	gboolean result = FALSE;
#line 1010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = FALSE;
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8329 "equation-parser.c"
}


gboolean parser_function_is_defined (Parser* self, const gchar* name) {
#line 1010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return PARSER_GET_CLASS (self)->function_is_defined (self, name);
#line 8338 "equation-parser.c"
}


static Number* parser_real_convert (Parser* self, Number* x, const gchar* x_units, const gchar* z_units) {
	Number* result = NULL;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (x_units != NULL, NULL);
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (z_units != NULL, NULL);
#line 1017 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = NULL;
#line 1017 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8354 "equation-parser.c"
}


Number* parser_convert (Parser* self, Number* x, const gchar* x_units, const gchar* z_units) {
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return PARSER_GET_CLASS (self)->convert (self, x, x_units, z_units);
#line 8363 "equation-parser.c"
}


Number* parser_parse (Parser* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end) {
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint _vala_error_start = 0U;
	guint _vala_error_end = 0U;
	Number* result = NULL;
	gboolean is_successfully_parsed = FALSE;
	guint _tmp0_ = 0U;
	ErrorCode _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	Number* ans = NULL;
	ParseNode* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	guint _tmp12_ = 0U;
	ErrorCode _tmp13_ = 0;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 1021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = parser_create_parse_tree (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_representation_base = _tmp0_;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_code = _tmp1_;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (_vala_error_token);
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_token = _tmp2_;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_start = _tmp3_;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_end = _tmp4_;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	is_successfully_parsed = _tmp5_;
#line 1025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = is_successfully_parsed;
#line 1025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (!_tmp6_) {
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = NULL;
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (representation_base) {
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*representation_base = _vala_representation_base;
#line 8420 "equation-parser.c"
		}
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_code) {
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_code = _vala_error_code;
#line 8426 "equation-parser.c"
		}
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_token) {
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_token = _vala_error_token;
#line 8432 "equation-parser.c"
		} else {
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (_vala_error_token);
#line 8436 "equation-parser.c"
		}
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_start) {
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_start = _vala_error_start;
#line 8442 "equation-parser.c"
		}
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_end) {
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_end = _vala_error_end;
#line 8448 "equation-parser.c"
		}
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8452 "equation-parser.c"
	}
#line 1028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp7_ = self->priv->root;
#line 1028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp8_ = parse_node_solve (_tmp7_);
#line 1028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	ans = _tmp8_;
#line 1029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = ans;
#line 1029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp9_ == NULL) {
#line 8464 "equation-parser.c"
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_code = ERROR_CODE_INVALID;
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_vala_error_token);
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_token = NULL;
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = self->priv->error_token_start;
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_start = (guint) _tmp10_;
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = self->priv->error_token_end;
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_vala_error_end = (guint) _tmp11_;
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = NULL;
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (ans);
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (representation_base) {
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*representation_base = _vala_representation_base;
#line 8489 "equation-parser.c"
		}
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_code) {
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_code = _vala_error_code;
#line 8495 "equation-parser.c"
		}
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_token) {
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_token = _vala_error_token;
#line 8501 "equation-parser.c"
		} else {
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (_vala_error_token);
#line 8505 "equation-parser.c"
		}
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_start) {
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_start = _vala_error_start;
#line 8511 "equation-parser.c"
		}
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (error_end) {
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			*error_end = _vala_error_end;
#line 8517 "equation-parser.c"
		}
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8521 "equation-parser.c"
	}
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp12_ = self->priv->representation_base;
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_representation_base = _tmp12_;
#line 1039 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp13_ = self->priv->error;
#line 1039 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_code = _tmp13_;
#line 1040 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp14_ = self->priv->error_token;
#line 1040 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 1040 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (_vala_error_token);
#line 1040 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_token = _tmp15_;
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp16_ = self->priv->error_token_start;
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_start = (guint) _tmp16_;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp17_ = self->priv->error_token_end;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_vala_error_end = (guint) _tmp17_;
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = ans;
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (representation_base) {
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*representation_base = _vala_representation_base;
#line 8553 "equation-parser.c"
	}
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (error_code) {
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*error_code = _vala_error_code;
#line 8559 "equation-parser.c"
	}
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (error_token) {
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*error_token = _vala_error_token;
#line 8565 "equation-parser.c"
	} else {
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_vala_error_token);
#line 8569 "equation-parser.c"
	}
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (error_start) {
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*error_start = _vala_error_start;
#line 8575 "equation-parser.c"
	}
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (error_end) {
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*error_end = _vala_error_end;
#line 8581 "equation-parser.c"
	}
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8585 "equation-parser.c"
}


static Precedence parser_get_precedence (Parser* self, LexerTokenType type) {
	Precedence result = 0;
	gboolean _tmp0_ = FALSE;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType _tmp3_ = 0;
	LexerTokenType _tmp4_ = 0;
	LexerTokenType _tmp5_ = 0;
	LexerTokenType _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	LexerTokenType _tmp9_ = 0;
	LexerTokenType _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	LexerTokenType _tmp15_ = 0;
	LexerTokenType _tmp18_ = 0;
	LexerTokenType _tmp19_ = 0;
	LexerTokenType _tmp20_ = 0;
	gboolean _tmp21_ = FALSE;
	LexerTokenType _tmp22_ = 0;
#line 1047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = type;
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp1_ == LEXER_TOKEN_TYPE_ADD) {
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp0_ = TRUE;
#line 8617 "equation-parser.c"
	} else {
		LexerTokenType _tmp2_ = 0;
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = type;
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp0_ = _tmp2_ == LEXER_TOKEN_TYPE_SUBTRACT;
#line 8624 "equation-parser.c"
	}
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp0_) {
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_ADD_SUBTRACT;
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8632 "equation-parser.c"
	}
#line 1052 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = type;
#line 1052 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp3_ == LEXER_TOKEN_TYPE_MULTIPLY) {
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_MULTIPLY;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8642 "equation-parser.c"
	}
#line 1054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = type;
#line 1054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp4_ == LEXER_TOKEN_TYPE_MOD) {
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_MOD;
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8652 "equation-parser.c"
	}
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = type;
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp5_ == LEXER_TOKEN_TYPE_DIVIDE) {
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_DIVIDE;
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8662 "equation-parser.c"
	}
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = type;
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp6_ == LEXER_TOKEN_TYPE_NOT) {
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_NOT;
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8672 "equation-parser.c"
	}
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = type;
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp9_ == LEXER_TOKEN_TYPE_ROOT) {
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = TRUE;
#line 8680 "equation-parser.c"
	} else {
		LexerTokenType _tmp10_ = 0;
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = type;
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = _tmp10_ == LEXER_TOKEN_TYPE_ROOT_3;
#line 8687 "equation-parser.c"
	}
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp8_) {
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = TRUE;
#line 8693 "equation-parser.c"
	} else {
		LexerTokenType _tmp11_ = 0;
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = type;
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = _tmp11_ == LEXER_TOKEN_TYPE_ROOT_4;
#line 8700 "equation-parser.c"
	}
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp7_) {
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_ROOT;
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8708 "equation-parser.c"
	}
#line 1062 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp12_ = type;
#line 1062 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp12_ == LEXER_TOKEN_TYPE_FUNCTION) {
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_FUNCTION;
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8718 "equation-parser.c"
	}
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp15_ = type;
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp15_ == LEXER_TOKEN_TYPE_AND) {
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = TRUE;
#line 8726 "equation-parser.c"
	} else {
		LexerTokenType _tmp16_ = 0;
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp16_ = type;
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = _tmp16_ == LEXER_TOKEN_TYPE_OR;
#line 8733 "equation-parser.c"
	}
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp14_) {
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = TRUE;
#line 8739 "equation-parser.c"
	} else {
		LexerTokenType _tmp17_ = 0;
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp17_ = type;
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = _tmp17_ == LEXER_TOKEN_TYPE_XOR;
#line 8746 "equation-parser.c"
	}
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp13_) {
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_BOOLEAN;
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8754 "equation-parser.c"
	}
#line 1066 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp18_ = type;
#line 1066 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp18_ == LEXER_TOKEN_TYPE_PERCENTAGE) {
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_PERCENTAGE;
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8764 "equation-parser.c"
	}
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp19_ = type;
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp19_ == LEXER_TOKEN_TYPE_POWER) {
#line 1069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_POWER;
#line 1069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8774 "equation-parser.c"
	}
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp20_ = type;
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp20_ == LEXER_TOKEN_TYPE_FACTORIAL) {
#line 1071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_FACTORIAL;
#line 1071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8784 "equation-parser.c"
	}
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp22_ = type;
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp22_ == LEXER_TOKEN_TYPE_NUMBER) {
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp21_ = TRUE;
#line 8792 "equation-parser.c"
	} else {
		LexerTokenType _tmp23_ = 0;
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp23_ = type;
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp21_ = _tmp23_ == LEXER_TOKEN_TYPE_VARIABLE;
#line 8799 "equation-parser.c"
	}
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp21_) {
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = PRECEDENCE_NUMBER_VARIABLE;
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8807 "equation-parser.c"
	}
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = PRECEDENCE_UNKNOWN;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8813 "equation-parser.c"
}


static Associativity parser_get_associativity_p (Parser* self, Precedence type) {
	Associativity result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Precedence _tmp4_ = 0;
	Precedence _tmp9_ = 0;
#line 1078 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = type;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp4_ == PRECEDENCE_BOOLEAN) {
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = TRUE;
#line 8833 "equation-parser.c"
	} else {
		Precedence _tmp5_ = 0;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = type;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = _tmp5_ == PRECEDENCE_DIVIDE;
#line 8840 "equation-parser.c"
	}
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp3_) {
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = TRUE;
#line 8846 "equation-parser.c"
	} else {
		Precedence _tmp6_ = 0;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = type;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = _tmp6_ == PRECEDENCE_MOD;
#line 8853 "equation-parser.c"
	}
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp2_) {
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp1_ = TRUE;
#line 8859 "equation-parser.c"
	} else {
		Precedence _tmp7_ = 0;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = type;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp1_ = _tmp7_ == PRECEDENCE_MULTIPLY;
#line 8866 "equation-parser.c"
	}
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp1_) {
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp0_ = TRUE;
#line 8872 "equation-parser.c"
	} else {
		Precedence _tmp8_ = 0;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = type;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp0_ = _tmp8_ == PRECEDENCE_ADD_SUBTRACT;
#line 8879 "equation-parser.c"
	}
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp0_) {
#line 1081 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = ASSOCIATIVITY_LEFT;
#line 1081 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8887 "equation-parser.c"
	}
#line 1082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = type;
#line 1082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp9_ == PRECEDENCE_POWER) {
#line 1083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = ASSOCIATIVITY_RIGHT;
#line 1083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8897 "equation-parser.c"
	}
#line 1085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = ASSOCIATIVITY_LEFT;
#line 1085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8903 "equation-parser.c"
}


static Associativity parser_get_associativity (Parser* self, LexerToken* token) {
	Associativity result = 0;
	LexerToken* _tmp0_ = NULL;
	LexerTokenType _tmp1_ = 0;
	Precedence _tmp2_ = 0;
	Associativity _tmp3_ = 0;
#line 1089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (token != NULL, 0);
#line 1091 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = token;
#line 1091 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = _tmp0_->type;
#line 1091 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = parser_get_precedence (self, _tmp1_);
#line 1091 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = parser_get_associativity_p (self, _tmp2_);
#line 1091 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp3_;
#line 1091 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8929 "equation-parser.c"
}


static guint parser_make_precedence_p (Parser* self, Precedence p) {
	guint result = 0U;
	Precedence _tmp0_ = 0;
	guint _tmp1_ = 0U;
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = p;
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = self->priv->depth_level;
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp0_ + (_tmp1_ * PRECEDENCE_DEPTH);
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8947 "equation-parser.c"
}


static guint parser_make_precedence_t (Parser* self, LexerTokenType type) {
	guint result = 0U;
	LexerTokenType _tmp0_ = 0;
	Precedence _tmp1_ = 0;
	guint _tmp2_ = 0U;
#line 1101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = type;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = parser_get_precedence (self, _tmp0_);
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = self->priv->depth_level;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = _tmp1_ + (_tmp2_ * PRECEDENCE_DEPTH);
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 8968 "equation-parser.c"
}


static gboolean parser_cmp_nodes (Parser* self, ParseNode* left, ParseNode* right) {
	gboolean result = FALSE;
	ParseNode* _tmp0_ = NULL;
	ParseNode* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	ParseNode* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
#line 1107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = left;
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp0_ == NULL) {
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = FALSE;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 8989 "equation-parser.c"
	}
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = left;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = _tmp1_->precedence;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = right;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = _tmp3_->precedence;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp2_ > _tmp4_) {
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = TRUE;
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 9005 "equation-parser.c"
	} else {
		ParseNode* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		ParseNode* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
#line 1117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = left;
#line 1117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = _tmp5_->precedence;
#line 1117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = right;
#line 1117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = _tmp7_->precedence;
#line 1117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp6_ < _tmp8_) {
#line 1118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 1118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 9025 "equation-parser.c"
		} else {
			ParseNode* _tmp9_ = NULL;
			Associativity _tmp10_ = 0;
#line 1120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp9_ = right;
#line 1120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp10_ = _tmp9_->associativity;
#line 1120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = _tmp10_ != ASSOCIATIVITY_RIGHT;
#line 1120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 9037 "equation-parser.c"
		}
	}
}


static void parser_insert_into_tree_all (Parser* self, ParseNode* node, gboolean unary_function) {
	ParseNode* _tmp0_ = NULL;
	ParseNode* tmp = NULL;
	ParseNode* _tmp5_ = NULL;
	ParseNode* _tmp6_ = NULL;
	gboolean _tmp13_ = FALSE;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (self != NULL);
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (node != NULL);
#line 1126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->root;
#line 1126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp0_ == NULL) {
#line 9057 "equation-parser.c"
		ParseNode* _tmp1_ = NULL;
		ParseNode* _tmp2_ = NULL;
		ParseNode* _tmp3_ = NULL;
		ParseNode* _tmp4_ = NULL;
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp1_ = node;
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (self->priv->root);
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		self->priv->root = _tmp2_;
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = self->priv->root;
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (self->priv->right_most);
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		self->priv->right_most = _tmp4_;
#line 1130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return;
#line 9080 "equation-parser.c"
	}
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = self->priv->right_most;
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	tmp = _tmp6_;
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	while (TRUE) {
#line 9090 "equation-parser.c"
		ParseNode* _tmp7_ = NULL;
		ParseNode* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		ParseNode* _tmp10_ = NULL;
		ParseNode* _tmp11_ = NULL;
		ParseNode* _tmp12_ = NULL;
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = tmp;
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = node;
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = parser_cmp_nodes (self, _tmp7_, _tmp8_);
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp9_) {
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			break;
#line 9107 "equation-parser.c"
		}
#line 1134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = tmp;
#line 1134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = _tmp10_->parent;
#line 1134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 1134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (tmp);
#line 1134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		tmp = _tmp12_;
#line 9119 "equation-parser.c"
	}
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp13_ = unary_function;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp13_) {
#line 9125 "equation-parser.c"
		ParseNode* _tmp14_ = NULL;
		ParseNode* _tmp43_ = NULL;
		ParseNode* _tmp44_ = NULL;
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = tmp;
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp14_ == NULL) {
#line 9133 "equation-parser.c"
			ParseNode* _tmp15_ = NULL;
			ParseNode* _tmp16_ = NULL;
			ParseNode* _tmp17_ = NULL;
			ParseNode* _tmp18_ = NULL;
			ParseNode* _tmp19_ = NULL;
			ParseNode* _tmp20_ = NULL;
			ParseNode* _tmp21_ = NULL;
			ParseNode* _tmp22_ = NULL;
			ParseNode* _tmp23_ = NULL;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp15_ = node;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp16_ = self->priv->root;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp17_ = _g_object_ref0 (_tmp16_);
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp15_->right);
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp15_->right = _tmp17_;
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp18_ = node;
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp19_ = _tmp18_->right;
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp20_ = node;
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp21_ = _g_object_ref0 (_tmp20_);
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp19_->parent);
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp19_->parent = _tmp21_;
#line 1144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp22_ = node;
#line 1144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp23_ = _g_object_ref0 (_tmp22_);
#line 1144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (self->priv->root);
#line 1144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			self->priv->root = _tmp23_;
#line 9173 "equation-parser.c"
		} else {
			ParseNode* _tmp24_ = NULL;
			ParseNode* _tmp25_ = NULL;
			ParseNode* _tmp26_ = NULL;
			ParseNode* _tmp27_ = NULL;
			ParseNode* _tmp28_ = NULL;
			ParseNode* _tmp29_ = NULL;
			ParseNode* _tmp34_ = NULL;
			ParseNode* _tmp35_ = NULL;
			ParseNode* _tmp36_ = NULL;
			ParseNode* _tmp37_ = NULL;
			ParseNode* _tmp38_ = NULL;
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp24_ = node;
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp25_ = tmp;
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp26_ = _tmp25_->right;
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp27_ = _g_object_ref0 (_tmp26_);
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp24_->right);
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp24_->right = _tmp27_;
#line 1149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp28_ = node;
#line 1149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp29_ = _tmp28_->right;
#line 1149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp29_ != NULL) {
#line 9204 "equation-parser.c"
				ParseNode* _tmp30_ = NULL;
				ParseNode* _tmp31_ = NULL;
				ParseNode* _tmp32_ = NULL;
				ParseNode* _tmp33_ = NULL;
#line 1150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp30_ = node;
#line 1150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp31_ = _tmp30_->right;
#line 1150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp32_ = node;
#line 1150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp33_ = _g_object_ref0 (_tmp32_);
#line 1150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (_tmp31_->parent);
#line 1150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp31_->parent = _tmp33_;
#line 9221 "equation-parser.c"
			}
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp34_ = tmp;
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp35_ = node;
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp36_ = _g_object_ref0 (_tmp35_);
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp34_->right);
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp34_->right = _tmp36_;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp37_ = tmp;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp38_ = _tmp37_->right;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp38_ != NULL) {
#line 9239 "equation-parser.c"
				ParseNode* _tmp39_ = NULL;
				ParseNode* _tmp40_ = NULL;
				ParseNode* _tmp41_ = NULL;
				ParseNode* _tmp42_ = NULL;
#line 1154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp39_ = tmp;
#line 1154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp40_ = _tmp39_->right;
#line 1154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp41_ = tmp;
#line 1154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp42_ = _g_object_ref0 (_tmp41_);
#line 1154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (_tmp40_->parent);
#line 1154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp40_->parent = _tmp42_;
#line 9256 "equation-parser.c"
			}
		}
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp43_ = node;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp44_ = _g_object_ref0 (_tmp43_);
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (self->priv->right_most);
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		self->priv->right_most = _tmp44_;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 9269 "equation-parser.c"
			ParseNode* _tmp45_ = NULL;
			ParseNode* _tmp46_ = NULL;
			ParseNode* _tmp47_ = NULL;
			ParseNode* _tmp48_ = NULL;
			ParseNode* _tmp49_ = NULL;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp45_ = self->priv->right_most;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp46_ = _tmp45_->right;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp46_ != NULL)) {
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 9283 "equation-parser.c"
			}
#line 1159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp47_ = self->priv->right_most;
#line 1159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp48_ = _tmp47_->right;
#line 1159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp49_ = _g_object_ref0 (_tmp48_);
#line 1159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (self->priv->right_most);
#line 1159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			self->priv->right_most = _tmp49_;
#line 9295 "equation-parser.c"
		}
	} else {
		ParseNode* _tmp50_ = NULL;
		ParseNode* _tmp79_ = NULL;
		ParseNode* _tmp80_ = NULL;
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp50_ = tmp;
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp50_ == NULL) {
#line 9305 "equation-parser.c"
			ParseNode* _tmp51_ = NULL;
			ParseNode* _tmp52_ = NULL;
			ParseNode* _tmp53_ = NULL;
			ParseNode* _tmp54_ = NULL;
			ParseNode* _tmp55_ = NULL;
			ParseNode* _tmp56_ = NULL;
			ParseNode* _tmp57_ = NULL;
			ParseNode* _tmp58_ = NULL;
			ParseNode* _tmp59_ = NULL;
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp51_ = node;
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp52_ = self->priv->root;
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp53_ = _g_object_ref0 (_tmp52_);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp51_->left);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp51_->left = _tmp53_;
#line 1167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp54_ = node;
#line 1167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp55_ = _tmp54_->left;
#line 1167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp56_ = node;
#line 1167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp57_ = _g_object_ref0 (_tmp56_);
#line 1167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp55_->parent);
#line 1167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp55_->parent = _tmp57_;
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp58_ = node;
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp59_ = _g_object_ref0 (_tmp58_);
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (self->priv->root);
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			self->priv->root = _tmp59_;
#line 9345 "equation-parser.c"
		} else {
			ParseNode* _tmp60_ = NULL;
			ParseNode* _tmp61_ = NULL;
			ParseNode* _tmp62_ = NULL;
			ParseNode* _tmp63_ = NULL;
			ParseNode* _tmp64_ = NULL;
			ParseNode* _tmp65_ = NULL;
			ParseNode* _tmp70_ = NULL;
			ParseNode* _tmp71_ = NULL;
			ParseNode* _tmp72_ = NULL;
			ParseNode* _tmp73_ = NULL;
			ParseNode* _tmp74_ = NULL;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp60_ = node;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp61_ = tmp;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp62_ = _tmp61_->right;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp63_ = _g_object_ref0 (_tmp62_);
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp60_->left);
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp60_->left = _tmp63_;
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp64_ = node;
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp65_ = _tmp64_->left;
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp65_ != NULL) {
#line 9376 "equation-parser.c"
				ParseNode* _tmp66_ = NULL;
				ParseNode* _tmp67_ = NULL;
				ParseNode* _tmp68_ = NULL;
				ParseNode* _tmp69_ = NULL;
#line 1175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp66_ = node;
#line 1175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp67_ = _tmp66_->left;
#line 1175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp68_ = node;
#line 1175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp69_ = _g_object_ref0 (_tmp68_);
#line 1175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (_tmp67_->parent);
#line 1175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp67_->parent = _tmp69_;
#line 9393 "equation-parser.c"
			}
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp70_ = tmp;
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp71_ = node;
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp72_ = _g_object_ref0 (_tmp71_);
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp70_->right);
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp70_->right = _tmp72_;
#line 1178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp73_ = tmp;
#line 1178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp74_ = _tmp73_->right;
#line 1178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp74_ != NULL) {
#line 9411 "equation-parser.c"
				ParseNode* _tmp75_ = NULL;
				ParseNode* _tmp76_ = NULL;
				ParseNode* _tmp77_ = NULL;
				ParseNode* _tmp78_ = NULL;
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp75_ = tmp;
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp76_ = _tmp75_->right;
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp77_ = tmp;
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp78_ = _g_object_ref0 (_tmp77_);
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (_tmp76_->parent);
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp76_->parent = _tmp78_;
#line 9428 "equation-parser.c"
			}
		}
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp79_ = node;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp80_ = _g_object_ref0 (_tmp79_);
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (self->priv->right_most);
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		self->priv->right_most = _tmp80_;
#line 9439 "equation-parser.c"
	}
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (tmp);
#line 9443 "equation-parser.c"
}


static void parser_insert_into_tree (Parser* self, ParseNode* node) {
	ParseNode* _tmp0_ = NULL;
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (self != NULL);
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (node != NULL);
#line 1189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = node;
#line 1189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_insert_into_tree_all (self, _tmp0_, FALSE);
#line 9457 "equation-parser.c"
}


static void parser_insert_into_tree_unary (Parser* self, ParseNode* node) {
	ParseNode* _tmp0_ = NULL;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (self != NULL);
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (node != NULL);
#line 1195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = node;
#line 1195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_insert_into_tree_all (self, _tmp0_, TRUE);
#line 9471 "equation-parser.c"
}


static void parser_destroy_all_nodes (Parser* self, ParseNode* node) {
	ParseNode* _tmp0_ = NULL;
	ParseNode* _tmp1_ = NULL;
	ParseNode* _tmp2_ = NULL;
	ParseNode* _tmp3_ = NULL;
	ParseNode* _tmp4_ = NULL;
#line 1199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (self != NULL);
#line 1199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (node != NULL);
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = node;
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp0_ == NULL) {
#line 1202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return;
#line 9491 "equation-parser.c"
	}
#line 1204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = node;
#line 1204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = _tmp1_->left;
#line 1204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_destroy_all_nodes (self, _tmp2_);
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = node;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = _tmp3_->right;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_destroy_all_nodes (self, _tmp4_);
#line 9505 "equation-parser.c"
}


static gboolean parser_check_variable (Parser* self, const gchar* name) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint index = 0;
	gunichar c = 0U;
#line 1213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = name;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = parser_variable_is_defined (self, _tmp0_);
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp1_) {
#line 1217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = TRUE;
#line 1217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 9529 "equation-parser.c"
	}
#line 1220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	index = 0;
#line 1222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	while (TRUE) {
#line 9535 "equation-parser.c"
		const gchar* _tmp2_ = NULL;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_ = FALSE;
		gunichar _tmp5_ = 0U;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 1222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = name;
#line 1222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = string_get_next_char (_tmp2_, &index, &_tmp3_);
#line 1222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		c = _tmp3_;
#line 1222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp4_) {
#line 1222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			break;
#line 9554 "equation-parser.c"
		}
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = c;
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = g_unichar_to_string (_tmp5_);
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = _tmp6_;
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = parser_variable_is_defined (self, _tmp7_);
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = !_tmp8_;
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (_tmp7_);
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp9_) {
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 9574 "equation-parser.c"
		}
	}
#line 1228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = TRUE;
#line 1228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 9581 "equation-parser.c"
}


static gboolean parser_statement (Parser* self) {
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	LexerToken* _tmp3_ = NULL;
	LexerTokenType _tmp4_ = 0;
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->lexer;
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = lexer_get_next_token (_tmp0_);
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp1_;
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = token;
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = _tmp3_->type;
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp4_ == LEXER_TOKEN_TYPE_VARIABLE) {
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = TRUE;
#line 9609 "equation-parser.c"
	} else {
		LexerToken* _tmp5_ = NULL;
		LexerTokenType _tmp6_ = 0;
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = token;
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = _tmp5_->type;
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = _tmp6_ == LEXER_TOKEN_TYPE_FUNCTION;
#line 9619 "equation-parser.c"
	}
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp2_) {
#line 9623 "equation-parser.c"
		LexerToken* token_old = NULL;
		LexerToken* _tmp7_ = NULL;
		LexerToken* _tmp8_ = NULL;
		Lexer* _tmp9_ = NULL;
		LexerToken* _tmp10_ = NULL;
		LexerToken* _tmp11_ = NULL;
		LexerTokenType _tmp12_ = 0;
#line 1236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = token;
#line 1236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 1236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token_old = _tmp8_;
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = self->priv->lexer;
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = lexer_get_next_token (_tmp9_);
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp10_;
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = token;
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = _tmp11_->type;
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp12_ == LEXER_TOKEN_TYPE_ASSIGN) {
#line 9651 "equation-parser.c"
			LexerToken* _tmp13_ = NULL;
			guint _tmp14_ = 0U;
			LexerToken* _tmp15_ = NULL;
			Associativity _tmp16_ = 0;
			NameNode* _tmp17_ = NULL;
			NameNode* _tmp18_ = NULL;
			LexerToken* _tmp19_ = NULL;
			LexerToken* _tmp20_ = NULL;
			Associativity _tmp21_ = 0;
			AssignNode* _tmp22_ = NULL;
			AssignNode* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp13_ = token_old;
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp14_ = parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp15_ = token_old;
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp16_ = parser_get_associativity (self, _tmp15_);
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp17_ = name_node_new (self, _tmp13_, _tmp14_, _tmp16_, NULL);
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp18_ = _tmp17_;
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_insert_into_tree (self, (ParseNode*) _tmp18_);
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp18_);
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp19_ = token;
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp20_ = token;
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp21_ = parser_get_associativity (self, _tmp20_);
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp22_ = assign_node_new (self, _tmp19_, (guint) 0, _tmp21_);
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp23_ = _tmp22_;
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_insert_into_tree (self, (ParseNode*) _tmp23_);
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp23_);
#line 1243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp24_ = parser_expression (self);
#line 1243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!_tmp24_) {
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = FALSE;
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token_old);
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 9706 "equation-parser.c"
			}
#line 1246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = TRUE;
#line 1246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token_old);
#line 1246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 9716 "equation-parser.c"
		} else {
			LexerToken* _tmp25_ = NULL;
			LexerTokenType _tmp26_ = 0;
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp25_ = token;
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp26_ = _tmp25_->type;
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp26_ == LEXER_TOKEN_TYPE_IN) {
#line 9726 "equation-parser.c"
				gboolean _tmp27_ = FALSE;
#line 1250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp27_ = parser_check_base (self);
#line 1250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (!_tmp27_) {
#line 9732 "equation-parser.c"
					Lexer* _tmp28_ = NULL;
					Lexer* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					Lexer* _tmp31_ = NULL;
					LexerToken* _tmp32_ = NULL;
					LexerToken* _tmp33_ = NULL;
					LexerToken* _tmp34_ = NULL;
					LexerToken* _tmp35_ = NULL;
					Associativity _tmp36_ = 0;
					ConvertNode* _tmp37_ = NULL;
					ConvertNode* _tmp38_ = NULL;
					gboolean _tmp39_ = FALSE;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp28_ = self->priv->lexer;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					lexer_roll_back (_tmp28_);
#line 1253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp29_ = self->priv->lexer;
#line 1253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					lexer_roll_back (_tmp29_);
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp30_ = parser_unit (self);
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!_tmp30_) {
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 9765 "equation-parser.c"
					}
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp31_ = self->priv->lexer;
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp32_ = lexer_get_next_token (_tmp31_);
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp33_ = _tmp32_;
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (_tmp33_);
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp34_ = token;
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp35_ = token;
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp36_ = parser_get_associativity (self, _tmp35_);
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp37_ = convert_node_new (self, _tmp34_, (guint) 0, _tmp36_);
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp38_ = _tmp37_;
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					parser_insert_into_tree (self, (ParseNode*) _tmp38_);
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (_tmp38_);
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp39_ = parser_unit (self);
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!_tmp39_) {
#line 1262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 9801 "equation-parser.c"
					}
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = TRUE;
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token_old);
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 9811 "equation-parser.c"
				} else {
					Lexer* _tmp40_ = NULL;
					LexerToken* _tmp41_ = NULL;
					LexerToken* _tmp42_ = NULL;
					LexerTokenType _tmp43_ = 0;
#line 1268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp40_ = self->priv->lexer;
#line 1268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp41_ = lexer_get_next_token (_tmp40_);
#line 1268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					token = _tmp41_;
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp42_ = token;
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp43_ = _tmp42_->type;
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp43_ == LEXER_TOKEN_TYPE_VARIABLE) {
#line 9831 "equation-parser.c"
						LexerToken* _tmp44_ = NULL;
						LexerToken* _tmp45_ = NULL;
						LexerTokenType _tmp46_ = 0;
						guint _tmp47_ = 0U;
						LexerToken* _tmp48_ = NULL;
						Associativity _tmp49_ = 0;
						VariableNode* _tmp50_ = NULL;
						VariableNode* _tmp51_ = NULL;
						LexerToken* _tmp52_ = NULL;
						LexerToken* _tmp53_ = NULL;
						Associativity _tmp54_ = 0;
						LexerToken* _tmp55_ = NULL;
						const gchar* _tmp56_ = NULL;
						ConvertBaseNode* _tmp57_ = NULL;
						ConvertBaseNode* _tmp58_ = NULL;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp44_ = token_old;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp45_ = token_old;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp46_ = _tmp45_->type;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp47_ = parser_make_precedence_t (self, _tmp46_);
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp48_ = token_old;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp49_ = parser_get_associativity (self, _tmp48_);
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp50_ = variable_node_new (self, _tmp44_, _tmp47_, _tmp49_);
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp51_ = _tmp50_;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_insert_into_tree (self, (ParseNode*) _tmp51_);
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (_tmp51_);
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp52_ = token;
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp53_ = token;
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp54_ = parser_get_associativity (self, _tmp53_);
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp55_ = token;
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp56_ = _tmp55_->text;
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp57_ = convert_base_node_new (self, _tmp52_, (guint) 0, _tmp54_, _tmp56_);
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp58_ = _tmp57_;
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_insert_into_tree (self, (ParseNode*) _tmp58_);
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (_tmp58_);
#line 1273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = TRUE;
#line 1273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 9893 "equation-parser.c"
					} else {
						Lexer* _tmp59_ = NULL;
						Lexer* _tmp60_ = NULL;
						Lexer* _tmp61_ = NULL;
						LexerToken* _tmp62_ = NULL;
						const gchar* _tmp63_ = NULL;
						LexerToken* _tmp64_ = NULL;
						guint _tmp65_ = 0U;
						LexerToken* _tmp66_ = NULL;
						guint _tmp67_ = 0U;
#line 1277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp59_ = self->priv->lexer;
#line 1277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp59_);
#line 1278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp60_ = self->priv->lexer;
#line 1278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp60_);
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp61_ = self->priv->lexer;
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp61_);
#line 1280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp62_ = token;
#line 1280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp63_ = _tmp62_->text;
#line 1280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp64_ = token;
#line 1280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp65_ = _tmp64_->start_index;
#line 1280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp66_ = token;
#line 1280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp67_ = _tmp66_->end_index;
#line 1280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_set_error (self, ERROR_CODE_UNKNOWN_CONVERSION, _tmp63_, _tmp65_, _tmp67_);
#line 1281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 9938 "equation-parser.c"
					}
				}
			} else {
				LexerToken* _tmp68_ = NULL;
				LexerTokenType _tmp69_ = 0;
#line 1286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp68_ = token;
#line 1286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp69_ = _tmp68_->type;
#line 1286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (_tmp69_ == LEXER_TOKEN_TYPE_SUP_NUMBER) {
#line 9950 "equation-parser.c"
					Lexer* _tmp70_ = NULL;
					LexerToken* _tmp71_ = NULL;
					LexerToken* _tmp72_ = NULL;
					LexerTokenType _tmp73_ = 0;
#line 1288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp70_ = self->priv->lexer;
#line 1288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp71_ = lexer_get_next_token (_tmp70_);
#line 1288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					token = _tmp71_;
#line 1289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp72_ = token;
#line 1289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp73_ = _tmp72_->type;
#line 1289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp73_ == LEXER_TOKEN_TYPE_IN) {
#line 9969 "equation-parser.c"
						Lexer* _tmp74_ = NULL;
						Lexer* _tmp75_ = NULL;
						Lexer* _tmp76_ = NULL;
						gboolean _tmp77_ = FALSE;
						Lexer* _tmp78_ = NULL;
						LexerToken* _tmp79_ = NULL;
						LexerToken* _tmp80_ = NULL;
						LexerToken* _tmp81_ = NULL;
						LexerToken* _tmp82_ = NULL;
						Associativity _tmp83_ = 0;
						ConvertNode* _tmp84_ = NULL;
						ConvertNode* _tmp85_ = NULL;
						gboolean _tmp86_ = FALSE;
#line 1291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp74_ = self->priv->lexer;
#line 1291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp74_);
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp75_ = self->priv->lexer;
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp75_);
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp76_ = self->priv->lexer;
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp76_);
#line 1294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp77_ = parser_unit (self);
#line 1294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (!_tmp77_) {
#line 1295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = FALSE;
#line 1295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token_old);
#line 1295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 10007 "equation-parser.c"
						}
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp78_ = self->priv->lexer;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp79_ = lexer_get_next_token (_tmp78_);
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp80_ = _tmp79_;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (_tmp80_);
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp81_ = token;
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp82_ = token;
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp83_ = parser_get_associativity (self, _tmp82_);
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp84_ = convert_node_new (self, _tmp81_, (guint) 0, _tmp83_);
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp85_ = _tmp84_;
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_insert_into_tree (self, (ParseNode*) _tmp85_);
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (_tmp85_);
#line 1300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp86_ = parser_unit (self);
#line 1300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (!_tmp86_) {
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = FALSE;
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token_old);
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 10043 "equation-parser.c"
						}
#line 1303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = TRUE;
#line 1303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 10053 "equation-parser.c"
					} else {
						Lexer* _tmp87_ = NULL;
						Lexer* _tmp88_ = NULL;
						Lexer* _tmp89_ = NULL;
						gboolean _tmp90_ = FALSE;
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp87_ = self->priv->lexer;
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp87_);
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp88_ = self->priv->lexer;
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp88_);
#line 1309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp89_ = self->priv->lexer;
#line 1309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp89_);
#line 1311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp90_ = parser_expression (self);
#line 1311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (!_tmp90_) {
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = FALSE;
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token_old);
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 10083 "equation-parser.c"
						}
#line 1314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = TRUE;
#line 1314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 10093 "equation-parser.c"
					}
				} else {
					Lexer* _tmp91_ = NULL;
					Lexer* _tmp92_ = NULL;
					LexerToken* _tmp93_ = NULL;
					LexerTokenType _tmp94_ = 0;
					gboolean _tmp96_ = FALSE;
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp91_ = self->priv->lexer;
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					lexer_roll_back (_tmp91_);
#line 1320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp92_ = self->priv->lexer;
#line 1320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					lexer_roll_back (_tmp92_);
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp93_ = token;
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp94_ = _tmp93_->type;
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp94_ == LEXER_TOKEN_TYPE_L_R_BRACKET) {
#line 10115 "equation-parser.c"
						gboolean _tmp95_ = FALSE;
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp95_ = parser_function_definition (self);
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (_tmp95_) {
#line 1325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = TRUE;
#line 1325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token_old);
#line 1325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 10129 "equation-parser.c"
						}
					}
#line 1328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp96_ = parser_expression (self);
#line 1328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!_tmp96_) {
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 10144 "equation-parser.c"
					}
#line 1331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = TRUE;
#line 1331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token_old);
#line 1331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 10154 "equation-parser.c"
				}
			}
		}
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token_old);
#line 10160 "equation-parser.c"
	} else {
		LexerToken* _tmp97_ = NULL;
		LexerTokenType _tmp98_ = 0;
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp97_ = token;
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp98_ = _tmp97_->type;
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp98_ == LEXER_TOKEN_TYPE_NUMBER) {
#line 10170 "equation-parser.c"
			LexerToken* token_old = NULL;
			LexerToken* _tmp99_ = NULL;
			LexerToken* _tmp100_ = NULL;
			Lexer* _tmp101_ = NULL;
			LexerToken* _tmp102_ = NULL;
			LexerToken* _tmp103_ = NULL;
			LexerTokenType _tmp104_ = 0;
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp99_ = token;
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp100_ = _g_object_ref0 (_tmp99_);
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			token_old = _tmp100_;
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp101_ = self->priv->lexer;
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp102_ = lexer_get_next_token (_tmp101_);
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			token = _tmp102_;
#line 1338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp103_ = token;
#line 1338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp104_ = _tmp103_->type;
#line 1338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp104_ == LEXER_TOKEN_TYPE_VARIABLE) {
#line 10198 "equation-parser.c"
				Lexer* _tmp105_ = NULL;
				LexerToken* _tmp106_ = NULL;
				LexerToken* _tmp107_ = NULL;
				LexerTokenType _tmp108_ = 0;
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp105_ = self->priv->lexer;
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp106_ = lexer_get_next_token (_tmp105_);
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				token = _tmp106_;
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp107_ = token;
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp108_ = _tmp107_->type;
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (_tmp108_ == LEXER_TOKEN_TYPE_IN) {
#line 10217 "equation-parser.c"
					Lexer* _tmp109_ = NULL;
					Lexer* _tmp110_ = NULL;
					LexerToken* _tmp111_ = NULL;
					LexerToken* _tmp112_ = NULL;
					LexerTokenType _tmp113_ = 0;
					guint _tmp114_ = 0U;
					LexerToken* _tmp115_ = NULL;
					Associativity _tmp116_ = 0;
					ConstantNode* _tmp117_ = NULL;
					ConstantNode* _tmp118_ = NULL;
					gboolean _tmp119_ = FALSE;
					Lexer* _tmp120_ = NULL;
					LexerToken* _tmp121_ = NULL;
					LexerToken* _tmp122_ = NULL;
					LexerToken* _tmp123_ = NULL;
					Associativity _tmp124_ = 0;
					ConvertNumberNode* _tmp125_ = NULL;
					ConvertNumberNode* _tmp126_ = NULL;
					gboolean _tmp127_ = FALSE;
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp109_ = self->priv->lexer;
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					lexer_roll_back (_tmp109_);
#line 1344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp110_ = self->priv->lexer;
#line 1344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					lexer_roll_back (_tmp110_);
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp111_ = token_old;
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp112_ = token_old;
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp113_ = _tmp112_->type;
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp114_ = parser_make_precedence_t (self, _tmp113_);
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp115_ = token;
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp116_ = parser_get_associativity (self, _tmp115_);
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp117_ = constant_node_new (self, _tmp111_, _tmp114_, _tmp116_);
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp118_ = _tmp117_;
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					parser_insert_into_tree (self, (ParseNode*) _tmp118_);
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (_tmp118_);
#line 1348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp119_ = parser_unit (self);
#line 1348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!_tmp119_) {
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 10277 "equation-parser.c"
					}
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp120_ = self->priv->lexer;
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp121_ = lexer_get_next_token (_tmp120_);
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					token = _tmp121_;
#line 1352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp122_ = token;
#line 1352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp123_ = token;
#line 1352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp124_ = parser_get_associativity (self, _tmp123_);
#line 1352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp125_ = convert_number_node_new (self, _tmp122_, (guint) 0, _tmp124_);
#line 1352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp126_ = _tmp125_;
#line 1352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					parser_insert_into_tree (self, (ParseNode*) _tmp126_);
#line 1352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (_tmp126_);
#line 1354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp127_ = parser_unit (self);
#line 1354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!_tmp127_) {
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 10313 "equation-parser.c"
					}
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = TRUE;
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token_old);
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 10323 "equation-parser.c"
				} else {
					LexerToken* _tmp128_ = NULL;
					LexerTokenType _tmp129_ = 0;
#line 1359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp128_ = token;
#line 1359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp129_ = _tmp128_->type;
#line 1359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp129_ == LEXER_TOKEN_TYPE_SUP_NUMBER) {
#line 10333 "equation-parser.c"
						Lexer* _tmp130_ = NULL;
						LexerToken* _tmp131_ = NULL;
						LexerToken* _tmp132_ = NULL;
						LexerTokenType _tmp133_ = 0;
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp130_ = self->priv->lexer;
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp131_ = lexer_get_next_token (_tmp130_);
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						token = _tmp131_;
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp132_ = token;
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp133_ = _tmp132_->type;
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (_tmp133_ == LEXER_TOKEN_TYPE_IN) {
#line 10352 "equation-parser.c"
							Lexer* _tmp134_ = NULL;
							Lexer* _tmp135_ = NULL;
							Lexer* _tmp136_ = NULL;
							LexerToken* _tmp137_ = NULL;
							LexerToken* _tmp138_ = NULL;
							LexerTokenType _tmp139_ = 0;
							guint _tmp140_ = 0U;
							LexerToken* _tmp141_ = NULL;
							Associativity _tmp142_ = 0;
							ConstantNode* _tmp143_ = NULL;
							ConstantNode* _tmp144_ = NULL;
							gboolean _tmp145_ = FALSE;
							Lexer* _tmp146_ = NULL;
							LexerToken* _tmp147_ = NULL;
							LexerToken* _tmp148_ = NULL;
							LexerToken* _tmp149_ = NULL;
							Associativity _tmp150_ = 0;
							ConvertNumberNode* _tmp151_ = NULL;
							ConvertNumberNode* _tmp152_ = NULL;
							gboolean _tmp153_ = FALSE;
#line 1364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp134_ = self->priv->lexer;
#line 1364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							lexer_roll_back (_tmp134_);
#line 1365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp135_ = self->priv->lexer;
#line 1365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							lexer_roll_back (_tmp135_);
#line 1366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp136_ = self->priv->lexer;
#line 1366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							lexer_roll_back (_tmp136_);
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp137_ = token_old;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp138_ = token_old;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp139_ = _tmp138_->type;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp140_ = parser_make_precedence_t (self, _tmp139_);
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp141_ = token;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp142_ = parser_get_associativity (self, _tmp141_);
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp143_ = constant_node_new (self, _tmp137_, _tmp140_, _tmp142_);
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp144_ = _tmp143_;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							parser_insert_into_tree (self, (ParseNode*) _tmp144_);
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (_tmp144_);
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp145_ = parser_unit (self);
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (!_tmp145_) {
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								result = FALSE;
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token_old);
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token);
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								return result;
#line 10417 "equation-parser.c"
							}
#line 1372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp146_ = self->priv->lexer;
#line 1372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp147_ = lexer_get_next_token (_tmp146_);
#line 1372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							token = _tmp147_;
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp148_ = token;
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp149_ = token;
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp150_ = parser_get_associativity (self, _tmp149_);
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp151_ = convert_number_node_new (self, _tmp148_, (guint) 0, _tmp150_);
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp152_ = _tmp151_;
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							parser_insert_into_tree (self, (ParseNode*) _tmp152_);
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (_tmp152_);
#line 1376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp153_ = parser_unit (self);
#line 1376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (!_tmp153_) {
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								result = FALSE;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token_old);
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token);
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								return result;
#line 10453 "equation-parser.c"
							}
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = TRUE;
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token_old);
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 10463 "equation-parser.c"
						} else {
							Lexer* _tmp154_ = NULL;
							Lexer* _tmp155_ = NULL;
							Lexer* _tmp156_ = NULL;
							Lexer* _tmp157_ = NULL;
							gboolean _tmp158_ = FALSE;
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp154_ = self->priv->lexer;
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							lexer_roll_back (_tmp154_);
#line 1383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp155_ = self->priv->lexer;
#line 1383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							lexer_roll_back (_tmp155_);
#line 1384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp156_ = self->priv->lexer;
#line 1384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							lexer_roll_back (_tmp156_);
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp157_ = self->priv->lexer;
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							lexer_roll_back (_tmp157_);
#line 1386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp158_ = parser_expression (self);
#line 1386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (!_tmp158_) {
#line 1387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								result = FALSE;
#line 1387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token_old);
#line 1387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token);
#line 1387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								return result;
#line 10498 "equation-parser.c"
							}
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = TRUE;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token_old);
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 10508 "equation-parser.c"
						}
					} else {
						Lexer* _tmp159_ = NULL;
						Lexer* _tmp160_ = NULL;
						Lexer* _tmp161_ = NULL;
						gboolean _tmp162_ = FALSE;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp159_ = self->priv->lexer;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp159_);
#line 1394 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp160_ = self->priv->lexer;
#line 1394 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp160_);
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp161_ = self->priv->lexer;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp161_);
#line 1396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp162_ = parser_expression (self);
#line 1396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (!_tmp162_) {
#line 1397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = FALSE;
#line 1397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token_old);
#line 1397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 10539 "equation-parser.c"
						}
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = TRUE;
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 10549 "equation-parser.c"
					}
				}
			} else {
				LexerToken* _tmp163_ = NULL;
				LexerTokenType _tmp164_ = 0;
#line 1401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp163_ = token;
#line 1401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp164_ = _tmp163_->type;
#line 1401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (_tmp164_ == LEXER_TOKEN_TYPE_IN) {
#line 10561 "equation-parser.c"
					Lexer* _tmp165_ = NULL;
					LexerToken* _tmp166_ = NULL;
					LexerToken* _tmp167_ = NULL;
					LexerTokenType _tmp168_ = 0;
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp165_ = self->priv->lexer;
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp166_ = lexer_get_next_token (_tmp165_);
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					token = _tmp166_;
#line 1404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp167_ = token;
#line 1404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp168_ = _tmp167_->type;
#line 1404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp168_ == LEXER_TOKEN_TYPE_VARIABLE) {
#line 10580 "equation-parser.c"
						LexerToken* _tmp169_ = NULL;
						LexerToken* _tmp170_ = NULL;
						LexerTokenType _tmp171_ = 0;
						guint _tmp172_ = 0U;
						LexerToken* _tmp173_ = NULL;
						Associativity _tmp174_ = 0;
						ConstantNode* _tmp175_ = NULL;
						ConstantNode* _tmp176_ = NULL;
						LexerToken* _tmp177_ = NULL;
						LexerToken* _tmp178_ = NULL;
						Associativity _tmp179_ = 0;
						LexerToken* _tmp180_ = NULL;
						const gchar* _tmp181_ = NULL;
						ConvertBaseNode* _tmp182_ = NULL;
						ConvertBaseNode* _tmp183_ = NULL;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp169_ = token_old;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp170_ = token_old;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp171_ = _tmp170_->type;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp172_ = parser_make_precedence_t (self, _tmp171_);
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp173_ = token;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp174_ = parser_get_associativity (self, _tmp173_);
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp175_ = constant_node_new (self, _tmp169_, _tmp172_, _tmp174_);
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp176_ = _tmp175_;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_insert_into_tree (self, (ParseNode*) _tmp176_);
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (_tmp176_);
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp177_ = token;
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp178_ = token;
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp179_ = parser_get_associativity (self, _tmp178_);
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp180_ = token;
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp181_ = _tmp180_->text;
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp182_ = convert_base_node_new (self, _tmp177_, (guint) 0, _tmp179_, _tmp181_);
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp183_ = _tmp182_;
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_insert_into_tree (self, (ParseNode*) _tmp183_);
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (_tmp183_);
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = TRUE;
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 10642 "equation-parser.c"
					} else {
						Lexer* _tmp184_ = NULL;
						Lexer* _tmp185_ = NULL;
						Lexer* _tmp186_ = NULL;
						LexerToken* _tmp187_ = NULL;
						const gchar* _tmp188_ = NULL;
						LexerToken* _tmp189_ = NULL;
						guint _tmp190_ = 0U;
						LexerToken* _tmp191_ = NULL;
						guint _tmp192_ = 0U;
#line 1412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp184_ = self->priv->lexer;
#line 1412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp184_);
#line 1413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp185_ = self->priv->lexer;
#line 1413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp185_);
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp186_ = self->priv->lexer;
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						lexer_roll_back (_tmp186_);
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp187_ = token;
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp188_ = _tmp187_->text;
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp189_ = token;
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp190_ = _tmp189_->start_index;
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp191_ = token;
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp192_ = _tmp191_->end_index;
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_set_error (self, ERROR_CODE_UNKNOWN_CONVERSION, _tmp188_, _tmp190_, _tmp192_);
#line 1416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 10687 "equation-parser.c"
					}
				} else {
					Lexer* _tmp193_ = NULL;
					Lexer* _tmp194_ = NULL;
					gboolean _tmp195_ = FALSE;
#line 1421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp193_ = self->priv->lexer;
#line 1421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					lexer_roll_back (_tmp193_);
#line 1422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp194_ = self->priv->lexer;
#line 1422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					lexer_roll_back (_tmp194_);
#line 1423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp195_ = parser_expression (self);
#line 1423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!_tmp195_) {
#line 1424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token_old);
#line 1424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 10713 "equation-parser.c"
					}
#line 1425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = TRUE;
#line 1425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token_old);
#line 1425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 10723 "equation-parser.c"
				}
			}
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token_old);
#line 10728 "equation-parser.c"
		} else {
			Lexer* _tmp196_ = NULL;
			gboolean _tmp197_ = FALSE;
#line 1430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp196_ = self->priv->lexer;
#line 1430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			lexer_roll_back (_tmp196_);
#line 1431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp197_ = parser_expression (self);
#line 1431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!_tmp197_) {
#line 1432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = FALSE;
#line 1432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 10746 "equation-parser.c"
			}
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = TRUE;
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 10754 "equation-parser.c"
		}
	}
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 10759 "equation-parser.c"
}


static gboolean parser_function_definition (Parser* self) {
	gboolean result = FALSE;
	gint num_token_parsed = 0;
	LexerToken* token = NULL;
	Lexer* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* function_name = NULL;
	LexerToken* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Lexer* _tmp6_ = NULL;
	LexerToken* _tmp7_ = NULL;
	LexerToken* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Lexer* _tmp10_ = NULL;
	LexerToken* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* argument_list = NULL;
	gchar* _tmp13_ = NULL;
	LexerToken* _tmp26_ = NULL;
	LexerTokenType _tmp27_ = 0;
	LexerToken* assign_token = NULL;
	Lexer* _tmp30_ = NULL;
	LexerToken* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	LexerToken* _tmp33_ = NULL;
	LexerTokenType _tmp34_ = 0;
	gchar* expression = NULL;
	gchar* _tmp37_ = NULL;
	Lexer* _tmp38_ = NULL;
	LexerToken* _tmp39_ = NULL;
	guint _tmp48_ = 0U;
	Associativity _tmp49_ = 0;
	const gchar* _tmp50_ = NULL;
	FunctionNameNode* _tmp51_ = NULL;
	FunctionNameNode* _tmp52_ = NULL;
	guint _tmp53_ = 0U;
	Associativity _tmp54_ = 0;
	FunctionNode* _tmp55_ = NULL;
	FunctionNode* _tmp56_ = NULL;
	guint _tmp57_ = 0U;
	Associativity _tmp58_ = 0;
	const gchar* _tmp59_ = NULL;
	FunctionArgumentsNode* _tmp60_ = NULL;
	FunctionArgumentsNode* _tmp61_ = NULL;
	LexerToken* _tmp62_ = NULL;
	LexerToken* _tmp63_ = NULL;
	Associativity _tmp64_ = 0;
	AssignFunctionNode* _tmp65_ = NULL;
	AssignFunctionNode* _tmp66_ = NULL;
	guint _tmp67_ = 0U;
	Associativity _tmp68_ = 0;
	const gchar* _tmp69_ = NULL;
	FunctionDescriptionNode* _tmp70_ = NULL;
	FunctionDescriptionNode* _tmp71_ = NULL;
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	num_token_parsed = 0;
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->lexer;
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = lexer_get_next_token (_tmp0_);
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp1_;
#line 1441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = num_token_parsed;
#line 1441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	num_token_parsed = _tmp2_ + 1;
#line 1443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = token;
#line 1443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = _tmp3_->text;
#line 1443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 1443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	function_name = _tmp5_;
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = self->priv->lexer;
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp7_ = lexer_get_next_token (_tmp6_);
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp8_ = _tmp7_;
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (_tmp8_);
#line 1445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = num_token_parsed;
#line 1445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	num_token_parsed = _tmp9_ + 1;
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp10_ = self->priv->lexer;
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp11_ = lexer_get_next_token (_tmp10_);
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp11_;
#line 1448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp12_ = num_token_parsed;
#line 1448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	num_token_parsed = _tmp12_ + 1;
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp13_ = g_strdup ("");
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	argument_list = _tmp13_;
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	while (TRUE) {
#line 10871 "equation-parser.c"
		gboolean _tmp14_ = FALSE;
		LexerToken* _tmp15_ = NULL;
		LexerTokenType _tmp16_ = 0;
		const gchar* _tmp19_ = NULL;
		LexerToken* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		Lexer* _tmp23_ = NULL;
		LexerToken* _tmp24_ = NULL;
		gint _tmp25_ = 0;
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = token;
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp16_ = _tmp15_->type;
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp16_ != LEXER_TOKEN_TYPE_R_R_BRACKET) {
#line 10888 "equation-parser.c"
			LexerToken* _tmp17_ = NULL;
			LexerTokenType _tmp18_ = 0;
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp17_ = token;
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp18_ = _tmp17_->type;
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp14_ = _tmp18_ != LEXER_TOKEN_TYPE_PL_EOS;
#line 10897 "equation-parser.c"
		} else {
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp14_ = FALSE;
#line 10901 "equation-parser.c"
		}
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp14_) {
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			break;
#line 10907 "equation-parser.c"
		}
#line 1453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp19_ = argument_list;
#line 1453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp20_ = token;
#line 1453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp21_ = _tmp20_->text;
#line 1453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp22_ = g_strconcat (_tmp19_, _tmp21_, NULL);
#line 1453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (argument_list);
#line 1453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		argument_list = _tmp22_;
#line 1454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp23_ = self->priv->lexer;
#line 1454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp24_ = lexer_get_next_token (_tmp23_);
#line 1454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp24_;
#line 1455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp25_ = num_token_parsed;
#line 1455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		num_token_parsed = _tmp25_ + 1;
#line 10933 "equation-parser.c"
	}
#line 1458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp26_ = token;
#line 1458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp27_ = _tmp26_->type;
#line 1458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp27_ == LEXER_TOKEN_TYPE_PL_EOS) {
#line 1460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 10943 "equation-parser.c"
			gint _tmp28_ = 0;
			Lexer* _tmp29_ = NULL;
#line 1460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp28_ = num_token_parsed;
#line 1460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			num_token_parsed = _tmp28_ - 1;
#line 1460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp28_ > 0)) {
#line 1460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 10954 "equation-parser.c"
			}
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp29_ = self->priv->lexer;
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			lexer_roll_back (_tmp29_);
#line 10960 "equation-parser.c"
		}
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = FALSE;
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (argument_list);
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (function_name);
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 10972 "equation-parser.c"
	}
#line 1465 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp30_ = self->priv->lexer;
#line 1465 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp31_ = lexer_get_next_token (_tmp30_);
#line 1465 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	assign_token = _tmp31_;
#line 1466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp32_ = num_token_parsed;
#line 1466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	num_token_parsed = _tmp32_ + 1;
#line 1467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp33_ = assign_token;
#line 1467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp34_ = _tmp33_->type;
#line 1467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp34_ != LEXER_TOKEN_TYPE_ASSIGN) {
#line 1469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 10992 "equation-parser.c"
			gint _tmp35_ = 0;
			Lexer* _tmp36_ = NULL;
#line 1469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp35_ = num_token_parsed;
#line 1469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			num_token_parsed = _tmp35_ - 1;
#line 1469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!(_tmp35_ > 0)) {
#line 1469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 11003 "equation-parser.c"
			}
#line 1470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp36_ = self->priv->lexer;
#line 1470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			lexer_roll_back (_tmp36_);
#line 11009 "equation-parser.c"
		}
#line 1471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = FALSE;
#line 1471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (assign_token);
#line 1471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (argument_list);
#line 1471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (function_name);
#line 1471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 11023 "equation-parser.c"
	}
#line 1474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp37_ = g_strdup ("");
#line 1474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	expression = _tmp37_;
#line 1475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp38_ = self->priv->lexer;
#line 1475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp39_ = lexer_get_next_token (_tmp38_);
#line 1475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 1475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp39_;
#line 1476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	while (TRUE) {
#line 11039 "equation-parser.c"
		LexerToken* _tmp40_ = NULL;
		LexerTokenType _tmp41_ = 0;
		const gchar* _tmp42_ = NULL;
		LexerToken* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		Lexer* _tmp46_ = NULL;
		LexerToken* _tmp47_ = NULL;
#line 1476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp40_ = token;
#line 1476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp41_ = _tmp40_->type;
#line 1476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!(_tmp41_ != LEXER_TOKEN_TYPE_PL_EOS)) {
#line 1476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			break;
#line 11056 "equation-parser.c"
		}
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp42_ = expression;
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp43_ = token;
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp44_ = _tmp43_->text;
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp45_ = g_strconcat (_tmp42_, _tmp44_, NULL);
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (expression);
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		expression = _tmp45_;
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp46_ = self->priv->lexer;
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp47_ = lexer_get_next_token (_tmp46_);
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp47_;
#line 11078 "equation-parser.c"
	}
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp48_ = parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp49_ = parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp50_ = function_name;
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp51_ = function_name_node_new (self, NULL, _tmp48_, _tmp49_, _tmp50_);
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp52_ = _tmp51_;
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_insert_into_tree (self, (ParseNode*) _tmp52_);
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (_tmp52_);
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp53_ = parser_make_precedence_p (self, PRECEDENCE_FUNCTION);
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp54_ = parser_get_associativity_p (self, PRECEDENCE_FUNCTION);
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp55_ = function_node_new (self, NULL, _tmp53_, _tmp54_, NULL);
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp56_ = _tmp55_;
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_insert_into_tree (self, (ParseNode*) _tmp56_);
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (_tmp56_);
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp57_ = parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp58_ = parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp59_ = argument_list;
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp60_ = function_arguments_node_new (self, NULL, _tmp57_, _tmp58_, _tmp59_);
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp61_ = _tmp60_;
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_insert_into_tree (self, (ParseNode*) _tmp61_);
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (_tmp61_);
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp62_ = assign_token;
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp63_ = assign_token;
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp64_ = parser_get_associativity (self, _tmp63_);
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp65_ = assign_function_node_new (self, _tmp62_, (guint) 0, _tmp64_);
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp66_ = _tmp65_;
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_insert_into_tree (self, (ParseNode*) _tmp66_);
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (_tmp66_);
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp67_ = parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp68_ = parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp69_ = expression;
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp70_ = function_description_node_new (self, NULL, _tmp67_, _tmp68_, _tmp69_);
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp71_ = _tmp70_;
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_insert_into_tree (self, (ParseNode*) _tmp71_);
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (_tmp71_);
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = TRUE;
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (expression);
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (assign_token);
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (argument_list);
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (function_name);
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 11162 "equation-parser.c"
}


static gboolean parser_check_base (Parser* self) {
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	Lexer* _tmp9_ = NULL;
#line 1491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->lexer;
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = lexer_get_next_token (_tmp0_);
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp1_;
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = _tmp2_ = g_strsplit ("hex,hexadecimal,dec,decimal,oct,octal,bin,binary", ",", 0);
#line 11184 "equation-parser.c"
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		s_collection = _tmp3_;
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		s_collection_length1 = _vala_array_length (_tmp2_);
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		for (s_it = 0; s_it < _vala_array_length (_tmp2_); s_it = s_it + 1) {
#line 11196 "equation-parser.c"
			gchar* _tmp4_ = NULL;
			gchar* s = NULL;
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp4_ = g_strdup (s_collection[s_it]);
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			s = _tmp4_;
#line 11203 "equation-parser.c"
			{
				LexerToken* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp5_ = token;
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp6_ = _tmp5_->text;
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp7_ = s;
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
#line 11216 "equation-parser.c"
					Lexer* _tmp8_ = NULL;
#line 1498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp8_ = self->priv->lexer;
#line 1498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					lexer_roll_back (_tmp8_);
#line 1499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = TRUE;
#line 1499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_free0 (s);
#line 1499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 11232 "equation-parser.c"
				}
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_free0 (s);
#line 11236 "equation-parser.c"
			}
		}
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
#line 11241 "equation-parser.c"
	}
#line 1502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = self->priv->lexer;
#line 1502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	lexer_roll_back (_tmp9_);
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = FALSE;
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 1503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 11253 "equation-parser.c"
}


static gboolean parser_unit (Parser* self) {
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	LexerToken* _tmp2_ = NULL;
	LexerTokenType _tmp3_ = 0;
#line 1506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->lexer;
#line 1508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = lexer_get_next_token (_tmp0_);
#line 1508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp1_;
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = token;
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = _tmp2_->type;
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp3_ == LEXER_TOKEN_TYPE_VARIABLE) {
#line 11278 "equation-parser.c"
		LexerToken* token_old = NULL;
		LexerToken* _tmp4_ = NULL;
		LexerToken* _tmp5_ = NULL;
		Lexer* _tmp6_ = NULL;
		LexerToken* _tmp7_ = NULL;
		LexerToken* _tmp8_ = NULL;
		LexerTokenType _tmp9_ = 0;
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = token;
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token_old = _tmp5_;
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = self->priv->lexer;
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = lexer_get_next_token (_tmp6_);
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp7_;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = token;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = _tmp8_->type;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp9_ == LEXER_TOKEN_TYPE_SUP_NUMBER) {
#line 11306 "equation-parser.c"
			LexerToken* _tmp10_ = NULL;
			LexerToken* _tmp11_ = NULL;
			LexerTokenType _tmp12_ = 0;
			guint _tmp13_ = 0U;
			LexerToken* _tmp14_ = NULL;
			Associativity _tmp15_ = 0;
			LexerToken* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			LexerToken* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			NameNode* _tmp22_ = NULL;
			NameNode* _tmp23_ = NULL;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp10_ = token_old;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp11_ = token_old;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp12_ = _tmp11_->type;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp13_ = parser_make_precedence_t (self, _tmp12_);
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp14_ = token_old;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp15_ = parser_get_associativity (self, _tmp14_);
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp16_ = token_old;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp17_ = _tmp16_->text;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp18_ = token;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp19_ = _tmp18_->text;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp20_ = g_strconcat (_tmp17_, _tmp19_, NULL);
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp21_ = _tmp20_;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp22_ = name_node_new (self, _tmp10_, _tmp13_, _tmp15_, _tmp21_);
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp23_ = _tmp22_;
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_insert_into_tree (self, (ParseNode*) _tmp23_);
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp23_);
#line 1515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (_tmp21_);
#line 1516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = TRUE;
#line 1516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token_old);
#line 1516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 11363 "equation-parser.c"
		} else {
			Lexer* _tmp24_ = NULL;
			LexerToken* _tmp25_ = NULL;
			LexerToken* _tmp26_ = NULL;
			LexerTokenType _tmp27_ = 0;
			guint _tmp28_ = 0U;
			LexerToken* _tmp29_ = NULL;
			Associativity _tmp30_ = 0;
			NameNode* _tmp31_ = NULL;
			NameNode* _tmp32_ = NULL;
#line 1520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp24_ = self->priv->lexer;
#line 1520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			lexer_roll_back (_tmp24_);
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp25_ = token_old;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp26_ = token_old;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp27_ = _tmp26_->type;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp28_ = parser_make_precedence_t (self, _tmp27_);
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp29_ = token_old;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp30_ = parser_get_associativity (self, _tmp29_);
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp31_ = name_node_new (self, _tmp25_, _tmp28_, _tmp30_, NULL);
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp32_ = _tmp31_;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_insert_into_tree (self, (ParseNode*) _tmp32_);
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp32_);
#line 1522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = TRUE;
#line 1522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token_old);
#line 1522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 11406 "equation-parser.c"
		}
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token_old);
#line 11410 "equation-parser.c"
	} else {
		Lexer* _tmp33_ = NULL;
#line 1527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp33_ = self->priv->lexer;
#line 1527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		lexer_roll_back (_tmp33_);
#line 1528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = FALSE;
#line 1528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 11423 "equation-parser.c"
	}
#line 1506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 11427 "equation-parser.c"
}


static gboolean parser_expression (Parser* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = parser_expression_1 (self);
#line 1534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (!_tmp0_) {
#line 1535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = FALSE;
#line 1535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 11445 "equation-parser.c"
	}
#line 1536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = parser_expression_2 (self);
#line 1536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (!_tmp1_) {
#line 1537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = FALSE;
#line 1537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 11455 "equation-parser.c"
	}
#line 1539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = TRUE;
#line 1539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 11461 "equation-parser.c"
}


static gboolean parser_expression_1 (Parser* self) {
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	LexerToken* _tmp3_ = NULL;
	LexerTokenType _tmp4_ = 0;
	LexerToken* _tmp8_ = NULL;
	LexerTokenType _tmp9_ = 0;
#line 1542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->lexer;
#line 1544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = lexer_get_next_token (_tmp0_);
#line 1544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp1_;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = token;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = _tmp3_->type;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp4_ == LEXER_TOKEN_TYPE_PL_EOS) {
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = TRUE;
#line 11491 "equation-parser.c"
	} else {
		LexerToken* _tmp5_ = NULL;
		LexerTokenType _tmp6_ = 0;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = token;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = _tmp5_->type;
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp2_ = _tmp6_ == LEXER_TOKEN_TYPE_ASSIGN;
#line 11501 "equation-parser.c"
	}
#line 1546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp2_) {
#line 11505 "equation-parser.c"
		Lexer* _tmp7_ = NULL;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = self->priv->lexer;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		lexer_roll_back (_tmp7_);
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = FALSE;
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 11517 "equation-parser.c"
	}
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp8_ = token;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = _tmp8_->type;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp9_ == LEXER_TOKEN_TYPE_L_R_BRACKET) {
#line 11525 "equation-parser.c"
		guint _tmp10_ = 0U;
		gboolean _tmp11_ = FALSE;
		Lexer* _tmp12_ = NULL;
		LexerToken* _tmp13_ = NULL;
		LexerToken* _tmp14_ = NULL;
		LexerTokenType _tmp15_ = 0;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = self->priv->depth_level;
#line 1554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		self->priv->depth_level = _tmp10_ + 1;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = parser_expression (self);
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp11_) {
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 11546 "equation-parser.c"
		}
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = self->priv->lexer;
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = lexer_get_next_token (_tmp12_);
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp13_;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = token;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = _tmp14_->type;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp15_ == LEXER_TOKEN_TYPE_R_R_BRACKET) {
#line 11562 "equation-parser.c"
			guint _tmp16_ = 0U;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp16_ = self->priv->depth_level;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			self->priv->depth_level = _tmp16_ - 1;
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = TRUE;
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 11574 "equation-parser.c"
		} else {
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 11582 "equation-parser.c"
		}
	} else {
		LexerToken* _tmp17_ = NULL;
		LexerTokenType _tmp18_ = 0;
#line 1569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp17_ = token;
#line 1569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp18_ = _tmp17_->type;
#line 1569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp18_ == LEXER_TOKEN_TYPE_L_S_BRACKET) {
#line 11593 "equation-parser.c"
			guint _tmp19_ = 0U;
			LexerToken* _tmp20_ = NULL;
			guint _tmp21_ = 0U;
			LexerToken* _tmp22_ = NULL;
			Associativity _tmp23_ = 0;
			RoundNode* _tmp24_ = NULL;
			RoundNode* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			Lexer* _tmp27_ = NULL;
			LexerToken* _tmp28_ = NULL;
			LexerToken* _tmp29_ = NULL;
			LexerTokenType _tmp30_ = 0;
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp19_ = self->priv->depth_level;
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			self->priv->depth_level = _tmp19_ + 1;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp20_ = token;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp21_ = parser_make_precedence_p (self, PRECEDENCE_UNKNOWN);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp22_ = token;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp23_ = parser_get_associativity (self, _tmp22_);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp24_ = round_node_new (self, _tmp20_, _tmp21_, _tmp23_);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp25_ = _tmp24_;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_insert_into_tree_unary (self, (ParseNode*) _tmp25_);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp25_);
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp26_ = parser_expression (self);
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!_tmp26_) {
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = FALSE;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 11636 "equation-parser.c"
			}
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp27_ = self->priv->lexer;
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp28_ = lexer_get_next_token (_tmp27_);
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			token = _tmp28_;
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp29_ = token;
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp30_ = _tmp29_->type;
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp30_ == LEXER_TOKEN_TYPE_R_S_BRACKET) {
#line 11652 "equation-parser.c"
				guint _tmp31_ = 0U;
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp31_ = self->priv->depth_level;
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				self->priv->depth_level = _tmp31_ - 1;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = TRUE;
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 11664 "equation-parser.c"
			} else {
#line 1588 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = FALSE;
#line 1588 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1588 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 11672 "equation-parser.c"
			}
		} else {
			LexerToken* _tmp32_ = NULL;
			LexerTokenType _tmp33_ = 0;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp32_ = token;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp33_ = _tmp32_->type;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp33_ == LEXER_TOKEN_TYPE_L_C_BRACKET) {
#line 11683 "equation-parser.c"
				guint _tmp34_ = 0U;
				LexerToken* _tmp35_ = NULL;
				guint _tmp36_ = 0U;
				LexerToken* _tmp37_ = NULL;
				Associativity _tmp38_ = 0;
				FractionalComponentNode* _tmp39_ = NULL;
				FractionalComponentNode* _tmp40_ = NULL;
				gboolean _tmp41_ = FALSE;
				Lexer* _tmp42_ = NULL;
				LexerToken* _tmp43_ = NULL;
				LexerToken* _tmp44_ = NULL;
				LexerTokenType _tmp45_ = 0;
#line 1592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp34_ = self->priv->depth_level;
#line 1592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				self->priv->depth_level = _tmp34_ + 1;
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp35_ = token;
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp36_ = parser_make_precedence_p (self, PRECEDENCE_UNKNOWN);
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp37_ = token;
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp38_ = parser_get_associativity (self, _tmp37_);
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp39_ = fractional_component_node_new (self, _tmp35_, _tmp36_, _tmp38_);
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp40_ = _tmp39_;
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				parser_insert_into_tree_unary (self, (ParseNode*) _tmp40_);
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (_tmp40_);
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp41_ = parser_expression (self);
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (!_tmp41_) {
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = FALSE;
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 11726 "equation-parser.c"
				}
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp42_ = self->priv->lexer;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp43_ = lexer_get_next_token (_tmp42_);
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				token = _tmp43_;
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp44_ = token;
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp45_ = _tmp44_->type;
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (_tmp45_ == LEXER_TOKEN_TYPE_R_C_BRACKET) {
#line 11742 "equation-parser.c"
					guint _tmp46_ = 0U;
#line 1604 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp46_ = self->priv->depth_level;
#line 1604 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					self->priv->depth_level = _tmp46_ - 1;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = TRUE;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 11754 "equation-parser.c"
				} else {
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = FALSE;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 11762 "equation-parser.c"
				}
			} else {
				LexerToken* _tmp47_ = NULL;
				LexerTokenType _tmp48_ = 0;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp47_ = token;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp48_ = _tmp47_->type;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (_tmp48_ == LEXER_TOKEN_TYPE_ABS) {
#line 11773 "equation-parser.c"
					guint _tmp49_ = 0U;
					LexerToken* _tmp50_ = NULL;
					guint _tmp51_ = 0U;
					LexerToken* _tmp52_ = NULL;
					Associativity _tmp53_ = 0;
					AbsoluteValueNode* _tmp54_ = NULL;
					AbsoluteValueNode* _tmp55_ = NULL;
					gboolean _tmp56_ = FALSE;
					Lexer* _tmp57_ = NULL;
					LexerToken* _tmp58_ = NULL;
					LexerToken* _tmp59_ = NULL;
					LexerTokenType _tmp60_ = 0;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp49_ = self->priv->depth_level;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					self->priv->depth_level = _tmp49_ + 1;
#line 1617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp50_ = token;
#line 1617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp51_ = parser_make_precedence_p (self, PRECEDENCE_UNKNOWN);
#line 1617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp52_ = token;
#line 1617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp53_ = parser_get_associativity (self, _tmp52_);
#line 1617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp54_ = absolute_value_node_new (self, _tmp50_, _tmp51_, _tmp53_);
#line 1617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp55_ = _tmp54_;
#line 1617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					parser_insert_into_tree_unary (self, (ParseNode*) _tmp55_);
#line 1617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (_tmp55_);
#line 1619 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp56_ = parser_expression (self);
#line 1619 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!_tmp56_) {
#line 1620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 11816 "equation-parser.c"
					}
#line 1622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp57_ = self->priv->lexer;
#line 1622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp58_ = lexer_get_next_token (_tmp57_);
#line 1622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					token = _tmp58_;
#line 1623 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp59_ = token;
#line 1623 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp60_ = _tmp59_->type;
#line 1623 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp60_ == LEXER_TOKEN_TYPE_ABS) {
#line 11832 "equation-parser.c"
						guint _tmp61_ = 0U;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp61_ = self->priv->depth_level;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						self->priv->depth_level = _tmp61_ - 1;
#line 1626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = TRUE;
#line 1626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 11844 "equation-parser.c"
					} else {
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 11852 "equation-parser.c"
					}
				} else {
					LexerToken* _tmp62_ = NULL;
					LexerTokenType _tmp63_ = 0;
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp62_ = token;
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp63_ = _tmp62_->type;
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp63_ == LEXER_TOKEN_TYPE_NOT) {
#line 11863 "equation-parser.c"
						LexerToken* _tmp64_ = NULL;
						guint _tmp65_ = 0U;
						LexerToken* _tmp66_ = NULL;
						Associativity _tmp67_ = 0;
						NotNode* _tmp68_ = NULL;
						NotNode* _tmp69_ = NULL;
						gboolean _tmp70_ = FALSE;
#line 1634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp64_ = token;
#line 1634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp65_ = parser_make_precedence_p (self, PRECEDENCE_NOT);
#line 1634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp66_ = token;
#line 1634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp67_ = parser_get_associativity (self, _tmp66_);
#line 1634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp68_ = not_node_new (self, _tmp64_, _tmp65_, _tmp67_);
#line 1634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp69_ = _tmp68_;
#line 1634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_insert_into_tree_unary (self, (ParseNode*) _tmp69_);
#line 1634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (_tmp69_);
#line 1636 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp70_ = parser_expression (self);
#line 1636 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (!_tmp70_) {
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = FALSE;
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 11897 "equation-parser.c"
						}
#line 1639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = TRUE;
#line 1639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 11905 "equation-parser.c"
					} else {
						LexerToken* _tmp71_ = NULL;
						LexerTokenType _tmp72_ = 0;
#line 1641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp71_ = token;
#line 1641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp72_ = _tmp71_->type;
#line 1641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (_tmp72_ == LEXER_TOKEN_TYPE_NUMBER) {
#line 11915 "equation-parser.c"
							LexerToken* _tmp73_ = NULL;
							LexerToken* _tmp74_ = NULL;
							LexerTokenType _tmp75_ = 0;
							guint _tmp76_ = 0U;
							LexerToken* _tmp77_ = NULL;
							Associativity _tmp78_ = 0;
							ConstantNode* _tmp79_ = NULL;
							ConstantNode* _tmp80_ = NULL;
							Lexer* _tmp81_ = NULL;
							LexerToken* _tmp82_ = NULL;
							Lexer* _tmp83_ = NULL;
							gboolean _tmp84_ = FALSE;
							gboolean _tmp85_ = FALSE;
							gboolean _tmp86_ = FALSE;
							gboolean _tmp87_ = FALSE;
							gboolean _tmp88_ = FALSE;
							LexerToken* _tmp89_ = NULL;
							LexerTokenType _tmp90_ = 0;
#line 1643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp73_ = token;
#line 1643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp74_ = token;
#line 1643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp75_ = _tmp74_->type;
#line 1643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp76_ = parser_make_precedence_t (self, _tmp75_);
#line 1643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp77_ = token;
#line 1643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp78_ = parser_get_associativity (self, _tmp77_);
#line 1643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp79_ = constant_node_new (self, _tmp73_, _tmp76_, _tmp78_);
#line 1643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp80_ = _tmp79_;
#line 1643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							parser_insert_into_tree (self, (ParseNode*) _tmp80_);
#line 1643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (_tmp80_);
#line 1645 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp81_ = self->priv->lexer;
#line 1645 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp82_ = lexer_get_next_token (_tmp81_);
#line 1645 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1645 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							token = _tmp82_;
#line 1646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp83_ = self->priv->lexer;
#line 1646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							lexer_roll_back (_tmp83_);
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp89_ = token;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp90_ = _tmp89_->type;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (_tmp90_ == LEXER_TOKEN_TYPE_FUNCTION) {
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp88_ = TRUE;
#line 11974 "equation-parser.c"
							} else {
								LexerToken* _tmp91_ = NULL;
								LexerTokenType _tmp92_ = 0;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp91_ = token;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp92_ = _tmp91_->type;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp88_ = _tmp92_ == LEXER_TOKEN_TYPE_VARIABLE;
#line 11984 "equation-parser.c"
							}
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (_tmp88_) {
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp87_ = TRUE;
#line 11990 "equation-parser.c"
							} else {
								LexerToken* _tmp93_ = NULL;
								LexerTokenType _tmp94_ = 0;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp93_ = token;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp94_ = _tmp93_->type;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp87_ = _tmp94_ == LEXER_TOKEN_TYPE_SUB_NUMBER;
#line 12000 "equation-parser.c"
							}
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (_tmp87_) {
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp86_ = TRUE;
#line 12006 "equation-parser.c"
							} else {
								LexerToken* _tmp95_ = NULL;
								LexerTokenType _tmp96_ = 0;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp95_ = token;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp96_ = _tmp95_->type;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp86_ = _tmp96_ == LEXER_TOKEN_TYPE_ROOT;
#line 12016 "equation-parser.c"
							}
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (_tmp86_) {
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp85_ = TRUE;
#line 12022 "equation-parser.c"
							} else {
								LexerToken* _tmp97_ = NULL;
								LexerTokenType _tmp98_ = 0;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp97_ = token;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp98_ = _tmp97_->type;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp85_ = _tmp98_ == LEXER_TOKEN_TYPE_ROOT_3;
#line 12032 "equation-parser.c"
							}
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (_tmp85_) {
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp84_ = TRUE;
#line 12038 "equation-parser.c"
							} else {
								LexerToken* _tmp99_ = NULL;
								LexerTokenType _tmp100_ = 0;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp99_ = token;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp100_ = _tmp99_->type;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp84_ = _tmp100_ == LEXER_TOKEN_TYPE_ROOT_4;
#line 12048 "equation-parser.c"
							}
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (_tmp84_) {
#line 12052 "equation-parser.c"
								guint _tmp101_ = 0U;
								Associativity _tmp102_ = 0;
								MultiplyNode* _tmp103_ = NULL;
								MultiplyNode* _tmp104_ = NULL;
								gboolean _tmp105_ = FALSE;
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp101_ = parser_make_precedence_p (self, PRECEDENCE_MULTIPLY);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp102_ = parser_get_associativity_p (self, PRECEDENCE_MULTIPLY);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp103_ = multiply_node_new (self, NULL, _tmp101_, _tmp102_);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp104_ = _tmp103_;
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								parser_insert_into_tree (self, (ParseNode*) _tmp104_);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (_tmp104_);
#line 1652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp105_ = parser_variable (self);
#line 1652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								if (!_tmp105_) {
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									result = FALSE;
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_g_object_unref0 (token);
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									return result;
#line 12080 "equation-parser.c"
								} else {
#line 1655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									result = TRUE;
#line 1655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_g_object_unref0 (token);
#line 1655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									return result;
#line 12088 "equation-parser.c"
								}
							} else {
#line 1658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								result = TRUE;
#line 1658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token);
#line 1658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								return result;
#line 12097 "equation-parser.c"
							}
						} else {
							LexerToken* _tmp106_ = NULL;
							LexerTokenType _tmp107_ = 0;
#line 1660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp106_ = token;
#line 1660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp107_ = _tmp106_->type;
#line 1660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (_tmp107_ == LEXER_TOKEN_TYPE_L_FLOOR) {
#line 12108 "equation-parser.c"
								guint _tmp108_ = 0U;
								guint _tmp109_ = 0U;
								Associativity _tmp110_ = 0;
								FloorNode* _tmp111_ = NULL;
								FloorNode* _tmp112_ = NULL;
								gboolean _tmp113_ = FALSE;
								Lexer* _tmp114_ = NULL;
								LexerToken* _tmp115_ = NULL;
								LexerToken* _tmp116_ = NULL;
								LexerTokenType _tmp117_ = 0;
#line 1662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp108_ = self->priv->depth_level;
#line 1662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								self->priv->depth_level = _tmp108_ + 1;
#line 1665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp109_ = parser_make_precedence_p (self, PRECEDENCE_UNKNOWN);
#line 1665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp110_ = parser_get_associativity_p (self, PRECEDENCE_UNKNOWN);
#line 1665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp111_ = floor_node_new (self, NULL, _tmp109_, _tmp110_);
#line 1665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp112_ = _tmp111_;
#line 1665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								parser_insert_into_tree_unary (self, (ParseNode*) _tmp112_);
#line 1665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (_tmp112_);
#line 1667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp113_ = parser_expression (self);
#line 1667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								if (!_tmp113_) {
#line 1668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									result = FALSE;
#line 1668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_g_object_unref0 (token);
#line 1668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									return result;
#line 12145 "equation-parser.c"
								}
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp114_ = self->priv->lexer;
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp115_ = lexer_get_next_token (_tmp114_);
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token);
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								token = _tmp115_;
#line 1671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp116_ = token;
#line 1671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp117_ = _tmp116_->type;
#line 1671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								if (_tmp117_ == LEXER_TOKEN_TYPE_R_FLOOR) {
#line 12161 "equation-parser.c"
									guint _tmp118_ = 0U;
#line 1673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp118_ = self->priv->depth_level;
#line 1673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									self->priv->depth_level = _tmp118_ - 1;
#line 1674 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									result = TRUE;
#line 1674 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_g_object_unref0 (token);
#line 1674 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									return result;
#line 12173 "equation-parser.c"
								} else {
#line 1678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									result = FALSE;
#line 1678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_g_object_unref0 (token);
#line 1678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									return result;
#line 12181 "equation-parser.c"
								}
							} else {
								LexerToken* _tmp119_ = NULL;
								LexerTokenType _tmp120_ = 0;
#line 1680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp119_ = token;
#line 1680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp120_ = _tmp119_->type;
#line 1680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								if (_tmp120_ == LEXER_TOKEN_TYPE_L_CEILING) {
#line 12192 "equation-parser.c"
									guint _tmp121_ = 0U;
									guint _tmp122_ = 0U;
									Associativity _tmp123_ = 0;
									CeilingNode* _tmp124_ = NULL;
									CeilingNode* _tmp125_ = NULL;
									gboolean _tmp126_ = FALSE;
									Lexer* _tmp127_ = NULL;
									LexerToken* _tmp128_ = NULL;
									LexerToken* _tmp129_ = NULL;
									LexerTokenType _tmp130_ = 0;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp121_ = self->priv->depth_level;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									self->priv->depth_level = _tmp121_ + 1;
#line 1685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp122_ = parser_make_precedence_p (self, PRECEDENCE_UNKNOWN);
#line 1685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp123_ = parser_get_associativity_p (self, PRECEDENCE_UNKNOWN);
#line 1685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp124_ = ceiling_node_new (self, NULL, _tmp122_, _tmp123_);
#line 1685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp125_ = _tmp124_;
#line 1685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									parser_insert_into_tree_unary (self, (ParseNode*) _tmp125_);
#line 1685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_g_object_unref0 (_tmp125_);
#line 1687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp126_ = parser_expression (self);
#line 1687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									if (!_tmp126_) {
#line 1688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										result = FALSE;
#line 1688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_g_object_unref0 (token);
#line 1688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										return result;
#line 12229 "equation-parser.c"
									}
#line 1690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp127_ = self->priv->lexer;
#line 1690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp128_ = lexer_get_next_token (_tmp127_);
#line 1690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_g_object_unref0 (token);
#line 1690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									token = _tmp128_;
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp129_ = token;
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp130_ = _tmp129_->type;
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									if (_tmp130_ == LEXER_TOKEN_TYPE_R_CEILING) {
#line 12245 "equation-parser.c"
										guint _tmp131_ = 0U;
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp131_ = self->priv->depth_level;
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										self->priv->depth_level = _tmp131_ - 1;
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										result = TRUE;
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_g_object_unref0 (token);
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										return result;
#line 12257 "equation-parser.c"
									} else {
#line 1698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										result = FALSE;
#line 1698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_g_object_unref0 (token);
#line 1698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										return result;
#line 12265 "equation-parser.c"
									}
								} else {
									LexerToken* _tmp132_ = NULL;
									LexerTokenType _tmp133_ = 0;
#line 1700 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp132_ = token;
#line 1700 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp133_ = _tmp132_->type;
#line 1700 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									if (_tmp133_ == LEXER_TOKEN_TYPE_SUBTRACT) {
#line 12276 "equation-parser.c"
										LexerToken* _tmp134_ = NULL;
										guint _tmp135_ = 0U;
										Associativity _tmp136_ = 0;
										UnaryMinusNode* _tmp137_ = NULL;
										UnaryMinusNode* _tmp138_ = NULL;
										gboolean _tmp139_ = FALSE;
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp134_ = token;
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp135_ = parser_make_precedence_p (self, PRECEDENCE_UNARY_MINUS);
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp136_ = parser_get_associativity_p (self, PRECEDENCE_UNARY_MINUS);
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp137_ = unary_minus_node_new (self, _tmp134_, _tmp135_, _tmp136_);
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp138_ = _tmp137_;
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										parser_insert_into_tree_unary (self, (ParseNode*) _tmp138_);
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_g_object_unref0 (_tmp138_);
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp139_ = parser_expression_1 (self);
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										if (!_tmp139_) {
#line 1705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											result = FALSE;
#line 1705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_g_object_unref0 (token);
#line 1705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											return result;
#line 12307 "equation-parser.c"
										}
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										result = TRUE;
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_g_object_unref0 (token);
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										return result;
#line 12315 "equation-parser.c"
									} else {
										LexerToken* _tmp140_ = NULL;
										LexerTokenType _tmp141_ = 0;
#line 1709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp140_ = token;
#line 1709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp141_ = _tmp140_->type;
#line 1709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										if (_tmp141_ == LEXER_TOKEN_TYPE_ADD) {
#line 12325 "equation-parser.c"
											Lexer* _tmp142_ = NULL;
											LexerToken* _tmp143_ = NULL;
											LexerToken* _tmp144_ = NULL;
											LexerTokenType _tmp145_ = 0;
#line 1711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp142_ = self->priv->lexer;
#line 1711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp143_ = lexer_get_next_token (_tmp142_);
#line 1711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_g_object_unref0 (token);
#line 1711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											token = _tmp143_;
#line 1712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp144_ = token;
#line 1712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp145_ = _tmp144_->type;
#line 1712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											if (_tmp145_ == LEXER_TOKEN_TYPE_NUMBER) {
#line 12344 "equation-parser.c"
												LexerToken* _tmp146_ = NULL;
												LexerToken* _tmp147_ = NULL;
												LexerTokenType _tmp148_ = 0;
												guint _tmp149_ = 0U;
												LexerToken* _tmp150_ = NULL;
												Associativity _tmp151_ = 0;
												ConstantNode* _tmp152_ = NULL;
												ConstantNode* _tmp153_ = NULL;
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp146_ = token;
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp147_ = token;
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp148_ = _tmp147_->type;
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp149_ = parser_make_precedence_t (self, _tmp148_);
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp150_ = token;
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp151_ = parser_get_associativity (self, _tmp150_);
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp152_ = constant_node_new (self, _tmp146_, _tmp149_, _tmp151_);
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp153_ = _tmp152_;
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												parser_insert_into_tree (self, (ParseNode*) _tmp153_);
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_g_object_unref0 (_tmp153_);
#line 1716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												result = TRUE;
#line 1716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_g_object_unref0 (token);
#line 1716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												return result;
#line 12379 "equation-parser.c"
											} else {
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												result = FALSE;
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_g_object_unref0 (token);
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												return result;
#line 12387 "equation-parser.c"
											}
										} else {
											Lexer* _tmp154_ = NULL;
											gboolean _tmp155_ = FALSE;
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp154_ = self->priv->lexer;
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											lexer_roll_back (_tmp154_);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp155_ = parser_variable (self);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											if (!_tmp155_) {
#line 1725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												result = FALSE;
#line 1725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_g_object_unref0 (token);
#line 1725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												return result;
#line 12406 "equation-parser.c"
											} else {
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												result = TRUE;
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_g_object_unref0 (token);
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												return result;
#line 12414 "equation-parser.c"
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 1542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 12428 "equation-parser.c"
}


static gboolean parser_expression_2 (Parser* self) {
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	LexerToken* _tmp2_ = NULL;
	LexerTokenType _tmp3_ = 0;
#line 1731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->lexer;
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = lexer_get_next_token (_tmp0_);
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp1_;
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = token;
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = _tmp2_->type;
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp3_ == LEXER_TOKEN_TYPE_L_R_BRACKET) {
#line 12453 "equation-parser.c"
		guint _tmp4_ = 0U;
		Associativity _tmp5_ = 0;
		MultiplyNode* _tmp6_ = NULL;
		MultiplyNode* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
		Lexer* _tmp10_ = NULL;
		LexerToken* _tmp11_ = NULL;
		LexerToken* _tmp12_ = NULL;
		LexerTokenType _tmp13_ = 0;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = parser_make_precedence_p (self, PRECEDENCE_MULTIPLY);
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = parser_get_associativity_p (self, PRECEDENCE_MULTIPLY);
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = multiply_node_new (self, NULL, _tmp4_, _tmp5_);
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = _tmp6_;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_insert_into_tree (self, (ParseNode*) _tmp7_);
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (_tmp7_);
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = self->priv->depth_level;
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		self->priv->depth_level = _tmp8_ + 1;
#line 1739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = parser_expression (self);
#line 1739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp9_) {
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 12490 "equation-parser.c"
		}
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = self->priv->lexer;
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = lexer_get_next_token (_tmp10_);
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp11_;
#line 1742 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = token;
#line 1742 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = _tmp12_->type;
#line 1742 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp13_ == LEXER_TOKEN_TYPE_R_R_BRACKET) {
#line 12506 "equation-parser.c"
			guint _tmp14_ = 0U;
			gboolean _tmp15_ = FALSE;
#line 1744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp14_ = self->priv->depth_level;
#line 1744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			self->priv->depth_level = _tmp14_ - 1;
#line 1746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp15_ = parser_expression_2 (self);
#line 1746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!_tmp15_) {
#line 1747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = FALSE;
#line 1747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 12523 "equation-parser.c"
			}
#line 1749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = TRUE;
#line 1749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 12531 "equation-parser.c"
		} else {
#line 1752 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 1752 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1752 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 12539 "equation-parser.c"
		}
	} else {
		LexerToken* _tmp16_ = NULL;
		LexerTokenType _tmp17_ = 0;
#line 1754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp16_ = token;
#line 1754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp17_ = _tmp16_->type;
#line 1754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp17_ == LEXER_TOKEN_TYPE_POWER) {
#line 12550 "equation-parser.c"
			LexerToken* _tmp18_ = NULL;
			LexerToken* _tmp19_ = NULL;
			LexerTokenType _tmp20_ = 0;
			guint _tmp21_ = 0U;
			LexerToken* _tmp22_ = NULL;
			Associativity _tmp23_ = 0;
			XPowYNode* _tmp24_ = NULL;
			XPowYNode* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp18_ = token;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp19_ = token;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp20_ = _tmp19_->type;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp21_ = parser_make_precedence_t (self, _tmp20_);
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp22_ = token;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp23_ = parser_get_associativity (self, _tmp22_);
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp24_ = xpow_ynode_new (self, _tmp18_, _tmp21_, _tmp23_);
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp25_ = _tmp24_;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_insert_into_tree (self, (ParseNode*) _tmp25_);
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp25_);
#line 1758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp26_ = parser_expression_1 (self);
#line 1758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!_tmp26_) {
#line 1759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = FALSE;
#line 1759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 12591 "equation-parser.c"
			}
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp27_ = parser_expression_2 (self);
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!_tmp27_) {
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = FALSE;
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 12603 "equation-parser.c"
			}
#line 1763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = TRUE;
#line 1763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 12611 "equation-parser.c"
		} else {
			LexerToken* _tmp28_ = NULL;
			LexerTokenType _tmp29_ = 0;
#line 1765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp28_ = token;
#line 1765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp29_ = _tmp28_->type;
#line 1765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp29_ == LEXER_TOKEN_TYPE_SUP_NUMBER) {
#line 12621 "equation-parser.c"
				guint _tmp30_ = 0U;
				Associativity _tmp31_ = 0;
				XPowYIntegerNode* _tmp32_ = NULL;
				XPowYIntegerNode* _tmp33_ = NULL;
				LexerToken* _tmp34_ = NULL;
				guint _tmp35_ = 0U;
				Associativity _tmp36_ = 0;
				NameNode* _tmp37_ = NULL;
				NameNode* _tmp38_ = NULL;
				gboolean _tmp39_ = FALSE;
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp30_ = parser_make_precedence_p (self, PRECEDENCE_POWER);
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp31_ = parser_get_associativity_p (self, PRECEDENCE_POWER);
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp32_ = xpow_yinteger_node_new (self, NULL, _tmp30_, _tmp31_);
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp33_ = _tmp32_;
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				parser_insert_into_tree (self, (ParseNode*) _tmp33_);
#line 1767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (_tmp33_);
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp34_ = token;
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp35_ = parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp36_ = parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp37_ = name_node_new (self, _tmp34_, _tmp35_, _tmp36_, NULL);
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp38_ = _tmp37_;
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				parser_insert_into_tree (self, (ParseNode*) _tmp38_);
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (_tmp38_);
#line 1770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp39_ = parser_expression_2 (self);
#line 1770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (!_tmp39_) {
#line 1771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = FALSE;
#line 1771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 12668 "equation-parser.c"
				}
#line 1773 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = TRUE;
#line 1773 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1773 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 12676 "equation-parser.c"
			} else {
				LexerToken* _tmp40_ = NULL;
				LexerTokenType _tmp41_ = 0;
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp40_ = token;
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp41_ = _tmp40_->type;
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (_tmp41_ == LEXER_TOKEN_TYPE_NSUP_NUMBER) {
#line 12686 "equation-parser.c"
					guint _tmp42_ = 0U;
					Associativity _tmp43_ = 0;
					XPowYIntegerNode* _tmp44_ = NULL;
					XPowYIntegerNode* _tmp45_ = NULL;
					LexerToken* _tmp46_ = NULL;
					guint _tmp47_ = 0U;
					Associativity _tmp48_ = 0;
					NameNode* _tmp49_ = NULL;
					NameNode* _tmp50_ = NULL;
					gboolean _tmp51_ = FALSE;
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp42_ = parser_make_precedence_p (self, PRECEDENCE_POWER);
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp43_ = parser_get_associativity_p (self, PRECEDENCE_POWER);
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp44_ = xpow_yinteger_node_new (self, NULL, _tmp42_, _tmp43_);
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp45_ = _tmp44_;
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					parser_insert_into_tree (self, (ParseNode*) _tmp45_);
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (_tmp45_);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp46_ = token;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp47_ = parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp48_ = parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp49_ = name_node_new (self, _tmp46_, _tmp47_, _tmp48_, NULL);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp50_ = _tmp49_;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					parser_insert_into_tree (self, (ParseNode*) _tmp50_);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (_tmp50_);
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp51_ = parser_expression_2 (self);
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!_tmp51_) {
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 12733 "equation-parser.c"
					}
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = TRUE;
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 12741 "equation-parser.c"
				} else {
					LexerToken* _tmp52_ = NULL;
					LexerTokenType _tmp53_ = 0;
#line 1785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp52_ = token;
#line 1785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp53_ = _tmp52_->type;
#line 1785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp53_ == LEXER_TOKEN_TYPE_FACTORIAL) {
#line 12751 "equation-parser.c"
						LexerToken* _tmp54_ = NULL;
						LexerToken* _tmp55_ = NULL;
						LexerTokenType _tmp56_ = 0;
						guint _tmp57_ = 0U;
						LexerToken* _tmp58_ = NULL;
						Associativity _tmp59_ = 0;
						FactorialNode* _tmp60_ = NULL;
						FactorialNode* _tmp61_ = NULL;
						gboolean _tmp62_ = FALSE;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp54_ = token;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp55_ = token;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp56_ = _tmp55_->type;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp57_ = parser_make_precedence_t (self, _tmp56_);
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp58_ = token;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp59_ = parser_get_associativity (self, _tmp58_);
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp60_ = factorial_node_new (self, _tmp54_, _tmp57_, _tmp59_);
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp61_ = _tmp60_;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_insert_into_tree_unary (self, (ParseNode*) _tmp61_);
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (_tmp61_);
#line 1789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp62_ = parser_expression_2 (self);
#line 1789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (!_tmp62_) {
#line 1790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = FALSE;
#line 1790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 12791 "equation-parser.c"
						}
#line 1792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = TRUE;
#line 1792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 12799 "equation-parser.c"
					} else {
						LexerToken* _tmp63_ = NULL;
						LexerTokenType _tmp64_ = 0;
#line 1794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp63_ = token;
#line 1794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp64_ = _tmp63_->type;
#line 1794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (_tmp64_ == LEXER_TOKEN_TYPE_MULTIPLY) {
#line 12809 "equation-parser.c"
							LexerToken* _tmp65_ = NULL;
							LexerToken* _tmp66_ = NULL;
							LexerTokenType _tmp67_ = 0;
							guint _tmp68_ = 0U;
							LexerToken* _tmp69_ = NULL;
							Associativity _tmp70_ = 0;
							MultiplyNode* _tmp71_ = NULL;
							MultiplyNode* _tmp72_ = NULL;
							gboolean _tmp73_ = FALSE;
							gboolean _tmp74_ = FALSE;
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp65_ = token;
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp66_ = token;
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp67_ = _tmp66_->type;
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp68_ = parser_make_precedence_t (self, _tmp67_);
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp69_ = token;
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp70_ = parser_get_associativity (self, _tmp69_);
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp71_ = multiply_node_new (self, _tmp65_, _tmp68_, _tmp70_);
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp72_ = _tmp71_;
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							parser_insert_into_tree (self, (ParseNode*) _tmp72_);
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (_tmp72_);
#line 1798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp73_ = parser_expression_1 (self);
#line 1798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (!_tmp73_) {
#line 1799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								result = FALSE;
#line 1799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token);
#line 1799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								return result;
#line 12850 "equation-parser.c"
							}
#line 1800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp74_ = parser_expression_2 (self);
#line 1800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (!_tmp74_) {
#line 1801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								result = FALSE;
#line 1801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token);
#line 1801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								return result;
#line 12862 "equation-parser.c"
							}
#line 1803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = TRUE;
#line 1803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 12870 "equation-parser.c"
						} else {
							LexerToken* _tmp75_ = NULL;
							LexerTokenType _tmp76_ = 0;
#line 1805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp75_ = token;
#line 1805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp76_ = _tmp75_->type;
#line 1805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (_tmp76_ == LEXER_TOKEN_TYPE_PERCENTAGE) {
#line 12880 "equation-parser.c"
								LexerToken* _tmp77_ = NULL;
								LexerToken* _tmp78_ = NULL;
								LexerTokenType _tmp79_ = 0;
								guint _tmp80_ = 0U;
								LexerToken* _tmp81_ = NULL;
								Associativity _tmp82_ = 0;
								PercentNode* _tmp83_ = NULL;
								PercentNode* _tmp84_ = NULL;
								gboolean _tmp85_ = FALSE;
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp77_ = token;
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp78_ = token;
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp79_ = _tmp78_->type;
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp80_ = parser_make_precedence_t (self, _tmp79_);
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp81_ = token;
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp82_ = parser_get_associativity (self, _tmp81_);
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp83_ = percent_node_new (self, _tmp77_, _tmp80_, _tmp82_);
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp84_ = _tmp83_;
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								parser_insert_into_tree_unary (self, (ParseNode*) _tmp84_);
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (_tmp84_);
#line 1809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp85_ = parser_expression_2 (self);
#line 1809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								if (!_tmp85_) {
#line 1810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									result = FALSE;
#line 1810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_g_object_unref0 (token);
#line 1810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									return result;
#line 12920 "equation-parser.c"
								}
#line 1812 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								result = TRUE;
#line 1812 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token);
#line 1812 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								return result;
#line 12928 "equation-parser.c"
							} else {
								LexerToken* _tmp86_ = NULL;
								LexerTokenType _tmp87_ = 0;
#line 1814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp86_ = token;
#line 1814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_tmp87_ = _tmp86_->type;
#line 1814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								if (_tmp87_ == LEXER_TOKEN_TYPE_AND) {
#line 12938 "equation-parser.c"
									LexerToken* _tmp88_ = NULL;
									LexerToken* _tmp89_ = NULL;
									LexerTokenType _tmp90_ = 0;
									guint _tmp91_ = 0U;
									LexerToken* _tmp92_ = NULL;
									Associativity _tmp93_ = 0;
									AndNode* _tmp94_ = NULL;
									AndNode* _tmp95_ = NULL;
									gboolean _tmp96_ = FALSE;
									gboolean _tmp97_ = FALSE;
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp88_ = token;
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp89_ = token;
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp90_ = _tmp89_->type;
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp91_ = parser_make_precedence_t (self, _tmp90_);
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp92_ = token;
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp93_ = parser_get_associativity (self, _tmp92_);
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp94_ = and_node_new (self, _tmp88_, _tmp91_, _tmp93_);
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp95_ = _tmp94_;
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									parser_insert_into_tree (self, (ParseNode*) _tmp95_);
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_g_object_unref0 (_tmp95_);
#line 1818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp96_ = parser_expression_1 (self);
#line 1818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									if (!_tmp96_) {
#line 1819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										result = FALSE;
#line 1819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_g_object_unref0 (token);
#line 1819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										return result;
#line 12979 "equation-parser.c"
									}
#line 1820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp97_ = parser_expression_2 (self);
#line 1820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									if (!_tmp97_) {
#line 1821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										result = FALSE;
#line 1821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_g_object_unref0 (token);
#line 1821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										return result;
#line 12991 "equation-parser.c"
									}
#line 1823 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									result = TRUE;
#line 1823 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_g_object_unref0 (token);
#line 1823 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									return result;
#line 12999 "equation-parser.c"
								} else {
									LexerToken* _tmp98_ = NULL;
									LexerTokenType _tmp99_ = 0;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp98_ = token;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									_tmp99_ = _tmp98_->type;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
									if (_tmp99_ == LEXER_TOKEN_TYPE_OR) {
#line 13009 "equation-parser.c"
										LexerToken* _tmp100_ = NULL;
										LexerToken* _tmp101_ = NULL;
										LexerTokenType _tmp102_ = 0;
										guint _tmp103_ = 0U;
										LexerToken* _tmp104_ = NULL;
										Associativity _tmp105_ = 0;
										OrNode* _tmp106_ = NULL;
										OrNode* _tmp107_ = NULL;
										gboolean _tmp108_ = FALSE;
										gboolean _tmp109_ = FALSE;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp100_ = token;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp101_ = token;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp102_ = _tmp101_->type;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp103_ = parser_make_precedence_t (self, _tmp102_);
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp104_ = token;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp105_ = parser_get_associativity (self, _tmp104_);
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp106_ = or_node_new (self, _tmp100_, _tmp103_, _tmp105_);
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp107_ = _tmp106_;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										parser_insert_into_tree (self, (ParseNode*) _tmp107_);
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_g_object_unref0 (_tmp107_);
#line 1829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp108_ = parser_expression_1 (self);
#line 1829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										if (!_tmp108_) {
#line 1830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											result = FALSE;
#line 1830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_g_object_unref0 (token);
#line 1830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											return result;
#line 13050 "equation-parser.c"
										}
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp109_ = parser_expression_2 (self);
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										if (!_tmp109_) {
#line 1832 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											result = FALSE;
#line 1832 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_g_object_unref0 (token);
#line 1832 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											return result;
#line 13062 "equation-parser.c"
										}
#line 1834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										result = TRUE;
#line 1834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_g_object_unref0 (token);
#line 1834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										return result;
#line 13070 "equation-parser.c"
									} else {
										LexerToken* _tmp110_ = NULL;
										LexerTokenType _tmp111_ = 0;
#line 1836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp110_ = token;
#line 1836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										_tmp111_ = _tmp110_->type;
#line 1836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
										if (_tmp111_ == LEXER_TOKEN_TYPE_XOR) {
#line 13080 "equation-parser.c"
											LexerToken* _tmp112_ = NULL;
											LexerToken* _tmp113_ = NULL;
											LexerTokenType _tmp114_ = 0;
											guint _tmp115_ = 0U;
											LexerToken* _tmp116_ = NULL;
											Associativity _tmp117_ = 0;
											XorNode* _tmp118_ = NULL;
											XorNode* _tmp119_ = NULL;
											gboolean _tmp120_ = FALSE;
											gboolean _tmp121_ = FALSE;
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp112_ = token;
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp113_ = token;
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp114_ = _tmp113_->type;
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp115_ = parser_make_precedence_t (self, _tmp114_);
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp116_ = token;
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp117_ = parser_get_associativity (self, _tmp116_);
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp118_ = xor_node_new (self, _tmp112_, _tmp115_, _tmp117_);
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp119_ = _tmp118_;
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											parser_insert_into_tree (self, (ParseNode*) _tmp119_);
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_g_object_unref0 (_tmp119_);
#line 1840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp120_ = parser_expression_1 (self);
#line 1840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											if (!_tmp120_) {
#line 1841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												result = FALSE;
#line 1841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_g_object_unref0 (token);
#line 1841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												return result;
#line 13121 "equation-parser.c"
											}
#line 1842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp121_ = parser_expression_2 (self);
#line 1842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											if (!_tmp121_) {
#line 1843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												result = FALSE;
#line 1843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_g_object_unref0 (token);
#line 1843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												return result;
#line 13133 "equation-parser.c"
											}
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											result = TRUE;
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_g_object_unref0 (token);
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											return result;
#line 13141 "equation-parser.c"
										} else {
											LexerToken* _tmp122_ = NULL;
											LexerTokenType _tmp123_ = 0;
#line 1847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp122_ = token;
#line 1847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											_tmp123_ = _tmp122_->type;
#line 1847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
											if (_tmp123_ == LEXER_TOKEN_TYPE_DIVIDE) {
#line 13151 "equation-parser.c"
												LexerToken* _tmp124_ = NULL;
												LexerToken* _tmp125_ = NULL;
												LexerTokenType _tmp126_ = 0;
												guint _tmp127_ = 0U;
												LexerToken* _tmp128_ = NULL;
												Associativity _tmp129_ = 0;
												DivideNode* _tmp130_ = NULL;
												DivideNode* _tmp131_ = NULL;
												gboolean _tmp132_ = FALSE;
												gboolean _tmp133_ = FALSE;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp124_ = token;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp125_ = token;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp126_ = _tmp125_->type;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp127_ = parser_make_precedence_t (self, _tmp126_);
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp128_ = token;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp129_ = parser_get_associativity (self, _tmp128_);
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp130_ = divide_node_new (self, _tmp124_, _tmp127_, _tmp129_);
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp131_ = _tmp130_;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												parser_insert_into_tree (self, (ParseNode*) _tmp131_);
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_g_object_unref0 (_tmp131_);
#line 1851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp132_ = parser_expression_1 (self);
#line 1851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												if (!_tmp132_) {
#line 1852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													result = FALSE;
#line 1852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_g_object_unref0 (token);
#line 1852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													return result;
#line 13192 "equation-parser.c"
												}
#line 1853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp133_ = parser_expression_2 (self);
#line 1853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												if (!_tmp133_) {
#line 1854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													result = FALSE;
#line 1854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_g_object_unref0 (token);
#line 1854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													return result;
#line 13204 "equation-parser.c"
												}
#line 1856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												result = TRUE;
#line 1856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_g_object_unref0 (token);
#line 1856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												return result;
#line 13212 "equation-parser.c"
											} else {
												LexerToken* _tmp134_ = NULL;
												LexerTokenType _tmp135_ = 0;
#line 1858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp134_ = token;
#line 1858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												_tmp135_ = _tmp134_->type;
#line 1858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
												if (_tmp135_ == LEXER_TOKEN_TYPE_MOD) {
#line 13222 "equation-parser.c"
													LexerToken* _tmp136_ = NULL;
													LexerToken* _tmp137_ = NULL;
													LexerTokenType _tmp138_ = 0;
													guint _tmp139_ = 0U;
													LexerToken* _tmp140_ = NULL;
													Associativity _tmp141_ = 0;
													ModulusDivideNode* _tmp142_ = NULL;
													ModulusDivideNode* _tmp143_ = NULL;
													gboolean _tmp144_ = FALSE;
													gboolean _tmp145_ = FALSE;
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp136_ = token;
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp137_ = token;
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp138_ = _tmp137_->type;
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp139_ = parser_make_precedence_t (self, _tmp138_);
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp140_ = token;
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp141_ = parser_get_associativity (self, _tmp140_);
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp142_ = modulus_divide_node_new (self, _tmp136_, _tmp139_, _tmp141_);
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp143_ = _tmp142_;
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													parser_insert_into_tree (self, (ParseNode*) _tmp143_);
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_g_object_unref0 (_tmp143_);
#line 1862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp144_ = parser_expression_1 (self);
#line 1862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													if (!_tmp144_) {
#line 1863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														result = FALSE;
#line 1863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_g_object_unref0 (token);
#line 1863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														return result;
#line 13263 "equation-parser.c"
													}
#line 1864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp145_ = parser_expression_2 (self);
#line 1864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													if (!_tmp145_) {
#line 1865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														result = FALSE;
#line 1865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_g_object_unref0 (token);
#line 1865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														return result;
#line 13275 "equation-parser.c"
													}
#line 1867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													result = TRUE;
#line 1867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_g_object_unref0 (token);
#line 1867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													return result;
#line 13283 "equation-parser.c"
												} else {
													LexerToken* _tmp146_ = NULL;
													LexerTokenType _tmp147_ = 0;
#line 1869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp146_ = token;
#line 1869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													_tmp147_ = _tmp146_->type;
#line 1869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
													if (_tmp147_ == LEXER_TOKEN_TYPE_ADD) {
#line 13293 "equation-parser.c"
														AddNode* node = NULL;
														LexerToken* _tmp148_ = NULL;
														LexerToken* _tmp149_ = NULL;
														LexerTokenType _tmp150_ = 0;
														guint _tmp151_ = 0U;
														LexerToken* _tmp152_ = NULL;
														Associativity _tmp153_ = 0;
														AddNode* _tmp154_ = NULL;
														AddNode* _tmp155_ = NULL;
														gboolean _tmp156_ = FALSE;
														Lexer* _tmp157_ = NULL;
														LexerToken* _tmp158_ = NULL;
														LexerToken* _tmp159_ = NULL;
														LexerTokenType _tmp160_ = 0;
														gboolean _tmp169_ = FALSE;
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp148_ = token;
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp149_ = token;
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp150_ = _tmp149_->type;
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp151_ = parser_make_precedence_t (self, _tmp150_);
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp152_ = token;
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp153_ = parser_get_associativity (self, _tmp152_);
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp154_ = add_node_new (self, _tmp148_, _tmp151_, _tmp153_);
#line 1871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														node = _tmp154_;
#line 1872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp155_ = node;
#line 1872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														parser_insert_into_tree (self, (ParseNode*) _tmp155_);
#line 1874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp156_ = parser_expression_1 (self);
#line 1874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														if (!_tmp156_) {
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															result = FALSE;
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_g_object_unref0 (node);
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_g_object_unref0 (token);
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															return result;
#line 13341 "equation-parser.c"
														}
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp157_ = self->priv->lexer;
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp158_ = lexer_get_next_token (_tmp157_);
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_g_object_unref0 (token);
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														token = _tmp158_;
#line 1878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp159_ = token;
#line 1878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp160_ = _tmp159_->type;
#line 1878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														if (_tmp160_ == LEXER_TOKEN_TYPE_PERCENTAGE) {
#line 13357 "equation-parser.c"
															AddNode* _tmp161_ = NULL;
															ParseNode* _tmp162_ = NULL;
															guint _tmp163_ = 0U;
#line 1881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp161_ = node;
#line 1881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp162_ = ((ParseNode*) _tmp161_)->right;
#line 1881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp163_ = _tmp162_->precedence;
#line 1881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															if (_tmp163_ > ((guint) PRECEDENCE_PERCENTAGE)) {
#line 13369 "equation-parser.c"
																AddNode* _tmp164_ = NULL;
																AddNode* _tmp165_ = NULL;
#line 1883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_tmp164_ = node;
#line 1883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																((ParseNode*) _tmp164_)->precedence = (guint) PRECEDENCE_PERCENTAGE;
#line 1884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_tmp165_ = node;
#line 1884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_tmp165_->do_percentage = TRUE;
#line 1885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																result = TRUE;
#line 1885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_g_object_unref0 (node);
#line 1885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_g_object_unref0 (token);
#line 1885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																return result;
#line 13388 "equation-parser.c"
															} else {
																Lexer* _tmp166_ = NULL;
																gboolean _tmp167_ = FALSE;
#line 1890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_tmp166_ = self->priv->lexer;
#line 1890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																lexer_roll_back (_tmp166_);
#line 1891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_tmp167_ = parser_expression_2 (self);
#line 1891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																if (!_tmp167_) {
#line 1892 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	result = TRUE;
#line 1892 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	_g_object_unref0 (node);
#line 1892 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	_g_object_unref0 (token);
#line 1892 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	return result;
#line 13408 "equation-parser.c"
																}
															}
														} else {
															Lexer* _tmp168_ = NULL;
#line 1896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp168_ = self->priv->lexer;
#line 1896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															lexer_roll_back (_tmp168_);
#line 13417 "equation-parser.c"
														}
#line 1898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp169_ = parser_expression_2 (self);
#line 1898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														if (!_tmp169_) {
#line 1899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															result = FALSE;
#line 1899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_g_object_unref0 (node);
#line 1899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_g_object_unref0 (token);
#line 1899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															return result;
#line 13431 "equation-parser.c"
														}
#line 1901 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														result = TRUE;
#line 1901 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_g_object_unref0 (node);
#line 1901 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_g_object_unref0 (token);
#line 1901 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														return result;
#line 13441 "equation-parser.c"
													} else {
														LexerToken* _tmp170_ = NULL;
														LexerTokenType _tmp171_ = 0;
#line 1903 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp170_ = token;
#line 1903 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														_tmp171_ = _tmp170_->type;
#line 1903 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
														if (_tmp171_ == LEXER_TOKEN_TYPE_SUBTRACT) {
#line 13451 "equation-parser.c"
															SubtractNode* node = NULL;
															LexerToken* _tmp172_ = NULL;
															LexerToken* _tmp173_ = NULL;
															LexerTokenType _tmp174_ = 0;
															guint _tmp175_ = 0U;
															LexerToken* _tmp176_ = NULL;
															Associativity _tmp177_ = 0;
															SubtractNode* _tmp178_ = NULL;
															SubtractNode* _tmp179_ = NULL;
															gboolean _tmp180_ = FALSE;
															Lexer* _tmp181_ = NULL;
															LexerToken* _tmp182_ = NULL;
															LexerToken* _tmp183_ = NULL;
															LexerTokenType _tmp184_ = 0;
															gboolean _tmp193_ = FALSE;
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp172_ = token;
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp173_ = token;
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp174_ = _tmp173_->type;
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp175_ = parser_make_precedence_t (self, _tmp174_);
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp176_ = token;
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp177_ = parser_get_associativity (self, _tmp176_);
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp178_ = subtract_node_new (self, _tmp172_, _tmp175_, _tmp177_);
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															node = _tmp178_;
#line 1906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp179_ = node;
#line 1906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															parser_insert_into_tree (self, (ParseNode*) _tmp179_);
#line 1908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp180_ = parser_expression_1 (self);
#line 1908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															if (!_tmp180_) {
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																result = FALSE;
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_g_object_unref0 (node);
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_g_object_unref0 (token);
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																return result;
#line 13499 "equation-parser.c"
															}
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp181_ = self->priv->lexer;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp182_ = lexer_get_next_token (_tmp181_);
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_g_object_unref0 (token);
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															token = _tmp182_;
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp183_ = token;
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp184_ = _tmp183_->type;
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															if (_tmp184_ == LEXER_TOKEN_TYPE_PERCENTAGE) {
#line 13515 "equation-parser.c"
																SubtractNode* _tmp185_ = NULL;
																ParseNode* _tmp186_ = NULL;
																guint _tmp187_ = 0U;
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_tmp185_ = node;
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_tmp186_ = ((ParseNode*) _tmp185_)->right;
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_tmp187_ = _tmp186_->precedence;
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																if (_tmp187_ > ((guint) PRECEDENCE_PERCENTAGE)) {
#line 13527 "equation-parser.c"
																	SubtractNode* _tmp188_ = NULL;
																	SubtractNode* _tmp189_ = NULL;
#line 1916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	_tmp188_ = node;
#line 1916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	((ParseNode*) _tmp188_)->precedence = (guint) PRECEDENCE_PERCENTAGE;
#line 1917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	_tmp189_ = node;
#line 1917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	_tmp189_->do_percentage = TRUE;
#line 1918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	result = TRUE;
#line 1918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	_g_object_unref0 (node);
#line 1918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	_g_object_unref0 (token);
#line 1918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	return result;
#line 13546 "equation-parser.c"
																} else {
																	Lexer* _tmp190_ = NULL;
																	gboolean _tmp191_ = FALSE;
#line 1923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	_tmp190_ = self->priv->lexer;
#line 1923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	lexer_roll_back (_tmp190_);
#line 1924 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	_tmp191_ = parser_expression_2 (self);
#line 1924 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																	if (!_tmp191_) {
#line 1925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																		result = TRUE;
#line 1925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																		_g_object_unref0 (node);
#line 1925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																		_g_object_unref0 (token);
#line 1925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																		return result;
#line 13566 "equation-parser.c"
																	}
																}
															} else {
																Lexer* _tmp192_ = NULL;
#line 1929 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_tmp192_ = self->priv->lexer;
#line 1929 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																lexer_roll_back (_tmp192_);
#line 13575 "equation-parser.c"
															}
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp193_ = parser_expression_2 (self);
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															if (!_tmp193_) {
#line 1932 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																result = FALSE;
#line 1932 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_g_object_unref0 (node);
#line 1932 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																_g_object_unref0 (token);
#line 1932 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
																return result;
#line 13589 "equation-parser.c"
															}
#line 1934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															result = TRUE;
#line 1934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_g_object_unref0 (node);
#line 1934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_g_object_unref0 (token);
#line 1934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															return result;
#line 13599 "equation-parser.c"
														} else {
															Lexer* _tmp194_ = NULL;
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_tmp194_ = self->priv->lexer;
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															lexer_roll_back (_tmp194_);
#line 1939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															result = TRUE;
#line 1939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															_g_object_unref0 (token);
#line 1939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
															return result;
#line 13612 "equation-parser.c"
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 1731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 13629 "equation-parser.c"
}


static gboolean parser_variable (Parser* self) {
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	LexerToken* _tmp2_ = NULL;
	LexerTokenType _tmp3_ = 0;
#line 1943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->lexer;
#line 1945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = lexer_get_next_token (_tmp0_);
#line 1945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp1_;
#line 1946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = token;
#line 1946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = _tmp2_->type;
#line 1946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp3_ == LEXER_TOKEN_TYPE_FUNCTION) {
#line 13654 "equation-parser.c"
		Lexer* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 1948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = self->priv->lexer;
#line 1948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		lexer_roll_back (_tmp4_);
#line 1949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = parser_function_invocation (self);
#line 1949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp5_) {
#line 1950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 1950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 13671 "equation-parser.c"
		}
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = TRUE;
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 13679 "equation-parser.c"
	} else {
		LexerToken* _tmp6_ = NULL;
		LexerTokenType _tmp7_ = 0;
#line 1953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = token;
#line 1953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = _tmp6_->type;
#line 1953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp7_ == LEXER_TOKEN_TYPE_SUB_NUMBER) {
#line 13689 "equation-parser.c"
			LexerToken* token_old = NULL;
			LexerToken* _tmp8_ = NULL;
			LexerToken* _tmp9_ = NULL;
			Lexer* _tmp10_ = NULL;
			LexerToken* _tmp11_ = NULL;
			LexerToken* _tmp12_ = NULL;
			LexerTokenType _tmp13_ = 0;
#line 1955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp8_ = token;
#line 1955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp9_ = _g_object_ref0 (_tmp8_);
#line 1955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			token_old = _tmp9_;
#line 1956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp10_ = self->priv->lexer;
#line 1956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp11_ = lexer_get_next_token (_tmp10_);
#line 1956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 1956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			token = _tmp11_;
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp12_ = token;
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp13_ = _tmp12_->type;
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp13_ == LEXER_TOKEN_TYPE_ROOT) {
#line 13717 "equation-parser.c"
				LexerToken* _tmp14_ = NULL;
				LexerToken* _tmp15_ = NULL;
				LexerTokenType _tmp16_ = 0;
				guint _tmp17_ = 0U;
				LexerToken* _tmp18_ = NULL;
				Associativity _tmp19_ = 0;
				LexerToken* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				RootNode* _tmp23_ = NULL;
				RootNode* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp14_ = token;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp15_ = token;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp16_ = _tmp15_->type;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp17_ = parser_make_precedence_t (self, _tmp16_);
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp18_ = token;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp19_ = parser_get_associativity (self, _tmp18_);
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp20_ = token_old;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp21_ = _tmp20_->text;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp22_ = sub_atoi (_tmp21_);
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp23_ = root_node_new (self, _tmp14_, _tmp17_, _tmp19_, _tmp22_);
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp24_ = _tmp23_;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				parser_insert_into_tree_unary (self, (ParseNode*) _tmp24_);
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (_tmp24_);
#line 1960 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp25_ = parser_expression (self);
#line 1960 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (!_tmp25_) {
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = FALSE;
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token_old);
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 13768 "equation-parser.c"
				}
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = TRUE;
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token_old);
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 13778 "equation-parser.c"
			} else {
#line 1966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = FALSE;
#line 1966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token_old);
#line 1966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 13788 "equation-parser.c"
			}
#line 1953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token_old);
#line 13792 "equation-parser.c"
		} else {
			LexerToken* _tmp26_ = NULL;
			LexerTokenType _tmp27_ = 0;
#line 1968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp26_ = token;
#line 1968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp27_ = _tmp26_->type;
#line 1968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp27_ == LEXER_TOKEN_TYPE_ROOT) {
#line 13802 "equation-parser.c"
				LexerToken* _tmp28_ = NULL;
				LexerToken* _tmp29_ = NULL;
				LexerTokenType _tmp30_ = 0;
				guint _tmp31_ = 0U;
				LexerToken* _tmp32_ = NULL;
				Associativity _tmp33_ = 0;
				RootNode* _tmp34_ = NULL;
				RootNode* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp28_ = token;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp29_ = token;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp30_ = _tmp29_->type;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp31_ = parser_make_precedence_t (self, _tmp30_);
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp32_ = token;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp33_ = parser_get_associativity (self, _tmp32_);
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp34_ = root_node_new (self, _tmp28_, _tmp31_, _tmp33_, 2);
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp35_ = _tmp34_;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				parser_insert_into_tree_unary (self, (ParseNode*) _tmp35_);
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (_tmp35_);
#line 1972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp36_ = parser_expression (self);
#line 1972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (!_tmp36_) {
#line 1973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = FALSE;
#line 1973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 13842 "equation-parser.c"
				}
#line 1975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				result = TRUE;
#line 1975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_g_object_unref0 (token);
#line 1975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				return result;
#line 13850 "equation-parser.c"
			} else {
				LexerToken* _tmp37_ = NULL;
				LexerTokenType _tmp38_ = 0;
#line 1977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp37_ = token;
#line 1977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp38_ = _tmp37_->type;
#line 1977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (_tmp38_ == LEXER_TOKEN_TYPE_ROOT_3) {
#line 13860 "equation-parser.c"
					LexerToken* _tmp39_ = NULL;
					LexerToken* _tmp40_ = NULL;
					LexerTokenType _tmp41_ = 0;
					guint _tmp42_ = 0U;
					LexerToken* _tmp43_ = NULL;
					Associativity _tmp44_ = 0;
					RootNode* _tmp45_ = NULL;
					RootNode* _tmp46_ = NULL;
					gboolean _tmp47_ = FALSE;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp39_ = token;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp40_ = token;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp41_ = _tmp40_->type;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp42_ = parser_make_precedence_t (self, _tmp41_);
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp43_ = token;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp44_ = parser_get_associativity (self, _tmp43_);
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp45_ = root_node_new (self, _tmp39_, _tmp42_, _tmp44_, 3);
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp46_ = _tmp45_;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					parser_insert_into_tree_unary (self, (ParseNode*) _tmp46_);
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (_tmp46_);
#line 1981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp47_ = parser_expression (self);
#line 1981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (!_tmp47_) {
#line 1982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = FALSE;
#line 1982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 13900 "equation-parser.c"
					}
#line 1984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					result = TRUE;
#line 1984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_g_object_unref0 (token);
#line 1984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					return result;
#line 13908 "equation-parser.c"
				} else {
					LexerToken* _tmp48_ = NULL;
					LexerTokenType _tmp49_ = 0;
#line 1986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp48_ = token;
#line 1986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp49_ = _tmp48_->type;
#line 1986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp49_ == LEXER_TOKEN_TYPE_ROOT_4) {
#line 13918 "equation-parser.c"
						LexerToken* _tmp50_ = NULL;
						LexerToken* _tmp51_ = NULL;
						LexerTokenType _tmp52_ = 0;
						guint _tmp53_ = 0U;
						LexerToken* _tmp54_ = NULL;
						Associativity _tmp55_ = 0;
						RootNode* _tmp56_ = NULL;
						RootNode* _tmp57_ = NULL;
						gboolean _tmp58_ = FALSE;
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp50_ = token;
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp51_ = token;
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp52_ = _tmp51_->type;
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp53_ = parser_make_precedence_t (self, _tmp52_);
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp54_ = token;
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp55_ = parser_get_associativity (self, _tmp54_);
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp56_ = root_node_new (self, _tmp50_, _tmp53_, _tmp55_, 4);
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp57_ = _tmp56_;
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						parser_insert_into_tree_unary (self, (ParseNode*) _tmp57_);
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (_tmp57_);
#line 1990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp58_ = parser_expression (self);
#line 1990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (!_tmp58_) {
#line 1991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = FALSE;
#line 1991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 1991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 13958 "equation-parser.c"
						}
#line 1993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						result = TRUE;
#line 1993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_g_object_unref0 (token);
#line 1993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						return result;
#line 13966 "equation-parser.c"
					} else {
						LexerToken* _tmp59_ = NULL;
						LexerTokenType _tmp60_ = 0;
#line 1995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp59_ = token;
#line 1995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						_tmp60_ = _tmp59_->type;
#line 1995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						if (_tmp60_ == LEXER_TOKEN_TYPE_VARIABLE) {
#line 13976 "equation-parser.c"
							Lexer* _tmp61_ = NULL;
							gboolean _tmp62_ = FALSE;
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp61_ = self->priv->lexer;
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							lexer_roll_back (_tmp61_);
#line 1999 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_tmp62_ = parser_term (self);
#line 1999 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							if (!_tmp62_) {
#line 2000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								result = FALSE;
#line 2000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								_g_object_unref0 (token);
#line 2000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
								return result;
#line 13993 "equation-parser.c"
							}
#line 2002 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = TRUE;
#line 2002 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 2002 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 14001 "equation-parser.c"
						} else {
#line 2005 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							result = FALSE;
#line 2005 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							_g_object_unref0 (token);
#line 2005 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
							return result;
#line 14009 "equation-parser.c"
						}
					}
				}
			}
		}
	}
#line 1943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 14018 "equation-parser.c"
}


static gboolean parser_function_invocation (Parser* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	gint num_token_parsed = 0;
	LexerToken* fun_token = NULL;
	Lexer* _tmp1_ = NULL;
	LexerToken* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* function_name = NULL;
	LexerToken* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	Associativity _tmp8_ = 0;
	const gchar* _tmp9_ = NULL;
	FunctionNameNode* _tmp10_ = NULL;
	FunctionNameNode* _tmp11_ = NULL;
	LexerToken* token = NULL;
	Lexer* _tmp12_ = NULL;
	LexerToken* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar* power = NULL;
	gboolean _tmp15_ = FALSE;
	LexerToken* _tmp16_ = NULL;
	LexerTokenType _tmp17_ = 0;
	LexerToken* _tmp26_ = NULL;
	LexerToken* _tmp27_ = NULL;
	LexerTokenType _tmp28_ = 0;
	guint _tmp29_ = 0U;
	LexerToken* _tmp30_ = NULL;
	Associativity _tmp31_ = 0;
	const gchar* _tmp32_ = NULL;
	FunctionNode* _tmp33_ = NULL;
	FunctionNode* _tmp34_ = NULL;
	LexerToken* _tmp35_ = NULL;
	LexerTokenType _tmp36_ = 0;
	guint _tmp90_ = 0U;
#line 2008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->depth_level;
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->depth_level = _tmp0_ + 1;
#line 2011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	num_token_parsed = 0;
#line 2012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = self->priv->lexer;
#line 2012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = lexer_get_next_token (_tmp1_);
#line 2012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	fun_token = _tmp2_;
#line 2013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = num_token_parsed;
#line 2013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	num_token_parsed = _tmp3_ + 1;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = fun_token;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = _tmp4_->text;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	function_name = _tmp6_;
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp7_ = parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp8_ = parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = function_name;
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp10_ = function_name_node_new (self, NULL, _tmp7_, _tmp8_, _tmp9_);
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp11_ = _tmp10_;
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_insert_into_tree (self, (ParseNode*) _tmp11_);
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (_tmp11_);
#line 2018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp12_ = self->priv->lexer;
#line 2018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp13_ = lexer_get_next_token (_tmp12_);
#line 2018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp13_;
#line 2019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp14_ = num_token_parsed;
#line 2019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	num_token_parsed = _tmp14_ + 1;
#line 2020 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	power = NULL;
#line 2021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp16_ = token;
#line 2021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp17_ = _tmp16_->type;
#line 2021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp17_ == LEXER_TOKEN_TYPE_SUP_NUMBER) {
#line 2021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = TRUE;
#line 14119 "equation-parser.c"
	} else {
		LexerToken* _tmp18_ = NULL;
		LexerTokenType _tmp19_ = 0;
#line 2021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp18_ = token;
#line 2021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp19_ = _tmp18_->type;
#line 2021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp15_ = _tmp19_ == LEXER_TOKEN_TYPE_NSUP_NUMBER;
#line 14129 "equation-parser.c"
	}
#line 2021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp15_) {
#line 14133 "equation-parser.c"
		LexerToken* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		Lexer* _tmp23_ = NULL;
		LexerToken* _tmp24_ = NULL;
		gint _tmp25_ = 0;
#line 2023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp20_ = token;
#line 2023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp21_ = _tmp20_->text;
#line 2023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp22_ = g_strdup (_tmp21_);
#line 2023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (power);
#line 2023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		power = _tmp22_;
#line 2024 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp23_ = self->priv->lexer;
#line 2024 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp24_ = lexer_get_next_token (_tmp23_);
#line 2024 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 2024 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp24_;
#line 2025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp25_ = num_token_parsed;
#line 2025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		num_token_parsed = _tmp25_ + 1;
#line 14162 "equation-parser.c"
	}
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp26_ = fun_token;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp27_ = fun_token;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp28_ = _tmp27_->type;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp29_ = parser_make_precedence_t (self, _tmp28_);
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp30_ = fun_token;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp31_ = parser_get_associativity (self, _tmp30_);
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp32_ = power;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp33_ = function_node_new (self, _tmp26_, _tmp29_, _tmp31_, _tmp32_);
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp34_ = _tmp33_;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_insert_into_tree (self, (ParseNode*) _tmp34_);
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (_tmp34_);
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp35_ = token;
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp36_ = _tmp35_->type;
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp36_ == LEXER_TOKEN_TYPE_L_R_BRACKET) {
#line 14192 "equation-parser.c"
		Lexer* _tmp37_ = NULL;
		LexerToken* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		gint m_depth = 0;
		gchar* argument_list = NULL;
		gchar* _tmp40_ = NULL;
		LexerToken* _tmp60_ = NULL;
		LexerTokenType _tmp61_ = 0;
		guint _tmp65_ = 0U;
		Associativity _tmp66_ = 0;
		const gchar* _tmp67_ = NULL;
		FunctionArgumentsNode* _tmp68_ = NULL;
		FunctionArgumentsNode* _tmp69_ = NULL;
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp37_ = self->priv->lexer;
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp38_ = lexer_get_next_token (_tmp37_);
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 2032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp38_;
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp39_ = num_token_parsed;
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		num_token_parsed = _tmp39_ + 1;
#line 2034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		m_depth = 1;
#line 2035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp40_ = g_strdup ("");
#line 2035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		argument_list = _tmp40_;
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		while (TRUE) {
#line 14226 "equation-parser.c"
			gboolean _tmp41_ = FALSE;
			LexerToken* _tmp42_ = NULL;
			LexerTokenType _tmp43_ = 0;
			LexerToken* _tmp46_ = NULL;
			LexerTokenType _tmp47_ = 0;
			const gchar* _tmp53_ = NULL;
			LexerToken* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
			Lexer* _tmp57_ = NULL;
			LexerToken* _tmp58_ = NULL;
			gint _tmp59_ = 0;
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp42_ = token;
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp43_ = _tmp42_->type;
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp43_ != LEXER_TOKEN_TYPE_PL_EOS) {
#line 14245 "equation-parser.c"
				LexerToken* _tmp44_ = NULL;
				LexerTokenType _tmp45_ = 0;
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp44_ = token;
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp45_ = _tmp44_->type;
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp41_ = _tmp45_ != LEXER_TOKEN_TYPE_ASSIGN;
#line 14254 "equation-parser.c"
			} else {
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp41_ = FALSE;
#line 14258 "equation-parser.c"
			}
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (!_tmp41_) {
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				break;
#line 14264 "equation-parser.c"
			}
#line 2039 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp46_ = token;
#line 2039 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp47_ = _tmp46_->type;
#line 2039 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (_tmp47_ == LEXER_TOKEN_TYPE_L_R_BRACKET) {
#line 14272 "equation-parser.c"
				gint _tmp48_ = 0;
#line 2040 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp48_ = m_depth;
#line 2040 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				m_depth = _tmp48_ + 1;
#line 14278 "equation-parser.c"
			} else {
				LexerToken* _tmp49_ = NULL;
				LexerTokenType _tmp50_ = 0;
#line 2041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp49_ = token;
#line 2041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp50_ = _tmp49_->type;
#line 2041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (_tmp50_ == LEXER_TOKEN_TYPE_R_R_BRACKET) {
#line 14288 "equation-parser.c"
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp51_ = m_depth;
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					m_depth = _tmp51_ - 1;
#line 2044 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					_tmp52_ = m_depth;
#line 2044 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					if (_tmp52_ == 0) {
#line 2045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
						break;
#line 14301 "equation-parser.c"
					}
				}
			}
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp53_ = argument_list;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp54_ = token;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp55_ = _tmp54_->text;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp56_ = g_strconcat (_tmp53_, _tmp55_, NULL);
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (argument_list);
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			argument_list = _tmp56_;
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp57_ = self->priv->lexer;
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp58_ = lexer_get_next_token (_tmp57_);
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			token = _tmp58_;
#line 2049 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp59_ = num_token_parsed;
#line 2049 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			num_token_parsed = _tmp59_ + 1;
#line 14329 "equation-parser.c"
		}
#line 2052 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp60_ = token;
#line 2052 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp61_ = _tmp60_->type;
#line 2052 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp61_ != LEXER_TOKEN_TYPE_R_R_BRACKET) {
#line 14337 "equation-parser.c"
			guint _tmp64_ = 0U;
#line 2054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			while (TRUE) {
#line 14341 "equation-parser.c"
				gint _tmp62_ = 0;
				Lexer* _tmp63_ = NULL;
#line 2054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp62_ = num_token_parsed;
#line 2054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				num_token_parsed = _tmp62_ - 1;
#line 2054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				if (!(_tmp62_ > 0)) {
#line 2054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
					break;
#line 14352 "equation-parser.c"
				}
#line 2055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp63_ = self->priv->lexer;
#line 2055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				lexer_roll_back (_tmp63_);
#line 14358 "equation-parser.c"
			}
#line 2056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp64_ = self->priv->depth_level;
#line 2056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			self->priv->depth_level = _tmp64_ - 1;
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (argument_list);
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (power);
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (function_name);
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (fun_token);
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 14378 "equation-parser.c"
		}
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp65_ = parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp66_ = parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE);
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp67_ = argument_list;
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp68_ = function_arguments_node_new (self, NULL, _tmp65_, _tmp66_, _tmp67_);
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp69_ = _tmp68_;
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_insert_into_tree (self, (ParseNode*) _tmp69_);
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (_tmp69_);
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (argument_list);
#line 14396 "equation-parser.c"
	} else {
		Lexer* _tmp70_ = NULL;
		gboolean _tmp71_ = FALSE;
		Lexer* _tmp74_ = NULL;
		LexerToken* _tmp75_ = NULL;
		LexerToken* _tmp76_ = NULL;
		LexerTokenType _tmp77_ = 0;
		guint _tmp87_ = 0U;
		gboolean _tmp88_ = FALSE;
#line 2064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp70_ = self->priv->lexer;
#line 2064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		lexer_roll_back (_tmp70_);
#line 2065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp71_ = parser_expression_1 (self);
#line 2065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp71_) {
#line 14414 "equation-parser.c"
			Lexer* _tmp72_ = NULL;
			guint _tmp73_ = 0U;
#line 2067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp72_ = self->priv->lexer;
#line 2067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			lexer_roll_back (_tmp72_);
#line 2068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp73_ = self->priv->depth_level;
#line 2068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			self->priv->depth_level = _tmp73_ - 1;
#line 2069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 2069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (power);
#line 2069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 2069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (function_name);
#line 2069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (fun_token);
#line 2069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 14437 "equation-parser.c"
		}
#line 2072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp74_ = self->priv->lexer;
#line 2072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp75_ = lexer_get_next_token (_tmp74_);
#line 2072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 2072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp75_;
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp76_ = token;
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp77_ = _tmp76_->type;
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp77_ == LEXER_TOKEN_TYPE_FACTORIAL) {
#line 14453 "equation-parser.c"
			LexerToken* _tmp78_ = NULL;
			LexerToken* _tmp79_ = NULL;
			LexerTokenType _tmp80_ = 0;
			guint _tmp81_ = 0U;
			LexerToken* _tmp82_ = NULL;
			Associativity _tmp83_ = 0;
			FactorialNode* _tmp84_ = NULL;
			FactorialNode* _tmp85_ = NULL;
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp78_ = token;
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp79_ = token;
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp80_ = _tmp79_->type;
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp81_ = parser_make_precedence_t (self, _tmp80_);
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp82_ = token;
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp83_ = parser_get_associativity (self, _tmp82_);
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp84_ = factorial_node_new (self, _tmp78_, _tmp81_, _tmp83_);
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp85_ = _tmp84_;
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_insert_into_tree_unary (self, (ParseNode*) _tmp85_);
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp85_);
#line 14482 "equation-parser.c"
		} else {
			Lexer* _tmp86_ = NULL;
#line 2076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp86_ = self->priv->lexer;
#line 2076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			lexer_roll_back (_tmp86_);
#line 14489 "equation-parser.c"
		}
#line 2078 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp87_ = self->priv->depth_level;
#line 2078 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		self->priv->depth_level = _tmp87_ - 1;
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp88_ = parser_expression_2 (self);
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp88_) {
#line 14499 "equation-parser.c"
			Lexer* _tmp89_ = NULL;
#line 2082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp89_ = self->priv->lexer;
#line 2082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			lexer_roll_back (_tmp89_);
#line 2083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 2083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (power);
#line 2083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 2083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_free0 (function_name);
#line 2083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (fun_token);
#line 2083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 14517 "equation-parser.c"
		}
#line 2085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = TRUE;
#line 2085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (power);
#line 2085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 2085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_free0 (function_name);
#line 2085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (fun_token);
#line 2085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 14531 "equation-parser.c"
	}
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp90_ = self->priv->depth_level;
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv->depth_level = _tmp90_ - 1;
#line 2089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	result = TRUE;
#line 2089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (power);
#line 2089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 2089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (function_name);
#line 2089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (fun_token);
#line 2089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return result;
#line 14549 "equation-parser.c"
}


static gboolean parser_term (Parser* self) {
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	LexerToken* _tmp2_ = NULL;
	LexerTokenType _tmp3_ = 0;
#line 2092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2094 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->lexer;
#line 2094 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = lexer_get_next_token (_tmp0_);
#line 2094 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp1_;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = token;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp3_ = _tmp2_->type;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp3_ == LEXER_TOKEN_TYPE_VARIABLE) {
#line 14574 "equation-parser.c"
		LexerToken* token_old = NULL;
		LexerToken* _tmp4_ = NULL;
		LexerToken* _tmp5_ = NULL;
		Lexer* _tmp6_ = NULL;
		LexerToken* _tmp7_ = NULL;
		LexerToken* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		LexerToken* _tmp25_ = NULL;
		LexerTokenType _tmp26_ = 0;
		gboolean _tmp46_ = FALSE;
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp4_ = token;
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token_old = _tmp5_;
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = self->priv->lexer;
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = lexer_get_next_token (_tmp6_);
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		token = _tmp7_;
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp8_ = token_old;
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp9_ = _tmp8_->text;
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = parser_check_variable (self, _tmp9_);
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp10_) {
#line 14608 "equation-parser.c"
			LexerToken* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 2103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp11_ = token;
#line 2103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp12_ = _tmp11_->text;
#line 2103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			if (g_strcmp0 (_tmp12_, "(") == 0) {
#line 14617 "equation-parser.c"
				LexerToken* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				LexerToken* _tmp15_ = NULL;
				guint _tmp16_ = 0U;
				LexerToken* _tmp17_ = NULL;
				guint _tmp18_ = 0U;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp13_ = token_old;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp14_ = _tmp13_->text;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp15_ = token_old;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp16_ = _tmp15_->start_index;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp17_ = token_old;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp18_ = _tmp17_->end_index;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				parser_set_error (self, ERROR_CODE_UNKNOWN_FUNCTION, _tmp14_, _tmp16_, _tmp18_);
#line 14638 "equation-parser.c"
			} else {
				LexerToken* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				LexerToken* _tmp21_ = NULL;
				guint _tmp22_ = 0U;
				LexerToken* _tmp23_ = NULL;
				guint _tmp24_ = 0U;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp19_ = token_old;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp20_ = _tmp19_->text;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp21_ = token_old;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp22_ = _tmp21_->start_index;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp23_ = token_old;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				_tmp24_ = _tmp23_->end_index;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
				parser_set_error (self, ERROR_CODE_UNKNOWN_VARIABLE, _tmp20_, _tmp22_, _tmp24_);
#line 14660 "equation-parser.c"
			}
#line 2107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 2107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token_old);
#line 2107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 2107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 14670 "equation-parser.c"
		}
#line 2109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp25_ = token;
#line 2109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp26_ = _tmp25_->type;
#line 2109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (_tmp26_ == LEXER_TOKEN_TYPE_SUP_NUMBER) {
#line 14678 "equation-parser.c"
			LexerToken* _tmp27_ = NULL;
			LexerToken* _tmp28_ = NULL;
			LexerTokenType _tmp29_ = 0;
			guint _tmp30_ = 0U;
			LexerToken* _tmp31_ = NULL;
			Associativity _tmp32_ = 0;
			LexerToken* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			VariableWithPowerNode* _tmp35_ = NULL;
			VariableWithPowerNode* _tmp36_ = NULL;
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp27_ = token_old;
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp28_ = token_old;
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp29_ = _tmp28_->type;
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp30_ = parser_make_precedence_t (self, _tmp29_);
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp31_ = token_old;
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp32_ = parser_get_associativity (self, _tmp31_);
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp33_ = token;
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp34_ = _tmp33_->text;
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp35_ = variable_with_power_node_new (self, _tmp27_, _tmp30_, _tmp32_, _tmp34_);
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp36_ = _tmp35_;
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_insert_into_tree (self, (ParseNode*) _tmp36_);
#line 2110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp36_);
#line 14713 "equation-parser.c"
		} else {
			Lexer* _tmp37_ = NULL;
			LexerToken* _tmp38_ = NULL;
			LexerToken* _tmp39_ = NULL;
			LexerTokenType _tmp40_ = 0;
			guint _tmp41_ = 0U;
			LexerToken* _tmp42_ = NULL;
			Associativity _tmp43_ = 0;
			VariableNode* _tmp44_ = NULL;
			VariableNode* _tmp45_ = NULL;
#line 2113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp37_ = self->priv->lexer;
#line 2113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			lexer_roll_back (_tmp37_);
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp38_ = token_old;
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp39_ = token_old;
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp40_ = _tmp39_->type;
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp41_ = parser_make_precedence_t (self, _tmp40_);
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp42_ = token_old;
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp43_ = parser_get_associativity (self, _tmp42_);
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp44_ = variable_node_new (self, _tmp38_, _tmp41_, _tmp43_);
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_tmp45_ = _tmp44_;
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			parser_insert_into_tree (self, (ParseNode*) _tmp45_);
#line 2114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (_tmp45_);
#line 14748 "equation-parser.c"
		}
#line 2117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp46_ = parser_term_2 (self);
#line 2117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp46_) {
#line 2118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 2118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token_old);
#line 2118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 2118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 14762 "equation-parser.c"
		}
#line 2120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = TRUE;
#line 2120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token_old);
#line 2120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 2120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 14772 "equation-parser.c"
	} else {
#line 2123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = FALSE;
#line 2123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 2123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 14780 "equation-parser.c"
	}
#line 2092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 14784 "equation-parser.c"
}


static gboolean parser_term_2 (Parser* self) {
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_ = NULL;
	LexerToken* _tmp1_ = NULL;
	Lexer* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	LexerToken* _tmp4_ = NULL;
	LexerTokenType _tmp5_ = 0;
	LexerToken* _tmp8_ = NULL;
	LexerTokenType _tmp9_ = 0;
#line 2126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp0_ = self->priv->lexer;
#line 2128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp1_ = lexer_get_next_token (_tmp0_);
#line 2128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	token = _tmp1_;
#line 2129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp2_ = self->priv->lexer;
#line 2129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	lexer_roll_back (_tmp2_);
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp4_ = token;
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp5_ = _tmp4_->type;
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp5_ == LEXER_TOKEN_TYPE_PL_EOS) {
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = TRUE;
#line 14819 "equation-parser.c"
	} else {
		LexerToken* _tmp6_ = NULL;
		LexerTokenType _tmp7_ = 0;
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp6_ = token;
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp7_ = _tmp6_->type;
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp3_ = _tmp7_ == LEXER_TOKEN_TYPE_ASSIGN;
#line 14829 "equation-parser.c"
	}
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp3_) {
#line 2132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = TRUE;
#line 2132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 2132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 14839 "equation-parser.c"
	}
#line 2134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp8_ = token;
#line 2134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_tmp9_ = _tmp8_->type;
#line 2134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (_tmp9_ == LEXER_TOKEN_TYPE_VARIABLE) {
#line 14847 "equation-parser.c"
		guint _tmp10_ = 0U;
		Associativity _tmp11_ = 0;
		MultiplyNode* _tmp12_ = NULL;
		MultiplyNode* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp10_ = parser_make_precedence_p (self, PRECEDENCE_MULTIPLY);
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp11_ = parser_get_associativity_p (self, PRECEDENCE_MULTIPLY);
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp12_ = multiply_node_new (self, NULL, _tmp10_, _tmp11_);
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp13_ = _tmp12_;
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_insert_into_tree (self, (ParseNode*) _tmp13_);
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (_tmp13_);
#line 2139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_tmp14_ = parser_term (self);
#line 2139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (!_tmp14_) {
#line 2140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			result = FALSE;
#line 2140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			_g_object_unref0 (token);
#line 2140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return result;
#line 14875 "equation-parser.c"
		}
#line 2142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = TRUE;
#line 2142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 2142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 14883 "equation-parser.c"
	} else {
#line 2145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		result = TRUE;
#line 2145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		_g_object_unref0 (token);
#line 2145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return result;
#line 14891 "equation-parser.c"
	}
#line 2126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (token);
#line 14895 "equation-parser.c"
}


static void value_parser_init (GValue* value) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	value->data[0].v_pointer = NULL;
#line 14902 "equation-parser.c"
}


static void value_parser_free_value (GValue* value) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (value->data[0].v_pointer) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_unref (value->data[0].v_pointer);
#line 14911 "equation-parser.c"
	}
}


static void value_parser_copy_value (const GValue* src_value, GValue* dest_value) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (src_value->data[0].v_pointer) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		dest_value->data[0].v_pointer = parser_ref (src_value->data[0].v_pointer);
#line 14921 "equation-parser.c"
	} else {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		dest_value->data[0].v_pointer = NULL;
#line 14925 "equation-parser.c"
	}
}


static gpointer value_parser_peek_pointer (const GValue* value) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return value->data[0].v_pointer;
#line 14933 "equation-parser.c"
}


static gchar* value_parser_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (collect_values[0].v_pointer) {
#line 14940 "equation-parser.c"
		Parser* object;
		object = collect_values[0].v_pointer;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		if (object->parent_instance.g_class == NULL) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 14947 "equation-parser.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 14951 "equation-parser.c"
		}
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		value->data[0].v_pointer = parser_ref (object);
#line 14955 "equation-parser.c"
	} else {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		value->data[0].v_pointer = NULL;
#line 14959 "equation-parser.c"
	}
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return NULL;
#line 14963 "equation-parser.c"
}


static gchar* value_parser_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Parser** object_p;
	object_p = collect_values[0].v_pointer;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (!object_p) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 14974 "equation-parser.c"
	}
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (!value->data[0].v_pointer) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*object_p = NULL;
#line 14980 "equation-parser.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*object_p = value->data[0].v_pointer;
#line 14984 "equation-parser.c"
	} else {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		*object_p = parser_ref (value->data[0].v_pointer);
#line 14988 "equation-parser.c"
	}
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return NULL;
#line 14992 "equation-parser.c"
}


GParamSpec* param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecParser* spec;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PARSER), NULL);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return G_PARAM_SPEC (spec);
#line 15006 "equation-parser.c"
}


gpointer value_get_parser (const GValue* value) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARSER), NULL);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return value->data[0].v_pointer;
#line 15015 "equation-parser.c"
}


void value_set_parser (GValue* value, gpointer v_object) {
	Parser* old;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARSER));
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	old = value->data[0].v_pointer;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (v_object) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PARSER));
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		value->data[0].v_pointer = v_object;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_ref (value->data[0].v_pointer);
#line 15035 "equation-parser.c"
	} else {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		value->data[0].v_pointer = NULL;
#line 15039 "equation-parser.c"
	}
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (old) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_unref (old);
#line 15045 "equation-parser.c"
	}
}


void value_take_parser (GValue* value, gpointer v_object) {
	Parser* old;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARSER));
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	old = value->data[0].v_pointer;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (v_object) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PARSER));
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		value->data[0].v_pointer = v_object;
#line 15064 "equation-parser.c"
	} else {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		value->data[0].v_pointer = NULL;
#line 15068 "equation-parser.c"
	}
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (old) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		parser_unref (old);
#line 15074 "equation-parser.c"
	}
}


static void parser_class_init (ParserClass * klass) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	parser_parent_class = g_type_class_peek_parent (klass);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParserClass *) klass)->finalize = parser_finalize;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_type_class_add_private (klass, sizeof (ParserPrivate));
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParserClass *) klass)->variable_is_defined = parser_real_variable_is_defined;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParserClass *) klass)->get_variable = parser_real_get_variable;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParserClass *) klass)->set_variable = parser_real_set_variable;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParserClass *) klass)->function_is_defined = parser_real_function_is_defined;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	((ParserClass *) klass)->convert = parser_real_convert;
#line 15096 "equation-parser.c"
}


static void parser_instance_init (Parser * self) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->priv = PARSER_GET_PRIVATE (self);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self->ref_count = 1;
#line 15105 "equation-parser.c"
}


static void parser_finalize (Parser* obj) {
	Parser * self;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PARSER, Parser);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_signal_handlers_destroy (self);
#line 892 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (self->priv->input);
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->priv->root);
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->priv->right_most);
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_object_unref0 (self->priv->lexer);
#line 901 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	_g_free0 (self->priv->error_token);
#line 15125 "equation-parser.c"
}


GType parser_get_type (void) {
	static volatile gsize parser_type_id__volatile = 0;
	if (g_once_init_enter (&parser_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_parser_init, value_parser_free_value, value_parser_copy_value, value_parser_peek_pointer, "p", value_parser_collect_value, "p", value_parser_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Parser), 0, (GInstanceInitFunc) parser_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType parser_type_id;
		parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Parser", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&parser_type_id__volatile, parser_type_id);
	}
	return parser_type_id__volatile;
}


gpointer parser_ref (gpointer instance) {
	Parser* self;
	self = instance;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	g_atomic_int_inc (&self->ref_count);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	return instance;
#line 15150 "equation-parser.c"
}


void parser_unref (gpointer instance) {
	Parser* self;
	self = instance;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		PARSER_GET_CLASS (self)->finalize (self);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/equation-parser.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 15163 "equation-parser.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



