/* cc-credentials-account-applications-model.c generated by valac 0.16.1, the Vala compiler
 * generated from cc-credentials-account-applications-model.vala, do not modify */

/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      David King <david.king@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libaccount-plugin/account-plugin.h>
#include <gtk/gtk.h>
#include <libaccounts-glib/accounts-glib.h>
#include <gio/gdesktopappinfo.h>
#include <glib/gi18n-lib.h>


#define CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_ROW (cc_credentials_account_application_row_get_type ())
typedef struct _CcCredentialsAccountApplicationRow CcCredentialsAccountApplicationRow;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL (cc_credentials_account_applications_model_get_type ())
#define CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL, CcCredentialsAccountApplicationsModel))
#define CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL, CcCredentialsAccountApplicationsModelClass))
#define CC_CREDENTIALS_IS_ACCOUNT_APPLICATIONS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL))
#define CC_CREDENTIALS_IS_ACCOUNT_APPLICATIONS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL))
#define CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL, CcCredentialsAccountApplicationsModelClass))

typedef struct _CcCredentialsAccountApplicationsModel CcCredentialsAccountApplicationsModel;
typedef struct _CcCredentialsAccountApplicationsModelClass CcCredentialsAccountApplicationsModelClass;
typedef struct _CcCredentialsAccountApplicationsModelPrivate CcCredentialsAccountApplicationsModelPrivate;
#define __g_list_free__cc_credentials_account_application_row_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__cc_credentials_account_application_row_free0_ (var), NULL)))
#define __vala_AgApplication_free0(var) ((var == NULL) ? NULL : (var = (_vala_AgApplication_free (var), NULL)))
#define __g_list_free___vala_AgApplication_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_AgApplication_free0_ (var), NULL)))
#define __vala_AgService_free0(var) ((var == NULL) ? NULL : (var = (_vala_AgService_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free___vala_AgService_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_AgService_free0_ (var), NULL)))

struct _CcCredentialsAccountApplicationRow {
	gchar* name;
	GIcon* icon;
	gchar* description;
	ApApplicationPlugin* plugin;
	GtkWidget* plugin_widget;
};

struct _CcCredentialsAccountApplicationsModel {
	GObject parent_instance;
	CcCredentialsAccountApplicationsModelPrivate * priv;
	GList* application_rows;
};

struct _CcCredentialsAccountApplicationsModelClass {
	GObjectClass parent_class;
};

struct _CcCredentialsAccountApplicationsModelPrivate {
	AgManager* manager;
	AgAccount* current_account;
};


static gpointer cc_credentials_account_applications_model_parent_class = NULL;

GType cc_credentials_account_application_row_get_type (void) G_GNUC_CONST;
CcCredentialsAccountApplicationRow* cc_credentials_account_application_row_dup (const CcCredentialsAccountApplicationRow* self);
void cc_credentials_account_application_row_free (CcCredentialsAccountApplicationRow* self);
void cc_credentials_account_application_row_copy (const CcCredentialsAccountApplicationRow* self, CcCredentialsAccountApplicationRow* dest);
void cc_credentials_account_application_row_destroy (CcCredentialsAccountApplicationRow* self);
GType cc_credentials_account_applications_model_get_type (void) G_GNUC_CONST;
#define CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL, CcCredentialsAccountApplicationsModelPrivate))
enum  {
	CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_DUMMY_PROPERTY,
	CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_ACCOUNT
};
static void _cc_credentials_account_application_row_free0_ (gpointer var);
static void _g_list_free__cc_credentials_account_application_row_free0_ (GList* self);
CcCredentialsAccountApplicationsModel* cc_credentials_account_applications_model_new (void);
CcCredentialsAccountApplicationsModel* cc_credentials_account_applications_model_construct (GType object_type);
static void cc_credentials_account_applications_model_populate_model (CcCredentialsAccountApplicationsModel* self);
static void _g_free0_ (gpointer var);
static void _vala_AgApplication_free (AgApplication* self);
static void __vala_AgApplication_free0_ (gpointer var);
static AgService* _vala_AgService_copy (AgService* self);
static AgApplication* _vala_AgApplication_copy (AgApplication* self);
static void _g_list_free___vala_AgApplication_free0_ (GList* self);
static void _vala_AgService_free (AgService* self);
static void cc_credentials_account_applications_model_add_application (CcCredentialsAccountApplicationsModel* self, const gchar* service_name, AgApplication* application);
static void _cc_credentials_account_applications_model_add_application_gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void __vala_AgService_free0_ (gpointer var);
static void _g_list_free___vala_AgService_free0_ (GList* self);
AgAccount* cc_credentials_account_applications_model_get_account (CcCredentialsAccountApplicationsModel* self);
void cc_credentials_account_applications_model_set_account (CcCredentialsAccountApplicationsModel* self, AgAccount* value);
static void cc_credentials_account_applications_model_finalize (GObject* obj);
static void _vala_cc_credentials_account_applications_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_cc_credentials_account_applications_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void cc_credentials_account_application_row_copy (const CcCredentialsAccountApplicationRow* self, CcCredentialsAccountApplicationRow* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GIcon* _tmp2_;
	GIcon* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	ApApplicationPlugin* _tmp6_;
	ApApplicationPlugin* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).icon;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).icon);
	(*dest).icon = _tmp3_;
	_tmp4_ = (*self).description;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp5_;
	_tmp6_ = (*self).plugin;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 ((*dest).plugin);
	(*dest).plugin = _tmp7_;
	_tmp8_ = (*self).plugin_widget;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 ((*dest).plugin_widget);
	(*dest).plugin_widget = _tmp9_;
}


void cc_credentials_account_application_row_destroy (CcCredentialsAccountApplicationRow* self) {
	_g_free0 ((*self).name);
	_g_object_unref0 ((*self).icon);
	_g_free0 ((*self).description);
	_g_object_unref0 ((*self).plugin);
	_g_object_unref0 ((*self).plugin_widget);
}


CcCredentialsAccountApplicationRow* cc_credentials_account_application_row_dup (const CcCredentialsAccountApplicationRow* self) {
	CcCredentialsAccountApplicationRow* dup;
	dup = g_new0 (CcCredentialsAccountApplicationRow, 1);
	cc_credentials_account_application_row_copy (self, dup);
	return dup;
}


void cc_credentials_account_application_row_free (CcCredentialsAccountApplicationRow* self) {
	cc_credentials_account_application_row_destroy (self);
	g_free (self);
}


GType cc_credentials_account_application_row_get_type (void) {
	static volatile gsize cc_credentials_account_application_row_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_account_application_row_type_id__volatile)) {
		GType cc_credentials_account_application_row_type_id;
		cc_credentials_account_application_row_type_id = g_boxed_type_register_static ("CcCredentialsAccountApplicationRow", (GBoxedCopyFunc) cc_credentials_account_application_row_dup, (GBoxedFreeFunc) cc_credentials_account_application_row_free);
		g_once_init_leave (&cc_credentials_account_application_row_type_id__volatile, cc_credentials_account_application_row_type_id);
	}
	return cc_credentials_account_application_row_type_id__volatile;
}


static void _cc_credentials_account_application_row_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (cc_credentials_account_application_row_free (var), NULL));
}


static void _g_list_free__cc_credentials_account_application_row_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _cc_credentials_account_application_row_free0_, NULL);
	g_list_free (self);
}


/**
     * Create a new model for storing applications that can be used with an
     * account.
     *
     * @param widget a Gtk.Widget to be used for looking up themed icons
     */
CcCredentialsAccountApplicationsModel* cc_credentials_account_applications_model_construct (GType object_type) {
	CcCredentialsAccountApplicationsModel * self = NULL;
	AgManager* _tmp0_;
	self = (CcCredentialsAccountApplicationsModel*) g_object_new (object_type, NULL);
	_tmp0_ = ag_manager_new ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp0_;
	return self;
}


CcCredentialsAccountApplicationsModel* cc_credentials_account_applications_model_new (void) {
	return cc_credentials_account_applications_model_construct (CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL);
}


/**
     * Populate the model with a list of applications that can use the services
     * of the current account.
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_AgApplication_free (AgApplication* self) {
	g_boxed_free (ag_application_get_type (), self);
}


static void __vala_AgApplication_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_AgApplication_free (var), NULL));
}


static AgService* _vala_AgService_copy (AgService* self) {
	return g_boxed_copy (ag_service_get_type (), self);
}


static gpointer __vala_AgService_copy0 (gpointer self) {
	return self ? _vala_AgService_copy (self) : NULL;
}


static AgApplication* _vala_AgApplication_copy (AgApplication* self) {
	return g_boxed_copy (ag_application_get_type (), self);
}


static gpointer __vala_AgApplication_copy0 (gpointer self) {
	return self ? _vala_AgApplication_copy (self) : NULL;
}


static void _g_list_free___vala_AgApplication_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_AgApplication_free0_, NULL);
	g_list_free (self);
}


static void _vala_AgService_free (AgService* self) {
	g_boxed_free (ag_service_get_type (), self);
}


static void _cc_credentials_account_applications_model_add_application_gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	cc_credentials_account_applications_model_add_application (self, key, value);
}


static void __vala_AgService_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_AgService_free (var), NULL));
}


static void _g_list_free___vala_AgService_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_AgService_free0_, NULL);
	g_list_free (self);
}


static void cc_credentials_account_applications_model_populate_model (CcCredentialsAccountApplicationsModel* self) {
	AgAccount* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* services;
	GHashFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* service_application;
	GList* _tmp4_;
	GHashTable* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_account;
	_tmp1_ = ag_account_list_services (_tmp0_);
	services = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_hash_table_new_full (_tmp2_, NULL, _g_free0_, __vala_AgApplication_free0_);
	service_application = _tmp3_;
	_tmp4_ = services;
	{
		GList* service_collection = NULL;
		GList* service_it = NULL;
		service_collection = _tmp4_;
		for (service_it = service_collection; service_it != NULL; service_it = service_it->next) {
			AgService* _tmp5_;
			AgService* service = NULL;
			_tmp5_ = __vala_AgService_copy0 ((AgService*) service_it->data);
			service = _tmp5_;
			{
				AgManager* _tmp6_;
				AgService* _tmp7_;
				GList* _tmp8_ = NULL;
				GList* applications;
				GList* _tmp9_;
				_tmp6_ = self->priv->manager;
				_tmp7_ = service;
				_tmp8_ = ag_manager_list_applications_by_service (_tmp6_, _tmp7_);
				applications = _tmp8_;
				_tmp9_ = applications;
				{
					GList* application_collection = NULL;
					GList* application_it = NULL;
					application_collection = _tmp9_;
					for (application_it = application_collection; application_it != NULL; application_it = application_it->next) {
						AgApplication* _tmp10_;
						AgApplication* application = NULL;
						_tmp10_ = __vala_AgApplication_copy0 ((AgApplication*) application_it->data);
						application = _tmp10_;
						{
							GHashTable* _tmp11_;
							AgService* _tmp12_;
							const gchar* _tmp13_ = NULL;
							gchar* _tmp14_;
							AgApplication* _tmp15_;
							AgApplication* _tmp16_;
							_tmp11_ = service_application;
							_tmp12_ = service;
							_tmp13_ = ag_service_get_name (_tmp12_);
							_tmp14_ = g_strdup (_tmp13_);
							_tmp15_ = application;
							_tmp16_ = __vala_AgApplication_copy0 (_tmp15_);
							g_hash_table_insert (_tmp11_, _tmp14_, _tmp16_);
							__vala_AgApplication_free0 (application);
						}
					}
				}
				__g_list_free___vala_AgApplication_free0_0 (applications);
				__vala_AgService_free0 (service);
			}
		}
	}
	_tmp17_ = service_application;
	g_hash_table_foreach (_tmp17_, _cc_credentials_account_applications_model_add_application_gh_func, self);
	self->application_rows = g_list_reverse (self->application_rows);
	_g_hash_table_unref0 (service_application);
	__g_list_free___vala_AgService_free0_0 (services);
}


/**
     * Add a single application to the model.
     *
     * @param service_name the name of the Ag.Service
     * @param application the Ag.Application to add to the model
     */
static gpointer _cc_credentials_account_application_row_dup0 (gpointer self) {
	return self ? cc_credentials_account_application_row_dup (self) : NULL;
}


static void cc_credentials_account_applications_model_add_application (CcCredentialsAccountApplicationsModel* self, const gchar* service_name, AgApplication* application) {
	AgApplication* _tmp0_;
	GDesktopAppInfo* _tmp1_ = NULL;
	GDesktopAppInfo* desktop_info;
	GDesktopAppInfo* _tmp2_;
	GDesktopAppInfo* _tmp5_;
	GIcon* _tmp6_ = NULL;
	GIcon* _tmp7_;
	GIcon* app_icon;
	AgManager* _tmp8_;
	const gchar* _tmp9_;
	AgService* _tmp10_ = NULL;
	AgService* service;
	AgApplication* _tmp11_;
	const gchar* _tmp12_ = NULL;
	AgApplication* _tmp13_;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* app_description;
	AgApplication* _tmp17_;
	const gchar* _tmp18_ = NULL;
	AgApplication* _tmp19_;
	AgService* _tmp20_;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gchar* app_service_usage;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* description_markup;
	AgApplication* _tmp32_;
	AgAccount* _tmp33_;
	ApApplicationPlugin* _tmp34_ = NULL;
	ApApplicationPlugin* app_plugin;
	GtkWidget* app_plugin_widget;
	ApApplicationPlugin* _tmp35_;
	AgApplication* _tmp44_;
	const gchar* _tmp45_ = NULL;
	gchar* _tmp46_;
	GIcon* _tmp47_;
	GIcon* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	ApApplicationPlugin* _tmp51_;
	ApApplicationPlugin* _tmp52_;
	GtkWidget* _tmp53_;
	GtkWidget* _tmp54_;
	CcCredentialsAccountApplicationRow _tmp55_ = {0};
	CcCredentialsAccountApplicationRow application_row;
	CcCredentialsAccountApplicationRow _tmp56_;
	CcCredentialsAccountApplicationRow _tmp57_;
	CcCredentialsAccountApplicationRow* _tmp58_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service_name != NULL);
	_tmp0_ = application;
	_tmp1_ = ag_application_get_desktop_app_info (_tmp0_);
	desktop_info = _tmp1_;
	_tmp2_ = desktop_info;
	if (_tmp2_ == NULL) {
		AgApplication* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = application;
		_tmp4_ = ag_application_get_name (_tmp3_);
		g_message ("cc-credentials-account-applications-model.vala:126: No desktop app inf" \
"o found for application name: %s", _tmp4_);
		_g_object_unref0 (desktop_info);
		return;
	}
	_tmp5_ = desktop_info;
	_tmp6_ = g_app_info_get_icon ((GAppInfo*) _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	app_icon = _tmp7_;
	_tmp8_ = self->priv->manager;
	_tmp9_ = service_name;
	_tmp10_ = ag_manager_get_service (_tmp8_, _tmp9_);
	service = _tmp10_;
	_tmp11_ = application;
	_tmp12_ = ag_application_get_i18n_domain (_tmp11_);
	_tmp13_ = application;
	_tmp14_ = ag_application_get_description (_tmp13_);
	_tmp15_ = g_dgettext (_tmp12_, _tmp14_);
	_tmp16_ = g_strdup (_tmp15_);
	app_description = _tmp16_;
	_tmp17_ = application;
	_tmp18_ = ag_application_get_i18n_domain (_tmp17_);
	_tmp19_ = application;
	_tmp20_ = service;
	_tmp21_ = ag_application_get_service_usage (_tmp19_, _tmp20_);
	_tmp22_ = g_dgettext (_tmp18_, _tmp21_);
	_tmp23_ = g_strdup (_tmp22_);
	app_service_usage = _tmp23_;
	_tmp24_ = app_description;
	_tmp25_ = g_strconcat (_tmp24_, "\n<small>", NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = app_service_usage;
	_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat (_tmp29_, "</small>", NULL);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	_g_free0 (_tmp26_);
	description_markup = _tmp31_;
	_tmp32_ = application;
	_tmp33_ = self->priv->current_account;
	_tmp34_ = ap_client_load_application_plugin (_tmp32_, _tmp33_);
	app_plugin = _tmp34_;
	app_plugin_widget = NULL;
	_tmp35_ = app_plugin;
	if (_tmp35_ == NULL) {
		AgApplication* _tmp36_;
		const gchar* _tmp37_ = NULL;
		AgAccount* _tmp38_;
		guint _tmp39_ = 0U;
		guint _tmp40_;
		_tmp36_ = application;
		_tmp37_ = ag_application_get_name (_tmp36_);
		_tmp38_ = self->priv->current_account;
		g_object_get (_tmp38_, "id", &_tmp39_, NULL);
		_tmp40_ = _tmp39_;
		g_message ("cc-credentials-account-applications-model.vala:153: No valid plugin fo" \
"und for application '%s' with account '%u'", _tmp37_, _tmp40_);
	} else {
		ApApplicationPlugin* _tmp41_;
		GtkWidget* _tmp42_ = NULL;
		GtkWidget* _tmp43_;
		_tmp41_ = app_plugin;
		_tmp42_ = ap_application_plugin_build_widget (_tmp41_);
		_tmp43_ = _g_object_ref0 (_tmp42_);
		_g_object_unref0 (app_plugin_widget);
		app_plugin_widget = _tmp43_;
	}
	_tmp44_ = application;
	_tmp45_ = ag_application_get_name (_tmp44_);
	_tmp46_ = g_strdup (_tmp45_);
	_tmp47_ = app_icon;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	_tmp49_ = description_markup;
	_tmp50_ = g_strdup (_tmp49_);
	_tmp51_ = app_plugin;
	_tmp52_ = _g_object_ref0 (_tmp51_);
	_tmp53_ = app_plugin_widget;
	_tmp54_ = _g_object_ref0 (_tmp53_);
	memset (&_tmp55_, 0, sizeof (CcCredentialsAccountApplicationRow));
	_g_free0 (_tmp55_.name);
	_tmp55_.name = _tmp46_;
	_g_object_unref0 (_tmp55_.icon);
	_tmp55_.icon = _tmp48_;
	_g_free0 (_tmp55_.description);
	_tmp55_.description = _tmp50_;
	_g_object_unref0 (_tmp55_.plugin);
	_tmp55_.plugin = _tmp52_;
	_g_object_unref0 (_tmp55_.plugin_widget);
	_tmp55_.plugin_widget = _tmp54_;
	application_row = _tmp55_;
	_tmp56_ = application_row;
	_tmp57_ = _tmp56_;
	_tmp58_ = _cc_credentials_account_application_row_dup0 (&_tmp57_);
	self->application_rows = g_list_prepend (self->application_rows, _tmp58_);
	cc_credentials_account_application_row_destroy (&application_row);
	_g_object_unref0 (app_plugin_widget);
	_g_object_unref0 (app_plugin);
	_g_free0 (description_markup);
	_g_free0 (app_service_usage);
	_g_free0 (app_description);
	__vala_AgService_free0 (service);
	_g_object_unref0 (app_icon);
	_g_object_unref0 (desktop_info);
}


AgAccount* cc_credentials_account_applications_model_get_account (CcCredentialsAccountApplicationsModel* self) {
	AgAccount* result;
	AgAccount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_account;
	result = _tmp0_;
	return result;
}


void cc_credentials_account_applications_model_set_account (CcCredentialsAccountApplicationsModel* self, AgAccount* value) {
	AgAccount* _tmp0_;
	AgAccount* _tmp1_;
	AgAccount* _tmp2_;
	AgAccount* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = self->priv->current_account;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->current_account);
	self->priv->current_account = _tmp3_;
	__g_list_free__cc_credentials_account_application_row_free0_0 (self->application_rows);
	self->application_rows = NULL;
	cc_credentials_account_applications_model_populate_model (self);
	g_object_notify ((GObject *) self, "account");
}


static void cc_credentials_account_applications_model_class_init (CcCredentialsAccountApplicationsModelClass * klass) {
	cc_credentials_account_applications_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CcCredentialsAccountApplicationsModelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_cc_credentials_account_applications_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_cc_credentials_account_applications_model_set_property;
	G_OBJECT_CLASS (klass)->finalize = cc_credentials_account_applications_model_finalize;
	/**
	     * Update the model when the current account changes.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_ACCOUNT, g_param_spec_object ("account", "account", "account", ag_account_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void cc_credentials_account_applications_model_instance_init (CcCredentialsAccountApplicationsModel * self) {
	self->priv = CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_GET_PRIVATE (self);
}


static void cc_credentials_account_applications_model_finalize (GObject* obj) {
	CcCredentialsAccountApplicationsModel * self;
	self = CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL (obj);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->current_account);
	__g_list_free__cc_credentials_account_application_row_free0_0 (self->application_rows);
	G_OBJECT_CLASS (cc_credentials_account_applications_model_parent_class)->finalize (obj);
}


/**
 * Web credentials account applications model. Used to store details about
 * applications that can be integrated with an account, to be used in creating
 * widgets in a grid for describing the applications.
 */
GType cc_credentials_account_applications_model_get_type (void) {
	static volatile gsize cc_credentials_account_applications_model_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_account_applications_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CcCredentialsAccountApplicationsModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cc_credentials_account_applications_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CcCredentialsAccountApplicationsModel), 0, (GInstanceInitFunc) cc_credentials_account_applications_model_instance_init, NULL };
		GType cc_credentials_account_applications_model_type_id;
		cc_credentials_account_applications_model_type_id = g_type_register_static (G_TYPE_OBJECT, "CcCredentialsAccountApplicationsModel", &g_define_type_info, 0);
		g_once_init_leave (&cc_credentials_account_applications_model_type_id__volatile, cc_credentials_account_applications_model_type_id);
	}
	return cc_credentials_account_applications_model_type_id__volatile;
}


static void _vala_cc_credentials_account_applications_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CcCredentialsAccountApplicationsModel * self;
	self = CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL (object);
	switch (property_id) {
		case CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_ACCOUNT:
		g_value_set_object (value, cc_credentials_account_applications_model_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_cc_credentials_account_applications_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CcCredentialsAccountApplicationsModel * self;
	self = CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL (object);
	switch (property_id) {
		case CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_ACCOUNT:
		cc_credentials_account_applications_model_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



