/* cc-credentials-accounts-model.c generated by valac 0.16.1, the Vala compiler
 * generated from cc-credentials-accounts-model.vala, do not modify */

/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      David King <david.king@canonical.com>
 */
/* FIXME: Make the model sortable.*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libaccounts-glib/accounts-glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>


#define CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL (cc_credentials_accounts_model_get_type ())
#define CC_CREDENTIALS_ACCOUNTS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL, CcCredentialsAccountsModel))
#define CC_CREDENTIALS_ACCOUNTS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL, CcCredentialsAccountsModelClass))
#define CC_CREDENTIALS_IS_ACCOUNTS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL))
#define CC_CREDENTIALS_IS_ACCOUNTS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL))
#define CC_CREDENTIALS_ACCOUNTS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL, CcCredentialsAccountsModelClass))

typedef struct _CcCredentialsAccountsModel CcCredentialsAccountsModel;
typedef struct _CcCredentialsAccountsModelClass CcCredentialsAccountsModelClass;
typedef struct _CcCredentialsAccountsModelPrivate CcCredentialsAccountsModelPrivate;

#define CC_TYPE_WEBCREDENTIALS_INDICATOR (cc_webcredentials_indicator_get_type ())
#define CC_WEBCREDENTIALS_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_TYPE_WEBCREDENTIALS_INDICATOR, CcWebcredentialsIndicator))
#define CC_IS_WEBCREDENTIALS_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_TYPE_WEBCREDENTIALS_INDICATOR))
#define CC_WEBCREDENTIALS_INDICATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CC_TYPE_WEBCREDENTIALS_INDICATOR, CcWebcredentialsIndicatorIface))

typedef struct _CcWebcredentialsIndicator CcWebcredentialsIndicator;
typedef struct _CcWebcredentialsIndicatorIface CcWebcredentialsIndicatorIface;

#define CC_TYPE_WEBCREDENTIALS_INDICATOR_PROXY (cc_webcredentials_indicator_proxy_get_type ())

#define CC_CREDENTIALS_ACCOUNTS_MODEL_TYPE_MODEL_COLUMNS (cc_credentials_accounts_model_model_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define CC_CREDENTIALS_ACCOUNTS_MODEL_TYPE_COLUMN_RECORD (cc_credentials_accounts_model_column_record_get_type ())
typedef struct _CcCredentialsAccountsModelColumnRecord CcCredentialsAccountsModelColumnRecord;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __vala_AgProvider_free0(var) ((var == NULL) ? NULL : (var = (_vala_AgProvider_free (var), NULL)))

struct _CcCredentialsAccountsModel {
	GtkListStore parent_instance;
	CcCredentialsAccountsModelPrivate * priv;
};

struct _CcCredentialsAccountsModelClass {
	GtkListStoreClass parent_class;
};

struct _CcWebcredentialsIndicatorIface {
	GTypeInterface parent_iface;
	void (*report_failure) (CcWebcredentialsIndicator* self, guint account_id, GHashTable* notification, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*report_failure_finish) (CcWebcredentialsIndicator* self, GAsyncResult* _res_, GError** error);
	void (*remove_failures) (CcWebcredentialsIndicator* self, guint* account_ids, int account_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_failures_finish) (CcWebcredentialsIndicator* self, GAsyncResult* _res_, GError** error);
	void (*clear_error_status) (CcWebcredentialsIndicator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*clear_error_status_finish) (CcWebcredentialsIndicator* self, GAsyncResult* _res_, GError** error);
	guint* (*get_failures) (CcWebcredentialsIndicator* self, int* result_length1);
};

struct _CcCredentialsAccountsModelPrivate {
	AgManager* accounts_manager;
	guint* past_failures;
	gint past_failures_length1;
	gint _past_failures_size_;
	CcWebcredentialsIndicator* indicator;
};

typedef enum  {
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_ID = 0,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT = 1,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_PROVIDER_ICON = 2,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_TRANSLUCENT_PIXBUF = 3,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION = 4,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ENABLED = 5,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION = 6
} CcCredentialsAccountsModelModelColumns;

struct _CcCredentialsAccountsModelColumnRecord {
	guint account_id;
	AgAccount* account;
	GIcon* icon;
	GdkPixbuf* translucent_pixbuf;
	gchar* description;
	gboolean enabled;
	gboolean attention;
};


static gpointer cc_credentials_accounts_model_parent_class = NULL;

GType cc_credentials_accounts_model_get_type (void) G_GNUC_CONST;
GType cc_webcredentials_indicator_proxy_get_type (void) G_GNUC_CONST;
guint cc_webcredentials_indicator_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType cc_webcredentials_indicator_get_type (void) G_GNUC_CONST;
#define CC_CREDENTIALS_ACCOUNTS_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL, CcCredentialsAccountsModelPrivate))
enum  {
	CC_CREDENTIALS_ACCOUNTS_MODEL_DUMMY_PROPERTY,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MANAGER,
	CC_CREDENTIALS_ACCOUNTS_MODEL_WEBCREDENTIALS_INTERFACE
};
GType cc_credentials_accounts_model_model_columns_get_type (void) G_GNUC_CONST;
CcCredentialsAccountsModel* cc_credentials_accounts_model_new (void);
CcCredentialsAccountsModel* cc_credentials_accounts_model_construct (GType object_type);
static void cc_credentials_accounts_model_add_account (CcCredentialsAccountsModel* self, guint account_id);
static void _cc_credentials_accounts_model_add_account_gfunc (gconstpointer data, gpointer self);
static void cc_credentials_accounts_model_on_proxy_properties_changed (CcCredentialsAccountsModel* self, GVariant* changed_properties, const gchar* invalidated_properties, int invalidated_properties_length1);
static void _cc_credentials_accounts_model_on_proxy_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static void cc_credentials_accounts_model_on_indicator_notify_failures (CcCredentialsAccountsModel* self);
static void cc_credentials_accounts_model_on_account_created (CcCredentialsAccountsModel* self, guint id);
static void _cc_credentials_accounts_model_on_account_created_ag_manager_account_created (AgManager* _sender, guint account_id, gpointer self);
static void cc_credentials_accounts_model_on_account_deleted (CcCredentialsAccountsModel* self, guint id);
static void _cc_credentials_accounts_model_on_account_deleted_ag_manager_account_deleted (AgManager* _sender, guint id, gpointer self);
static void cc_credentials_accounts_model_on_account_updated (CcCredentialsAccountsModel* self, guint id);
static void _cc_credentials_accounts_model_on_account_updated_ag_manager_account_updated (AgManager* _sender, guint account_id, gpointer self);
static GType cc_credentials_accounts_model_column_record_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CcCredentialsAccountsModelColumnRecord* cc_credentials_accounts_model_column_record_dup (const CcCredentialsAccountsModelColumnRecord* self);
static void cc_credentials_accounts_model_column_record_free (CcCredentialsAccountsModelColumnRecord* self);
static void cc_credentials_accounts_model_column_record_copy (const CcCredentialsAccountsModelColumnRecord* self, CcCredentialsAccountsModelColumnRecord* dest);
static void cc_credentials_accounts_model_column_record_destroy (CcCredentialsAccountsModelColumnRecord* self);
static void cc_credentials_accounts_model_fill_column_record (CcCredentialsAccountsModel* self, guint account_id, CcCredentialsAccountsModelColumnRecord* result);
gboolean cc_credentials_accounts_model_find_iter_for_account_id (CcCredentialsAccountsModel* self, AgAccountId account_id, GtkTreeIter* iter);
static GdkPixbuf* cc_credentials_accounts_model_translucent_from_gicon (CcCredentialsAccountsModel* self, GIcon* gicon);
guint* cc_webcredentials_indicator_get_failures (CcWebcredentialsIndicator* self, int* result_length1);
static guint* _vala_array_dup1 (guint* self, int length);
static void cc_credentials_accounts_model_set_failure (CcCredentialsAccountsModel* self, guint account_id, gboolean failure);
static void _cc_credentials_accounts_model_set_failure_gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void cc_credentials_accounts_model_on_account_enabled (CcCredentialsAccountsModel* self, AgAccount* account, const gchar* service, gboolean enabled);
static gchar* cc_credentials_accounts_model_format_account_description (CcCredentialsAccountsModel* self, AgAccount* account);
static void cc_credentials_accounts_model_on_account_display_name_changed (CcCredentialsAccountsModel* self, AgAccount* account);
AgManager* cc_credentials_accounts_model_get_manager (CcCredentialsAccountsModel* self);
static void _vala_AgProvider_free (AgProvider* self);
static void _cc_credentials_accounts_model_on_account_enabled_ag_account_enabled (AgAccount* _sender, const gchar* service, gboolean enabled, gpointer self);
static void _cc_credentials_accounts_model_on_account_display_name_changed_ag_account_display_name_changed (AgAccount* _sender, gpointer self);
CcWebcredentialsIndicator* cc_credentials_accounts_model_get_webcredentials_interface (CcCredentialsAccountsModel* self);
static void cc_credentials_accounts_model_finalize (GObject* obj);
static void _vala_cc_credentials_accounts_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static gint _vala_array_length (gpointer array);


/**
     * Identifiers for columns in the accounts model.
     *
     * @param ACCOUNT_ID the Ag.AccountId for the Ag.Account
     * @param ACCOUNT the Ag.Account
     * @param PROVIDER_ICON the icon of the account provider
     * @param TRANSLUCENT_PIXBUF the translucent icon to show when the account
     * is disabled
     * @param ACCOUNT_DESCRIPTION the description of the account or provider
     * @param ENABLED whether the account is enabled
     * @param NEEDS_ATTENTION whether there is a problem with the account that
     * needs the attention of the user
     */
GType cc_credentials_accounts_model_model_columns_get_type (void) {
	static volatile gsize cc_credentials_accounts_model_model_columns_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_accounts_model_model_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_ID, "CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_ID", "account-id"}, {CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT, "CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT", "account"}, {CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_PROVIDER_ICON, "CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_PROVIDER_ICON", "provider-icon"}, {CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_TRANSLUCENT_PIXBUF, "CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_TRANSLUCENT_PIXBUF", "translucent-pixbuf"}, {CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION, "CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION", "account-description"}, {CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ENABLED, "CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ENABLED", "enabled"}, {CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION, "CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION", "needs-attention"}, {0, NULL, NULL}};
		GType cc_credentials_accounts_model_model_columns_type_id;
		cc_credentials_accounts_model_model_columns_type_id = g_enum_register_static ("CcCredentialsAccountsModelModelColumns", values);
		g_once_init_leave (&cc_credentials_accounts_model_model_columns_type_id__volatile, cc_credentials_accounts_model_model_columns_type_id);
	}
	return cc_credentials_accounts_model_model_columns_type_id__volatile;
}


/**
     * Create a new data model for the list of accounts.
     */
static void _cc_credentials_accounts_model_add_account_gfunc (gconstpointer data, gpointer self) {
	cc_credentials_accounts_model_add_account (self, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _cc_credentials_accounts_model_on_proxy_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
	cc_credentials_accounts_model_on_proxy_properties_changed (self, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}


static void _cc_credentials_accounts_model_on_account_created_ag_manager_account_created (AgManager* _sender, guint account_id, gpointer self) {
	cc_credentials_accounts_model_on_account_created (self, account_id);
}


static void _cc_credentials_accounts_model_on_account_deleted_ag_manager_account_deleted (AgManager* _sender, guint id, gpointer self) {
	cc_credentials_accounts_model_on_account_deleted (self, id);
}


static void _cc_credentials_accounts_model_on_account_updated_ag_manager_account_updated (AgManager* _sender, guint account_id, gpointer self) {
	cc_credentials_accounts_model_on_account_updated (self, account_id);
}


CcCredentialsAccountsModel* cc_credentials_accounts_model_construct (GType object_type) {
	CcCredentialsAccountsModel * self = NULL;
	GType* _tmp0_ = NULL;
	GType* types;
	gint types_length1;
	gint _types_size_;
	AgManager* _tmp1_;
	AgManager* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* accounts;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* add_account_text;
	GIcon* provider_icon;
	gint _tmp10_;
	GIcon* _tmp11_;
	AgManager* _tmp19_;
	AgManager* _tmp20_;
	AgManager* _tmp21_;
	GError * _inner_error_ = NULL;
	self = (CcCredentialsAccountsModel*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (GType, 7);
	_tmp0_[0] = G_TYPE_UINT;
	_tmp0_[1] = ag_account_get_type ();
	_tmp0_[2] = G_TYPE_ICON;
	_tmp0_[3] = GDK_TYPE_PIXBUF;
	_tmp0_[4] = G_TYPE_STRING;
	_tmp0_[5] = G_TYPE_BOOLEAN;
	_tmp0_[6] = G_TYPE_BOOLEAN;
	types = _tmp0_;
	types_length1 = 7;
	_types_size_ = types_length1;
	gtk_list_store_set_column_types ((GtkListStore*) self, types_length1, types);
	_tmp1_ = ag_manager_new ();
	_g_object_unref0 (self->priv->accounts_manager);
	self->priv->accounts_manager = _tmp1_;
	_tmp2_ = self->priv->accounts_manager;
	_tmp3_ = ag_manager_list (_tmp2_);
	accounts = _tmp3_;
	g_list_foreach (accounts, _cc_credentials_accounts_model_add_account_gfunc, self);
	_tmp4_ = _ ("Add account…");
	_tmp5_ = g_strdup (_tmp4_);
	add_account_text = _tmp5_;
	provider_icon = NULL;
	{
		GIcon* _tmp6_ = NULL;
		GIcon* _tmp7_;
		_tmp6_ = g_icon_new_for_string ("credentials-add-account", &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_g_object_unref0 (provider_icon);
		provider_icon = _tmp7_;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_message ("cc-credentials-accounts-model.vala:116: Error looking up themed add ic" \
"on: %s", _tmp9_);
		_g_error_free0 (_error_);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (provider_icon);
		_g_free0 (add_account_text);
		_g_list_free0 (accounts);
		types = (g_free (types), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp10_ = G_MAXINT;
	_tmp11_ = provider_icon;
	gtk_list_store_insert_with_values ((GtkListStore*) self, NULL, _tmp10_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_ID, 0, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_PROVIDER_ICON, _tmp11_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION, add_account_text, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ENABLED, TRUE, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION, FALSE, -1, -1);
	{
		CcWebcredentialsIndicator* _tmp12_ = NULL;
		CcWebcredentialsIndicator* _tmp13_;
		CcWebcredentialsIndicator* _tmp14_;
		GDBusProxy* _tmp15_;
		GDBusProxy* indicator_proxy;
		GDBusProxy* _tmp16_;
		_tmp12_ = g_initable_new (CC_TYPE_WEBCREDENTIALS_INDICATOR_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "com.canonical.indicators.webcredentials", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/com/canonical/indicators/webcredentials", "g-interface-name", "com.canonical.indicators.webcredentials", NULL);
		_tmp13_ = (CcWebcredentialsIndicator*) _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch4_g_io_error;
			}
			_g_object_unref0 (provider_icon);
			_g_free0 (add_account_text);
			_g_list_free0 (accounts);
			types = (g_free (types), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->priv->indicator);
		self->priv->indicator = _tmp13_;
		_tmp14_ = self->priv->indicator;
		_tmp15_ = _g_object_ref0 (G_IS_DBUS_PROXY (_tmp14_) ? ((GDBusProxy*) _tmp14_) : NULL);
		indicator_proxy = _tmp15_;
		_tmp16_ = indicator_proxy;
		g_signal_connect_object (_tmp16_, "g-properties-changed", (GCallback) _cc_credentials_accounts_model_on_proxy_properties_changed_g_dbus_proxy_g_properties_changed, self, 0);
		cc_credentials_accounts_model_on_indicator_notify_failures (self);
		_g_object_unref0 (indicator_proxy);
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = err;
		_tmp18_ = _tmp17_->message;
		g_warning ("cc-credentials-accounts-model.vala:141: Error initializing indicator p" \
"roxy: %s\n" \
"Account attention monitoring will be disabled", _tmp18_);
		_g_error_free0 (err);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (provider_icon);
		_g_free0 (add_account_text);
		_g_list_free0 (accounts);
		types = (g_free (types), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp19_ = self->priv->accounts_manager;
	g_signal_connect_object (_tmp19_, "account-created", (GCallback) _cc_credentials_accounts_model_on_account_created_ag_manager_account_created, self, 0);
	_tmp20_ = self->priv->accounts_manager;
	g_signal_connect_object (_tmp20_, "account-deleted", (GCallback) _cc_credentials_accounts_model_on_account_deleted_ag_manager_account_deleted, self, 0);
	_tmp21_ = self->priv->accounts_manager;
	g_signal_connect_object (_tmp21_, "account-updated", (GCallback) _cc_credentials_accounts_model_on_account_updated_ag_manager_account_updated, self, 0);
	_g_object_unref0 (provider_icon);
	_g_free0 (add_account_text);
	_g_list_free0 (accounts);
	types = (g_free (types), NULL);
	return self;
}


CcCredentialsAccountsModel* cc_credentials_accounts_model_new (void) {
	return cc_credentials_accounts_model_construct (CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL);
}


/**
     * Instantiate an account from the supplied account ID, and add it to the
     * list of accounts.
     *
     * This method is intended to be used with the foreach method of GLib
     * containers.
     *
     * @param account_id an Ag.AccountId to add to the list of accounts
     */
static void cc_credentials_accounts_model_add_account (CcCredentialsAccountsModel* self, guint account_id) {
	AgAccount* account = NULL;
	guint _tmp6_;
	CcCredentialsAccountsModelColumnRecord _tmp7_ = {0};
	CcCredentialsAccountsModelColumnRecord record;
	CcCredentialsAccountsModelColumnRecord _tmp8_;
	guint _tmp9_;
	CcCredentialsAccountsModelColumnRecord _tmp10_;
	AgAccount* _tmp11_;
	CcCredentialsAccountsModelColumnRecord _tmp12_;
	GIcon* _tmp13_;
	CcCredentialsAccountsModelColumnRecord _tmp14_;
	GdkPixbuf* _tmp15_;
	CcCredentialsAccountsModelColumnRecord _tmp16_;
	const gchar* _tmp17_;
	CcCredentialsAccountsModelColumnRecord _tmp18_;
	gboolean _tmp19_;
	CcCredentialsAccountsModelColumnRecord _tmp20_;
	gboolean _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		AgManager* _tmp0_;
		guint _tmp1_;
		AgAccount* _tmp2_ = NULL;
		AgAccount* _tmp3_;
		_tmp0_ = self->priv->accounts_manager;
		_tmp1_ = account_id;
		_tmp2_ = ag_manager_load_account (_tmp0_, (AgAccountId) _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_g_object_unref0 (account);
		account = _tmp3_;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_critical ("cc-credentials-accounts-model.vala:168: Unable to instantiate account:" \
" %s", _tmp5_);
		_g_error_free0 (_error_);
		_g_object_unref0 (account);
		return;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (account);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = account_id;
	cc_credentials_accounts_model_fill_column_record (self, _tmp6_, &_tmp7_);
	record = _tmp7_;
	_tmp8_ = record;
	_tmp9_ = _tmp8_.account_id;
	_tmp10_ = record;
	_tmp11_ = _tmp10_.account;
	_tmp12_ = record;
	_tmp13_ = _tmp12_.icon;
	_tmp14_ = record;
	_tmp15_ = _tmp14_.translucent_pixbuf;
	_tmp16_ = record;
	_tmp17_ = _tmp16_.description;
	_tmp18_ = record;
	_tmp19_ = _tmp18_.enabled;
	_tmp20_ = record;
	_tmp21_ = _tmp20_.attention;
	gtk_list_store_insert_with_values ((GtkListStore*) self, NULL, 0, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_ID, _tmp9_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT, _tmp11_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_PROVIDER_ICON, _tmp13_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_TRANSLUCENT_PIXBUF, _tmp15_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION, _tmp17_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ENABLED, _tmp19_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION, _tmp21_, -1, -1);
	cc_credentials_accounts_model_column_record_destroy (&record);
	_g_object_unref0 (account);
}


/**
     * Get an iter to a row in the model with a matching Ag.AccountId.
     *
     * The row in the model for adding a new account (which has an accound ID
     * of 0) is special, as it is always the last row. Additionally, false is
     * always returned when searching for that row.
     *
     * @param account_id the Ag.AccountId of an Ag.Account described in the
     * model
     * @return true if the account_id existed in the model, false otherwise
     */
gboolean cc_credentials_accounts_model_find_iter_for_account_id (CcCredentialsAccountsModel* self, AgAccountId account_id, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTreeIter local_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	AgAccountId _tmp1_;
	gboolean found;
	GtkTreeIter _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_tree_model_get_iter_first ((GtkTreeModel*) self, &_tmp0_);
	local_iter = _tmp0_;
	_tmp1_ = account_id;
	if (_tmp1_ == ((AgAccountId) 0)) {
		GtkTreeIter _tmp2_;
		_tmp2_ = local_iter;
		_vala_iter = _tmp2_;
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	found = FALSE;
	{
		gboolean _tmp3_;
		_tmp3_ = TRUE;
		while (TRUE) {
			gboolean _tmp4_;
			AgAccountId model_account_id = 0U;
			GtkTreeIter _tmp6_;
			AgAccountId _tmp7_;
			AgAccountId _tmp8_;
			_tmp4_ = _tmp3_;
			if (!_tmp4_) {
				gboolean _tmp5_ = FALSE;
				_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) self, &local_iter);
				if (!_tmp5_) {
					break;
				}
			}
			_tmp3_ = FALSE;
			_tmp6_ = local_iter;
			gtk_tree_model_get ((GtkTreeModel*) self, &_tmp6_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_ID, &model_account_id, -1, -1);
			_tmp7_ = account_id;
			_tmp8_ = model_account_id;
			if (_tmp7_ == _tmp8_) {
				found = TRUE;
				break;
			}
		}
	}
	_tmp9_ = local_iter;
	_vala_iter = _tmp9_;
	result = found;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


/**
     * Create a translucent Gdk.Pixbuf from a GLib.Icon.
     *
     * @param gicon the GLib.Icon to create a translucent pixbuf for
     */
static GdkPixbuf* cc_credentials_accounts_model_translucent_from_gicon (CcCredentialsAccountsModel* self, GIcon* gicon) {
	GdkPixbuf* result = NULL;
	GtkIconTheme* _tmp0_ = NULL;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* icon_theme;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	icon_theme = _tmp1_;
	{
		GIcon* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		GdkPixbuf* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* pixbuf;
		GdkColorspace _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* temp_pixbuf;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp2_ = gicon;
		_tmp3_ = g_icon_to_string (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_icon_theme_load_icon (icon_theme, _tmp4_, 32, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		pixbuf = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_tmp7_ = gdk_pixbuf_get_colorspace (pixbuf);
		_tmp8_ = gdk_pixbuf_get_bits_per_sample (pixbuf);
		_tmp9_ = gdk_pixbuf_get_width (pixbuf);
		_tmp10_ = gdk_pixbuf_get_height (pixbuf);
		_tmp11_ = gdk_pixbuf_new (_tmp7_, TRUE, _tmp8_, _tmp9_, _tmp10_);
		temp_pixbuf = _tmp11_;
		_tmp12_ = temp_pixbuf;
		gdk_pixbuf_fill (_tmp12_, (guint32) 0);
		_tmp13_ = temp_pixbuf;
		_tmp14_ = gdk_pixbuf_get_width (pixbuf);
		_tmp15_ = gdk_pixbuf_get_height (pixbuf);
		gdk_pixbuf_composite (pixbuf, _tmp13_, 0, 0, _tmp14_, _tmp15_, 0.0, 0.0, 1.0, 1.0, GDK_INTERP_BILINEAR, 255 / 2);
		result = temp_pixbuf;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (icon_theme);
		return result;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* err = NULL;
		GIcon* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		GdkPixbuf* _tmp21_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = gicon;
		_tmp17_ = g_icon_to_string (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = err;
		_tmp20_ = _tmp19_->message;
		g_message ("cc-credentials-accounts-model.vala:254: Error loading icon '%s': %s", _tmp18_, _tmp20_);
		_g_free0 (_tmp18_);
		_tmp21_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 32, 32);
		result = _tmp21_;
		_g_error_free0 (err);
		_g_object_unref0 (icon_theme);
		return result;
	}
	__finally6:
	_g_object_unref0 (icon_theme);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
     * Handle D-Bus property changes on the indicator proxy.
     *
     * @param changed_properties dictionary of changed property names and
     * values
     * @param invalidated_properties array of names of invalidated properties
     */
static void cc_credentials_accounts_model_on_proxy_properties_changed (CcCredentialsAccountsModel* self, GVariant* changed_properties, const gchar* invalidated_properties, int invalidated_properties_length1) {
	GVariant* _tmp0_;
	GVariantIter* _tmp1_ = NULL;
	GVariantIter* iter;
	GVariant* change = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed_properties != NULL);
	_tmp0_ = changed_properties;
	_tmp1_ = g_variant_iter_new (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GVariantIter* _tmp2_;
		GVariant* _tmp3_ = NULL;
		GVariant* _tmp4_;
		gchar* property_name = NULL;
		GVariant* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = iter;
		_tmp3_ = g_variant_iter_next_value (_tmp2_);
		_g_variant_unref0 (change);
		change = _tmp3_;
		_tmp4_ = change;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = change;
		g_variant_get (_tmp5_, "{sv}", &property_name, NULL, NULL);
		_tmp6_ = property_name;
		if (g_strcmp0 (_tmp6_, "Failures") == 0) {
		}
		{
			cc_credentials_accounts_model_on_indicator_notify_failures (self);
		}
		_g_free0 (property_name);
	}
	_g_variant_unref0 (change);
	_g_variant_iter_free0 (iter);
}


/**
     * Handle account authentication failures, marking the failing accounts as
     * needing attention.
     */
static guint* _vala_array_dup1 (guint* self, int length) {
	return g_memdup (self, length * sizeof (guint));
}


static void _cc_credentials_accounts_model_set_failure_gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	cc_credentials_accounts_model_set_failure (self, key, value);
}


static void cc_credentials_accounts_model_on_indicator_notify_failures (CcCredentialsAccountsModel* self) {
	CcWebcredentialsIndicator* _tmp0_;
	guint* _tmp1_;
	gint _tmp1__length1;
	guint* _tmp2_;
	gint _tmp2__length1;
	guint* failures;
	gint failures_length1;
	gint _failures_size_;
	gboolean _tmp3_ = FALSE;
	guint* _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GHashTable* failures_hash;
	guint* _tmp10_;
	gint _tmp10__length1;
	guint* _tmp14_;
	gint _tmp14__length1;
	guint* _tmp18_;
	gint _tmp18__length1;
	guint* _tmp19_;
	gint _tmp19__length1;
	GHashTable* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->indicator;
	_tmp1_ = cc_webcredentials_indicator_get_failures (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	failures = _tmp2_;
	failures_length1 = _tmp2__length1;
	_failures_size_ = failures_length1;
	_tmp4_ = self->priv->past_failures;
	_tmp4__length1 = self->priv->past_failures_length1;
	if (_tmp4_ == NULL) {
		guint* _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = failures;
		_tmp5__length1 = failures_length1;
		_tmp3_ = _tmp5_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		failures = (g_free (failures), NULL);
		return;
	}
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, NULL, NULL);
	failures_hash = _tmp9_;
	_tmp10_ = self->priv->past_failures;
	_tmp10__length1 = self->priv->past_failures_length1;
	if (_tmp10_ != NULL) {
		guint* _tmp11_;
		gint _tmp11__length1;
		_tmp11_ = self->priv->past_failures;
		_tmp11__length1 = self->priv->past_failures_length1;
		{
			guint* past_failure_collection = NULL;
			gint past_failure_collection_length1 = 0;
			gint _past_failure_collection_size_ = 0;
			gint past_failure_it = 0;
			past_failure_collection = _tmp11_;
			past_failure_collection_length1 = _tmp11__length1;
			for (past_failure_it = 0; past_failure_it < _tmp11__length1; past_failure_it = past_failure_it + 1) {
				guint past_failure = 0U;
				past_failure = past_failure_collection[past_failure_it];
				{
					GHashTable* _tmp12_;
					guint _tmp13_;
					_tmp12_ = failures_hash;
					_tmp13_ = past_failure;
					g_hash_table_insert (_tmp12_, GUINT_TO_POINTER (_tmp13_), GINT_TO_POINTER (FALSE));
				}
			}
		}
	}
	_tmp14_ = failures;
	_tmp14__length1 = failures_length1;
	if (_tmp14_ != NULL) {
		guint* _tmp15_;
		gint _tmp15__length1;
		_tmp15_ = failures;
		_tmp15__length1 = failures_length1;
		{
			guint* failure_collection = NULL;
			gint failure_collection_length1 = 0;
			gint _failure_collection_size_ = 0;
			gint failure_it = 0;
			failure_collection = _tmp15_;
			failure_collection_length1 = _tmp15__length1;
			for (failure_it = 0; failure_it < _tmp15__length1; failure_it = failure_it + 1) {
				guint failure = 0U;
				failure = failure_collection[failure_it];
				{
					GHashTable* _tmp16_;
					guint _tmp17_;
					_tmp16_ = failures_hash;
					_tmp17_ = failure;
					g_hash_table_insert (_tmp16_, GUINT_TO_POINTER (_tmp17_), GINT_TO_POINTER (TRUE));
				}
			}
		}
	}
	_tmp18_ = failures;
	_tmp18__length1 = failures_length1;
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup1 (_tmp18_, _tmp18__length1) : ((gpointer) _tmp18_);
	_tmp19__length1 = _tmp18__length1;
	self->priv->past_failures = (g_free (self->priv->past_failures), NULL);
	self->priv->past_failures = _tmp19_;
	self->priv->past_failures_length1 = _tmp19__length1;
	self->priv->_past_failures_size_ = self->priv->past_failures_length1;
	_tmp20_ = failures_hash;
	g_hash_table_foreach (_tmp20_, _cc_credentials_accounts_model_set_failure_gh_func, self);
	_g_hash_table_unref0 (failures_hash);
	failures = (g_free (failures), NULL);
}


/**
     * Set the failure state for an account id in the model.
     *
     * @param account_id the account ID for which to set the failure
     * @param failure true if the account should be marked as failing, false if
     * the account failure state should be cleared
     */
static void cc_credentials_accounts_model_set_failure (CcCredentialsAccountsModel* self, guint account_id, gboolean failure) {
	GtkTreeIter iter = {0};
	guint _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = account_id;
	_tmp2_ = cc_credentials_accounts_model_find_iter_for_account_id (self, (AgAccountId) _tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkTreeIter _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = iter;
		_tmp4_ = failure;
		gtk_list_store_set ((GtkListStore*) self, &_tmp3_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION, _tmp4_, -1, -1);
	} else {
		guint _tmp5_;
		_tmp5_ = account_id;
		g_message ("cc-credentials-accounts-model.vala:344: Failure change reported for no" \
"n-existent account ID: %u", _tmp5_);
	}
}


/**
     * Handle the account-created signal on Ag.Manager.
     *
     * @param id the Ag.AccountId of the Ag.Account that was created
     */
static void cc_credentials_accounts_model_on_account_created (CcCredentialsAccountsModel* self, guint id) {
	guint _tmp0_;
	AgAccountId account_id;
	g_return_if_fail (self != NULL);
	_tmp0_ = id;
	account_id = (AgAccountId) _tmp0_;
	cc_credentials_accounts_model_add_account (self, (guint) account_id);
}


/**
     * Handle the account-deleted signal on Ag.Manager.
     *
     * @param id the Ag.AccountId of the Ag.Account that was deleted
     */
static void cc_credentials_accounts_model_on_account_deleted (CcCredentialsAccountsModel* self, guint id) {
	guint _tmp0_;
	AgAccountId account_id;
	GtkTreeIter iter = {0};
	AgAccountId _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = id;
	account_id = (AgAccountId) _tmp0_;
	_tmp1_ = account_id;
	_tmp3_ = cc_credentials_accounts_model_find_iter_for_account_id (self, _tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		GtkTreeIter _tmp4_;
		_tmp4_ = iter;
		gtk_list_store_remove ((GtkListStore*) self, &_tmp4_);
	} else {
		guint _tmp5_;
		_tmp5_ = id;
		g_warning ("cc-credentials-accounts-model.vala:377: Account with ID %u was already" \
" removed", _tmp5_);
	}
}


/**
     * Handle the account-updated signal on Ag.Manager.
     *
     * @param id the Ag.AccountId of the Ag.Account that was updated
     */
static void cc_credentials_accounts_model_on_account_updated (CcCredentialsAccountsModel* self, guint id) {
	guint _tmp0_;
	AgAccountId account_id;
	GtkTreeIter iter = {0};
	AgAccountId _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = id;
	account_id = (AgAccountId) _tmp0_;
	_tmp1_ = account_id;
	_tmp3_ = cc_credentials_accounts_model_find_iter_for_account_id (self, _tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		AgAccountId _tmp4_;
		CcCredentialsAccountsModelColumnRecord _tmp5_ = {0};
		CcCredentialsAccountsModelColumnRecord record;
		GtkTreeIter _tmp6_;
		CcCredentialsAccountsModelColumnRecord _tmp7_;
		GIcon* _tmp8_;
		CcCredentialsAccountsModelColumnRecord _tmp9_;
		GdkPixbuf* _tmp10_;
		CcCredentialsAccountsModelColumnRecord _tmp11_;
		const gchar* _tmp12_;
		CcCredentialsAccountsModelColumnRecord _tmp13_;
		gboolean _tmp14_;
		CcCredentialsAccountsModelColumnRecord _tmp15_;
		gboolean _tmp16_;
		_tmp4_ = account_id;
		cc_credentials_accounts_model_fill_column_record (self, (guint) _tmp4_, &_tmp5_);
		record = _tmp5_;
		_tmp6_ = iter;
		_tmp7_ = record;
		_tmp8_ = _tmp7_.icon;
		_tmp9_ = record;
		_tmp10_ = _tmp9_.translucent_pixbuf;
		_tmp11_ = record;
		_tmp12_ = _tmp11_.description;
		_tmp13_ = record;
		_tmp14_ = _tmp13_.enabled;
		_tmp15_ = record;
		_tmp16_ = _tmp15_.attention;
		gtk_list_store_set ((GtkListStore*) self, &_tmp6_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_PROVIDER_ICON, _tmp8_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_TRANSLUCENT_PIXBUF, _tmp10_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION, _tmp12_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ENABLED, _tmp14_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION, _tmp16_, -1, -1);
		cc_credentials_accounts_model_column_record_destroy (&record);
	} else {
		guint _tmp17_;
		AgAccountId _tmp18_;
		_tmp17_ = id;
		g_warning ("cc-credentials-accounts-model.vala:405: Account with ID %u was updated" \
", but did not already exist in the model", _tmp17_);
		_tmp18_ = account_id;
		cc_credentials_accounts_model_add_account (self, (guint) _tmp18_);
	}
}


/**
     * Handle the account enabled state being changed, and update the model
     * accordingly.
     *
     * @param account the account which was updated
     * @param service the service which was changed. Ignored
     * @param enabled the current state of the account
     */
static void cc_credentials_accounts_model_on_account_enabled (CcCredentialsAccountsModel* self, AgAccount* account, const gchar* service, gboolean enabled) {
	GtkTreeIter iter = {0};
	AgAccount* _tmp0_;
	guint _tmp1_ = 0U;
	guint _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = account;
	g_object_get (_tmp0_, "id", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp4_ = cc_credentials_accounts_model_find_iter_for_account_id (self, (AgAccountId) _tmp2_, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		GtkTreeIter _tmp5_;
		AgAccount* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gboolean _tmp9_;
		_tmp5_ = iter;
		_tmp6_ = account;
		_tmp7_ = cc_credentials_accounts_model_format_account_description (self, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = enabled;
		gtk_list_store_set ((GtkListStore*) self, &_tmp5_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION, _tmp8_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ENABLED, _tmp9_, -1, -1);
		_g_free0 (_tmp8_);
	} else {
		AgAccount* _tmp10_;
		guint _tmp11_ = 0U;
		guint _tmp12_;
		_tmp10_ = account;
		g_object_get (_tmp10_, "id", &_tmp11_, NULL);
		_tmp12_ = _tmp11_;
		g_message ("cc-credentials-accounts-model.vala:433: Enabled state change reported " \
"for non-existent account ID: %u", _tmp12_);
	}
}


/**
     * Handle the account display name being changed, and update the model
     * accordingly.
     *
     * @param account the account which was updated
     */
static void cc_credentials_accounts_model_on_account_display_name_changed (CcCredentialsAccountsModel* self, AgAccount* account) {
	GtkTreeIter iter = {0};
	AgAccount* _tmp0_;
	guint _tmp1_ = 0U;
	guint _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = account;
	g_object_get (_tmp0_, "id", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp4_ = cc_credentials_accounts_model_find_iter_for_account_id (self, (AgAccountId) _tmp2_, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		GtkTreeIter _tmp5_;
		AgAccount* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp5_ = iter;
		_tmp6_ = account;
		_tmp7_ = cc_credentials_accounts_model_format_account_description (self, _tmp6_);
		_tmp8_ = _tmp7_;
		gtk_list_store_set ((GtkListStore*) self, &_tmp5_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION, _tmp8_, -1, -1);
		_g_free0 (_tmp8_);
	} else {
		AgAccount* _tmp9_;
		guint _tmp10_ = 0U;
		guint _tmp11_;
		_tmp9_ = account;
		g_object_get (_tmp9_, "id", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		g_message ("cc-credentials-accounts-model.vala:456: Enabled state change reported " \
"for non-existent account ID: %u", _tmp11_);
	}
}


/**
     * Fill in a ColumnRecord structure with details of the account, for using
     * to fill in a row in the model.
     *
     * @param account_id the ID of the Ag.Account
     * @return a new ColumnRecord
     */
static void _vala_AgProvider_free (AgProvider* self) {
	g_boxed_free (ag_provider_get_type (), self);
}


static void _cc_credentials_accounts_model_on_account_enabled_ag_account_enabled (AgAccount* _sender, const gchar* service, gboolean enabled, gpointer self) {
	cc_credentials_accounts_model_on_account_enabled (self, _sender, service, enabled);
}


static void _cc_credentials_accounts_model_on_account_display_name_changed_ag_account_display_name_changed (AgAccount* _sender, gpointer self) {
	cc_credentials_accounts_model_on_account_display_name_changed (self, _sender);
}


static void cc_credentials_accounts_model_fill_column_record (CcCredentialsAccountsModel* self, guint account_id, CcCredentialsAccountsModelColumnRecord* result) {
	AgManager* _tmp0_;
	guint _tmp1_;
	AgAccount* _tmp2_ = NULL;
	AgAccount* account;
	CcCredentialsAccountsModelColumnRecord record = {0};
	AgAccount* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* display_name;
	AgAccount* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gchar* _tmp8_ = NULL;
	CcCredentialsAccountsModelColumnRecord _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* name_markup;
	AgManager* _tmp19_;
	AgManager* _tmp20_;
	AgAccount* _tmp21_;
	const gchar* _tmp22_ = NULL;
	AgProvider* _tmp23_ = NULL;
	AgProvider* provider;
	guint _tmp24_;
	AgAccount* _tmp25_;
	AgAccount* _tmp26_;
	CcCredentialsAccountsModelColumnRecord _tmp32_;
	GIcon* _tmp33_;
	GdkPixbuf* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	AgAccount* _tmp43_;
	AgAccount* _tmp44_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->accounts_manager;
	_tmp1_ = account_id;
	_tmp2_ = ag_manager_get_account (_tmp0_, (AgAccountId) _tmp1_);
	account = _tmp2_;
	memset (&record, 0, sizeof (CcCredentialsAccountsModelColumnRecord));
	_tmp3_ = account;
	_tmp4_ = ag_account_get_display_name (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	display_name = _tmp5_;
	_tmp6_ = account;
	_tmp7_ = ag_account_get_enabled (_tmp6_);
	record.enabled = _tmp7_;
	_tmp9_ = record;
	_tmp10_ = _tmp9_.enabled;
	if (_tmp10_) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = display_name;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp12_;
	} else {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = display_name;
		_tmp14_ = g_strconcat ("<span foreground=\"#555555\">", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, "</span>", NULL);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp16_;
		_g_free0 (_tmp15_);
	}
	_tmp17_ = _tmp8_;
	_tmp18_ = g_strdup (_tmp17_);
	name_markup = _tmp18_;
	_tmp19_ = cc_credentials_accounts_model_get_manager (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = account;
	_tmp22_ = ag_account_get_provider_name (_tmp21_);
	_tmp23_ = ag_manager_get_provider (_tmp20_, _tmp22_);
	provider = _tmp23_;
	_tmp24_ = account_id;
	record.account_id = _tmp24_;
	_tmp25_ = account;
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (record.account);
	record.account = _tmp26_;
	{
		const gchar* _tmp27_ = NULL;
		GIcon* _tmp28_ = NULL;
		GIcon* _tmp29_;
		_tmp27_ = ag_provider_get_icon_name (provider);
		_tmp28_ = g_icon_new_for_string (_tmp27_, &_inner_error_);
		_tmp29_ = _tmp28_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_g_object_unref0 (record.icon);
		record.icon = _tmp29_;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = _error_;
		_tmp31_ = _tmp30_->message;
		g_message ("cc-credentials-accounts-model.vala:488: Error looking up themed provid" \
"er icon: %s", _tmp31_);
		_g_object_unref0 (record.icon);
		record.icon = NULL;
		_g_error_free0 (_error_);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		__vala_AgProvider_free0 (provider);
		_g_free0 (name_markup);
		_g_free0 (_tmp8_);
		_g_free0 (display_name);
		cc_credentials_accounts_model_column_record_destroy (&record);
		_g_object_unref0 (account);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp32_ = record;
	_tmp33_ = _tmp32_.icon;
	_tmp34_ = cc_credentials_accounts_model_translucent_from_gicon (self, _tmp33_);
	_g_object_unref0 (record.translucent_pixbuf);
	record.translucent_pixbuf = _tmp34_;
	_tmp35_ = ag_provider_get_display_name (provider);
	_tmp36_ = g_strconcat (_tmp35_, "\n", NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat (_tmp37_, "<small>", NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp39_, name_markup, NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat (_tmp41_, "</small>", NULL);
	_g_free0 (record.description);
	record.description = _tmp42_;
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	record.attention = FALSE;
	_tmp43_ = account;
	g_signal_connect_object (_tmp43_, "enabled", (GCallback) _cc_credentials_accounts_model_on_account_enabled_ag_account_enabled, self, 0);
	_tmp44_ = account;
	g_signal_connect_object (_tmp44_, "display-name-changed", (GCallback) _cc_credentials_accounts_model_on_account_display_name_changed_ag_account_display_name_changed, self, 0);
	*result = record;
	__vala_AgProvider_free0 (provider);
	_g_free0 (name_markup);
	_g_free0 (_tmp8_);
	_g_free0 (display_name);
	_g_object_unref0 (account);
	return;
}


/**
     * Provide a string describing the account for display to the user.
     *
     * @param account the account for which to generate the description
     * @return the account description
     */
static gchar* cc_credentials_accounts_model_format_account_description (CcCredentialsAccountsModel* self, AgAccount* account) {
	gchar* result = NULL;
	AgManager* _tmp0_;
	AgManager* _tmp1_;
	AgAccount* _tmp2_;
	const gchar* _tmp3_ = NULL;
	AgProvider* _tmp4_ = NULL;
	AgProvider* provider;
	AgAccount* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* display_name;
	gchar* _tmp8_ = NULL;
	AgAccount* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* name_markup;
	AgProvider* _tmp19_;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = cc_credentials_accounts_model_get_manager (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = account;
	_tmp3_ = ag_account_get_provider_name (_tmp2_);
	_tmp4_ = ag_manager_get_provider (_tmp1_, _tmp3_);
	provider = _tmp4_;
	_tmp5_ = account;
	_tmp6_ = ag_account_get_display_name (_tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	display_name = _tmp7_;
	_tmp9_ = account;
	_tmp10_ = ag_account_get_enabled (_tmp9_);
	if (_tmp10_) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = display_name;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp12_;
	} else {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = display_name;
		_tmp14_ = g_strconcat ("<span foreground=\"#555555\">", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, "</span>", NULL);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp16_;
		_g_free0 (_tmp15_);
	}
	_tmp17_ = _tmp8_;
	_tmp18_ = g_strdup (_tmp17_);
	name_markup = _tmp18_;
	_tmp19_ = provider;
	_tmp20_ = ag_provider_get_display_name (_tmp19_);
	_tmp21_ = g_strconcat (_tmp20_, "\n", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp22_, "<small>", NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp24_, name_markup, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat (_tmp26_, "</small>", NULL);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	result = _tmp28_;
	_g_free0 (name_markup);
	_g_free0 (_tmp8_);
	_g_free0 (display_name);
	__vala_AgProvider_free0 (provider);
	return result;
}


AgManager* cc_credentials_accounts_model_get_manager (CcCredentialsAccountsModel* self) {
	AgManager* result;
	AgManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->accounts_manager;
	result = _tmp0_;
	return result;
}


CcWebcredentialsIndicator* cc_credentials_accounts_model_get_webcredentials_interface (CcCredentialsAccountsModel* self) {
	CcWebcredentialsIndicator* result;
	CcWebcredentialsIndicator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->indicator;
	result = _tmp0_;
	return result;
}


static void cc_credentials_accounts_model_column_record_copy (const CcCredentialsAccountsModelColumnRecord* self, CcCredentialsAccountsModelColumnRecord* dest) {
	guint _tmp0_;
	AgAccount* _tmp1_;
	AgAccount* _tmp2_;
	GIcon* _tmp3_;
	GIcon* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	_tmp0_ = (*self).account_id;
	(*dest).account_id = _tmp0_;
	_tmp1_ = (*self).account;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 ((*dest).account);
	(*dest).account = _tmp2_;
	_tmp3_ = (*self).icon;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 ((*dest).icon);
	(*dest).icon = _tmp4_;
	_tmp5_ = (*self).translucent_pixbuf;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 ((*dest).translucent_pixbuf);
	(*dest).translucent_pixbuf = _tmp6_;
	_tmp7_ = (*self).description;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp8_;
	_tmp9_ = (*self).enabled;
	(*dest).enabled = _tmp9_;
	_tmp10_ = (*self).attention;
	(*dest).attention = _tmp10_;
}


static void cc_credentials_accounts_model_column_record_destroy (CcCredentialsAccountsModelColumnRecord* self) {
	_g_object_unref0 ((*self).account);
	_g_object_unref0 ((*self).icon);
	_g_object_unref0 ((*self).translucent_pixbuf);
	_g_free0 ((*self).description);
}


static CcCredentialsAccountsModelColumnRecord* cc_credentials_accounts_model_column_record_dup (const CcCredentialsAccountsModelColumnRecord* self) {
	CcCredentialsAccountsModelColumnRecord* dup;
	dup = g_new0 (CcCredentialsAccountsModelColumnRecord, 1);
	cc_credentials_accounts_model_column_record_copy (self, dup);
	return dup;
}


static void cc_credentials_accounts_model_column_record_free (CcCredentialsAccountsModelColumnRecord* self) {
	cc_credentials_accounts_model_column_record_destroy (self);
	g_free (self);
}


static GType cc_credentials_accounts_model_column_record_get_type (void) {
	static volatile gsize cc_credentials_accounts_model_column_record_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_accounts_model_column_record_type_id__volatile)) {
		GType cc_credentials_accounts_model_column_record_type_id;
		cc_credentials_accounts_model_column_record_type_id = g_boxed_type_register_static ("CcCredentialsAccountsModelColumnRecord", (GBoxedCopyFunc) cc_credentials_accounts_model_column_record_dup, (GBoxedFreeFunc) cc_credentials_accounts_model_column_record_free);
		g_once_init_leave (&cc_credentials_accounts_model_column_record_type_id__volatile, cc_credentials_accounts_model_column_record_type_id);
	}
	return cc_credentials_accounts_model_column_record_type_id__volatile;
}


static void cc_credentials_accounts_model_class_init (CcCredentialsAccountsModelClass * klass) {
	cc_credentials_accounts_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CcCredentialsAccountsModelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_cc_credentials_accounts_model_get_property;
	G_OBJECT_CLASS (klass)->finalize = cc_credentials_accounts_model_finalize;
	/**
	     * The account manager.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_ACCOUNTS_MODEL_MANAGER, g_param_spec_object ("manager", "manager", "manager", ag_manager_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The Webcredentials interface used to report account authentication
	     * failures.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_ACCOUNTS_MODEL_WEBCREDENTIALS_INTERFACE, g_param_spec_object ("webcredentials-interface", "webcredentials-interface", "webcredentials-interface", CC_TYPE_WEBCREDENTIALS_INDICATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void cc_credentials_accounts_model_instance_init (CcCredentialsAccountsModel * self) {
	self->priv = CC_CREDENTIALS_ACCOUNTS_MODEL_GET_PRIVATE (self);
}


static void cc_credentials_accounts_model_finalize (GObject* obj) {
	CcCredentialsAccountsModel * self;
	self = CC_CREDENTIALS_ACCOUNTS_MODEL (obj);
	_g_object_unref0 (self->priv->accounts_manager);
	self->priv->past_failures = (g_free (self->priv->past_failures), NULL);
	_g_object_unref0 (self->priv->indicator);
	G_OBJECT_CLASS (cc_credentials_accounts_model_parent_class)->finalize (obj);
}


/**
 * Web credentials accounts Gtk.ListStore. Used as a model for the accounts
 * stored by libaccounts-glib.
 */
GType cc_credentials_accounts_model_get_type (void) {
	static volatile gsize cc_credentials_accounts_model_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_accounts_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CcCredentialsAccountsModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cc_credentials_accounts_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CcCredentialsAccountsModel), 0, (GInstanceInitFunc) cc_credentials_accounts_model_instance_init, NULL };
		GType cc_credentials_accounts_model_type_id;
		cc_credentials_accounts_model_type_id = g_type_register_static (GTK_TYPE_LIST_STORE, "CcCredentialsAccountsModel", &g_define_type_info, 0);
		g_once_init_leave (&cc_credentials_accounts_model_type_id__volatile, cc_credentials_accounts_model_type_id);
	}
	return cc_credentials_accounts_model_type_id__volatile;
}


static void _vala_cc_credentials_accounts_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CcCredentialsAccountsModel * self;
	self = CC_CREDENTIALS_ACCOUNTS_MODEL (object);
	switch (property_id) {
		case CC_CREDENTIALS_ACCOUNTS_MODEL_MANAGER:
		g_value_set_object (value, cc_credentials_accounts_model_get_manager (self));
		break;
		case CC_CREDENTIALS_ACCOUNTS_MODEL_WEBCREDENTIALS_INTERFACE:
		g_value_set_object (value, cc_credentials_accounts_model_get_webcredentials_interface (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



