/* cc-credentials-providers-page.c generated by valac 0.16.1, the Vala compiler
 * generated from cc-credentials-providers-page.vala, do not modify */

/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      David King <david.king@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libaccounts-glib/accounts-glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define CC_CREDENTIALS_TYPE_PROVIDERS_PAGE (cc_credentials_providers_page_get_type ())
#define CC_CREDENTIALS_PROVIDERS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE, CcCredentialsProvidersPage))
#define CC_CREDENTIALS_PROVIDERS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE, CcCredentialsProvidersPageClass))
#define CC_CREDENTIALS_IS_PROVIDERS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE))
#define CC_CREDENTIALS_IS_PROVIDERS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE))
#define CC_CREDENTIALS_PROVIDERS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE, CcCredentialsProvidersPageClass))

typedef struct _CcCredentialsProvidersPage CcCredentialsProvidersPage;
typedef struct _CcCredentialsProvidersPageClass CcCredentialsProvidersPageClass;
typedef struct _CcCredentialsProvidersPagePrivate CcCredentialsProvidersPagePrivate;

#define CC_CREDENTIALS_PROVIDERS_PAGE_TYPE_NOTEBOOK_PAGE (cc_credentials_providers_page_notebook_page_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CC_CREDENTIALS_TYPE_APPLICATIONS_MODEL (cc_credentials_applications_model_get_type ())
#define CC_CREDENTIALS_APPLICATIONS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_APPLICATIONS_MODEL, CcCredentialsApplicationsModel))
#define CC_CREDENTIALS_APPLICATIONS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_APPLICATIONS_MODEL, CcCredentialsApplicationsModelClass))
#define CC_CREDENTIALS_IS_APPLICATIONS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_APPLICATIONS_MODEL))
#define CC_CREDENTIALS_IS_APPLICATIONS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_APPLICATIONS_MODEL))
#define CC_CREDENTIALS_APPLICATIONS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_APPLICATIONS_MODEL, CcCredentialsApplicationsModelClass))

typedef struct _CcCredentialsApplicationsModel CcCredentialsApplicationsModel;
typedef struct _CcCredentialsApplicationsModelClass CcCredentialsApplicationsModelClass;

#define CC_CREDENTIALS_APPLICATIONS_MODEL_TYPE_MODEL_COLUMNS (cc_credentials_applications_model_model_columns_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CC_CREDENTIALS_TYPE_PROVIDERS_MODEL (cc_credentials_providers_model_get_type ())
#define CC_CREDENTIALS_PROVIDERS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL, CcCredentialsProvidersModel))
#define CC_CREDENTIALS_PROVIDERS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL, CcCredentialsProvidersModelClass))
#define CC_CREDENTIALS_IS_PROVIDERS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL))
#define CC_CREDENTIALS_IS_PROVIDERS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL))
#define CC_CREDENTIALS_PROVIDERS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL, CcCredentialsProvidersModelClass))

typedef struct _CcCredentialsProvidersModel CcCredentialsProvidersModel;
typedef struct _CcCredentialsProvidersModelClass CcCredentialsProvidersModelClass;

#define CC_CREDENTIALS_PROVIDERS_MODEL_TYPE_MODEL_COLUMNS (cc_credentials_providers_model_model_columns_get_type ())

struct _CcCredentialsProvidersPage {
	GtkGrid parent_instance;
	CcCredentialsProvidersPagePrivate * priv;
};

struct _CcCredentialsProvidersPageClass {
	GtkGridClass parent_class;
};

struct _CcCredentialsProvidersPagePrivate {
	AgManager* manager;
	GtkComboBox* applications_combo;
	GtkNotebook* providers_notebook;
	GtkTreeModelFilter* filter_model;
	gchar* current_application;
	gchar* _application_id;
};

typedef enum  {
	CC_CREDENTIALS_PROVIDERS_PAGE_NOTEBOOK_PAGE_TREE = 0,
	CC_CREDENTIALS_PROVIDERS_PAGE_NOTEBOOK_PAGE_LABEL = 1
} CcCredentialsProvidersPageNotebookPage;

typedef enum  {
	CC_CREDENTIALS_APPLICATIONS_MODEL_MODEL_COLUMNS_APPLICATION_NAME = 0,
	CC_CREDENTIALS_APPLICATIONS_MODEL_MODEL_COLUMNS_APPLICATION_DESCRIPTION = 1
} CcCredentialsApplicationsModelModelColumns;

typedef enum  {
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_NAME = 0,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_ICON = 1,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_DESCRIPTION = 2,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_NAME = 3,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_ICON = 4,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_DESCRIPTION = 5,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_TOOLTIP = 6,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_ROW_SORT = 7
} CcCredentialsProvidersModelModelColumns;


static gpointer cc_credentials_providers_page_parent_class = NULL;

GType cc_credentials_providers_page_get_type (void) G_GNUC_CONST;
#define CC_CREDENTIALS_PROVIDERS_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE, CcCredentialsProvidersPagePrivate))
enum  {
	CC_CREDENTIALS_PROVIDERS_PAGE_DUMMY_PROPERTY,
	CC_CREDENTIALS_PROVIDERS_PAGE_APPLICATION_ID
};
static GType cc_credentials_providers_page_notebook_page_get_type (void) G_GNUC_UNUSED;
CcCredentialsProvidersPage* cc_credentials_providers_page_new (void);
CcCredentialsProvidersPage* cc_credentials_providers_page_construct (GType object_type);
CcCredentialsProvidersPage* cc_credentials_providers_page_new_with_application (const gchar* application);
CcCredentialsProvidersPage* cc_credentials_providers_page_construct_with_application (GType object_type, const gchar* application);
static GtkWidget* cc_credentials_providers_page_create_providers_infobar (CcCredentialsProvidersPage* self);
CcCredentialsApplicationsModel* cc_credentials_applications_model_new (void);
CcCredentialsApplicationsModel* cc_credentials_applications_model_construct (GType object_type);
GType cc_credentials_applications_model_get_type (void) G_GNUC_CONST;
GType cc_credentials_applications_model_model_columns_get_type (void) G_GNUC_CONST;
static void cc_credentials_providers_page_on_applications_combo_changed (CcCredentialsProvidersPage* self, GtkComboBox* applications_combo);
static void _cc_credentials_providers_page_on_applications_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static GtkWidget* cc_credentials_providers_page_create_providers_notebook (CcCredentialsProvidersPage* self);
static GtkWidget* cc_credentials_providers_page_create_providers_tree (CcCredentialsProvidersPage* self);
CcCredentialsProvidersModel* cc_credentials_providers_model_new (void);
CcCredentialsProvidersModel* cc_credentials_providers_model_construct (GType object_type);
GType cc_credentials_providers_model_get_type (void) G_GNUC_CONST;
static gboolean cc_credentials_providers_page_filter_model_visible (CcCredentialsProvidersPage* self, GtkTreeModel* model, GtkTreeIter* iter);
static gboolean _cc_credentials_providers_page_filter_model_visible_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
GType cc_credentials_providers_model_model_columns_get_type (void) G_GNUC_CONST;
static gboolean cc_credentials_providers_page_on_providers_tree_button_press_event (CcCredentialsProvidersPage* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _cc_credentials_providers_page_on_providers_tree_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void cc_credentials_providers_page_on_providers_tree_row_activated (CcCredentialsProvidersPage* self, GtkTreeView* tree_view, GtkTreePath* path, GtkTreeViewColumn* column);
static void _cc_credentials_providers_page_on_providers_tree_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void cc_credentials_providers_page_update_notebook_widget (CcCredentialsProvidersPage* self, gint n_items);
static void cc_credentials_providers_page_add_account_for_current_selection (CcCredentialsProvidersPage* self, GtkTreeView* providers_tree);
const gchar* cc_credentials_providers_page_get_application_id (CcCredentialsProvidersPage* self);
static void cc_credentials_providers_page_set_application_id (CcCredentialsProvidersPage* self, const gchar* value);
static GObject * cc_credentials_providers_page_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
gboolean cc_credentials_applications_model_find_iter_for_application (CcCredentialsApplicationsModel* self, const gchar* application, GtkTreeIter* iter);
static void cc_credentials_providers_page_finalize (GObject* obj);
static void _vala_cc_credentials_providers_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_cc_credentials_providers_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Select the desired page of @link providers_notebook to select a provider
     * tree view or label describing no applications for this provider.
     *
     * @param TREE show the tree view of providers for this application
     * @param LABEL show the label explaining the lack of available
     * applications
     */
static GType cc_credentials_providers_page_notebook_page_get_type (void) {
	static volatile gsize cc_credentials_providers_page_notebook_page_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_providers_page_notebook_page_type_id__volatile)) {
		static const GEnumValue values[] = {{CC_CREDENTIALS_PROVIDERS_PAGE_NOTEBOOK_PAGE_TREE, "CC_CREDENTIALS_PROVIDERS_PAGE_NOTEBOOK_PAGE_TREE", "tree"}, {CC_CREDENTIALS_PROVIDERS_PAGE_NOTEBOOK_PAGE_LABEL, "CC_CREDENTIALS_PROVIDERS_PAGE_NOTEBOOK_PAGE_LABEL", "label"}, {0, NULL, NULL}};
		GType cc_credentials_providers_page_notebook_page_type_id;
		cc_credentials_providers_page_notebook_page_type_id = g_enum_register_static ("CcCredentialsProvidersPageNotebookPage", values);
		g_once_init_leave (&cc_credentials_providers_page_notebook_page_type_id__volatile, cc_credentials_providers_page_notebook_page_type_id);
	}
	return cc_credentials_providers_page_notebook_page_type_id__volatile;
}


CcCredentialsProvidersPage* cc_credentials_providers_page_construct (GType object_type) {
	CcCredentialsProvidersPage * self = NULL;
	self = (CcCredentialsProvidersPage*) g_object_new (object_type, NULL);
	return self;
}


CcCredentialsProvidersPage* cc_credentials_providers_page_new (void) {
	return cc_credentials_providers_page_construct (CC_CREDENTIALS_TYPE_PROVIDERS_PAGE);
}


CcCredentialsProvidersPage* cc_credentials_providers_page_construct_with_application (GType object_type, const gchar* application) {
	CcCredentialsProvidersPage * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (application != NULL, NULL);
	_tmp0_ = application;
	self = (CcCredentialsProvidersPage*) g_object_new (object_type, "application-id", _tmp0_, NULL);
	return self;
}


CcCredentialsProvidersPage* cc_credentials_providers_page_new_with_application (const gchar* application) {
	return cc_credentials_providers_page_construct_with_application (CC_CREDENTIALS_TYPE_PROVIDERS_PAGE, application);
}


/**
     * Create the infobar which describes the treeview of account providers.
     *
     * @return a Gtk.InfoBar describing the account providers
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _cc_credentials_providers_page_on_applications_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	cc_credentials_providers_page_on_applications_combo_changed (self, _sender);
}


static GtkWidget* cc_credentials_providers_page_create_providers_infobar (CcCredentialsProvidersPage* self) {
	GtkWidget* result = NULL;
	GtkInfoBar* _tmp0_;
	GtkInfoBar* _tmp1_;
	GtkInfoBar* infobar;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* label;
	CcCredentialsApplicationsModel* _tmp5_;
	CcCredentialsApplicationsModel* applications_model;
	GtkComboBox* _tmp6_;
	GtkComboBox* _tmp7_;
	GtkComboBox* _tmp8_;
	GtkCellRendererText* _tmp9_;
	GtkCellRendererText* _tmp10_;
	GtkCellRendererText* text_renderer;
	GtkComboBox* _tmp11_;
	GtkComboBox* _tmp12_;
	GtkGrid* _tmp13_;
	GtkGrid* _tmp14_;
	GtkGrid* infobar_grid;
	GtkComboBox* _tmp15_;
	GtkWidget* _tmp16_ = NULL;
	GtkContainer* _tmp17_;
	GtkContainer* content_area;
	GtkComboBox* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkInfoBar*) gtk_info_bar_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	infobar = _tmp1_;
	gtk_info_bar_set_message_type (infobar, GTK_MESSAGE_QUESTION);
	gtk_widget_set_name ((GtkWidget*) infobar, "providers-infobar");
	_tmp2_ = _ ("Show accounts that integrate with:");
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	label = _tmp4_;
	_tmp5_ = cc_credentials_applications_model_new ();
	applications_model = _tmp5_;
	_tmp6_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) applications_model);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->applications_combo);
	self->priv->applications_combo = _tmp7_;
	_tmp8_ = self->priv->applications_combo;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	text_renderer = _tmp10_;
	_tmp11_ = self->priv->applications_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp11_, (GtkCellRenderer*) text_renderer, FALSE);
	_tmp12_ = self->priv->applications_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) text_renderer, "markup", CC_CREDENTIALS_APPLICATIONS_MODEL_MODEL_COLUMNS_APPLICATION_DESCRIPTION, NULL);
	_tmp13_ = (GtkGrid*) gtk_grid_new ();
	_tmp14_ = g_object_ref_sink (_tmp13_);
	infobar_grid = _tmp14_;
	gtk_grid_set_column_spacing (infobar_grid, 6);
	gtk_container_add ((GtkContainer*) infobar_grid, (GtkWidget*) label);
	_tmp15_ = self->priv->applications_combo;
	gtk_container_add ((GtkContainer*) infobar_grid, (GtkWidget*) _tmp15_);
	_tmp16_ = gtk_info_bar_get_content_area (infobar);
	_tmp17_ = _g_object_ref0 (GTK_IS_CONTAINER (_tmp16_) ? ((GtkContainer*) _tmp16_) : NULL);
	content_area = _tmp17_;
	gtk_container_add (content_area, (GtkWidget*) infobar_grid);
	_tmp18_ = self->priv->applications_combo;
	g_signal_connect_object (_tmp18_, "changed", (GCallback) _cc_credentials_providers_page_on_applications_combo_changed_gtk_combo_box_changed, self, 0);
	{
		GtkCssProvider* _tmp19_;
		GtkCssProvider* css;
		GtkStyleContext* _tmp20_ = NULL;
		GtkStyleContext* _tmp21_;
		GtkStyleContext* context;
		GtkStyleContext* _tmp22_;
		_tmp19_ = gtk_css_provider_new ();
		css = _tmp19_;
		gtk_css_provider_load_from_data (css, "@define-color question_bg_color rgb (222, 222, 222); GtkInfoBar#provid" \
"ers-infobar { color: @fg_color; -GtkInfoBar-action-area-border: 0 }", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (css);
			goto __catch14_g_error;
		}
		_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) infobar);
		_tmp21_ = _g_object_ref0 (_tmp20_);
		context = _tmp21_;
		_tmp22_ = context;
		gtk_style_context_add_provider (_tmp22_, (GtkStyleProvider*) css, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (context);
		_g_object_unref0 (css);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* err = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = err;
		_tmp24_ = _tmp23_->message;
		g_warning ("cc-credentials-providers-page.vala:143: Error processing CSS theme ove" \
"rride: %s", _tmp24_);
		_g_error_free0 (err);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (content_area);
		_g_object_unref0 (infobar_grid);
		_g_object_unref0 (text_renderer);
		_g_object_unref0 (applications_model);
		_g_object_unref0 (label);
		_g_object_unref0 (infobar);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	gtk_widget_set_size_request ((GtkWidget*) infobar, -1, 48);
	gtk_widget_show_all ((GtkWidget*) infobar);
	result = (GtkWidget*) infobar;
	_g_object_unref0 (content_area);
	_g_object_unref0 (infobar_grid);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (applications_model);
	_g_object_unref0 (label);
	return result;
}


/**
     * Create the notebook for holding the provider treeview or a label.
     *
     * @return a Gtk.Notebook
     */
static GtkWidget* cc_credentials_providers_page_create_providers_notebook (CcCredentialsProvidersPage* self) {
	GtkWidget* result = NULL;
	GtkNotebook* _tmp0_;
	GtkNotebook* _tmp1_;
	GtkNotebook* _tmp2_;
	GtkNotebook* _tmp3_;
	GtkNotebook* _tmp4_;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_;
	const gchar* _tmp7_ = NULL;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* no_applications_label;
	GtkNotebook* _tmp10_;
	GtkNotebook* _tmp11_;
	GtkNotebook* _tmp12_;
	GtkWidget* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkNotebook*) gtk_notebook_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->providers_notebook);
	self->priv->providers_notebook = _tmp1_;
	_tmp2_ = self->priv->providers_notebook;
	gtk_notebook_set_show_border (_tmp2_, FALSE);
	_tmp3_ = self->priv->providers_notebook;
	gtk_notebook_set_show_tabs (_tmp3_, FALSE);
	_tmp4_ = self->priv->providers_notebook;
	_tmp5_ = cc_credentials_providers_page_create_providers_tree (self);
	_tmp6_ = _tmp5_;
	gtk_notebook_append_page (_tmp4_, _tmp6_, NULL);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = _ ("There are currently no account providers available which integrate wit" \
"h this application");
	_tmp8_ = (GtkLabel*) gtk_label_new (_tmp7_);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	no_applications_label = _tmp9_;
	g_object_set (no_applications_label, "wrap", TRUE, NULL);
	_tmp10_ = self->priv->providers_notebook;
	gtk_notebook_append_page (_tmp10_, (GtkWidget*) no_applications_label, NULL);
	_tmp11_ = self->priv->providers_notebook;
	gtk_widget_show_all ((GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->providers_notebook;
	_tmp13_ = _g_object_ref0 ((GtkWidget*) _tmp12_);
	result = _tmp13_;
	_g_object_unref0 (no_applications_label);
	return result;
}


/**
     * Create the treeview of account providers, for setting up a new account.
     *
     * @return a Gtk.ScrolledWindow containing the account provider treeview
     */
static gboolean _cc_credentials_providers_page_filter_model_visible_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = cc_credentials_providers_page_filter_model_visible (self, model, iter);
	return result;
}


static gboolean _cc_credentials_providers_page_on_providers_tree_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = cc_credentials_providers_page_on_providers_tree_button_press_event (self, _sender, event);
	return result;
}


static void _cc_credentials_providers_page_on_providers_tree_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	cc_credentials_providers_page_on_providers_tree_row_activated (self, _sender, path, column);
}


static GtkWidget* cc_credentials_providers_page_create_providers_tree (CcCredentialsProvidersPage* self) {
	GtkWidget* result = NULL;
	CcCredentialsProvidersModel* _tmp0_;
	CcCredentialsProvidersModel* providers_model;
	GtkTreeModelFilter* _tmp1_;
	GtkTreeModelFilter* _tmp2_;
	GtkTreeModelFilter* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* providers_tree;
	GtkCellRendererPixbuf* _tmp6_;
	GtkCellRendererPixbuf* _tmp7_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp8_;
	GtkCellRendererText* _tmp9_;
	GtkCellRendererText* text_renderer;
	GtkTreeViewColumn* _tmp10_;
	GtkTreeViewColumn* _tmp11_;
	GtkTreeViewColumn* providers_tree_column;
	GtkScrolledWindow* _tmp12_;
	GtkScrolledWindow* _tmp13_;
	GtkScrolledWindow* scrolled_window;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cc_credentials_providers_model_new ();
	providers_model = _tmp0_;
	_tmp1_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) providers_model, NULL);
	_g_object_unref0 (self->priv->filter_model);
	self->priv->filter_model = _tmp1_;
	_tmp2_ = self->priv->filter_model;
	gtk_tree_model_filter_set_visible_func (_tmp2_, _cc_credentials_providers_page_filter_model_visible_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	_tmp3_ = self->priv->filter_model;
	_tmp4_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp3_);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	providers_tree = _tmp5_;
	gtk_tree_view_set_headers_visible (providers_tree, FALSE);
	gtk_tree_view_set_hover_selection (providers_tree, TRUE);
	gtk_tree_view_set_tooltip_column (providers_tree, (gint) CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_TOOLTIP);
	_tmp6_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	pixbuf_renderer = _tmp7_;
	g_object_set (pixbuf_renderer, "stock-size", (guint) GTK_ICON_SIZE_DND, NULL);
	gtk_cell_renderer_set_padding ((GtkCellRenderer*) pixbuf_renderer, 8, 8);
	_tmp8_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp9_ = g_object_ref_sink (_tmp8_);
	text_renderer = _tmp9_;
	_tmp10_ = gtk_tree_view_column_new ();
	_tmp11_ = g_object_ref_sink (_tmp10_);
	providers_tree_column = _tmp11_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) providers_tree_column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) providers_tree_column, (GtkCellRenderer*) pixbuf_renderer, "gicon", (gint) CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_ICON);
	gtk_cell_layout_pack_start ((GtkCellLayout*) providers_tree_column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) providers_tree_column, (GtkCellRenderer*) text_renderer, "markup", (gint) CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_DESCRIPTION);
	gtk_tree_view_append_column (providers_tree, providers_tree_column);
	_tmp12_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_tmp13_ = g_object_ref_sink (_tmp12_);
	scrolled_window = _tmp13_;
	gtk_scrolled_window_set_min_content_height (scrolled_window, 250);
	gtk_scrolled_window_set_min_content_width (scrolled_window, 400);
	g_object_set ((GtkWidget*) scrolled_window, "expand", TRUE, NULL);
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_ETCHED_IN);
	gtk_container_add ((GtkContainer*) scrolled_window, (GtkWidget*) providers_tree);
	g_signal_connect_object ((GtkWidget*) providers_tree, "button-press-event", (GCallback) _cc_credentials_providers_page_on_providers_tree_button_press_event_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object (providers_tree, "row-activated", (GCallback) _cc_credentials_providers_page_on_providers_tree_row_activated_gtk_tree_view_row_activated, self, 0);
	gtk_widget_show_all ((GtkWidget*) scrolled_window);
	result = (GtkWidget*) scrolled_window;
	_g_object_unref0 (providers_tree_column);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (providers_tree);
	_g_object_unref0 (providers_model);
	return result;
}


/**
     * Visible filter function for the filter tree model of applications.
     *
     * @param model the child tree model to filter
     * @param iter the iter to query data from
     */
static gboolean cc_credentials_providers_page_filter_model_visible (CcCredentialsProvidersPage* self, GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	gchar* application_name = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, CC_CREDENTIALS_APPLICATIONS_MODEL_MODEL_COLUMNS_APPLICATION_NAME, &application_name, -1, -1);
	_tmp2_ = self->priv->current_application;
	result = g_strcmp0 (application_name, _tmp2_) == 0;
	_g_free0 (application_name);
	return result;
}


/**
     * Handle the application combo box selection being changed, by updating
     * the current application being filtered by the filter model.
     *
     * @param applications_combo the combo box for selecting from a list of
     * applications
     */
static void cc_credentials_providers_page_on_applications_combo_changed (CcCredentialsProvidersPage* self, GtkComboBox* applications_combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (applications_combo != NULL);
	_tmp0_ = applications_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gchar* application_name = NULL;
		GtkComboBox* _tmp3_;
		GtkTreeModel* _tmp4_;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* _tmp6_;
		GtkTreeModel* model;
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		GtkTreeModelFilter* _tmp11_;
		GtkTreeModelFilter* _tmp12_;
		gint _tmp13_ = 0;
		gint n_items;
		gint _tmp14_;
		_tmp3_ = applications_combo;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		model = _tmp6_;
		_tmp7_ = model;
		_tmp8_ = iter;
		gtk_tree_model_get (_tmp7_, &_tmp8_, CC_CREDENTIALS_APPLICATIONS_MODEL_MODEL_COLUMNS_APPLICATION_NAME, &application_name, -1, -1);
		_tmp9_ = application_name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->priv->current_application);
		self->priv->current_application = _tmp10_;
		_tmp11_ = self->priv->filter_model;
		gtk_tree_model_filter_refilter (_tmp11_);
		_tmp12_ = self->priv->filter_model;
		_tmp13_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp12_, NULL);
		n_items = _tmp13_;
		_tmp14_ = n_items;
		cc_credentials_providers_page_update_notebook_widget (self, _tmp14_);
		_g_object_unref0 (model);
		_g_free0 (application_name);
	}
}


/**
     * Use the current selection (either with the pointer or keyboard
     * navigation) to select a provider for which to create a new account.
     *
     * @param providers_tree the treeview from which to get the current
     * selection
     */
static void cc_credentials_providers_page_add_account_for_current_selection (CcCredentialsProvidersPage* self, GtkTreeView* providers_tree) {
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkTreeModel* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (providers_tree != NULL);
	_tmp0_ = providers_tree;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp6_ = gtk_tree_selection_get_selected (_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (model);
	_tmp7_ = _g_object_ref0 (_tmp4_);
	model = _tmp7_;
	iter = _tmp5_;
	if (_tmp6_) {
		gchar* provider_name = NULL;
		GtkTreeModel* _tmp8_;
		GtkTreeIter _tmp9_;
		GtkTreeSelection* _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = model;
		_tmp9_ = iter;
		gtk_tree_model_get (_tmp8_, &_tmp9_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_NAME, &provider_name, -1, -1);
		_tmp10_ = selection;
		gtk_tree_selection_unselect_all (_tmp10_);
		_tmp11_ = provider_name;
		g_signal_emit_by_name (self, "new-account-request", _tmp11_);
		_g_free0 (provider_name);
	}
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


/**
     * Update which widget the providers notebook is showing, based on the
     * number of items in the filter model.
     *
     * @param n_items the number of items shown in the providers tree view,
     * from the filter model
     */
static void cc_credentials_providers_page_update_notebook_widget (CcCredentialsProvidersPage* self, gint n_items) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = n_items;
	if (_tmp0_ > 0) {
		GtkNotebook* _tmp1_;
		_tmp1_ = self->priv->providers_notebook;
		gtk_notebook_set_current_page (_tmp1_, (gint) CC_CREDENTIALS_PROVIDERS_PAGE_NOTEBOOK_PAGE_TREE);
	} else {
		GtkNotebook* _tmp2_;
		_tmp2_ = self->priv->providers_notebook;
		gtk_notebook_set_current_page (_tmp2_, (gint) CC_CREDENTIALS_PROVIDERS_PAGE_NOTEBOOK_PAGE_LABEL);
	}
}


/**
     * Check which row the pointer was clicked over, and create a new account
     * for the associated provider.
     *
     * @param widget the widget (providers_tree) that generated the event
     * @param event the button press event
     * @return true if the event was handled, false if the event should be
     * propagated
     */
static gboolean cc_credentials_providers_page_on_providers_tree_button_press_event (CcCredentialsProvidersPage* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_;
	guint _tmp2_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.button;
	if (_tmp2_ == ((guint) 1)) {
		GdkEventButton _tmp3_;
		GdkEventType _tmp4_;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.type;
		_tmp0_ = _tmp4_ == GDK_BUTTON_PRESS;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GtkWidget* _tmp6_;
		_tmp6_ = widget;
		cc_credentials_providers_page_add_account_for_current_selection (self, GTK_IS_TREE_VIEW (_tmp6_) ? ((GtkTreeView*) _tmp6_) : NULL);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
     * Make activations (with the keyboard, presumably) act the same as
     * single-clicking on a row.
     *
     * @param tree_view the tree view which had a row activated
     * @param path the path of the activated row (unused)
     * @param column the column for the activated row (unused)
     */
static void cc_credentials_providers_page_on_providers_tree_row_activated (CcCredentialsProvidersPage* self, GtkTreeView* tree_view, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_view != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = tree_view;
	cc_credentials_providers_page_add_account_for_current_selection (self, _tmp0_);
}


const gchar* cc_credentials_providers_page_get_application_id (CcCredentialsProvidersPage* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application_id;
	result = _tmp0_;
	return result;
}


static void cc_credentials_providers_page_set_application_id (CcCredentialsProvidersPage* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_application_id);
	self->priv->_application_id = _tmp1_;
	g_object_notify ((GObject *) self, "application-id");
}


static GObject * cc_credentials_providers_page_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CcCredentialsProvidersPage * self;
	AgManager* _tmp0_;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_;
	GtkComboBox* _tmp5_;
	const gchar* _tmp6_;
	parent_class = G_OBJECT_CLASS (cc_credentials_providers_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CC_CREDENTIALS_PROVIDERS_PAGE (obj);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	_tmp0_ = ag_manager_new ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp0_;
	_tmp1_ = cc_credentials_providers_page_create_providers_infobar (self);
	_tmp2_ = _tmp1_;
	gtk_container_add ((GtkContainer*) self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = cc_credentials_providers_page_create_providers_notebook (self);
	_tmp4_ = _tmp3_;
	gtk_container_add ((GtkContainer*) self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->applications_combo;
	gtk_combo_box_set_active (_tmp5_, 0);
	_tmp6_ = self->priv->_application_id;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GtkTreeIter iter = {0};
		GtkComboBox* _tmp9_;
		GtkTreeModel* _tmp10_;
		GtkTreeModel* _tmp11_;
		CcCredentialsApplicationsModel* _tmp12_;
		CcCredentialsApplicationsModel* applications_model;
		CcCredentialsApplicationsModel* _tmp13_;
		const gchar* _tmp14_;
		GtkTreeIter _tmp15_ = {0};
		gboolean _tmp16_ = FALSE;
		_tmp7_ = self->priv->_application_id;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->priv->current_application);
		self->priv->current_application = _tmp8_;
		_tmp9_ = self->priv->applications_combo;
		_tmp10_ = gtk_combo_box_get_model (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _g_object_ref0 (CC_CREDENTIALS_IS_APPLICATIONS_MODEL (_tmp11_) ? ((CcCredentialsApplicationsModel*) _tmp11_) : NULL);
		applications_model = _tmp12_;
		_tmp13_ = applications_model;
		_tmp14_ = self->priv->_application_id;
		_tmp16_ = cc_credentials_applications_model_find_iter_for_application (_tmp13_, _tmp14_, &_tmp15_);
		iter = _tmp15_;
		if (_tmp16_) {
			GtkComboBox* _tmp17_;
			GtkTreeIter _tmp18_;
			_tmp17_ = self->priv->applications_combo;
			_tmp18_ = iter;
			gtk_combo_box_set_active_iter (_tmp17_, &_tmp18_);
		} else {
			const gchar* _tmp19_;
			_tmp19_ = self->priv->_application_id;
			g_message ("cc-credentials-providers-page.vala:96: Passed-in application '%s' was " \
"not found", _tmp19_);
		}
		_g_object_unref0 (applications_model);
	}
	gtk_widget_set_size_request ((GtkWidget*) self, -1, 400);
	gtk_widget_show ((GtkWidget*) self);
	return obj;
}


static void cc_credentials_providers_page_class_init (CcCredentialsProvidersPageClass * klass) {
	cc_credentials_providers_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CcCredentialsProvidersPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_cc_credentials_providers_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_cc_credentials_providers_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = cc_credentials_providers_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = cc_credentials_providers_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_PROVIDERS_PAGE_APPLICATION_ID, g_param_spec_string ("application-id", "application-id", "application-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Emitted when a new account should be added.
	     *
	     * @param provider_name the name of the provider for which an account
	     * should be added
	     */
	g_signal_new ("new_account_request", CC_CREDENTIALS_TYPE_PROVIDERS_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void cc_credentials_providers_page_instance_init (CcCredentialsProvidersPage * self) {
	self->priv = CC_CREDENTIALS_PROVIDERS_PAGE_GET_PRIVATE (self);
}


static void cc_credentials_providers_page_finalize (GObject* obj) {
	CcCredentialsProvidersPage * self;
	self = CC_CREDENTIALS_PROVIDERS_PAGE (obj);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->applications_combo);
	_g_object_unref0 (self->priv->providers_notebook);
	_g_object_unref0 (self->priv->filter_model);
	_g_free0 (self->priv->current_application);
	_g_free0 (self->priv->_application_id);
	G_OBJECT_CLASS (cc_credentials_providers_page_parent_class)->finalize (obj);
}


/**
 * Web credentials providers page. This is for selecting an available provider
 * to add a new account for.
 */
GType cc_credentials_providers_page_get_type (void) {
	static volatile gsize cc_credentials_providers_page_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_providers_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CcCredentialsProvidersPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cc_credentials_providers_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CcCredentialsProvidersPage), 0, (GInstanceInitFunc) cc_credentials_providers_page_instance_init, NULL };
		GType cc_credentials_providers_page_type_id;
		cc_credentials_providers_page_type_id = g_type_register_static (GTK_TYPE_GRID, "CcCredentialsProvidersPage", &g_define_type_info, 0);
		g_once_init_leave (&cc_credentials_providers_page_type_id__volatile, cc_credentials_providers_page_type_id);
	}
	return cc_credentials_providers_page_type_id__volatile;
}


static void _vala_cc_credentials_providers_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CcCredentialsProvidersPage * self;
	self = CC_CREDENTIALS_PROVIDERS_PAGE (object);
	switch (property_id) {
		case CC_CREDENTIALS_PROVIDERS_PAGE_APPLICATION_ID:
		g_value_set_string (value, cc_credentials_providers_page_get_application_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_cc_credentials_providers_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CcCredentialsProvidersPage * self;
	self = CC_CREDENTIALS_PROVIDERS_PAGE (object);
	switch (property_id) {
		case CC_CREDENTIALS_PROVIDERS_PAGE_APPLICATION_ID:
		cc_credentials_providers_page_set_application_id (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



