/* test-account-plugin.c generated by valac 0.16.1, the Vala compiler
 * generated from test-account-plugin.vala, do not modify */

/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Alberto Mardegan <alberto.mardegan@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libaccount-plugin/account-plugin.h>
#include <gtk/gtk.h>
#include <libaccounts-glib/accounts-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_TEST_PLUGIN (test_plugin_get_type ())
#define TEST_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_PLUGIN, TestPlugin))
#define TEST_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_PLUGIN, TestPluginClass))
#define IS_TEST_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_PLUGIN))
#define IS_TEST_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_PLUGIN))
#define TEST_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_PLUGIN, TestPluginClass))

typedef struct _TestPlugin TestPlugin;
typedef struct _TestPluginClass TestPluginClass;
typedef struct _TestPluginPrivate TestPluginPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TEST_OAUTH_PLUGIN (test_oauth_plugin_get_type ())
#define TEST_OAUTH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_OAUTH_PLUGIN, TestOAuthPlugin))
#define TEST_OAUTH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_OAUTH_PLUGIN, TestOAuthPluginClass))
#define IS_TEST_OAUTH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_OAUTH_PLUGIN))
#define IS_TEST_OAUTH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_OAUTH_PLUGIN))
#define TEST_OAUTH_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_OAUTH_PLUGIN, TestOAuthPluginClass))

typedef struct _TestOAuthPlugin TestOAuthPlugin;
typedef struct _TestOAuthPluginClass TestOAuthPluginClass;
typedef struct _TestOAuthPluginPrivate TestOAuthPluginPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_TEST_APPLICATION_PLUGIN (test_application_plugin_get_type ())
#define TEST_APPLICATION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_APPLICATION_PLUGIN, TestApplicationPlugin))
#define TEST_APPLICATION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_APPLICATION_PLUGIN, TestApplicationPluginClass))
#define IS_TEST_APPLICATION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_APPLICATION_PLUGIN))
#define IS_TEST_APPLICATION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_APPLICATION_PLUGIN))
#define TEST_APPLICATION_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_APPLICATION_PLUGIN, TestApplicationPluginClass))

typedef struct _TestApplicationPlugin TestApplicationPlugin;
typedef struct _TestApplicationPluginClass TestApplicationPluginClass;
typedef struct _TestApplicationPluginPrivate TestApplicationPluginPrivate;
typedef struct _Block2Data Block2Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_AgAuthData_free0(var) ((var == NULL) ? NULL : (var = (_vala_AgAuthData_free (var), NULL)))
#define __vala_AgService_free0(var) ((var == NULL) ? NULL : (var = (_vala_AgService_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_AgApplication_free0(var) ((var == NULL) ? NULL : (var = (_vala_AgApplication_free (var), NULL)))

struct _TestPlugin {
	ApPlugin parent_instance;
	TestPluginPrivate * priv;
	GtkWidget* widget_to_build;
};

struct _TestPluginClass {
	ApPluginClass parent_class;
};

struct _TestOAuthPlugin {
	ApOAuthPlugin parent_instance;
	TestOAuthPluginPrivate * priv;
};

struct _TestOAuthPluginClass {
	ApOAuthPluginClass parent_class;
};

struct _TestApplicationPlugin {
	ApApplicationPlugin parent_instance;
	TestApplicationPluginPrivate * priv;
	GtkWidget* widget_to_build;
};

struct _TestApplicationPluginClass {
	ApApplicationPluginClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	TestOAuthPlugin* plugin;
	GMainLoop* main_loop;
};


static gpointer test_plugin_parent_class = NULL;
static gpointer test_oauth_plugin_parent_class = NULL;
static gpointer test_application_plugin_parent_class = NULL;

GType test_plugin_get_type (void) G_GNUC_CONST;
enum  {
	TEST_PLUGIN_DUMMY_PROPERTY
};
TestPlugin* test_plugin_new (AgAccount* account);
TestPlugin* test_plugin_construct (GType object_type, AgAccount* account);
static GtkWidget* test_plugin_real_build_widget (ApPlugin* base);
static void test_plugin_finalize (GObject* obj);
GType test_oauth_plugin_get_type (void) G_GNUC_CONST;
enum  {
	TEST_OAUTH_PLUGIN_DUMMY_PROPERTY
};
TestOAuthPlugin* test_oauth_plugin_new (AgAccount* account);
TestOAuthPlugin* test_oauth_plugin_construct (GType object_type, AgAccount* account);
static GObject * test_oauth_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
GType test_application_plugin_get_type (void) G_GNUC_CONST;
enum  {
	TEST_APPLICATION_PLUGIN_DUMMY_PROPERTY
};
TestApplicationPlugin* test_application_plugin_new (AgApplication* application, AgAccount* account);
TestApplicationPlugin* test_application_plugin_construct (GType object_type, AgApplication* application, AgAccount* account);
static GtkWidget* test_application_plugin_real_build_widget (ApApplicationPlugin* base);
static void test_application_plugin_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);
void accountplugin_create (void);
static void _accountplugin_create_gcallback (void);
void accountplugin_create_headless (void);
static void _accountplugin_create_headless_gcallback (void);
void applicationplugin_create (void);
static void _applicationplugin_create_gcallback (void);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_);
static void ___lambda5__ap_plugin_finished (ApPlugin* _sender, gpointer self);
static gboolean __lambda6_ (Block2Data* _data2_);
static gboolean ___lambda6__gsource_func (gpointer self);
static AgService* _vala_AgService_copy (AgService* self);
static gboolean __lambda7_ (Block2Data* _data2_);
static void __lambda8_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean ___lambda7__gsource_func (gpointer self);
static void _vala_AgAuthData_free (AgAuthData* self);
static void _vala_AgService_free (AgService* self);
static void _vala_AgApplication_free (AgApplication* self);


TestPlugin* test_plugin_construct (GType object_type, AgAccount* account) {
	TestPlugin * self = NULL;
	AgAccount* _tmp0_;
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = account;
	self = (TestPlugin*) g_object_new (object_type, "account", _tmp0_, NULL);
	return self;
}


TestPlugin* test_plugin_new (AgAccount* account) {
	return test_plugin_construct (TYPE_TEST_PLUGIN, account);
}


static GtkWidget* test_plugin_real_build_widget (ApPlugin* base) {
	TestPlugin * self;
	GtkWidget* result = NULL;
	GtkWidget* _tmp0_;
	self = (TestPlugin*) base;
	_tmp0_ = self->widget_to_build;
	result = _tmp0_;
	return result;
}


static void test_plugin_class_init (TestPluginClass * klass) {
	test_plugin_parent_class = g_type_class_peek_parent (klass);
	AP_PLUGIN_CLASS (klass)->build_widget = test_plugin_real_build_widget;
	G_OBJECT_CLASS (klass)->finalize = test_plugin_finalize;
}


static void test_plugin_instance_init (TestPlugin * self) {
}


static void test_plugin_finalize (GObject* obj) {
	TestPlugin * self;
	self = TEST_PLUGIN (obj);
	_g_object_unref0 (self->widget_to_build);
	G_OBJECT_CLASS (test_plugin_parent_class)->finalize (obj);
}


GType test_plugin_get_type (void) {
	static volatile gsize test_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&test_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestPlugin), 0, (GInstanceInitFunc) test_plugin_instance_init, NULL };
		GType test_plugin_type_id;
		test_plugin_type_id = g_type_register_static (ap_plugin_get_type (), "TestPlugin", &g_define_type_info, 0);
		g_once_init_leave (&test_plugin_type_id__volatile, test_plugin_type_id);
	}
	return test_plugin_type_id__volatile;
}


TestOAuthPlugin* test_oauth_plugin_construct (GType object_type, AgAccount* account) {
	TestOAuthPlugin * self = NULL;
	AgAccount* _tmp0_;
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = account;
	self = (TestOAuthPlugin*) g_object_new (object_type, "account", _tmp0_, NULL);
	return self;
}


TestOAuthPlugin* test_oauth_plugin_new (AgAccount* account) {
	return test_oauth_plugin_construct (TYPE_TEST_OAUTH_PLUGIN, account);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GObject * test_oauth_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TestOAuthPlugin * self;
	GHashFunc _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* account_oauth_params;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	GValue* _tmp4_ = NULL;
	GHashTable* _tmp5_;
	gchar* _tmp6_;
	GValue* _tmp7_ = NULL;
	GHashTable* _tmp8_;
	GHashFunc _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* oauth_params;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	GValue* _tmp13_ = NULL;
	GHashTable* _tmp14_;
	gchar* _tmp15_;
	GValue* _tmp16_ = NULL;
	GHashTable* _tmp17_;
	parent_class = G_OBJECT_CLASS (test_oauth_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TEST_OAUTH_PLUGIN (obj);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_hash_table_new_full (_tmp0_, NULL, _g_free0_, __vala_GValue_free0_);
	account_oauth_params = _tmp1_;
	_tmp2_ = account_oauth_params;
	_tmp3_ = g_strdup ("long");
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_set_string (_tmp4_, "short");
	g_hash_table_insert (_tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = account_oauth_params;
	_tmp6_ = g_strdup ("wide");
	_tmp7_ = g_new0 (GValue, 1);
	g_value_init (_tmp7_, G_TYPE_STRING);
	g_value_set_string (_tmp7_, "narrow");
	g_hash_table_insert (_tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = account_oauth_params;
	ap_oauth_plugin_set_account_oauth_parameters ((ApOAuthPlugin*) self, _tmp8_);
	_tmp9_ = g_str_hash;
	_tmp10_ = g_hash_table_new_full (_tmp9_, NULL, _g_free0_, __vala_GValue_free0_);
	oauth_params = _tmp10_;
	_tmp11_ = oauth_params;
	_tmp12_ = g_strdup ("long");
	_tmp13_ = g_new0 (GValue, 1);
	g_value_init (_tmp13_, G_TYPE_STRING);
	g_value_set_string (_tmp13_, "not short");
	g_hash_table_insert (_tmp11_, _tmp12_, _tmp13_);
	_tmp14_ = oauth_params;
	_tmp15_ = g_strdup ("wide");
	_tmp16_ = g_new0 (GValue, 1);
	g_value_init (_tmp16_, G_TYPE_STRING);
	g_value_set_string (_tmp16_, "not narrow");
	g_hash_table_insert (_tmp14_, _tmp15_, _tmp16_);
	_tmp17_ = oauth_params;
	ap_oauth_plugin_set_oauth_parameters ((ApOAuthPlugin*) self, _tmp17_);
	_g_hash_table_unref0 (oauth_params);
	_g_hash_table_unref0 (account_oauth_params);
	return obj;
}


static void test_oauth_plugin_class_init (TestOAuthPluginClass * klass) {
	test_oauth_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = test_oauth_plugin_constructor;
}


static void test_oauth_plugin_instance_init (TestOAuthPlugin * self) {
}


GType test_oauth_plugin_get_type (void) {
	static volatile gsize test_oauth_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&test_oauth_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestOAuthPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_oauth_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestOAuthPlugin), 0, (GInstanceInitFunc) test_oauth_plugin_instance_init, NULL };
		GType test_oauth_plugin_type_id;
		test_oauth_plugin_type_id = g_type_register_static (ap_oauth_plugin_get_type (), "TestOAuthPlugin", &g_define_type_info, 0);
		g_once_init_leave (&test_oauth_plugin_type_id__volatile, test_oauth_plugin_type_id);
	}
	return test_oauth_plugin_type_id__volatile;
}


TestApplicationPlugin* test_application_plugin_construct (GType object_type, AgApplication* application, AgAccount* account) {
	TestApplicationPlugin * self = NULL;
	AgAccount* _tmp0_;
	AgApplication* _tmp1_;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = account;
	_tmp1_ = application;
	self = (TestApplicationPlugin*) g_object_new (object_type, "account", _tmp0_, "application", _tmp1_, NULL);
	return self;
}


TestApplicationPlugin* test_application_plugin_new (AgApplication* application, AgAccount* account) {
	return test_application_plugin_construct (TYPE_TEST_APPLICATION_PLUGIN, application, account);
}


static GtkWidget* test_application_plugin_real_build_widget (ApApplicationPlugin* base) {
	TestApplicationPlugin * self;
	GtkWidget* result = NULL;
	GtkWidget* _tmp0_;
	self = (TestApplicationPlugin*) base;
	_tmp0_ = self->widget_to_build;
	result = _tmp0_;
	return result;
}


static void test_application_plugin_class_init (TestApplicationPluginClass * klass) {
	test_application_plugin_parent_class = g_type_class_peek_parent (klass);
	AP_APPLICATION_PLUGIN_CLASS (klass)->build_widget = test_application_plugin_real_build_widget;
	G_OBJECT_CLASS (klass)->finalize = test_application_plugin_finalize;
}


static void test_application_plugin_instance_init (TestApplicationPlugin * self) {
}


static void test_application_plugin_finalize (GObject* obj) {
	TestApplicationPlugin * self;
	self = TEST_APPLICATION_PLUGIN (obj);
	_g_object_unref0 (self->widget_to_build);
	G_OBJECT_CLASS (test_application_plugin_parent_class)->finalize (obj);
}


GType test_application_plugin_get_type (void) {
	static volatile gsize test_application_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&test_application_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestApplicationPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_application_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestApplicationPlugin), 0, (GInstanceInitFunc) test_application_plugin_instance_init, NULL };
		GType test_application_plugin_type_id;
		test_application_plugin_type_id = g_type_register_static (ap_application_plugin_get_type (), "TestApplicationPlugin", &g_define_type_info, 0);
		g_once_init_leave (&test_application_plugin_type_id__volatile, test_application_plugin_type_id);
	}
	return test_application_plugin_type_id__volatile;
}


static void _accountplugin_create_gcallback (void) {
	accountplugin_create ();
}


static void _accountplugin_create_headless_gcallback (void) {
	accountplugin_create_headless ();
}


static void _applicationplugin_create_gcallback (void) {
	applicationplugin_create ();
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gtk_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/libaccount-plugin/plugin/create", _accountplugin_create_gcallback);
	g_test_add_func ("/libaccount-plugin/plugin/create-headless", _accountplugin_create_headless_gcallback);
	g_test_add_func ("/libaccount-plugin/application-plugin/create", _applicationplugin_create_gcallback);
	g_test_run ();
	result = EXIT_SUCCESS;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


void accountplugin_create (void) {
	AgManager* _tmp0_;
	AgManager* manager;
	AgAccount* _tmp1_ = NULL;
	AgAccount* account;
	TestPlugin* _tmp2_;
	TestPlugin* plugin;
	AgAccount* _tmp3_;
	AgAccount* _tmp4_;
	AgAccount* _tmp5_ = NULL;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_ = FALSE;
	GtkLabel* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_ = NULL;
	GtkWidget* _tmp12_;
	_tmp0_ = ag_manager_new ();
	manager = _tmp0_;
	_tmp1_ = ag_manager_create_account (manager, "MyProvider");
	account = _tmp1_;
	_tmp2_ = test_plugin_new (account);
	plugin = _tmp2_;
	_tmp3_ = ap_plugin_get_account ((ApPlugin*) plugin);
	_tmp4_ = _tmp3_;
	g_assert (_tmp4_ == account);
	_tmp5_ = ap_plugin_get_account ((ApPlugin*) plugin);
	g_assert (_tmp5_ == account);
	ap_plugin_set_need_authentication ((ApPlugin*) plugin, TRUE);
	_tmp6_ = ap_plugin_get_need_authentication ((ApPlugin*) plugin);
	_tmp7_ = _tmp6_;
	g_assert (_tmp7_ == TRUE);
	_tmp8_ = ap_plugin_get_need_authentication ((ApPlugin*) plugin);
	g_assert (_tmp8_ == TRUE);
	_tmp9_ = (GtkLabel*) gtk_label_new ("Hello world!");
	_tmp10_ = (GtkWidget*) g_object_ref_sink (_tmp9_);
	_g_object_unref0 (plugin->widget_to_build);
	plugin->widget_to_build = _tmp10_;
	_tmp11_ = ap_plugin_build_widget ((ApPlugin*) plugin);
	_tmp12_ = plugin->widget_to_build;
	g_assert (_tmp11_ == _tmp12_);
	_g_object_unref0 (plugin);
	_g_object_unref0 (account);
	_g_object_unref0 (manager);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_main_loop_unref0 (_data2_->main_loop);
		_g_object_unref0 (_data2_->plugin);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda5_ (Block2Data* _data2_) {
	g_main_loop_quit (_data2_->main_loop);
}


static void ___lambda5__ap_plugin_finished (ApPlugin* _sender, gpointer self) {
	__lambda5_ (self);
}


static gboolean __lambda6_ (Block2Data* _data2_) {
	gboolean result = FALSE;
	ap_plugin_act_headless ((ApPlugin*) _data2_->plugin);
	result = FALSE;
	return result;
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ (self);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static AgService* _vala_AgService_copy (AgService* self) {
	return g_boxed_copy (ag_service_get_type (), self);
}


static gpointer __vala_AgService_copy0 (gpointer self) {
	return self ? _vala_AgService_copy (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void __lambda8_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		ap_plugin_delete_account_finish ((ApPlugin*) _data2_->plugin, _tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp1_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = _error_->message;
		g_critical ("test-account-plugin.vala:154: Error deleting account: %s", _tmp1_);
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_main_loop_quit (_data2_->main_loop);
}


static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda8_ (self, source_object, res);
	block2_data_unref (self);
}


static gboolean __lambda7_ (Block2Data* _data2_) {
	gboolean result = FALSE;
	ap_plugin_delete_account ((ApPlugin*) _data2_->plugin, ___lambda8__gasync_ready_callback, block2_data_ref (_data2_));
	result = FALSE;
	return result;
}


static gboolean ___lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda7_ (self);
	return result;
}


static void _vala_AgAuthData_free (AgAuthData* self) {
	g_boxed_free (ag_auth_data_get_type (), self);
}


static void _vala_AgService_free (AgService* self) {
	g_boxed_free (ag_service_get_type (), self);
}


void accountplugin_create_headless (void) {
	Block2Data* _data2_;
	AgManager* _tmp0_;
	AgManager* manager;
	AgAccount* _tmp1_ = NULL;
	AgAccount* account;
	TestOAuthPlugin* _tmp2_;
	AgAccount* _tmp3_;
	AgAccount* _tmp4_;
	AgAccount* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* test_username;
	GMainLoop* _tmp7_;
	guint _tmp8_ = 0U;
	guint _tmp9_;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	AgService* _tmp12_ = NULL;
	AgService* service;
	AgAccount* _tmp13_;
	AgService* _tmp14_;
	AgAccountService* _tmp15_;
	AgAccountService* account_service;
	AgAuthData* _tmp16_ = NULL;
	AgAuthData* auth_data;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GHashTable* _tmp19_ = NULL;
	GHashTable* _tmp20_;
	GHashTable* parameters;
	gconstpointer _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gconstpointer _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = ag_manager_new ();
	manager = _tmp0_;
	_tmp1_ = ag_manager_create_account (manager, "MyProvider");
	account = _tmp1_;
	_tmp2_ = test_oauth_plugin_new (account);
	_data2_->plugin = _tmp2_;
	_tmp3_ = ap_plugin_get_account ((ApPlugin*) _data2_->plugin);
	_tmp4_ = _tmp3_;
	g_assert (_tmp4_ == account);
	_tmp5_ = ap_plugin_get_account ((ApPlugin*) _data2_->plugin);
	g_assert (_tmp5_ == account);
	_tmp6_ = g_strdup ("Long John Silver");
	test_username = _tmp6_;
	ap_plugin_set_need_authentication ((ApPlugin*) _data2_->plugin, FALSE);
	ap_plugin_set_credentials ((ApPlugin*) _data2_->plugin, test_username, "irrelevant password");
	_tmp7_ = g_main_loop_new (NULL, FALSE);
	_data2_->main_loop = _tmp7_;
	g_signal_connect_data ((ApPlugin*) _data2_->plugin, "finished", (GCallback) ___lambda5__ap_plugin_finished, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	g_main_loop_run (_data2_->main_loop);
	g_object_get (account, "id", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	g_assert (_tmp9_ != ((guint) 0));
	_tmp10_ = ag_account_get_display_name (account);
	g_assert (g_strcmp0 (_tmp10_, test_username) == 0);
	ag_account_select_service (account, NULL);
	_tmp11_ = ag_account_get_enabled (account);
	g_assert (!_tmp11_);
	_tmp12_ = ag_manager_get_service (manager, "MyService");
	service = _tmp12_;
	_tmp13_ = _g_object_ref0 (account);
	_tmp14_ = __vala_AgService_copy0 (service);
	_tmp15_ = ag_account_service_new (_tmp13_, _tmp14_);
	account_service = _tmp15_;
	_tmp16_ = ag_account_service_get_auth_data (account_service);
	auth_data = _tmp16_;
	_tmp17_ = ag_auth_data_get_method (auth_data);
	g_assert (g_strcmp0 (_tmp17_, "oauth2") == 0);
	_tmp18_ = ag_auth_data_get_mechanism (auth_data);
	g_assert (g_strcmp0 (_tmp18_, "user_agent") == 0);
	_tmp19_ = ag_auth_data_get_parameters (auth_data);
	_tmp20_ = _g_hash_table_ref0 (_tmp19_);
	parameters = _tmp20_;
	_tmp21_ = g_hash_table_lookup (parameters, "long");
	_tmp22_ = g_value_get_string ((GValue*) _tmp21_);
	g_assert (g_strcmp0 (_tmp22_, "short") == 0);
	_tmp23_ = g_hash_table_lookup (parameters, "wide");
	_tmp24_ = g_value_get_string ((GValue*) _tmp23_);
	g_assert (g_strcmp0 (_tmp24_, "narrow") == 0);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda7__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	g_main_loop_run (_data2_->main_loop);
	_g_hash_table_unref0 (parameters);
	__vala_AgAuthData_free0 (auth_data);
	_g_object_unref0 (account_service);
	__vala_AgService_free0 (service);
	_g_free0 (test_username);
	_g_object_unref0 (account);
	_g_object_unref0 (manager);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void _vala_AgApplication_free (AgApplication* self) {
	g_boxed_free (ag_application_get_type (), self);
}


void applicationplugin_create (void) {
	AgManager* _tmp0_;
	AgManager* manager;
	AgAccount* _tmp1_ = NULL;
	AgAccount* account;
	AgApplication* _tmp2_ = NULL;
	AgApplication* application;
	TestApplicationPlugin* _tmp3_;
	TestApplicationPlugin* plugin;
	AgAccount* _tmp4_;
	AgAccount* _tmp5_;
	AgAccount* _tmp6_ = NULL;
	AgApplication* _tmp7_;
	AgApplication* _tmp8_;
	AgApplication* _tmp9_ = NULL;
	GtkLabel* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_ = NULL;
	GtkWidget* _tmp13_;
	_tmp0_ = ag_manager_new ();
	manager = _tmp0_;
	_tmp1_ = ag_manager_create_account (manager, "MyProvider");
	account = _tmp1_;
	_tmp2_ = ag_manager_get_application (manager, "Gallery");
	application = _tmp2_;
	g_assert (application != NULL);
	_tmp3_ = test_application_plugin_new (application, account);
	plugin = _tmp3_;
	_tmp4_ = ap_application_plugin_get_account ((ApApplicationPlugin*) plugin);
	_tmp5_ = _tmp4_;
	g_assert (_tmp5_ == account);
	_tmp6_ = ap_application_plugin_get_account ((ApApplicationPlugin*) plugin);
	g_assert (_tmp6_ == account);
	_tmp7_ = ap_application_plugin_get_application ((ApApplicationPlugin*) plugin);
	_tmp8_ = _tmp7_;
	g_assert (_tmp8_ == application);
	_tmp9_ = ap_application_plugin_get_application ((ApApplicationPlugin*) plugin);
	g_assert (_tmp9_ == application);
	_tmp10_ = (GtkLabel*) gtk_label_new ("Hello world!");
	_tmp11_ = (GtkWidget*) g_object_ref_sink (_tmp10_);
	_g_object_unref0 (plugin->widget_to_build);
	plugin->widget_to_build = _tmp11_;
	_tmp12_ = ap_application_plugin_build_widget ((ApApplicationPlugin*) plugin);
	_tmp13_ = plugin->widget_to_build;
	g_assert (_tmp12_ == _tmp13_);
	_g_object_unref0 (plugin);
	__vala_AgApplication_free0 (application);
	_g_object_unref0 (account);
	_g_object_unref0 (manager);
}



