// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEVFSMM_URI_H
#define _LIBGNOMEVFSMM_URI_H


#include <glibmm.h>

/* $Id: uri.hg,v 1.20 2006/10/31 09:06:50 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfsmm/file-info.h>
#include <libgnomevfsmm/enums.h>
#include <libgnomevfsmm/exception.h>
#include <libgnomevfs/gnome-vfs-uri.h>
#include <libgnomevfs/gnome-vfs-ops.h>


namespace Gnome
{

namespace Vfs
{

/** @addtogroup libgnomevfsmmEnums Enums and Flags */

/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%MakeURIDirs operator|(MakeURIDirs, MakeURIDirs)</tt><br>
 * <tt>%MakeURIDirs operator&(MakeURIDirs, MakeURIDirs)</tt><br>
 * <tt>%MakeURIDirs operator^(MakeURIDirs, MakeURIDirs)</tt><br>
 * <tt>%MakeURIDirs operator~(MakeURIDirs)</tt><br>
 * <tt>%MakeURIDirs& operator|=(MakeURIDirs&, MakeURIDirs)</tt><br>
 * <tt>%MakeURIDirs& operator&=(MakeURIDirs&, MakeURIDirs)</tt><br>
 * <tt>%MakeURIDirs& operator^=(MakeURIDirs&, MakeURIDirs)</tt><br>
 */
enum MakeURIDirs
{
  MAKE_URI_DIR_NONE = 0,
  MAKE_URI_DIR_HOMEDIR = 1 << 0,
  MAKE_URI_DIR_CURRENT = 1 << 1
};

/** @ingroup libgnomevfsmmEnums */
inline MakeURIDirs operator|(MakeURIDirs lhs, MakeURIDirs rhs)
  { return static_cast<MakeURIDirs>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline MakeURIDirs operator&(MakeURIDirs lhs, MakeURIDirs rhs)
  { return static_cast<MakeURIDirs>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline MakeURIDirs operator^(MakeURIDirs lhs, MakeURIDirs rhs)
  { return static_cast<MakeURIDirs>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline MakeURIDirs operator~(MakeURIDirs flags)
  { return static_cast<MakeURIDirs>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline MakeURIDirs& operator|=(MakeURIDirs& lhs, MakeURIDirs rhs)
  { return (lhs = static_cast<MakeURIDirs>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline MakeURIDirs& operator&=(MakeURIDirs& lhs, MakeURIDirs rhs)
  { return (lhs = static_cast<MakeURIDirs>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline MakeURIDirs& operator^=(MakeURIDirs& lhs, MakeURIDirs rhs)
  { return (lhs = static_cast<MakeURIDirs>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class Uri
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Uri CppObjectType;
  typedef GnomeVFSURI BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  // For use with Glib::RefPtr<> only.
  void reference()   const;
  void unreference() const;

  ///Provides access to the underlying C instance.
  GnomeVFSURI*       gobj();

  ///Provides access to the underlying C instance.
  const GnomeVFSURI* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GnomeVFSURI* gobj_copy() const;

protected:
  // Do not derive this.  Gnome::Vfs::Uri can neither be constructed nor deleted.
  Uri();
  void operator delete(void*, size_t);

private:
  // noncopyable
  Uri(const Uri&);
  Uri& operator=(const Uri&);


public:

  /** Create a new Uri from the text string @a uri.
   * @param uri A string representing a URI.
   * @return The new Uri.
   */
  static Glib::RefPtr<Uri> create(const Glib::ustring& uri);

  
  /** Create a new Uri from @a relative_reference to this object.
   * @param relative_reference A string representing a possibly relative URI reference.
   * @return The new Uri.
   */
  Glib::RefPtr<Uri> resolve_relative(const Glib::ustring& relative_reference);


  /** Create a new Uri object by appending @a uri_fragment to this Uri object.  
   * This takes care of adding an appropriate directory separator between 
   * the end of the Uri and the start of @a uri_fragment if necessary.
   * @param uri_fragment A piece of a Uri (ie a fully escaped partial path).
   * @return The new Uri obtained by combining this object and @a uri_fragment.
   */
  Glib::RefPtr<Uri> append_string(const Glib::ustring& uri_fragment);
  
  /** Create a new Uri object by appending @a path to this Uri object.  This 
   * takes care of adding an appropriate directory separator between the 
   * end of the Uri and the start of @a path if necessary.
   * @param path A non-escaped file path.
   * @return The new Uri obtained by combining this object and @a path.
   */
  Glib::RefPtr<Uri> append_path(const Glib::ustring& path);
  
  /** Create a new Uri object by appending @a filename to this Uri object.  This 
   * takes care of adding an appropriate directory separator between the end 
   * of the Uri and the start of @a filename if necessary.
   * @param filename Any "regular" file name (can include #, /, etc).
   * @return The new Uri obtained by combining this object and @a filename.
   */
  Glib::RefPtr<Uri> append_file_name(const Glib::ustring& filename);
  
  /** Translate this Uri into a printable string. The string will not contain 
   * the Uri elements specified by @a hide_options.
   * @param hide_options Bitmask specifying what URI elements (e.g. password, user 
   *     name etc.) should NOT be represented in the returned string.
   * @return A Glib::ustring representing this Uri.
   */
  Glib::ustring to_string(URIHideOptions hide_options = URI_HIDE_NONE) const;
  
  /** Duplicate this Uri.
   * @return A Glib::RefPtr to a new Uri that is exactly the same as this object.
   */
  Glib::RefPtr<Uri> dup();
  
  /** Check if this Uri is a local (native) file system.
   * @return <tt>false</tt> if uri is not a local file system, <tt>true</tt> otherwise.
   */
  bool is_local() const;
  
  /** Check if this Uri has a parent or not.
   * @return <tt>true</tt> if this Uri has a parent, <tt>false</tt> otherwise.
   */
  bool has_parent() const;
  
  /** Retrieve this object's parent Uri.
   * @return A Glib::RefPtr to this object's parent Uri.
   */
  Glib::RefPtr<Uri> get_parent();
  
  /** Retrieve this object's parent Uri.
   * @return A Glib::RefPtr to this object's parent Uri.
   */
  Glib::RefPtr<const Uri> get_parent() const;

  //TODO: GnomeVFSToplevelURI inherits from GnomeVFSUri, but they are not GObjects. That needs a little work.  
  //_WRAP_METHOD(GnomeVFSToplevelURI* get_toplevel(), gnome_vfs_uri_get_toplevel)
  //_WRAP_METHOD(const GnomeVFSToplevelURI* get_toplevel() const, gnome_vfs_uri_get_toplevel)

  
  /** Retrieve this object's host name.
   * @return A string representing the host name.
   */
  Glib::ustring get_host_name() const;
  
  /** Retrieve this object's scheme.
   * @return A string representing the scheme.
   */
  Glib::ustring get_scheme() const;
  
  /** Retrieve this object's host port number.
   * @return The host port number used by this object. If the value is zero, the default port value for the specified toplevel access method is used.
   */
  guint get_host_port() const;
  
  /** Retrieve the user name in this object.
   * @return A string representing the user name in this Uri.
   */
  Glib::ustring get_user_name() const;
  
  /** Retrieve the password for this object.
   * @return The password for this Uri.
   */
  Glib::ustring get_password() const;

  
  /** Set @a host_name as the host name accessed by this Uri.
   * @param host_name A string representing a host name.
   */
  void set_host_name(const Glib::ustring& host_name);
  
  /** Set the host port number in this Uri.  If @a host_port is zero, the default port
   * for this object's toplevel access method is used.
   * @param host_port A TCP/IP port number.
   */
  void set_host_port(guint host_port);
  
  /** Set @a user_name as the user name for this Uri.
   * @param user_name A string representing a user name on the host accessed by this object.
   */
  void set_user_name(const Glib::ustring& user_name);
  
  /** Set @a password as the password for this Uri.
   * @param password A password string.
   */
  void set_password(const Glib::ustring& password);

  
  /** Compare @a a and @a b.
   * @param b A GnomeVFSURI.
   * @return <tt>true</tt> if @a a and @a b are equal, <tt>false</tt> otherwise.
   * 
   * FIXME: This comparison should take into account the possiblity
   * that unreserved characters may be escaped.
   * ...or perhaps gnome_vfs_uri_new should unescape unreserved characters?.
   */
  bool equal(const Glib::RefPtr<const Uri>& uri) const;
  //We wrap this as equal() as well, because operator== requires an operator*.
  

  /** Check if @a possible_child is contained by this Uri.
   * If @a recursive is <tt>false</tt>, just try the immediate parent directory, else
   * search up through the hierarchy.
   * @param possible_child A Glib::RefPtr to the Uri to test.
   * @param recursive A flag to turn recursive check on.
   * @return <tt>true</tt> if @a possible_child is contained in this Uri.
   */
  bool is_parent(const Glib::RefPtr<const Uri>& possible_child, bool recursive = true) const;

  
  /** Retrieve full path name for this Uri.
   * @return A string representing the full path of this object.
   */
  Glib::ustring get_path() const;
  
  /** Retrieve the optional fragment identifier for this Uri.
   * @return A string representing the fragment identifier for this Uri, or <tt>0</tt>.
   */
  Glib::ustring get_fragment_identifier() const;
  
  /** Extract the name of the directory in which the file pointed to by this Uri is
   * stored as a new string.  The string will end with a GNOME_VFS_URI_PATH_CHR.
   * @return A string representing the parent directory.
   */
  Glib::ustring extract_dirname() const;
  
  /** Retrieve base file name for this Uri, ignoring any trailing path separators.
   * This matches the XPG definition of basename, but not g_basename. This is
   * often useful when you want the name of something that is pointed to by a
   * Uri, and don't care whether the uri has a directory or file form.
   * If this Uri points to the root of a domain, this method returns the host name; if there's
   * no host name, returns GNOME_VFS_URI_PATH_STR.
   * 
   * See also: extract_short_path_name.
   * @return A string representing the unescaped short form of the name.
   */
  Glib::ustring extract_short_name() const;
  
  /** Retrieve base file name for this Uri, ignoring any trailing path separators.
   * This matches the XPG definition of basename, but not g_basename. This is
   * often useful when you want the name of something that is pointed to by a
   * Uri, and don't care whether the uri has a directory or file form.
   * If this Uri points to the root (including the root of any domain),
   * this method returns GNOME_VFS_URI_PATH_STR.
   * 
   * See also: extract_short_name.
   * @return A string representing the escaped short form of the name.
   */
  Glib::ustring extract_short_path_name() const;

  //These are used for creating hashes for hash tables, apparently.
  //I don't see the point of wrapping them.
  

/*
GList* gnome_vfs_uri_list_parse(const Glib::ustring& uri_list), )
*/

  
  /** Returns a full Uri given a full base URI, and a secondary URI which may
   * be relative.
   * @param base_uri A string representing the base URI.
   * @param relative_uri A URI fragment/reference to be appended to @a base_uri.
   * @return A string containing the URI (<tt>0</tt> for some bad errors).
   */
  static Glib::ustring make_full_from_relative(const Glib::ustring& base_uri, const Glib::ustring& relative_uri);

  
  /** Filter, modify, unescape and change URIs to make them appropriate
   * to display to users. The conversion is done such that the roundtrip
   * to UTF-8 is reversible.
   * 
   * Rules:
   * file: URI's without fragments should appear as local paths
   * file: URI's with fragments should appear as file: URI's
   * All other URI's appear as expected
   * 
   *  @a uri: a URI
   * @return A newly allocated UTF-8 string
   * 
   * @newin2p2.
   */
  static Glib::ustring format_for_display(const Glib::ustring& uri);
  
  /** Takes a user input path/URI and makes a valid URI out of it.
   * 
   * This function is the reverse of gnome_vfs_format_uri_for_display
   * but it also handles the fact that the user could have typed
   * arbitrary UTF8 in the entry showing the string.
   * @param location A possibly mangled "uri", in UTF8.
   * @return A newly allocated uri.
   * 
   * @newin2p2.
   */
  static Glib::ustring make_from_input(const Glib::ustring& uri);
  
  static Glib::ustring make_from_input(const Glib::ustring& uri, MakeURIDirs dirs);
  
  /** If the @a uri passed contains a fragment (anything after a '#') strips if,
   * then makes the URI canonical.
   * @return A newly allocated string containing a canonical URI.
   * 
   * @newin2p2.
   */
  static Glib::ustring make_canonical_strip_fragment(const Glib::ustring& uri);
  
  /** Compare two URIs.
   * @param uri_1 Stringified URI to compare with @a uri_2.
   * @param uri_2 Stringified URI to compare with @a uri_1.
   * @return <tt>true</tt> if they are the same, <tt>false</tt> otherwise.
   * 
   * @newin2p2.
   */
  static bool uris_match(const Glib::ustring& uri_1, const Glib::ustring& uri_2);
  
  /** Retrieve the scheme used in @a uri
   * @param uri A stringified URI.
   * @return A string containing the scheme
   * 
   * @newin2p2.
   */
  static Glib::ustring get_scheme(const Glib::ustring& uri);
  
  /** Similar to gnome_vfs_make_uri_from_input, except that:
   * 
   * 1) guesses relative paths instead of http domains
   * 2) doesn't bother stripping leading/trailing white space
   * 3) doesn't bother with ~ expansion--that's done by the shell
   * @param location A possibly mangled "uri".
   * @return A newly allocated uri
   * 
   * @newin2p2.
   */
  static Glib::ustring make_from_shell_arg(const Glib::ustring& uri);


  /** Retrieve the file info for this Uri.
   * @param options An enum (bitfield) representing what information to retrieve.
   * @return The information for this Uri.
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileInfo> get_file_info(FileInfoOptions options = FILE_INFO_DEFAULT) const throw(exception);
  #else
  Glib::RefPtr<FileInfo> get_file_info(FileInfoOptions options, std::auto_ptr<Gnome::Vfs::exception>& error) const;
  #endif

  /** Creates a symbolic link from this Uri to @a target_reference.
   * @param target_reference URI to point the link to (full or relative path).
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  void create_symbolic_link(const Glib::ustring& target_reference) throw(exception);
  #else
  void create_symbolic_link(const Glib::ustring& target_reference, std::auto_ptr<Gnome::Vfs::exception>& error);
  #endif

  /** Check if this Uri points to an existing entity.
   * @return <tt>true</tt> if this Uri exists.
   */
  bool uri_exists() const;

  /** This only works for URIs with the file: scheme.
   *
   * @param vfs_uri:
   * @result The amount of free space on a volume.
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  FileSize get_volume_free_space() const throw(exception);        
  #else
  FileSize get_volume_free_space(std::auto_ptr<Gnome::Vfs::exception>& error) const;
  #endif


};


//TODO: GnomeVFSToplevelURI inherits from GnomeVFSUri, but they are not GObjects. That needs a little work.
/*
class TopLevelUri : Uri
{
  //TODO: Constructors/memory-management so we can wrap a GnomeVFSToplevelURI* in this.
  //TODO: member accessors?
};
*/
  

} // namespace Vfs
} // namespace Gnome


namespace Gnome
{

namespace Vfs
{

/** @relates Gnome::Vfs::Uri
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const Uri& lhs, const Uri& rhs);

/** @relates Gnome::Vfs::Uri
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const Uri& lhs, const Uri& rhs);


} // namespace Vfs

} // namespace Gnome


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Vfs::Uri
   */
  Glib::RefPtr<Gnome::Vfs::Uri> wrap(GnomeVFSURI* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGNOMEVFSMM_URI_H */

