/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     CLASS = 258,
     FROM = 259,
     CONST = 260,
     VOID = 261,
     STRUCT = 262,
     UNION = 263,
     ENUM = 264,
     THREEDOTS = 265,
     SIGNED = 266,
     UNSIGNED = 267,
     LONG = 268,
     SHORT = 269,
     INT = 270,
     FLOAT = 271,
     DOUBLE = 272,
     CHAR = 273,
     TOKEN = 274,
     NUMBER = 275,
     TYPETOKEN = 276,
     ARRAY_DIM = 277,
     SINGLE_CHAR = 278,
     CCODE = 279,
     HTCODE = 280,
     PHCODE = 281,
     HCODE = 282,
     ACODE = 283,
     ATCODE = 284,
     STRING = 285,
     PUBLIC = 286,
     PRIVATE = 287,
     PROTECTED = 288,
     CLASSWIDE = 289,
     PROPERTY = 290,
     ARGUMENT = 291,
     VIRTUAL = 292,
     SIGNAL = 293,
     OVERRIDE = 294,
     NICK = 295,
     BLURB = 296,
     MAXIMUM = 297,
     MINIMUM = 298,
     DEFAULT_VALUE = 299,
     ERROR = 300,
     FLAGS = 301,
     TYPE = 302,
     FLAGS_TYPE = 303,
     ENUM_TYPE = 304,
     PARAM_TYPE = 305,
     BOXED_TYPE = 306,
     OBJECT_TYPE = 307
   };
#endif
#define CLASS 258
#define FROM 259
#define CONST 260
#define VOID 261
#define STRUCT 262
#define UNION 263
#define ENUM 264
#define THREEDOTS 265
#define SIGNED 266
#define UNSIGNED 267
#define LONG 268
#define SHORT 269
#define INT 270
#define FLOAT 271
#define DOUBLE 272
#define CHAR 273
#define TOKEN 274
#define NUMBER 275
#define TYPETOKEN 276
#define ARRAY_DIM 277
#define SINGLE_CHAR 278
#define CCODE 279
#define HTCODE 280
#define PHCODE 281
#define HCODE 282
#define ACODE 283
#define ATCODE 284
#define STRING 285
#define PUBLIC 286
#define PRIVATE 287
#define PROTECTED 288
#define CLASSWIDE 289
#define PROPERTY 290
#define ARGUMENT 291
#define VIRTUAL 292
#define SIGNAL 293
#define OVERRIDE 294
#define NICK 295
#define BLURB 296
#define MAXIMUM 297
#define MINIMUM 298
#define DEFAULT_VALUE 299
#define ERROR 300
#define FLAGS 301
#define TYPE 302
#define FLAGS_TYPE 303
#define ENUM_TYPE 304
#define PARAM_TYPE 305
#define BOXED_TYPE 306
#define OBJECT_TYPE 307




/* Copy the first part of user declarations.  */
#line 23 "parse.y"


#include "config.h"
#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "treefuncs.h"
#include "main.h"
#include "util.h"

/* FIXME: add gettext support */
#define _(x) (x)
	
GList *nodes = NULL;

static GList *class_nodes = NULL;
Node *class = NULL;
GList *enums = NULL;
static GList *enum_vals = NULL;
static GList *flag_vals = NULL;
static GList *error_vals = NULL;

static gboolean abstract = FALSE;
static char *chunk_size = NULL;
static char *bonobo_object_class = NULL;
static int glade_xml = FALSE;
static GList *interfaces = NULL;
static GList *typestack = NULL;
static GList *funcargs = NULL;
static GList *checks = NULL;
static int has_self = FALSE;
static int vararg = FALSE;
static Method *last_added_method = NULL;

/* destructor and initializer for variables */
static gboolean destructor_unref = FALSE;
static char *destructor = NULL;
static int destructor_line = 0;
static gboolean destructor_simple = TRUE;
static char *initializer = NULL;
static int initializer_line = 0;
static int glade_widget = FALSE;

static char *onerror = NULL;
static char *defreturn = NULL;

static GList *gtktypes = NULL;

static Property *property = NULL;

/* this can be a global as we will only do one function at a time
   anyway */
static int the_scope = NO_SCOPE;

void free(void *ptr);
int yylex(void);

extern int ccode_line;
extern int line_no;
extern gboolean for_cpp;

extern char *yytext;

static void
yyerror(char *str)
{
	char *out=NULL;
	char *p;
	
	if(strcmp(yytext,"\n")==0) {
		out=g_strconcat("Error: ",str," before newline",NULL);
	} else if(yytext[0]=='\0') {
		out=g_strconcat("Error: ", str, " at end of input", NULL);
	} else {
		char *tmp = g_strdup(yytext);
		while((p=strchr(tmp, '\n')))
			*p='.';

		out=g_strconcat("Error: ", str, " before '", tmp, "'", NULL);
		g_free(tmp);
	}

	fprintf(stderr, "%s:%d: %s\n", filename, line_no, out);
	g_free(out);
	
	exit(1);
}

static Type *
pop_type(void)
{
	Type *type = typestack->data;
	typestack = g_list_remove(typestack,typestack->data);
	return type;
}

static void
push_variable (char *name, int scope, int line_no, char *postfix)
{
	Node *var;
	Type *type = pop_type ();

	type->postfix = postfix;
	
	var = node_new (VARIABLE_NODE,
			"scope", scope,
			"vtype:steal", type,
			"glade_widget", glade_widget,
			"id:steal", name,
			"line_no", line_no,
			"destructor_unref", destructor_unref,
			"destructor:steal", destructor,
			"destructor_line", destructor_line,
			"destructor_simple", destructor_simple,
			"initializer:steal", initializer,
			"initializer_line", initializer_line,
			"initializer_simple", TRUE,
			NULL);
	class_nodes = g_list_append(class_nodes, var);
	glade_widget = FALSE;
}

static void
push_function (int scope, int method, char *oid, char *id,
	       GString *cbuf, int line_no, int ccode_line,
	       gboolean vararg, GList *flags)
{
	Node *node;
	Type *type;
	char *c_cbuf;

	g_assert(scope != CLASS_SCOPE);
       
	if(method == INIT_METHOD || method == CLASS_INIT_METHOD) {
		type = (Type *)node_new (TYPE_NODE,
					 "name", "void",
					 NULL);
	} else {
		type = pop_type();
	}
	
	/* a complicated and ugly test to figure out if we have
	   the wrong number of types for a signal */
	if((method == SIGNAL_FIRST_METHOD ||
	    method == SIGNAL_LAST_METHOD) &&
	   g_list_length(gtktypes) != g_list_length(funcargs) &&
	   !(g_list_length(funcargs) == 1 &&
	     g_list_length(gtktypes) == 2 &&
	     strcmp(gtktypes->next->data, "NONE")==0)) {
		error_print(GOB_WARN, line_no,
			    _("The number of GTK arguments and "
			      "function arguments for a signal "
			      "don't seem to match"));
	}
	if(g_list_length(gtktypes) > 2) {
		GList *li;
		for(li = gtktypes->next; li; li = li->next) {
			if(strcmp(li->data, "NONE")==0) {
				error_print(GOB_ERROR, line_no,
					    _("NONE can only appear in an "
					      "argument list by itself"));
			}
		}
	}
	if(cbuf) {
		char *p;
		c_cbuf = p = cbuf->str;
		while(p && *p && (*p==' ' || *p=='\t' || *p=='\n' || *p=='\r'))
			p++;
		if(!p || !*p)
			c_cbuf = NULL;
	} else
		c_cbuf = NULL;

	node = node_new (METHOD_NODE,
			 "scope", scope,
			 "method", method,
			 "mtype:steal", type,
			 "otype:steal", oid,
			 "gtktypes:steal", gtktypes,
			 "flags:steal", flags,
			 "id:steal", id,
			 "args:steal", funcargs,
			 "onerror:steal", onerror,
			 "defreturn:steal", defreturn,
			 "cbuf:steal", c_cbuf,
			 "line_no", line_no,
			 "ccode_line", ccode_line,
			 "vararg", vararg,
			 "unique_id", method_unique_id++,
			 NULL);

	last_added_method = (Method *)node;

	if(cbuf)
		g_string_free(cbuf,
			      /*only free segment if we haven't passed it
				above */
			      c_cbuf?FALSE:TRUE);
	gtktypes = NULL;
	funcargs = NULL;

	onerror = NULL;
	defreturn = NULL;

	class_nodes = g_list_append(class_nodes, node);
}

static void
free_all_global_state(void)
{
	g_free(onerror);
	onerror = NULL;
	g_free(defreturn);
	defreturn = NULL;

	g_free(chunk_size);
	chunk_size = NULL;
	
	g_list_foreach(gtktypes, (GFunc)g_free, NULL);
	g_list_free(gtktypes);
	gtktypes = NULL;

	node_list_free (funcargs);
	funcargs = NULL;
}

static void
push_funcarg(char *name, char *postfix)
{
	Node *node;
	Type *type = pop_type();

	type->postfix = postfix;
	
	node = node_new (FUNCARG_NODE,
			 "atype:steal", type,
			 "name:steal", name,
			 "checks:steal", checks,
			 NULL);
	checks = NULL;
	
	funcargs = g_list_append(funcargs, node);
}

static void
push_init_arg(char *name, int is_class)
{
	Node *node;
	Node *type;
	char *tn;
	
	if(is_class)
		tn = g_strconcat(((Class *)class)->otype,":Class",NULL);
	else
		tn = g_strdup(((Class *)class)->otype);

	type = node_new (TYPE_NODE,
			 "name:steal", tn,
			 "pointer", "*",
			 NULL);
	node = node_new (FUNCARG_NODE,
			 "atype:steal", (Type *)type,
			 "name:steal", name,
			 NULL);
	funcargs = g_list_prepend(funcargs, node);
}

static void
push_self(char *id, gboolean constant)
{
	Node *node;
	Node *type;
	GList *ch = NULL;
	type = node_new (TYPE_NODE,
			 "name", ((Class *)class)->otype,
			 "pointer", constant ? "const *" : "*",
			 NULL);
	ch = g_list_append (ch, node_new (CHECK_NODE,
					  "chtype", NULL_CHECK,
					  NULL));
	ch = g_list_append (ch, node_new (CHECK_NODE,
					  "chtype", TYPE_CHECK,
					  NULL));
	node = node_new (FUNCARG_NODE,
			 "atype:steal", (Type *)type,
			 "name:steal", id,
			 "checks:steal", ch,
			 NULL);
	funcargs = g_list_prepend(funcargs, node);
}

static Variable *
find_var_or_die(const char *id, int line)
{
	GList *li;

	for(li = class_nodes; li != NULL; li = li->next) {
		Variable *var;
		Node *node = li->data;
		if(node->type != VARIABLE_NODE)
			continue;
		var = li->data;
		if(strcmp(var->id, id)==0)
			return var;
	}

	error_printf(GOB_ERROR, line, _("Variable %s not defined here"), id);

	g_assert_not_reached();
	return NULL;
}

static gboolean
set_return_value(char *type, char *val)
{
	if(strcmp(type, "onerror")==0) {
		if(!onerror) {
			onerror = val;
			return TRUE;
		} else
			return FALSE;
	} else if(strcmp(type, "defreturn")==0) {
		if(!defreturn) {
			defreturn = val;
			return TRUE;
		} else
			return FALSE;
	}
	return FALSE;
}

static void
export_accessors (const char *var_name,
		  gboolean do_get,
		  int get_lineno,
		  gboolean do_set,
		  int set_lineno,
		  Type *type,
		  const char *gtktype,
		  int lineno)
{	
	Type *the_type;

	if (type != NULL)
		the_type = (Type *)node_copy ((Node *)type);
	else
		the_type = get_tree_type (gtktype, TRUE);

	if (the_type == NULL) {
		error_print (GOB_ERROR, line_no,
			     _("Cannot determine type of property or argument"));
		return;
	}

	if (do_get) {
		char *get_id = g_strdup_printf ("get_%s", var_name);
		GString *get_cbuf = g_string_new (NULL);
		Node *node1 = node_new (TYPE_NODE,
					"name", the_type->name,
					"pointer", the_type->pointer,
					"postfix", the_type->postfix,
					NULL);
		Node *node3 = node_new (TYPE_NODE,
					"name", class->class.otype,
					"pointer", "*",
					NULL);

		g_string_sprintf (get_cbuf,
				  "\t%s%s val; "
				  "g_object_get (G_OBJECT (self), \"%s\", "
				  "&val, NULL); "
				  "return val;\n",
				  the_type->name, 
				  the_type->pointer ? the_type->pointer : "",
				  var_name);
		
		typestack = g_list_prepend (typestack, node1);
		typestack = g_list_prepend (typestack, node3);
		
		push_funcarg ("self", FALSE);
		
		push_function (PUBLIC_SCOPE, REGULAR_METHOD, NULL,
			       get_id, get_cbuf, get_lineno,
			       lineno, FALSE, NULL);
	}
	
	if (do_set) {
		char *set_id = g_strdup_printf ("set_%s", var_name);
		GString *set_cbuf = g_string_new (NULL);
		Node *node1 = node_new (TYPE_NODE, 
					"name", the_type->name,
					"pointer", the_type->pointer,
					"postfix", the_type->postfix,
					NULL);
		Node *node2 = node_new (TYPE_NODE, 
					"name", "void",
					NULL);
		Node *node3 = node_new (TYPE_NODE, 
					"name", class->class.otype,
					"pointer", "*",
					NULL);

		g_string_sprintf (set_cbuf,
				  "\tg_object_set (G_OBJECT (self), "
				  "\"%s\", val, NULL);\n",
				  var_name);

		typestack = g_list_prepend (typestack, node2);
		typestack = g_list_prepend (typestack, node1);
		typestack = g_list_prepend (typestack, node3);
		
		push_funcarg ("self", FALSE);
		push_funcarg ("val", FALSE);
	
		typestack = g_list_prepend (typestack, node2);
		push_function (PUBLIC_SCOPE, REGULAR_METHOD, NULL,
			       set_id, set_cbuf, set_lineno,
			       lineno, FALSE, NULL);
	}

	node_free ((Node *)the_type);
}

static char *
get_prop_enum_flag_cast (Property *prop)
{
	char *tmp, *ret;
	if (prop->extra_gtktype == NULL ||
	/* HACK!  just in case someone made this
	 * work with 2.0.0 by using the TYPE
	 * macro directly */
	    ((strstr (prop->extra_gtktype, "_TYPE_") != NULL ||
	      strstr (prop->extra_gtktype, "TYPE_") == prop->extra_gtktype) &&
	     strchr (prop->extra_gtktype, ':') == NULL)) {
		if (prop->ptype != NULL)
			return get_type (prop->ptype, TRUE);
		else
			return g_strdup ("");
	}
	tmp = remove_sep (prop->extra_gtktype);
	ret = g_strdup_printf ("(%s) ", tmp);
	g_free (tmp);
	return ret;
}

static void
add_construct_glade (char * file, char * root, char * domain)
{
	Node *var;
	Type * type;
	GList * flags = NULL;
	
	type = (Type *)node_new (TYPE_NODE,
				 "name", "GladeXML",
				 "pointer", "*",
				 NULL);
	initializer = g_strdup_printf("\t{\n"
				      "\tGtkWidget * root;\n"
				      "\t%%1$s->_priv->_glade_xml = glade_xml_new(%s, %s, %s);\n"
				      "\troot = glade_xml_get_widget(%%1$s->_priv->_glade_xml, %s);\n"
				      "\tgtk_widget_show(root);\n"
				      "\tgtk_container_add(GTK_CONTAINER(%%1$s), root);\n"
				      "\tglade_xml_signal_autoconnect_full(%%1$s->_priv->_glade_xml, (GladeXMLConnectFunc)___glade_xml_connect_foreach, (gpointer)%%1$s);\n"
				      "}\n", file, root, domain ? domain : "NULL", root);
	
	var = node_new (VARIABLE_NODE,
			"scope", PRIVATE_SCOPE,
			"vtype:steal", type,
			"glade_widget", FALSE,
			"id:steal", "_glade_xml",
			"destructor_unref", FALSE,
			"destructor", "g_object_unref", 
			"destructor_simple", TRUE,
			"initializer", initializer,
			"initializer_simple", FALSE,
			NULL);
	class_nodes = g_list_prepend(class_nodes, var);
}

static void
property_link_and_export (Node *node)
{
	Property *prop = (Property *)node;

	if (prop->link) {
		const char *root;
		char *get = NULL, *set = NULL;
		Variable *var;

		if (prop->set != NULL ||
		    prop->get != NULL) {	
			error_print (GOB_ERROR, prop->line_no,
				     _("Property linking requested, but "
				       "getters and setters exist"));
		}

		var = find_var_or_die (prop->name, prop->line_no);
		if(var->scope == PRIVATE_SCOPE) {
			root = "self->_priv";
		} else if (var->scope == CLASS_SCOPE) {
			root = "SELF_GET_CLASS(self)";
			if (no_self_alias)
				error_print (GOB_ERROR, prop->line_no,
					     _("Self aliases needed when autolinking to a classwide member"));
		} else {
			root = "self";
		}

		if (strcmp (prop->gtktype, "STRING") == 0) {
			set = g_strdup_printf("{ char *old = %s->%s; "
					      "%s->%s = g_value_dup_string (VAL); g_free (old); }",
					      root, prop->name,
					      root, prop->name);
			get = g_strdup_printf("g_value_set_string (VAL, %s->%s);",
					      root, prop->name);
		} else if (strcmp (prop->gtktype, "OBJECT") == 0) {
			char *cast;
			if (prop->extra_gtktype != NULL) {
				cast = remove_sep (prop->extra_gtktype);
			} else {
				cast = g_strdup ("void");
			}
			set = g_strdup_printf("{ GObject *___old = (GObject *)%s->%s; "
					      "%s->%s = (%s *)g_value_dup_object (VAL); "
					      "if (___old != NULL) { "
					        "g_object_unref (G_OBJECT (___old)); "
					      "} "
					      "}",
					      root, prop->name,
					      root, prop->name,
					      cast);
			get = g_strdup_printf ("g_value_set_object (VAL, "
					       "(gpointer)%s->%s);",
					       root, prop->name);
			g_free (cast);
		} else if (strcmp (prop->gtktype, "BOXED") == 0) {
			char *type = make_me_type (prop->extra_gtktype,
						   "G_TYPE_BOXED");
			if (prop->extra_gtktype == NULL) {
				error_print (GOB_ERROR, prop->line_no,
					     _("Property linking requested for BOXED, but "
					       "boxed_type not set"));
			}
			set = g_strdup_printf("{ gpointer ___old = (gpointer)%s->%s; "
					      "gpointer ___new = (gpointer)g_value_get_boxed (VAL); "
					      "if (___new != ___old) { "
					        "if (___old != NULL) g_boxed_free (%s, ___old); "
					        "if (___new != NULL) %s->%s = g_boxed_copy (%s, ___new); "
					        "else %s->%s = NULL;"
					      "} "
					      "}",
					      root, prop->name,
					      type,
					      root, prop->name,
					      type,
					      root, prop->name);
			get = g_strdup_printf("g_value_set_boxed (VAL, %s->%s);",
					      root, prop->name);
			g_free (type);
		} else {
			char *set_func;
			char *get_func;
			const char *getcast = "";
			const char *setcast = "";
			char *to_free = NULL;
			set_func = g_strdup_printf ("g_value_set_%s", prop->gtktype);
			g_strdown (set_func);
			get_func = g_strdup_printf ("g_value_get_%s", prop->gtktype);
			g_strdown (get_func);

			if (for_cpp) {
				if (strcmp (prop->gtktype, "FLAGS") == 0) {
					setcast = "(guint) ";
					getcast = to_free =
						get_prop_enum_flag_cast (prop);
				} else if (strcmp (prop->gtktype, "ENUM") == 0) {
					setcast = "(gint) ";
					getcast = to_free =
						get_prop_enum_flag_cast (prop);
                               }  else if (strcmp (prop->gtktype, "POINTER") == 0) {
                                       setcast = "(gpointer) ";
                                       getcast = g_strdup_printf ("(%s%s) ",
								  prop->ptype->name,
								  prop->ptype->pointer ? prop->ptype->pointer : "");
				}
			}

			set = g_strdup_printf("%s->%s = %s%s (VAL);",
					      root, prop->name,
					      getcast,
					      get_func);
			get = g_strdup_printf("%s (VAL, %s%s->%s);",
					      set_func,
					      setcast,	
					      root, prop->name);

			g_free (get_func);
			g_free (set_func);
			g_free (to_free);
		}

		node_set (node,
			  "get:steal", get,
			  "get_line", prop->line_no,
			  "set:steal", set,
			  "set_line", prop->line_no,
			  NULL);
	}

	if (prop->export) {
		export_accessors (prop->name,
				  prop->get != NULL, prop->get_line,
				  prop->set != NULL,  prop->set_line,
				  prop->ptype,
				  prop->gtktype,
				  prop->line_no);
	} 
}


static char *
debool (char *s)
{
	if (strcmp (s, "BOOL") == 0) {
		error_print (GOB_WARN, line_no,
			    _("BOOL type is deprecated, please use BOOLEAN"));
		g_free (s);
		return g_strdup ("BOOLEAN");
	} else {
		return s;
	}
}

static void
ensure_property (void)
{
	if (property == NULL)
		property = (Property *)node_new (PROPERTY_NODE, NULL);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 668 "parse.y"
typedef union YYSTYPE {
	char *id;
	GString *cbuf;
	GList *list;
	int line;
	int sigtype;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 833 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 213 of yacc.c.  */
#line 845 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  23
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   629

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  66
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  53
/* YYNRULES -- Number of rules. */
#define YYNRULES  195
/* YYNRULES -- Number of states. */
#define YYNSTATES  414

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   307

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    64,     2,     2,     2,     2,     2,     2,
      55,    56,    61,     2,    59,    65,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    57,
      63,    58,    62,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    53,    60,    54,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     7,    10,    13,    15,    17,    19,    21,
      23,    25,    27,    30,    33,    36,    39,    41,    43,    45,
      47,    52,    56,    62,    63,    68,    74,    80,    86,    93,
     101,   108,   116,   119,   121,   123,   126,   130,   132,   134,
     136,   138,   140,   142,   144,   146,   149,   153,   156,   160,
     163,   166,   168,   170,   172,   173,   179,   186,   199,   209,
     216,   220,   221,   233,   242,   248,   252,   253,   257,   259,
     261,   266,   268,   270,   274,   278,   282,   286,   290,   294,
     298,   302,   306,   310,   314,   318,   322,   326,   330,   334,
     338,   340,   346,   348,   352,   353,   357,   359,   362,   364,
     366,   368,   371,   374,   377,   381,   385,   388,   391,   394,
     396,   399,   401,   404,   406,   408,   410,   412,   414,   416,
     418,   420,   422,   424,   426,   428,   430,   433,   436,   440,
     443,   445,   449,   453,   456,   458,   463,   467,   469,   472,
     474,   485,   497,   507,   517,   526,   538,   547,   553,   556,
     561,   562,   564,   567,   569,   571,   574,   577,   581,   586,
     591,   593,   597,   599,   603,   605,   608,   612,   619,   627,
     630,   632,   634,   637,   640,   644,   648,   652,   656,   664,
     673,   677,   679,   683,   685,   693,   702,   706,   708,   716,
     725,   729,   731,   733,   736,   738
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      67,     0,    -1,    69,    70,    69,    -1,    70,    69,    -1,
      69,    70,    -1,    70,    -1,    24,    -1,    27,    -1,    25,
      -1,    26,    -1,    28,    -1,    29,    -1,    69,    68,    -1,
      69,   111,    -1,    69,   114,    -1,    69,   116,    -1,    68,
      -1,   111,    -1,   114,    -1,   116,    -1,    71,    53,    73,
      54,    -1,    71,    53,    54,    -1,     3,    21,     4,    21,
      72,    -1,    -1,    55,    19,    56,    72,    -1,    55,    19,
      19,    56,    72,    -1,    55,    19,    21,    56,    72,    -1,
      55,    19,    20,    56,    72,    -1,    55,    19,    30,    30,
      56,    72,    -1,    55,    19,    30,    30,    30,    56,    72,
      -1,    55,    19,    19,    30,    56,    72,    -1,    55,    19,
      19,    30,    30,    56,    72,    -1,    73,    74,    -1,    74,
      -1,   102,    -1,    19,   102,    -1,    19,    21,   102,    -1,
      79,    -1,    80,    -1,    82,    -1,    57,    -1,    31,    -1,
      32,    -1,    33,    -1,    34,    -1,    19,    19,    -1,    19,
      53,    24,    -1,    58,   118,    -1,    58,    53,    24,    -1,
      76,    77,    -1,    77,    76,    -1,    77,    -1,    76,    -1,
      19,    -1,    -1,    75,    91,    19,    78,    57,    -1,    75,
      91,    19,    22,    78,    57,    -1,    36,    89,    88,    19,
      81,    19,    53,    24,    19,    53,    24,    57,    -1,    36,
      89,    88,    19,    81,    19,    53,    24,    57,    -1,    36,
      89,    88,    19,    81,    19,    -1,    55,    19,    56,    -1,
      -1,    35,    19,    19,    83,    19,    53,    24,    19,    53,
      24,    57,    -1,    35,    19,    19,    83,    19,    53,    24,
      57,    -1,    35,    19,    19,    83,    57,    -1,    55,    84,
      56,    -1,    -1,    84,    59,    87,    -1,    87,    -1,    30,
      -1,    19,    55,    30,    56,    -1,   118,    -1,    85,    -1,
      40,    58,    85,    -1,    41,    58,    85,    -1,    42,    58,
     118,    -1,    43,    58,   118,    -1,    44,    58,    86,    -1,
      46,    58,    90,    -1,    47,    58,    91,    -1,    48,    58,
      21,    -1,    48,    58,    19,    -1,    49,    58,    21,    -1,
      49,    58,    19,    -1,    50,    58,    21,    -1,    50,    58,
      19,    -1,    51,    58,    21,    -1,    51,    58,    19,    -1,
      52,    58,    21,    -1,    52,    58,    19,    -1,    19,    -1,
      19,    55,    19,    91,    56,    -1,    19,    -1,    55,    90,
      56,    -1,    -1,    19,    60,    90,    -1,    19,    -1,    92,
      96,    -1,    92,    -1,    93,    -1,    19,    -1,     5,    19,
      -1,    19,     5,    -1,    95,    19,    -1,     5,    95,    19,
      -1,    95,    19,     5,    -1,    94,    93,    -1,    21,    93,
      -1,     5,    93,    -1,    21,    -1,    21,     5,    -1,    94,
      -1,    94,     5,    -1,     6,    -1,    18,    -1,    14,    -1,
      15,    -1,    13,    -1,    16,    -1,    17,    -1,    11,    -1,
      12,    -1,     7,    -1,     8,    -1,     9,    -1,    61,    -1,
      61,     5,    -1,    61,    96,    -1,    61,     5,    96,    -1,
      19,    99,    -1,    99,    -1,    75,    19,    99,    -1,    19,
      75,    99,    -1,    75,    99,    -1,    97,    -1,    19,    55,
     100,    56,    -1,   100,    59,    19,    -1,    19,    -1,    53,
      24,    -1,    57,    -1,    38,    89,    98,    91,    19,    55,
     105,    56,   103,   101,    -1,    75,    38,    89,    97,    91,
      19,    55,   105,    56,   103,   101,    -1,    37,    75,    91,
      19,    55,   105,    56,   103,   101,    -1,    75,    37,    91,
      19,    55,   105,    56,   103,   101,    -1,    37,    91,    19,
      55,   105,    56,   103,   101,    -1,    39,    55,    21,    56,
      91,    19,    55,   105,    56,   103,   101,    -1,    75,    91,
      19,    55,   105,    56,   103,   101,    -1,    19,    55,    19,
      56,   101,    -1,    19,   104,    -1,    19,   104,    19,   104,
      -1,    -1,   118,    -1,    53,    24,    -1,     6,    -1,    19,
      -1,    19,     5,    -1,     5,    19,    -1,    19,    59,   106,
      -1,    19,     5,    59,   106,    -1,     5,    19,    59,   106,
      -1,   106,    -1,   107,    59,    10,    -1,   107,    -1,   107,
      59,   108,    -1,   108,    -1,    91,    19,    -1,    91,    19,
      22,    -1,    91,    19,    55,    19,   109,    56,    -1,    91,
      19,    22,    55,    19,   109,    56,    -1,   109,   110,    -1,
     110,    -1,    19,    -1,    62,   118,    -1,    63,   118,    -1,
      62,    58,   118,    -1,    63,    58,   118,    -1,    58,    58,
     118,    -1,    64,    58,   118,    -1,     9,    19,    53,   112,
      54,    21,    57,    -1,     9,    19,    53,   112,    59,    54,
      21,    57,    -1,   112,    59,   113,    -1,   113,    -1,    19,
      58,   118,    -1,    19,    -1,    46,    19,    53,   115,    54,
      21,    57,    -1,    46,    19,    53,   115,    59,    54,    21,
      57,    -1,   115,    59,    19,    -1,    19,    -1,    45,    19,
      53,   117,    54,    21,    57,    -1,    45,    19,    53,   117,
      59,    54,    21,    57,    -1,   117,    59,    19,    -1,    19,
      -1,    20,    -1,    65,    20,    -1,    23,    -1,    19,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   689,   689,   690,   691,   692,   695,   704,   713,   722,
     731,   740,   751,   752,   753,   754,   755,   756,   757,   758,
     761,   766,   773,   790,   791,   799,   811,   820,   832,   841,
     850,   859,   870,   871,   874,   875,   884,   896,   897,   898,
     899,   902,   903,   904,   905,   908,   928,   952,   956,   964,
     965,   966,   967,   968,   976,   982,   985,   990,  1058,  1112,
    1201,  1209,  1214,  1262,  1298,  1314,  1315,  1318,  1319,  1322,
    1323,  1335,  1336,  1339,  1345,  1351,  1357,  1363,  1369,  1375,
    1382,  1388,  1394,  1400,  1406,  1412,  1418,  1424,  1430,  1436,
    1442,  1467,  1476,  1482,  1483,  1486,  1489,  1495,  1502,  1511,
    1514,  1517,  1521,  1525,  1529,  1534,  1542,  1546,  1551,  1555,
    1558,  1562,  1565,  1570,  1571,  1572,  1573,  1574,  1575,  1576,
    1577,  1578,  1581,  1582,  1583,  1586,  1587,  1588,  1592,  1599,
    1611,  1617,  1629,  1641,  1644,  1650,  1655,  1658,  1663,  1664,
    1668,  1684,  1700,  1716,  1732,  1743,  1749,  1759,  1782,  1793,
    1812,  1818,  1819,  1825,  1826,  1837,  1848,  1859,  1869,  1879,
    1889,  1892,  1893,  1896,  1897,  1900,  1903,  1906,  1914,  1924,
    1925,  1928,  1945,  1952,  1959,  1966,  1973,  1980,  1989,  1998,
    2009,  2010,  2013,  2033,  2043,  2052,  2063,  2066,  2071,  2080,
    2091,  2094,  2100,  2101,  2105,  2106
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "CLASS", "FROM", "CONST", "VOID",
  "STRUCT", "UNION", "ENUM", "THREEDOTS", "SIGNED", "UNSIGNED", "LONG",
  "SHORT", "INT", "FLOAT", "DOUBLE", "CHAR", "TOKEN", "NUMBER",
  "TYPETOKEN", "ARRAY_DIM", "SINGLE_CHAR", "CCODE", "HTCODE", "PHCODE",
  "HCODE", "ACODE", "ATCODE", "STRING", "PUBLIC", "PRIVATE", "PROTECTED",
  "CLASSWIDE", "PROPERTY", "ARGUMENT", "VIRTUAL", "SIGNAL", "OVERRIDE",
  "NICK", "BLURB", "MAXIMUM", "MINIMUM", "DEFAULT_VALUE", "ERROR", "FLAGS",
  "TYPE", "FLAGS_TYPE", "ENUM_TYPE", "PARAM_TYPE", "BOXED_TYPE",
  "OBJECT_TYPE", "'{'", "'}'", "'('", "')'", "';'", "'='", "','", "'|'",
  "'*'", "'>'", "'<'", "'!'", "'-'", "$accept", "prog", "ccode", "ccodes",
  "class", "classdec", "classflags", "classcode", "thing", "scope",
  "destructor", "initializer", "varoptions", "variable", "argument",
  "export", "property", "param_spec", "param_spec_list", "string",
  "anyval", "param_spec_value", "argtype", "flags", "flaglist", "type",
  "specifier_list", "spec_list", "specifier", "strunionenum", "pointer",
  "simplesigtype", "fullsigtype", "sigtype", "tokenlist", "codenocode",
  "method", "returnvals", "retcode", "funcargs", "arglist", "arglist1",
  "arg", "checklist", "check", "enumcode", "enumvals", "enumval",
  "flagcode", "flagvals", "errorcode", "errorvals", "numtok", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   123,   125,    40,    41,    59,    61,    44,
     124,    42,    62,    60,    33,    45
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    66,    67,    67,    67,    67,    68,    68,    68,    68,
      68,    68,    69,    69,    69,    69,    69,    69,    69,    69,
      70,    70,    71,    72,    72,    72,    72,    72,    72,    72,
      72,    72,    73,    73,    74,    74,    74,    74,    74,    74,
      74,    75,    75,    75,    75,    76,    76,    77,    77,    78,
      78,    78,    78,    78,    78,    79,    79,    80,    80,    80,
      81,    81,    82,    82,    82,    83,    83,    84,    84,    85,
      85,    86,    86,    87,    87,    87,    87,    87,    87,    87,
      87,    87,    87,    87,    87,    87,    87,    87,    87,    87,
      87,    88,    88,    89,    89,    90,    90,    91,    91,    92,
      92,    92,    92,    92,    92,    92,    93,    93,    93,    93,
      93,    93,    93,    94,    94,    94,    94,    94,    94,    94,
      94,    94,    95,    95,    95,    96,    96,    96,    96,    97,
      97,    98,    98,    98,    98,    99,   100,   100,   101,   101,
     102,   102,   102,   102,   102,   102,   102,   102,   103,   103,
     103,   104,   104,   105,   105,   105,   105,   105,   105,   105,
     105,   106,   106,   107,   107,   108,   108,   108,   108,   109,
     109,   110,   110,   110,   110,   110,   110,   110,   111,   111,
     112,   112,   113,   113,   114,   114,   115,   115,   116,   116,
     117,   117,   118,   118,   118,   118
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     3,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     1,     1,     1,     1,
       4,     3,     5,     0,     4,     5,     5,     5,     6,     7,
       6,     7,     2,     1,     1,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     2,     3,     2,
       2,     1,     1,     1,     0,     5,     6,    12,     9,     6,
       3,     0,    11,     8,     5,     3,     0,     3,     1,     1,
       4,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       1,     5,     1,     3,     0,     3,     1,     2,     1,     1,
       1,     2,     2,     2,     3,     3,     2,     2,     2,     1,
       2,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     3,     2,
       1,     3,     3,     2,     1,     4,     3,     1,     2,     1,
      10,    11,     9,     9,     8,    11,     8,     5,     2,     4,
       0,     1,     2,     1,     1,     2,     2,     3,     4,     4,
       1,     3,     1,     3,     1,     2,     3,     6,     7,     2,
       1,     1,     2,     2,     3,     3,     3,     3,     7,     8,
       3,     1,     3,     1,     7,     8,     3,     1,     7,     8,
       3,     1,     1,     2,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     0,     0,     6,     8,     9,     7,    10,    11,     0,
       0,     0,    16,     0,     5,     0,    17,    18,    19,     0,
       0,     0,     0,     1,    12,     4,    13,    14,    15,     3,
       0,     0,     0,     0,     0,     2,     0,    41,    42,    43,
      44,     0,    94,     0,    94,     0,    21,    40,     0,    33,
       0,    37,    38,    39,    34,    23,   183,     0,   181,   191,
       0,   187,     0,     0,     0,     0,     0,    35,     0,     0,
       0,     0,   113,   122,   123,   124,   120,   121,   117,   115,
     116,   118,   119,   114,   100,   109,     0,     0,    98,    99,
     111,     0,     0,     0,    20,    32,     0,    94,     0,     0,
      22,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       0,    66,    96,     0,    92,     0,     0,   101,   108,     0,
     102,   110,   107,     0,     0,   125,    97,   112,   106,   103,
       0,     0,   134,     0,   130,     0,     0,     0,    54,     0,
     195,   192,   194,     0,   182,     0,     0,   180,     0,   190,
       0,     0,   186,     0,     0,     0,     0,     0,     0,    93,
       0,    61,   104,     0,     0,   126,   127,   105,     0,     0,
       0,   129,     0,   133,     0,     0,     0,     0,     0,    53,
      54,     0,     0,    52,    51,     0,     0,     0,     0,     0,
      23,   193,   178,     0,   188,     0,   184,     0,     0,   139,
     147,    90,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    68,     0,    64,    95,     0,
       0,     0,     0,     0,   113,   100,     0,     0,   160,   162,
     164,   128,   137,     0,   132,   131,     0,     0,     0,     0,
      45,     0,     0,     0,     0,    47,    49,     0,    50,    55,
       0,    23,    23,    23,     0,    24,   179,   189,   185,   138,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    65,     0,     0,     0,     0,    59,     0,   101,
     102,     0,   165,   150,     0,   135,     0,     0,     0,     0,
       0,    46,    56,   150,    48,     0,    23,    25,    27,    26,
       0,    23,     0,    69,    73,    74,    75,    76,   195,    72,
      77,    71,    78,    79,    81,    80,    83,    82,    85,    84,
      87,    86,    89,    88,    67,     0,    91,    60,     0,   150,
       0,     0,   157,   166,     0,     0,     0,   161,   163,   136,
       0,     0,   150,     0,     0,    23,    30,    23,    28,     0,
       0,    63,     0,     0,   159,   158,     0,     0,     0,   148,
     151,   144,   150,     0,     0,     0,   146,    31,    29,     0,
       0,     0,    58,   142,     0,   171,     0,     0,     0,     0,
       0,   170,   152,     0,     0,   150,   143,   150,    70,     0,
       0,     0,     0,     0,   172,     0,   173,     0,   167,   169,
     149,   140,     0,     0,    62,     0,   168,   176,   174,   175,
     177,   145,   141,    57
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    11,    12,    13,    14,    15,   100,    48,    49,    50,
     183,   184,   185,    51,    52,   221,    53,   157,   214,   304,
     310,   215,   115,    70,   113,   226,    88,    89,    90,    91,
     126,   132,   133,   134,   233,   200,    54,   336,   359,   227,
     228,   229,   230,   380,   381,    16,    57,    58,    17,    62,
      18,    60,   360
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -325
static const short int yypact[] =
{
     144,    -5,    92,  -325,  -325,  -325,  -325,  -325,  -325,    98,
      99,   123,  -325,   144,   167,    78,  -325,  -325,  -325,   161,
     121,   154,   182,  -325,  -325,   167,  -325,  -325,  -325,   167,
     148,   179,   217,   227,   228,   167,   211,  -325,  -325,  -325,
    -325,   237,   229,   326,   229,   234,  -325,  -325,   184,  -325,
     292,  -325,  -325,  -325,  -325,   263,   261,   -31,  -325,  -325,
     147,  -325,   174,   268,   283,   309,   292,  -325,   317,   330,
     331,   373,  -325,  -325,  -325,  -325,  -325,  -325,  -325,  -325,
    -325,  -325,  -325,  -325,   346,   441,   390,   333,   294,  -325,
     455,   334,   293,   335,  -325,  -325,   390,   229,   357,   364,
    -325,    75,   372,    38,   379,    50,   389,    95,  -325,   298,
     398,   393,   367,   378,   394,   425,   469,  -325,  -325,   431,
    -325,   469,  -325,   432,   408,     5,  -325,   469,  -325,   459,
     220,   446,  -325,   390,  -325,   421,   460,   470,   156,   178,
    -325,  -325,  -325,   458,  -325,   434,   467,  -325,   435,  -325,
     472,   437,  -325,   474,   202,   442,   221,    39,   330,  -325,
     477,   443,  -325,   444,   407,   294,  -325,  -325,   445,   482,
     483,  -325,    -6,  -325,   484,   390,   449,    -6,   390,   101,
      31,   407,    15,   447,   487,   450,   -15,   452,   453,   480,
     263,  -325,  -325,   454,  -325,   456,  -325,   457,   488,  -325,
    -325,  -325,   461,   462,   463,   464,   465,   466,   468,   471,
     473,   475,   476,   478,   -23,  -325,   479,  -325,  -325,   390,
     496,   497,   407,   424,   481,    14,   498,   485,  -325,   486,
    -325,  -325,  -325,   201,  -325,  -325,   489,   499,   407,   506,
    -325,   503,   490,   492,   504,  -325,  -325,   101,  -325,  -325,
     100,   263,   263,   263,   104,  -325,  -325,  -325,  -325,  -325,
       2,     2,    75,    75,     7,   330,   390,   208,   266,   269,
     274,   327,  -325,   221,   511,   493,   494,   500,   495,   222,
     223,   390,    87,   519,   356,  -325,   520,   407,   491,   501,
     505,  -325,  -325,   519,  -325,   502,   263,  -325,  -325,  -325,
     507,   263,   509,  -325,  -325,  -325,  -325,  -325,   509,  -325,
    -325,  -325,  -325,  -325,  -325,  -325,  -325,  -325,  -325,  -325,
    -325,  -325,  -325,  -325,  -325,    58,  -325,  -325,   516,   519,
     390,   390,  -325,   510,   523,    32,   202,  -325,  -325,  -325,
     512,   407,   519,   407,   202,   263,  -325,   263,  -325,   513,
     508,  -325,    71,   202,  -325,  -325,   533,    88,   530,   536,
    -325,  -325,   519,   514,   202,   515,  -325,  -325,  -325,   517,
     532,   521,  -325,  -325,    88,  -325,   518,    64,    83,   522,
      63,  -325,  -325,    32,   202,   519,  -325,   519,  -325,   524,
     535,    81,    75,    75,  -325,    75,  -325,    75,  -325,  -325,
    -325,  -325,   202,   202,  -325,   525,  -325,  -325,  -325,  -325,
    -325,  -325,  -325,  -325
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -325,  -325,   103,   110,   549,  -325,  -188,  -325,   527,   -25,
     382,   347,   387,  -325,  -325,  -325,  -325,  -325,  -325,    22,
    -325,   296,  -325,   -35,  -153,   -42,  -325,   -68,  -325,   -65,
     -94,   440,  -325,   -84,  -325,  -324,   -22,  -286,   189,  -177,
    -256,  -325,   295,   204,  -154,   175,  -325,   526,   196,  -325,
     245,  -325,  -101
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -157
static const short int yytable[] =
{
     144,    87,   255,   118,   243,   218,   119,   344,    98,    92,
     165,    66,   361,   168,    67,   250,    19,   122,    86,   280,
     366,   302,   128,   102,   110,   332,   308,   141,   103,   373,
     142,   166,   303,   272,   140,   141,   273,   303,   142,    66,
     386,   251,   108,   353,   123,   278,   171,   173,   118,   169,
     179,   140,   141,   118,   136,   142,   364,    56,   216,   118,
     401,   289,   137,   297,   298,   299,   125,   131,   244,   149,
    -154,   231,   143,   281,   354,   355,   384,   350,   411,   412,
     143,   245,   375,   140,   141,   358,   234,   142,   235,   182,
     371,   174,   146,   171,   140,   141,   217,   143,   142,   402,
     375,   403,   140,   141,   150,   170,   142,   375,   346,   333,
     340,    20,   312,   348,   152,   351,    24,    21,    22,   398,
     240,   376,   393,    23,    29,   377,   378,   379,   372,   143,
     295,    30,    24,   237,   300,    35,   239,   406,    24,   376,
     143,   395,   334,   377,   378,   379,   376,     1,   143,   153,
     377,   378,   379,     2,   241,   118,   296,   367,   119,   368,
     301,   306,   307,   311,   363,    31,   365,    36,     3,     4,
       5,     6,     7,     8,    32,   179,     2,   275,   180,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    26,     9,
      10,     3,     4,     5,     6,     7,     8,   186,   187,   188,
      55,   104,    46,    36,    26,    47,   105,    33,   189,    27,
      26,   181,     9,    10,   182,    37,    38,    39,    40,    41,
      42,    43,    44,    45,   313,    27,   399,   314,   106,   315,
      63,    27,    64,   107,   190,    34,    56,   399,    94,   168,
     201,    47,    37,    38,    39,    40,    59,    61,    43,    44,
      45,    37,    38,    39,    40,   198,    68,   285,    28,   199,
     286,   202,   203,   204,   205,   206,    65,   207,   208,   209,
     210,   211,   212,   213,    28,   169,   394,   396,  -156,  -155,
      28,   330,   331,   305,    69,   316,   309,   317,   318,    93,
     319,   407,   408,   320,   409,   321,   410,    71,    72,    73,
      74,    75,    63,    76,    77,    78,    79,    80,    81,    82,
      83,    84,   130,    85,    37,    38,    39,    40,    99,   101,
      43,    44,    45,    65,    37,    38,    39,    40,   109,    96,
      97,    71,    72,    73,    74,    75,   111,    76,    77,    78,
      79,    80,    81,    82,    83,    84,   322,    85,   323,   112,
     114,   120,   124,   129,   154,   125,   135,    37,    38,    39,
      40,    71,    72,    73,    74,    75,   337,    76,    77,    78,
      79,    80,    81,    82,    83,    84,   138,    85,   116,    72,
      73,    74,    75,   139,    76,    77,    78,    79,    80,    81,
      82,    83,   117,   145,    85,    71,    72,    73,    74,    75,
     148,    76,    77,    78,    79,    80,    81,    82,    83,    84,
     151,    85,   223,   224,    73,    74,    75,   155,    76,    77,
      78,    79,    80,    81,    82,    83,   225,   158,    85,   116,
      72,    73,    74,    75,   159,    76,    77,    78,    79,    80,
      81,    82,    83,   279,   161,    85,   121,    72,   156,   160,
     162,   163,    76,    77,    78,    79,    80,    81,    82,    83,
     127,    72,    85,   164,   167,   172,    76,    77,    78,    79,
      80,    81,    82,    83,   116,    72,    85,   175,   191,   176,
      76,    77,    78,    79,    80,    81,    82,    83,   193,   177,
      85,   192,   194,   195,   196,   197,   219,   181,   220,   222,
     169,   232,   168,   236,   238,   182,   247,   249,   252,   253,
     254,   256,   259,   257,   258,   276,   277,   282,   288,   260,
     261,   262,   263,   264,   265,   290,   266,   291,   294,   267,
     246,   268,   274,   269,   270,   325,   271,  -153,   335,   339,
     352,   283,   357,   369,   287,   284,   341,   292,   293,   326,
     327,   329,   374,   328,   382,   383,   389,   342,   345,   405,
     343,   370,    25,   347,   349,   356,   248,   242,   362,   324,
     385,   387,   400,   388,   390,    95,   392,   178,   391,   338,
     397,   404,   413,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   147
};

static const short int yycheck[] =
{
     101,    43,   190,    71,   181,   158,    71,   293,    50,    44,
       5,    36,   336,    19,    36,    30,    21,    85,    43,     5,
     344,    19,    90,    54,    66,   281,    19,    20,    59,   353,
      23,   125,    30,    56,    19,    20,    59,    30,    23,    64,
     364,    56,    64,   329,    86,   222,   130,   131,   116,    55,
      19,    19,    20,   121,    96,    23,   342,    19,    19,   127,
     384,   238,    97,   251,   252,   253,    61,    92,    53,    19,
      56,   165,    65,    59,   330,   331,   362,    19,   402,   403,
      65,   182,    19,    19,    20,    53,   170,    23,   172,    58,
      19,   133,    54,   177,    19,    20,    57,    65,    23,   385,
      19,   387,    19,    20,    54,   130,    23,    19,   296,    22,
     287,    19,   265,   301,    19,    57,    13,    19,    19,    56,
      19,    58,    58,     0,    14,    62,    63,    64,    57,    65,
      30,    53,    29,   175,    30,    25,   178,    56,    35,    58,
      65,    58,    55,    62,    63,    64,    58,     3,    65,    54,
      62,    63,    64,     9,    53,   223,    56,   345,   223,   347,
      56,   262,   263,   264,   341,     4,   343,    19,    24,    25,
      26,    27,    28,    29,    53,    19,     9,   219,    22,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    13,    45,
      46,    24,    25,    26,    27,    28,    29,    19,    20,    21,
      21,    54,    54,    19,    29,    57,    59,    53,    30,    13,
      35,    55,    45,    46,    58,    31,    32,    33,    34,    35,
      36,    37,    38,    39,   266,    29,   380,    19,    54,    21,
      19,    35,    21,    59,    56,    53,    19,   391,    54,    19,
      19,    57,    31,    32,    33,    34,    19,    19,    37,    38,
      39,    31,    32,    33,    34,    53,    19,    56,    13,    57,
      59,    40,    41,    42,    43,    44,    55,    46,    47,    48,
      49,    50,    51,    52,    29,    55,   377,   378,    56,    56,
      35,    59,    59,   261,    55,    19,   264,    21,    19,    55,
      21,   392,   393,    19,   395,    21,   397,     5,     6,     7,
       8,     9,    19,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    19,    21,    31,    32,    33,    34,    55,    58,
      37,    38,    39,    55,    31,    32,    33,    34,    19,    37,
      38,     5,     6,     7,     8,     9,    19,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    19,    21,    21,    19,
      19,     5,    19,    19,    56,    61,    21,    31,    32,    33,
      34,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    19,    21,     5,     6,
       7,     8,     9,    19,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    21,    21,     5,     6,     7,     8,     9,
      21,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      21,    21,     5,     6,     7,     8,     9,    19,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    60,    21,     5,
       6,     7,     8,     9,    56,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    19,    21,     5,     6,    55,    55,
      19,    19,    11,    12,    13,    14,    15,    16,    17,    18,
       5,     6,    21,    55,     5,    19,    11,    12,    13,    14,
      15,    16,    17,    18,     5,     6,    21,    56,    20,    19,
      11,    12,    13,    14,    15,    16,    17,    18,    21,    19,
      21,    57,    57,    21,    57,    21,    19,    55,    55,    55,
      55,    19,    19,    19,    55,    58,    19,    57,    56,    56,
      30,    57,    24,    57,    57,    19,    19,    19,    19,    58,
      58,    58,    58,    58,    58,    19,    58,    24,    24,    58,
     183,    58,    53,    58,    58,    24,    58,    56,    19,    19,
      24,    56,    19,    30,    55,    59,    55,    57,    56,    56,
      56,    56,    19,    53,    24,    19,    24,    56,    56,    24,
      55,    53,    13,    56,    55,    55,   184,   180,    56,   273,
      56,    56,   383,    56,    53,    48,    58,   137,   374,   284,
      58,    57,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     3,     9,    24,    25,    26,    27,    28,    29,    45,
      46,    67,    68,    69,    70,    71,   111,   114,   116,    21,
      19,    19,    19,     0,    68,    70,   111,   114,   116,    69,
      53,     4,    53,    53,    53,    69,    19,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    54,    57,    73,    74,
      75,    79,    80,    82,   102,    21,    19,   112,   113,    19,
     117,    19,   115,    19,    21,    55,    75,   102,    19,    55,
      89,     5,     6,     7,     8,     9,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    21,    75,    91,    92,    93,
      94,    95,    89,    55,    54,    74,    37,    38,    91,    55,
      72,    58,    54,    59,    54,    59,    54,    59,   102,    19,
      91,    19,    19,    90,    19,    88,     5,    19,    93,    95,
       5,     5,    93,    91,    19,    61,    96,     5,    93,    19,
      19,    75,    97,    98,    99,    21,    91,    89,    19,    19,
      19,    20,    23,    65,   118,    21,    54,   113,    21,    19,
      54,    21,    19,    54,    56,    19,    55,    83,    60,    56,
      55,    19,    19,    19,    55,     5,    96,     5,    19,    55,
      75,    99,    19,    99,    91,    56,    19,    19,    97,    19,
      22,    55,    58,    76,    77,    78,    19,    20,    21,    30,
      56,    20,    57,    21,    57,    21,    57,    21,    53,    57,
     101,    19,    40,    41,    42,    43,    44,    46,    47,    48,
      49,    50,    51,    52,    84,    87,    19,    57,    90,    19,
      55,    81,    55,     5,     6,    19,    91,   105,   106,   107,
     108,    96,    19,   100,    99,    99,    19,    91,    55,    91,
      19,    53,    78,   105,    53,   118,    77,    19,    76,    57,
      30,    56,    56,    56,    30,    72,    57,    57,    57,    24,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    58,
      58,    58,    56,    59,    53,    91,    19,    19,   105,    19,
       5,    59,    19,    56,    59,    56,    59,    55,    19,   105,
      19,    24,    57,    56,    24,    30,    56,    72,    72,    72,
      30,    56,    19,    30,    85,    85,   118,   118,    19,    85,
      86,   118,    90,    91,    19,    21,    19,    21,    19,    21,
      19,    21,    19,    21,    87,    24,    56,    56,    53,    56,
      59,    59,   106,    22,    55,    19,   103,    10,   108,    19,
     105,    55,    56,    55,   103,    56,    72,    56,    72,    55,
      19,    57,    24,   103,   106,   106,    55,    19,    53,   104,
     118,   101,    56,   105,   103,   105,   101,    72,    72,    30,
      53,    19,    57,   101,    19,    19,    58,    62,    63,    64,
     109,   110,    24,    19,   103,    56,   101,    56,    56,    24,
      53,   109,    58,    58,   118,    58,   118,    58,    56,   110,
     104,   101,   103,   103,    57,    24,    56,   118,   118,   118,
     118,   101,   101,    57
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 689 "parse.y"
    { ; }
    break;

  case 3:
#line 690 "parse.y"
    { ; }
    break;

  case 4:
#line 691 "parse.y"
    { ; }
    break;

  case 5:
#line 692 "parse.y"
    { ; }
    break;

  case 6:
#line 695 "parse.y"
    {
			Node *node = node_new (CCODE_NODE,
					       "cctype", C_CCODE,
					       "cbuf:steal", ((yyvsp[0].cbuf))->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free((yyvsp[0].cbuf),FALSE);
					}
    break;

  case 7:
#line 704 "parse.y"
    {
			Node *node = node_new (CCODE_NODE,
					       "cctype", H_CCODE,
					       "cbuf:steal", ((yyvsp[0].cbuf))->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free((yyvsp[0].cbuf),FALSE);
					}
    break;

  case 8:
#line 713 "parse.y"
    {
			Node *node = node_new (CCODE_NODE,
					       "cctype", HT_CCODE,
					       "cbuf:steal", ((yyvsp[0].cbuf))->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free((yyvsp[0].cbuf),FALSE);
					}
    break;

  case 9:
#line 722 "parse.y"
    {
			Node *node = node_new (CCODE_NODE,
					       "cctype", PH_CCODE,
					       "cbuf:steal", ((yyvsp[0].cbuf))->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free((yyvsp[0].cbuf),FALSE);
					}
    break;

  case 10:
#line 731 "parse.y"
    {
			Node *node = node_new (CCODE_NODE,
					       "cctype", A_CCODE,
					       "cbuf:steal", ((yyvsp[0].cbuf))->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free((yyvsp[0].cbuf),FALSE);
					}
    break;

  case 11:
#line 740 "parse.y"
    {
			Node *node = node_new (CCODE_NODE,
					       "cctype", AT_CCODE,
					       "cbuf:steal", ((yyvsp[0].cbuf))->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free((yyvsp[0].cbuf),FALSE);
					}
    break;

  case 12:
#line 751 "parse.y"
    { ; }
    break;

  case 13:
#line 752 "parse.y"
    { ; }
    break;

  case 14:
#line 753 "parse.y"
    { ; }
    break;

  case 15:
#line 754 "parse.y"
    { ; }
    break;

  case 16:
#line 755 "parse.y"
    { ; }
    break;

  case 17:
#line 756 "parse.y"
    { ; }
    break;

  case 18:
#line 757 "parse.y"
    { ; }
    break;

  case 19:
#line 758 "parse.y"
    { ; }
    break;

  case 20:
#line 761 "parse.y"
    {
			((Class *)class)->nodes = class_nodes;
			class_nodes = NULL;
			nodes = g_list_append(nodes,class);
						}
    break;

  case 21:
#line 766 "parse.y"
    {
			((Class *)class)->nodes = NULL;
			class_nodes = NULL;
			nodes = g_list_append(nodes,class);
						}
    break;

  case 22:
#line 773 "parse.y"
    {
			class = node_new (CLASS_NODE,
					  "otype:steal", (yyvsp[-3].id),
					  "ptype:steal", (yyvsp[-1].id),
					  "bonobo_object_class:steal", bonobo_object_class,
					  "glade_xml", glade_xml,
					  "interfaces:steal", interfaces,
					  "chunk_size:steal", chunk_size,
					  "abstract", abstract,
					  NULL);
			bonobo_object_class = NULL;
			glade_xml = FALSE;
			chunk_size = NULL;
			interfaces = NULL;
						}
    break;

  case 24:
#line 791 "parse.y"
    {
			if(strcmp((yyvsp[-2].id),"abstract") == 0) {
				abstract = TRUE;
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;

  case 25:
#line 799 "parse.y"
    {
			if(strcmp((yyvsp[-3].id),"chunks") == 0) {
				g_free (chunk_size);
				chunk_size = g_strdup((yyvsp[-2].id));
			} else if(strcmp((yyvsp[-3].id),"BonoboObject") == 0) {
				g_free (bonobo_object_class);
				bonobo_object_class = g_strdup((yyvsp[-2].id));
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;

  case 26:
#line 811 "parse.y"
    {
			if (strcmp ((yyvsp[-3].id), "interface") == 0) {
				interfaces = g_list_append (interfaces,
							    g_strdup ((yyvsp[-2].id)));
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;

  case 27:
#line 820 "parse.y"
    {
			if(strcmp((yyvsp[-3].id),"chunks") == 0) {
				g_free (chunk_size);
				if(atoi((yyvsp[-2].id)) != 0)
					chunk_size = g_strdup((yyvsp[-2].id));
				else
					chunk_size = NULL;
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;

  case 28:
#line 832 "parse.y"
    {
			if (strcmp ((yyvsp[-4].id), "GladeXML") == 0) {
				glade_xml = TRUE;
				add_construct_glade((yyvsp[-3].id), (yyvsp[-2].id), NULL);
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;

  case 29:
#line 841 "parse.y"
    {
			if (strcmp ((yyvsp[-5].id), "GladeXML") == 0) {
				glade_xml = TRUE;
				add_construct_glade((yyvsp[-4].id), (yyvsp[-3].id), (yyvsp[-2].id));
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;

  case 30:
#line 850 "parse.y"
    {
			if (strcmp ((yyvsp[-4].id), "GladeXML") == 0) {
				glade_xml = TRUE;
				add_construct_glade((yyvsp[-3].id), (yyvsp[-2].id), NULL);
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;

  case 31:
#line 859 "parse.y"
    {
			if (strcmp ((yyvsp[-5].id), "GladeXML") == 0) {
				glade_xml = TRUE;
				add_construct_glade((yyvsp[-4].id), (yyvsp[-3].id), (yyvsp[-2].id));
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;

  case 32:
#line 870 "parse.y"
    { ; }
    break;

  case 33:
#line 871 "parse.y"
    { ; }
    break;

  case 34:
#line 874 "parse.y"
    { ; }
    break;

  case 35:
#line 875 "parse.y"
    {
			if (strcmp ((yyvsp[-1].id), "BonoboObject") != 0) {
				g_free ((yyvsp[-1].id));
				yyerror (_("parse error"));
				YYERROR;
			}
			g_free ((yyvsp[-1].id));
			last_added_method->bonobo_object_func = TRUE;
						}
    break;

  case 36:
#line 884 "parse.y"
    {
			if (strcmp ((yyvsp[-2].id), "interface") != 0) {
				g_free ((yyvsp[-2].id));
				g_free ((yyvsp[-1].id));
				yyerror (_("parse error"));
				YYERROR;
			}
			g_free ((yyvsp[-2].id));
			node_set ((Node *)last_added_method,
				  "interface:steal", (yyvsp[-1].id),
				  NULL);
						}
    break;

  case 37:
#line 896 "parse.y"
    { ; }
    break;

  case 38:
#line 897 "parse.y"
    { ; }
    break;

  case 39:
#line 898 "parse.y"
    { ; }
    break;

  case 40:
#line 899 "parse.y"
    { ; }
    break;

  case 41:
#line 902 "parse.y"
    { the_scope = PUBLIC_SCOPE; }
    break;

  case 42:
#line 903 "parse.y"
    { the_scope = PRIVATE_SCOPE; }
    break;

  case 43:
#line 904 "parse.y"
    { the_scope = PROTECTED_SCOPE; }
    break;

  case 44:
#line 905 "parse.y"
    { the_scope = CLASS_SCOPE; }
    break;

  case 45:
#line 908 "parse.y"
    {
			if (strcmp ((yyvsp[-1].id), "destroywith") == 0) {
				g_free ((yyvsp[-1].id));
				destructor_unref = FALSE;
				destructor = (yyvsp[0].id);
				destructor_line = line_no;
				destructor_simple = TRUE;
			} else if (strcmp ((yyvsp[-1].id), "unrefwith") == 0) {
				g_free ((yyvsp[-1].id));
				destructor_unref = TRUE;
				destructor = (yyvsp[0].id);
				destructor_line = line_no;
				destructor_simple = TRUE;
			} else {
				g_free ((yyvsp[-1].id));
				g_free ((yyvsp[0].id));
				yyerror (_("parse error"));
				YYERROR;
			}
				}
    break;

  case 46:
#line 928 "parse.y"
    {
			if (strcmp ((yyvsp[-2].id), "destroy") == 0) {
				g_free((yyvsp[-2].id));
				destructor_unref = FALSE;
				destructor = ((yyvsp[0].cbuf))->str;
				g_string_free((yyvsp[0].cbuf), FALSE);
				destructor_line = ccode_line;
				destructor_simple = FALSE;
			} else if (strcmp ((yyvsp[-2].id), "unref") == 0) {
				g_free ((yyvsp[-2].id));
				destructor_unref = TRUE;
				destructor = ((yyvsp[0].cbuf))->str;
				g_string_free ((yyvsp[0].cbuf), FALSE);
				destructor_line = ccode_line;
				destructor_simple = FALSE;
			} else {
				g_free ((yyvsp[-2].id));
				g_string_free ((yyvsp[0].cbuf), TRUE);
				yyerror (_("parse error"));
				YYERROR;
			}
					}
    break;

  case 47:
#line 952 "parse.y"
    {
			initializer = (yyvsp[0].id);
			initializer_line = ccode_line;
				}
    break;

  case 48:
#line 956 "parse.y"
    {
			initializer = ((yyvsp[0].cbuf))->str;
			initializer_line = ccode_line;
			g_string_free((yyvsp[0].cbuf), FALSE);
				}
    break;

  case 49:
#line 964 "parse.y"
    { ; }
    break;

  case 50:
#line 965 "parse.y"
    { ; }
    break;

  case 51:
#line 966 "parse.y"
    { destructor = NULL; }
    break;

  case 52:
#line 967 "parse.y"
    { initializer = NULL; }
    break;

  case 53:
#line 968 "parse.y"
    {
			if (strcmp ((yyvsp[0].id), "GladeXML") == 0) {
				glade_widget = TRUE;
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
					}
    break;

  case 54:
#line 976 "parse.y"
    {
			destructor = NULL;
			initializer = NULL;
					}
    break;

  case 55:
#line 982 "parse.y"
    {
			push_variable((yyvsp[-2].id), the_scope,(yyvsp[-4].line), NULL);
						}
    break;

  case 56:
#line 985 "parse.y"
    {
			push_variable((yyvsp[-3].id), the_scope, (yyvsp[-5].line), (yyvsp[-2].id));
						}
    break;

  case 57:
#line 990 "parse.y"
    {
			Node *node = NULL;
			if(strcmp((yyvsp[-6].id),"get")==0 &&
			   strcmp((yyvsp[-3].id),"set")==0) {
				Type *type = pop_type();
				g_free ((yyvsp[-6].id)); 
				g_free ((yyvsp[-3].id));
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", (yyvsp[-9].id),
						 "atype:steal", type,
						 "flags:steal", (yyvsp[-10].list),
						 "name:steal", (yyvsp[-8].id),
						 "get:steal", ((yyvsp[-4].cbuf))->str,
						 "get_line", (yyvsp[-5].line),
						 "set:steal", ((yyvsp[-1].cbuf))->str,
						 "set_line", (yyvsp[-2].line),
						 "line_no", (yyvsp[-11].line),
						 NULL);

				class_nodes = g_list_append(class_nodes,node);

				g_string_free ((yyvsp[-4].cbuf), FALSE);
				g_string_free ((yyvsp[-1].cbuf), FALSE);

			} else if(strcmp((yyvsp[-6].id),"set")==0 &&
				strcmp((yyvsp[-3].id),"get")==0) {
				Type *type = pop_type();
				g_free ((yyvsp[-6].id)); 
				g_free ((yyvsp[-3].id));
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", (yyvsp[-9].id),
						 "atype:steal", type,
						 "flags:steal", (yyvsp[-10].list),
						 "name:steal", (yyvsp[-8].id),
						 "get:steal", ((yyvsp[-1].cbuf))->str,
						 "get_line", (yyvsp[-2].line),
						 "set:steal", ((yyvsp[-4].cbuf))->str,
						 "set_line", (yyvsp[-5].line),
						 "line_no", (yyvsp[-11].line),
						 NULL);
				g_string_free ((yyvsp[-1].cbuf), FALSE);
				g_string_free ((yyvsp[-4].cbuf), FALSE);
				class_nodes = g_list_append(class_nodes,node);
			} else {
				g_free ((yyvsp[-9].id)); 
				g_free ((yyvsp[-8].id));
				g_free ((yyvsp[-6].id)); 
				g_free ((yyvsp[-3].id));
				g_list_foreach ((yyvsp[-10].list), (GFunc)g_free, NULL);
				g_list_free ((yyvsp[-10].list));
				g_string_free ((yyvsp[-1].cbuf), TRUE);
				g_string_free ((yyvsp[-4].cbuf), TRUE);
				yyerror (_("parse error"));
				YYERROR;
			}

			if ((yyvsp[-7].id) != NULL) {
				Argument *arg = (Argument *)node;
				export_accessors (arg->name,
						  arg->get != NULL, arg->get_line,
						  arg->set != NULL, arg->set_line,
						  arg->atype,
						  arg->gtktype,
						  arg->line_no);
				g_free ((yyvsp[-7].id));
			} 

						}
    break;

  case 58:
#line 1058 "parse.y"
    {
			Node *node = NULL;
			if(strcmp((yyvsp[-3].id), "get") == 0) {
				Type *type = pop_type();
				g_free ((yyvsp[-3].id));
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", (yyvsp[-6].id),
						 "atype:steal", type,
						 "flags:steal", (yyvsp[-7].list),
						 "name:steal", (yyvsp[-5].id),
						 "get:steal", ((yyvsp[-1].cbuf))->str,
						 "get_line", (yyvsp[-2].line),
						 "line_no", (yyvsp[-8].line),
						 NULL);

				g_string_free ((yyvsp[-1].cbuf), FALSE);
				class_nodes = g_list_append(class_nodes, node);
			} else if(strcmp((yyvsp[-3].id), "set") == 0) {
				Type *type = pop_type();
				g_free ((yyvsp[-3].id));
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", (yyvsp[-6].id),
						 "atype:steal", type,
						 "flags:steal", (yyvsp[-7].list),
						 "name:steal", (yyvsp[-5].id),
						 "set:steal", ((yyvsp[-1].cbuf))->str,
						 "set_line", (yyvsp[-2].line),
						 "line_no", (yyvsp[-8].line),
						 NULL);

				g_string_free ((yyvsp[-1].cbuf), FALSE);
				class_nodes = g_list_append (class_nodes, node);
			} else {
				g_free ((yyvsp[-3].id)); 
				g_free ((yyvsp[-6].id));
				g_free ((yyvsp[-5].id));
				g_list_foreach ((yyvsp[-7].list), (GFunc)g_free, NULL);
				g_list_free ((yyvsp[-7].list));
				g_string_free ((yyvsp[-1].cbuf), TRUE);
				yyerror(_("parse error"));
				YYERROR;
			}

			if ((yyvsp[-4].id) != NULL) {
				Argument *arg = (Argument *)node;
				export_accessors (arg->name,
						  arg->get != NULL, arg->get_line,
						  arg->set != NULL, arg->set_line,
						  arg->atype,
						  arg->gtktype,
						  arg->line_no);
				g_free ((yyvsp[-4].id));
			} 
						}
    break;

  case 59:
#line 1112 "parse.y"
    {
			Node *node;
			char *get, *set = NULL;
			Variable *var;
			Type *type;
			const char *root;
			
			if(strcmp((yyvsp[0].id), "link")!=0 &&
			   strcmp((yyvsp[0].id), "stringlink")!=0 && 
			   strcmp((yyvsp[0].id), "objectlink")!=0) {
				g_free((yyvsp[0].id)); 
				g_free((yyvsp[-3].id));
				g_free((yyvsp[-2].id));
				g_list_foreach((yyvsp[-4].list),(GFunc)g_free,NULL);
				g_list_free((yyvsp[-4].list));
				yyerror(_("parse error"));
				YYERROR;
			}

			type = pop_type();

			var = find_var_or_die((yyvsp[-2].id), (yyvsp[-5].line));
			if(var->scope == PRIVATE_SCOPE) {
				root = "self->_priv";
			} else if(var->scope == CLASS_SCOPE) {
				root = "SELF_GET_CLASS(self)";
				if(no_self_alias)
					error_print(GOB_ERROR, (yyvsp[-5].line),
						    _("Self aliases needed when autolinking to a classwide member"));
			} else {
				root = "self";
			}

			if(strcmp((yyvsp[0].id), "link")==0) {
				set = g_strdup_printf("%s->%s = ARG;",
						      root, (yyvsp[-2].id));
			} else if(strcmp((yyvsp[0].id), "stringlink")==0) {
				set = g_strdup_printf("g_free (%s->%s); "
						      "%s->%s = g_strdup (ARG);",
						      root, (yyvsp[-2].id),
						      root, (yyvsp[-2].id));
			} else if(strcmp((yyvsp[0].id), "objectlink")==0) {
				set = g_strdup_printf(
				  "if (ARG != NULL) "
				   "g_object_ref (G_OBJECT (ARG)); "
				  "if (%s->%s != NULL) "
				   "g_object_unref (G_OBJECT (%s->%s)); "
				  "%s->%s = ARG;",
				  root, (yyvsp[-2].id),
				  root, (yyvsp[-2].id),
				  root, (yyvsp[-2].id));
			} else {
				g_assert_not_reached();
			}

			get = g_strdup_printf("ARG = %s->%s;", root, (yyvsp[-2].id));
  
			g_free ((yyvsp[0].id));

			if (type == NULL)
				type = (Type *)node_copy ((Node *)var->vtype);

			node = node_new (ARGUMENT_NODE,
					 "gtktype:steal", (yyvsp[-3].id),
					 "atype:steal", type,
					 "flags:steal", (yyvsp[-4].list),
					 "name:steal", (yyvsp[-2].id),
					 "get:steal", get,
					 "get_line", (yyvsp[-5].line),
					 "set:steal", set,
					 "set_line", (yyvsp[-5].line),
					 "line_no", (yyvsp[-5].line),
					 NULL);

			if ((yyvsp[-1].id) != NULL) {
				Argument *arg = (Argument *)node;
				export_accessors (arg->name,
						  arg->get != NULL, arg->get_line,
						  arg->set != NULL, arg->set_line,
						  arg->atype,
						  arg->gtktype,
						  arg->line_no);
				g_free ((yyvsp[-1].id));
			} 

			class_nodes = g_list_append (class_nodes, node);
						}
    break;

  case 60:
#line 1201 "parse.y"
    {
			if (strcmp ((yyvsp[-1].id), "export")!=0) {
				g_free ((yyvsp[-1].id)); 
				yyerror (_("parse error"));
				YYERROR;
			}
			(yyval.id) = (yyvsp[-1].id);
						}
    break;

  case 61:
#line 1209 "parse.y"
    {
			(yyval.id) = NULL;
						}
    break;

  case 62:
#line 1214 "parse.y"
    {
			ensure_property ();
			node_set ((Node *)property,
				  "line_no", (yyvsp[-10].line),
				  "gtktype:steal", debool ((yyvsp[-9].id)),
				  "name:steal", (yyvsp[-8].id),
				  NULL);
			if (strcmp ((yyvsp[-6].id), "get") == 0 &&
			    strcmp ((yyvsp[-3].id), "set") == 0) {
				node_set ((Node *)property,
					  "get:steal", ((yyvsp[-4].cbuf))->str,
					  "get_line", (yyvsp[-5].line),
					  "set:steal", ((yyvsp[-1].cbuf))->str,
					  "set_line", (yyvsp[-2].line),
					  NULL);
				g_string_free ((yyvsp[-4].cbuf), FALSE);
				g_string_free ((yyvsp[-1].cbuf), FALSE);
				g_free ((yyvsp[-6].id)); 
				g_free ((yyvsp[-3].id));
			} else if (strcmp ((yyvsp[-6].id), "set") == 0 &&
				   strcmp ((yyvsp[-3].id), "get") == 0) {
				node_set ((Node *)property,
					  "get:steal", ((yyvsp[-1].cbuf))->str,
					  "get_line", (yyvsp[-2].line),
					  "set:steal", ((yyvsp[-4].cbuf))->str,
					  "set_line", (yyvsp[-5].line),
					  NULL);
				g_string_free ((yyvsp[-4].cbuf), FALSE);
				g_string_free ((yyvsp[-1].cbuf), FALSE);
				g_free ((yyvsp[-6].id)); 
				g_free ((yyvsp[-3].id));
			} else {
				g_string_free ((yyvsp[-4].cbuf), TRUE);
				g_string_free ((yyvsp[-1].cbuf), TRUE);
				g_free ((yyvsp[-6].id)); 
				g_free ((yyvsp[-3].id));
				node_free ((Node *)property);
				property = NULL;
				yyerror (_("parse error"));
				YYERROR;
			}
			property_link_and_export ((Node *)property);
			if (property != NULL) {
				class_nodes = g_list_append (class_nodes,
							     property);
				property = NULL;
			}
		}
    break;

  case 63:
#line 1262 "parse.y"
    {
			ensure_property ();
			node_set ((Node *)property,
				  "line_no", (yyvsp[-7].line),
				  "gtktype:steal", debool ((yyvsp[-6].id)),
				  "name:steal", (yyvsp[-5].id),
				  NULL);
			if (strcmp ((yyvsp[-3].id), "get") == 0) {
				node_set ((Node *)property,
					  "get:steal", ((yyvsp[-1].cbuf))->str,
					  "get_line", (yyvsp[-2].line),
					  NULL);
				g_string_free ((yyvsp[-1].cbuf), FALSE);
				g_free ((yyvsp[-3].id)); 
			} else if (strcmp ((yyvsp[-3].id), "set") == 0) {
				node_set ((Node *)property,
					  "set:steal", ((yyvsp[-1].cbuf))->str,
					  "set_line", (yyvsp[-2].line),
					  NULL);
				g_string_free ((yyvsp[-1].cbuf), FALSE);
				g_free ((yyvsp[-3].id)); 
			} else {
				g_string_free ((yyvsp[-1].cbuf), TRUE);
				g_free ((yyvsp[-3].id)); 
				node_free ((Node *)property);
				property = NULL;
				yyerror (_("parse error"));
				YYERROR;
			}
			property_link_and_export ((Node *)property);
			if (property != NULL) {
				class_nodes = g_list_append (class_nodes,
							     property);
				property = NULL;
			}
		}
    break;

  case 64:
#line 1298 "parse.y"
    {
			ensure_property ();
			node_set ((Node *)property,
				  "line_no", (yyvsp[-4].line),
				  "gtktype:steal", debool ((yyvsp[-3].id)),
				  "name:steal", (yyvsp[-2].id),
				  NULL);
			property_link_and_export ((Node *)property);
			if (property != NULL) {
				class_nodes = g_list_append (class_nodes,
							     property);
				property = NULL;
			}
		}
    break;

  case 65:
#line 1314 "parse.y"
    { ; }
    break;

  case 66:
#line 1315 "parse.y"
    { ; }
    break;

  case 67:
#line 1318 "parse.y"
    { ; }
    break;

  case 68:
#line 1319 "parse.y"
    { ; }
    break;

  case 69:
#line 1322 "parse.y"
    { (yyval.id) = (yyvsp[0].id); }
    break;

  case 70:
#line 1323 "parse.y"
    {
			if (strcmp ((yyvsp[-3].id), "_") != 0) {
				g_free ((yyvsp[-3].id));
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free ((yyvsp[-3].id));
			(yyval.id) = g_strconcat ("_(", (yyvsp[-1].id), ")", NULL);
			g_free ((yyvsp[-1].id));
		}
    break;

  case 71:
#line 1335 "parse.y"
    { (yyval.id) = (yyvsp[0].id); }
    break;

  case 72:
#line 1336 "parse.y"
    { (yyval.id) = (yyvsp[0].id); }
    break;

  case 73:
#line 1339 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "nick:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 74:
#line 1345 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "blurb:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 75:
#line 1351 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "maximum:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 76:
#line 1357 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "minimum:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 77:
#line 1363 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "default_value:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 78:
#line 1369 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "flags:steal", (yyvsp[0].list),
			  NULL);
		  }
    break;

  case 79:
#line 1375 "parse.y"
    {
		Type *type = pop_type ();
		ensure_property ();
		node_set ((Node *)property,
			  "ptype:steal", type,
			  NULL);
		  }
    break;

  case 80:
#line 1382 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 81:
#line 1388 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 82:
#line 1394 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 83:
#line 1400 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 84:
#line 1406 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 85:
#line 1412 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 86:
#line 1418 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 87:
#line 1424 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 88:
#line 1430 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 89:
#line 1436 "parse.y"
    {
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", (yyvsp[0].id),
			  NULL);
		  }
    break;

  case 90:
#line 1442 "parse.y"
    {
		ensure_property ();
		if (strcmp ((yyvsp[0].id), "override") == 0) {
			g_free((yyvsp[0].id));
			node_set ((Node *)property,
				  "override", TRUE,
				  NULL);
		} else if (strcmp ((yyvsp[0].id), "link") == 0) {
			g_free((yyvsp[0].id));
			node_set ((Node *)property,
				  "link", TRUE,
				  NULL);
		} else if (strcmp ((yyvsp[0].id), "export") == 0) {
			g_free((yyvsp[0].id));
			node_set ((Node *)property,
				  "export", TRUE,
				  NULL);
		} else {
			g_free((yyvsp[0].id));
			yyerror(_("parse error"));
			YYERROR;
		}
		  }
    break;

  case 91:
#line 1467 "parse.y"
    {
			if(strcmp((yyvsp[-2].id),"type")!=0) {
				g_free((yyvsp[-4].id));
				g_free((yyvsp[-2].id));
				yyerror(_("parse error"));
				YYERROR;
			}
			(yyval.id) = debool ((yyvsp[-4].id));
						}
    break;

  case 92:
#line 1476 "parse.y"
    {
			(yyval.id) = debool ((yyvsp[0].id));
			typestack = g_list_prepend(typestack,NULL);
						}
    break;

  case 93:
#line 1482 "parse.y"
    { (yyval.list) = (yyvsp[-1].list); }
    break;

  case 94:
#line 1483 "parse.y"
    { (yyval.list) = NULL; }
    break;

  case 95:
#line 1486 "parse.y"
    {
			(yyval.list) = g_list_append((yyvsp[0].list),(yyvsp[-2].id));
						}
    break;

  case 96:
#line 1489 "parse.y"
    {
			(yyval.list) = g_list_append(NULL,(yyvsp[0].id));
						}
    break;

  case 97:
#line 1495 "parse.y"
    {
			Node *node = node_new (TYPE_NODE, 
					       "name:steal", (yyvsp[-1].id),
					       "pointer:steal", (yyvsp[0].id),
					       NULL);
			typestack = g_list_prepend(typestack,node);
							}
    break;

  case 98:
#line 1502 "parse.y"
    {
			Node *node = node_new (TYPE_NODE, 
					       "name:steal", (yyvsp[0].id),
					       NULL);
			typestack = g_list_prepend(typestack,node);
							}
    break;

  case 99:
#line 1511 "parse.y"
    {
			(yyval.id) = (yyvsp[0].id);
							}
    break;

  case 100:
#line 1514 "parse.y"
    {
			(yyval.id) = (yyvsp[0].id);
							}
    break;

  case 101:
#line 1517 "parse.y"
    {
			(yyval.id) = g_strconcat("const ", (yyvsp[0].id), NULL);
			g_free((yyvsp[0].id));
							}
    break;

  case 102:
#line 1521 "parse.y"
    {
			(yyval.id) = g_strconcat((yyvsp[-1].id), " const", NULL);
			g_free((yyvsp[-1].id));
							}
    break;

  case 103:
#line 1525 "parse.y"
    {
			(yyval.id) = g_strconcat((yyvsp[-1].id), " ", (yyvsp[0].id), NULL);
			g_free((yyvsp[0].id));
							}
    break;

  case 104:
#line 1529 "parse.y"
    {
			(yyval.id) = g_strconcat("const ", (yyvsp[-1].id), " ",
					     (yyvsp[0].id), NULL);
			g_free((yyvsp[0].id));
							}
    break;

  case 105:
#line 1534 "parse.y"
    {
			(yyval.id) = g_strconcat((yyvsp[-2].id), " ",
					     (yyvsp[-1].id), " const", NULL);
			g_free((yyvsp[-1].id));
							}
    break;

  case 106:
#line 1542 "parse.y"
    {
			(yyval.id) = g_strconcat((yyvsp[-1].id), " ", (yyvsp[0].id), NULL);
			g_free((yyvsp[0].id));
							}
    break;

  case 107:
#line 1546 "parse.y"
    {
			(yyval.id) = g_strconcat((yyvsp[-1].id), " ", (yyvsp[0].id), NULL);
			g_free((yyvsp[-1].id));
			g_free((yyvsp[0].id));
							}
    break;

  case 108:
#line 1551 "parse.y"
    {
			(yyval.id) = g_strconcat("const ", (yyvsp[0].id), NULL);
			g_free((yyvsp[0].id));
							}
    break;

  case 109:
#line 1555 "parse.y"
    {
			(yyval.id) = (yyvsp[0].id);
							}
    break;

  case 110:
#line 1558 "parse.y"
    {
			(yyval.id) = g_strconcat((yyvsp[-1].id), " const", NULL);
			g_free((yyvsp[-1].id));
							}
    break;

  case 111:
#line 1562 "parse.y"
    {
			(yyval.id) = g_strdup((yyvsp[0].id));
							}
    break;

  case 112:
#line 1565 "parse.y"
    {
			(yyval.id) = g_strconcat((yyvsp[-1].id), " const", NULL);
							}
    break;

  case 113:
#line 1570 "parse.y"
    { (yyval.id) = "void"; }
    break;

  case 114:
#line 1571 "parse.y"
    { (yyval.id) = "char"; }
    break;

  case 115:
#line 1572 "parse.y"
    { (yyval.id) = "short"; }
    break;

  case 116:
#line 1573 "parse.y"
    { (yyval.id) = "int"; }
    break;

  case 117:
#line 1574 "parse.y"
    { (yyval.id) = "long"; }
    break;

  case 118:
#line 1575 "parse.y"
    { (yyval.id) = "float"; }
    break;

  case 119:
#line 1576 "parse.y"
    { (yyval.id) = "double"; }
    break;

  case 120:
#line 1577 "parse.y"
    { (yyval.id) = "signed"; }
    break;

  case 121:
#line 1578 "parse.y"
    { (yyval.id) = "unsigned"; }
    break;

  case 122:
#line 1581 "parse.y"
    { (yyval.id) = "struct"; }
    break;

  case 123:
#line 1582 "parse.y"
    { (yyval.id) = "union"; }
    break;

  case 124:
#line 1583 "parse.y"
    { (yyval.id) = "enum"; }
    break;

  case 125:
#line 1586 "parse.y"
    { (yyval.id) = g_strdup("*"); }
    break;

  case 126:
#line 1587 "parse.y"
    { (yyval.id) = g_strdup("* const"); }
    break;

  case 127:
#line 1588 "parse.y"
    {
				(yyval.id) = g_strconcat("*", (yyvsp[0].id), NULL);
				g_free((yyvsp[0].id));
					}
    break;

  case 128:
#line 1592 "parse.y"
    {
				(yyval.id) = g_strconcat("* const", (yyvsp[0].id), NULL);
				g_free((yyvsp[0].id));
					}
    break;

  case 129:
#line 1599 "parse.y"
    {
			if(strcmp((yyvsp[-1].id), "first")==0)
				(yyval.sigtype) = SIGNAL_FIRST_METHOD;
			else if(strcmp((yyvsp[-1].id), "last")==0)
				(yyval.sigtype) = SIGNAL_LAST_METHOD;
			else {
				yyerror(_("signal must be 'first' or 'last'"));
				g_free((yyvsp[-1].id));
				YYERROR;
			}
			g_free((yyvsp[-1].id));
					}
    break;

  case 130:
#line 1611 "parse.y"
    {
			(yyval.sigtype) = SIGNAL_LAST_METHOD;
					}
    break;

  case 131:
#line 1617 "parse.y"
    {
			if(strcmp((yyvsp[-1].id),"first")==0)
				(yyval.sigtype) = SIGNAL_FIRST_METHOD;
			else if(strcmp((yyvsp[-1].id),"last")==0)
				(yyval.sigtype) = SIGNAL_LAST_METHOD;
			else {
				yyerror(_("signal must be 'first' or 'last'"));
				g_free((yyvsp[-1].id));
				YYERROR;
			}
			g_free((yyvsp[-1].id));
					}
    break;

  case 132:
#line 1629 "parse.y"
    {
			if(strcmp((yyvsp[-2].id),"first")==0)
				(yyval.sigtype) = SIGNAL_FIRST_METHOD;
			else if(strcmp((yyvsp[-2].id),"last")==0)
				(yyval.sigtype) = SIGNAL_LAST_METHOD;
			else {
				yyerror(_("signal must be 'first' or 'last'"));
				g_free((yyvsp[-2].id));
				YYERROR;
			}
			g_free((yyvsp[-2].id));
					}
    break;

  case 133:
#line 1641 "parse.y"
    {
			(yyval.sigtype) = SIGNAL_LAST_METHOD;
					}
    break;

  case 134:
#line 1644 "parse.y"
    {
			/* the_scope was default thus public */
			the_scope = PUBLIC_SCOPE;
					}
    break;

  case 135:
#line 1650 "parse.y"
    {
			gtktypes = g_list_prepend(gtktypes, debool ((yyvsp[-3].id)));
						}
    break;

  case 136:
#line 1655 "parse.y"
    {
			gtktypes = g_list_append(gtktypes, debool ((yyvsp[0].id)));
						}
    break;

  case 137:
#line 1658 "parse.y"
    { 
			gtktypes = g_list_append(gtktypes, debool ((yyvsp[0].id)));
       						}
    break;

  case 138:
#line 1663 "parse.y"
    { (yyval.cbuf) = (yyvsp[0].cbuf); }
    break;

  case 139:
#line 1664 "parse.y"
    { (yyval.cbuf) = NULL; }
    break;

  case 140:
#line 1668 "parse.y"
    {
			if(!has_self) {
				yyerror(_("signal without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, (yyvsp[-7].sigtype),NULL,
				      (yyvsp[-5].id), (yyvsp[0].cbuf),(yyvsp[-9].line),
				      ccode_line, vararg, (yyvsp[-8].list));
									}
    break;

  case 141:
#line 1684 "parse.y"
    {
			if(!has_self) {
				yyerror(_("signal without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, (yyvsp[-7].sigtype), NULL,
				      (yyvsp[-5].id), (yyvsp[0].cbuf), (yyvsp[-9].line),
				      ccode_line, vararg, (yyvsp[-8].list));
									}
    break;

  case 142:
#line 1700 "parse.y"
    {
			if(!has_self) {
				yyerror(_("virtual method without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, VIRTUAL_METHOD, NULL, (yyvsp[-5].id),
				      (yyvsp[0].cbuf), (yyvsp[-8].line),
				      ccode_line, vararg, NULL);
									}
    break;

  case 143:
#line 1716 "parse.y"
    {
			if(!has_self) {
				yyerror(_("virtual method without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, VIRTUAL_METHOD, NULL, (yyvsp[-5].id),
				      (yyvsp[0].cbuf), (yyvsp[-7].line),
				      ccode_line, vararg, NULL);
									}
    break;

  case 144:
#line 1732 "parse.y"
    {
			if(!has_self) {
				yyerror(_("virtual method without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			push_function(PUBLIC_SCOPE, VIRTUAL_METHOD, NULL,
				      (yyvsp[-5].id), (yyvsp[0].cbuf), (yyvsp[-7].line),
				      ccode_line, vararg, NULL);
									}
    break;

  case 145:
#line 1743 "parse.y"
    {
			push_function(NO_SCOPE, OVERRIDE_METHOD, (yyvsp[-8].id),
				      (yyvsp[-5].id), (yyvsp[0].cbuf),
				      (yyvsp[-10].line), ccode_line,
				      vararg, NULL);
									}
    break;

  case 146:
#line 1749 "parse.y"
    {
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, REGULAR_METHOD, NULL, (yyvsp[-5].id),
				      (yyvsp[0].cbuf), (yyvsp[-7].line), ccode_line,
				      vararg, NULL);
								}
    break;

  case 147:
#line 1759 "parse.y"
    {
			if(strcmp((yyvsp[-4].id), "init")==0) {
				push_init_arg((yyvsp[-2].id),FALSE);
				push_function(NO_SCOPE, INIT_METHOD, NULL,
					      (yyvsp[-4].id), (yyvsp[0].cbuf), (yyvsp[-3].line),
					      ccode_line, FALSE, NULL);
			} else if(strcmp((yyvsp[-4].id), "class_init")==0) {
				push_init_arg((yyvsp[-2].id),TRUE);
				push_function(NO_SCOPE, CLASS_INIT_METHOD, NULL,
					      (yyvsp[-4].id), (yyvsp[0].cbuf), (yyvsp[-3].line),
					      ccode_line, FALSE, NULL);
			} else {
				g_free((yyvsp[-4].id));
				g_free((yyvsp[-2].id));
				g_string_free((yyvsp[0].cbuf),TRUE);
				yyerror(_("parse error "
					  "(untyped blocks must be init or "
					  "class_init)"));
				YYERROR;
			}
						}
    break;

  case 148:
#line 1782 "parse.y"
    {
			g_free(onerror); onerror = NULL;
			g_free(defreturn); defreturn = NULL;
			if(!set_return_value((yyvsp[-1].id), (yyvsp[0].id))) {
				g_free((yyvsp[-1].id));
				g_free((yyvsp[0].id));
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free((yyvsp[-1].id));
					}
    break;

  case 149:
#line 1793 "parse.y"
    {
			g_free(onerror); onerror = NULL;
			g_free(defreturn); defreturn = NULL;
			if(!set_return_value((yyvsp[-3].id), (yyvsp[-2].id))) {
				g_free((yyvsp[-3].id)); g_free((yyvsp[-2].id));
				g_free((yyvsp[-1].id)); g_free((yyvsp[0].id));
				yyerror(_("parse error"));
				YYERROR;
			}
			if(!set_return_value((yyvsp[-1].id), (yyvsp[0].id))) {
				onerror = defreturn = NULL;
				g_free((yyvsp[-3].id)); g_free((yyvsp[-2].id));
				g_free((yyvsp[-1].id)); g_free((yyvsp[0].id));
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free((yyvsp[-3].id));
			g_free((yyvsp[-1].id));
						}
    break;

  case 150:
#line 1812 "parse.y"
    {
			g_free(onerror); onerror = NULL;
			g_free(defreturn); defreturn = NULL;
					}
    break;

  case 151:
#line 1818 "parse.y"
    { (yyval.id) = (yyvsp[0].id); }
    break;

  case 152:
#line 1819 "parse.y"
    {
			(yyval.id) = ((yyvsp[0].cbuf))->str;
			g_string_free((yyvsp[0].cbuf), FALSE);
					}
    break;

  case 153:
#line 1825 "parse.y"
    { vararg = FALSE; has_self = FALSE; }
    break;

  case 154:
#line 1826 "parse.y"
    {
			vararg = FALSE;
			has_self = TRUE;
			if(strcmp((yyvsp[0].id),"self")==0)
				push_self((yyvsp[0].id), FALSE);
			else {
				g_free((yyvsp[0].id));
				yyerror(_("parse error"));
				YYERROR;
			}
       					}
    break;

  case 155:
#line 1837 "parse.y"
    {
			vararg = FALSE;
			has_self = TRUE;
			if(strcmp((yyvsp[-1].id),"self")==0)
				push_self((yyvsp[-1].id), TRUE);
			else {
				g_free((yyvsp[-1].id));
				yyerror(_("parse error"));
				YYERROR;
			}
       					}
    break;

  case 156:
#line 1848 "parse.y"
    {
			vararg = FALSE;
			has_self = TRUE;
			if(strcmp((yyvsp[0].id),"self")==0)
				push_self((yyvsp[0].id), TRUE);
			else {
				g_free((yyvsp[0].id));
				yyerror(_("parse error"));
				YYERROR;
			}
       					}
    break;

  case 157:
#line 1859 "parse.y"
    {
			has_self = TRUE;
			if(strcmp((yyvsp[-2].id),"self")==0)
				push_self((yyvsp[-2].id), FALSE);
			else {
				g_free((yyvsp[-2].id));
				yyerror(_("parse error"));
				YYERROR;
			}
					}
    break;

  case 158:
#line 1869 "parse.y"
    {
			has_self = TRUE;
			if(strcmp((yyvsp[-3].id),"self")==0)
				push_self((yyvsp[-3].id), TRUE);
			else {
				g_free((yyvsp[-3].id));
				yyerror(_("parse error"));
				YYERROR;
			}
					}
    break;

  case 159:
#line 1879 "parse.y"
    {
			has_self = TRUE;
			if(strcmp((yyvsp[-2].id),"self")==0)
				push_self((yyvsp[-2].id), TRUE);
			else {
				g_free((yyvsp[-2].id));
				yyerror(_("parse error"));
				YYERROR;
			}
					}
    break;

  case 160:
#line 1889 "parse.y"
    { has_self = FALSE; }
    break;

  case 161:
#line 1892 "parse.y"
    { vararg = TRUE; }
    break;

  case 162:
#line 1893 "parse.y"
    { vararg = FALSE; }
    break;

  case 163:
#line 1896 "parse.y"
    { ; }
    break;

  case 164:
#line 1897 "parse.y"
    { ; }
    break;

  case 165:
#line 1900 "parse.y"
    {
			push_funcarg((yyvsp[0].id),NULL);
								}
    break;

  case 166:
#line 1903 "parse.y"
    {
			push_funcarg((yyvsp[-1].id),(yyvsp[0].id));
								}
    break;

  case 167:
#line 1906 "parse.y"
    {
			if(strcmp((yyvsp[-2].id),"check")!=0) {
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free((yyvsp[-2].id));
			push_funcarg((yyvsp[-4].id),NULL);
								}
    break;

  case 168:
#line 1914 "parse.y"
    {
			if(strcmp((yyvsp[-2].id),"check")!=0) {
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free((yyvsp[-2].id));
			push_funcarg((yyvsp[-5].id),(yyvsp[-4].id));
								}
    break;

  case 169:
#line 1924 "parse.y"
    { ; }
    break;

  case 170:
#line 1925 "parse.y"
    { ; }
    break;

  case 171:
#line 1928 "parse.y"
    {
			if(strcmp((yyvsp[0].id),"type")==0) {
				Node *node = node_new (CHECK_NODE,
						       "chtype", TYPE_CHECK,
						       NULL);
				checks = g_list_append(checks,node);
			} else if(strcmp((yyvsp[0].id),"null")==0) {
				Node *node = node_new (CHECK_NODE,
						       "chtype", NULL_CHECK,
						       NULL);
				checks = g_list_append(checks,node);
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free((yyvsp[0].id));
					}
    break;

  case 172:
#line 1945 "parse.y"
    {
			Node *node = node_new (CHECK_NODE,
					       "chtype", GT_CHECK,
					       "number:steal", (yyvsp[0].id),
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;

  case 173:
#line 1952 "parse.y"
    {
			Node *node = node_new (CHECK_NODE,
					       "chtype", LT_CHECK,
					       "number:steal", (yyvsp[0].id),
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;

  case 174:
#line 1959 "parse.y"
    {
			Node *node = node_new (CHECK_NODE,
					       "chtype", GE_CHECK,
					       "number:steal", (yyvsp[0].id),
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;

  case 175:
#line 1966 "parse.y"
    {
			Node *node = node_new (CHECK_NODE,
					       "chtype", LE_CHECK,
					       "number:steal", (yyvsp[0].id),
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;

  case 176:
#line 1973 "parse.y"
    {
			Node *node = node_new (CHECK_NODE,
					       "chtype", EQ_CHECK,
					       "number:steal", (yyvsp[0].id),
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;

  case 177:
#line 1980 "parse.y"
    {
			Node *node = node_new (CHECK_NODE,
					       "chtype", NE_CHECK,
					       "number:steal", (yyvsp[0].id),
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;

  case 178:
#line 1989 "parse.y"
    {
			Node *node = node_new (ENUMDEF_NODE,
					       "etype:steal", (yyvsp[-1].id),
					       "prefix:steal", (yyvsp[-5].id),
					       "values:steal", enum_vals,
					       NULL);
			enum_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;

  case 179:
#line 1998 "parse.y"
    {
			Node *node = node_new (ENUMDEF_NODE,
					       "etype:steal", (yyvsp[-1].id),
					       "prefix:steal", (yyvsp[-6].id),
					       "values:steal", enum_vals,
					       NULL);
			enum_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;

  case 180:
#line 2009 "parse.y"
    {;}
    break;

  case 181:
#line 2010 "parse.y"
    {;}
    break;

  case 182:
#line 2013 "parse.y"
    {
			Node *node;
			char *num = (yyvsp[0].id);

			/* A float value, that's a bad enum */
			if (num[0] >= '0' &&
			    num[0] <= '9' &&
			    strchr (num, '.') != NULL) {
				g_free ((yyvsp[-2].id));
				g_free (num);
				yyerror(_("parse error (enumerator value not integer constant)"));
				YYERROR;
			}
		       
			node = node_new (ENUMVALUE_NODE,
					 "name:steal", (yyvsp[-2].id),
					 "value:steal", num,
					 NULL);
			enum_vals = g_list_append (enum_vals, node);
			}
    break;

  case 183:
#line 2033 "parse.y"
    {
			Node *node;

			node = node_new (ENUMVALUE_NODE,
					 "name:steal", (yyvsp[0].id),
					 NULL);
			enum_vals = g_list_append (enum_vals, node);
	}
    break;

  case 184:
#line 2043 "parse.y"
    {
			Node *node = node_new (FLAGS_NODE,
					       "ftype:steal", (yyvsp[-1].id),
					       "prefix:steal", (yyvsp[-5].id),
					       "values:steal", flag_vals,
					       NULL);
			flag_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;

  case 185:
#line 2052 "parse.y"
    {
			Node *node = node_new (FLAGS_NODE,
					       "ftype:steal", (yyvsp[-1].id),
					       "prefix:steal", (yyvsp[-6].id),
					       "values:steal", flag_vals,
					       NULL);
			flag_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;

  case 186:
#line 2063 "parse.y"
    {
			flag_vals = g_list_append (flag_vals, (yyvsp[0].id));
		}
    break;

  case 187:
#line 2066 "parse.y"
    {
			flag_vals = g_list_append (flag_vals, (yyvsp[0].id));
		}
    break;

  case 188:
#line 2071 "parse.y"
    {
			Node *node = node_new (ERROR_NODE,
					       "etype:steal", (yyvsp[-1].id),
					       "prefix:steal", (yyvsp[-5].id),
					       "values:steal", error_vals,
					       NULL);
			error_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;

  case 189:
#line 2080 "parse.y"
    {
			Node *node = node_new (ERROR_NODE,
					       "etype:steal", (yyvsp[-1].id),
					       "prefix:steal", (yyvsp[-6].id),
					       "values:steal", error_vals,
					       NULL);
			error_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;

  case 190:
#line 2091 "parse.y"
    {
			error_vals = g_list_append (error_vals, (yyvsp[0].id));
		}
    break;

  case 191:
#line 2094 "parse.y"
    {
			error_vals = g_list_append (error_vals, (yyvsp[0].id));
		}
    break;

  case 192:
#line 2100 "parse.y"
    { (yyval.id) = (yyvsp[0].id); }
    break;

  case 193:
#line 2101 "parse.y"
    {
			(yyval.id) = g_strconcat("-",(yyvsp[0].id),NULL);
			g_free((yyvsp[0].id));
					}
    break;

  case 194:
#line 2105 "parse.y"
    { (yyval.id) = (yyvsp[0].id); }
    break;

  case 195:
#line 2106 "parse.y"
    { (yyval.id) = (yyvsp[0].id); }
    break;


    }

/* Line 1037 of yacc.c.  */
#line 4252 "y.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {

		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 yydestruct ("Error: popping",
                             yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  yydestruct ("Error: discarding", yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping", yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token. */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yydestruct ("Error: discarding lookahead",
              yytoken, &yylval);
  yychar = YYEMPTY;
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 2109 "parse.y"


