/* Copyright (C) 2004 Bart
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
 
#include "../include/hfs.h"

namespace GParted
{

FS hfs::get_filesystem_support()
{
	FS fs ;
		
	fs .filesystem = GParted::FS_HFS ;
	
	fs .read = GParted::FS::LIBPARTED ; 
	fs .shrink = GParted::FS::LIBPARTED ; 

	if ( ! Glib::find_program_in_path( "hformat" ) .empty() )
		fs .create = GParted::FS::EXTERNAL ;
	
	if ( ! Glib::find_program_in_path( "hfsck" ) .empty() )
	{
		fs .get_label = FS::EXTERNAL ;
		fs .check = FS::EXTERNAL ;
	}

	fs .copy = GParted::FS::GPARTED ;
	fs .move = GParted::FS::GPARTED ;
	
	fs .MAX = 2048 * MEBIBYTE ;
	
	return fs ;
}

void hfs::set_used_sectors( Partition & partition ) 
{
}

void hfs::get_label( Partition & partition )
{
	if ( ! Utils::execute_command( "hfsck -v " + partition .get_path(), output, error, true ) )
	{
		char buf[512] ;
		index = output .find( "drVN" ) ;

		if ( index < output .length() && sscanf( output .substr( index ) .c_str(), "drVN = %512s", buf ) == 1 )
		{
			partition .label = buf ;
			
			//remove "" from the label..
			if ( partition .label .size() > 0 && partition .label[0] == '\"' )
				partition .label = partition .label .substr( 1 ) ;

			if ( partition .label .size() > 0 && partition .label[ partition .label .size() -1 ] == '\"' )
				partition .label = partition .label .substr( 0, partition .label .size() -1 ) ;
		}
	}
	else
	{
		if ( ! output .empty() )
			partition .messages .push_back( output ) ;
		
		if ( ! error .empty() )
			partition .messages .push_back( error ) ;
	}
}

bool hfs::create( const Partition & new_partition, OperationDetail & operationdetail )
{
	return ! execute_command( "hformat " + new_partition .get_path(), operationdetail ) ;
}

bool hfs::resize( const Partition & partition_new, OperationDetail & operationdetail, bool fill_partition )
{
	return true ;
}

bool hfs::copy( const Glib::ustring & src_part_path,
		const Glib::ustring & dest_part_path,
		OperationDetail & operationdetail )
{
	return true ;
}

bool hfs::check_repair( const Partition & partition, OperationDetail & operationdetail )
{
	//FIXME: find out what the returnvalue is in case of modified.. also check what the -a flag does.. (there is no manpage)
	return ! execute_command( "hfsck -v " + partition .get_path(), operationdetail ) ;
}

} //GParted


