/* searches.c generated by valac 0.16.0, the Vala compiler
 * generated from searches.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "gwibber.h"
#include <gee.h>
#include <json-glib/json-glib.h>


#define TYPE_SEARCHES_INTERFACE (searches_interface_get_type ())
#define SEARCHES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCHES_INTERFACE, SearchesInterface))
#define IS_SEARCHES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCHES_INTERFACE))
#define SEARCHES_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SEARCHES_INTERFACE, SearchesInterfaceIface))

typedef struct _SearchesInterface SearchesInterface;
typedef struct _SearchesInterfaceIface SearchesInterfaceIface;

#define TYPE_SEARCHES_INTERFACE_PROXY (searches_interface_proxy_get_type ())
typedef GDBusProxy SearchesInterfaceProxy;
typedef GDBusProxyClass SearchesInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __vala_JsonObject_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonObject_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __vala_JsonArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonArray_free (var), NULL)))

struct _SearchesInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*Get) (SearchesInterface* self, const gchar* id, GError** error);
	gchar* (*List) (SearchesInterface* self, GError** error);
	gchar* (*Create) (SearchesInterface* self, const gchar* query, GError** error);
	void (*Delete) (SearchesInterface* self, const gchar* id, GError** error);
};

struct _GwibberSearchesPrivate {
	SearchesInterface* searches;
	GwibberUtils* utils;
};


static gpointer gwibber_searches_parent_class = NULL;

GType searches_interface_proxy_get_type (void) G_GNUC_CONST;
guint searches_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType searches_interface_get_type (void) G_GNUC_CONST;
gchar* searches_interface_Get (SearchesInterface* self, const gchar* id, GError** error);
gchar* searches_interface_List (SearchesInterface* self, GError** error);
gchar* searches_interface_Create (SearchesInterface* self, const gchar* query, GError** error);
void searches_interface_Delete (SearchesInterface* self, const gchar* id, GError** error);
static void searches_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_searches_interface_updated (SearchesInterface* self, GVariant* parameters);
static void _dbus_handle_searches_interface_created (SearchesInterface* self, GVariant* parameters);
static void _dbus_handle_searches_interface_deleted (SearchesInterface* self, GVariant* parameters);
static gchar* searches_interface_proxy_Get (SearchesInterface* self, const gchar* id, GError** error);
static gchar* searches_interface_proxy_List (SearchesInterface* self, GError** error);
static gchar* searches_interface_proxy_Create (SearchesInterface* self, const gchar* query, GError** error);
static void searches_interface_proxy_Delete (SearchesInterface* self, const gchar* id, GError** error);
static void searches_interface_proxy_searches_interface_interface_init (SearchesInterfaceIface* iface);
static void _dbus_searches_interface_Get (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_searches_interface_List (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_searches_interface_Create (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_searches_interface_Delete (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void searches_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* searches_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean searches_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_searches_interface_updated (GObject* _sender, const gchar* account, gpointer* _data);
static void _dbus_searches_interface_created (GObject* _sender, const gchar* account, gpointer* _data);
static void _dbus_searches_interface_deleted (GObject* _sender, const gchar* account, gpointer* _data);
static void _searches_interface_unregister_object (gpointer user_data);
#define GWIBBER_SEARCHES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_SEARCHES, GwibberSearchesPrivate))
enum  {
	GWIBBER_SEARCHES_DUMMY_PROPERTY
};
#define GWIBBER_SEARCHES_searches_name "com.Gwibber.Searches"
#define GWIBBER_SEARCHES_searches_path "/com/gwibber/Searches"
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void _gwibber_searches_searches_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static void ___lambda7_ (GwibberSearches* self, const gchar* source);
static void ____lambda7__searches_interface_updated (SearchesInterface* _sender, const gchar* account, gpointer self);
static void ___lambda8_ (GwibberSearches* self, const gchar* source);
static void ____lambda8__searches_interface_created (SearchesInterface* _sender, const gchar* account, gpointer self);
static void ___lambda9_ (GwibberSearches* self, const gchar* source);
static void ____lambda9__searches_interface_deleted (SearchesInterface* _sender, const gchar* account, gpointer self);
static JsonObject* _vala_JsonObject_copy (JsonObject* self);
static void _vala_JsonObject_free (JsonObject* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static JsonArray* _vala_JsonArray_copy (JsonArray* self);
static void _vala_JsonArray_free (JsonArray* self);
static void gwibber_searches_finalize (GObject* obj);

static const GDBusArgInfo _searches_interface_dbus_arg_info_Get_id = {-1, "id", "s"};
static const GDBusArgInfo _searches_interface_dbus_arg_info_Get_result = {-1, "result", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Get_in[] = {&_searches_interface_dbus_arg_info_Get_id, NULL};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Get_out[] = {&_searches_interface_dbus_arg_info_Get_result, NULL};
static const GDBusMethodInfo _searches_interface_dbus_method_info_Get = {-1, "Get", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Get_in), (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Get_out)};
static const GDBusArgInfo _searches_interface_dbus_arg_info_List_result = {-1, "result", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_List_in[] = {NULL};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_List_out[] = {&_searches_interface_dbus_arg_info_List_result, NULL};
static const GDBusMethodInfo _searches_interface_dbus_method_info_List = {-1, "List", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_List_in), (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_List_out)};
static const GDBusArgInfo _searches_interface_dbus_arg_info_Create_query = {-1, "query", "s"};
static const GDBusArgInfo _searches_interface_dbus_arg_info_Create_result = {-1, "result", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Create_in[] = {&_searches_interface_dbus_arg_info_Create_query, NULL};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Create_out[] = {&_searches_interface_dbus_arg_info_Create_result, NULL};
static const GDBusMethodInfo _searches_interface_dbus_method_info_Create = {-1, "Create", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Create_in), (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Create_out)};
static const GDBusArgInfo _searches_interface_dbus_arg_info_Delete_id = {-1, "id", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Delete_in[] = {&_searches_interface_dbus_arg_info_Delete_id, NULL};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_Delete_out[] = {NULL};
static const GDBusMethodInfo _searches_interface_dbus_method_info_Delete = {-1, "Delete", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Delete_in), (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_Delete_out)};
static const GDBusMethodInfo * const _searches_interface_dbus_method_info[] = {&_searches_interface_dbus_method_info_Get, &_searches_interface_dbus_method_info_List, &_searches_interface_dbus_method_info_Create, &_searches_interface_dbus_method_info_Delete, NULL};
static const GDBusArgInfo _searches_interface_dbus_arg_info_updated_account = {-1, "account", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_updated[] = {&_searches_interface_dbus_arg_info_updated_account, NULL};
static const GDBusSignalInfo _searches_interface_dbus_signal_info_updated = {-1, "Updated", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_updated)};
static const GDBusArgInfo _searches_interface_dbus_arg_info_created_account = {-1, "account", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_created[] = {&_searches_interface_dbus_arg_info_created_account, NULL};
static const GDBusSignalInfo _searches_interface_dbus_signal_info_created = {-1, "Created", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_created)};
static const GDBusArgInfo _searches_interface_dbus_arg_info_deleted_account = {-1, "account", "s"};
static const GDBusArgInfo * const _searches_interface_dbus_arg_info_deleted[] = {&_searches_interface_dbus_arg_info_deleted_account, NULL};
static const GDBusSignalInfo _searches_interface_dbus_signal_info_deleted = {-1, "Deleted", (GDBusArgInfo **) (&_searches_interface_dbus_arg_info_deleted)};
static const GDBusSignalInfo * const _searches_interface_dbus_signal_info[] = {&_searches_interface_dbus_signal_info_updated, &_searches_interface_dbus_signal_info_created, &_searches_interface_dbus_signal_info_deleted, NULL};
static const GDBusPropertyInfo * const _searches_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _searches_interface_dbus_interface_info = {-1, "com.Gwibber.Searches", (GDBusMethodInfo **) (&_searches_interface_dbus_method_info), (GDBusSignalInfo **) (&_searches_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_searches_interface_dbus_property_info)};
static const GDBusInterfaceVTable _searches_interface_dbus_interface_vtable = {searches_interface_dbus_interface_method_call, searches_interface_dbus_interface_get_property, searches_interface_dbus_interface_set_property};

gchar* searches_interface_Get (SearchesInterface* self, const gchar* id, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEARCHES_INTERFACE_GET_INTERFACE (self)->Get (self, id, error);
}


gchar* searches_interface_List (SearchesInterface* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEARCHES_INTERFACE_GET_INTERFACE (self)->List (self, error);
}


gchar* searches_interface_Create (SearchesInterface* self, const gchar* query, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEARCHES_INTERFACE_GET_INTERFACE (self)->Create (self, query, error);
}


void searches_interface_Delete (SearchesInterface* self, const gchar* id, GError** error) {
	g_return_if_fail (self != NULL);
	SEARCHES_INTERFACE_GET_INTERFACE (self)->Delete (self, id, error);
}


static void searches_interface_base_init (SearchesInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("updated", TYPE_SEARCHES_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_signal_new ("created", TYPE_SEARCHES_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_signal_new ("deleted", TYPE_SEARCHES_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


GType searches_interface_get_type (void) {
	static volatile gsize searches_interface_type_id__volatile = 0;
	if (g_once_init_enter (&searches_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchesInterfaceIface), (GBaseInitFunc) searches_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType searches_interface_type_id;
		searches_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "SearchesInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (searches_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (searches_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) searches_interface_proxy_get_type);
		g_type_set_qdata (searches_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.Gwibber.Searches");
		g_type_set_qdata (searches_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) searches_interface_register_object);
		g_once_init_leave (&searches_interface_type_id__volatile, searches_interface_type_id);
	}
	return searches_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (SearchesInterfaceProxy, searches_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_SEARCHES_INTERFACE, searches_interface_proxy_searches_interface_interface_init) )
static void searches_interface_proxy_class_init (SearchesInterfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = searches_interface_proxy_g_signal;
}


static void _dbus_handle_searches_interface_updated (SearchesInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* account = NULL;
	GVariant* _tmp24_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp24_, NULL);
	g_variant_unref (_tmp24_);
	g_signal_emit_by_name (self, "updated", account);
	_g_free0 (account);
}


static void _dbus_handle_searches_interface_created (SearchesInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* account = NULL;
	GVariant* _tmp25_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp25_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	g_signal_emit_by_name (self, "created", account);
	_g_free0 (account);
}


static void _dbus_handle_searches_interface_deleted (SearchesInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* account = NULL;
	GVariant* _tmp26_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp26_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp26_, NULL);
	g_variant_unref (_tmp26_);
	g_signal_emit_by_name (self, "deleted", account);
	_g_free0 (account);
}


static void searches_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Updated") == 0) {
		_dbus_handle_searches_interface_updated ((SearchesInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "Created") == 0) {
		_dbus_handle_searches_interface_created ((SearchesInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "Deleted") == 0) {
		_dbus_handle_searches_interface_deleted ((SearchesInterface*) proxy, parameters);
	}
}


static void searches_interface_proxy_init (SearchesInterfaceProxy* self) {
}


static gchar* searches_interface_proxy_Get (SearchesInterface* self, const gchar* id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp27_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Searches", "Get");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp27_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp27_, NULL);
	g_variant_unref (_tmp27_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* searches_interface_proxy_List (SearchesInterface* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp28_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Searches", "List");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp28_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp28_, NULL);
	g_variant_unref (_tmp28_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* searches_interface_proxy_Create (SearchesInterface* self, const gchar* query, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp29_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Searches", "Create");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp29_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	g_object_unref (_reply_message);
	return _result;
}


static void searches_interface_proxy_Delete (SearchesInterface* self, const gchar* id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Searches", "Delete");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void searches_interface_proxy_searches_interface_interface_init (SearchesInterfaceIface* iface) {
	iface->Get = searches_interface_proxy_Get;
	iface->List = searches_interface_proxy_List;
	iface->Create = searches_interface_proxy_Create;
	iface->Delete = searches_interface_proxy_Delete;
}


static void _dbus_searches_interface_Get (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp30_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp30_, NULL);
	g_variant_unref (_tmp30_);
	result = searches_interface_Get (self, id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_searches_interface_List (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = searches_interface_List (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_searches_interface_Create (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp31_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp31_, NULL);
	g_variant_unref (_tmp31_);
	result = searches_interface_Create (self, query, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (query);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_searches_interface_Delete (SearchesInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp32_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp32_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp32_, NULL);
	g_variant_unref (_tmp32_);
	searches_interface_Delete (self, id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void searches_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Get") == 0) {
		_dbus_searches_interface_Get (object, parameters, invocation);
	} else if (strcmp (method_name, "List") == 0) {
		_dbus_searches_interface_List (object, parameters, invocation);
	} else if (strcmp (method_name, "Create") == 0) {
		_dbus_searches_interface_Create (object, parameters, invocation);
	} else if (strcmp (method_name, "Delete") == 0) {
		_dbus_searches_interface_Delete (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* searches_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean searches_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_searches_interface_updated (GObject* _sender, const gchar* account, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Searches", "Updated", _arguments, NULL);
}


static void _dbus_searches_interface_created (GObject* _sender, const gchar* account, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Searches", "Created", _arguments, NULL);
}


static void _dbus_searches_interface_deleted (GObject* _sender, const gchar* account, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Searches", "Deleted", _arguments, NULL);
}


guint searches_interface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_searches_interface_dbus_interface_info), &_searches_interface_dbus_interface_vtable, data, _searches_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "updated", (GCallback) _dbus_searches_interface_updated, data);
	g_signal_connect (object, "created", (GCallback) _dbus_searches_interface_created, data);
	g_signal_connect (object, "deleted", (GCallback) _dbus_searches_interface_deleted, data);
	return result;
}


static void _searches_interface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_searches_interface_updated, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_searches_interface_created, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_searches_interface_deleted, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _gwibber_searches_searches_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
	gwibber_searches_searches_available (self, up);
}


static void ___lambda7_ (GwibberSearches* self, const gchar* source) {
	const gchar* _tmp0_;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	gwibber_searches_search_updated (self, _tmp0_);
}


static void ____lambda7__searches_interface_updated (SearchesInterface* _sender, const gchar* account, gpointer self) {
	___lambda7_ (self, account);
}


static void ___lambda8_ (GwibberSearches* self, const gchar* source) {
	const gchar* _tmp0_;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	gwibber_searches_search_created (self, _tmp0_);
}


static void ____lambda8__searches_interface_created (SearchesInterface* _sender, const gchar* account, gpointer self) {
	___lambda8_ (self, account);
}


static void ___lambda9_ (GwibberSearches* self, const gchar* source) {
	const gchar* _tmp0_;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	gwibber_searches_search_deleted (self, _tmp0_);
}


static void ____lambda9__searches_interface_deleted (SearchesInterface* _sender, const gchar* account, gpointer self) {
	___lambda9_ (self, account);
}


GwibberSearches* gwibber_searches_construct (GType object_type) {
	GwibberSearches * self = NULL;
	GError * _inner_error_ = NULL;
	self = (GwibberSearches*) g_object_new (object_type, NULL);
	{
		SearchesInterface* _tmp0_ = NULL;
		SearchesInterface* _tmp1_;
		GwibberUtils* _tmp2_;
		GwibberUtils* _tmp3_;
		GwibberUtils* _tmp4_;
		SearchesInterface* _tmp5_;
		SearchesInterface* _tmp6_;
		SearchesInterface* _tmp7_;
		_tmp0_ = g_initable_new (TYPE_SEARCHES_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", GWIBBER_SEARCHES_searches_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GWIBBER_SEARCHES_searches_path, "g-interface-name", "com.Gwibber.Searches", NULL);
		_tmp1_ = (SearchesInterface*) _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch32_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->priv->searches);
		self->priv->searches = _tmp1_;
		_tmp2_ = gwibber_utils_new ();
		_g_object_unref0 (self->priv->utils);
		self->priv->utils = _tmp2_;
		_tmp3_ = self->priv->utils;
		gwibber_utils_setup (_tmp3_, GWIBBER_SEARCHES_searches_name, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch32_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = self->priv->utils;
		g_signal_connect_object (_tmp4_, "available", (GCallback) _gwibber_searches_searches_available_gwibber_utils_available, self, 0);
		_tmp5_ = self->priv->searches;
		g_signal_connect_object (_tmp5_, "updated", (GCallback) ____lambda7__searches_interface_updated, self, 0);
		_tmp6_ = self->priv->searches;
		g_signal_connect_object (_tmp6_, "created", (GCallback) ____lambda8__searches_interface_created, self, 0);
		_tmp7_ = self->priv->searches;
		g_signal_connect_object (_tmp7_, "deleted", (GCallback) ____lambda9__searches_interface_deleted, self, 0);
	}
	goto __finally32;
	__catch32_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = g_strconcat ("Unable to get Gwibber Searches: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		g_warning ("searches.vala:77: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally32:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


GwibberSearches* gwibber_searches_new (void) {
	return gwibber_searches_construct (GWIBBER_TYPE_SEARCHES);
}


/**
         * com.Gwibber.Searches
         **/
static JsonObject* _vala_JsonObject_copy (JsonObject* self) {
	return g_boxed_copy (json_object_get_type (), self);
}


static gpointer __vala_JsonObject_copy0 (gpointer self) {
	return self ? _vala_JsonObject_copy (self) : NULL;
}


static void _vala_JsonObject_free (JsonObject* self) {
	g_boxed_free (json_object_get_type (), self);
}


GeeHashMap* gwibber_searches_lookup (GwibberSearches* self, const gchar* id) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* searches_map;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	searches_map = _tmp0_;
	{
		SearchesInterface* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _result_;
		JsonParser* _tmp4_;
		JsonParser* parser;
		JsonParser* _tmp5_;
		const gchar* _tmp6_;
		JsonParser* _tmp7_;
		JsonNode* _tmp8_ = NULL;
		JsonObject* _tmp9_ = NULL;
		JsonObject* _tmp10_;
		JsonObject* obj;
		JsonObject* _tmp11_;
		GList* _tmp12_ = NULL;
		GList* members;
		GList* _tmp13_;
		_tmp1_ = self->priv->searches;
		_tmp2_ = id;
		_tmp3_ = searches_interface_Get (_tmp1_, _tmp2_, &_inner_error_);
		_result_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch33_g_error;
		}
		_tmp4_ = json_parser_new ();
		parser = _tmp4_;
		_tmp5_ = parser;
		_tmp6_ = _result_;
		json_parser_load_from_data (_tmp5_, _tmp6_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			_g_free0 (_result_);
			goto __catch33_g_error;
		}
		_tmp7_ = parser;
		_tmp8_ = json_parser_get_root (_tmp7_);
		_tmp9_ = json_node_get_object (_tmp8_);
		_tmp10_ = __vala_JsonObject_copy0 (_tmp9_);
		obj = _tmp10_;
		_tmp11_ = obj;
		_tmp12_ = json_object_get_members (_tmp11_);
		members = _tmp12_;
		_tmp13_ = members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp13_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				gchar* _tmp14_;
				gchar* member = NULL;
				_tmp14_ = g_strdup ((const gchar*) member_it->data);
				member = _tmp14_;
				{
					GeeHashMap* _tmp15_;
					const gchar* _tmp16_;
					JsonObject* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_ = NULL;
					_tmp15_ = searches_map;
					_tmp16_ = member;
					_tmp17_ = obj;
					_tmp18_ = member;
					_tmp19_ = json_object_get_string_member (_tmp17_, _tmp18_);
					gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp16_, _tmp19_);
					_g_free0 (member);
				}
			}
		}
		_g_list_free0 (members);
		__vala_JsonObject_free0 (obj);
		_g_object_unref0 (parser);
		_g_free0 (_result_);
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("searches.vala:102: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (searches_map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = searches_map;
	return result;
}


/**
         * com.Gwibber.Searches
         **/
void gwibber_searches_delete (GwibberSearches* self, const gchar* id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	{
		SearchesInterface* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->searches;
		_tmp1_ = id;
		searches_interface_Delete (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch34_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally34;
	__catch34_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("searches.vala:118: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally34:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	return;
}


/**
         * com.Gwibber.Searches
         **/
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


gchar* gwibber_searches_create (GwibberSearches* self, const gchar* name, const gchar* query) {
	gchar* result = NULL;
	GList* _tmp0_ = NULL;
	GList* searches_list;
	GList* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = gwibber_searches_list (self);
	searches_list = _tmp0_;
	_tmp1_ = searches_list;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp1_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			GeeHashMap* _tmp2_;
			GeeHashMap* s = NULL;
			_tmp2_ = _g_object_ref0 ((GeeHashMap*) s_it->data);
			s = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				GeeHashMap* _tmp4_;
				gpointer _tmp5_ = NULL;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp13_;
				_tmp4_ = s;
				_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, "name");
				_tmp6_ = (gchar*) _tmp5_;
				_tmp7_ = name;
				_tmp8_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
				_g_free0 (_tmp6_);
				if (_tmp8_) {
					GeeHashMap* _tmp9_;
					gpointer _tmp10_ = NULL;
					gchar* _tmp11_;
					const gchar* _tmp12_;
					_tmp9_ = s;
					_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, "query");
					_tmp11_ = (gchar*) _tmp10_;
					_tmp12_ = query;
					_tmp3_ = g_strcmp0 (_tmp11_, _tmp12_) == 0;
					_g_free0 (_tmp11_);
				} else {
					_tmp3_ = FALSE;
				}
				_tmp13_ = _tmp3_;
				if (_tmp13_) {
					GeeHashMap* _tmp14_;
					gpointer _tmp15_ = NULL;
					gchar* _tmp16_;
					GeeHashMap* _tmp17_;
					gpointer _tmp18_ = NULL;
					g_debug ("searches.vala:134: search stream exists, updating");
					_tmp14_ = s;
					_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, "id");
					_tmp16_ = (gchar*) _tmp15_;
					g_signal_emit_by_name (self, "updated", _tmp16_);
					_g_free0 (_tmp16_);
					_tmp17_ = s;
					_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, "id");
					result = (gchar*) _tmp18_;
					_g_object_unref0 (s);
					__g_list_free__g_object_unref0_0 (searches_list);
					return result;
				}
				_g_object_unref0 (s);
			}
		}
	}
	{
		SearchesInterface* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp19_ = self->priv->searches;
		_tmp20_ = query;
		_tmp21_ = g_strconcat ("{\"query\": \"", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, "\", \"name\": \"", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = name;
		_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, "\"}", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = searches_interface_Create (_tmp19_, _tmp29_, &_inner_error_);
		_tmp31_ = _tmp30_;
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_tmp32_ = _tmp31_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch35_g_io_error;
			}
			__g_list_free__g_object_unref0_0 (searches_list);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp32_;
		__g_list_free__g_object_unref0_0 (searches_list);
		return result;
	}
	goto __finally35;
	__catch35_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_warning ("searches.vala:146: %s", _tmp34_);
		_tmp35_ = g_strdup ("");
		result = _tmp35_;
		_g_error_free0 (e);
		__g_list_free__g_object_unref0_0 (searches_list);
		return result;
	}
	__finally35:
	__g_list_free__g_object_unref0_0 (searches_list);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
         * com.Gwibber.Searches
         **/
static JsonArray* _vala_JsonArray_copy (JsonArray* self) {
	return g_boxed_copy (json_array_get_type (), self);
}


static gpointer __vala_JsonArray_copy0 (gpointer self) {
	return self ? _vala_JsonArray_copy (self) : NULL;
}


static void _vala_JsonArray_free (JsonArray* self) {
	g_boxed_free (json_array_get_type (), self);
}


GList* gwibber_searches_list (GwibberSearches* self) {
	GList* result = NULL;
	GList* searches_list;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	searches_list = NULL;
	{
		SearchesInterface* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _result_;
		JsonParser* _tmp2_;
		JsonParser* parser;
		JsonParser* _tmp3_;
		const gchar* _tmp4_;
		JsonParser* _tmp5_;
		JsonNode* _tmp6_ = NULL;
		JsonArray* _tmp7_ = NULL;
		JsonArray* _tmp8_;
		JsonArray* nodeArray;
		_tmp0_ = self->priv->searches;
		_tmp1_ = searches_interface_List (_tmp0_, &_inner_error_);
		_result_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch36_g_error;
		}
		_tmp2_ = json_parser_new ();
		parser = _tmp2_;
		_tmp3_ = parser;
		_tmp4_ = _result_;
		json_parser_load_from_data (_tmp3_, _tmp4_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			_g_free0 (_result_);
			goto __catch36_g_error;
		}
		_tmp5_ = parser;
		_tmp6_ = json_parser_get_root (_tmp5_);
		_tmp7_ = json_node_get_array (_tmp6_);
		_tmp8_ = __vala_JsonArray_copy0 (_tmp7_);
		nodeArray = _tmp8_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					gboolean _tmp10_;
					gint _tmp12_;
					JsonArray* _tmp13_;
					guint _tmp14_ = 0U;
					GeeHashMap* _tmp15_;
					GeeHashMap* searches_map;
					JsonArray* _tmp16_;
					gint _tmp17_;
					JsonNode* _tmp18_ = NULL;
					JsonObject* _tmp19_ = NULL;
					GList* _tmp20_ = NULL;
					GList* members;
					GList* _tmp21_;
					GeeHashMap* _tmp31_;
					GeeHashMap* _tmp32_;
					_tmp10_ = _tmp9_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp12_ = i;
					_tmp13_ = nodeArray;
					_tmp14_ = json_array_get_length (_tmp13_);
					if (!(((guint) _tmp12_) < _tmp14_)) {
						break;
					}
					_tmp15_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
					searches_map = _tmp15_;
					_tmp16_ = nodeArray;
					_tmp17_ = i;
					_tmp18_ = json_array_get_element (_tmp16_, (guint) _tmp17_);
					_tmp19_ = json_node_get_object (_tmp18_);
					_tmp20_ = json_object_get_members (_tmp19_);
					members = _tmp20_;
					_tmp21_ = members;
					{
						GList* member_collection = NULL;
						GList* member_it = NULL;
						member_collection = _tmp21_;
						for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
							gchar* _tmp22_;
							gchar* member = NULL;
							_tmp22_ = g_strdup ((const gchar*) member_it->data);
							member = _tmp22_;
							{
								GeeHashMap* _tmp23_;
								const gchar* _tmp24_;
								JsonArray* _tmp25_;
								gint _tmp26_;
								JsonNode* _tmp27_ = NULL;
								JsonObject* _tmp28_ = NULL;
								const gchar* _tmp29_;
								const gchar* _tmp30_ = NULL;
								_tmp23_ = searches_map;
								_tmp24_ = member;
								_tmp25_ = nodeArray;
								_tmp26_ = i;
								_tmp27_ = json_array_get_element (_tmp25_, (guint) _tmp26_);
								_tmp28_ = json_node_get_object (_tmp27_);
								_tmp29_ = member;
								_tmp30_ = json_object_get_string_member (_tmp28_, _tmp29_);
								gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp24_, _tmp30_);
								_g_free0 (member);
							}
						}
					}
					_tmp31_ = searches_map;
					_tmp32_ = _g_object_ref0 (_tmp31_);
					searches_list = g_list_append (searches_list, _tmp32_);
					_g_list_free0 (members);
					_g_object_unref0 (searches_map);
				}
			}
		}
		__vala_JsonArray_free0 (nodeArray);
		_g_object_unref0 (parser);
		_g_free0 (_result_);
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_warning ("searches.vala:176: %s", _tmp34_);
		_g_error_free0 (e);
	}
	__finally36:
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (searches_list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = searches_list;
	return result;
}


void gwibber_searches_search_deleted (GwibberSearches* self, const gchar* data) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	{
		JsonParser* _tmp0_;
		JsonParser* parser;
		const gchar* _tmp1_;
		JsonNode* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_;
		JsonObject* root_object;
		JsonObject* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* id;
		const gchar* _tmp8_;
		_tmp0_ = json_parser_new ();
		parser = _tmp0_;
		_tmp1_ = data;
		json_parser_load_from_data (parser, _tmp1_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			goto __catch37_g_error;
		}
		_tmp2_ = json_parser_get_root (parser);
		_tmp3_ = json_node_get_object (_tmp2_);
		_tmp4_ = __vala_JsonObject_copy0 (_tmp3_);
		root_object = _tmp4_;
		_tmp5_ = root_object;
		_tmp6_ = json_object_get_string_member (_tmp5_, "id");
		_tmp7_ = g_strdup (_tmp6_);
		id = _tmp7_;
		_tmp8_ = id;
		g_signal_emit_by_name (self, "deleted", _tmp8_);
		_g_free0 (id);
		__vala_JsonObject_free0 (root_object);
		_g_object_unref0 (parser);
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("searches.vala:190: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally37:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_searches_search_created (GwibberSearches* self, const gchar* data) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	{
		JsonParser* _tmp0_;
		JsonParser* parser;
		const gchar* _tmp1_;
		JsonNode* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_;
		JsonObject* root_object;
		JsonObject* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* id;
		const gchar* _tmp8_;
		_tmp0_ = json_parser_new ();
		parser = _tmp0_;
		_tmp1_ = data;
		json_parser_load_from_data (parser, _tmp1_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			goto __catch38_g_error;
		}
		_tmp2_ = json_parser_get_root (parser);
		_tmp3_ = json_node_get_object (_tmp2_);
		_tmp4_ = __vala_JsonObject_copy0 (_tmp3_);
		root_object = _tmp4_;
		_tmp5_ = root_object;
		_tmp6_ = json_object_get_string_member (_tmp5_, "id");
		_tmp7_ = g_strdup (_tmp6_);
		id = _tmp7_;
		_tmp8_ = id;
		g_signal_emit_by_name (self, "created", _tmp8_);
		_g_free0 (id);
		__vala_JsonObject_free0 (root_object);
		_g_object_unref0 (parser);
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("searches.vala:203: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally38:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_searches_search_updated (GwibberSearches* self, const gchar* data) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	{
		JsonParser* _tmp0_;
		JsonParser* parser;
		const gchar* _tmp1_;
		JsonNode* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_;
		JsonObject* root_object;
		JsonObject* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* id;
		const gchar* _tmp8_;
		_tmp0_ = json_parser_new ();
		parser = _tmp0_;
		_tmp1_ = data;
		json_parser_load_from_data (parser, _tmp1_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			goto __catch39_g_error;
		}
		_tmp2_ = json_parser_get_root (parser);
		_tmp3_ = json_node_get_object (_tmp2_);
		_tmp4_ = __vala_JsonObject_copy0 (_tmp3_);
		root_object = _tmp4_;
		_tmp5_ = root_object;
		_tmp6_ = json_object_get_string_member (_tmp5_, "id");
		_tmp7_ = g_strdup (_tmp6_);
		id = _tmp7_;
		_tmp8_ = id;
		g_signal_emit_by_name (self, "updated", _tmp8_);
		_g_free0 (id);
		__vala_JsonObject_free0 (root_object);
		_g_object_unref0 (parser);
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("searches.vala:216: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally39:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_searches_searches_available (GwibberSearches* self, gboolean is_up) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_up;
	g_signal_emit_by_name (self, "is-available", _tmp0_);
}


static void gwibber_searches_class_init (GwibberSearchesClass * klass) {
	gwibber_searches_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberSearchesPrivate));
	G_OBJECT_CLASS (klass)->finalize = gwibber_searches_finalize;
	/** 
	            Searches::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.Searches availability state changes
	*/
	g_signal_new ("is_available", GWIBBER_TYPE_SEARCHES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	g_signal_new ("updated", GWIBBER_TYPE_SEARCHES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("deleted", GWIBBER_TYPE_SEARCHES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("created", GWIBBER_TYPE_SEARCHES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void gwibber_searches_instance_init (GwibberSearches * self) {
	self->priv = GWIBBER_SEARCHES_GET_PRIVATE (self);
}


static void gwibber_searches_finalize (GObject* obj) {
	GwibberSearches * self;
	self = GWIBBER_SEARCHES (obj);
	_g_object_unref0 (self->priv->searches);
	_g_object_unref0 (self->priv->utils);
	G_OBJECT_CLASS (gwibber_searches_parent_class)->finalize (obj);
}


GType gwibber_searches_get_type (void) {
	static volatile gsize gwibber_searches_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_searches_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberSearchesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_searches_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberSearches), 0, (GInstanceInitFunc) gwibber_searches_instance_init, NULL };
		GType gwibber_searches_type_id;
		gwibber_searches_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberSearches", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_searches_type_id__volatile, gwibber_searches_type_id);
	}
	return gwibber_searches_type_id__volatile;
}



