/* test-utils.c generated by valac 0.16.1, the Vala compiler
 * generated from test-utils.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken@vandine.org>
 */

#include <glib.h>
#include <glib-object.h>
#include <gwibber.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define GWIBBER_TEST_TYPE_UTILS_SUITE (gwibber_test_utils_suite_get_type ())
#define GWIBBER_TEST_UTILS_SUITE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TEST_TYPE_UTILS_SUITE, GwibberTestUtilsSuite))
#define GWIBBER_TEST_UTILS_SUITE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TEST_TYPE_UTILS_SUITE, GwibberTestUtilsSuiteClass))
#define GWIBBER_TEST_IS_UTILS_SUITE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TEST_TYPE_UTILS_SUITE))
#define GWIBBER_TEST_IS_UTILS_SUITE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TEST_TYPE_UTILS_SUITE))
#define GWIBBER_TEST_UTILS_SUITE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TEST_TYPE_UTILS_SUITE, GwibberTestUtilsSuiteClass))

typedef struct _GwibberTestUtilsSuite GwibberTestUtilsSuite;
typedef struct _GwibberTestUtilsSuiteClass GwibberTestUtilsSuiteClass;
typedef struct _GwibberTestUtilsSuitePrivate GwibberTestUtilsSuitePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GwibberTestParamSpecUtilsSuite GwibberTestParamSpecUtilsSuite;

struct _GwibberTestUtilsSuite {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GwibberTestUtilsSuitePrivate * priv;
};

struct _GwibberTestUtilsSuiteClass {
	GTypeClass parent_class;
	void (*finalize) (GwibberTestUtilsSuite *self);
};

struct _GwibberTestParamSpecUtilsSuite {
	GParamSpec parent_instance;
};


static gpointer gwibber_test_utils_suite_parent_class = NULL;

gpointer gwibber_test_utils_suite_ref (gpointer instance);
void gwibber_test_utils_suite_unref (gpointer instance);
GParamSpec* gwibber_test_param_spec_utils_suite (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gwibber_test_value_set_utils_suite (GValue* value, gpointer v_object);
void gwibber_test_value_take_utils_suite (GValue* value, gpointer v_object);
gpointer gwibber_test_value_get_utils_suite (const GValue* value);
GType gwibber_test_utils_suite_get_type (void) G_GNUC_CONST;
enum  {
	GWIBBER_TEST_UTILS_SUITE_DUMMY_PROPERTY
};
GwibberTestUtilsSuite* gwibber_test_utils_suite_new (void);
GwibberTestUtilsSuite* gwibber_test_utils_suite_construct (GType object_type);
void gwibber_test_utils_suite_test_time_string_seconds (void);
static void _gwibber_test_utils_suite_test_time_string_seconds_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_minute (void);
static void _gwibber_test_utils_suite_test_time_string_minute_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_minutes (void);
static void _gwibber_test_utils_suite_test_time_string_minutes_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_hour (void);
static void _gwibber_test_utils_suite_test_time_string_hour_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_hours (void);
static void _gwibber_test_utils_suite_test_time_string_hours_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_day (void);
static void _gwibber_test_utils_suite_test_time_string_day_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_days (void);
static void _gwibber_test_utils_suite_test_time_string_days_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_avatar_path (void);
static void _gwibber_test_utils_suite_test_avatar_path_gtest_data_func (gpointer self);
static void gwibber_test_utils_suite_finalize (GwibberTestUtilsSuite* obj);


static void _gwibber_test_utils_suite_test_time_string_seconds_gtest_data_func (gpointer self) {
#line 28 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	gwibber_test_utils_suite_test_time_string_seconds ();
#line 100 "test-utils.c"
}


static void _gwibber_test_utils_suite_test_time_string_minute_gtest_data_func (gpointer self) {
#line 30 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	gwibber_test_utils_suite_test_time_string_minute ();
#line 107 "test-utils.c"
}


static void _gwibber_test_utils_suite_test_time_string_minutes_gtest_data_func (gpointer self) {
#line 32 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	gwibber_test_utils_suite_test_time_string_minutes ();
#line 114 "test-utils.c"
}


static void _gwibber_test_utils_suite_test_time_string_hour_gtest_data_func (gpointer self) {
#line 34 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	gwibber_test_utils_suite_test_time_string_hour ();
#line 121 "test-utils.c"
}


static void _gwibber_test_utils_suite_test_time_string_hours_gtest_data_func (gpointer self) {
#line 36 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	gwibber_test_utils_suite_test_time_string_hours ();
#line 128 "test-utils.c"
}


static void _gwibber_test_utils_suite_test_time_string_day_gtest_data_func (gpointer self) {
#line 38 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	gwibber_test_utils_suite_test_time_string_day ();
#line 135 "test-utils.c"
}


static void _gwibber_test_utils_suite_test_time_string_days_gtest_data_func (gpointer self) {
#line 40 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	gwibber_test_utils_suite_test_time_string_days ();
#line 142 "test-utils.c"
}


static void _gwibber_test_utils_suite_test_avatar_path_gtest_data_func (gpointer self) {
#line 42 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	gwibber_test_utils_suite_test_avatar_path ();
#line 149 "test-utils.c"
}


GwibberTestUtilsSuite* gwibber_test_utils_suite_construct (GType object_type) {
	GwibberTestUtilsSuite* self = NULL;
#line 26 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	self = (GwibberTestUtilsSuite*) g_type_create_instance (object_type);
#line 28 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_seconds", NULL, _gwibber_test_utils_suite_test_time_string_seconds_gtest_data_func);
#line 30 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_minute", NULL, _gwibber_test_utils_suite_test_time_string_minute_gtest_data_func);
#line 32 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_minutes", NULL, _gwibber_test_utils_suite_test_time_string_minutes_gtest_data_func);
#line 34 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_hour", NULL, _gwibber_test_utils_suite_test_time_string_hour_gtest_data_func);
#line 36 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_hours", NULL, _gwibber_test_utils_suite_test_time_string_hours_gtest_data_func);
#line 38 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_day", NULL, _gwibber_test_utils_suite_test_time_string_day_gtest_data_func);
#line 40 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_days", NULL, _gwibber_test_utils_suite_test_time_string_days_gtest_data_func);
#line 42 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_test_add_data_func ("/Unit/Gwibber/Utils/avatar_path", NULL, _gwibber_test_utils_suite_test_avatar_path_gtest_data_func);
#line 26 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	return self;
#line 175 "test-utils.c"
}


GwibberTestUtilsSuite* gwibber_test_utils_suite_new (void) {
#line 26 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	return gwibber_test_utils_suite_construct (GWIBBER_TEST_TYPE_UTILS_SUITE);
#line 182 "test-utils.c"
}


static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2552 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	gmtime_r (&time, &_tmp0_);
#line 2552 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2553 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2553 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	return;
#line 197 "test-utils.c"
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2557 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 2557 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2558 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2558 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	return;
#line 212 "test-utils.c"
}


void gwibber_test_utils_suite_test_time_string_seconds (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
#line 48 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp0_ = gwibber_utils_new ();
#line 48 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	utils = _tmp0_;
#line 49 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp1_ = time (NULL);
#line 49 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_t = _tmp1_;
#line 50 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_gm (_t, &_tmp2_);
#line 50 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n = _tmp2_;
#line 51 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_local (_t, &_tmp3_);
#line 51 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	lt = _tmp3_;
#line 52 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp4_ = lt;
#line 52 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp5_ = _tmp4_.tm_isdst;
#line 52 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n.tm_isdst = _tmp5_;
#line 53 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp6_ = mktime (&n);
#line 53 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	t = ((gint) _tmp6_) - 59;
#line 54 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
#line 54 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	ts = _tmp7_;
#line 55 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_assert (g_strcmp0 (ts, "a few seconds ago") == 0);
#line 46 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (ts);
#line 46 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_object_unref0 (utils);
#line 267 "test-utils.c"
}


void gwibber_test_utils_suite_test_time_string_minute (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
#line 60 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp0_ = gwibber_utils_new ();
#line 60 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	utils = _tmp0_;
#line 61 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp1_ = time (NULL);
#line 61 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_t = _tmp1_;
#line 62 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_gm (_t, &_tmp2_);
#line 62 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n = _tmp2_;
#line 63 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_local (_t, &_tmp3_);
#line 63 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	lt = _tmp3_;
#line 64 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp4_ = lt;
#line 64 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp5_ = _tmp4_.tm_isdst;
#line 64 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n.tm_isdst = _tmp5_;
#line 65 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp6_ = mktime (&n);
#line 65 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	t = ((gint) _tmp6_) - 60;
#line 66 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
#line 66 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	ts = _tmp7_;
#line 67 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_assert (g_strcmp0 (ts, "1 minute ago") == 0);
#line 58 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (ts);
#line 58 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_object_unref0 (utils);
#line 322 "test-utils.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 1419 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1419 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1420 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1420 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1420 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1420 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	return result;
#line 342 "test-utils.c"
}


void gwibber_test_utils_suite_test_time_string_minutes (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
	gboolean _tmp8_ = FALSE;
#line 71 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp0_ = gwibber_utils_new ();
#line 71 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	utils = _tmp0_;
#line 72 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp1_ = time (NULL);
#line 72 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_t = _tmp1_;
#line 73 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_gm (_t, &_tmp2_);
#line 73 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n = _tmp2_;
#line 74 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_local (_t, &_tmp3_);
#line 74 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	lt = _tmp3_;
#line 75 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp4_ = lt;
#line 75 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp5_ = _tmp4_.tm_isdst;
#line 75 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n.tm_isdst = _tmp5_;
#line 76 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp6_ = mktime (&n);
#line 76 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	t = ((gint) _tmp6_) - 3559;
#line 77 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
#line 77 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	ts = _tmp7_;
#line 78 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp8_ = string_contains (ts, "minutes ago");
#line 78 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_assert (_tmp8_);
#line 69 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (ts);
#line 69 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_object_unref0 (utils);
#line 400 "test-utils.c"
}


void gwibber_test_utils_suite_test_time_string_hour (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
#line 82 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp0_ = gwibber_utils_new ();
#line 82 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	utils = _tmp0_;
#line 83 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp1_ = time (NULL);
#line 83 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_t = _tmp1_;
#line 84 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_gm (_t, &_tmp2_);
#line 84 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n = _tmp2_;
#line 85 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_local (_t, &_tmp3_);
#line 85 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	lt = _tmp3_;
#line 86 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp4_ = lt;
#line 86 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp5_ = _tmp4_.tm_isdst;
#line 86 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n.tm_isdst = _tmp5_;
#line 87 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp6_ = mktime (&n);
#line 87 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	t = ((gint) _tmp6_) - 3601;
#line 88 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
#line 88 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	ts = _tmp7_;
#line 89 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_assert (g_strcmp0 (ts, "1 hour ago") == 0);
#line 80 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (ts);
#line 80 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_object_unref0 (utils);
#line 455 "test-utils.c"
}


void gwibber_test_utils_suite_test_time_string_hours (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
	gboolean _tmp8_ = FALSE;
#line 93 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp0_ = gwibber_utils_new ();
#line 93 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	utils = _tmp0_;
#line 94 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp1_ = time (NULL);
#line 94 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_t = _tmp1_;
#line 95 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_gm (_t, &_tmp2_);
#line 95 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n = _tmp2_;
#line 96 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_local (_t, &_tmp3_);
#line 96 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	lt = _tmp3_;
#line 97 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp4_ = lt;
#line 97 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp5_ = _tmp4_.tm_isdst;
#line 97 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n.tm_isdst = _tmp5_;
#line 98 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp6_ = mktime (&n);
#line 98 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	t = ((gint) _tmp6_) - 7201;
#line 99 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
#line 99 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	ts = _tmp7_;
#line 100 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp8_ = string_contains (ts, "hours ago");
#line 100 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_assert (_tmp8_);
#line 91 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (ts);
#line 91 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_object_unref0 (utils);
#line 513 "test-utils.c"
}


void gwibber_test_utils_suite_test_time_string_day (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
#line 104 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp0_ = gwibber_utils_new ();
#line 104 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	utils = _tmp0_;
#line 105 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp1_ = time (NULL);
#line 105 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_t = _tmp1_;
#line 106 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_gm (_t, &_tmp2_);
#line 106 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n = _tmp2_;
#line 107 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_local (_t, &_tmp3_);
#line 107 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	lt = _tmp3_;
#line 108 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp4_ = lt;
#line 108 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp5_ = _tmp4_.tm_isdst;
#line 108 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n.tm_isdst = _tmp5_;
#line 109 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp6_ = mktime (&n);
#line 109 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	t = ((gint) _tmp6_) - 86400;
#line 110 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
#line 110 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	ts = _tmp7_;
#line 111 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_assert (g_strcmp0 (ts, "1 day ago") == 0);
#line 102 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (ts);
#line 102 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_object_unref0 (utils);
#line 568 "test-utils.c"
}


void gwibber_test_utils_suite_test_time_string_days (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
	gboolean _tmp8_ = FALSE;
#line 115 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp0_ = gwibber_utils_new ();
#line 115 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	utils = _tmp0_;
#line 116 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp1_ = time (NULL);
#line 116 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_t = _tmp1_;
#line 117 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_gm (_t, &_tmp2_);
#line 117 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n = _tmp2_;
#line 118 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_time_local (_t, &_tmp3_);
#line 118 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	lt = _tmp3_;
#line 119 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp4_ = lt;
#line 119 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp5_ = _tmp4_.tm_isdst;
#line 119 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	n.tm_isdst = _tmp5_;
#line 120 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp6_ = mktime (&n);
#line 120 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	t = ((gint) _tmp6_) - 172800;
#line 121 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
#line 121 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	ts = _tmp7_;
#line 122 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp8_ = string_contains (ts, "days ago");
#line 122 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_assert (_tmp8_);
#line 113 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (ts);
#line 113 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_object_unref0 (utils);
#line 626 "test-utils.c"
}


void gwibber_test_utils_suite_test_avatar_path (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	gchar* _tmp1_;
	gchar* url;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* avatar_path;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	FILE* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
#line 126 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp0_ = gwibber_utils_new ();
#line 126 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	utils = _tmp0_;
#line 127 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp1_ = g_strdup ("http://test.com/avatar");
#line 127 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	url = _tmp1_;
#line 128 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp2_ = url;
#line 128 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp3_ = gwibber_utils_avatar_path (utils, _tmp2_);
#line 128 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	avatar_path = _tmp3_;
#line 129 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp4_ = avatar_path;
#line 129 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp5_ = g_get_user_cache_dir ();
#line 129 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp6_ = url;
#line 129 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp7_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _tmp6_, (gsize) (-1));
#line 129 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp8_ = _tmp7_;
#line 129 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp9_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, "gwibber/avatars", _tmp8_, NULL);
#line 129 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp10_ = _tmp9_;
#line 129 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_assert (g_strcmp0 (_tmp4_, _tmp10_) == 0);
#line 129 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (_tmp10_);
#line 129 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (_tmp8_);
#line 130 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp11_ = g_strdup ("http://test.com/this_is_a_very_long_avatar_url_that_should_cause_test_" \
"failures_as_per_bug_845374_which_is_scheduled_to_be_fixed_in_a_later_r" \
"elease_but_hopefully_will_be_patched_before_then");
#line 130 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (url);
#line 130 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	url = _tmp11_;
#line 131 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp12_ = stdout;
#line 131 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp13_ = url;
#line 131 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp14_ = url;
#line 131 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp15_ = strlen (_tmp14_);
#line 131 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp16_ = _tmp15_;
#line 131 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp17_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _tmp13_, (gsize) _tmp16_);
#line 131 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp18_ = _tmp17_;
#line 131 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	fprintf (_tmp12_, "%s", _tmp18_);
#line 131 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (_tmp18_);
#line 132 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp19_ = url;
#line 132 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp20_ = gwibber_utils_avatar_path (utils, _tmp19_);
#line 132 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (avatar_path);
#line 132 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	avatar_path = _tmp20_;
#line 133 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp21_ = avatar_path;
#line 133 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp22_ = g_get_user_cache_dir ();
#line 133 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp23_ = url;
#line 133 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp24_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _tmp23_, (gsize) (-1));
#line 133 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp25_ = _tmp24_;
#line 133 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp26_ = g_build_path (G_DIR_SEPARATOR_S, _tmp22_, "gwibber/avatars", _tmp25_, NULL);
#line 133 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_tmp27_ = _tmp26_;
#line 133 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_assert (g_strcmp0 (_tmp21_, _tmp27_) == 0);
#line 133 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (_tmp27_);
#line 133 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (_tmp25_);
#line 124 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (avatar_path);
#line 124 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_free0 (url);
#line 124 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	_g_object_unref0 (utils);
#line 754 "test-utils.c"
}


static void gwibber_test_value_utils_suite_init (GValue* value) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	value->data[0].v_pointer = NULL;
#line 761 "test-utils.c"
}


static void gwibber_test_value_utils_suite_free_value (GValue* value) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	if (value->data[0].v_pointer) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		gwibber_test_utils_suite_unref (value->data[0].v_pointer);
#line 770 "test-utils.c"
	}
}


static void gwibber_test_value_utils_suite_copy_value (const GValue* src_value, GValue* dest_value) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	if (src_value->data[0].v_pointer) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		dest_value->data[0].v_pointer = gwibber_test_utils_suite_ref (src_value->data[0].v_pointer);
#line 780 "test-utils.c"
	} else {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 784 "test-utils.c"
	}
}


static gpointer gwibber_test_value_utils_suite_peek_pointer (const GValue* value) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	return value->data[0].v_pointer;
#line 792 "test-utils.c"
}


static gchar* gwibber_test_value_utils_suite_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	if (collect_values[0].v_pointer) {
#line 799 "test-utils.c"
		GwibberTestUtilsSuite* object;
		object = collect_values[0].v_pointer;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 806 "test-utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 810 "test-utils.c"
		}
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		value->data[0].v_pointer = gwibber_test_utils_suite_ref (object);
#line 814 "test-utils.c"
	} else {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		value->data[0].v_pointer = NULL;
#line 818 "test-utils.c"
	}
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	return NULL;
#line 822 "test-utils.c"
}


static gchar* gwibber_test_value_utils_suite_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GwibberTestUtilsSuite** object_p;
	object_p = collect_values[0].v_pointer;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	if (!object_p) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 833 "test-utils.c"
	}
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	if (!value->data[0].v_pointer) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		*object_p = NULL;
#line 839 "test-utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		*object_p = value->data[0].v_pointer;
#line 843 "test-utils.c"
	} else {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		*object_p = gwibber_test_utils_suite_ref (value->data[0].v_pointer);
#line 847 "test-utils.c"
	}
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	return NULL;
#line 851 "test-utils.c"
}


GParamSpec* gwibber_test_param_spec_utils_suite (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GwibberTestParamSpecUtilsSuite* spec;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GWIBBER_TEST_TYPE_UTILS_SUITE), NULL);
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	return G_PARAM_SPEC (spec);
#line 865 "test-utils.c"
}


gpointer gwibber_test_value_get_utils_suite (const GValue* value) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GWIBBER_TEST_TYPE_UTILS_SUITE), NULL);
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	return value->data[0].v_pointer;
#line 874 "test-utils.c"
}


void gwibber_test_value_set_utils_suite (GValue* value, gpointer v_object) {
	GwibberTestUtilsSuite* old;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GWIBBER_TEST_TYPE_UTILS_SUITE));
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	if (v_object) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GWIBBER_TEST_TYPE_UTILS_SUITE));
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		value->data[0].v_pointer = v_object;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		gwibber_test_utils_suite_ref (value->data[0].v_pointer);
#line 894 "test-utils.c"
	} else {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		value->data[0].v_pointer = NULL;
#line 898 "test-utils.c"
	}
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	if (old) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		gwibber_test_utils_suite_unref (old);
#line 904 "test-utils.c"
	}
}


void gwibber_test_value_take_utils_suite (GValue* value, gpointer v_object) {
	GwibberTestUtilsSuite* old;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GWIBBER_TEST_TYPE_UTILS_SUITE));
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	if (v_object) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GWIBBER_TEST_TYPE_UTILS_SUITE));
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		value->data[0].v_pointer = v_object;
#line 923 "test-utils.c"
	} else {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		value->data[0].v_pointer = NULL;
#line 927 "test-utils.c"
	}
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	if (old) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		gwibber_test_utils_suite_unref (old);
#line 933 "test-utils.c"
	}
}


static void gwibber_test_utils_suite_class_init (GwibberTestUtilsSuiteClass * klass) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	gwibber_test_utils_suite_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	GWIBBER_TEST_UTILS_SUITE_CLASS (klass)->finalize = gwibber_test_utils_suite_finalize;
#line 943 "test-utils.c"
}


static void gwibber_test_utils_suite_instance_init (GwibberTestUtilsSuite * self) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	self->ref_count = 1;
#line 950 "test-utils.c"
}


static void gwibber_test_utils_suite_finalize (GwibberTestUtilsSuite* obj) {
	GwibberTestUtilsSuite * self;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	self = GWIBBER_TEST_UTILS_SUITE (obj);
#line 958 "test-utils.c"
}


GType gwibber_test_utils_suite_get_type (void) {
	static volatile gsize gwibber_test_utils_suite_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_test_utils_suite_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gwibber_test_value_utils_suite_init, gwibber_test_value_utils_suite_free_value, gwibber_test_value_utils_suite_copy_value, gwibber_test_value_utils_suite_peek_pointer, "p", gwibber_test_value_utils_suite_collect_value, "p", gwibber_test_value_utils_suite_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GwibberTestUtilsSuiteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_test_utils_suite_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberTestUtilsSuite), 0, (GInstanceInitFunc) gwibber_test_utils_suite_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gwibber_test_utils_suite_type_id;
		gwibber_test_utils_suite_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GwibberTestUtilsSuite", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gwibber_test_utils_suite_type_id__volatile, gwibber_test_utils_suite_type_id);
	}
	return gwibber_test_utils_suite_type_id__volatile;
}


gpointer gwibber_test_utils_suite_ref (gpointer instance) {
	GwibberTestUtilsSuite* self;
	self = instance;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	return instance;
#line 983 "test-utils.c"
}


void gwibber_test_utils_suite_unref (gpointer instance) {
	GwibberTestUtilsSuite* self;
	self = instance;
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		GWIBBER_TEST_UTILS_SUITE_GET_CLASS (self)->finalize (self);
#line 24 "/home/ken/src/gwibber/trunk/tests/vala/test-utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 996 "test-utils.c"
	}
}



