# 맞춤법 검사를 위한 내부 인코딩

## 왜 전용 내부 인코딩이 필요한가

모아쓰기된 한글 음절은 hunspell과 같은 형태론 기반 맞춤법 검사에
적합하지 않다. 맞춤법 검사 시스템은 단어 사이의 편집 거리가 얼마나
되느냐를 이용해서 추천할 단어를 고르게 되는데, 한글 음절에 대한 코드를
가지고 음절 사이의 편집 거리, 더 나아가서 여러 음절과 여러 음절 사이의
편집 거리를 계산하기는 힘들다.

그러므로 한글 음절 코드를 자모 단위로 분해한 내부 코드로 한번 변환한
다음, hunspell을 이용해 추천 단어를 찾고, 내부 코드로 된 추천 단어를
다시 일반적인 한글 음절로 변환하는 게 가장 자연스러운 접근 방법이다.

## 유니코드 NFD

직관적인 접근 방법은 유니코드에 들어 있는 인코딩을 사용하는 방법이다.
한글 자모 코드가 그것이다. 하지만, 유니코드의 한글 자모는 초성과
종성을 다른 코드를 사용하기 때문에 불필요한 편집거리가 발생할 수 있다.

장점: 구현이 쉽다.

단점: 불필요한 편집거리가 많이 발생한다.

## 두벌식 키스트로크

단, 두벌식 키스트로크만으로 표현할 수 없는 조합이 있기 때문에 (예:
"사이ㅅ"), 두벌식 조합을 중지하는 reset 코드를 추가로 넣는다. 일반적인
한글 입력기에서도 추가적인 동작이 있어야 입력할 수 있기 때문에 문제가
되지 않는다.

장점: 불필요한 편집거리가 발생하지 않는다.

단점: hunspell 코드의 수정 없이 데이터만으로는 구현할 수 없다.

## 시작코드 + 두벌식 키스트로크

임시 구현. 각 음절의 시작에 시작 코드를 넣는다.

장점: hunspell 코드의 수정 없이 구현 가능. 불필요한 편집거리가 덜 발생한다.

단점: 불필요한 편집거리가 아직도 발생한다.
