/* 
* This is part of the source for i855crt driver
* copyright(c) Merello Andrea 2004
* <andreamrl@tiscali.it>
*
* this is released under the terms of GPL (General Public Licence)
*
* some parts of this driver are taken/based  from/on the 'i810switch' driver
* many thanks to the original author.
*
* some parts of this driver are taken/based  from/on the 855GM-fb driver
* many thanks to the original author.
* 
* plase note that this driver is still experimental
*
* feedbacks are VERY appreciated
*/

#include "i855crt.h"
#define rd(x) *((volatile int *) (mmio + x))


unsigned char *mmio;

/*this tries to find know video card in lspci output */
char *i810_chip(char **buff_ptr, int *len_ptr, FILE *pci_f) 
{
	int i;
	char *p;

	while (getline(buff_ptr, len_ptr, pci_f) > 0) 
	{
		i = 
		(p = strstr(*buff_ptr, I810STR)) != NULL ||
		(p = strstr(*buff_ptr, I810ESTR)) != NULL ||
		(p = strstr(*buff_ptr, I810_DC100STR_1)) != NULL ||
		(p = strstr(*buff_ptr, I810_DC100STR_2)) != NULL ||
		(p = strstr(*buff_ptr, I810_IGSTR)) != NULL ||
		(p = strstr(*buff_ptr, I810_CFCSTR)) != NULL;
		(p = strstr(*buff_ptr, I830STR)) != NULL ||
		(p = strstr(*buff_ptr, I845STR)) != NULL ||
		(p = strstr(*buff_ptr, I865STR)) != NULL ;
	
		if(i)
		{
			fprintf(stderr,"This driver is untested with your videocard !\n");  
			return p;
		}
		
		i = (p = strstr(*buff_ptr, I855STR)) != NULL;
		if (i) 	return p;
		
	}
	return NULL;
}

/*this extracts the iomem address of the specified device */
unsigned long i810_addr(char **buff_ptr, int *len_ptr, FILE *pci_f)
{
	char *p;

	while (getline(buff_ptr, len_ptr, pci_f) > 0)
		if (strstr(*buff_ptr, NONPRSTR) != NULL) {
			p = strstr(*buff_ptr, MEMSTR);
			if (p != NULL)
				return strtoul(p+sizeof(MEMSTR), NULL, 16);
		}
	return 0;
}

int main (int argc, char *argv[])
{
	int mem,len,i,fd;
	unsigned long addr;
	FILE *pci_f;
	char *buff = NULL;
	char lspcistr[] = CMD_LSPCI " -v -d xxxx:xxxx";
	char *chip;
	struct vmode mode;

	putenv("PATH=/sbin:/usr/sbin:/bin:/usr/bin");
	
	pci_f = popen(CMD_LSPCI " -n", "r");
	if (!pci_f) 
	{
		fprintf(stderr, "Something is wrong with lspci.\n");
		exit(1);
	}
	chip = i810_chip(&buff, &len, pci_f);
	if (chip == NULL) 
	{
		fprintf(stderr, "No know videocard has been found.\n");
		exit(1);
	}
	pclose(pci_f);

	{
		char *p = strstr(lspcistr, "xxxx:xxxx");
		if (p == 0) 
		{
			fprintf(stderr, "CMD_LSPCI is wrong.\n");
			exit(1);
		}
		memcpy(p, chip, 9);
	}

	pci_f = popen(lspcistr, "r");
	if (!pci_f) 
	{
		fprintf(stderr, "Something is wrong with lspci.\n");
		exit(1);
	}
	addr = i810_addr(&buff, &len, pci_f);
	if (addr == 0) 
	{
		fprintf(stderr, "Something is wrong with lspci.\n");
		exit(1);
	}
	pclose(pci_f);

	
	mem = open("/dev/mem", O_RDWR);
	if (mem == -1) 
	{
    	  	i = errno;
		perror("/dev/mem");
		if (i == EACCES && geteuid() != 0)
			fprintf(stderr, "Must have access to `/dev/mem'.\n");
		
		exit(-1);
	}
	

	mmio = mmap(NULL, 512 * 1024,  PROT_WRITE | PROT_READ,
			MAP_SHARED, mem, addr);
	if (!mmio) 
	{
		close(mem);
		exit(-1);
	}
	
	fprintf(stderr,"dumping registers to 'log' file..\n");
	int j;
	
	
	for(i=0;i<512*1024;i+=0x10)
	{
		printf("\n%5x: ",i);
		
		for (j=0;j<0x10;j+=4)
		
				printf("%8x ",rd(i+j));
				
							
	}	
	
	close(mem);
	munmap(mmio, 512 * 1024);
	return 0;
}

