/*
 * Line6 PODxt Pro USB driver - 0.5
 *
 * Copyright (C) 2004, 2005 Markus Grabner (grabner@icg.tu-graz.ac.at)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation, version 2.
 *
 */

#include <linux/config.h>

#ifdef CONFIG_USB_DEBUG
#define DEBUG 1
#endif

#include <asm/uaccess.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/usb.h>
#include <linux/time.h>

#include <sound/driver.h>
#include <sound/core.h>
#include <sound/control.h>
#include <sound/initval.h>
#include <sound/pcm.h>
#include <sound/pcm_params.h>

#include "audio.h"
#include "driver.h"
#include "midi.h"
#include "pcm.h"


static int podxtpro_index[SNDRV_CARDS] = SNDRV_DEFAULT_IDX;
static char *podxtpro_id[SNDRV_CARDS] = SNDRV_DEFAULT_STR;


/*
	Initialize the PODxt Pro USB audio system.
*/
int podxtpro_init_audio(struct usb_podxtpro *podxtpro)
{
	static int dev = 0;
	snd_card_t *card;
	int err;

	card = snd_card_new(podxtpro_index[dev], podxtpro_id[dev], THIS_MODULE, 0);

	if(card == NULL)
		return -ENOMEM;

	podxtpro->card = card;

	strcpy(card->driver, "Line6-USB");
	strcpy(card->shortname, "Line6-USB");
	sprintf(card->longname, "Line6 %s USB audio", podxtpro->devname);  /* 80 chars - see asound.h */

	if((err = podxtpro_init_pcm(podxtpro)) < 0)
		return err;

	if((err = podxtpro_init_midi(podxtpro)) < 0)
		return err;

	if((err = snd_card_register(card)) < 0)
		return err;

	return 0;
}

/*
	Cleanup the PODxt Pro USB audio system.
*/
void podxtpro_cleanup_audio(struct usb_podxtpro *podxtpro)
{
	snd_card_t *card = podxtpro->card;

	if(card == 0)
		return;

	snd_card_disconnect(card);
	snd_card_free(card);
	podxtpro->card = 0;
}
