/*
 * Line6 PODxt Pro USB driver - 0.5
 *
 * Copyright (C) 2004, 2005 Markus Grabner (grabner@icg.tu-graz.ac.at)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation, version 2.
 *
 */

#include <linux/config.h>
#ifdef CONFIG_USB_DEBUG
#define DEBUG 1
#endif
#include <linux/kernel.h>
#include <linux/usb.h>

#include "config.h"
#include "control.h"
#include "driver.h"


static ssize_t get_param(struct device *dev, char *buf, int param)
{
	struct usb_interface *interface = to_usb_interface(dev);
	struct usb_podxtpro *podxtpro = usb_get_intfdata(interface);
	int retval = podxtpro_wait_dump(podxtpro, 0);
	if(retval < 0) return retval;
	return sprintf(buf, "%d\n", podxtpro->prog_data.control[param]);
}

static ssize_t set_param(struct device *dev, const char *buf, size_t count, int param)
{
	struct usb_interface *interface = to_usb_interface(dev);
	struct usb_podxtpro *podxtpro = usb_get_intfdata(interface);
	int value = simple_strtoul(buf, NULL, 10);
	podxtpro_set_parameter(podxtpro, param, value);
	return count;
}

static ssize_t get_delay_param_2(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_param_2);
}

static ssize_t set_delay_param_2(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_param_2);
}

static ssize_t get_tempo_lsb(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_tempo_lsb);
}

static ssize_t set_tempo_lsb(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_tempo_lsb);
}

static ssize_t get_eq_enable(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_eq_enable);
}

static ssize_t set_eq_enable(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_eq_enable);
}

static ssize_t get_presence(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_presence);
}

static ssize_t set_presence(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_presence);
}

static ssize_t get_cabinet_model(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_cabinet_model);
}

static ssize_t set_cabinet_model(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_cabinet_model);
}

static ssize_t get_vol_pedal_position(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_vol_pedal_position);
}

static ssize_t set_vol_pedal_position(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_vol_pedal_position);
}

static ssize_t get_stomp_param_3(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_stomp_param_3);
}

static ssize_t set_stomp_param_3(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_stomp_param_3);
}

static ssize_t get_comp_enable(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_comp_enable);
}

static ssize_t set_comp_enable(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_comp_enable);
}

static ssize_t get_band_4_gain(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_band_4_gain);
}

static ssize_t set_band_4_gain(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_band_4_gain);
}

static ssize_t get_reverb_mix(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_reverb_mix);
}

static ssize_t set_reverb_mix(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_reverb_mix);
}

static ssize_t get_treble(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_treble);
}

static ssize_t set_treble(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_treble);
}

static ssize_t get_mod_param_5(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mod_param_5);
}

static ssize_t set_mod_param_5(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mod_param_5);
}

static ssize_t get_stomp_time(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_stomp_time);
}

static ssize_t set_stomp_time(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_stomp_time);
}

static ssize_t get_mod_pre_post(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mod_pre_post);
}

static ssize_t set_mod_pre_post(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mod_pre_post);
}

static ssize_t get_mod_param_1_double_precision(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mod_param_1_double_precision);
}

static ssize_t set_mod_param_1_double_precision(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mod_param_1_double_precision);
}

static ssize_t get_tweak_param_select(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_tweak_param_select);
}

static ssize_t set_tweak_param_select(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_tweak_param_select);
}

static ssize_t get_band_1_frequency(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_band_1_frequency);
}

static ssize_t set_band_1_frequency(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_band_1_frequency);
}

static ssize_t get_tempo_msb(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_tempo_msb);
}

static ssize_t set_tempo_msb(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_tempo_msb);
}

static ssize_t get_pan(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_pan);
}

static ssize_t set_pan(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_pan);
}

static ssize_t get_delay_param_1_note_value(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_param_1_note_value);
}

static ssize_t set_delay_param_1_note_value(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_param_1_note_value);
}

static ssize_t get_delay_param_3(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_param_3);
}

static ssize_t set_delay_param_3(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_param_3);
}

static ssize_t get_amp_model_setup(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_amp_model_setup);
}

static ssize_t set_amp_model_setup(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_amp_model_setup);
}

static ssize_t get_stomp_param_1_note_value(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_stomp_param_1_note_value);
}

static ssize_t set_stomp_param_1_note_value(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_stomp_param_1_note_value);
}

static ssize_t get_fx_loop_on_off(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_fx_loop_on_off);
}

static ssize_t set_fx_loop_on_off(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_fx_loop_on_off);
}

static ssize_t get_delay_pre_post(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_pre_post);
}

static ssize_t set_delay_pre_post(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_pre_post);
}

static ssize_t get_band_4_frequency(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_band_4_frequency);
}

static ssize_t set_band_4_frequency(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_band_4_frequency);
}

static ssize_t get_volume_tweak_pedal_assign(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_volume_tweak_pedal_assign);
}

static ssize_t set_volume_tweak_pedal_assign(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_volume_tweak_pedal_assign);
}

static ssize_t get_mod_param_1(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mod_param_1);
}

static ssize_t set_mod_param_1(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mod_param_1);
}

static ssize_t get_mod_enable(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mod_enable);
}

static ssize_t set_mod_enable(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mod_enable);
}

static ssize_t get_reverb_tone(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_reverb_tone);
}

static ssize_t set_reverb_tone(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_reverb_tone);
}

static ssize_t get_tap(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_tap);
}

static ssize_t set_tap(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_tap);
}

static ssize_t get_band_1_gain(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_band_1_gain);
}

static ssize_t set_band_1_gain(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_band_1_gain);
}

static ssize_t get_modulation_model(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_modulation_model);
}

static ssize_t set_modulation_model(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_modulation_model);
}

static ssize_t get_reverb_pre_post(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_reverb_pre_post);
}

static ssize_t set_reverb_pre_post(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_reverb_pre_post);
}

static ssize_t get_amp_model(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_amp_model);
}

static ssize_t set_amp_model(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_amp_model);
}

static ssize_t get_mid(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mid);
}

static ssize_t set_mid(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mid);
}

static ssize_t get_stomp_param_4(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_stomp_param_4);
}

static ssize_t set_stomp_param_4(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_stomp_param_4);
}

static ssize_t get_mod_param_2(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mod_param_2);
}

static ssize_t set_mod_param_2(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mod_param_2);
}

static ssize_t get_band_3_frequency(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_band_3_frequency);
}

static ssize_t set_band_3_frequency(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_band_3_frequency);
}

static ssize_t get_mod_volume_mix(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mod_volume_mix);
}

static ssize_t set_mod_volume_mix(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mod_volume_mix);
}

static ssize_t get_delay_param_5(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_param_5);
}

static ssize_t set_delay_param_5(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_param_5);
}

static ssize_t get_roomlevel(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_roomlevel);
}

static ssize_t set_roomlevel(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_roomlevel);
}

static ssize_t get_effect_setup(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_effect_setup);
}

static ssize_t set_effect_setup(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_effect_setup);
}

static ssize_t get_delay_param_1_double_precision(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_param_1_double_precision);
}

static ssize_t set_delay_param_1_double_precision(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_param_1_double_precision);
}

static ssize_t get_mod_param_4(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mod_param_4);
}

static ssize_t set_mod_param_4(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mod_param_4);
}

static ssize_t get_mic_selection(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mic_selection);
}

static ssize_t set_mic_selection(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mic_selection);
}

static ssize_t get_chan_vol(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_chan_vol);
}

static ssize_t set_chan_vol(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_chan_vol);
}

static ssize_t get_tweak(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_tweak);
}

static ssize_t set_tweak(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_tweak);
}

static ssize_t get_band_2_gain(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_band_2_gain);
}

static ssize_t set_band_2_gain(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_band_2_gain);
}

static ssize_t get_delay_model(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_model);
}

static ssize_t set_delay_model(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_model);
}

static ssize_t get_delay_param_1(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_param_1);
}

static ssize_t set_delay_param_1(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_param_1);
}

static ssize_t get_stomp_param_5(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_stomp_param_5);
}

static ssize_t set_stomp_param_5(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_stomp_param_5);
}

static ssize_t get_stomp_enable(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_stomp_enable);
}

static ssize_t set_stomp_enable(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_stomp_enable);
}

static ssize_t get_delay_enable(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_enable);
}

static ssize_t set_delay_enable(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_enable);
}

static ssize_t get_stomp_param_6(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_stomp_param_6);
}

static ssize_t set_stomp_param_6(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_stomp_param_6);
}

static ssize_t get_reverb_pre_delay(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_reverb_pre_delay);
}

static ssize_t set_reverb_pre_delay(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_reverb_pre_delay);
}

static ssize_t get_stomp_model(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_stomp_model);
}

static ssize_t set_stomp_model(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_stomp_model);
}

static ssize_t get_bass(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_bass);
}

static ssize_t set_bass(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_bass);
}

static ssize_t get_tuner(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_tuner);
}

static ssize_t set_tuner(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_tuner);
}

static ssize_t get_gate_decay_time(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_gate_decay_time);
}

static ssize_t set_gate_decay_time(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_gate_decay_time);
}

static ssize_t get_mod_param_3(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mod_param_3);
}

static ssize_t set_mod_param_3(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mod_param_3);
}

static ssize_t get_stomp_param_2(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_stomp_param_2);
}

static ssize_t set_stomp_param_2(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_stomp_param_2);
}

static ssize_t get_noise_gate_enable(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_noise_gate_enable);
}

static ssize_t set_noise_gate_enable(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_noise_gate_enable);
}

static ssize_t get_band_2_frequency(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_band_2_frequency);
}

static ssize_t set_band_2_frequency(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_band_2_frequency);
}

static ssize_t get_volume_pedal_minimum(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_volume_pedal_minimum);
}

static ssize_t set_volume_pedal_minimum(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_volume_pedal_minimum);
}

static ssize_t get_gate_threshold(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_gate_threshold);
}

static ssize_t set_gate_threshold(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_gate_threshold);
}

static ssize_t get_drive(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_drive);
}

static ssize_t set_drive(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_drive);
}

static ssize_t get_bypass_volume(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_bypass_volume);
}

static ssize_t set_bypass_volume(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_bypass_volume);
}

static ssize_t get_delay_param_4(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_param_4);
}

static ssize_t set_delay_param_4(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_param_4);
}

static ssize_t get_reverb_enable(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_reverb_enable);
}

static ssize_t set_reverb_enable(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_reverb_enable);
}

static ssize_t get_compression_threshold(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_compression_threshold);
}

static ssize_t set_compression_threshold(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_compression_threshold);
}

static ssize_t get_mod_param_1_note_value(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_mod_param_1_note_value);
}

static ssize_t set_mod_param_1_note_value(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_mod_param_1_note_value);
}

static ssize_t get_volume_pre_post(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_volume_pre_post);
}

static ssize_t set_volume_pre_post(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_volume_pre_post);
}

static ssize_t get_reverb_decay(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_reverb_decay);
}

static ssize_t set_reverb_decay(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_reverb_decay);
}

static ssize_t get_wah_position(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_wah_position);
}

static ssize_t set_wah_position(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_wah_position);
}

static ssize_t get_delay_volume_mix(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_delay_volume_mix);
}

static ssize_t set_delay_volume_mix(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_delay_volume_mix);
}

static ssize_t get_reverb_type(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_reverb_type);
}

static ssize_t set_reverb_type(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_reverb_type);
}

static ssize_t get_band_3_gain(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_band_3_gain);
}

static ssize_t set_band_3_gain(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_band_3_gain);
}

static ssize_t get_wah_enable(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_wah_enable);
}

static ssize_t set_wah_enable(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_wah_enable);
}

static ssize_t get_compression_gain(struct device *dev, DEVICE_ATTRIBUTE char *buf)
{
	return get_param(dev, buf, PODXTPRO_compression_gain);
}

static ssize_t set_compression_gain(struct device *dev, DEVICE_ATTRIBUTE const char *buf, size_t count)
{
	return set_param(dev, buf, count, PODXTPRO_compression_gain);
}

static DEVICE_ATTR(delay_param_2, S_IWUGO | S_IRUGO, get_delay_param_2, set_delay_param_2);
static DEVICE_ATTR(tempo_lsb, S_IWUGO | S_IRUGO, get_tempo_lsb, set_tempo_lsb);
static DEVICE_ATTR(eq_enable, S_IWUGO | S_IRUGO, get_eq_enable, set_eq_enable);
static DEVICE_ATTR(presence, S_IWUGO | S_IRUGO, get_presence, set_presence);
static DEVICE_ATTR(cabinet_model, S_IWUGO | S_IRUGO, get_cabinet_model, set_cabinet_model);
static DEVICE_ATTR(vol_pedal_position, S_IWUGO | S_IRUGO, get_vol_pedal_position, set_vol_pedal_position);
static DEVICE_ATTR(stomp_param_3, S_IWUGO | S_IRUGO, get_stomp_param_3, set_stomp_param_3);
static DEVICE_ATTR(comp_enable, S_IWUGO | S_IRUGO, get_comp_enable, set_comp_enable);
static DEVICE_ATTR(band_4_gain, S_IWUGO | S_IRUGO, get_band_4_gain, set_band_4_gain);
static DEVICE_ATTR(reverb_mix, S_IWUGO | S_IRUGO, get_reverb_mix, set_reverb_mix);
static DEVICE_ATTR(treble, S_IWUGO | S_IRUGO, get_treble, set_treble);
static DEVICE_ATTR(mod_param_5, S_IWUGO | S_IRUGO, get_mod_param_5, set_mod_param_5);
static DEVICE_ATTR(stomp_time, S_IWUGO | S_IRUGO, get_stomp_time, set_stomp_time);
static DEVICE_ATTR(mod_pre_post, S_IWUGO | S_IRUGO, get_mod_pre_post, set_mod_pre_post);
static DEVICE_ATTR(mod_param_1_double_precision, S_IWUGO | S_IRUGO, get_mod_param_1_double_precision, set_mod_param_1_double_precision);
static DEVICE_ATTR(tweak_param_select, S_IWUGO | S_IRUGO, get_tweak_param_select, set_tweak_param_select);
static DEVICE_ATTR(band_1_frequency, S_IWUGO | S_IRUGO, get_band_1_frequency, set_band_1_frequency);
static DEVICE_ATTR(tempo_msb, S_IWUGO | S_IRUGO, get_tempo_msb, set_tempo_msb);
static DEVICE_ATTR(pan, S_IWUGO | S_IRUGO, get_pan, set_pan);
static DEVICE_ATTR(delay_param_1_note_value, S_IWUGO | S_IRUGO, get_delay_param_1_note_value, set_delay_param_1_note_value);
static DEVICE_ATTR(delay_param_3, S_IWUGO | S_IRUGO, get_delay_param_3, set_delay_param_3);
static DEVICE_ATTR(amp_model_setup, S_IWUGO | S_IRUGO, get_amp_model_setup, set_amp_model_setup);
static DEVICE_ATTR(stomp_param_1_note_value, S_IWUGO | S_IRUGO, get_stomp_param_1_note_value, set_stomp_param_1_note_value);
static DEVICE_ATTR(fx_loop_on_off, S_IWUGO | S_IRUGO, get_fx_loop_on_off, set_fx_loop_on_off);
static DEVICE_ATTR(delay_pre_post, S_IWUGO | S_IRUGO, get_delay_pre_post, set_delay_pre_post);
static DEVICE_ATTR(band_4_frequency, S_IWUGO | S_IRUGO, get_band_4_frequency, set_band_4_frequency);
static DEVICE_ATTR(volume_tweak_pedal_assign, S_IWUGO | S_IRUGO, get_volume_tweak_pedal_assign, set_volume_tweak_pedal_assign);
static DEVICE_ATTR(mod_param_1, S_IWUGO | S_IRUGO, get_mod_param_1, set_mod_param_1);
static DEVICE_ATTR(mod_enable, S_IWUGO | S_IRUGO, get_mod_enable, set_mod_enable);
static DEVICE_ATTR(reverb_tone, S_IWUGO | S_IRUGO, get_reverb_tone, set_reverb_tone);
static DEVICE_ATTR(tap, S_IWUGO | S_IRUGO, get_tap, set_tap);
static DEVICE_ATTR(band_1_gain, S_IWUGO | S_IRUGO, get_band_1_gain, set_band_1_gain);
static DEVICE_ATTR(modulation_model, S_IWUGO | S_IRUGO, get_modulation_model, set_modulation_model);
static DEVICE_ATTR(reverb_pre_post, S_IWUGO | S_IRUGO, get_reverb_pre_post, set_reverb_pre_post);
static DEVICE_ATTR(amp_model, S_IWUGO | S_IRUGO, get_amp_model, set_amp_model);
static DEVICE_ATTR(mid, S_IWUGO | S_IRUGO, get_mid, set_mid);
static DEVICE_ATTR(stomp_param_4, S_IWUGO | S_IRUGO, get_stomp_param_4, set_stomp_param_4);
static DEVICE_ATTR(mod_param_2, S_IWUGO | S_IRUGO, get_mod_param_2, set_mod_param_2);
static DEVICE_ATTR(band_3_frequency, S_IWUGO | S_IRUGO, get_band_3_frequency, set_band_3_frequency);
static DEVICE_ATTR(mod_volume_mix, S_IWUGO | S_IRUGO, get_mod_volume_mix, set_mod_volume_mix);
static DEVICE_ATTR(delay_param_5, S_IWUGO | S_IRUGO, get_delay_param_5, set_delay_param_5);
static DEVICE_ATTR(roomlevel, S_IWUGO | S_IRUGO, get_roomlevel, set_roomlevel);
static DEVICE_ATTR(effect_setup, S_IWUGO | S_IRUGO, get_effect_setup, set_effect_setup);
static DEVICE_ATTR(delay_param_1_double_precision, S_IWUGO | S_IRUGO, get_delay_param_1_double_precision, set_delay_param_1_double_precision);
static DEVICE_ATTR(mod_param_4, S_IWUGO | S_IRUGO, get_mod_param_4, set_mod_param_4);
static DEVICE_ATTR(mic_selection, S_IWUGO | S_IRUGO, get_mic_selection, set_mic_selection);
static DEVICE_ATTR(chan_vol, S_IWUGO | S_IRUGO, get_chan_vol, set_chan_vol);
static DEVICE_ATTR(tweak, S_IWUGO | S_IRUGO, get_tweak, set_tweak);
static DEVICE_ATTR(band_2_gain, S_IWUGO | S_IRUGO, get_band_2_gain, set_band_2_gain);
static DEVICE_ATTR(delay_model, S_IWUGO | S_IRUGO, get_delay_model, set_delay_model);
static DEVICE_ATTR(delay_param_1, S_IWUGO | S_IRUGO, get_delay_param_1, set_delay_param_1);
static DEVICE_ATTR(stomp_param_5, S_IWUGO | S_IRUGO, get_stomp_param_5, set_stomp_param_5);
static DEVICE_ATTR(stomp_enable, S_IWUGO | S_IRUGO, get_stomp_enable, set_stomp_enable);
static DEVICE_ATTR(delay_enable, S_IWUGO | S_IRUGO, get_delay_enable, set_delay_enable);
static DEVICE_ATTR(stomp_param_6, S_IWUGO | S_IRUGO, get_stomp_param_6, set_stomp_param_6);
static DEVICE_ATTR(reverb_pre_delay, S_IWUGO | S_IRUGO, get_reverb_pre_delay, set_reverb_pre_delay);
static DEVICE_ATTR(stomp_model, S_IWUGO | S_IRUGO, get_stomp_model, set_stomp_model);
static DEVICE_ATTR(bass, S_IWUGO | S_IRUGO, get_bass, set_bass);
static DEVICE_ATTR(tuner, S_IWUGO | S_IRUGO, get_tuner, set_tuner);
static DEVICE_ATTR(gate_decay_time, S_IWUGO | S_IRUGO, get_gate_decay_time, set_gate_decay_time);
static DEVICE_ATTR(mod_param_3, S_IWUGO | S_IRUGO, get_mod_param_3, set_mod_param_3);
static DEVICE_ATTR(stomp_param_2, S_IWUGO | S_IRUGO, get_stomp_param_2, set_stomp_param_2);
static DEVICE_ATTR(noise_gate_enable, S_IWUGO | S_IRUGO, get_noise_gate_enable, set_noise_gate_enable);
static DEVICE_ATTR(band_2_frequency, S_IWUGO | S_IRUGO, get_band_2_frequency, set_band_2_frequency);
static DEVICE_ATTR(volume_pedal_minimum, S_IWUGO | S_IRUGO, get_volume_pedal_minimum, set_volume_pedal_minimum);
static DEVICE_ATTR(gate_threshold, S_IWUGO | S_IRUGO, get_gate_threshold, set_gate_threshold);
static DEVICE_ATTR(drive, S_IWUGO | S_IRUGO, get_drive, set_drive);
static DEVICE_ATTR(bypass_volume, S_IWUGO | S_IRUGO, get_bypass_volume, set_bypass_volume);
static DEVICE_ATTR(delay_param_4, S_IWUGO | S_IRUGO, get_delay_param_4, set_delay_param_4);
static DEVICE_ATTR(reverb_enable, S_IWUGO | S_IRUGO, get_reverb_enable, set_reverb_enable);
static DEVICE_ATTR(compression_threshold, S_IWUGO | S_IRUGO, get_compression_threshold, set_compression_threshold);
static DEVICE_ATTR(mod_param_1_note_value, S_IWUGO | S_IRUGO, get_mod_param_1_note_value, set_mod_param_1_note_value);
static DEVICE_ATTR(volume_pre_post, S_IWUGO | S_IRUGO, get_volume_pre_post, set_volume_pre_post);
static DEVICE_ATTR(reverb_decay, S_IWUGO | S_IRUGO, get_reverb_decay, set_reverb_decay);
static DEVICE_ATTR(wah_position, S_IWUGO | S_IRUGO, get_wah_position, set_wah_position);
static DEVICE_ATTR(delay_volume_mix, S_IWUGO | S_IRUGO, get_delay_volume_mix, set_delay_volume_mix);
static DEVICE_ATTR(reverb_type, S_IWUGO | S_IRUGO, get_reverb_type, set_reverb_type);
static DEVICE_ATTR(band_3_gain, S_IWUGO | S_IRUGO, get_band_3_gain, set_band_3_gain);
static DEVICE_ATTR(wah_enable, S_IWUGO | S_IRUGO, get_wah_enable, set_wah_enable);
static DEVICE_ATTR(compression_gain, S_IWUGO | S_IRUGO, get_compression_gain, set_compression_gain);


void podxtpro_create_files(struct device *dev) {
	device_create_file(dev, &dev_attr_delay_param_2);
	device_create_file(dev, &dev_attr_tempo_lsb);
	device_create_file(dev, &dev_attr_eq_enable);
	device_create_file(dev, &dev_attr_presence);
	device_create_file(dev, &dev_attr_cabinet_model);
	device_create_file(dev, &dev_attr_vol_pedal_position);
	device_create_file(dev, &dev_attr_stomp_param_3);
	device_create_file(dev, &dev_attr_comp_enable);
	device_create_file(dev, &dev_attr_band_4_gain);
	device_create_file(dev, &dev_attr_reverb_mix);
	device_create_file(dev, &dev_attr_treble);
	device_create_file(dev, &dev_attr_mod_param_5);
	device_create_file(dev, &dev_attr_stomp_time);
	device_create_file(dev, &dev_attr_mod_pre_post);
	device_create_file(dev, &dev_attr_mod_param_1_double_precision);
	device_create_file(dev, &dev_attr_tweak_param_select);
	device_create_file(dev, &dev_attr_band_1_frequency);
	device_create_file(dev, &dev_attr_tempo_msb);
	device_create_file(dev, &dev_attr_pan);
	device_create_file(dev, &dev_attr_delay_param_1_note_value);
	device_create_file(dev, &dev_attr_delay_param_3);
	device_create_file(dev, &dev_attr_amp_model_setup);
	device_create_file(dev, &dev_attr_stomp_param_1_note_value);
	device_create_file(dev, &dev_attr_fx_loop_on_off);
	device_create_file(dev, &dev_attr_delay_pre_post);
	device_create_file(dev, &dev_attr_band_4_frequency);
	device_create_file(dev, &dev_attr_volume_tweak_pedal_assign);
	device_create_file(dev, &dev_attr_mod_param_1);
	device_create_file(dev, &dev_attr_mod_enable);
	device_create_file(dev, &dev_attr_reverb_tone);
	device_create_file(dev, &dev_attr_tap);
	device_create_file(dev, &dev_attr_band_1_gain);
	device_create_file(dev, &dev_attr_modulation_model);
	device_create_file(dev, &dev_attr_reverb_pre_post);
	device_create_file(dev, &dev_attr_amp_model);
	device_create_file(dev, &dev_attr_mid);
	device_create_file(dev, &dev_attr_stomp_param_4);
	device_create_file(dev, &dev_attr_mod_param_2);
	device_create_file(dev, &dev_attr_band_3_frequency);
	device_create_file(dev, &dev_attr_mod_volume_mix);
	device_create_file(dev, &dev_attr_delay_param_5);
	device_create_file(dev, &dev_attr_roomlevel);
	device_create_file(dev, &dev_attr_effect_setup);
	device_create_file(dev, &dev_attr_delay_param_1_double_precision);
	device_create_file(dev, &dev_attr_mod_param_4);
	device_create_file(dev, &dev_attr_mic_selection);
	device_create_file(dev, &dev_attr_chan_vol);
	device_create_file(dev, &dev_attr_tweak);
	device_create_file(dev, &dev_attr_band_2_gain);
	device_create_file(dev, &dev_attr_delay_model);
	device_create_file(dev, &dev_attr_delay_param_1);
	device_create_file(dev, &dev_attr_stomp_param_5);
	device_create_file(dev, &dev_attr_stomp_enable);
	device_create_file(dev, &dev_attr_delay_enable);
	device_create_file(dev, &dev_attr_stomp_param_6);
	device_create_file(dev, &dev_attr_reverb_pre_delay);
	device_create_file(dev, &dev_attr_stomp_model);
	device_create_file(dev, &dev_attr_bass);
	device_create_file(dev, &dev_attr_tuner);
	device_create_file(dev, &dev_attr_gate_decay_time);
	device_create_file(dev, &dev_attr_mod_param_3);
	device_create_file(dev, &dev_attr_stomp_param_2);
	device_create_file(dev, &dev_attr_noise_gate_enable);
	device_create_file(dev, &dev_attr_band_2_frequency);
	device_create_file(dev, &dev_attr_volume_pedal_minimum);
	device_create_file(dev, &dev_attr_gate_threshold);
	device_create_file(dev, &dev_attr_drive);
	device_create_file(dev, &dev_attr_bypass_volume);
	device_create_file(dev, &dev_attr_delay_param_4);
	device_create_file(dev, &dev_attr_reverb_enable);
	device_create_file(dev, &dev_attr_compression_threshold);
	device_create_file(dev, &dev_attr_mod_param_1_note_value);
	device_create_file(dev, &dev_attr_volume_pre_post);
	device_create_file(dev, &dev_attr_reverb_decay);
	device_create_file(dev, &dev_attr_wah_position);
	device_create_file(dev, &dev_attr_delay_volume_mix);
	device_create_file(dev, &dev_attr_reverb_type);
	device_create_file(dev, &dev_attr_band_3_gain);
	device_create_file(dev, &dev_attr_wah_enable);
	device_create_file(dev, &dev_attr_compression_gain);
}

void podxtpro_remove_files(struct device *dev) {
	device_remove_file(dev, &dev_attr_delay_param_2);
	device_remove_file(dev, &dev_attr_tempo_lsb);
	device_remove_file(dev, &dev_attr_eq_enable);
	device_remove_file(dev, &dev_attr_presence);
	device_remove_file(dev, &dev_attr_cabinet_model);
	device_remove_file(dev, &dev_attr_vol_pedal_position);
	device_remove_file(dev, &dev_attr_stomp_param_3);
	device_remove_file(dev, &dev_attr_comp_enable);
	device_remove_file(dev, &dev_attr_band_4_gain);
	device_remove_file(dev, &dev_attr_reverb_mix);
	device_remove_file(dev, &dev_attr_treble);
	device_remove_file(dev, &dev_attr_mod_param_5);
	device_remove_file(dev, &dev_attr_stomp_time);
	device_remove_file(dev, &dev_attr_mod_pre_post);
	device_remove_file(dev, &dev_attr_mod_param_1_double_precision);
	device_remove_file(dev, &dev_attr_tweak_param_select);
	device_remove_file(dev, &dev_attr_band_1_frequency);
	device_remove_file(dev, &dev_attr_tempo_msb);
	device_remove_file(dev, &dev_attr_pan);
	device_remove_file(dev, &dev_attr_delay_param_1_note_value);
	device_remove_file(dev, &dev_attr_delay_param_3);
	device_remove_file(dev, &dev_attr_amp_model_setup);
	device_remove_file(dev, &dev_attr_stomp_param_1_note_value);
	device_remove_file(dev, &dev_attr_fx_loop_on_off);
	device_remove_file(dev, &dev_attr_delay_pre_post);
	device_remove_file(dev, &dev_attr_band_4_frequency);
	device_remove_file(dev, &dev_attr_volume_tweak_pedal_assign);
	device_remove_file(dev, &dev_attr_mod_param_1);
	device_remove_file(dev, &dev_attr_mod_enable);
	device_remove_file(dev, &dev_attr_reverb_tone);
	device_remove_file(dev, &dev_attr_tap);
	device_remove_file(dev, &dev_attr_band_1_gain);
	device_remove_file(dev, &dev_attr_modulation_model);
	device_remove_file(dev, &dev_attr_reverb_pre_post);
	device_remove_file(dev, &dev_attr_amp_model);
	device_remove_file(dev, &dev_attr_mid);
	device_remove_file(dev, &dev_attr_stomp_param_4);
	device_remove_file(dev, &dev_attr_mod_param_2);
	device_remove_file(dev, &dev_attr_band_3_frequency);
	device_remove_file(dev, &dev_attr_mod_volume_mix);
	device_remove_file(dev, &dev_attr_delay_param_5);
	device_remove_file(dev, &dev_attr_roomlevel);
	device_remove_file(dev, &dev_attr_effect_setup);
	device_remove_file(dev, &dev_attr_delay_param_1_double_precision);
	device_remove_file(dev, &dev_attr_mod_param_4);
	device_remove_file(dev, &dev_attr_mic_selection);
	device_remove_file(dev, &dev_attr_chan_vol);
	device_remove_file(dev, &dev_attr_tweak);
	device_remove_file(dev, &dev_attr_band_2_gain);
	device_remove_file(dev, &dev_attr_delay_model);
	device_remove_file(dev, &dev_attr_delay_param_1);
	device_remove_file(dev, &dev_attr_stomp_param_5);
	device_remove_file(dev, &dev_attr_stomp_enable);
	device_remove_file(dev, &dev_attr_delay_enable);
	device_remove_file(dev, &dev_attr_stomp_param_6);
	device_remove_file(dev, &dev_attr_reverb_pre_delay);
	device_remove_file(dev, &dev_attr_stomp_model);
	device_remove_file(dev, &dev_attr_bass);
	device_remove_file(dev, &dev_attr_tuner);
	device_remove_file(dev, &dev_attr_gate_decay_time);
	device_remove_file(dev, &dev_attr_mod_param_3);
	device_remove_file(dev, &dev_attr_stomp_param_2);
	device_remove_file(dev, &dev_attr_noise_gate_enable);
	device_remove_file(dev, &dev_attr_band_2_frequency);
	device_remove_file(dev, &dev_attr_volume_pedal_minimum);
	device_remove_file(dev, &dev_attr_gate_threshold);
	device_remove_file(dev, &dev_attr_drive);
	device_remove_file(dev, &dev_attr_bypass_volume);
	device_remove_file(dev, &dev_attr_delay_param_4);
	device_remove_file(dev, &dev_attr_reverb_enable);
	device_remove_file(dev, &dev_attr_compression_threshold);
	device_remove_file(dev, &dev_attr_mod_param_1_note_value);
	device_remove_file(dev, &dev_attr_volume_pre_post);
	device_remove_file(dev, &dev_attr_reverb_decay);
	device_remove_file(dev, &dev_attr_wah_position);
	device_remove_file(dev, &dev_attr_delay_volume_mix);
	device_remove_file(dev, &dev_attr_reverb_type);
	device_remove_file(dev, &dev_attr_band_3_gain);
	device_remove_file(dev, &dev_attr_wah_enable);
	device_remove_file(dev, &dev_attr_compression_gain);
}


EXPORT_SYMBOL(podxtpro_create_files);
EXPORT_SYMBOL(podxtpro_remove_files);
