/*
 * Line6 PODxt Pro USB driver - 0.5
 *
 * Copyright (C) 2004, 2005 Markus Grabner (grabner@icg.tu-graz.ac.at)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation, version 2.
 *
 */

#ifndef PODXTPRO_CONTROL_H
#define PODXTPRO_CONTROL_H


/**
   List of PODxt Pro controls.
   See Appendix C of the "PODxt (Pro) Pilot's Handbook" by Line6.
   Comments after the number refer to the PODxt Pro firmware version required
   for this feature.
*/
enum {
	PODXTPRO_tweak                          =   1,
	PODXTPRO_wah_position                   =   4,
	PODXTPRO_compression_gain               =   5,
	PODXTPRO_vol_pedal_position             =   7,
	PODXTPRO_compression_threshold          =   9,
	PODXTPRO_pan                            =  10,
	PODXTPRO_amp_model_setup                =  11,
	PODXTPRO_amp_model                      =  12,  // 2.0
	PODXTPRO_drive                          =  13,
	PODXTPRO_bass                           =  14,
	PODXTPRO_mid                            =  15,
	PODXTPRO_treble                         =  16,
	PODXTPRO_chan_vol                       =  17,
	PODXTPRO_reverb_mix                     =  18,
	PODXTPRO_effect_setup                   =  19,
	PODXTPRO_band_1_frequency               =  20,  // 2.0
	PODXTPRO_presence                       =  21,
	PODXTPRO_noise_gate_enable              =  22,
	PODXTPRO_gate_threshold                 =  23,
	PODXTPRO_gate_decay_time                =  24,
	PODXTPRO_stomp_enable                   =  25,
	PODXTPRO_comp_enable                    =  26,
	PODXTPRO_stomp_time                     =  27,
	PODXTPRO_delay_enable                   =  28,
	PODXTPRO_mod_param_1                    =  29,
	PODXTPRO_delay_param_1                  =  30,
	PODXTPRO_delay_param_1_note_value       =  31,
	PODXTPRO_delay_param_2                  =  33,
	PODXTPRO_delay_volume_mix               =  34,
	PODXTPRO_delay_param_3                  =  35,
	PODXTPRO_reverb_enable                  =  36,
	PODXTPRO_reverb_type                    =  37,
	PODXTPRO_reverb_decay                   =  38,
	PODXTPRO_reverb_tone                    =  39,
	PODXTPRO_reverb_pre_delay               =  40,
	PODXTPRO_reverb_pre_post                =  41,
	PODXTPRO_band_2_frequency               =  42,  // 2.0
	PODXTPRO_wah_enable                     =  43,
	PODXTPRO_volume_pedal_minimum           =  46,  // 2.0
	PODXTPRO_volume_pre_post                =  47,
	PODXTPRO_mod_enable                     =  50,
	PODXTPRO_mod_param_1_note_value         =  51,
	PODXTPRO_mod_param_2                    =  52,
	PODXTPRO_mod_param_3                    =  53,
	PODXTPRO_mod_param_4                    =  54,
	PODXTPRO_mod_param_5                    =  55,
	PODXTPRO_mod_volume_mix                 =  56,
	PODXTPRO_mod_pre_post                   =  57,
	PODXTPRO_modulation_model               =  58,
	PODXTPRO_band_3_frequency               =  60,  // 2.0
	PODXTPRO_mod_param_1_double_precision   =  61,
	PODXTPRO_delay_param_1_double_precision =  62,
	PODXTPRO_eq_enable                      =  63,  // 2.0
	PODXTPRO_tap                            =  64,
	PODXTPRO_volume_tweak_pedal_assign      =  65,
	PODXTPRO_tuner                          =  69,
	PODXTPRO_mic_selection                  =  70,
	PODXTPRO_cabinet_model                  =  71,
	PODXTPRO_stomp_model                    =  75,
	PODXTPRO_roomlevel                      =  76,
	PODXTPRO_band_4_frequency               =  77,  // 2.0
	PODXTPRO_stomp_param_1_note_value       =  78,
	PODXTPRO_stomp_param_2                  =  79,
	PODXTPRO_stomp_param_3                  =  80,
	PODXTPRO_stomp_param_4                  =  81,
	PODXTPRO_stomp_param_5                  =  82,
	PODXTPRO_stomp_param_6                  =  83,
	PODXTPRO_delay_param_4                  =  85,
	PODXTPRO_delay_param_5                  =  86,
	PODXTPRO_delay_pre_post                 =  87,
	PODXTPRO_delay_model                    =  88,
	PODXTPRO_tempo_msb                      =  89,
	PODXTPRO_tempo_lsb                      =  90,
	PODXTPRO_bypass_volume                  = 105,  // 2.14 (undocumented)
	PODXTPRO_fx_loop_on_off                 = 107,  // (undocumented)
	PODXTPRO_tweak_param_select             = 108,
	PODXTPRO_band_1_gain                    = 114,  // 2.0
	PODXTPRO_band_2_gain                    = 116,  // 2.0
	PODXTPRO_band_3_gain                    = 117,  // 2.0
	PODXTPRO_band_4_gain                    = 119   // 2.0
};


extern void podxtpro_create_files(struct device *dev);
extern void podxtpro_remove_files(struct device *dev);


#endif
