#ifndef IEEE80211_STA_H
#define IEEE80211_STA_H

/* Parsed Information Elements */
struct ieee802_11_elems {
	u8 *ssid;
	u8 ssid_len;
	u8 *supp_rates;
	u8 supp_rates_len;
	u8 *fh_params;
	u8 fh_params_len;
	u8 *ds_params;
	u8 ds_params_len;
	u8 *cf_params;
	u8 cf_params_len;
	u8 *tim;
	u8 tim_len;
	u8 *ibss_params;
	u8 ibss_params_len;
	u8 *challenge;
	u8 challenge_len;
};

typedef enum { ParseOK = 0, ParseUnknown = 1, ParseFailed = -1 } ParseRes;

struct ieee80211_chan_range {
	u8 min;
	u8 max;
};

struct ieee80211_dup_cache {
	u8 addr[ETH_ALEN];
	u16 seq_ctl;
	unsigned long last_rx;
};

struct ieee80211_data {
	struct net_device *dev;
	struct ieee80211_device *ieee;

	int (*tx)(struct net_device *dev, struct sk_buff *skb);

	void (*scan)(struct net_device *dev);
	void (*associate)(struct net_device *dev);
	void (*setup_ibss)(struct net_device *dev, int start);
	void (*link_change)(struct net_device *dev, int link);
	void (*link_monitor)(struct net_device *dev);
	int (*set_channel)(struct net_device *dev, unsigned int channel);

	struct work_struct work;

#define AUTO_ASSOCIATE	(1<<0)
#define AUTO_RATE	(1<<1)
#define ANY_SSID	(1<<2)
#define PREF_BSSID_SET	(1<<3)
#define PREV_BSSID_SET	(1<<4)
#define LINK_ON 	(1<<5)
#define SCAN_NOTIFY	(1<<6)
#define SOFT_SCAN	(1<<7)
#define SOFT_ASSOCIATE	(1<<8)

	u32 flags;
	
	char nick[IW_ESSID_MAX_SIZE];

	int wpa_version;	/* IW_AUTH_WPA_VERSION */
	int cipher_pairwise;	/* IW_AUTH_CIPHER_PAIRWISE */
	int cipher_group;	/* IW_AUTH_CIPHER_GROUP */
	int auth_alg;		/* IW_AUTH_80211_AUTH_ALG */
	
	unsigned int auth_tries;
	unsigned int assoc_tries;
	struct {
		unsigned int auth_state;
		u8 *challenge;
		unsigned int auth_algorithm;
		struct ieee80211_network *network;
	} bss;

#define IEEE80211_DUP_CACHE_SIZE 4
	struct ieee80211_dup_cache tuple[IEEE80211_DUP_CACHE_SIZE];
	struct iw_scan_req scan_param;

	u8 bssid[ETH_ALEN];
	u8 rate;
	u8 pref_channel;
	u8 channel, scan_channel;
	struct ieee80211_chan_range chan_range;
	int num_supp_rates;
	u8 *supp_rates;

	u8 ssid[IW_ESSID_MAX_SIZE];
	size_t ssid_len;
	u8 pref_bssid[ETH_ALEN];
	u8 prev_bssid[ETH_ALEN];

	u16 aid;
	u64 timestamp;
	u16 capab, beacon_interval, listen_interval;
};

static const u8 IEEE80211_B_RATES[] = { 0x02, 0x04, 0x0b, 0x16, 0x00 };

void ieee80211_init(struct ieee80211_data *data);
void ieee80211_rx_mgmt(struct ieee80211_data *data, struct sk_buff *skb,
		       struct ieee80211_rx_stats *rx_status);
void ieee80211_start_scan(struct ieee80211_data *data);
void ieee80211_stop(struct ieee80211_data *data);

void ieee80211_send_deauth(struct ieee80211_data *data, u16 reason, u8 *addr);
void ieee80211_send_disassoc(struct ieee80211_data *data, u16 reason, u8 *addr);

int ieee80211_filter_duplicates(struct ieee80211_dup_cache *cache, struct ieee80211_hdr_3addr *hdr);
u8 ieee80211_get_rate(struct ieee80211_data *data, u8 *addr);

void ieee80211_linkcheck(struct ieee80211_data *data);

#endif /* IEEE80211_STA_H */
