#ifndef PRISM54MAGIC_H
#define PRISM54MAGIC_H

/*
 * Magic packets for softmac Prism54 hardware
 *
 * Copyright (c) 2006, Michael Wu <flamingice@sourmilk.net>
 *
 * Based on the islsm (softmac prism54) driver, which is:
 * Copyright 2004-2006 Jean-Baptiste Note <jbnote@gmail.com>, et al.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

/* usb version 1 packet */
static const char p54u_net2280_magic_packet[86] = {
	0x01, 0x80, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
	0x00,
	0x00, 0x14, 0x0a, 0x06,
	0x02, 0x00, 0x1f, 0x00, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1f,
	0x00,
	0xff, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0x00, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1f,
	0x00,
	0xff, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0x00, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1f,
	0x00,
	0xff, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0x00, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1f,
	0x00,
	0xff, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* usb version 2 packet */
static const char p54u_3887_magic_packet[86] = {
	0x01, 0x80, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
	0x00,
	0x00, 0x14, 0x0a, 0x06,
	0x02, 0x00, 0x03, 0x00, 0x07, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x07,
	0x00,
	0x0f, 0x00, 0x2f, 0x00,
	0x03, 0x00, 0x0f, 0x00, 0xff, 0x03, 0x2b, 0x00, 0x07, 0x00, 0x0f,
	0x00,
	0xff, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x05
};

/* pci packet. 5a values are "don't care" values. */
static const char p54p_magic_packet[88] = {
	0x01, 0x80, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
        0x00,
        0x00, 0x14, 0x0a, 0x06,
        0x02, 0x5a, 0x03, 0x00, 0x07, 0x00, 0x2f, 0x00, 0x02, 0x5a, 0x07,
        0x00,
        0x0f, 0x00, 0x5e, 0x00,
        0x03, 0x5a, 0x0f, 0x00, 0xff, 0x03, 0x00, 0x00, 0x07, 0x5a, 0x0f,
        0x00,
        0xff, 0x03, 0x00, 0x00,
        0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a,
        0x5a,
        0x5a, 0x5a, 0x5a, 0x5a,
        0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a,
        0x5a,
        0x5a, 0x5a, 0x5a, 0x5a,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#endif /* PRISM54MAGIC_H */
