/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: rt_config.h 
 *              
 *      Abstract: Central header file to maintain all include files for all
 *                NDIS miniport driver routines 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      RoryC           21st Dec 02     Created
 *      MarkW           9th  Feb 04     Baseline of code
 *      Ivo 		27th Jun 04     Fixed Wireless Exts iport for ioctl
 ***************************************************************************/ 

 
#ifndef	__RT_CONFIG_H__
#define	__RT_CONFIG_H__

#define	DRV_NAME	"rt2400"
#define DRV_VERSION	"1.2.2 BETA3"
#define DRV_RELDATE	"2005/07/31"

/* Keep these in sync with the strings above */
#define DRV_VERSION_MAJOR 1
#define DRV_VERSION_MINOR 2
#define DRV_VERSION_SUB   2 
#define DRV_BUILD_YEAR    2005
#define DRV_BUILD_MONTH   7 
#define DRV_BUILD_DAY     31 

#define	PROFILE_PATH	"/etc/Ralink/RT2400/RT2400.dat"

/* Operational parameters that are set at compile time. */
#if !defined(__OPTIMIZE__)  ||  !defined(__KERNEL__)
#warning  You must compile this file with the correct options!
#warning  See the last lines of the source file.
#error  You must compile this driver with "-O".
#endif

#include <linux/version.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/pci.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/ethtool.h>
#include <linux/wireless.h>
#include <linux/proc_fs.h>
#include <linux/delay.h>
#include <linux/if_arp.h>

#if LINUX_VERSION_CODE >= 0x20407
#include <linux/mii.h>
#endif
#include <asm/processor.h>		/* Processor type for cache alignment. */
#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>

#if WIRELESS_EXT > 12
#include <net/iw_handler.h> /* New driver API */
#endif /* WIRELESS_EXT > 12 */

// The type definition has to be placed before including rt2460.h
#ifndef ULONG
#define	CHAR			char
#define	INT				int
#define	UINT			u32
#define ULONG			u32
#define USHORT			u16
#define UCHAR			u8

#define BOOLEAN			u8
#define LARGE_INTEGER	s64
#define VOID			void
#define	LONG			int
#define ULONGLONG		u64
typedef VOID	*PVOID;
typedef CHAR	*PCHAR;
typedef UCHAR	*PUCHAR;
typedef LONG	*PLONG;
#endif

#define	IN
#define	OUT

#define TRUE		1
#define FALSE		0

#define	NDIS_STATUS				INT
#define	NDIS_STATUS_SUCCESS		0x00
#define NDIS_STATUS_FAILURE		0x01
#define	NDIS_STATUS_RESOURCES	0x03

#include	"rt2460.h"
#include	"rtmp_def.h"
#include	"rtmp.h"
#include	"mlme.h"
#include	"oid.h"

#endif	// __RT_CONFIG_H__
