/* vim:set noet ts=4: */
/*
 * ibus - The Input Bus
 *
 * Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */
#ifndef __Key_COMPOSE_DATA_H_
#define __Key_COMPOSE_DATA_H_

static const quint16 ibus_compose_seqs_compact[] = {
Key_dead_stroke, 138, 226, 235, 235, 235,
Key_Greek_accentdieresis, 235, 239, 239, 239, 239,
Key_dead_grave, 239, 299, 386, 598, 598,
Key_dead_acute, 598, 664, 760, 1036, 1036,
Key_dead_circumflex, 1036, 1176, 1176, 1376, 1376,
Key_dead_tilde, 1376, 1458, 1521, 1661, 1661,
Key_dead_macron, 1661, 1707, 1707, 1779, 1779,
Key_dead_breve, 1779, 1833, 1833, 1857, 1857,
Key_dead_abovedot, 1857, 1887, 1890, 1922, 1922,
Key_dead_diaeresis, 1922, 2010, 2019, 2043, 2043,
Key_dead_abovering, 2043, 2053, 2053, 2053, 2053,
Key_dead_doubleacute, 2053, 2063, 2063, 2063, 2063,
Key_dead_caron, 2063, 2089, 2089, 2097, 2097,
Key_dead_cedilla, 2097, 2111, 2111, 2111, 2111,
Key_dead_ogonek, 2111, 2121, 2121, 2121, 2121,
Key_dead_iota, 2121, 2143, 2242, 2674, 3334,
Key_dead_voiced_sound, 3334, 3380, 3380, 3380, 3380,
Key_dead_semivoiced_sound, 3380, 3390, 3390, 3390, 3390,
Key_dead_belowdot, 3390, 3400, 3400, 3416, 3416,
Key_dead_hook, 3416, 3494, 3494, 3550, 3550,
Key_dead_psili, 3550, 3578, 3578, 3578, 3578,
Key_dead_dasia, 3578, 3610, 3610, 3610, 3610,
Key_Multi_key, 3610, 3610, 9589, 13297, 15157,
Key_space, 0x002F,
Key_2, 0x01BB,
Key_A, 0x023A,
Key_B, 0x0243,
Key_C, 0x023B,
Key_D, 0x0110,
Key_E, 0x0246,
Key_G, 0x01E4,
Key_H, 0x0126,
Key_I, 0x0197,
Key_J, 0x0248,
Key_L, 0x0141,
Key_O, 0x00D8,
Key_P, 0x2C63,
Key_R, 0x024C,
Key_T, 0x0166,
Key_U, 0x0244,
Key_Y, 0x024E,
Key_Z, 0x01B5,
Key_a, 0x2C65,
Key_b, 0x0180,
Key_c, 0x023C,
Key_d, 0x0111,
Key_e, 0x0247,
Key_g, 0x01E5,
Key_h, 0x0127,
Key_i, 0x0268,
Key_j, 0x0249,
Key_l, 0x0142,
Key_o, 0x00F8,
Key_p, 0x1D7D,
Key_r, 0x024D,
Key_t, 0x0167,
Key_u, 0x0289,
Key_y, 0x024F,
Key_z, 0x01B6,
Key_nobreakspace, 0x0338,
Key_Oacute, 0x01FE,
Key_oacute, 0x01FF,
0x0237, 0x025F,
0x0269, 0x1D7C,
Key_dead_stroke, 0x002F,
Key_lessthanequal, 0x2270,
Key_greaterthanequal, 0x2271,
Key_dead_acute, Key_O, 0x01FE,
Key_dead_acute, Key_o, 0x01FF,
Key_dead_abovedot, Key_j, 0x025F,
Key_Greek_iota, 0x0390,
Key_Greek_upsilon, 0x03B0,
Key_space, 0x0060,
Key_V, 0x01DB,
Key_v, 0x01DC,
Key_Abreve, 0x1EB0,
Key_abreve, 0x1EB1,
Key_Emacron, 0x1E14,
Key_emacron, 0x1E15,
Key_Omacron, 0x1E50,
Key_omacron, 0x1E51,
Key_Cyrillic_ie, 0x0450,
Key_Cyrillic_i, 0x045D,
Key_Cyrillic_IE, 0x0400,
Key_Cyrillic_I, 0x040D,
Key_Greek_iotadieresis, 0x1FD2,
Key_Greek_upsilondieresis, 0x1FE2,
Key_Greek_ALPHA, 0x1FBA,
Key_Greek_EPSILON, 0x1FC8,
Key_Greek_ETA, 0x1FCA,
Key_Greek_IOTA, 0x1FDA,
Key_Greek_OMICRON, 0x1FF8,
Key_Greek_UPSILON, 0x1FEA,
Key_Greek_OMEGA, 0x1FFA,
Key_Greek_alpha, 0x1F70,
Key_Greek_epsilon, 0x1F72,
Key_Greek_eta, 0x1F74,
Key_Greek_iota, 0x1F76,
Key_Greek_omicron, 0x1F78,
Key_Greek_upsilon, 0x1F7A,
Key_Greek_omega, 0x1F7C,
Key_dead_grave, 0x0060,
Key_dead_diaeresis, Key_Greek_iota, 0x1FD2,
Key_dead_diaeresis, Key_Greek_upsilon, 0x1FE2,
Key_dead_psili, Key_Greek_ALPHA, 0x1F0A,
Key_dead_psili, Key_Greek_EPSILON, 0x1F1A,
Key_dead_psili, Key_Greek_ETA, 0x1F2A,
Key_dead_psili, Key_Greek_IOTA, 0x1F3A,
Key_dead_psili, Key_Greek_OMICRON, 0x1F4A,
Key_dead_psili, Key_Greek_OMEGA, 0x1F6A,
Key_dead_psili, Key_Greek_alpha, 0x1F02,
Key_dead_psili, Key_Greek_epsilon, 0x1F12,
Key_dead_psili, Key_Greek_eta, 0x1F22,
Key_dead_psili, Key_Greek_iota, 0x1F32,
Key_dead_psili, Key_Greek_omicron, 0x1F42,
Key_dead_psili, Key_Greek_upsilon, 0x1F52,
Key_dead_psili, Key_Greek_omega, 0x1F62,
Key_dead_dasia, Key_Greek_ALPHA, 0x1F0B,
Key_dead_dasia, Key_Greek_EPSILON, 0x1F1B,
Key_dead_dasia, Key_Greek_ETA, 0x1F2B,
Key_dead_dasia, Key_Greek_IOTA, 0x1F3B,
Key_dead_dasia, Key_Greek_OMICRON, 0x1F4B,
Key_dead_dasia, Key_Greek_UPSILON, 0x1F5B,
Key_dead_dasia, Key_Greek_OMEGA, 0x1F6B,
Key_dead_dasia, Key_Greek_alpha, 0x1F03,
Key_dead_dasia, Key_Greek_epsilon, 0x1F13,
Key_dead_dasia, Key_Greek_eta, 0x1F23,
Key_dead_dasia, Key_Greek_iota, 0x1F33,
Key_dead_dasia, Key_Greek_omicron, 0x1F43,
Key_dead_dasia, Key_Greek_upsilon, 0x1F53,
Key_dead_dasia, Key_Greek_omega, 0x1F63,
Key_Multi_key, Key_quotedbl, Key_U, 0x01DB,
Key_Multi_key, Key_quotedbl, Key_u, 0x01DC,
Key_Multi_key, Key_quotedbl, Key_Greek_iota, 0x1FD2,
Key_Multi_key, Key_quotedbl, Key_Greek_upsilon, 0x1FE2,
Key_Multi_key, Key_parenleft, Key_Greek_ALPHA, 0x1F0B,
Key_Multi_key, Key_parenleft, Key_Greek_EPSILON, 0x1F1B,
Key_Multi_key, Key_parenleft, Key_Greek_ETA, 0x1F2B,
Key_Multi_key, Key_parenleft, Key_Greek_IOTA, 0x1F3B,
Key_Multi_key, Key_parenleft, Key_Greek_OMICRON, 0x1F4B,
Key_Multi_key, Key_parenleft, Key_Greek_UPSILON, 0x1F5B,
Key_Multi_key, Key_parenleft, Key_Greek_OMEGA, 0x1F6B,
Key_Multi_key, Key_parenleft, Key_Greek_alpha, 0x1F03,
Key_Multi_key, Key_parenleft, Key_Greek_epsilon, 0x1F13,
Key_Multi_key, Key_parenleft, Key_Greek_eta, 0x1F23,
Key_Multi_key, Key_parenleft, Key_Greek_iota, 0x1F33,
Key_Multi_key, Key_parenleft, Key_Greek_omicron, 0x1F43,
Key_Multi_key, Key_parenleft, Key_Greek_upsilon, 0x1F53,
Key_Multi_key, Key_parenleft, Key_Greek_omega, 0x1F63,
Key_Multi_key, Key_parenright, Key_Greek_ALPHA, 0x1F0A,
Key_Multi_key, Key_parenright, Key_Greek_EPSILON, 0x1F1A,
Key_Multi_key, Key_parenright, Key_Greek_ETA, 0x1F2A,
Key_Multi_key, Key_parenright, Key_Greek_IOTA, 0x1F3A,
Key_Multi_key, Key_parenright, Key_Greek_OMICRON, 0x1F4A,
Key_Multi_key, Key_parenright, Key_Greek_OMEGA, 0x1F6A,
Key_Multi_key, Key_parenright, Key_Greek_alpha, 0x1F02,
Key_Multi_key, Key_parenright, Key_Greek_epsilon, 0x1F12,
Key_Multi_key, Key_parenright, Key_Greek_eta, 0x1F22,
Key_Multi_key, Key_parenright, Key_Greek_iota, 0x1F32,
Key_Multi_key, Key_parenright, Key_Greek_omicron, 0x1F42,
Key_Multi_key, Key_parenright, Key_Greek_upsilon, 0x1F52,
Key_Multi_key, Key_parenright, Key_Greek_omega, 0x1F62,
Key_Multi_key, Key_plus, Key_O, 0x1EDC,
Key_Multi_key, Key_plus, Key_U, 0x1EEA,
Key_Multi_key, Key_plus, Key_o, 0x1EDD,
Key_Multi_key, Key_plus, Key_u, 0x1EEB,
Key_Multi_key, Key_U, Key_A, 0x1EB0,
Key_Multi_key, Key_U, Key_a, 0x1EB1,
Key_Multi_key, Key_asciicircum, Key_A, 0x1EA6,
Key_Multi_key, Key_asciicircum, Key_E, 0x1EC0,
Key_Multi_key, Key_asciicircum, Key_O, 0x1ED2,
Key_Multi_key, Key_asciicircum, Key_a, 0x1EA7,
Key_Multi_key, Key_asciicircum, Key_e, 0x1EC1,
Key_Multi_key, Key_asciicircum, Key_o, 0x1ED3,
Key_Multi_key, Key_underscore, Key_E, 0x1E14,
Key_Multi_key, Key_underscore, Key_O, 0x1E50,
Key_Multi_key, Key_underscore, Key_e, 0x1E15,
Key_Multi_key, Key_underscore, Key_o, 0x1E51,
Key_Multi_key, Key_b, Key_A, 0x1EB0,
Key_Multi_key, Key_b, Key_a, 0x1EB1,
Key_Multi_key, Key_macron, Key_E, 0x1E14,
Key_Multi_key, Key_macron, Key_O, 0x1E50,
Key_Multi_key, Key_macron, Key_e, 0x1E15,
Key_Multi_key, Key_macron, Key_o, 0x1E51,
Key_space, 0x0027,
Key_V, 0x01D7,
Key_v, 0x01D8,
Key_Abreve, 0x1EAE,
Key_abreve, 0x1EAF,
Key_Emacron, 0x1E16,
Key_emacron, 0x1E17,
Key_Utilde, 0x1E78,
Key_omacron, 0x1E53,
Key_utilde, 0x1E79,
Key_Cyrillic_ghe, 0x0453,
Key_Cyrillic_ka, 0x045C,
Key_Cyrillic_GHE, 0x0403,
Key_Cyrillic_KA, 0x040C,
Key_Greek_iotadieresis, 0x0390,
Key_Greek_upsilondieresis, 0x03B0,
Key_Greek_ALPHA, 0x0386,
Key_Greek_EPSILON, 0x0388,
Key_Greek_ETA, 0x0389,
Key_Greek_IOTA, 0x038A,
Key_Greek_OMICRON, 0x038C,
Key_Greek_UPSILON, 0x038E,
Key_Greek_OMEGA, 0x038F,
Key_Greek_alpha, 0x03AC,
Key_Greek_epsilon, 0x03AD,
Key_Greek_eta, 0x03AE,
Key_Greek_iota, 0x03AF,
Key_Greek_omicron, 0x03CC,
Key_Greek_upsilon, 0x03CD,
Key_Greek_omega, 0x03CE,
Key_Sabovedot, 0x1E64,
Key_sabovedot, 0x1E65,
Key_dead_acute, 0x00B4,
Key_dead_stroke, Key_O, 0x01FE,
Key_dead_stroke, Key_o, 0x01FF,
Key_dead_diaeresis, Key_space, 0x0385,
Key_dead_diaeresis, Key_Greek_iota, 0x0390,
Key_dead_diaeresis, Key_Greek_upsilon, 0x03B0,
Key_dead_psili, Key_Greek_ALPHA, 0x1F0C,
Key_dead_psili, Key_Greek_EPSILON, 0x1F1C,
Key_dead_psili, Key_Greek_ETA, 0x1F2C,
Key_dead_psili, Key_Greek_IOTA, 0x1F3C,
Key_dead_psili, Key_Greek_OMICRON, 0x1F4C,
Key_dead_psili, Key_Greek_OMEGA, 0x1F6C,
Key_dead_psili, Key_Greek_alpha, 0x1F04,
Key_dead_psili, Key_Greek_epsilon, 0x1F14,
Key_dead_psili, Key_Greek_eta, 0x1F24,
Key_dead_psili, Key_Greek_iota, 0x1F34,
Key_dead_psili, Key_Greek_omicron, 0x1F44,
Key_dead_psili, Key_Greek_upsilon, 0x1F54,
Key_dead_psili, Key_Greek_omega, 0x1F64,
Key_dead_dasia, Key_Greek_ALPHA, 0x1F0D,
Key_dead_dasia, Key_Greek_EPSILON, 0x1F1D,
Key_dead_dasia, Key_Greek_ETA, 0x1F2D,
Key_dead_dasia, Key_Greek_IOTA, 0x1F3D,
Key_dead_dasia, Key_Greek_OMICRON, 0x1F4D,
Key_dead_dasia, Key_Greek_UPSILON, 0x1F5D,
Key_dead_dasia, Key_Greek_OMEGA, 0x1F6D,
Key_dead_dasia, Key_Greek_alpha, 0x1F05,
Key_dead_dasia, Key_Greek_epsilon, 0x1F15,
Key_dead_dasia, Key_Greek_eta, 0x1F25,
Key_dead_dasia, Key_Greek_iota, 0x1F35,
Key_dead_dasia, Key_Greek_omicron, 0x1F45,
Key_dead_dasia, Key_Greek_upsilon, 0x1F55,
Key_dead_dasia, Key_Greek_omega, 0x1F65,
Key_Multi_key, Key_quotedbl, Key_I, 0x1E2E,
Key_Multi_key, Key_quotedbl, Key_U, 0x01D7,
Key_Multi_key, Key_quotedbl, Key_i, 0x1E2F,
Key_Multi_key, Key_quotedbl, Key_u, 0x01D8,
Key_Multi_key, Key_quotedbl, Key_Greek_iota, 0x0390,
Key_Multi_key, Key_quotedbl, Key_Greek_upsilon, 0x03B0,
Key_Multi_key, Key_parenleft, Key_Greek_ALPHA, 0x1F0D,
Key_Multi_key, Key_parenleft, Key_Greek_EPSILON, 0x1F1D,
Key_Multi_key, Key_parenleft, Key_Greek_ETA, 0x1F2D,
Key_Multi_key, Key_parenleft, Key_Greek_IOTA, 0x1F3D,
Key_Multi_key, Key_parenleft, Key_Greek_OMICRON, 0x1F4D,
Key_Multi_key, Key_parenleft, Key_Greek_UPSILON, 0x1F5D,
Key_Multi_key, Key_parenleft, Key_Greek_OMEGA, 0x1F6D,
Key_Multi_key, Key_parenleft, Key_Greek_alpha, 0x1F05,
Key_Multi_key, Key_parenleft, Key_Greek_epsilon, 0x1F15,
Key_Multi_key, Key_parenleft, Key_Greek_eta, 0x1F25,
Key_Multi_key, Key_parenleft, Key_Greek_iota, 0x1F35,
Key_Multi_key, Key_parenleft, Key_Greek_omicron, 0x1F45,
Key_Multi_key, Key_parenleft, Key_Greek_upsilon, 0x1F55,
Key_Multi_key, Key_parenleft, Key_Greek_omega, 0x1F65,
Key_Multi_key, Key_parenright, Key_Greek_ALPHA, 0x1F0C,
Key_Multi_key, Key_parenright, Key_Greek_EPSILON, 0x1F1C,
Key_Multi_key, Key_parenright, Key_Greek_ETA, 0x1F2C,
Key_Multi_key, Key_parenright, Key_Greek_IOTA, 0x1F3C,
Key_Multi_key, Key_parenright, Key_Greek_OMICRON, 0x1F4C,
Key_Multi_key, Key_parenright, Key_Greek_OMEGA, 0x1F6C,
Key_Multi_key, Key_parenright, Key_Greek_alpha, 0x1F04,
Key_Multi_key, Key_parenright, Key_Greek_epsilon, 0x1F14,
Key_Multi_key, Key_parenright, Key_Greek_eta, 0x1F24,
Key_Multi_key, Key_parenright, Key_Greek_iota, 0x1F34,
Key_Multi_key, Key_parenright, Key_Greek_omicron, 0x1F44,
Key_Multi_key, Key_parenright, Key_Greek_upsilon, 0x1F54,
Key_Multi_key, Key_parenright, Key_Greek_omega, 0x1F64,
Key_Multi_key, Key_plus, Key_O, 0x1EDA,
Key_Multi_key, Key_plus, Key_U, 0x1EE8,
Key_Multi_key, Key_plus, Key_o, 0x1EDB,
Key_Multi_key, Key_plus, Key_u, 0x1EE9,
Key_Multi_key, Key_comma, Key_C, 0x1E08,
Key_Multi_key, Key_comma, Key_c, 0x1E09,
Key_Multi_key, Key_slash, Key_O, 0x01FE,
Key_Multi_key, Key_slash, Key_o, 0x01FF,
Key_Multi_key, Key_U, Key_A, 0x1EAE,
Key_Multi_key, Key_U, Key_a, 0x1EAF,
Key_Multi_key, Key_asciicircum, Key_A, 0x1EA4,
Key_Multi_key, Key_asciicircum, Key_E, 0x1EBE,
Key_Multi_key, Key_asciicircum, Key_O, 0x1ED0,
Key_Multi_key, Key_asciicircum, Key_a, 0x1EA5,
Key_Multi_key, Key_asciicircum, Key_e, 0x1EBF,
Key_Multi_key, Key_asciicircum, Key_o, 0x1ED1,
Key_Multi_key, Key_underscore, Key_E, 0x1E16,
Key_Multi_key, Key_underscore, Key_O, 0x1E52,
Key_Multi_key, Key_underscore, Key_e, 0x1E17,
Key_Multi_key, Key_underscore, Key_o, 0x1E53,
Key_Multi_key, Key_b, Key_A, 0x1EAE,
Key_Multi_key, Key_b, Key_a, 0x1EAF,
Key_Multi_key, Key_o, Key_A, 0x01FA,
Key_Multi_key, Key_o, Key_a, 0x01FB,
Key_Multi_key, Key_asciitilde, Key_O, 0x1E4C,
Key_Multi_key, Key_asciitilde, Key_U, 0x1E78,
Key_Multi_key, Key_asciitilde, Key_o, 0x1E4D,
Key_Multi_key, Key_asciitilde, Key_u, 0x1E79,
Key_Multi_key, Key_macron, Key_E, 0x1E16,
Key_Multi_key, Key_macron, Key_O, 0x1E52,
Key_Multi_key, Key_macron, Key_e, 0x1E17,
Key_Multi_key, Key_macron, Key_o, 0x1E53,
Key_Multi_key, Key_cedilla, Key_C, 0x1E08,
Key_Multi_key, Key_cedilla, Key_c, 0x1E09,
Key_Multi_key, Key_KP_Divide, Key_O, 0x01FE,
Key_Multi_key, Key_KP_Divide, Key_o, 0x01FF,
Key_space, 0x005E,
Key_parenleft, 0x207D,
Key_parenright, 0x207E,
Key_plus, 0x207A,
Key_minus, 0x207B,
Key_0, 0x2070,
Key_1, 0x00B9,
Key_2, 0x00B2,
Key_3, 0x00B3,
Key_4, 0x2074,
Key_5, 0x2075,
Key_6, 0x2076,
Key_7, 0x2077,
Key_8, 0x2078,
Key_9, 0x2079,
Key_equal, 0x207C,
Key_nobreakspace, 0x0302,
Key_Agrave, 0x1EA6,
Key_Aacute, 0x1EA4,
Key_Atilde, 0x1EAA,
Key_Egrave, 0x1EC0,
Key_Eacute, 0x1EBE,
Key_Ograve, 0x1ED2,
Key_Oacute, 0x1ED0,
Key_Otilde, 0x1ED6,
Key_agrave, 0x1EA7,
Key_aacute, 0x1EA5,
Key_atilde, 0x1EAB,
Key_egrave, 0x1EC1,
Key_eacute, 0x1EBF,
Key_ograve, 0x1ED3,
Key_oacute, 0x1ED1,
Key_otilde, 0x1ED7,
Key_Ahook, 0x1EA8,
Key_ahook, 0x1EA9,
Key_Ehook, 0x1EC2,
Key_ehook, 0x1EC3,
Key_Etilde, 0x1EC4,
Key_etilde, 0x1EC5,
Key_Ohook, 0x1ED4,
Key_ohook, 0x1ED5,
0x2212, 0x207B,
0x4E00, 0x3192,
0x4E01, 0x319C,
0x4E09, 0x3194,
0x4E0A, 0x3196,
0x4E0B, 0x3198,
0x4E19, 0x319B,
0x4E2D, 0x3197,
0x4E59, 0x319A,
0x4E8C, 0x3193,
0x4EBA, 0x319F,
0x56DB, 0x3195,
0x5730, 0x319E,
0x5929, 0x319D,
0x7532, 0x3199,
Key_dead_circumflex, 0x005E,
Key_KP_Space, 0x00B2,
Key_KP_Add, 0x207A,
Key_KP_0, 0x2070,
Key_KP_1, 0x00B9,
Key_KP_2, 0x00B2,
Key_KP_3, 0x00B3,
Key_KP_4, 0x2074,
Key_KP_5, 0x2075,
Key_KP_6, 0x2076,
Key_KP_7, 0x2077,
Key_KP_8, 0x2078,
Key_KP_9, 0x2079,
Key_KP_Equal, 0x207C,
Key_Multi_key, Key_exclam, Key_A, 0x1EAC,
Key_Multi_key, Key_exclam, Key_E, 0x1EC6,
Key_Multi_key, Key_exclam, Key_O, 0x1ED8,
Key_Multi_key, Key_exclam, Key_a, 0x1EAD,
Key_Multi_key, Key_exclam, Key_e, 0x1EC7,
Key_Multi_key, Key_exclam, Key_o, 0x1ED9,
Key_Multi_key, Key_S, Key_M, 0x2120,
Key_Multi_key, Key_S, Key_m, 0x2120,
Key_Multi_key, Key_T, Key_M, 0x2122,
Key_Multi_key, Key_T, Key_m, 0x2122,
Key_Multi_key, Key_underscore, Key_a, 0x00AA,
Key_Multi_key, Key_underscore, Key_h, 0x02B0,
Key_Multi_key, Key_underscore, Key_i, 0x2071,
Key_Multi_key, Key_underscore, Key_j, 0x02B2,
Key_Multi_key, Key_underscore, Key_l, 0x02E1,
Key_Multi_key, Key_underscore, Key_n, 0x207F,
Key_Multi_key, Key_underscore, Key_o, 0x00BA,
Key_Multi_key, Key_underscore, Key_r, 0x02B3,
Key_Multi_key, Key_underscore, Key_s, 0x02E2,
Key_Multi_key, Key_underscore, Key_w, 0x02B7,
Key_Multi_key, Key_underscore, Key_x, 0x02E3,
Key_Multi_key, Key_underscore, Key_y, 0x02B8,
Key_Multi_key, Key_underscore, 0x0263, 0x02E0,
Key_Multi_key, Key_underscore, 0x0266, 0x02B1,
Key_Multi_key, Key_underscore, 0x0279, 0x02B4,
Key_Multi_key, Key_underscore, 0x027B, 0x02B5,
Key_Multi_key, Key_underscore, 0x0281, 0x02B6,
Key_Multi_key, Key_underscore, 0x0295, 0x02E4,
Key_Multi_key, Key_s, Key_M, 0x2120,
Key_Multi_key, Key_s, Key_m, 0x2120,
Key_Multi_key, Key_t, Key_M, 0x2122,
Key_Multi_key, Key_t, Key_m, 0x2122,
Key_Multi_key, Key_underbar, Key_a, 0x00AA,
Key_Multi_key, Key_underbar, Key_h, 0x02B0,
Key_Multi_key, Key_underbar, Key_i, 0x2071,
Key_Multi_key, Key_underbar, Key_j, 0x02B2,
Key_Multi_key, Key_underbar, Key_l, 0x02E1,
Key_Multi_key, Key_underbar, Key_n, 0x207F,
Key_Multi_key, Key_underbar, Key_o, 0x00BA,
Key_Multi_key, Key_underbar, Key_r, 0x02B3,
Key_Multi_key, Key_underbar, Key_s, 0x02E2,
Key_Multi_key, Key_underbar, Key_w, 0x02B7,
Key_Multi_key, Key_underbar, Key_x, 0x02E3,
Key_Multi_key, Key_underbar, Key_y, 0x02B8,
Key_Multi_key, Key_underbar, 0x0263, 0x02E0,
Key_Multi_key, Key_underbar, 0x0266, 0x02B1,
Key_Multi_key, Key_underbar, 0x0279, 0x02B4,
Key_Multi_key, Key_underbar, 0x027B, 0x02B5,
Key_Multi_key, Key_underbar, 0x0281, 0x02B6,
Key_Multi_key, Key_underbar, 0x0295, 0x02E4,
Key_space, 0x007E,
Key_less, 0x2272,
Key_equal, 0x2243,
Key_greater, 0x2273,
Key_Oacute, 0x1E4C,
Key_Odiaeresis, 0x1E4E,
Key_Uacute, 0x1E78,
Key_oacute, 0x1E4D,
Key_odiaeresis, 0x1E4F,
Key_uacute, 0x1E79,
Key_Abreve, 0x1EB4,
Key_abreve, 0x1EB5,
Key_Omacron, 0x022C,
Key_omacron, 0x022D,
Key_Greek_iotadieresis, 0x1FD7,
Key_Greek_upsilondieresis, 0x1FE7,
Key_Greek_alpha, 0x1FB6,
Key_Greek_eta, 0x1FC6,
Key_Greek_iota, 0x1FD6,
Key_Greek_upsilon, 0x1FE6,
Key_Greek_omega, 0x1FF6,
0x1F00, 0x1F06,
0x1F01, 0x1F07,
0x1F08, 0x1F0E,
0x1F09, 0x1F0F,
0x1F20, 0x1F26,
0x1F21, 0x1F27,
0x1F28, 0x1F2E,
0x1F29, 0x1F2F,
0x1F30, 0x1F36,
0x1F31, 0x1F37,
0x1F38, 0x1F3E,
0x1F39, 0x1F3F,
0x1F50, 0x1F56,
0x1F51, 0x1F57,
0x1F59, 0x1F5F,
0x1F60, 0x1F66,
0x1F61, 0x1F67,
0x1F68, 0x1F6E,
0x1F69, 0x1F6F,
Key_dead_tilde, 0x007E,
Key_dead_diaeresis, Key_Greek_iota, 0x1FD7,
Key_dead_diaeresis, Key_Greek_upsilon, 0x1FE7,
Key_dead_psili, Key_Greek_ALPHA, 0x1F0E,
Key_dead_psili, Key_Greek_ETA, 0x1F2E,
Key_dead_psili, Key_Greek_IOTA, 0x1F3E,
Key_dead_psili, Key_Greek_OMEGA, 0x1F6E,
Key_dead_psili, Key_Greek_alpha, 0x1F06,
Key_dead_psili, Key_Greek_eta, 0x1F26,
Key_dead_psili, Key_Greek_iota, 0x1F36,
Key_dead_psili, Key_Greek_upsilon, 0x1F56,
Key_dead_psili, Key_Greek_omega, 0x1F66,
Key_dead_dasia, Key_Greek_ALPHA, 0x1F0F,
Key_dead_dasia, Key_Greek_ETA, 0x1F2F,
Key_dead_dasia, Key_Greek_IOTA, 0x1F3F,
Key_dead_dasia, Key_Greek_UPSILON, 0x1F5F,
Key_dead_dasia, Key_Greek_OMEGA, 0x1F6F,
Key_dead_dasia, Key_Greek_alpha, 0x1F07,
Key_dead_dasia, Key_Greek_eta, 0x1F27,
Key_dead_dasia, Key_Greek_iota, 0x1F37,
Key_dead_dasia, Key_Greek_upsilon, 0x1F57,
Key_dead_dasia, Key_Greek_omega, 0x1F67,
Key_Multi_key, Key_quotedbl, Key_Greek_iota, 0x1FD7,
Key_Multi_key, Key_quotedbl, Key_Greek_upsilon, 0x1FE7,
Key_Multi_key, Key_parenleft, Key_Greek_ALPHA, 0x1F0F,
Key_Multi_key, Key_parenleft, Key_Greek_ETA, 0x1F2F,
Key_Multi_key, Key_parenleft, Key_Greek_IOTA, 0x1F3F,
Key_Multi_key, Key_parenleft, Key_Greek_UPSILON, 0x1F5F,
Key_Multi_key, Key_parenleft, Key_Greek_OMEGA, 0x1F6F,
Key_Multi_key, Key_parenleft, Key_Greek_alpha, 0x1F07,
Key_Multi_key, Key_parenleft, Key_Greek_eta, 0x1F27,
Key_Multi_key, Key_parenleft, Key_Greek_iota, 0x1F37,
Key_Multi_key, Key_parenleft, Key_Greek_upsilon, 0x1F57,
Key_Multi_key, Key_parenleft, Key_Greek_omega, 0x1F67,
Key_Multi_key, Key_parenright, Key_Greek_ALPHA, 0x1F0E,
Key_Multi_key, Key_parenright, Key_Greek_ETA, 0x1F2E,
Key_Multi_key, Key_parenright, Key_Greek_IOTA, 0x1F3E,
Key_Multi_key, Key_parenright, Key_Greek_OMEGA, 0x1F6E,
Key_Multi_key, Key_parenright, Key_Greek_alpha, 0x1F06,
Key_Multi_key, Key_parenright, Key_Greek_eta, 0x1F26,
Key_Multi_key, Key_parenright, Key_Greek_iota, 0x1F36,
Key_Multi_key, Key_parenright, Key_Greek_upsilon, 0x1F56,
Key_Multi_key, Key_parenright, Key_Greek_omega, 0x1F66,
Key_Multi_key, Key_plus, Key_O, 0x1EE0,
Key_Multi_key, Key_plus, Key_U, 0x1EEE,
Key_Multi_key, Key_plus, Key_o, 0x1EE1,
Key_Multi_key, Key_plus, Key_u, 0x1EEF,
Key_Multi_key, Key_U, Key_A, 0x1EB4,
Key_Multi_key, Key_U, Key_a, 0x1EB5,
Key_Multi_key, Key_asciicircum, Key_A, 0x1EAA,
Key_Multi_key, Key_asciicircum, Key_E, 0x1EC4,
Key_Multi_key, Key_asciicircum, Key_O, 0x1ED6,
Key_Multi_key, Key_asciicircum, Key_a, 0x1EAB,
Key_Multi_key, Key_asciicircum, Key_e, 0x1EC5,
Key_Multi_key, Key_asciicircum, Key_o, 0x1ED7,
Key_Multi_key, Key_b, Key_A, 0x1EB4,
Key_Multi_key, Key_b, Key_a, 0x1EB5,
Key_space, 0x00AF,
Key_V, 0x01D5,
Key_v, 0x01D6,
Key_nobreakspace, 0x0304,
Key_Egrave, 0x1E14,
Key_Eacute, 0x1E16,
Key_Ograve, 0x1E50,
Key_Oacute, 0x1E52,
Key_egrave, 0x1E15,
Key_eacute, 0x1E17,
Key_ograve, 0x1E51,
Key_oacute, 0x1E53,
Key_Cyrillic_i, 0x04E3,
Key_Cyrillic_u, 0x04EF,
Key_Cyrillic_I, 0x04E2,
Key_Cyrillic_U, 0x04EE,
Key_Greek_ALPHA, 0x1FB9,
Key_Greek_IOTA, 0x1FD9,
Key_Greek_UPSILON, 0x1FE9,
Key_Greek_alpha, 0x1FB1,
Key_Greek_iota, 0x1FD1,
Key_Greek_upsilon, 0x1FE1,
Key_dead_macron, 0x00AF,
Key_Multi_key, Key_exclam, Key_L, 0x1E38,
Key_Multi_key, Key_exclam, Key_R, 0x1E5C,
Key_Multi_key, Key_exclam, Key_l, 0x1E39,
Key_Multi_key, Key_exclam, Key_r, 0x1E5D,
Key_Multi_key, Key_quotedbl, Key_A, 0x01DE,
Key_Multi_key, Key_quotedbl, Key_O, 0x022A,
Key_Multi_key, Key_quotedbl, Key_U, 0x01D5,
Key_Multi_key, Key_quotedbl, Key_a, 0x01DF,
Key_Multi_key, Key_quotedbl, Key_o, 0x022B,
Key_Multi_key, Key_quotedbl, Key_u, 0x01D6,
Key_Multi_key, Key_period, Key_A, 0x01E0,
Key_Multi_key, Key_period, Key_O, 0x0230,
Key_Multi_key, Key_period, Key_a, 0x01E1,
Key_Multi_key, Key_period, Key_o, 0x0231,
Key_Multi_key, Key_semicolon, Key_O, 0x01EC,
Key_Multi_key, Key_semicolon, Key_o, 0x01ED,
Key_Multi_key, Key_asciitilde, Key_O, 0x022C,
Key_Multi_key, Key_asciitilde, Key_o, 0x022D,
Key_space, 0x02D8,
Key_nobreakspace, 0x0306,
Key_Agrave, 0x1EB0,
Key_Aacute, 0x1EAE,
Key_Atilde, 0x1EB4,
Key_agrave, 0x1EB1,
Key_aacute, 0x1EAF,
Key_atilde, 0x1EB5,
Key_Cyrillic_a, 0x04D1,
Key_Cyrillic_ie, 0x04D7,
Key_Cyrillic_i, 0x0439,
Key_Cyrillic_u, 0x045E,
Key_Cyrillic_zhe, 0x04C2,
Key_Cyrillic_A, 0x04D0,
Key_Cyrillic_IE, 0x04D6,
Key_Cyrillic_I, 0x0419,
Key_Cyrillic_U, 0x040E,
Key_Cyrillic_ZHE, 0x04C1,
Key_Greek_ALPHA, 0x1FB8,
Key_Greek_IOTA, 0x1FD8,
Key_Greek_UPSILON, 0x1FE8,
Key_Greek_alpha, 0x1FB0,
Key_Greek_iota, 0x1FD0,
Key_Greek_upsilon, 0x1FE0,
Key_Ahook, 0x1EB2,
Key_ahook, 0x1EB3,
Key_dead_breve, 0x02D8,
Key_Multi_key, Key_exclam, Key_A, 0x1EB6,
Key_Multi_key, Key_exclam, Key_a, 0x1EB7,
Key_Multi_key, Key_comma, Key_E, 0x1E1C,
Key_Multi_key, Key_comma, Key_e, 0x1E1D,
Key_Multi_key, Key_cedilla, Key_E, 0x1E1C,
Key_Multi_key, Key_cedilla, Key_e, 0x1E1D,
Key_space, 0x02D9,
Key_L, 0x013F,
Key_i, 0x0131,
Key_j, 0x0237,
Key_l, 0x0140,
Key_nobreakspace, 0x0307,
Key_Sacute, 0x1E64,
Key_Scaron, 0x1E66,
Key_sacute, 0x1E65,
Key_scaron, 0x1E67,
Key_Amacron, 0x01E0,
Key_Omacron, 0x0230,
Key_amacron, 0x01E1,
Key_omacron, 0x0231,
Key_dead_abovedot, 0x02D9,
Key_dead_stroke, Key_j, 0x025F,
Key_Multi_key, Key_exclam, Key_S, 0x1E68,
Key_Multi_key, Key_exclam, Key_s, 0x1E69,
Key_Multi_key, Key_apostrophe, Key_S, 0x1E64,
Key_Multi_key, Key_apostrophe, Key_s, 0x1E65,
Key_Multi_key, Key_c, Key_S, 0x1E66,
Key_Multi_key, Key_c, Key_s, 0x1E67,
Key_Multi_key, Key_acute, Key_S, 0x1E64,
Key_Multi_key, Key_acute, Key_s, 0x1E65,
Key_space, 0x0022,
Key_apostrophe, 0x0344,
Key_nobreakspace, 0x0308,
Key_acute, 0x0344,
Key_Iacute, 0x1E2E,
Key_Ugrave, 0x01DB,
Key_Uacute, 0x01D7,
Key_iacute, 0x1E2F,
Key_ugrave, 0x01DC,
Key_uacute, 0x01D8,
0x01D3, 0x01D9,
0x01D4, 0x01DA,
Key_Amacron, 0x01DE,
Key_Umacron, 0x1E7A,
Key_amacron, 0x01DF,
Key_omacron, 0x022B,
Key_umacron, 0x1E7B,
Key_Ukrainian_i, 0x0457,
Key_Ukrainian_I, 0x0407,
Key_Cyrillic_a, 0x04D3,
Key_Cyrillic_ie, 0x0451,
Key_Cyrillic_i, 0x04E5,
Key_Cyrillic_o, 0x04E7,
Key_Cyrillic_u, 0x04F1,
Key_Cyrillic_zhe, 0x04DD,
Key_Cyrillic_yeru, 0x04F9,
Key_Cyrillic_ze, 0x04DF,
Key_Cyrillic_e, 0x04ED,
Key_Cyrillic_che, 0x04F5,
Key_Cyrillic_A, 0x04D2,
Key_Cyrillic_IE, 0x0401,
Key_Cyrillic_I, 0x04E4,
Key_Cyrillic_O, 0x04E6,
Key_Cyrillic_U, 0x04F0,
Key_Cyrillic_ZHE, 0x04DC,
Key_Cyrillic_YERU, 0x04F8,
Key_Cyrillic_ZE, 0x04DE,
Key_Cyrillic_E, 0x04EC,
Key_Cyrillic_CHE, 0x04F4,
Key_Greek_IOTA, 0x03AA,
Key_Greek_UPSILON, 0x03AB,
Key_Greek_iota, 0x03CA,
Key_Greek_upsilon, 0x03CB,
Key_dead_diaeresis, 0x00A8,
Key_dead_acute, Key_space, 0x0385,
Key_dead_acute, Key_Greek_iota, 0x0390,
Key_dead_acute, Key_Greek_upsilon, 0x03B0,
Key_Multi_key, Key_underscore, Key_U, 0x1E7A,
Key_Multi_key, Key_underscore, Key_u, 0x1E7B,
Key_Multi_key, Key_asciitilde, Key_O, 0x1E4E,
Key_Multi_key, Key_asciitilde, Key_o, 0x1E4F,
Key_Multi_key, Key_macron, Key_U, 0x1E7A,
Key_Multi_key, Key_macron, Key_u, 0x1E7B,
Key_space, 0x00B0,
Key_nobreakspace, 0x030A,
Key_Aacute, 0x01FA,
Key_aacute, 0x01FB,
Key_dead_abovering, 0x00B0,
Key_space, 0x02DD,
Key_nobreakspace, 0x030B,
Key_Cyrillic_u, 0x04F3,
Key_Cyrillic_U, 0x04F2,
Key_dead_doubleacute, 0x02DD,
Key_space, 0x02C7,
Key_parenleft, 0x208D,
Key_parenright, 0x208E,
Key_plus, 0x208A,
Key_minus, 0x208B,
Key_equal, 0x208C,
Key_V, 0x01D9,
Key_v, 0x01DA,
Key_nobreakspace, 0x030C,
0x01F2, 0x01C5,
Key_Sabovedot, 0x1E66,
Key_sabovedot, 0x1E67,
Key_dead_caron, 0x02C7,
Key_Multi_key, Key_quotedbl, Key_U, 0x01D9,
Key_Multi_key, Key_quotedbl, Key_u, 0x01DA,
Key_space, 0x00B8,
Key_nobreakspace, 0x0327,
Key_cent, 0x20B5,
Key_Cacute, 0x1E08,
Key_cacute, 0x1E09,
Key_ColonSign, 0x20B5,
Key_dead_cedilla, 0x00B8,
Key_space, 0x02DB,
Key_nobreakspace, 0x0328,
Key_Omacron, 0x01EC,
Key_omacron, 0x01ED,
Key_dead_ogonek, 0x02DB,
Key_space, 0x037A,
Key_Greek_alphaaccent, 0x1FB4,
Key_Greek_etaaccent, 0x1FC4,
Key_Greek_omegaaccent, 0x1FF4,
Key_Greek_ALPHA, 0x1FBC,
Key_Greek_ETA, 0x1FCC,
Key_Greek_OMEGA, 0x1FFC,
Key_Greek_alpha, 0x1FB3,
Key_Greek_eta, 0x1FC3,
Key_Greek_omega, 0x1FF3,
Key_dead_iota, 0x037A,
Key_dead_grave, Key_Greek_alpha, 0x1FB2,
Key_dead_grave, Key_Greek_eta, 0x1FC2,
Key_dead_grave, Key_Greek_omega, 0x1FF2,
Key_dead_acute, Key_Greek_alpha, 0x1FB4,
Key_dead_acute, Key_Greek_eta, 0x1FC4,
Key_dead_acute, Key_Greek_omega, 0x1FF4,
Key_dead_tilde, Key_Greek_alpha, 0x1FB7,
Key_dead_tilde, Key_Greek_eta, 0x1FC7,
Key_dead_tilde, Key_Greek_omega, 0x1FF7,
Key_dead_tilde, 0x1F00, 0x1F86,
Key_dead_tilde, 0x1F01, 0x1F87,
Key_dead_tilde, 0x1F08, 0x1F8E,
Key_dead_tilde, 0x1F09, 0x1F8F,
Key_dead_tilde, 0x1F20, 0x1F96,
Key_dead_tilde, 0x1F21, 0x1F97,
Key_dead_tilde, 0x1F28, 0x1F9E,
Key_dead_tilde, 0x1F29, 0x1F9F,
Key_dead_tilde, 0x1F60, 0x1FA6,
Key_dead_tilde, 0x1F61, 0x1FA7,
Key_dead_tilde, 0x1F68, 0x1FAE,
Key_dead_tilde, 0x1F69, 0x1FAF,
Key_dead_psili, Key_Greek_ALPHA, 0x1F88,
Key_dead_psili, Key_Greek_ETA, 0x1F98,
Key_dead_psili, Key_Greek_OMEGA, 0x1FA8,
Key_dead_psili, Key_Greek_alpha, 0x1F80,
Key_dead_psili, Key_Greek_eta, 0x1F90,
Key_dead_psili, Key_Greek_omega, 0x1FA0,
Key_dead_dasia, Key_Greek_ALPHA, 0x1F89,
Key_dead_dasia, Key_Greek_ETA, 0x1F99,
Key_dead_dasia, Key_Greek_OMEGA, 0x1FA9,
Key_dead_dasia, Key_Greek_alpha, 0x1F81,
Key_dead_dasia, Key_Greek_eta, 0x1F91,
Key_dead_dasia, Key_Greek_omega, 0x1FA1,
Key_dead_grave, Key_dead_psili, Key_Greek_ALPHA, 0x1F8A,
Key_dead_grave, Key_dead_psili, Key_Greek_ETA, 0x1F9A,
Key_dead_grave, Key_dead_psili, Key_Greek_OMEGA, 0x1FAA,
Key_dead_grave, Key_dead_psili, Key_Greek_alpha, 0x1F82,
Key_dead_grave, Key_dead_psili, Key_Greek_eta, 0x1F92,
Key_dead_grave, Key_dead_psili, Key_Greek_omega, 0x1FA2,
Key_dead_grave, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8B,
Key_dead_grave, Key_dead_dasia, Key_Greek_ETA, 0x1F9B,
Key_dead_grave, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAB,
Key_dead_grave, Key_dead_dasia, Key_Greek_alpha, 0x1F83,
Key_dead_grave, Key_dead_dasia, Key_Greek_eta, 0x1F93,
Key_dead_grave, Key_dead_dasia, Key_Greek_omega, 0x1FA3,
Key_dead_acute, Key_dead_psili, Key_Greek_ALPHA, 0x1F8C,
Key_dead_acute, Key_dead_psili, Key_Greek_ETA, 0x1F9C,
Key_dead_acute, Key_dead_psili, Key_Greek_OMEGA, 0x1FAC,
Key_dead_acute, Key_dead_psili, Key_Greek_alpha, 0x1F84,
Key_dead_acute, Key_dead_psili, Key_Greek_eta, 0x1F94,
Key_dead_acute, Key_dead_psili, Key_Greek_omega, 0x1FA4,
Key_dead_acute, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8D,
Key_dead_acute, Key_dead_dasia, Key_Greek_ETA, 0x1F9D,
Key_dead_acute, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAD,
Key_dead_acute, Key_dead_dasia, Key_Greek_alpha, 0x1F85,
Key_dead_acute, Key_dead_dasia, Key_Greek_eta, 0x1F95,
Key_dead_acute, Key_dead_dasia, Key_Greek_omega, 0x1FA5,
Key_dead_tilde, Key_dead_psili, Key_Greek_ALPHA, 0x1F8E,
Key_dead_tilde, Key_dead_psili, Key_Greek_ETA, 0x1F9E,
Key_dead_tilde, Key_dead_psili, Key_Greek_OMEGA, 0x1FAE,
Key_dead_tilde, Key_dead_psili, Key_Greek_alpha, 0x1F86,
Key_dead_tilde, Key_dead_psili, Key_Greek_eta, 0x1F96,
Key_dead_tilde, Key_dead_psili, Key_Greek_omega, 0x1FA6,
Key_dead_tilde, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8F,
Key_dead_tilde, Key_dead_dasia, Key_Greek_ETA, 0x1F9F,
Key_dead_tilde, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAF,
Key_dead_tilde, Key_dead_dasia, Key_Greek_alpha, 0x1F87,
Key_dead_tilde, Key_dead_dasia, Key_Greek_eta, 0x1F97,
Key_dead_tilde, Key_dead_dasia, Key_Greek_omega, 0x1FA7,
Key_Multi_key, Key_apostrophe, Key_Greek_alpha, 0x1FB4,
Key_Multi_key, Key_apostrophe, Key_Greek_eta, 0x1FC4,
Key_Multi_key, Key_apostrophe, Key_Greek_omega, 0x1FF4,
Key_Multi_key, Key_apostrophe, 0x1F00, 0x1F84,
Key_Multi_key, Key_apostrophe, 0x1F01, 0x1F85,
Key_Multi_key, Key_apostrophe, 0x1F08, 0x1F8C,
Key_Multi_key, Key_apostrophe, 0x1F09, 0x1F8D,
Key_Multi_key, Key_apostrophe, 0x1F20, 0x1F94,
Key_Multi_key, Key_apostrophe, 0x1F21, 0x1F95,
Key_Multi_key, Key_apostrophe, 0x1F28, 0x1F9C,
Key_Multi_key, Key_apostrophe, 0x1F29, 0x1F9D,
Key_Multi_key, Key_apostrophe, 0x1F60, 0x1FA4,
Key_Multi_key, Key_apostrophe, 0x1F61, 0x1FA5,
Key_Multi_key, Key_apostrophe, 0x1F68, 0x1FAC,
Key_Multi_key, Key_apostrophe, 0x1F69, 0x1FAD,
Key_Multi_key, Key_parenleft, Key_Greek_ALPHA, 0x1F89,
Key_Multi_key, Key_parenleft, Key_Greek_ETA, 0x1F99,
Key_Multi_key, Key_parenleft, Key_Greek_OMEGA, 0x1FA9,
Key_Multi_key, Key_parenleft, Key_Greek_alpha, 0x1F81,
Key_Multi_key, Key_parenleft, Key_Greek_eta, 0x1F91,
Key_Multi_key, Key_parenleft, Key_Greek_omega, 0x1FA1,
Key_Multi_key, Key_parenright, Key_Greek_ALPHA, 0x1F88,
Key_Multi_key, Key_parenright, Key_Greek_ETA, 0x1F98,
Key_Multi_key, Key_parenright, Key_Greek_OMEGA, 0x1FA8,
Key_Multi_key, Key_parenright, Key_Greek_alpha, 0x1F80,
Key_Multi_key, Key_parenright, Key_Greek_eta, 0x1F90,
Key_Multi_key, Key_parenright, Key_Greek_omega, 0x1FA0,
Key_Multi_key, Key_grave, Key_Greek_alpha, 0x1FB2,
Key_Multi_key, Key_grave, Key_Greek_eta, 0x1FC2,
Key_Multi_key, Key_grave, Key_Greek_omega, 0x1FF2,
Key_Multi_key, Key_grave, 0x1F00, 0x1F82,
Key_Multi_key, Key_grave, 0x1F01, 0x1F83,
Key_Multi_key, Key_grave, 0x1F08, 0x1F8A,
Key_Multi_key, Key_grave, 0x1F09, 0x1F8B,
Key_Multi_key, Key_grave, 0x1F20, 0x1F92,
Key_Multi_key, Key_grave, 0x1F21, 0x1F93,
Key_Multi_key, Key_grave, 0x1F28, 0x1F9A,
Key_Multi_key, Key_grave, 0x1F29, 0x1F9B,
Key_Multi_key, Key_grave, 0x1F60, 0x1FA2,
Key_Multi_key, Key_grave, 0x1F61, 0x1FA3,
Key_Multi_key, Key_grave, 0x1F68, 0x1FAA,
Key_Multi_key, Key_grave, 0x1F69, 0x1FAB,
Key_Multi_key, Key_asciitilde, Key_Greek_alpha, 0x1FB7,
Key_Multi_key, Key_asciitilde, Key_Greek_eta, 0x1FC7,
Key_Multi_key, Key_asciitilde, Key_Greek_omega, 0x1FF7,
Key_Multi_key, Key_asciitilde, 0x1F00, 0x1F86,
Key_Multi_key, Key_asciitilde, 0x1F01, 0x1F87,
Key_Multi_key, Key_asciitilde, 0x1F08, 0x1F8E,
Key_Multi_key, Key_asciitilde, 0x1F09, 0x1F8F,
Key_Multi_key, Key_asciitilde, 0x1F20, 0x1F96,
Key_Multi_key, Key_asciitilde, 0x1F21, 0x1F97,
Key_Multi_key, Key_asciitilde, 0x1F28, 0x1F9E,
Key_Multi_key, Key_asciitilde, 0x1F29, 0x1F9F,
Key_Multi_key, Key_asciitilde, 0x1F60, 0x1FA6,
Key_Multi_key, Key_asciitilde, 0x1F61, 0x1FA7,
Key_Multi_key, Key_asciitilde, 0x1F68, 0x1FAE,
Key_Multi_key, Key_asciitilde, 0x1F69, 0x1FAF,
Key_Multi_key, Key_acute, Key_Greek_alpha, 0x1FB4,
Key_Multi_key, Key_acute, Key_Greek_eta, 0x1FC4,
Key_Multi_key, Key_acute, Key_Greek_omega, 0x1FF4,
Key_Multi_key, Key_acute, 0x1F00, 0x1F84,
Key_Multi_key, Key_acute, 0x1F01, 0x1F85,
Key_Multi_key, Key_acute, 0x1F08, 0x1F8C,
Key_Multi_key, Key_acute, 0x1F09, 0x1F8D,
Key_Multi_key, Key_acute, 0x1F20, 0x1F94,
Key_Multi_key, Key_acute, 0x1F21, 0x1F95,
Key_Multi_key, Key_acute, 0x1F28, 0x1F9C,
Key_Multi_key, Key_acute, 0x1F29, 0x1F9D,
Key_Multi_key, Key_acute, 0x1F60, 0x1FA4,
Key_Multi_key, Key_acute, 0x1F61, 0x1FA5,
Key_Multi_key, Key_acute, 0x1F68, 0x1FAC,
Key_Multi_key, Key_acute, 0x1F69, 0x1FAD,
Key_dead_grave, Key_Multi_key, Key_parenleft, Key_Greek_ALPHA, 0x1F8B,
Key_dead_grave, Key_Multi_key, Key_parenleft, Key_Greek_ETA, 0x1F9B,
Key_dead_grave, Key_Multi_key, Key_parenleft, Key_Greek_OMEGA, 0x1FAB,
Key_dead_grave, Key_Multi_key, Key_parenleft, Key_Greek_alpha, 0x1F83,
Key_dead_grave, Key_Multi_key, Key_parenleft, Key_Greek_eta, 0x1F93,
Key_dead_grave, Key_Multi_key, Key_parenleft, Key_Greek_omega, 0x1FA3,
Key_dead_grave, Key_Multi_key, Key_parenright, Key_Greek_ALPHA, 0x1F8A,
Key_dead_grave, Key_Multi_key, Key_parenright, Key_Greek_ETA, 0x1F9A,
Key_dead_grave, Key_Multi_key, Key_parenright, Key_Greek_OMEGA, 0x1FAA,
Key_dead_grave, Key_Multi_key, Key_parenright, Key_Greek_alpha, 0x1F82,
Key_dead_grave, Key_Multi_key, Key_parenright, Key_Greek_eta, 0x1F92,
Key_dead_grave, Key_Multi_key, Key_parenright, Key_Greek_omega, 0x1FA2,
Key_dead_acute, Key_Multi_key, Key_parenleft, Key_Greek_ALPHA, 0x1F8D,
Key_dead_acute, Key_Multi_key, Key_parenleft, Key_Greek_ETA, 0x1F9D,
Key_dead_acute, Key_Multi_key, Key_parenleft, Key_Greek_OMEGA, 0x1FAD,
Key_dead_acute, Key_Multi_key, Key_parenleft, Key_Greek_alpha, 0x1F85,
Key_dead_acute, Key_Multi_key, Key_parenleft, Key_Greek_eta, 0x1F95,
Key_dead_acute, Key_Multi_key, Key_parenleft, Key_Greek_omega, 0x1FA5,
Key_dead_acute, Key_Multi_key, Key_parenright, Key_Greek_ALPHA, 0x1F8C,
Key_dead_acute, Key_Multi_key, Key_parenright, Key_Greek_ETA, 0x1F9C,
Key_dead_acute, Key_Multi_key, Key_parenright, Key_Greek_OMEGA, 0x1FAC,
Key_dead_acute, Key_Multi_key, Key_parenright, Key_Greek_alpha, 0x1F84,
Key_dead_acute, Key_Multi_key, Key_parenright, Key_Greek_eta, 0x1F94,
Key_dead_acute, Key_Multi_key, Key_parenright, Key_Greek_omega, 0x1FA4,
Key_dead_tilde, Key_Multi_key, Key_parenleft, Key_Greek_ALPHA, 0x1F8F,
Key_dead_tilde, Key_Multi_key, Key_parenleft, Key_Greek_ETA, 0x1F9F,
Key_dead_tilde, Key_Multi_key, Key_parenleft, Key_Greek_OMEGA, 0x1FAF,
Key_dead_tilde, Key_Multi_key, Key_parenleft, Key_Greek_alpha, 0x1F87,
Key_dead_tilde, Key_Multi_key, Key_parenleft, Key_Greek_eta, 0x1F97,
Key_dead_tilde, Key_Multi_key, Key_parenleft, Key_Greek_omega, 0x1FA7,
Key_dead_tilde, Key_Multi_key, Key_parenright, Key_Greek_ALPHA, 0x1F8E,
Key_dead_tilde, Key_Multi_key, Key_parenright, Key_Greek_ETA, 0x1F9E,
Key_dead_tilde, Key_Multi_key, Key_parenright, Key_Greek_OMEGA, 0x1FAE,
Key_dead_tilde, Key_Multi_key, Key_parenright, Key_Greek_alpha, 0x1F86,
Key_dead_tilde, Key_Multi_key, Key_parenright, Key_Greek_eta, 0x1F96,
Key_dead_tilde, Key_Multi_key, Key_parenright, Key_Greek_omega, 0x1FA6,
Key_Multi_key, Key_apostrophe, Key_parenleft, Key_Greek_ALPHA, 0x1F8D,
Key_Multi_key, Key_apostrophe, Key_parenleft, Key_Greek_ETA, 0x1F9D,
Key_Multi_key, Key_apostrophe, Key_parenleft, Key_Greek_OMEGA, 0x1FAD,
Key_Multi_key, Key_apostrophe, Key_parenleft, Key_Greek_alpha, 0x1F85,
Key_Multi_key, Key_apostrophe, Key_parenleft, Key_Greek_eta, 0x1F95,
Key_Multi_key, Key_apostrophe, Key_parenleft, Key_Greek_omega, 0x1FA5,
Key_Multi_key, Key_apostrophe, Key_parenright, Key_Greek_ALPHA, 0x1F8C,
Key_Multi_key, Key_apostrophe, Key_parenright, Key_Greek_ETA, 0x1F9C,
Key_Multi_key, Key_apostrophe, Key_parenright, Key_Greek_OMEGA, 0x1FAC,
Key_Multi_key, Key_apostrophe, Key_parenright, Key_Greek_alpha, 0x1F84,
Key_Multi_key, Key_apostrophe, Key_parenright, Key_Greek_eta, 0x1F94,
Key_Multi_key, Key_apostrophe, Key_parenright, Key_Greek_omega, 0x1FA4,
Key_Multi_key, Key_apostrophe, Key_dead_psili, Key_Greek_ALPHA, 0x1F8C,
Key_Multi_key, Key_apostrophe, Key_dead_psili, Key_Greek_ETA, 0x1F9C,
Key_Multi_key, Key_apostrophe, Key_dead_psili, Key_Greek_OMEGA, 0x1FAC,
Key_Multi_key, Key_apostrophe, Key_dead_psili, Key_Greek_alpha, 0x1F84,
Key_Multi_key, Key_apostrophe, Key_dead_psili, Key_Greek_eta, 0x1F94,
Key_Multi_key, Key_apostrophe, Key_dead_psili, Key_Greek_omega, 0x1FA4,
Key_Multi_key, Key_apostrophe, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8D,
Key_Multi_key, Key_apostrophe, Key_dead_dasia, Key_Greek_ETA, 0x1F9D,
Key_Multi_key, Key_apostrophe, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAD,
Key_Multi_key, Key_apostrophe, Key_dead_dasia, Key_Greek_alpha, 0x1F85,
Key_Multi_key, Key_apostrophe, Key_dead_dasia, Key_Greek_eta, 0x1F95,
Key_Multi_key, Key_apostrophe, Key_dead_dasia, Key_Greek_omega, 0x1FA5,
Key_Multi_key, Key_grave, Key_parenleft, Key_Greek_ALPHA, 0x1F8B,
Key_Multi_key, Key_grave, Key_parenleft, Key_Greek_ETA, 0x1F9B,
Key_Multi_key, Key_grave, Key_parenleft, Key_Greek_OMEGA, 0x1FAB,
Key_Multi_key, Key_grave, Key_parenleft, Key_Greek_alpha, 0x1F83,
Key_Multi_key, Key_grave, Key_parenleft, Key_Greek_eta, 0x1F93,
Key_Multi_key, Key_grave, Key_parenleft, Key_Greek_omega, 0x1FA3,
Key_Multi_key, Key_grave, Key_parenright, Key_Greek_ALPHA, 0x1F8A,
Key_Multi_key, Key_grave, Key_parenright, Key_Greek_ETA, 0x1F9A,
Key_Multi_key, Key_grave, Key_parenright, Key_Greek_OMEGA, 0x1FAA,
Key_Multi_key, Key_grave, Key_parenright, Key_Greek_alpha, 0x1F82,
Key_Multi_key, Key_grave, Key_parenright, Key_Greek_eta, 0x1F92,
Key_Multi_key, Key_grave, Key_parenright, Key_Greek_omega, 0x1FA2,
Key_Multi_key, Key_grave, Key_dead_psili, Key_Greek_ALPHA, 0x1F8A,
Key_Multi_key, Key_grave, Key_dead_psili, Key_Greek_ETA, 0x1F9A,
Key_Multi_key, Key_grave, Key_dead_psili, Key_Greek_OMEGA, 0x1FAA,
Key_Multi_key, Key_grave, Key_dead_psili, Key_Greek_alpha, 0x1F82,
Key_Multi_key, Key_grave, Key_dead_psili, Key_Greek_eta, 0x1F92,
Key_Multi_key, Key_grave, Key_dead_psili, Key_Greek_omega, 0x1FA2,
Key_Multi_key, Key_grave, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8B,
Key_Multi_key, Key_grave, Key_dead_dasia, Key_Greek_ETA, 0x1F9B,
Key_Multi_key, Key_grave, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAB,
Key_Multi_key, Key_grave, Key_dead_dasia, Key_Greek_alpha, 0x1F83,
Key_Multi_key, Key_grave, Key_dead_dasia, Key_Greek_eta, 0x1F93,
Key_Multi_key, Key_grave, Key_dead_dasia, Key_Greek_omega, 0x1FA3,
Key_Multi_key, Key_asciitilde, Key_parenleft, Key_Greek_ALPHA, 0x1F8F,
Key_Multi_key, Key_asciitilde, Key_parenleft, Key_Greek_ETA, 0x1F9F,
Key_Multi_key, Key_asciitilde, Key_parenleft, Key_Greek_OMEGA, 0x1FAF,
Key_Multi_key, Key_asciitilde, Key_parenleft, Key_Greek_alpha, 0x1F87,
Key_Multi_key, Key_asciitilde, Key_parenleft, Key_Greek_eta, 0x1F97,
Key_Multi_key, Key_asciitilde, Key_parenleft, Key_Greek_omega, 0x1FA7,
Key_Multi_key, Key_asciitilde, Key_parenright, Key_Greek_ALPHA, 0x1F8E,
Key_Multi_key, Key_asciitilde, Key_parenright, Key_Greek_ETA, 0x1F9E,
Key_Multi_key, Key_asciitilde, Key_parenright, Key_Greek_OMEGA, 0x1FAE,
Key_Multi_key, Key_asciitilde, Key_parenright, Key_Greek_alpha, 0x1F86,
Key_Multi_key, Key_asciitilde, Key_parenright, Key_Greek_eta, 0x1F96,
Key_Multi_key, Key_asciitilde, Key_parenright, Key_Greek_omega, 0x1FA6,
Key_Multi_key, Key_asciitilde, Key_dead_psili, Key_Greek_ALPHA, 0x1F8E,
Key_Multi_key, Key_asciitilde, Key_dead_psili, Key_Greek_ETA, 0x1F9E,
Key_Multi_key, Key_asciitilde, Key_dead_psili, Key_Greek_OMEGA, 0x1FAE,
Key_Multi_key, Key_asciitilde, Key_dead_psili, Key_Greek_alpha, 0x1F86,
Key_Multi_key, Key_asciitilde, Key_dead_psili, Key_Greek_eta, 0x1F96,
Key_Multi_key, Key_asciitilde, Key_dead_psili, Key_Greek_omega, 0x1FA6,
Key_Multi_key, Key_asciitilde, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8F,
Key_Multi_key, Key_asciitilde, Key_dead_dasia, Key_Greek_ETA, 0x1F9F,
Key_Multi_key, Key_asciitilde, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAF,
Key_Multi_key, Key_asciitilde, Key_dead_dasia, Key_Greek_alpha, 0x1F87,
Key_Multi_key, Key_asciitilde, Key_dead_dasia, Key_Greek_eta, 0x1F97,
Key_Multi_key, Key_asciitilde, Key_dead_dasia, Key_Greek_omega, 0x1FA7,
Key_Multi_key, Key_acute, Key_parenleft, Key_Greek_ALPHA, 0x1F8D,
Key_Multi_key, Key_acute, Key_parenleft, Key_Greek_ETA, 0x1F9D,
Key_Multi_key, Key_acute, Key_parenleft, Key_Greek_OMEGA, 0x1FAD,
Key_Multi_key, Key_acute, Key_parenleft, Key_Greek_alpha, 0x1F85,
Key_Multi_key, Key_acute, Key_parenleft, Key_Greek_eta, 0x1F95,
Key_Multi_key, Key_acute, Key_parenleft, Key_Greek_omega, 0x1FA5,
Key_Multi_key, Key_acute, Key_parenright, Key_Greek_ALPHA, 0x1F8C,
Key_Multi_key, Key_acute, Key_parenright, Key_Greek_ETA, 0x1F9C,
Key_Multi_key, Key_acute, Key_parenright, Key_Greek_OMEGA, 0x1FAC,
Key_Multi_key, Key_acute, Key_parenright, Key_Greek_alpha, 0x1F84,
Key_Multi_key, Key_acute, Key_parenright, Key_Greek_eta, 0x1F94,
Key_Multi_key, Key_acute, Key_parenright, Key_Greek_omega, 0x1FA4,
Key_Multi_key, Key_acute, Key_dead_psili, Key_Greek_ALPHA, 0x1F8C,
Key_Multi_key, Key_acute, Key_dead_psili, Key_Greek_ETA, 0x1F9C,
Key_Multi_key, Key_acute, Key_dead_psili, Key_Greek_OMEGA, 0x1FAC,
Key_Multi_key, Key_acute, Key_dead_psili, Key_Greek_alpha, 0x1F84,
Key_Multi_key, Key_acute, Key_dead_psili, Key_Greek_eta, 0x1F94,
Key_Multi_key, Key_acute, Key_dead_psili, Key_Greek_omega, 0x1FA4,
Key_Multi_key, Key_acute, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8D,
Key_Multi_key, Key_acute, Key_dead_dasia, Key_Greek_ETA, 0x1F9D,
Key_Multi_key, Key_acute, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAD,
Key_Multi_key, Key_acute, Key_dead_dasia, Key_Greek_alpha, 0x1F85,
Key_Multi_key, Key_acute, Key_dead_dasia, Key_Greek_eta, 0x1F95,
Key_Multi_key, Key_acute, Key_dead_dasia, Key_Greek_omega, 0x1FA5,
Key_kana_WO, 0x30FA,
Key_kana_U, 0x30F4,
Key_kana_KA, 0x30AC,
Key_kana_KI, 0x30AE,
Key_kana_KU, 0x30B0,
Key_kana_KE, 0x30B2,
Key_kana_KO, 0x30B4,
Key_kana_SA, 0x30B6,
Key_kana_SHI, 0x30B8,
Key_kana_SU, 0x30BA,
Key_kana_SE, 0x30BC,
Key_kana_SO, 0x30BE,
Key_kana_TA, 0x30C0,
Key_kana_CHI, 0x30C2,
Key_kana_TSU, 0x30C5,
Key_kana_TE, 0x30C7,
Key_kana_TO, 0x30C9,
Key_kana_HA, 0x30D0,
Key_kana_HI, 0x30D3,
Key_kana_FU, 0x30D6,
Key_kana_HE, 0x30D9,
Key_kana_HO, 0x30DC,
Key_kana_WA, 0x30F7,
Key_kana_HA, 0x30D1,
Key_kana_HI, 0x30D4,
Key_kana_FU, 0x30D7,
Key_kana_HE, 0x30DA,
Key_kana_HO, 0x30DD,
Key_plus, 0x2A25,
Key_minus, 0x2A2A,
Key_equal, 0x2A66,
Key_Abreve, 0x1EB6,
Key_abreve, 0x1EB7,
Key_Multi_key, Key_plus, Key_O, 0x1EE2,
Key_Multi_key, Key_plus, Key_U, 0x1EF0,
Key_Multi_key, Key_plus, Key_o, 0x1EE3,
Key_Multi_key, Key_plus, Key_u, 0x1EF1,
Key_space, 0x0309,
Key_B, 0x0181,
Key_C, 0x0187,
Key_D, 0x018A,
Key_F, 0x0191,
Key_G, 0x0193,
Key_K, 0x0198,
Key_M, 0x2C6E,
Key_N, 0x019D,
Key_P, 0x01A4,
Key_T, 0x01AC,
Key_V, 0x01B2,
Key_W, 0x2C72,
Key_Z, 0x0224,
Key_b, 0x0253,
Key_c, 0x0188,
Key_d, 0x0257,
Key_f, 0x0192,
Key_g, 0x0260,
Key_h, 0x0266,
Key_k, 0x0199,
Key_m, 0x0271,
Key_n, 0x0272,
Key_p, 0x01A5,
Key_q, 0x02A0,
Key_s, 0x0282,
Key_t, 0x01AD,
Key_v, 0x028B,
Key_w, 0x2C73,
Key_z, 0x0225,
Key_nobreakspace, 0x0309,
Key_Abreve, 0x1EB2,
Key_abreve, 0x1EB3,
0x0256, 0x1D91,
Key_schwa, 0x025A,
0x025C, 0x025D,
0x025F, 0x0284,
0x0279, 0x027B,
Key_dead_hook, 0x0309,
Key_Multi_key, Key_plus, Key_O, 0x1EDE,
Key_Multi_key, Key_plus, Key_U, 0x1EEC,
Key_Multi_key, Key_plus, Key_o, 0x1EDF,
Key_Multi_key, Key_plus, Key_u, 0x1EED,
Key_Multi_key, Key_U, Key_A, 0x1EB2,
Key_Multi_key, Key_U, Key_a, 0x1EB3,
Key_Multi_key, Key_asciicircum, Key_A, 0x1EA8,
Key_Multi_key, Key_asciicircum, Key_E, 0x1EC2,
Key_Multi_key, Key_asciicircum, Key_O, 0x1ED4,
Key_Multi_key, Key_asciicircum, Key_a, 0x1EA9,
Key_Multi_key, Key_asciicircum, Key_e, 0x1EC3,
Key_Multi_key, Key_asciicircum, Key_o, 0x1ED5,
Key_Multi_key, Key_b, Key_A, 0x1EB2,
Key_Multi_key, Key_b, Key_a, 0x1EB3,
Key_Greek_ALPHA, 0x1F08,
Key_Greek_EPSILON, 0x1F18,
Key_Greek_ETA, 0x1F28,
Key_Greek_IOTA, 0x1F38,
Key_Greek_OMICRON, 0x1F48,
Key_Greek_OMEGA, 0x1F68,
Key_Greek_alpha, 0x1F00,
Key_Greek_epsilon, 0x1F10,
Key_Greek_eta, 0x1F20,
Key_Greek_iota, 0x1F30,
Key_Greek_omicron, 0x1F40,
Key_Greek_rho, 0x1FE4,
Key_Greek_upsilon, 0x1F50,
Key_Greek_omega, 0x1F60,
Key_Greek_ALPHA, 0x1F09,
Key_Greek_EPSILON, 0x1F19,
Key_Greek_ETA, 0x1F29,
Key_Greek_IOTA, 0x1F39,
Key_Greek_OMICRON, 0x1F49,
Key_Greek_RHO, 0x1FEC,
Key_Greek_UPSILON, 0x1F59,
Key_Greek_OMEGA, 0x1F69,
Key_Greek_alpha, 0x1F01,
Key_Greek_epsilon, 0x1F11,
Key_Greek_eta, 0x1F21,
Key_Greek_iota, 0x1F31,
Key_Greek_omicron, 0x1F41,
Key_Greek_rho, 0x1FE5,
Key_Greek_upsilon, 0x1F51,
Key_Greek_omega, 0x1F61,
Key_space, Key_space, 0x00A0,
Key_space, Key_apostrophe, 0x0027,
Key_space, Key_parenleft, 0x02D8,
Key_space, Key_comma, 0x00B8,
Key_space, Key_minus, 0x007E,
Key_space, Key_period, 0x2008,
Key_space, Key_less, 0x02C7,
Key_space, Key_greater, 0x005E,
Key_space, Key_asciicircum, 0x005E,
Key_space, Key_grave, 0x0060,
Key_space, Key_asciitilde, 0x007E,
Key_exclam, Key_exclam, 0x00A1,
Key_exclam, Key_question, 0x203D,
Key_exclam, Key_A, 0x1EA0,
Key_exclam, Key_B, 0x1E04,
Key_exclam, Key_D, 0x1E0C,
Key_exclam, Key_E, 0x1EB8,
Key_exclam, Key_H, 0x1E24,
Key_exclam, Key_I, 0x1ECA,
Key_exclam, Key_K, 0x1E32,
Key_exclam, Key_L, 0x1E36,
Key_exclam, Key_M, 0x1E42,
Key_exclam, Key_N, 0x1E46,
Key_exclam, Key_O, 0x1ECC,
Key_exclam, Key_P, 0x00B6,
Key_exclam, Key_R, 0x1E5A,
Key_exclam, Key_S, 0x00A7,
Key_exclam, Key_T, 0x1E6C,
Key_exclam, Key_U, 0x1EE4,
Key_exclam, Key_V, 0x1E7E,
Key_exclam, Key_W, 0x1E88,
Key_exclam, Key_Y, 0x1EF4,
Key_exclam, Key_Z, 0x1E92,
Key_exclam, Key_asciicircum, 0x00A6,
Key_exclam, Key_a, 0x1EA1,
Key_exclam, Key_b, 0x1E05,
Key_exclam, Key_d, 0x1E0D,
Key_exclam, Key_e, 0x1EB9,
Key_exclam, Key_h, 0x1E25,
Key_exclam, Key_i, 0x1ECB,
Key_exclam, Key_k, 0x1E33,
Key_exclam, Key_l, 0x1E37,
Key_exclam, Key_m, 0x1E43,
Key_exclam, Key_n, 0x1E47,
Key_exclam, Key_o, 0x1ECD,
Key_exclam, Key_p, 0x00B6,
Key_exclam, Key_r, 0x1E5B,
Key_exclam, Key_s, 0x00A7,
Key_exclam, Key_t, 0x1E6D,
Key_exclam, Key_u, 0x1EE5,
Key_exclam, Key_v, 0x1E7F,
Key_exclam, Key_w, 0x1E89,
Key_exclam, Key_y, 0x1EF5,
Key_exclam, Key_z, 0x1E93,
Key_exclam, Key_Ohorn, 0x1EE2,
Key_exclam, Key_ohorn, 0x1EE3,
Key_exclam, Key_Uhorn, 0x1EF0,
Key_exclam, Key_uhorn, 0x1EF1,
Key_quotedbl, Key_quotedbl, 0x00A8,
Key_quotedbl, Key_apostrophe, 0x0344,
Key_quotedbl, Key_comma, 0x201E,
Key_quotedbl, Key_slash, 0x301E,
Key_quotedbl, Key_less, 0x201C,
Key_quotedbl, Key_greater, 0x201D,
Key_quotedbl, Key_A, 0x00C4,
Key_quotedbl, Key_E, 0x00CB,
Key_quotedbl, Key_H, 0x1E26,
Key_quotedbl, Key_I, 0x00CF,
Key_quotedbl, Key_O, 0x00D6,
Key_quotedbl, Key_U, 0x00DC,
Key_quotedbl, Key_W, 0x1E84,
Key_quotedbl, Key_X, 0x1E8C,
Key_quotedbl, Key_Y, 0x0178,
Key_quotedbl, Key_backslash, 0x301D,
Key_quotedbl, Key_a, 0x00E4,
Key_quotedbl, Key_e, 0x00EB,
Key_quotedbl, Key_h, 0x1E27,
Key_quotedbl, Key_i, 0x00EF,
Key_quotedbl, Key_o, 0x00F6,
Key_quotedbl, Key_t, 0x1E97,
Key_quotedbl, Key_u, 0x00FC,
Key_quotedbl, Key_w, 0x1E85,
Key_quotedbl, Key_x, 0x1E8D,
Key_quotedbl, Key_y, 0x00FF,
Key_quotedbl, Key_acute, 0x0344,
Key_quotedbl, Key_Otilde, 0x1E4E,
Key_quotedbl, Key_otilde, 0x1E4F,
Key_quotedbl, 0x03D2, 0x03D4,
Key_quotedbl, Key_Umacron, 0x1E7A,
Key_quotedbl, Key_umacron, 0x1E7B,
Key_quotedbl, 0x04D8, 0x04DA,
Key_quotedbl, 0x04D9, 0x04DB,
Key_quotedbl, 0x04E8, 0x04EA,
Key_quotedbl, 0x04E9, 0x04EB,
Key_quotedbl, Key_Ukrainian_i, 0x0457,
Key_quotedbl, Key_Ukrainian_I, 0x0407,
Key_quotedbl, Key_Cyrillic_a, 0x04D3,
Key_quotedbl, Key_Cyrillic_ie, 0x0451,
Key_quotedbl, Key_Cyrillic_i, 0x04E5,
Key_quotedbl, Key_Cyrillic_o, 0x04E7,
Key_quotedbl, Key_Cyrillic_u, 0x04F1,
Key_quotedbl, Key_Cyrillic_zhe, 0x04DD,
Key_quotedbl, Key_Cyrillic_yeru, 0x04F9,
Key_quotedbl, Key_Cyrillic_ze, 0x04DF,
Key_quotedbl, Key_Cyrillic_e, 0x04ED,
Key_quotedbl, Key_Cyrillic_che, 0x04F5,
Key_quotedbl, Key_Cyrillic_A, 0x04D2,
Key_quotedbl, Key_Cyrillic_IE, 0x0401,
Key_quotedbl, Key_Cyrillic_I, 0x04E4,
Key_quotedbl, Key_Cyrillic_O, 0x04E6,
Key_quotedbl, Key_Cyrillic_U, 0x04F0,
Key_quotedbl, Key_Cyrillic_ZHE, 0x04DC,
Key_quotedbl, Key_Cyrillic_YERU, 0x04F8,
Key_quotedbl, Key_Cyrillic_ZE, 0x04DE,
Key_quotedbl, Key_Cyrillic_E, 0x04EC,
Key_quotedbl, Key_Cyrillic_CHE, 0x04F4,
Key_quotedbl, Key_Greek_IOTA, 0x03AA,
Key_quotedbl, Key_Greek_UPSILON, 0x03AB,
Key_quotedbl, Key_Greek_iota, 0x03CA,
Key_quotedbl, Key_Greek_upsilon, 0x03CB,
Key_quotedbl, Key_dead_acute, 0x0344,
Key_numbersign, Key_numbersign, 0x266F,
Key_numbersign, Key_b, 0x266D,
Key_numbersign, Key_f, 0x266E,
Key_percent, Key_o, 0x2030,
Key_apostrophe, Key_space, 0x0027,
Key_apostrophe, Key_apostrophe, 0x00B4,
Key_apostrophe, Key_comma, 0x201A,
Key_apostrophe, Key_less, 0x2018,
Key_apostrophe, Key_greater, 0x2019,
Key_apostrophe, Key_A, 0x00C1,
Key_apostrophe, Key_C, 0x0106,
Key_apostrophe, Key_E, 0x00C9,
Key_apostrophe, Key_G, 0x01F4,
Key_apostrophe, Key_I, 0x00CD,
Key_apostrophe, Key_K, 0x1E30,
Key_apostrophe, Key_L, 0x0139,
Key_apostrophe, Key_M, 0x1E3E,
Key_apostrophe, Key_N, 0x0143,
Key_apostrophe, Key_O, 0x00D3,
Key_apostrophe, Key_P, 0x1E54,
Key_apostrophe, Key_R, 0x0154,
Key_apostrophe, Key_S, 0x015A,
Key_apostrophe, Key_U, 0x00DA,
Key_apostrophe, Key_W, 0x1E82,
Key_apostrophe, Key_Y, 0x00DD,
Key_apostrophe, Key_Z, 0x0179,
Key_apostrophe, Key_a, 0x00E1,
Key_apostrophe, Key_c, 0x0107,
Key_apostrophe, Key_e, 0x00E9,
Key_apostrophe, Key_g, 0x01F5,
Key_apostrophe, Key_i, 0x00ED,
Key_apostrophe, Key_k, 0x1E31,
Key_apostrophe, Key_l, 0x013A,
Key_apostrophe, Key_m, 0x1E3F,
Key_apostrophe, Key_n, 0x0144,
Key_apostrophe, Key_o, 0x00F3,
Key_apostrophe, Key_p, 0x1E55,
Key_apostrophe, Key_r, 0x0155,
Key_apostrophe, Key_s, 0x015B,
Key_apostrophe, Key_u, 0x00FA,
Key_apostrophe, Key_w, 0x1E83,
Key_apostrophe, Key_y, 0x00FD,
Key_apostrophe, Key_z, 0x017A,
Key_apostrophe, Key_Acircumflex, 0x1EA4,
Key_apostrophe, Key_Aring, 0x01FA,
Key_apostrophe, Key_AE, 0x01FC,
Key_apostrophe, Key_Ccedilla, 0x1E08,
Key_apostrophe, Key_Ecircumflex, 0x1EBE,
Key_apostrophe, Key_Idiaeresis, 0x1E2E,
Key_apostrophe, Key_Ocircumflex, 0x1ED0,
Key_apostrophe, Key_Otilde, 0x1E4C,
Key_apostrophe, Key_Ooblique, 0x01FE,
Key_apostrophe, 0x00DC, 0x01D7,
Key_apostrophe, Key_acircumflex, 0x1EA5,
Key_apostrophe, Key_aring, 0x01FB,
Key_apostrophe, Key_ae, 0x01FD,
Key_apostrophe, Key_ccedilla, 0x1E09,
Key_apostrophe, Key_ecircumflex, 0x1EBF,
Key_apostrophe, Key_idiaeresis, 0x1E2F,
Key_apostrophe, Key_ocircumflex, 0x1ED1,
Key_apostrophe, Key_otilde, 0x1E4D,
Key_apostrophe, Key_oslash, 0x01FF,
Key_apostrophe, Key_udiaeresis, 0x01D8,
Key_apostrophe, Key_Ohorn, 0x1EDA,
Key_apostrophe, Key_ohorn, 0x1EDB,
Key_apostrophe, Key_Uhorn, 0x1EE8,
Key_apostrophe, Key_uhorn, 0x1EE9,
Key_apostrophe, Key_Abreve, 0x1EAE,
Key_apostrophe, Key_abreve, 0x1EAF,
Key_apostrophe, Key_Emacron, 0x1E16,
Key_apostrophe, Key_emacron, 0x1E17,
Key_apostrophe, Key_Omacron, 0x1E52,
Key_apostrophe, Key_Utilde, 0x1E78,
Key_apostrophe, Key_omacron, 0x1E53,
Key_apostrophe, Key_utilde, 0x1E79,
Key_apostrophe, Key_Cyrillic_ghe, 0x0453,
Key_apostrophe, Key_Cyrillic_ka, 0x045C,
Key_apostrophe, Key_Cyrillic_GHE, 0x0403,
Key_apostrophe, Key_Cyrillic_KA, 0x040C,
Key_apostrophe, Key_Greek_iotadieresis, 0x0390,
Key_apostrophe, Key_Greek_upsilondieresis, 0x03B0,
Key_apostrophe, Key_Greek_ALPHA, 0x0386,
Key_apostrophe, Key_Greek_EPSILON, 0x0388,
Key_apostrophe, Key_Greek_ETA, 0x0389,
Key_apostrophe, Key_Greek_IOTA, 0x038A,
Key_apostrophe, Key_Greek_OMICRON, 0x038C,
Key_apostrophe, Key_Greek_UPSILON, 0x038E,
Key_apostrophe, Key_Greek_OMEGA, 0x038F,
Key_apostrophe, Key_Greek_alpha, 0x03AC,
Key_apostrophe, Key_Greek_epsilon, 0x03AD,
Key_apostrophe, Key_Greek_eta, 0x03AE,
Key_apostrophe, Key_Greek_iota, 0x03AF,
Key_apostrophe, Key_Greek_omicron, 0x03CC,
Key_apostrophe, Key_Greek_upsilon, 0x03CD,
Key_apostrophe, Key_Greek_omega, 0x03CE,
Key_apostrophe, 0x1F00, 0x1F04,
Key_apostrophe, 0x1F01, 0x1F05,
Key_apostrophe, 0x1F08, 0x1F0C,
Key_apostrophe, 0x1F09, 0x1F0D,
Key_apostrophe, 0x1F10, 0x1F14,
Key_apostrophe, 0x1F11, 0x1F15,
Key_apostrophe, 0x1F18, 0x1F1C,
Key_apostrophe, 0x1F19, 0x1F1D,
Key_apostrophe, 0x1F20, 0x1F24,
Key_apostrophe, 0x1F21, 0x1F25,
Key_apostrophe, 0x1F28, 0x1F2C,
Key_apostrophe, 0x1F29, 0x1F2D,
Key_apostrophe, 0x1F30, 0x1F34,
Key_apostrophe, 0x1F31, 0x1F35,
Key_apostrophe, 0x1F38, 0x1F3C,
Key_apostrophe, 0x1F39, 0x1F3D,
Key_apostrophe, 0x1F40, 0x1F44,
Key_apostrophe, 0x1F41, 0x1F45,
Key_apostrophe, 0x1F48, 0x1F4C,
Key_apostrophe, 0x1F49, 0x1F4D,
Key_apostrophe, 0x1F50, 0x1F54,
Key_apostrophe, 0x1F51, 0x1F55,
Key_apostrophe, 0x1F59, 0x1F5D,
Key_apostrophe, 0x1F60, 0x1F64,
Key_apostrophe, 0x1F61, 0x1F65,
Key_apostrophe, 0x1F68, 0x1F6C,
Key_apostrophe, 0x1F69, 0x1F6D,
Key_parenleft, Key_space, 0x02D8,
Key_parenleft, Key_parenleft, 0x005B,
Key_parenleft, Key_minus, 0x007B,
Key_parenleft, Key_A, 0x0102,
Key_parenleft, Key_G, 0x011E,
Key_parenleft, Key_a, 0x0103,
Key_parenleft, Key_c, 0x00A9,
Key_parenleft, Key_g, 0x011F,
Key_parenleft, Key_r, 0x00AE,
Key_parenleft, Key_Greek_ALPHA, 0x1F09,
Key_parenleft, Key_Greek_EPSILON, 0x1F19,
Key_parenleft, Key_Greek_ETA, 0x1F29,
Key_parenleft, Key_Greek_IOTA, 0x1F39,
Key_parenleft, Key_Greek_OMICRON, 0x1F49,
Key_parenleft, Key_Greek_RHO, 0x1FEC,
Key_parenleft, Key_Greek_UPSILON, 0x1F59,
Key_parenleft, Key_Greek_OMEGA, 0x1F69,
Key_parenleft, Key_Greek_alpha, 0x1F01,
Key_parenleft, Key_Greek_epsilon, 0x1F11,
Key_parenleft, Key_Greek_eta, 0x1F21,
Key_parenleft, Key_Greek_iota, 0x1F31,
Key_parenleft, Key_Greek_omicron, 0x1F41,
Key_parenleft, Key_Greek_rho, 0x1FE5,
Key_parenleft, Key_Greek_upsilon, 0x1F51,
Key_parenleft, Key_Greek_omega, 0x1F61,
Key_parenright, Key_parenright, 0x005D,
Key_parenright, Key_minus, 0x007D,
Key_parenright, Key_Greek_ALPHA, 0x1F08,
Key_parenright, Key_Greek_EPSILON, 0x1F18,
Key_parenright, Key_Greek_ETA, 0x1F28,
Key_parenright, Key_Greek_IOTA, 0x1F38,
Key_parenright, Key_Greek_OMICRON, 0x1F48,
Key_parenright, Key_Greek_OMEGA, 0x1F68,
Key_parenright, Key_Greek_alpha, 0x1F00,
Key_parenright, Key_Greek_epsilon, 0x1F10,
Key_parenright, Key_Greek_eta, 0x1F20,
Key_parenright, Key_Greek_iota, 0x1F30,
Key_parenright, Key_Greek_omicron, 0x1F40,
Key_parenright, Key_Greek_rho, 0x1FE4,
Key_parenright, Key_Greek_upsilon, 0x1F50,
Key_parenright, Key_Greek_omega, 0x1F60,
Key_asterisk, Key_0, 0x00B0,
Key_asterisk, Key_A, 0x00C5,
Key_asterisk, Key_U, 0x016E,
Key_asterisk, Key_a, 0x00E5,
Key_asterisk, Key_u, 0x016F,
Key_plus, Key_plus, 0x0023,
Key_plus, Key_minus, 0x00B1,
Key_plus, Key_O, 0x01A0,
Key_plus, Key_U, 0x01AF,
Key_plus, Key_o, 0x01A1,
Key_plus, Key_u, 0x01B0,
Key_comma, Key_space, 0x00B8,
Key_comma, Key_quotedbl, 0x201E,
Key_comma, Key_apostrophe, 0x201A,
Key_comma, Key_comma, 0x00B8,
Key_comma, Key_minus, 0x00AC,
Key_comma, Key_A, 0x0104,
Key_comma, Key_C, 0x00C7,
Key_comma, Key_D, 0x1E10,
Key_comma, Key_E, 0x0118,
Key_comma, Key_G, 0x0122,
Key_comma, Key_H, 0x1E28,
Key_comma, Key_I, 0x012E,
Key_comma, Key_K, 0x0136,
Key_comma, Key_L, 0x013B,
Key_comma, Key_N, 0x0145,
Key_comma, Key_R, 0x0156,
Key_comma, Key_S, 0x015E,
Key_comma, Key_T, 0x0162,
Key_comma, Key_U, 0x0172,
Key_comma, Key_a, 0x0105,
Key_comma, Key_c, 0x00E7,
Key_comma, Key_d, 0x1E11,
Key_comma, Key_e, 0x0119,
Key_comma, Key_g, 0x0123,
Key_comma, Key_h, 0x1E29,
Key_comma, Key_i, 0x012F,
Key_comma, Key_k, 0x0137,
Key_comma, Key_l, 0x013C,
Key_comma, Key_n, 0x0146,
Key_comma, Key_r, 0x0157,
Key_comma, Key_s, 0x015F,
Key_comma, Key_t, 0x0163,
Key_comma, Key_u, 0x0173,
Key_minus, Key_space, 0x007E,
Key_minus, Key_parenleft, 0x007B,
Key_minus, Key_parenright, 0x007D,
Key_minus, Key_plus, 0x00B1,
Key_minus, Key_comma, 0x00AC,
Key_minus, Key_colon, 0x00F7,
Key_minus, Key_A, 0x00C3,
Key_minus, Key_D, 0x0110,
Key_minus, Key_E, 0x0112,
Key_minus, Key_I, 0x012A,
Key_minus, Key_L, 0x00A3,
Key_minus, Key_N, 0x00D1,
Key_minus, Key_O, 0x00D5,
Key_minus, Key_U, 0x016A,
Key_minus, Key_Y, 0x00A5,
Key_minus, Key_asciicircum, 0x00AF,
Key_minus, Key_a, 0x00E3,
Key_minus, Key_d, 0x0111,
Key_minus, Key_e, 0x0113,
Key_minus, Key_i, 0x012B,
Key_minus, Key_l, 0x00A3,
Key_minus, Key_n, 0x00F1,
Key_minus, Key_o, 0x00F5,
Key_minus, Key_u, 0x016B,
Key_minus, Key_y, 0x00A5,
Key_period, Key_minus, 0x00B7,
Key_period, Key_period, 0x02D9,
Key_period, Key_less, 0x2039,
Key_period, Key_equal, 0x2022,
Key_period, Key_greater, 0x203A,
Key_period, Key_A, 0x0226,
Key_period, Key_B, 0x1E02,
Key_period, Key_C, 0x010A,
Key_period, Key_D, 0x1E0A,
Key_period, Key_E, 0x0116,
Key_period, Key_F, 0x1E1E,
Key_period, Key_G, 0x0120,
Key_period, Key_H, 0x1E22,
Key_period, Key_I, 0x0130,
Key_period, Key_M, 0x1E40,
Key_period, Key_N, 0x1E44,
Key_period, Key_O, 0x022E,
Key_period, Key_P, 0x1E56,
Key_period, Key_R, 0x1E58,
Key_period, Key_S, 0x1E60,
Key_period, Key_T, 0x1E6A,
Key_period, Key_W, 0x1E86,
Key_period, Key_X, 0x1E8A,
Key_period, Key_Y, 0x1E8E,
Key_period, Key_Z, 0x017B,
Key_period, Key_asciicircum, 0x00B7,
Key_period, Key_a, 0x0227,
Key_period, Key_b, 0x1E03,
Key_period, Key_c, 0x010B,
Key_period, Key_d, 0x1E0B,
Key_period, Key_e, 0x0117,
Key_period, Key_f, 0x1E1F,
Key_period, Key_g, 0x0121,
Key_period, Key_h, 0x1E23,
Key_period, Key_i, 0x0131,
Key_period, Key_m, 0x1E41,
Key_period, Key_n, 0x1E45,
Key_period, Key_o, 0x022F,
Key_period, Key_p, 0x1E57,
Key_period, Key_r, 0x1E59,
Key_period, Key_s, 0x1E61,
Key_period, Key_t, 0x1E6B,
Key_period, Key_w, 0x1E87,
Key_period, Key_x, 0x1E8B,
Key_period, Key_y, 0x1E8F,
Key_period, Key_z, 0x017C,
Key_period, 0x017F, 0x1E9B,
Key_period, Key_Sacute, 0x1E64,
Key_period, Key_Scaron, 0x1E66,
Key_period, Key_sacute, 0x1E65,
Key_period, Key_scaron, 0x1E67,
Key_period, 0x1E62, 0x1E68,
Key_period, 0x1E63, 0x1E69,
Key_slash, Key_slash, 0x005C,
Key_slash, Key_less, 0x005C,
Key_slash, Key_C, 0x00A2,
Key_slash, Key_D, 0x0110,
Key_slash, Key_G, 0x01E4,
Key_slash, Key_H, 0x0126,
Key_slash, Key_I, 0x0197,
Key_slash, Key_L, 0x0141,
Key_slash, Key_O, 0x00D8,
Key_slash, Key_T, 0x0166,
Key_slash, Key_U, 0x00B5,
Key_slash, Key_Z, 0x01B5,
Key_slash, Key_asciicircum, 0x007C,
Key_slash, Key_b, 0x0180,
Key_slash, Key_c, 0x00A2,
Key_slash, Key_d, 0x0111,
Key_slash, Key_g, 0x01E5,
Key_slash, Key_h, 0x0127,
Key_slash, Key_i, 0x0268,
Key_slash, Key_l, 0x0142,
Key_slash, Key_m, 0x20A5,
Key_slash, Key_o, 0x00F8,
Key_slash, Key_t, 0x0167,
Key_slash, Key_u, 0x00B5,
Key_slash, Key_z, 0x01B6,
Key_slash, 0x0294, 0x02A1,
Key_slash, 0x04AE, 0x04B0,
Key_slash, 0x04AF, 0x04B1,
Key_slash, Key_Cyrillic_ghe, 0x0493,
Key_slash, Key_Cyrillic_ka, 0x049F,
Key_slash, Key_Cyrillic_GHE, 0x0492,
Key_slash, Key_Cyrillic_KA, 0x049E,
Key_slash, Key_leftarrow, 0x219A,
Key_slash, Key_rightarrow, 0x219B,
Key_slash, 0x2194, 0x21AE,
Key_0, Key_asterisk, 0x00B0,
Key_0, Key_C, 0x00A9,
Key_0, Key_S, 0x00A7,
Key_0, Key_X, 0x00A4,
Key_0, Key_asciicircum, 0x00B0,
Key_0, Key_c, 0x00A9,
Key_0, Key_s, 0x00A7,
Key_0, Key_x, 0x00A4,
Key_1, Key_2, 0x00BD,
Key_1, Key_3, 0x2153,
Key_1, Key_4, 0x00BC,
Key_1, Key_5, 0x2155,
Key_1, Key_6, 0x2159,
Key_1, Key_8, 0x215B,
Key_1, Key_S, 0x00B9,
Key_1, Key_asciicircum, 0x00B9,
Key_1, Key_s, 0x00B9,
Key_2, Key_3, 0x2154,
Key_2, Key_5, 0x2156,
Key_2, Key_S, 0x00B2,
Key_2, Key_asciicircum, 0x00B2,
Key_2, Key_s, 0x00B2,
Key_3, Key_4, 0x00BE,
Key_3, Key_5, 0x2157,
Key_3, Key_8, 0x215C,
Key_3, Key_S, 0x00B3,
Key_3, Key_asciicircum, 0x00B3,
Key_3, Key_s, 0x00B3,
Key_4, Key_5, 0x2158,
Key_5, Key_6, 0x215A,
Key_5, Key_8, 0x215D,
Key_7, Key_8, 0x215E,
Key_colon, Key_minus, 0x00F7,
Key_semicolon, Key_A, 0x0104,
Key_semicolon, Key_E, 0x0118,
Key_semicolon, Key_I, 0x012E,
Key_semicolon, Key_O, 0x01EA,
Key_semicolon, Key_U, 0x0172,
Key_semicolon, Key_a, 0x0105,
Key_semicolon, Key_e, 0x0119,
Key_semicolon, Key_i, 0x012F,
Key_semicolon, Key_o, 0x01EB,
Key_semicolon, Key_u, 0x0173,
Key_less, Key_space, 0x02C7,
Key_less, Key_quotedbl, 0x201C,
Key_less, Key_apostrophe, 0x2018,
Key_less, Key_slash, 0x005C,
Key_less, Key_less, 0x00AB,
Key_less, Key_C, 0x010C,
Key_less, Key_D, 0x010E,
Key_less, Key_E, 0x011A,
Key_less, Key_L, 0x013D,
Key_less, Key_N, 0x0147,
Key_less, Key_R, 0x0158,
Key_less, Key_S, 0x0160,
Key_less, Key_T, 0x0164,
Key_less, Key_Z, 0x017D,
Key_less, Key_c, 0x010D,
Key_less, Key_d, 0x010F,
Key_less, Key_e, 0x011B,
Key_less, Key_l, 0x013E,
Key_less, Key_n, 0x0148,
Key_less, Key_r, 0x0159,
Key_less, Key_s, 0x0161,
Key_less, Key_t, 0x0165,
Key_less, Key_z, 0x017E,
Key_less, 0x0338, 0x226E,
Key_equal, Key_C, 0x20AC,
Key_equal, Key_E, 0x20AC,
Key_equal, Key_L, 0x00A3,
Key_equal, Key_N, 0x20A6,
Key_equal, Key_O, 0x0150,
Key_equal, Key_U, 0x0170,
Key_equal, Key_W, 0x20A9,
Key_equal, Key_Y, 0x00A5,
Key_equal, Key_c, 0x20AC,
Key_equal, Key_e, 0x20AC,
Key_equal, Key_l, 0x00A3,
Key_equal, Key_o, 0x0151,
Key_equal, Key_u, 0x0171,
Key_equal, Key_y, 0x00A5,
Key_equal, 0x0338, 0x2260,
Key_equal, Key_Cyrillic_u, 0x04F3,
Key_equal, Key_Cyrillic_IE, 0x20AC,
Key_equal, Key_Cyrillic_ES, 0x20AC,
Key_equal, Key_Cyrillic_U, 0x04F2,
Key_greater, Key_space, 0x005E,
Key_greater, Key_quotedbl, 0x201D,
Key_greater, Key_apostrophe, 0x2019,
Key_greater, Key_greater, 0x00BB,
Key_greater, Key_A, 0x00C2,
Key_greater, Key_E, 0x00CA,
Key_greater, Key_I, 0x00CE,
Key_greater, Key_O, 0x00D4,
Key_greater, Key_U, 0x00DB,
Key_greater, Key_a, 0x00E2,
Key_greater, Key_e, 0x00EA,
Key_greater, Key_i, 0x00EE,
Key_greater, Key_o, 0x00F4,
Key_greater, Key_u, 0x00FB,
Key_greater, 0x0338, 0x226F,
Key_question, Key_exclam, 0x203D,
Key_question, Key_question, 0x00BF,
Key_question, Key_A, 0x1EA2,
Key_question, Key_E, 0x1EBA,
Key_question, Key_I, 0x1EC8,
Key_question, Key_O, 0x1ECE,
Key_question, Key_U, 0x1EE6,
Key_question, Key_Y, 0x1EF6,
Key_question, Key_a, 0x1EA3,
Key_question, Key_e, 0x1EBB,
Key_question, Key_i, 0x1EC9,
Key_question, Key_o, 0x1ECF,
Key_question, Key_u, 0x1EE7,
Key_question, Key_y, 0x1EF7,
Key_question, Key_Acircumflex, 0x1EA8,
Key_question, Key_Ecircumflex, 0x1EC2,
Key_question, Key_Ocircumflex, 0x1ED4,
Key_question, Key_acircumflex, 0x1EA9,
Key_question, Key_ecircumflex, 0x1EC3,
Key_question, Key_ocircumflex, 0x1ED5,
Key_question, Key_Ohorn, 0x1EDE,
Key_question, Key_ohorn, 0x1EDF,
Key_question, Key_Uhorn, 0x1EEC,
Key_question, Key_uhorn, 0x1EED,
Key_question, Key_Abreve, 0x1EB2,
Key_question, Key_abreve, 0x1EB3,
Key_A, Key_quotedbl, 0x00C4,
Key_A, Key_apostrophe, 0x00C1,
Key_A, Key_parenleft, 0x0102,
Key_A, Key_asterisk, 0x00C5,
Key_A, Key_comma, 0x0104,
Key_A, Key_minus, 0x00C3,
Key_A, Key_greater, 0x00C2,
Key_A, Key_A, 0x00C5,
Key_A, Key_E, 0x00C6,
Key_A, Key_T, 0x0040,
Key_A, Key_asciicircum, 0x00C2,
Key_A, Key_underscore, 0x00AA,
Key_A, Key_grave, 0x00C0,
Key_A, Key_asciitilde, 0x00C3,
Key_A, Key_diaeresis, 0x00C4,
Key_A, Key_acute, 0x00C1,
Key_B, Key_period, 0x1E02,
Key_C, Key_apostrophe, 0x0106,
Key_C, Key_comma, 0x00C7,
Key_C, Key_period, 0x010A,
Key_C, Key_slash, 0x00A2,
Key_C, Key_0, 0x00A9,
Key_C, Key_less, 0x010C,
Key_C, Key_equal, 0x20AC,
Key_C, Key_E, 0x20A0,
Key_C, Key_O, 0x00A9,
Key_C, Key_o, 0x00A9,
Key_C, Key_r, 0x20A2,
Key_C, Key_bar, 0x00A2,
Key_D, Key_minus, 0x0110,
Key_D, Key_period, 0x1E0A,
Key_D, Key_less, 0x010E,
Key_D, Key_H, 0x00D0,
Key_E, Key_quotedbl, 0x00CB,
Key_E, Key_apostrophe, 0x00C9,
Key_E, Key_comma, 0x0118,
Key_E, Key_minus, 0x0112,
Key_E, Key_period, 0x0116,
Key_E, Key_less, 0x011A,
Key_E, Key_equal, 0x20AC,
Key_E, Key_greater, 0x00CA,
Key_E, Key_asciicircum, 0x00CA,
Key_E, Key_underscore, 0x0112,
Key_E, Key_grave, 0x00C8,
Key_E, Key_diaeresis, 0x00CB,
Key_E, Key_acute, 0x00C9,
Key_F, Key_period, 0x1E1E,
Key_F, Key_r, 0x20A3,
Key_G, Key_parenleft, 0x011E,
Key_G, Key_comma, 0x0122,
Key_G, Key_period, 0x0120,
Key_G, Key_U, 0x011E,
Key_G, Key_breve, 0x011E,
Key_I, Key_quotedbl, 0x00CF,
Key_I, Key_apostrophe, 0x00CD,
Key_I, Key_comma, 0x012E,
Key_I, Key_minus, 0x012A,
Key_I, Key_period, 0x0130,
Key_I, Key_greater, 0x00CE,
Key_I, Key_asciicircum, 0x00CE,
Key_I, Key_underscore, 0x012A,
Key_I, Key_grave, 0x00CC,
Key_I, Key_asciitilde, 0x0128,
Key_I, Key_diaeresis, 0x00CF,
Key_I, Key_acute, 0x00CD,
Key_K, Key_comma, 0x0136,
Key_L, Key_apostrophe, 0x0139,
Key_L, Key_comma, 0x013B,
Key_L, Key_minus, 0x00A3,
Key_L, Key_slash, 0x0141,
Key_L, Key_less, 0x013D,
Key_L, Key_equal, 0x00A3,
Key_L, Key_V, 0x007C,
Key_M, Key_period, 0x1E40,
Key_N, Key_apostrophe, 0x0143,
Key_N, Key_comma, 0x0145,
Key_N, Key_minus, 0x00D1,
Key_N, Key_less, 0x0147,
Key_N, Key_equal, 0x20A6,
Key_N, Key_G, 0x014A,
Key_N, Key_O, 0x2116,
Key_N, Key_o, 0x2116,
Key_N, Key_asciitilde, 0x00D1,
Key_O, Key_quotedbl, 0x00D6,
Key_O, Key_apostrophe, 0x00D3,
Key_O, Key_minus, 0x00D5,
Key_O, Key_slash, 0x00D8,
Key_O, Key_greater, 0x00D4,
Key_O, Key_C, 0x00A9,
Key_O, Key_E, 0x0152,
Key_O, Key_R, 0x00AE,
Key_O, Key_S, 0x00A7,
Key_O, Key_X, 0x00A4,
Key_O, Key_asciicircum, 0x00D4,
Key_O, Key_underscore, 0x00BA,
Key_O, Key_grave, 0x00D2,
Key_O, Key_c, 0x00A9,
Key_O, Key_r, 0x00AE,
Key_O, Key_x, 0x00A4,
Key_O, Key_asciitilde, 0x00D5,
Key_O, Key_diaeresis, 0x00D6,
Key_O, Key_acute, 0x00D3,
Key_P, Key_exclam, 0x00B6,
Key_P, Key_period, 0x1E56,
Key_P, Key_P, 0x00B6,
Key_P, Key_t, 0x20A7,
Key_R, Key_apostrophe, 0x0154,
Key_R, Key_comma, 0x0156,
Key_R, Key_less, 0x0158,
Key_R, Key_O, 0x00AE,
Key_R, Key_s, 0x20A8,
Key_S, Key_exclam, 0x00A7,
Key_S, Key_apostrophe, 0x015A,
Key_S, Key_comma, 0x015E,
Key_S, Key_period, 0x1E60,
Key_S, Key_0, 0x00A7,
Key_S, Key_1, 0x00B9,
Key_S, Key_2, 0x00B2,
Key_S, Key_3, 0x00B3,
Key_S, Key_less, 0x0160,
Key_S, Key_M, 0x2120,
Key_S, Key_O, 0x00A7,
Key_S, Key_m, 0x2120,
Key_S, Key_cedilla, 0x015E,
Key_T, Key_minus, 0x0166,
Key_T, Key_period, 0x1E6A,
Key_T, Key_slash, 0x0166,
Key_T, Key_less, 0x0164,
Key_T, Key_H, 0x00DE,
Key_T, Key_M, 0x2122,
Key_T, Key_m, 0x2122,
Key_U, Key_quotedbl, 0x00DC,
Key_U, Key_apostrophe, 0x00DA,
Key_U, Key_asterisk, 0x016E,
Key_U, Key_comma, 0x0172,
Key_U, Key_minus, 0x016A,
Key_U, Key_slash, 0x00B5,
Key_U, Key_greater, 0x00DB,
Key_U, Key_A, 0x0102,
Key_U, Key_E, 0x0114,
Key_U, Key_G, 0x011E,
Key_U, Key_I, 0x012C,
Key_U, Key_O, 0x014E,
Key_U, Key_U, 0x016C,
Key_U, Key_asciicircum, 0x00DB,
Key_U, Key_underscore, 0x016A,
Key_U, Key_grave, 0x00D9,
Key_U, Key_a, 0x0103,
Key_U, Key_e, 0x0115,
Key_U, Key_g, 0x011F,
Key_U, Key_i, 0x012D,
Key_U, Key_o, 0x014F,
Key_U, Key_u, 0x016D,
Key_U, Key_asciitilde, 0x0168,
Key_U, Key_diaeresis, 0x00DC,
Key_U, Key_acute, 0x00DA,
Key_U, 0x0228, 0x1E1C,
Key_U, 0x0229, 0x1E1D,
Key_U, Key_Cyrillic_a, 0x04D1,
Key_U, Key_Cyrillic_ie, 0x04D7,
Key_U, Key_Cyrillic_i, 0x0439,
Key_U, Key_Cyrillic_u, 0x045E,
Key_U, Key_Cyrillic_zhe, 0x04C2,
Key_U, Key_Cyrillic_A, 0x04D0,
Key_U, Key_Cyrillic_IE, 0x04D6,
Key_U, Key_Cyrillic_I, 0x0419,
Key_U, Key_Cyrillic_U, 0x040E,
Key_U, Key_Cyrillic_ZHE, 0x04C1,
Key_U, Key_Greek_ALPHA, 0x1FB8,
Key_U, Key_Greek_IOTA, 0x1FD8,
Key_U, Key_Greek_UPSILON, 0x1FE8,
Key_U, Key_Greek_alpha, 0x1FB0,
Key_U, Key_Greek_iota, 0x1FD0,
Key_U, Key_Greek_upsilon, 0x1FE0,
Key_U, 0x1EA0, 0x1EB6,
Key_U, 0x1EA1, 0x1EB7,
Key_V, Key_L, 0x007C,
Key_W, Key_equal, 0x20A9,
Key_W, Key_asciicircum, 0x0174,
Key_X, Key_0, 0x00A4,
Key_X, Key_O, 0x00A4,
Key_X, Key_o, 0x00A4,
Key_Y, Key_quotedbl, 0x0178,
Key_Y, Key_apostrophe, 0x00DD,
Key_Y, Key_minus, 0x00A5,
Key_Y, Key_equal, 0x00A5,
Key_Y, Key_asciicircum, 0x0176,
Key_Y, Key_diaeresis, 0x0178,
Key_Y, Key_acute, 0x00DD,
Key_Z, Key_apostrophe, 0x0179,
Key_Z, Key_period, 0x017B,
Key_Z, Key_less, 0x017D,
Key_asciicircum, Key_space, 0x005E,
Key_asciicircum, Key_parenleft, 0x207D,
Key_asciicircum, Key_parenright, 0x207E,
Key_asciicircum, Key_plus, 0x207A,
Key_asciicircum, Key_minus, 0x00AF,
Key_asciicircum, Key_period, 0x00B7,
Key_asciicircum, Key_slash, 0x007C,
Key_asciicircum, Key_0, 0x00B0,
Key_asciicircum, Key_1, 0x00B9,
Key_asciicircum, Key_2, 0x00B2,
Key_asciicircum, Key_3, 0x00B3,
Key_asciicircum, Key_4, 0x2074,
Key_asciicircum, Key_5, 0x2075,
Key_asciicircum, Key_6, 0x2076,
Key_asciicircum, Key_7, 0x2077,
Key_asciicircum, Key_8, 0x2078,
Key_asciicircum, Key_9, 0x2079,
Key_asciicircum, Key_equal, 0x207C,
Key_asciicircum, Key_A, 0x00C2,
Key_asciicircum, Key_C, 0x0108,
Key_asciicircum, Key_E, 0x00CA,
Key_asciicircum, Key_G, 0x011C,
Key_asciicircum, Key_H, 0x0124,
Key_asciicircum, Key_I, 0x00CE,
Key_asciicircum, Key_J, 0x0134,
Key_asciicircum, Key_O, 0x00D4,
Key_asciicircum, Key_S, 0x015C,
Key_asciicircum, Key_U, 0x00DB,
Key_asciicircum, Key_W, 0x0174,
Key_asciicircum, Key_Y, 0x0176,
Key_asciicircum, Key_Z, 0x1E90,
Key_asciicircum, Key_underscore, 0x00AF,
Key_asciicircum, Key_a, 0x00E2,
Key_asciicircum, Key_c, 0x0109,
Key_asciicircum, Key_e, 0x00EA,
Key_asciicircum, Key_g, 0x011D,
Key_asciicircum, Key_h, 0x0125,
Key_asciicircum, Key_i, 0x00EE,
Key_asciicircum, Key_j, 0x0135,
Key_asciicircum, Key_o, 0x00F4,
Key_asciicircum, Key_s, 0x015D,
Key_asciicircum, Key_u, 0x00FB,
Key_asciicircum, Key_w, 0x0175,
Key_asciicircum, Key_y, 0x0177,
Key_asciicircum, Key_z, 0x1E91,
Key_asciicircum, 0x1EA0, 0x1EAC,
Key_asciicircum, 0x1EA1, 0x1EAD,
Key_asciicircum, 0x1EB8, 0x1EC6,
Key_asciicircum, 0x1EB9, 0x1EC7,
Key_asciicircum, 0x1ECC, 0x1ED8,
Key_asciicircum, 0x1ECD, 0x1ED9,
Key_asciicircum, 0x2212, 0x207B,
Key_asciicircum, 0x4E00, 0x3192,
Key_asciicircum, 0x4E01, 0x319C,
Key_asciicircum, 0x4E09, 0x3194,
Key_asciicircum, 0x4E0A, 0x3196,
Key_asciicircum, 0x4E0B, 0x3198,
Key_asciicircum, 0x4E19, 0x319B,
Key_asciicircum, 0x4E2D, 0x3197,
Key_asciicircum, 0x4E59, 0x319A,
Key_asciicircum, 0x4E8C, 0x3193,
Key_asciicircum, 0x4EBA, 0x319F,
Key_asciicircum, 0x56DB, 0x3195,
Key_asciicircum, 0x5730, 0x319E,
Key_asciicircum, 0x5929, 0x319D,
Key_asciicircum, 0x7532, 0x3199,
Key_asciicircum, Key_KP_Space, 0x00B2,
Key_asciicircum, Key_KP_Add, 0x207A,
Key_asciicircum, Key_KP_0, 0x2070,
Key_asciicircum, Key_KP_1, 0x00B9,
Key_asciicircum, Key_KP_2, 0x00B2,
Key_asciicircum, Key_KP_3, 0x00B3,
Key_asciicircum, Key_KP_4, 0x2074,
Key_asciicircum, Key_KP_5, 0x2075,
Key_asciicircum, Key_KP_6, 0x2076,
Key_asciicircum, Key_KP_7, 0x2077,
Key_asciicircum, Key_KP_8, 0x2078,
Key_asciicircum, Key_KP_9, 0x2079,
Key_asciicircum, Key_KP_Equal, 0x207C,
Key_underscore, Key_parenleft, 0x208D,
Key_underscore, Key_parenright, 0x208E,
Key_underscore, Key_plus, 0x208A,
Key_underscore, Key_0, 0x2080,
Key_underscore, Key_1, 0x2081,
Key_underscore, Key_2, 0x2082,
Key_underscore, Key_3, 0x2083,
Key_underscore, Key_4, 0x2084,
Key_underscore, Key_5, 0x2085,
Key_underscore, Key_6, 0x2086,
Key_underscore, Key_7, 0x2087,
Key_underscore, Key_8, 0x2088,
Key_underscore, Key_9, 0x2089,
Key_underscore, Key_equal, 0x208C,
Key_underscore, Key_A, 0x00AA,
Key_underscore, Key_E, 0x0112,
Key_underscore, Key_G, 0x1E20,
Key_underscore, Key_I, 0x012A,
Key_underscore, Key_O, 0x00BA,
Key_underscore, Key_U, 0x016A,
Key_underscore, Key_Y, 0x0232,
Key_underscore, Key_asciicircum, 0x00AF,
Key_underscore, Key_underscore, 0x00AF,
Key_underscore, Key_a, 0x00AA,
Key_underscore, Key_e, 0x0113,
Key_underscore, Key_g, 0x1E21,
Key_underscore, Key_i, 0x012B,
Key_underscore, Key_o, 0x00BA,
Key_underscore, Key_u, 0x016B,
Key_underscore, Key_y, 0x0233,
Key_underscore, Key_Adiaeresis, 0x01DE,
Key_underscore, Key_AE, 0x01E2,
Key_underscore, Key_Otilde, 0x022C,
Key_underscore, Key_Odiaeresis, 0x022A,
Key_underscore, 0x00DC, 0x01D5,
Key_underscore, Key_adiaeresis, 0x01DF,
Key_underscore, Key_ae, 0x01E3,
Key_underscore, Key_otilde, 0x022D,
Key_underscore, Key_odiaeresis, 0x022B,
Key_underscore, Key_udiaeresis, 0x01D6,
Key_underscore, 0x01EA, 0x01EC,
Key_underscore, 0x01EB, 0x01ED,
Key_underscore, 0x0226, 0x01E0,
Key_underscore, 0x0227, 0x01E1,
Key_underscore, 0x022E, 0x0230,
Key_underscore, 0x022F, 0x0231,
Key_underscore, Key_Cyrillic_i, 0x04E3,
Key_underscore, Key_Cyrillic_u, 0x04EF,
Key_underscore, Key_Cyrillic_I, 0x04E2,
Key_underscore, Key_Cyrillic_U, 0x04EE,
Key_underscore, Key_Greek_ALPHA, 0x1FB9,
Key_underscore, Key_Greek_IOTA, 0x1FD9,
Key_underscore, Key_Greek_UPSILON, 0x1FE9,
Key_underscore, Key_Greek_alpha, 0x1FB1,
Key_underscore, Key_Greek_iota, 0x1FD1,
Key_underscore, Key_Greek_upsilon, 0x1FE1,
Key_underscore, 0x1E36, 0x1E38,
Key_underscore, 0x1E37, 0x1E39,
Key_underscore, 0x1E5A, 0x1E5C,
Key_underscore, 0x1E5B, 0x1E5D,
Key_underscore, 0x2212, 0x208B,
Key_underscore, Key_KP_Space, 0x2082,
Key_underscore, Key_KP_Add, 0x208A,
Key_underscore, Key_KP_0, 0x2080,
Key_underscore, Key_KP_1, 0x2081,
Key_underscore, Key_KP_2, 0x2082,
Key_underscore, Key_KP_3, 0x2083,
Key_underscore, Key_KP_4, 0x2084,
Key_underscore, Key_KP_5, 0x2085,
Key_underscore, Key_KP_6, 0x2086,
Key_underscore, Key_KP_7, 0x2087,
Key_underscore, Key_KP_8, 0x2088,
Key_underscore, Key_KP_9, 0x2089,
Key_underscore, Key_KP_Equal, 0x208C,
Key_grave, Key_space, 0x0060,
Key_grave, Key_A, 0x00C0,
Key_grave, Key_E, 0x00C8,
Key_grave, Key_I, 0x00CC,
Key_grave, Key_N, 0x01F8,
Key_grave, Key_O, 0x00D2,
Key_grave, Key_U, 0x00D9,
Key_grave, Key_W, 0x1E80,
Key_grave, Key_Y, 0x1EF2,
Key_grave, Key_a, 0x00E0,
Key_grave, Key_e, 0x00E8,
Key_grave, Key_i, 0x00EC,
Key_grave, Key_n, 0x01F9,
Key_grave, Key_o, 0x00F2,
Key_grave, Key_u, 0x00F9,
Key_grave, Key_w, 0x1E81,
Key_grave, Key_y, 0x1EF3,
Key_grave, Key_Acircumflex, 0x1EA6,
Key_grave, Key_Ecircumflex, 0x1EC0,
Key_grave, Key_Ocircumflex, 0x1ED2,
Key_grave, 0x00DC, 0x01DB,
Key_grave, Key_acircumflex, 0x1EA7,
Key_grave, Key_ecircumflex, 0x1EC1,
Key_grave, Key_ocircumflex, 0x1ED3,
Key_grave, Key_udiaeresis, 0x01DC,
Key_grave, Key_Ohorn, 0x1EDC,
Key_grave, Key_ohorn, 0x1EDD,
Key_grave, Key_Uhorn, 0x1EEA,
Key_grave, Key_uhorn, 0x1EEB,
Key_grave, Key_Abreve, 0x1EB0,
Key_grave, Key_abreve, 0x1EB1,
Key_grave, Key_Emacron, 0x1E14,
Key_grave, Key_emacron, 0x1E15,
Key_grave, Key_Omacron, 0x1E50,
Key_grave, Key_omacron, 0x1E51,
Key_grave, Key_Cyrillic_ie, 0x0450,
Key_grave, Key_Cyrillic_i, 0x045D,
Key_grave, Key_Cyrillic_IE, 0x0400,
Key_grave, Key_Cyrillic_I, 0x040D,
Key_grave, Key_Greek_iotadieresis, 0x1FD2,
Key_grave, Key_Greek_upsilondieresis, 0x1FE2,
Key_grave, Key_Greek_ALPHA, 0x1FBA,
Key_grave, Key_Greek_EPSILON, 0x1FC8,
Key_grave, Key_Greek_ETA, 0x1FCA,
Key_grave, Key_Greek_IOTA, 0x1FDA,
Key_grave, Key_Greek_OMICRON, 0x1FF8,
Key_grave, Key_Greek_UPSILON, 0x1FEA,
Key_grave, Key_Greek_OMEGA, 0x1FFA,
Key_grave, Key_Greek_alpha, 0x1F70,
Key_grave, Key_Greek_epsilon, 0x1F72,
Key_grave, Key_Greek_eta, 0x1F74,
Key_grave, Key_Greek_iota, 0x1F76,
Key_grave, Key_Greek_omicron, 0x1F78,
Key_grave, Key_Greek_upsilon, 0x1F7A,
Key_grave, Key_Greek_omega, 0x1F7C,
Key_grave, 0x1F00, 0x1F02,
Key_grave, 0x1F01, 0x1F03,
Key_grave, 0x1F08, 0x1F0A,
Key_grave, 0x1F09, 0x1F0B,
Key_grave, 0x1F10, 0x1F12,
Key_grave, 0x1F11, 0x1F13,
Key_grave, 0x1F18, 0x1F1A,
Key_grave, 0x1F19, 0x1F1B,
Key_grave, 0x1F20, 0x1F22,
Key_grave, 0x1F21, 0x1F23,
Key_grave, 0x1F28, 0x1F2A,
Key_grave, 0x1F29, 0x1F2B,
Key_grave, 0x1F30, 0x1F32,
Key_grave, 0x1F31, 0x1F33,
Key_grave, 0x1F38, 0x1F3A,
Key_grave, 0x1F39, 0x1F3B,
Key_grave, 0x1F40, 0x1F42,
Key_grave, 0x1F41, 0x1F43,
Key_grave, 0x1F48, 0x1F4A,
Key_grave, 0x1F49, 0x1F4B,
Key_grave, 0x1F50, 0x1F52,
Key_grave, 0x1F51, 0x1F53,
Key_grave, 0x1F59, 0x1F5B,
Key_grave, 0x1F60, 0x1F62,
Key_grave, 0x1F61, 0x1F63,
Key_grave, 0x1F68, 0x1F6A,
Key_grave, 0x1F69, 0x1F6B,
Key_a, Key_quotedbl, 0x00E4,
Key_a, Key_apostrophe, 0x00E1,
Key_a, Key_parenleft, 0x0103,
Key_a, Key_asterisk, 0x00E5,
Key_a, Key_comma, 0x0105,
Key_a, Key_minus, 0x00E3,
Key_a, Key_greater, 0x00E2,
Key_a, Key_asciicircum, 0x00E2,
Key_a, Key_underscore, 0x00AA,
Key_a, Key_grave, 0x00E0,
Key_a, Key_a, 0x00E5,
Key_a, Key_e, 0x00E6,
Key_a, Key_asciitilde, 0x00E3,
Key_a, Key_diaeresis, 0x00E4,
Key_a, Key_acute, 0x00E1,
Key_b, Key_period, 0x1E03,
Key_b, Key_A, 0x0102,
Key_b, Key_E, 0x0114,
Key_b, Key_G, 0x011E,
Key_b, Key_I, 0x012C,
Key_b, Key_O, 0x014E,
Key_b, Key_U, 0x016C,
Key_b, Key_a, 0x0103,
Key_b, Key_e, 0x0115,
Key_b, Key_g, 0x011F,
Key_b, Key_i, 0x012D,
Key_b, Key_o, 0x014F,
Key_b, Key_u, 0x016D,
Key_b, 0x0228, 0x1E1C,
Key_b, 0x0229, 0x1E1D,
Key_b, Key_Cyrillic_a, 0x04D1,
Key_b, Key_Cyrillic_ie, 0x04D7,
Key_b, Key_Cyrillic_i, 0x0439,
Key_b, Key_Cyrillic_u, 0x045E,
Key_b, Key_Cyrillic_zhe, 0x04C2,
Key_b, Key_Cyrillic_A, 0x04D0,
Key_b, Key_Cyrillic_IE, 0x04D6,
Key_b, Key_Cyrillic_I, 0x0419,
Key_b, Key_Cyrillic_U, 0x040E,
Key_b, Key_Cyrillic_ZHE, 0x04C1,
Key_b, Key_Greek_ALPHA, 0x1FB8,
Key_b, Key_Greek_IOTA, 0x1FD8,
Key_b, Key_Greek_UPSILON, 0x1FE8,
Key_b, Key_Greek_alpha, 0x1FB0,
Key_b, Key_Greek_iota, 0x1FD0,
Key_b, Key_Greek_upsilon, 0x1FE0,
Key_b, 0x1EA0, 0x1EB6,
Key_b, 0x1EA1, 0x1EB7,
Key_c, Key_apostrophe, 0x0107,
Key_c, Key_comma, 0x00E7,
Key_c, Key_period, 0x010B,
Key_c, Key_slash, 0x00A2,
Key_c, Key_0, 0x00A9,
Key_c, Key_less, 0x010D,
Key_c, Key_equal, 0x20AC,
Key_c, Key_A, 0x01CD,
Key_c, Key_C, 0x010C,
Key_c, Key_D, 0x010E,
Key_c, Key_E, 0x011A,
Key_c, Key_G, 0x01E6,
Key_c, Key_H, 0x021E,
Key_c, Key_I, 0x01CF,
Key_c, Key_K, 0x01E8,
Key_c, Key_L, 0x013D,
Key_c, Key_N, 0x0147,
Key_c, Key_O, 0x00A9,
Key_c, Key_R, 0x0158,
Key_c, Key_S, 0x0160,
Key_c, Key_T, 0x0164,
Key_c, Key_U, 0x01D3,
Key_c, Key_Z, 0x017D,
Key_c, Key_a, 0x01CE,
Key_c, Key_c, 0x010D,
Key_c, Key_d, 0x010F,
Key_c, Key_e, 0x011B,
Key_c, Key_g, 0x01E7,
Key_c, Key_h, 0x021F,
Key_c, Key_i, 0x01D0,
Key_c, Key_j, 0x01F0,
Key_c, Key_k, 0x01E9,
Key_c, Key_l, 0x013E,
Key_c, Key_n, 0x0148,
Key_c, Key_o, 0x00A9,
Key_c, Key_r, 0x0159,
Key_c, Key_s, 0x0161,
Key_c, Key_t, 0x0165,
Key_c, Key_u, 0x01D4,
Key_c, Key_z, 0x017E,
Key_c, Key_bar, 0x00A2,
Key_c, 0x00DC, 0x01D9,
Key_c, Key_udiaeresis, 0x01DA,
Key_c, 0x01B7, 0x01EE,
Key_c, 0x0292, 0x01EF,
Key_d, Key_minus, 0x0111,
Key_d, Key_period, 0x1E0B,
Key_d, Key_less, 0x010F,
Key_d, Key_h, 0x00F0,
Key_e, Key_quotedbl, 0x00EB,
Key_e, Key_apostrophe, 0x00E9,
Key_e, Key_comma, 0x0119,
Key_e, Key_minus, 0x0113,
Key_e, Key_period, 0x0117,
Key_e, Key_less, 0x011B,
Key_e, Key_equal, 0x20AC,
Key_e, Key_greater, 0x00EA,
Key_e, Key_asciicircum, 0x00EA,
Key_e, Key_underscore, 0x0113,
Key_e, Key_grave, 0x00E8,
Key_e, Key_e, 0x0259,
Key_e, Key_diaeresis, 0x00EB,
Key_e, Key_acute, 0x00E9,
Key_f, Key_period, 0x1E1F,
Key_f, Key_S, 0x017F,
Key_f, Key_s, 0x017F,
Key_g, Key_parenleft, 0x011F,
Key_g, Key_comma, 0x0123,
Key_g, Key_period, 0x0121,
Key_g, Key_U, 0x011F,
Key_g, Key_breve, 0x011F,
Key_i, Key_quotedbl, 0x00EF,
Key_i, Key_apostrophe, 0x00ED,
Key_i, Key_comma, 0x012F,
Key_i, Key_minus, 0x012B,
Key_i, Key_period, 0x0131,
Key_i, Key_greater, 0x00EE,
Key_i, Key_asciicircum, 0x00EE,
Key_i, Key_underscore, 0x012B,
Key_i, Key_grave, 0x00EC,
Key_i, Key_asciitilde, 0x0129,
Key_i, Key_diaeresis, 0x00EF,
Key_i, Key_acute, 0x00ED,
Key_k, Key_comma, 0x0137,
Key_k, Key_k, 0x0138,
Key_l, Key_apostrophe, 0x013A,
Key_l, Key_comma, 0x013C,
Key_l, Key_minus, 0x00A3,
Key_l, Key_slash, 0x0142,
Key_l, Key_less, 0x013E,
Key_l, Key_equal, 0x00A3,
Key_l, Key_v, 0x007C,
Key_m, Key_period, 0x1E41,
Key_m, Key_slash, 0x20A5,
Key_m, Key_u, 0x00B5,
Key_n, Key_apostrophe, 0x0144,
Key_n, Key_comma, 0x0146,
Key_n, Key_minus, 0x00F1,
Key_n, Key_less, 0x0148,
Key_n, Key_g, 0x014B,
Key_n, Key_asciitilde, 0x00F1,
Key_o, Key_quotedbl, 0x00F6,
Key_o, Key_apostrophe, 0x00F3,
Key_o, Key_minus, 0x00F5,
Key_o, Key_slash, 0x00F8,
Key_o, Key_greater, 0x00F4,
Key_o, Key_A, 0x00C5,
Key_o, Key_C, 0x00A9,
Key_o, Key_R, 0x00AE,
Key_o, Key_U, 0x016E,
Key_o, Key_X, 0x00A4,
Key_o, Key_asciicircum, 0x00F4,
Key_o, Key_underscore, 0x00BA,
Key_o, Key_grave, 0x00F2,
Key_o, Key_a, 0x00E5,
Key_o, Key_c, 0x00A9,
Key_o, Key_e, 0x0153,
Key_o, Key_o, 0x00B0,
Key_o, Key_r, 0x00AE,
Key_o, Key_s, 0x00A7,
Key_o, Key_u, 0x016F,
Key_o, Key_w, 0x1E98,
Key_o, Key_x, 0x00A4,
Key_o, Key_y, 0x1E99,
Key_o, Key_asciitilde, 0x00F5,
Key_o, Key_diaeresis, 0x00F6,
Key_o, Key_acute, 0x00F3,
Key_p, Key_exclam, 0x00B6,
Key_p, Key_period, 0x1E57,
Key_r, Key_apostrophe, 0x0155,
Key_r, Key_comma, 0x0157,
Key_r, Key_less, 0x0159,
Key_s, Key_exclam, 0x00A7,
Key_s, Key_apostrophe, 0x015B,
Key_s, Key_comma, 0x015F,
Key_s, Key_period, 0x1E61,
Key_s, Key_0, 0x00A7,
Key_s, Key_1, 0x00B9,
Key_s, Key_2, 0x00B2,
Key_s, Key_3, 0x00B3,
Key_s, Key_less, 0x0161,
Key_s, Key_M, 0x2120,
Key_s, Key_m, 0x2120,
Key_s, Key_o, 0x00A7,
Key_s, Key_s, 0x00DF,
Key_s, Key_cedilla, 0x015F,
Key_t, Key_minus, 0x0167,
Key_t, Key_period, 0x1E6B,
Key_t, Key_slash, 0x0167,
Key_t, Key_less, 0x0165,
Key_t, Key_M, 0x2122,
Key_t, Key_h, 0x00FE,
Key_t, Key_m, 0x2122,
Key_u, Key_quotedbl, 0x00FC,
Key_u, Key_apostrophe, 0x00FA,
Key_u, Key_asterisk, 0x016F,
Key_u, Key_comma, 0x0173,
Key_u, Key_minus, 0x016B,
Key_u, Key_slash, 0x00B5,
Key_u, Key_greater, 0x00FB,
Key_u, Key_asciicircum, 0x00FB,
Key_u, Key_underscore, 0x016B,
Key_u, Key_grave, 0x00F9,
Key_u, Key_u, 0x016D,
Key_u, Key_asciitilde, 0x0169,
Key_u, Key_diaeresis, 0x00FC,
Key_u, Key_acute, 0x00FA,
Key_v, Key_Z, 0x017D,
Key_v, Key_l, 0x007C,
Key_v, Key_z, 0x017E,
Key_w, Key_asciicircum, 0x0175,
Key_x, Key_0, 0x00A4,
Key_x, Key_O, 0x00A4,
Key_x, Key_o, 0x00A4,
Key_x, Key_x, 0x00D7,
Key_y, Key_quotedbl, 0x00FF,
Key_y, Key_apostrophe, 0x00FD,
Key_y, Key_minus, 0x00A5,
Key_y, Key_equal, 0x00A5,
Key_y, Key_asciicircum, 0x0177,
Key_y, Key_diaeresis, 0x00FF,
Key_y, Key_acute, 0x00FD,
Key_z, Key_apostrophe, 0x017A,
Key_z, Key_period, 0x017C,
Key_z, Key_less, 0x017E,
Key_bar, Key_C, 0x00A2,
Key_bar, Key_c, 0x00A2,
Key_asciitilde, Key_space, 0x007E,
Key_asciitilde, Key_A, 0x00C3,
Key_asciitilde, Key_E, 0x1EBC,
Key_asciitilde, Key_I, 0x0128,
Key_asciitilde, Key_N, 0x00D1,
Key_asciitilde, Key_O, 0x00D5,
Key_asciitilde, Key_U, 0x0168,
Key_asciitilde, Key_V, 0x1E7C,
Key_asciitilde, Key_Y, 0x1EF8,
Key_asciitilde, Key_a, 0x00E3,
Key_asciitilde, Key_e, 0x1EBD,
Key_asciitilde, Key_i, 0x0129,
Key_asciitilde, Key_n, 0x00F1,
Key_asciitilde, Key_o, 0x00F5,
Key_asciitilde, Key_u, 0x0169,
Key_asciitilde, Key_v, 0x1E7D,
Key_asciitilde, Key_y, 0x1EF9,
Key_asciitilde, Key_Acircumflex, 0x1EAA,
Key_asciitilde, Key_Ecircumflex, 0x1EC4,
Key_asciitilde, Key_Ocircumflex, 0x1ED6,
Key_asciitilde, Key_acircumflex, 0x1EAB,
Key_asciitilde, Key_ecircumflex, 0x1EC5,
Key_asciitilde, Key_ocircumflex, 0x1ED7,
Key_asciitilde, Key_Ohorn, 0x1EE0,
Key_asciitilde, Key_ohorn, 0x1EE1,
Key_asciitilde, Key_Uhorn, 0x1EEE,
Key_asciitilde, Key_uhorn, 0x1EEF,
Key_asciitilde, Key_Abreve, 0x1EB4,
Key_asciitilde, Key_abreve, 0x1EB5,
Key_asciitilde, Key_Greek_iotadieresis, 0x1FD7,
Key_asciitilde, Key_Greek_upsilondieresis, 0x1FE7,
Key_asciitilde, Key_Greek_alpha, 0x1FB6,
Key_asciitilde, Key_Greek_eta, 0x1FC6,
Key_asciitilde, Key_Greek_iota, 0x1FD6,
Key_asciitilde, Key_Greek_upsilon, 0x1FE6,
Key_asciitilde, Key_Greek_omega, 0x1FF6,
Key_asciitilde, 0x1F00, 0x1F06,
Key_asciitilde, 0x1F01, 0x1F07,
Key_asciitilde, 0x1F08, 0x1F0E,
Key_asciitilde, 0x1F09, 0x1F0F,
Key_asciitilde, 0x1F20, 0x1F26,
Key_asciitilde, 0x1F21, 0x1F27,
Key_asciitilde, 0x1F28, 0x1F2E,
Key_asciitilde, 0x1F29, 0x1F2F,
Key_asciitilde, 0x1F30, 0x1F36,
Key_asciitilde, 0x1F31, 0x1F37,
Key_asciitilde, 0x1F38, 0x1F3E,
Key_asciitilde, 0x1F39, 0x1F3F,
Key_asciitilde, 0x1F50, 0x1F56,
Key_asciitilde, 0x1F51, 0x1F57,
Key_asciitilde, 0x1F59, 0x1F5F,
Key_asciitilde, 0x1F60, 0x1F66,
Key_asciitilde, 0x1F61, 0x1F67,
Key_asciitilde, 0x1F68, 0x1F6E,
Key_asciitilde, 0x1F69, 0x1F6F,
Key_diaeresis, Key_apostrophe, 0x0385,
Key_diaeresis, Key_A, 0x00C4,
Key_diaeresis, Key_E, 0x00CB,
Key_diaeresis, Key_I, 0x00CF,
Key_diaeresis, Key_O, 0x00D6,
Key_diaeresis, Key_U, 0x00DC,
Key_diaeresis, Key_Y, 0x0178,
Key_diaeresis, Key_grave, 0x1FED,
Key_diaeresis, Key_a, 0x00E4,
Key_diaeresis, Key_e, 0x00EB,
Key_diaeresis, Key_i, 0x00EF,
Key_diaeresis, Key_o, 0x00F6,
Key_diaeresis, Key_u, 0x00FC,
Key_diaeresis, Key_y, 0x00FF,
Key_diaeresis, Key_asciitilde, 0x1FC1,
Key_diaeresis, Key_acute, 0x0385,
Key_diaeresis, Key_dead_grave, 0x1FED,
Key_diaeresis, Key_dead_acute, 0x0385,
Key_diaeresis, Key_dead_tilde, 0x1FC1,
Key_macron, Key_A, 0x0100,
Key_macron, Key_E, 0x0112,
Key_macron, Key_G, 0x1E20,
Key_macron, Key_I, 0x012A,
Key_macron, Key_O, 0x014C,
Key_macron, Key_U, 0x016A,
Key_macron, Key_Y, 0x0232,
Key_macron, Key_a, 0x0101,
Key_macron, Key_e, 0x0113,
Key_macron, Key_g, 0x1E21,
Key_macron, Key_i, 0x012B,
Key_macron, Key_o, 0x014D,
Key_macron, Key_u, 0x016B,
Key_macron, Key_y, 0x0233,
Key_macron, Key_Adiaeresis, 0x01DE,
Key_macron, Key_AE, 0x01E2,
Key_macron, Key_Otilde, 0x022C,
Key_macron, Key_Odiaeresis, 0x022A,
Key_macron, 0x00DC, 0x01D5,
Key_macron, Key_adiaeresis, 0x01DF,
Key_macron, Key_ae, 0x01E3,
Key_macron, Key_otilde, 0x022D,
Key_macron, Key_odiaeresis, 0x022B,
Key_macron, Key_udiaeresis, 0x01D6,
Key_macron, 0x01EA, 0x01EC,
Key_macron, 0x01EB, 0x01ED,
Key_macron, 0x0226, 0x01E0,
Key_macron, 0x0227, 0x01E1,
Key_macron, 0x022E, 0x0230,
Key_macron, 0x022F, 0x0231,
Key_macron, Key_Cyrillic_i, 0x04E3,
Key_macron, Key_Cyrillic_u, 0x04EF,
Key_macron, Key_Cyrillic_I, 0x04E2,
Key_macron, Key_Cyrillic_U, 0x04EE,
Key_macron, Key_Greek_ALPHA, 0x1FB9,
Key_macron, Key_Greek_IOTA, 0x1FD9,
Key_macron, Key_Greek_UPSILON, 0x1FE9,
Key_macron, Key_Greek_alpha, 0x1FB1,
Key_macron, Key_Greek_iota, 0x1FD1,
Key_macron, Key_Greek_upsilon, 0x1FE1,
Key_macron, 0x1E36, 0x1E38,
Key_macron, 0x1E37, 0x1E39,
Key_macron, 0x1E5A, 0x1E5C,
Key_macron, 0x1E5B, 0x1E5D,
Key_acute, Key_A, 0x00C1,
Key_acute, Key_C, 0x0106,
Key_acute, Key_E, 0x00C9,
Key_acute, Key_G, 0x01F4,
Key_acute, Key_I, 0x00CD,
Key_acute, Key_K, 0x1E30,
Key_acute, Key_L, 0x0139,
Key_acute, Key_M, 0x1E3E,
Key_acute, Key_N, 0x0143,
Key_acute, Key_O, 0x00D3,
Key_acute, Key_P, 0x1E54,
Key_acute, Key_R, 0x0154,
Key_acute, Key_S, 0x015A,
Key_acute, Key_U, 0x00DA,
Key_acute, Key_W, 0x1E82,
Key_acute, Key_Y, 0x00DD,
Key_acute, Key_Z, 0x0179,
Key_acute, Key_a, 0x00E1,
Key_acute, Key_c, 0x0107,
Key_acute, Key_e, 0x00E9,
Key_acute, Key_g, 0x01F5,
Key_acute, Key_i, 0x00ED,
Key_acute, Key_k, 0x1E31,
Key_acute, Key_l, 0x013A,
Key_acute, Key_m, 0x1E3F,
Key_acute, Key_n, 0x0144,
Key_acute, Key_o, 0x00F3,
Key_acute, Key_p, 0x1E55,
Key_acute, Key_r, 0x0155,
Key_acute, Key_s, 0x015B,
Key_acute, Key_u, 0x00FA,
Key_acute, Key_w, 0x1E83,
Key_acute, Key_y, 0x00FD,
Key_acute, Key_z, 0x017A,
Key_acute, Key_Acircumflex, 0x1EA4,
Key_acute, Key_Aring, 0x01FA,
Key_acute, Key_AE, 0x01FC,
Key_acute, Key_Ccedilla, 0x1E08,
Key_acute, Key_Ecircumflex, 0x1EBE,
Key_acute, Key_Idiaeresis, 0x1E2E,
Key_acute, Key_Ocircumflex, 0x1ED0,
Key_acute, Key_Otilde, 0x1E4C,
Key_acute, Key_Ooblique, 0x01FE,
Key_acute, 0x00DC, 0x01D7,
Key_acute, Key_acircumflex, 0x1EA5,
Key_acute, Key_aring, 0x01FB,
Key_acute, Key_ae, 0x01FD,
Key_acute, Key_ccedilla, 0x1E09,
Key_acute, Key_ecircumflex, 0x1EBF,
Key_acute, Key_idiaeresis, 0x1E2F,
Key_acute, Key_ocircumflex, 0x1ED1,
Key_acute, Key_otilde, 0x1E4D,
Key_acute, Key_oslash, 0x01FF,
Key_acute, Key_udiaeresis, 0x01D8,
Key_acute, Key_Ohorn, 0x1EDA,
Key_acute, Key_ohorn, 0x1EDB,
Key_acute, Key_Uhorn, 0x1EE8,
Key_acute, Key_uhorn, 0x1EE9,
Key_acute, Key_Abreve, 0x1EAE,
Key_acute, Key_abreve, 0x1EAF,
Key_acute, Key_Emacron, 0x1E16,
Key_acute, Key_emacron, 0x1E17,
Key_acute, Key_Omacron, 0x1E52,
Key_acute, Key_Utilde, 0x1E78,
Key_acute, Key_omacron, 0x1E53,
Key_acute, Key_utilde, 0x1E79,
Key_acute, Key_Cyrillic_ghe, 0x0453,
Key_acute, Key_Cyrillic_ka, 0x045C,
Key_acute, Key_Cyrillic_GHE, 0x0403,
Key_acute, Key_Cyrillic_KA, 0x040C,
Key_acute, Key_Greek_iotadieresis, 0x0390,
Key_acute, Key_Greek_upsilondieresis, 0x03B0,
Key_acute, Key_Greek_ALPHA, 0x0386,
Key_acute, Key_Greek_EPSILON, 0x0388,
Key_acute, Key_Greek_ETA, 0x0389,
Key_acute, Key_Greek_IOTA, 0x038A,
Key_acute, Key_Greek_OMICRON, 0x038C,
Key_acute, Key_Greek_UPSILON, 0x038E,
Key_acute, Key_Greek_OMEGA, 0x038F,
Key_acute, Key_Greek_alpha, 0x03AC,
Key_acute, Key_Greek_epsilon, 0x03AD,
Key_acute, Key_Greek_eta, 0x03AE,
Key_acute, Key_Greek_iota, 0x03AF,
Key_acute, Key_Greek_omicron, 0x03CC,
Key_acute, Key_Greek_upsilon, 0x03CD,
Key_acute, Key_Greek_omega, 0x03CE,
Key_acute, 0x1F00, 0x1F04,
Key_acute, 0x1F01, 0x1F05,
Key_acute, 0x1F08, 0x1F0C,
Key_acute, 0x1F09, 0x1F0D,
Key_acute, 0x1F10, 0x1F14,
Key_acute, 0x1F11, 0x1F15,
Key_acute, 0x1F18, 0x1F1C,
Key_acute, 0x1F19, 0x1F1D,
Key_acute, 0x1F20, 0x1F24,
Key_acute, 0x1F21, 0x1F25,
Key_acute, 0x1F28, 0x1F2C,
Key_acute, 0x1F29, 0x1F2D,
Key_acute, 0x1F30, 0x1F34,
Key_acute, 0x1F31, 0x1F35,
Key_acute, 0x1F38, 0x1F3C,
Key_acute, 0x1F39, 0x1F3D,
Key_acute, 0x1F40, 0x1F44,
Key_acute, 0x1F41, 0x1F45,
Key_acute, 0x1F48, 0x1F4C,
Key_acute, 0x1F49, 0x1F4D,
Key_acute, 0x1F50, 0x1F54,
Key_acute, 0x1F51, 0x1F55,
Key_acute, 0x1F59, 0x1F5D,
Key_acute, 0x1F60, 0x1F64,
Key_acute, 0x1F61, 0x1F65,
Key_acute, 0x1F68, 0x1F6C,
Key_acute, 0x1F69, 0x1F6D,
Key_cedilla, Key_C, 0x00C7,
Key_cedilla, Key_D, 0x1E10,
Key_cedilla, Key_E, 0x0228,
Key_cedilla, Key_G, 0x0122,
Key_cedilla, Key_H, 0x1E28,
Key_cedilla, Key_K, 0x0136,
Key_cedilla, Key_L, 0x013B,
Key_cedilla, Key_N, 0x0145,
Key_cedilla, Key_R, 0x0156,
Key_cedilla, Key_S, 0x015E,
Key_cedilla, Key_T, 0x0162,
Key_cedilla, Key_c, 0x00E7,
Key_cedilla, Key_d, 0x1E11,
Key_cedilla, Key_e, 0x0229,
Key_cedilla, Key_g, 0x0123,
Key_cedilla, Key_h, 0x1E29,
Key_cedilla, Key_k, 0x0137,
Key_cedilla, Key_l, 0x013C,
Key_cedilla, Key_n, 0x0146,
Key_cedilla, Key_r, 0x0157,
Key_cedilla, Key_s, 0x015F,
Key_cedilla, Key_t, 0x0163,
Key_breve, Key_G, 0x011E,
Key_breve, Key_g, 0x011F,
0x05B4, Key_hebrew_yod, 0xFB1D,
0x05B7, 0x05F2, 0xFB1F,
0x05B7, Key_hebrew_aleph, 0xFB2E,
0x05B8, Key_hebrew_aleph, 0xFB2F,
0x05B9, Key_hebrew_waw, 0xFB4B,
0x05BC, Key_hebrew_aleph, 0xFB30,
0x05BC, Key_hebrew_beth, 0xFB31,
0x05BC, Key_hebrew_gimmel, 0xFB32,
0x05BC, Key_hebrew_daleth, 0xFB33,
0x05BC, Key_hebrew_he, 0xFB34,
0x05BC, Key_hebrew_waw, 0xFB35,
0x05BC, Key_hebrew_zayin, 0xFB36,
0x05BC, Key_hebrew_teth, 0xFB38,
0x05BC, Key_hebrew_yod, 0xFB39,
0x05BC, Key_hebrew_finalkaph, 0xFB3A,
0x05BC, Key_hebrew_kaph, 0xFB3B,
0x05BC, Key_hebrew_lamed, 0xFB3C,
0x05BC, Key_hebrew_mem, 0xFB3E,
0x05BC, Key_hebrew_nun, 0xFB40,
0x05BC, Key_hebrew_samekh, 0xFB41,
0x05BC, Key_hebrew_finalpe, 0xFB43,
0x05BC, Key_hebrew_pe, 0xFB44,
0x05BC, Key_hebrew_zadi, 0xFB46,
0x05BC, Key_hebrew_qoph, 0xFB47,
0x05BC, Key_hebrew_resh, 0xFB48,
0x05BC, Key_hebrew_shin, 0xFB49,
0x05BC, Key_hebrew_taw, 0xFB4A,
0x05BF, Key_hebrew_beth, 0xFB4C,
0x05BF, Key_hebrew_kaph, 0xFB4D,
0x05BF, Key_hebrew_pe, 0xFB4E,
0x05C1, Key_hebrew_shin, 0xFB2A,
0x05C1, 0xFB49, 0xFB2C,
0x05C2, Key_hebrew_shin, 0xFB2B,
0x05C2, 0xFB49, 0xFB2D,
0x0653, Key_Arabic_alef, 0x0622,
0x0654, Key_Arabic_alef, 0x0623,
0x0654, Key_Arabic_waw, 0x0624,
0x0654, Key_Arabic_yeh, 0x0626,
0x0654, 0x06C1, 0x06C2,
0x0654, 0x06D2, 0x06D3,
0x0654, 0x06D5, 0x06C0,
0x0655, Key_Arabic_alef, 0x0625,
Key_Cyrillic_pe, Key_Cyrillic_a, 0x00A7,
Key_Cyrillic_IE, Key_equal, 0x20AC,
Key_Cyrillic_EN, Key_Cyrillic_o, 0x2116,
Key_Cyrillic_EN, Key_Cyrillic_O, 0x2116,
Key_Cyrillic_ES, Key_equal, 0x20AC,
Key_Greek_ALPHA, Key_apostrophe, 0x0386,
Key_Greek_EPSILON, Key_apostrophe, 0x0388,
Key_Greek_ETA, Key_apostrophe, 0x0389,
Key_Greek_IOTA, Key_quotedbl, 0x03AA,
Key_Greek_IOTA, Key_apostrophe, 0x038A,
Key_Greek_OMICRON, Key_apostrophe, 0x038C,
Key_Greek_UPSILON, Key_quotedbl, 0x03AB,
Key_Greek_UPSILON, Key_apostrophe, 0x038E,
Key_Greek_OMEGA, Key_apostrophe, 0x038F,
Key_Greek_alpha, Key_apostrophe, 0x03AC,
Key_Greek_epsilon, Key_apostrophe, 0x03AD,
Key_Greek_eta, Key_apostrophe, 0x03AE,
Key_Greek_iota, Key_quotedbl, 0x03CA,
Key_Greek_iota, Key_apostrophe, 0x03AF,
Key_Greek_iota, Key_Greek_alphaaccent, 0x1FB4,
Key_Greek_iota, Key_Greek_etaaccent, 0x1FC4,
Key_Greek_iota, Key_Greek_omegaaccent, 0x1FF4,
Key_Greek_iota, Key_Greek_ALPHA, 0x1FBC,
Key_Greek_iota, Key_Greek_ETA, 0x1FCC,
Key_Greek_iota, Key_Greek_OMEGA, 0x1FFC,
Key_Greek_iota, Key_Greek_alpha, 0x1FB3,
Key_Greek_iota, Key_Greek_eta, 0x1FC3,
Key_Greek_iota, Key_Greek_omega, 0x1FF3,
Key_Greek_iota, 0x1F00, 0x1F80,
Key_Greek_iota, 0x1F01, 0x1F81,
Key_Greek_iota, 0x1F02, 0x1F82,
Key_Greek_iota, 0x1F03, 0x1F83,
Key_Greek_iota, 0x1F04, 0x1F84,
Key_Greek_iota, 0x1F05, 0x1F85,
Key_Greek_iota, 0x1F06, 0x1F86,
Key_Greek_iota, 0x1F07, 0x1F87,
Key_Greek_iota, 0x1F08, 0x1F88,
Key_Greek_iota, 0x1F09, 0x1F89,
Key_Greek_iota, 0x1F0A, 0x1F8A,
Key_Greek_iota, 0x1F0B, 0x1F8B,
Key_Greek_iota, 0x1F0C, 0x1F8C,
Key_Greek_iota, 0x1F0D, 0x1F8D,
Key_Greek_iota, 0x1F0E, 0x1F8E,
Key_Greek_iota, 0x1F0F, 0x1F8F,
Key_Greek_iota, 0x1F20, 0x1F90,
Key_Greek_iota, 0x1F21, 0x1F91,
Key_Greek_iota, 0x1F22, 0x1F92,
Key_Greek_iota, 0x1F23, 0x1F93,
Key_Greek_iota, 0x1F24, 0x1F94,
Key_Greek_iota, 0x1F25, 0x1F95,
Key_Greek_iota, 0x1F26, 0x1F96,
Key_Greek_iota, 0x1F27, 0x1F97,
Key_Greek_iota, 0x1F28, 0x1F98,
Key_Greek_iota, 0x1F29, 0x1F99,
Key_Greek_iota, 0x1F2A, 0x1F9A,
Key_Greek_iota, 0x1F2B, 0x1F9B,
Key_Greek_iota, 0x1F2C, 0x1F9C,
Key_Greek_iota, 0x1F2D, 0x1F9D,
Key_Greek_iota, 0x1F2E, 0x1F9E,
Key_Greek_iota, 0x1F2F, 0x1F9F,
Key_Greek_iota, 0x1F60, 0x1FA0,
Key_Greek_iota, 0x1F61, 0x1FA1,
Key_Greek_iota, 0x1F62, 0x1FA2,
Key_Greek_iota, 0x1F63, 0x1FA3,
Key_Greek_iota, 0x1F64, 0x1FA4,
Key_Greek_iota, 0x1F65, 0x1FA5,
Key_Greek_iota, 0x1F66, 0x1FA6,
Key_Greek_iota, 0x1F67, 0x1FA7,
Key_Greek_iota, 0x1F68, 0x1FA8,
Key_Greek_iota, 0x1F69, 0x1FA9,
Key_Greek_iota, 0x1F6A, 0x1FAA,
Key_Greek_iota, 0x1F6B, 0x1FAB,
Key_Greek_iota, 0x1F6C, 0x1FAC,
Key_Greek_iota, 0x1F6D, 0x1FAD,
Key_Greek_iota, 0x1F6E, 0x1FAE,
Key_Greek_iota, 0x1F6F, 0x1FAF,
Key_Greek_iota, 0x1F70, 0x1FB2,
Key_Greek_iota, 0x1F74, 0x1FC2,
Key_Greek_iota, 0x1F7C, 0x1FF2,
Key_Greek_iota, 0x1FB6, 0x1FB7,
Key_Greek_iota, 0x1FC6, 0x1FC7,
Key_Greek_iota, 0x1FF6, 0x1FF7,
Key_Greek_omicron, Key_apostrophe, 0x03CC,
Key_Greek_upsilon, Key_quotedbl, 0x03CB,
Key_Greek_upsilon, Key_apostrophe, 0x03CD,
Key_Greek_omega, Key_apostrophe, 0x03CE,
Key_lessthanequal, 0x0338, 0x2270,
Key_greaterthanequal, 0x0338, 0x2271,
Key_approximate, 0x0338, 0x2247,
Key_identical, 0x0338, 0x2262,
Key_includedin, 0x0338, 0x2284,
Key_includes, 0x0338, 0x2285,
0x093C, 0x0915, 0x0958,
0x093C, 0x0916, 0x0959,
0x093C, 0x0917, 0x095A,
0x093C, 0x091C, 0x095B,
0x093C, 0x0921, 0x095C,
0x093C, 0x0922, 0x095D,
0x093C, 0x0928, 0x0929,
0x093C, 0x092B, 0x095E,
0x093C, 0x092F, 0x095F,
0x093C, 0x0930, 0x0931,
0x093C, 0x0933, 0x0934,
0x09BC, 0x09A1, 0x09DC,
0x09BC, 0x09A2, 0x09DD,
0x09BC, 0x09AF, 0x09DF,
0x09C7, 0x09BE, 0x09CB,
0x09C7, 0x09D7, 0x09CC,
0x0A3C, 0x0A16, 0x0A59,
0x0A3C, 0x0A17, 0x0A5A,
0x0A3C, 0x0A1C, 0x0A5B,
0x0A3C, 0x0A2B, 0x0A5E,
0x0A3C, 0x0A32, 0x0A33,
0x0A3C, 0x0A38, 0x0A36,
0x0B3C, 0x0B21, 0x0B5C,
0x0B3C, 0x0B22, 0x0B5D,
0x0B47, 0x0B3E, 0x0B4B,
0x0B47, 0x0B56, 0x0B48,
0x0B47, 0x0B57, 0x0B4C,
Key_leftcaret, 0x0338, 0x226E,
Key_rightcaret, 0x0338, 0x226F,
Key_underbar, Key_parenleft, 0x208D,
Key_underbar, Key_parenright, 0x208E,
Key_underbar, Key_plus, 0x208A,
Key_underbar, Key_0, 0x2080,
Key_underbar, Key_1, 0x2081,
Key_underbar, Key_2, 0x2082,
Key_underbar, Key_3, 0x2083,
Key_underbar, Key_4, 0x2084,
Key_underbar, Key_5, 0x2085,
Key_underbar, Key_6, 0x2086,
Key_underbar, Key_7, 0x2087,
Key_underbar, Key_8, 0x2088,
Key_underbar, Key_9, 0x2089,
Key_underbar, Key_equal, 0x208C,
0x0BC6, 0x0BBE, 0x0BCA,
0x0BC6, 0x0BD7, 0x0BCC,
Key_underbar, 0x2212, 0x208B,
Key_underbar, Key_KP_Space, 0x2082,
Key_underbar, Key_KP_Add, 0x208A,
Key_underbar, Key_KP_0, 0x2080,
Key_underbar, Key_KP_1, 0x2081,
Key_underbar, Key_KP_2, 0x2082,
Key_underbar, Key_KP_3, 0x2083,
Key_underbar, Key_KP_4, 0x2084,
Key_underbar, Key_KP_5, 0x2085,
Key_underbar, Key_KP_6, 0x2086,
Key_underbar, Key_KP_7, 0x2087,
Key_underbar, Key_KP_8, 0x2088,
Key_underbar, Key_KP_9, 0x2089,
Key_underbar, Key_KP_Equal, 0x208C,
0x0BC7, 0x0BBE, 0x0BCB,
0x0BD7, 0x0B92, 0x0B94,
Key_rightshoe, 0x0338, 0x2285,
Key_leftshoe, 0x0338, 0x2284,
Key_righttack, 0x0338, 0x22AC,
0x0C46, 0x0C56, 0x0C48,
0x0CBF, 0x0CD5, 0x0CC0,
0x0CC6, 0x0CC2, 0x0CCA,
0x0CC6, 0x0CD5, 0x0CC7,
0x0CC6, 0x0CD6, 0x0CC8,
0x0CCA, 0x0CD5, 0x0CCB,
0x0D46, 0x0D3E, 0x0D4A,
0x0D46, 0x0D57, 0x0D4C,
0x0D47, 0x0D3E, 0x0D4B,
0x0DD9, 0x0DCA, 0x0DDA,
0x0DD9, 0x0DCF, 0x0DDC,
0x0DD9, 0x0DDF, 0x0DDE,
0x0DDC, 0x0DCA, 0x0DDD,
0x0F71, 0x0F72, 0x0F73,
0x0F71, 0x0F74, 0x0F75,
0x0F71, 0x0F80, 0x0F81,
0x0F90, 0x0FB5, 0x0FB9,
0x0F92, 0x0FB7, 0x0F93,
0x0F9C, 0x0FB7, 0x0F9D,
0x0FA1, 0x0FB7, 0x0FA2,
0x0FA6, 0x0FB7, 0x0FA7,
0x0FAB, 0x0FB7, 0x0FAC,
0x0FB2, 0x0F80, 0x0F76,
0x0FB3, 0x0F80, 0x0F78,
0x0FB5, 0x0F40, 0x0F69,
0x0FB7, 0x0F42, 0x0F43,
0x0FB7, 0x0F4C, 0x0F4D,
0x0FB7, 0x0F51, 0x0F52,
0x0FB7, 0x0F56, 0x0F57,
0x0FB7, 0x0F5B, 0x0F5C,
0x102E, 0x1025, 0x1026,
0x1100, 0x1100, 0x1101,
0x1102, 0x1100, 0x1113,
0x1102, 0x1102, 0x1114,
0x1102, 0x1103, 0x1115,
0x1102, 0x1107, 0x1116,
0x1103, 0x1100, 0x1117,
0x1103, 0x1103, 0x1104,
0x1105, 0x1102, 0x1118,
0x1105, 0x1105, 0x1119,
0x1105, 0x110B, 0x111B,
0x1105, 0x1112, 0x111A,
0x1106, 0x1107, 0x111C,
0x1106, 0x110B, 0x111D,
0x1107, 0x1100, 0x111E,
0x1107, 0x1102, 0x111F,
0x1107, 0x1103, 0x1120,
0x1107, 0x1107, 0x1108,
0x1107, 0x1109, 0x1121,
0x1107, 0x110A, 0x1125,
0x1107, 0x110B, 0x112B,
0x1107, 0x110C, 0x1127,
0x1107, 0x110E, 0x1128,
0x1107, 0x1110, 0x1129,
0x1107, 0x1111, 0x112A,
0x1107, 0x112B, 0x112C,
0x1107, 0x112D, 0x1122,
0x1107, 0x112F, 0x1123,
0x1107, 0x1132, 0x1124,
0x1107, 0x1136, 0x1126,
0x1108, 0x110B, 0x112C,
0x1109, 0x1100, 0x112D,
0x1109, 0x1102, 0x112E,
0x1109, 0x1103, 0x112F,
0x1109, 0x1105, 0x1130,
0x1109, 0x1106, 0x1131,
0x1109, 0x1107, 0x1132,
0x1109, 0x1109, 0x110A,
0x1109, 0x110A, 0x1134,
0x1109, 0x110B, 0x1135,
0x1109, 0x110C, 0x1136,
0x1109, 0x110E, 0x1137,
0x1109, 0x110F, 0x1138,
0x1109, 0x1110, 0x1139,
0x1109, 0x1111, 0x113A,
0x1109, 0x1112, 0x113B,
0x1109, 0x111E, 0x1133,
0x110A, 0x1109, 0x1134,
0x110B, 0x1100, 0x1141,
0x110B, 0x1103, 0x1142,
0x110B, 0x1106, 0x1143,
0x110B, 0x1107, 0x1144,
0x110B, 0x1109, 0x1145,
0x110B, 0x110B, 0x1147,
0x110B, 0x110C, 0x1148,
0x110B, 0x110E, 0x1149,
0x110B, 0x1110, 0x114A,
0x110B, 0x1111, 0x114B,
0x110B, 0x1140, 0x1146,
0x110C, 0x110B, 0x114D,
0x110C, 0x110C, 0x110D,
0x110E, 0x110F, 0x1152,
0x110E, 0x1112, 0x1153,
0x1111, 0x1107, 0x1156,
0x1111, 0x110B, 0x1157,
0x1112, 0x1112, 0x1158,
0x1121, 0x1100, 0x1122,
0x1121, 0x1103, 0x1123,
0x1121, 0x1107, 0x1124,
0x1121, 0x1109, 0x1125,
0x1121, 0x110C, 0x1126,
0x1132, 0x1100, 0x1133,
0x113C, 0x113C, 0x113D,
0x113E, 0x113E, 0x113F,
0x114E, 0x114E, 0x114F,
0x1150, 0x1150, 0x1151,
0x1161, 0x1169, 0x1176,
0x1161, 0x116E, 0x1177,
0x1161, 0x1175, 0x1162,
0x1163, 0x1169, 0x1178,
0x1163, 0x116D, 0x1179,
0x1163, 0x1175, 0x1164,
0x1165, 0x1169, 0x117A,
0x1165, 0x116E, 0x117B,
0x1165, 0x1173, 0x117C,
0x1165, 0x1175, 0x1166,
0x1167, 0x1169, 0x117D,
0x1167, 0x116E, 0x117E,
0x1167, 0x1175, 0x1168,
0x1169, 0x1161, 0x116A,
0x1169, 0x1162, 0x116B,
0x1169, 0x1165, 0x117F,
0x1169, 0x1166, 0x1180,
0x1169, 0x1168, 0x1181,
0x1169, 0x1169, 0x1182,
0x1169, 0x116E, 0x1183,
0x1169, 0x1175, 0x116C,
0x116A, 0x1175, 0x116B,
0x116D, 0x1163, 0x1184,
0x116D, 0x1164, 0x1185,
0x116D, 0x1167, 0x1186,
0x116D, 0x1169, 0x1187,
0x116D, 0x1175, 0x1188,
0x116E, 0x1161, 0x1189,
0x116E, 0x1162, 0x118A,
0x116E, 0x1165, 0x116F,
0x116E, 0x1166, 0x1170,
0x116E, 0x1168, 0x118C,
0x116E, 0x116E, 0x118D,
0x116E, 0x1175, 0x1171,
0x116E, 0x117C, 0x118B,
0x116F, 0x1173, 0x118B,
0x116F, 0x1175, 0x1170,
0x1172, 0x1161, 0x118E,
0x1172, 0x1165, 0x118F,
0x1172, 0x1166, 0x1190,
0x1172, 0x1167, 0x1191,
0x1172, 0x1168, 0x1192,
0x1172, 0x116E, 0x1193,
0x1172, 0x1175, 0x1194,
0x1173, 0x116E, 0x1195,
0x1173, 0x1173, 0x1196,
0x1173, 0x1175, 0x1174,
0x1174, 0x116E, 0x1197,
0x1175, 0x1161, 0x1198,
0x1175, 0x1163, 0x1199,
0x1175, 0x1169, 0x119A,
0x1175, 0x116E, 0x119B,
0x1175, 0x1173, 0x119C,
0x1175, 0x119E, 0x119D,
0x119E, 0x1165, 0x119F,
0x119E, 0x116E, 0x11A0,
0x119E, 0x1175, 0x11A1,
0x119E, 0x119E, 0x11A2,
0x11A8, 0x11A8, 0x11A9,
0x11A8, 0x11AF, 0x11C3,
0x11A8, 0x11BA, 0x11AA,
0x11A8, 0x11E7, 0x11C4,
0x11AA, 0x11A8, 0x11C4,
0x11AB, 0x11A8, 0x11C5,
0x11AB, 0x11AE, 0x11C6,
0x11AB, 0x11BA, 0x11C7,
0x11AB, 0x11BD, 0x11AC,
0x11AB, 0x11C0, 0x11C9,
0x11AB, 0x11C2, 0x11AD,
0x11AB, 0x11EB, 0x11C8,
0x11AE, 0x11A8, 0x11CA,
0x11AE, 0x11AF, 0x11CB,
0x11AF, 0x11A8, 0x11B0,
0x11AF, 0x11AA, 0x11CC,
0x11AF, 0x11AB, 0x11CD,
0x11AF, 0x11AE, 0x11CE,
0x11AF, 0x11AF, 0x11D0,
0x11AF, 0x11B7, 0x11B1,
0x11AF, 0x11B8, 0x11B2,
0x11AF, 0x11B9, 0x11D3,
0x11AF, 0x11BA, 0x11B3,
0x11AF, 0x11BB, 0x11D6,
0x11AF, 0x11BF, 0x11D8,
0x11AF, 0x11C0, 0x11B4,
0x11AF, 0x11C1, 0x11B5,
0x11AF, 0x11C2, 0x11B6,
0x11AF, 0x11DA, 0x11D1,
0x11AF, 0x11DD, 0x11D2,
0x11AF, 0x11E5, 0x11D4,
0x11AF, 0x11E6, 0x11D5,
0x11AF, 0x11EB, 0x11D7,
0x11AF, 0x11F9, 0x11D9,
0x11B0, 0x11BA, 0x11CC,
0x11B1, 0x11A8, 0x11D1,
0x11B1, 0x11BA, 0x11D2,
0x11B2, 0x11BA, 0x11D3,
0x11B2, 0x11BC, 0x11D5,
0x11B2, 0x11C2, 0x11D4,
0x11B3, 0x11BA, 0x11D6,
0x11B7, 0x11A8, 0x11DA,
0x11B7, 0x11AF, 0x11DB,
0x11B7, 0x11B8, 0x11DC,
0x11B7, 0x11BA, 0x11DD,
0x11B7, 0x11BB, 0x11DE,
0x11B7, 0x11BC, 0x11E2,
0x11B7, 0x11BE, 0x11E0,
0x11B7, 0x11C2, 0x11E1,
0x11B7, 0x11EB, 0x11DF,
0x11B8, 0x11AF, 0x11E3,
0x11B8, 0x11BA, 0x11B9,
0x11B8, 0x11BC, 0x11E6,
0x11B8, 0x11C1, 0x11E4,
0x11B8, 0x11C2, 0x11E5,
0x11BA, 0x11A8, 0x11E7,
0x11BA, 0x11AE, 0x11E8,
0x11BA, 0x11AF, 0x11E9,
0x11BA, 0x11B8, 0x11EA,
0x11BA, 0x11BA, 0x11BB,
0x11BC, 0x11A8, 0x11EC,
0x11BC, 0x11A9, 0x11ED,
0x11BC, 0x11BC, 0x11EE,
0x11BC, 0x11BF, 0x11EF,
0x11C1, 0x11B8, 0x11F3,
0x11C1, 0x11BC, 0x11F4,
0x11C2, 0x11AB, 0x11F5,
0x11C2, 0x11AF, 0x11F6,
0x11C2, 0x11B7, 0x11F7,
0x11C2, 0x11B8, 0x11F8,
0x11CE, 0x11C2, 0x11CF,
0x11DD, 0x11BA, 0x11DE,
0x11EC, 0x11A8, 0x11ED,
0x11F0, 0x11BA, 0x11F1,
0x11F0, 0x11EB, 0x11F2,
0x1FBF, Key_apostrophe, 0x1FCE,
0x1FBF, Key_grave, 0x1FCD,
0x1FBF, Key_asciitilde, 0x1FCF,
0x1FBF, Key_acute, 0x1FCE,
0x1FBF, Key_dead_grave, 0x1FCD,
0x1FBF, Key_dead_acute, 0x1FCE,
0x1FBF, Key_dead_tilde, 0x1FCF,
0x1FFE, Key_apostrophe, 0x1FDE,
0x1FFE, Key_grave, 0x1FDD,
0x1FFE, Key_asciitilde, 0x1FDF,
0x1FFE, Key_acute, 0x1FDE,
0x1FFE, Key_dead_grave, 0x1FDD,
0x1FFE, Key_dead_acute, 0x1FDE,
0x1FFE, Key_dead_tilde, 0x1FDF,
0x2203, 0x0338, 0x2204,
0x2208, 0x0338, 0x2209,
0x220B, 0x0338, 0x220C,
0x2223, 0x0338, 0x2224,
0x2225, 0x0338, 0x2226,
0x223C, 0x0338, 0x2241,
0x2243, 0x0338, 0x2244,
0x2248, 0x0338, 0x2249,
0x224D, 0x0338, 0x226D,
0x2272, 0x0338, 0x2274,
0x2273, 0x0338, 0x2275,
0x2276, 0x0338, 0x2278,
0x2277, 0x0338, 0x2279,
0x227A, 0x0338, 0x2280,
0x227B, 0x0338, 0x2281,
0x227C, 0x0338, 0x22E0,
0x227D, 0x0338, 0x22E1,
0x2286, 0x0338, 0x2288,
0x2287, 0x0338, 0x2289,
0x2291, 0x0338, 0x22E2,
0x2292, 0x0338, 0x22E3,
0x22A8, 0x0338, 0x22AD,
0x22A9, 0x0338, 0x22AE,
0x22AB, 0x0338, 0x22AF,
0x22B2, 0x0338, 0x22EA,
0x22B3, 0x0338, 0x22EB,
0x22B4, 0x0338, 0x22EC,
0x22B5, 0x0338, 0x22ED,
0x2ADD, 0x0338, 0x2ADC,
Key_KP_Divide, Key_D, 0x0110,
Key_KP_Divide, Key_G, 0x01E4,
Key_KP_Divide, Key_H, 0x0126,
Key_KP_Divide, Key_I, 0x0197,
Key_KP_Divide, Key_L, 0x0141,
Key_KP_Divide, Key_O, 0x00D8,
Key_KP_Divide, Key_T, 0x0166,
Key_KP_Divide, Key_Z, 0x01B5,
Key_KP_Divide, Key_b, 0x0180,
Key_KP_Divide, Key_d, 0x0111,
Key_KP_Divide, Key_g, 0x01E5,
Key_KP_Divide, Key_h, 0x0127,
Key_KP_Divide, Key_i, 0x0268,
Key_KP_Divide, Key_l, 0x0142,
Key_KP_Divide, Key_o, 0x00F8,
Key_KP_Divide, Key_t, 0x0167,
Key_KP_Divide, Key_z, 0x01B6,
Key_KP_Divide, 0x0294, 0x02A1,
Key_KP_Divide, 0x04AE, 0x04B0,
Key_KP_Divide, 0x04AF, 0x04B1,
Key_KP_Divide, Key_Cyrillic_ghe, 0x0493,
Key_KP_Divide, Key_Cyrillic_ka, 0x049F,
Key_KP_Divide, Key_Cyrillic_GHE, 0x0492,
Key_KP_Divide, Key_Cyrillic_KA, 0x049E,
Key_KP_Divide, Key_leftarrow, 0x219A,
Key_KP_Divide, Key_rightarrow, 0x219B,
Key_KP_Divide, 0x2194, 0x21AE,
Key_KP_Equal, 0x0338, 0x2260,
Key_exclam, Key_plus, Key_O, 0x1EE2,
Key_exclam, Key_plus, Key_U, 0x1EF0,
Key_exclam, Key_plus, Key_o, 0x1EE3,
Key_exclam, Key_plus, Key_u, 0x1EF1,
Key_exclam, Key_dead_horn, Key_O, 0x1EE2,
Key_exclam, Key_dead_horn, Key_U, 0x1EF0,
Key_exclam, Key_dead_horn, Key_o, 0x1EE3,
Key_exclam, Key_dead_horn, Key_u, 0x1EF1,
Key_quotedbl, Key_apostrophe, Key_space, 0x0385,
Key_quotedbl, Key_apostrophe, Key_Greek_iota, 0x0390,
Key_quotedbl, Key_apostrophe, Key_Greek_upsilon, 0x03B0,
Key_quotedbl, Key_underscore, Key_U, 0x1E7A,
Key_quotedbl, Key_underscore, Key_u, 0x1E7B,
Key_quotedbl, Key_asciitilde, Key_O, 0x1E4E,
Key_quotedbl, Key_asciitilde, Key_o, 0x1E4F,
Key_quotedbl, Key_macron, Key_U, 0x1E7A,
Key_quotedbl, Key_macron, Key_u, 0x1E7B,
Key_quotedbl, Key_dead_tilde, Key_O, 0x1E4E,
Key_quotedbl, Key_dead_tilde, Key_o, 0x1E4F,
Key_quotedbl, Key_dead_macron, Key_U, 0x1E7A,
Key_quotedbl, Key_dead_macron, Key_u, 0x1E7B,
Key_apostrophe, Key_quotedbl, Key_space, 0x0385,
Key_apostrophe, Key_quotedbl, Key_I, 0x1E2E,
Key_apostrophe, Key_quotedbl, Key_U, 0x01D7,
Key_apostrophe, Key_quotedbl, Key_i, 0x1E2F,
Key_apostrophe, Key_quotedbl, Key_u, 0x01D8,
Key_apostrophe, Key_quotedbl, Key_Greek_iota, 0x0390,
Key_apostrophe, Key_quotedbl, Key_Greek_upsilon, 0x03B0,
Key_apostrophe, Key_parenleft, Key_Greek_ALPHA, 0x1F0D,
Key_apostrophe, Key_parenleft, Key_Greek_EPSILON, 0x1F1D,
Key_apostrophe, Key_parenleft, Key_Greek_ETA, 0x1F2D,
Key_apostrophe, Key_parenleft, Key_Greek_IOTA, 0x1F3D,
Key_apostrophe, Key_parenleft, Key_Greek_OMICRON, 0x1F4D,
Key_apostrophe, Key_parenleft, Key_Greek_UPSILON, 0x1F5D,
Key_apostrophe, Key_parenleft, Key_Greek_OMEGA, 0x1F6D,
Key_apostrophe, Key_parenleft, Key_Greek_alpha, 0x1F05,
Key_apostrophe, Key_parenleft, Key_Greek_epsilon, 0x1F15,
Key_apostrophe, Key_parenleft, Key_Greek_eta, 0x1F25,
Key_apostrophe, Key_parenleft, Key_Greek_iota, 0x1F35,
Key_apostrophe, Key_parenleft, Key_Greek_omicron, 0x1F45,
Key_apostrophe, Key_parenleft, Key_Greek_upsilon, 0x1F55,
Key_apostrophe, Key_parenleft, Key_Greek_omega, 0x1F65,
Key_apostrophe, Key_parenright, Key_Greek_ALPHA, 0x1F0C,
Key_apostrophe, Key_parenright, Key_Greek_EPSILON, 0x1F1C,
Key_apostrophe, Key_parenright, Key_Greek_ETA, 0x1F2C,
Key_apostrophe, Key_parenright, Key_Greek_IOTA, 0x1F3C,
Key_apostrophe, Key_parenright, Key_Greek_OMICRON, 0x1F4C,
Key_apostrophe, Key_parenright, Key_Greek_OMEGA, 0x1F6C,
Key_apostrophe, Key_parenright, Key_Greek_alpha, 0x1F04,
Key_apostrophe, Key_parenright, Key_Greek_epsilon, 0x1F14,
Key_apostrophe, Key_parenright, Key_Greek_eta, 0x1F24,
Key_apostrophe, Key_parenright, Key_Greek_iota, 0x1F34,
Key_apostrophe, Key_parenright, Key_Greek_omicron, 0x1F44,
Key_apostrophe, Key_parenright, Key_Greek_upsilon, 0x1F54,
Key_apostrophe, Key_parenright, Key_Greek_omega, 0x1F64,
Key_apostrophe, Key_plus, Key_O, 0x1EDA,
Key_apostrophe, Key_plus, Key_U, 0x1EE8,
Key_apostrophe, Key_plus, Key_o, 0x1EDB,
Key_apostrophe, Key_plus, Key_u, 0x1EE9,
Key_apostrophe, Key_slash, Key_O, 0x01FE,
Key_apostrophe, Key_slash, Key_o, 0x01FF,
Key_apostrophe, Key_asciicircum, Key_A, 0x1EA4,
Key_apostrophe, Key_asciicircum, Key_E, 0x1EBE,
Key_apostrophe, Key_asciicircum, Key_O, 0x1ED0,
Key_apostrophe, Key_asciicircum, Key_a, 0x1EA5,
Key_apostrophe, Key_asciicircum, Key_e, 0x1EBF,
Key_apostrophe, Key_asciicircum, Key_o, 0x1ED1,
Key_apostrophe, Key_underscore, Key_E, 0x1E16,
Key_apostrophe, Key_underscore, Key_O, 0x1E52,
Key_apostrophe, Key_underscore, Key_e, 0x1E17,
Key_apostrophe, Key_underscore, Key_o, 0x1E53,
Key_apostrophe, Key_b, Key_A, 0x1EAE,
Key_apostrophe, Key_b, Key_a, 0x1EAF,
Key_apostrophe, Key_asciitilde, Key_O, 0x1E4C,
Key_apostrophe, Key_asciitilde, Key_U, 0x1E78,
Key_apostrophe, Key_asciitilde, Key_o, 0x1E4D,
Key_apostrophe, Key_asciitilde, Key_u, 0x1E79,
Key_apostrophe, Key_macron, Key_E, 0x1E16,
Key_apostrophe, Key_macron, Key_O, 0x1E52,
Key_apostrophe, Key_macron, Key_e, 0x1E17,
Key_apostrophe, Key_macron, Key_o, 0x1E53,
Key_apostrophe, Key_cedilla, Key_C, 0x1E08,
Key_apostrophe, Key_cedilla, Key_c, 0x1E09,
Key_apostrophe, Key_dead_circumflex, Key_A, 0x1EA4,
Key_apostrophe, Key_dead_circumflex, Key_E, 0x1EBE,
Key_apostrophe, Key_dead_circumflex, Key_O, 0x1ED0,
Key_apostrophe, Key_dead_circumflex, Key_a, 0x1EA5,
Key_apostrophe, Key_dead_circumflex, Key_e, 0x1EBF,
Key_apostrophe, Key_dead_circumflex, Key_o, 0x1ED1,
Key_apostrophe, Key_dead_tilde, Key_O, 0x1E4C,
Key_apostrophe, Key_dead_tilde, Key_U, 0x1E78,
Key_apostrophe, Key_dead_tilde, Key_o, 0x1E4D,
Key_apostrophe, Key_dead_tilde, Key_u, 0x1E79,
Key_apostrophe, Key_dead_macron, Key_E, 0x1E16,
Key_apostrophe, Key_dead_macron, Key_O, 0x1E52,
Key_apostrophe, Key_dead_macron, Key_e, 0x1E17,
Key_apostrophe, Key_dead_macron, Key_o, 0x1E53,
Key_apostrophe, Key_dead_breve, Key_A, 0x1EAE,
Key_apostrophe, Key_dead_breve, Key_a, 0x1EAF,
Key_apostrophe, Key_dead_diaeresis, Key_I, 0x1E2E,
Key_apostrophe, Key_dead_diaeresis, Key_U, 0x01D7,
Key_apostrophe, Key_dead_diaeresis, Key_i, 0x1E2F,
Key_apostrophe, Key_dead_diaeresis, Key_u, 0x01D8,
Key_apostrophe, Key_dead_diaeresis, Key_Greek_iota, 0x0390,
Key_apostrophe, Key_dead_diaeresis, Key_Greek_upsilon, 0x03B0,
Key_apostrophe, Key_dead_abovering, Key_A, 0x01FA,
Key_apostrophe, Key_dead_abovering, Key_a, 0x01FB,
Key_apostrophe, Key_dead_cedilla, Key_C, 0x1E08,
Key_apostrophe, Key_dead_cedilla, Key_c, 0x1E09,
Key_apostrophe, Key_dead_horn, Key_O, 0x1EDA,
Key_apostrophe, Key_dead_horn, Key_U, 0x1EE8,
Key_apostrophe, Key_dead_horn, Key_o, 0x1EDB,
Key_apostrophe, Key_dead_horn, Key_u, 0x1EE9,
Key_apostrophe, Key_dead_psili, Key_Greek_ALPHA, 0x1F0C,
Key_apostrophe, Key_dead_psili, Key_Greek_EPSILON, 0x1F1C,
Key_apostrophe, Key_dead_psili, Key_Greek_ETA, 0x1F2C,
Key_apostrophe, Key_dead_psili, Key_Greek_IOTA, 0x1F3C,
Key_apostrophe, Key_dead_psili, Key_Greek_OMICRON, 0x1F4C,
Key_apostrophe, Key_dead_psili, Key_Greek_OMEGA, 0x1F6C,
Key_apostrophe, Key_dead_psili, Key_Greek_alpha, 0x1F04,
Key_apostrophe, Key_dead_psili, Key_Greek_epsilon, 0x1F14,
Key_apostrophe, Key_dead_psili, Key_Greek_eta, 0x1F24,
Key_apostrophe, Key_dead_psili, Key_Greek_iota, 0x1F34,
Key_apostrophe, Key_dead_psili, Key_Greek_omicron, 0x1F44,
Key_apostrophe, Key_dead_psili, Key_Greek_upsilon, 0x1F54,
Key_apostrophe, Key_dead_psili, Key_Greek_omega, 0x1F64,
Key_apostrophe, Key_dead_dasia, Key_Greek_ALPHA, 0x1F0D,
Key_apostrophe, Key_dead_dasia, Key_Greek_EPSILON, 0x1F1D,
Key_apostrophe, Key_dead_dasia, Key_Greek_ETA, 0x1F2D,
Key_apostrophe, Key_dead_dasia, Key_Greek_IOTA, 0x1F3D,
Key_apostrophe, Key_dead_dasia, Key_Greek_OMICRON, 0x1F4D,
Key_apostrophe, Key_dead_dasia, Key_Greek_UPSILON, 0x1F5D,
Key_apostrophe, Key_dead_dasia, Key_Greek_OMEGA, 0x1F6D,
Key_apostrophe, Key_dead_dasia, Key_Greek_alpha, 0x1F05,
Key_apostrophe, Key_dead_dasia, Key_Greek_epsilon, 0x1F15,
Key_apostrophe, Key_dead_dasia, Key_Greek_eta, 0x1F25,
Key_apostrophe, Key_dead_dasia, Key_Greek_iota, 0x1F35,
Key_apostrophe, Key_dead_dasia, Key_Greek_omicron, 0x1F45,
Key_apostrophe, Key_dead_dasia, Key_Greek_upsilon, 0x1F55,
Key_apostrophe, Key_dead_dasia, Key_Greek_omega, 0x1F65,
Key_apostrophe, Key_KP_Divide, Key_O, 0x01FE,
Key_apostrophe, Key_KP_Divide, Key_o, 0x01FF,
Key_parenleft, Key_0, Key_parenright, 0x24EA,
Key_parenleft, Key_1, Key_parenright, 0x2460,
Key_parenleft, Key_2, Key_parenright, 0x2461,
Key_parenleft, Key_3, Key_parenright, 0x2462,
Key_parenleft, Key_4, Key_parenright, 0x2463,
Key_parenleft, Key_5, Key_parenright, 0x2464,
Key_parenleft, Key_6, Key_parenright, 0x2465,
Key_parenleft, Key_7, Key_parenright, 0x2466,
Key_parenleft, Key_8, Key_parenright, 0x2467,
Key_parenleft, Key_9, Key_parenright, 0x2468,
Key_parenleft, Key_A, Key_parenright, 0x24B6,
Key_parenleft, Key_B, Key_parenright, 0x24B7,
Key_parenleft, Key_C, Key_parenright, 0x24B8,
Key_parenleft, Key_D, Key_parenright, 0x24B9,
Key_parenleft, Key_E, Key_parenright, 0x24BA,
Key_parenleft, Key_F, Key_parenright, 0x24BB,
Key_parenleft, Key_G, Key_parenright, 0x24BC,
Key_parenleft, Key_H, Key_parenright, 0x24BD,
Key_parenleft, Key_I, Key_parenright, 0x24BE,
Key_parenleft, Key_J, Key_parenright, 0x24BF,
Key_parenleft, Key_K, Key_parenright, 0x24C0,
Key_parenleft, Key_L, Key_parenright, 0x24C1,
Key_parenleft, Key_M, Key_parenright, 0x24C2,
Key_parenleft, Key_N, Key_parenright, 0x24C3,
Key_parenleft, Key_O, Key_parenright, 0x24C4,
Key_parenleft, Key_P, Key_parenright, 0x24C5,
Key_parenleft, Key_Q, Key_parenright, 0x24C6,
Key_parenleft, Key_R, Key_parenright, 0x24C7,
Key_parenleft, Key_S, Key_parenright, 0x24C8,
Key_parenleft, Key_T, Key_parenright, 0x24C9,
Key_parenleft, Key_U, Key_parenright, 0x24CA,
Key_parenleft, Key_V, Key_parenright, 0x24CB,
Key_parenleft, Key_W, Key_parenright, 0x24CC,
Key_parenleft, Key_X, Key_parenright, 0x24CD,
Key_parenleft, Key_Y, Key_parenright, 0x24CE,
Key_parenleft, Key_Z, Key_parenright, 0x24CF,
Key_parenleft, Key_a, Key_parenright, 0x24D0,
Key_parenleft, Key_b, Key_parenright, 0x24D1,
Key_parenleft, Key_c, Key_parenright, 0x24D2,
Key_parenleft, Key_d, Key_parenright, 0x24D3,
Key_parenleft, Key_e, Key_parenright, 0x24D4,
Key_parenleft, Key_f, Key_parenright, 0x24D5,
Key_parenleft, Key_g, Key_parenright, 0x24D6,
Key_parenleft, Key_h, Key_parenright, 0x24D7,
Key_parenleft, Key_i, Key_parenright, 0x24D8,
Key_parenleft, Key_j, Key_parenright, 0x24D9,
Key_parenleft, Key_k, Key_parenright, 0x24DA,
Key_parenleft, Key_l, Key_parenright, 0x24DB,
Key_parenleft, Key_m, Key_parenright, 0x24DC,
Key_parenleft, Key_n, Key_parenright, 0x24DD,
Key_parenleft, Key_o, Key_parenright, 0x24DE,
Key_parenleft, Key_p, Key_parenright, 0x24DF,
Key_parenleft, Key_q, Key_parenright, 0x24E0,
Key_parenleft, Key_r, Key_parenright, 0x24E1,
Key_parenleft, Key_s, Key_parenright, 0x24E2,
Key_parenleft, Key_t, Key_parenright, 0x24E3,
Key_parenleft, Key_u, Key_parenright, 0x24E4,
Key_parenleft, Key_v, Key_parenright, 0x24E5,
Key_parenleft, Key_w, Key_parenright, 0x24E6,
Key_parenleft, Key_x, Key_parenright, 0x24E7,
Key_parenleft, Key_y, Key_parenright, 0x24E8,
Key_parenleft, Key_z, Key_parenright, 0x24E9,
Key_parenleft, Key_kana_WO, Key_parenright, 0x32FE,
Key_parenleft, Key_kana_A, Key_parenright, 0x32D0,
Key_parenleft, Key_kana_I, Key_parenright, 0x32D1,
Key_parenleft, Key_kana_U, Key_parenright, 0x32D2,
Key_parenleft, Key_kana_E, Key_parenright, 0x32D3,
Key_parenleft, Key_kana_O, Key_parenright, 0x32D4,
Key_parenleft, Key_kana_KA, Key_parenright, 0x32D5,
Key_parenleft, Key_kana_KI, Key_parenright, 0x32D6,
Key_parenleft, Key_kana_KU, Key_parenright, 0x32D7,
Key_parenleft, Key_kana_KE, Key_parenright, 0x32D8,
Key_parenleft, Key_kana_KO, Key_parenright, 0x32D9,
Key_parenleft, Key_kana_SA, Key_parenright, 0x32DA,
Key_parenleft, Key_kana_SHI, Key_parenright, 0x32DB,
Key_parenleft, Key_kana_SU, Key_parenright, 0x32DC,
Key_parenleft, Key_kana_SE, Key_parenright, 0x32DD,
Key_parenleft, Key_kana_SO, Key_parenright, 0x32DE,
Key_parenleft, Key_kana_TA, Key_parenright, 0x32DF,
Key_parenleft, Key_kana_CHI, Key_parenright, 0x32E0,
Key_parenleft, Key_kana_TSU, Key_parenright, 0x32E1,
Key_parenleft, Key_kana_TE, Key_parenright, 0x32E2,
Key_parenleft, Key_kana_TO, Key_parenright, 0x32E3,
Key_parenleft, Key_kana_NA, Key_parenright, 0x32E4,
Key_parenleft, Key_kana_NI, Key_parenright, 0x32E5,
Key_parenleft, Key_kana_NU, Key_parenright, 0x32E6,
Key_parenleft, Key_kana_NE, Key_parenright, 0x32E7,
Key_parenleft, Key_kana_NO, Key_parenright, 0x32E8,
Key_parenleft, Key_kana_HA, Key_parenright, 0x32E9,
Key_parenleft, Key_kana_HI, Key_parenright, 0x32EA,
Key_parenleft, Key_kana_FU, Key_parenright, 0x32EB,
Key_parenleft, Key_kana_HE, Key_parenright, 0x32EC,
Key_parenleft, Key_kana_HO, Key_parenright, 0x32ED,
Key_parenleft, Key_kana_MA, Key_parenright, 0x32EE,
Key_parenleft, Key_kana_MI, Key_parenright, 0x32EF,
Key_parenleft, Key_kana_MU, Key_parenright, 0x32F0,
Key_parenleft, Key_kana_ME, Key_parenright, 0x32F1,
Key_parenleft, Key_kana_MO, Key_parenright, 0x32F2,
Key_parenleft, Key_kana_YA, Key_parenright, 0x32F3,
Key_parenleft, Key_kana_YU, Key_parenright, 0x32F4,
Key_parenleft, Key_kana_YO, Key_parenright, 0x32F5,
Key_parenleft, Key_kana_RA, Key_parenright, 0x32F6,
Key_parenleft, Key_kana_RI, Key_parenright, 0x32F7,
Key_parenleft, Key_kana_RU, Key_parenright, 0x32F8,
Key_parenleft, Key_kana_RE, Key_parenright, 0x32F9,
Key_parenleft, Key_kana_RO, Key_parenright, 0x32FA,
Key_parenleft, Key_kana_WA, Key_parenright, 0x32FB,
Key_parenleft, 0x1100, Key_parenright, 0x3260,
Key_parenleft, 0x1102, Key_parenright, 0x3261,
Key_parenleft, 0x1103, Key_parenright, 0x3262,
Key_parenleft, 0x1105, Key_parenright, 0x3263,
Key_parenleft, 0x1106, Key_parenright, 0x3264,
Key_parenleft, 0x1107, Key_parenright, 0x3265,
Key_parenleft, 0x1109, Key_parenright, 0x3266,
Key_parenleft, 0x110B, Key_parenright, 0x3267,
Key_parenleft, 0x110C, Key_parenright, 0x3268,
Key_parenleft, 0x110E, Key_parenright, 0x3269,
Key_parenleft, 0x110F, Key_parenright, 0x326A,
Key_parenleft, 0x1110, Key_parenright, 0x326B,
Key_parenleft, 0x1111, Key_parenright, 0x326C,
Key_parenleft, 0x1112, Key_parenright, 0x326D,
Key_parenleft, 0x30F0, Key_parenright, 0x32FC,
Key_parenleft, 0x30F1, Key_parenright, 0x32FD,
Key_parenleft, 0x4E00, Key_parenright, 0x3280,
Key_parenleft, 0x4E03, Key_parenright, 0x3286,
Key_parenleft, 0x4E09, Key_parenright, 0x3282,
Key_parenleft, 0x4E0A, Key_parenright, 0x32A4,
Key_parenleft, 0x4E0B, Key_parenright, 0x32A6,
Key_parenleft, 0x4E2D, Key_parenright, 0x32A5,
Key_parenleft, 0x4E5D, Key_parenright, 0x3288,
Key_parenleft, 0x4E8C, Key_parenright, 0x3281,
Key_parenleft, 0x4E94, Key_parenright, 0x3284,
Key_parenleft, 0x4F01, Key_parenright, 0x32AD,
Key_parenleft, 0x4F11, Key_parenright, 0x32A1,
Key_parenleft, 0x512A, Key_parenright, 0x329D,
Key_parenleft, 0x516B, Key_parenright, 0x3287,
Key_parenleft, 0x516D, Key_parenright, 0x3285,
Key_parenleft, 0x5199, Key_parenright, 0x32A2,
Key_parenleft, 0x52B4, Key_parenright, 0x3298,
Key_parenleft, 0x533B, Key_parenright, 0x32A9,
Key_parenleft, 0x5341, Key_parenright, 0x3289,
Key_parenleft, 0x5354, Key_parenright, 0x32AF,
Key_parenleft, 0x5370, Key_parenright, 0x329E,
Key_parenleft, 0x53F3, Key_parenright, 0x32A8,
Key_parenleft, 0x540D, Key_parenright, 0x3294,
Key_parenleft, 0x56DB, Key_parenright, 0x3283,
Key_parenleft, 0x571F, Key_parenright, 0x328F,
Key_parenleft, 0x591C, Key_parenright, 0x32B0,
Key_parenleft, 0x5973, Key_parenright, 0x329B,
Key_parenleft, 0x5B66, Key_parenright, 0x32AB,
Key_parenleft, 0x5B97, Key_parenright, 0x32AA,
Key_parenleft, 0x5DE6, Key_parenright, 0x32A7,
Key_parenleft, 0x65E5, Key_parenright, 0x3290,
Key_parenleft, 0x6708, Key_parenright, 0x328A,
Key_parenleft, 0x6709, Key_parenright, 0x3292,
Key_parenleft, 0x6728, Key_parenright, 0x328D,
Key_parenleft, 0x682A, Key_parenright, 0x3291,
Key_parenleft, 0x6B63, Key_parenright, 0x32A3,
Key_parenleft, 0x6C34, Key_parenright, 0x328C,
Key_parenleft, 0x6CE8, Key_parenright, 0x329F,
Key_parenleft, 0x706B, Key_parenright, 0x328B,
Key_parenleft, 0x7279, Key_parenright, 0x3295,
Key_parenleft, 0x7537, Key_parenright, 0x329A,
Key_parenleft, 0x76E3, Key_parenright, 0x32AC,
Key_parenleft, 0x793E, Key_parenright, 0x3293,
Key_parenleft, 0x795D, Key_parenright, 0x3297,
Key_parenleft, 0x79D8, Key_parenright, 0x3299,
Key_parenleft, 0x8CA1, Key_parenright, 0x3296,
Key_parenleft, 0x8CC7, Key_parenright, 0x32AE,
Key_parenleft, 0x9069, Key_parenright, 0x329C,
Key_parenleft, 0x91D1, Key_parenright, 0x328E,
Key_parenleft, 0x9805, Key_parenright, 0x32A0,
Key_parenleft, Key_KP_Space, Key_parenright, 0x2461,
Key_parenleft, Key_KP_0, Key_parenright, 0x24EA,
Key_parenleft, Key_KP_1, Key_parenright, 0x2460,
Key_parenleft, Key_KP_2, Key_parenright, 0x2461,
Key_parenleft, Key_KP_3, Key_parenright, 0x2462,
Key_parenleft, Key_KP_4, Key_parenright, 0x2463,
Key_parenleft, Key_KP_5, Key_parenright, 0x2464,
Key_parenleft, Key_KP_6, Key_parenright, 0x2465,
Key_parenleft, Key_KP_7, Key_parenright, 0x2466,
Key_parenleft, Key_KP_8, Key_parenright, 0x2467,
Key_parenleft, Key_KP_9, Key_parenright, 0x2468,
Key_minus, Key_minus, Key_space, 0x00AD,
Key_minus, Key_minus, Key_minus, 0x2014,
Key_minus, Key_minus, Key_period, 0x2013,
Key_period, Key_exclam, Key_S, 0x1E68,
Key_period, Key_exclam, Key_s, 0x1E69,
Key_period, Key_apostrophe, Key_S, 0x1E64,
Key_period, Key_apostrophe, Key_s, 0x1E65,
Key_period, Key_acute, Key_S, 0x1E64,
Key_period, Key_acute, Key_s, 0x1E65,
Key_period, Key_dead_acute, Key_S, 0x1E64,
Key_period, Key_dead_acute, Key_s, 0x1E65,
Key_period, Key_dead_caron, Key_S, 0x1E66,
Key_period, Key_dead_caron, Key_s, 0x1E67,
Key_period, Key_dead_belowdot, Key_S, 0x1E68,
Key_period, Key_dead_belowdot, Key_s, 0x1E69,
Key_question, Key_plus, Key_O, 0x1EDE,
Key_question, Key_plus, Key_U, 0x1EEC,
Key_question, Key_plus, Key_o, 0x1EDF,
Key_question, Key_plus, Key_u, 0x1EED,
Key_question, Key_asciicircum, Key_A, 0x1EA8,
Key_question, Key_asciicircum, Key_E, 0x1EC2,
Key_question, Key_asciicircum, Key_O, 0x1ED4,
Key_question, Key_asciicircum, Key_a, 0x1EA9,
Key_question, Key_asciicircum, Key_e, 0x1EC3,
Key_question, Key_asciicircum, Key_o, 0x1ED5,
Key_question, Key_b, Key_A, 0x1EB2,
Key_question, Key_b, Key_a, 0x1EB3,
Key_question, Key_dead_circumflex, Key_A, 0x1EA8,
Key_question, Key_dead_circumflex, Key_E, 0x1EC2,
Key_question, Key_dead_circumflex, Key_O, 0x1ED4,
Key_question, Key_dead_circumflex, Key_a, 0x1EA9,
Key_question, Key_dead_circumflex, Key_e, 0x1EC3,
Key_question, Key_dead_circumflex, Key_o, 0x1ED5,
Key_question, Key_dead_breve, Key_A, 0x1EB2,
Key_question, Key_dead_breve, Key_a, 0x1EB3,
Key_question, Key_dead_horn, Key_O, 0x1EDE,
Key_question, Key_dead_horn, Key_U, 0x1EEC,
Key_question, Key_dead_horn, Key_o, 0x1EDF,
Key_question, Key_dead_horn, Key_u, 0x1EED,
Key_U, Key_exclam, Key_A, 0x1EB6,
Key_U, Key_exclam, Key_a, 0x1EB7,
Key_U, Key_comma, Key_E, 0x1E1C,
Key_U, Key_comma, Key_e, 0x1E1D,
Key_U, Key_cedilla, Key_E, 0x1E1C,
Key_U, Key_cedilla, Key_e, 0x1E1D,
Key_U, Key_dead_cedilla, Key_E, 0x1E1C,
Key_U, Key_dead_cedilla, Key_e, 0x1E1D,
Key_U, Key_dead_belowdot, Key_A, 0x1EB6,
Key_U, Key_dead_belowdot, Key_a, 0x1EB7,
Key_asciicircum, Key_exclam, Key_A, 0x1EAC,
Key_asciicircum, Key_exclam, Key_E, 0x1EC6,
Key_asciicircum, Key_exclam, Key_O, 0x1ED8,
Key_asciicircum, Key_exclam, Key_a, 0x1EAD,
Key_asciicircum, Key_exclam, Key_e, 0x1EC7,
Key_asciicircum, Key_exclam, Key_o, 0x1ED9,
Key_asciicircum, Key_underscore, Key_a, 0x00AA,
Key_asciicircum, Key_underscore, Key_h, 0x02B0,
Key_asciicircum, Key_underscore, Key_i, 0x2071,
Key_asciicircum, Key_underscore, Key_j, 0x02B2,
Key_asciicircum, Key_underscore, Key_l, 0x02E1,
Key_asciicircum, Key_underscore, Key_n, 0x207F,
Key_asciicircum, Key_underscore, Key_o, 0x00BA,
Key_asciicircum, Key_underscore, Key_r, 0x02B3,
Key_asciicircum, Key_underscore, Key_s, 0x02E2,
Key_asciicircum, Key_underscore, Key_w, 0x02B7,
Key_asciicircum, Key_underscore, Key_x, 0x02E3,
Key_asciicircum, Key_underscore, Key_y, 0x02B8,
Key_asciicircum, Key_underscore, 0x0263, 0x02E0,
Key_asciicircum, Key_underscore, 0x0266, 0x02B1,
Key_asciicircum, Key_underscore, 0x0279, 0x02B4,
Key_asciicircum, Key_underscore, 0x027B, 0x02B5,
Key_asciicircum, Key_underscore, 0x0281, 0x02B6,
Key_asciicircum, Key_underscore, 0x0295, 0x02E4,
Key_asciicircum, Key_underbar, Key_a, 0x00AA,
Key_asciicircum, Key_underbar, Key_h, 0x02B0,
Key_asciicircum, Key_underbar, Key_i, 0x2071,
Key_asciicircum, Key_underbar, Key_j, 0x02B2,
Key_asciicircum, Key_underbar, Key_l, 0x02E1,
Key_asciicircum, Key_underbar, Key_n, 0x207F,
Key_asciicircum, Key_underbar, Key_o, 0x00BA,
Key_asciicircum, Key_underbar, Key_r, 0x02B3,
Key_asciicircum, Key_underbar, Key_s, 0x02E2,
Key_asciicircum, Key_underbar, Key_w, 0x02B7,
Key_asciicircum, Key_underbar, Key_x, 0x02E3,
Key_asciicircum, Key_underbar, Key_y, 0x02B8,
Key_asciicircum, Key_underbar, 0x0263, 0x02E0,
Key_asciicircum, Key_underbar, 0x0266, 0x02B1,
Key_asciicircum, Key_underbar, 0x0279, 0x02B4,
Key_asciicircum, Key_underbar, 0x027B, 0x02B5,
Key_asciicircum, Key_underbar, 0x0281, 0x02B6,
Key_asciicircum, Key_underbar, 0x0295, 0x02E4,
Key_asciicircum, Key_dead_belowdot, Key_A, 0x1EAC,
Key_asciicircum, Key_dead_belowdot, Key_E, 0x1EC6,
Key_asciicircum, Key_dead_belowdot, Key_O, 0x1ED8,
Key_asciicircum, Key_dead_belowdot, Key_a, 0x1EAD,
Key_asciicircum, Key_dead_belowdot, Key_e, 0x1EC7,
Key_asciicircum, Key_dead_belowdot, Key_o, 0x1ED9,
Key_underscore, Key_exclam, Key_L, 0x1E38,
Key_underscore, Key_exclam, Key_R, 0x1E5C,
Key_underscore, Key_exclam, Key_l, 0x1E39,
Key_underscore, Key_exclam, Key_r, 0x1E5D,
Key_underscore, Key_quotedbl, Key_A, 0x01DE,
Key_underscore, Key_quotedbl, Key_O, 0x022A,
Key_underscore, Key_quotedbl, Key_U, 0x01D5,
Key_underscore, Key_quotedbl, Key_a, 0x01DF,
Key_underscore, Key_quotedbl, Key_o, 0x022B,
Key_underscore, Key_quotedbl, Key_u, 0x01D6,
Key_underscore, Key_period, Key_A, 0x01E0,
Key_underscore, Key_period, Key_O, 0x0230,
Key_underscore, Key_period, Key_a, 0x01E1,
Key_underscore, Key_period, Key_o, 0x0231,
Key_underscore, Key_semicolon, Key_O, 0x01EC,
Key_underscore, Key_semicolon, Key_o, 0x01ED,
Key_underscore, Key_asciitilde, Key_O, 0x022C,
Key_underscore, Key_asciitilde, Key_o, 0x022D,
Key_underscore, Key_dead_tilde, Key_O, 0x022C,
Key_underscore, Key_dead_tilde, Key_o, 0x022D,
Key_underscore, Key_dead_abovedot, Key_A, 0x01E0,
Key_underscore, Key_dead_abovedot, Key_O, 0x0230,
Key_underscore, Key_dead_abovedot, Key_a, 0x01E1,
Key_underscore, Key_dead_abovedot, Key_o, 0x0231,
Key_underscore, Key_dead_diaeresis, Key_A, 0x01DE,
Key_underscore, Key_dead_diaeresis, Key_O, 0x022A,
Key_underscore, Key_dead_diaeresis, Key_U, 0x01D5,
Key_underscore, Key_dead_diaeresis, Key_a, 0x01DF,
Key_underscore, Key_dead_diaeresis, Key_o, 0x022B,
Key_underscore, Key_dead_diaeresis, Key_u, 0x01D6,
Key_underscore, Key_dead_ogonek, Key_O, 0x01EC,
Key_underscore, Key_dead_ogonek, Key_o, 0x01ED,
Key_underscore, Key_dead_belowdot, Key_L, 0x1E38,
Key_underscore, Key_dead_belowdot, Key_R, 0x1E5C,
Key_underscore, Key_dead_belowdot, Key_l, 0x1E39,
Key_underscore, Key_dead_belowdot, Key_r, 0x1E5D,
Key_grave, Key_quotedbl, Key_U, 0x01DB,
Key_grave, Key_quotedbl, Key_u, 0x01DC,
Key_grave, Key_quotedbl, Key_Greek_iota, 0x1FD2,
Key_grave, Key_quotedbl, Key_Greek_upsilon, 0x1FE2,
Key_grave, Key_parenleft, Key_Greek_ALPHA, 0x1F0B,
Key_grave, Key_parenleft, Key_Greek_EPSILON, 0x1F1B,
Key_grave, Key_parenleft, Key_Greek_ETA, 0x1F2B,
Key_grave, Key_parenleft, Key_Greek_IOTA, 0x1F3B,
Key_grave, Key_parenleft, Key_Greek_OMICRON, 0x1F4B,
Key_grave, Key_parenleft, Key_Greek_UPSILON, 0x1F5B,
Key_grave, Key_parenleft, Key_Greek_OMEGA, 0x1F6B,
Key_grave, Key_parenleft, Key_Greek_alpha, 0x1F03,
Key_grave, Key_parenleft, Key_Greek_epsilon, 0x1F13,
Key_grave, Key_parenleft, Key_Greek_eta, 0x1F23,
Key_grave, Key_parenleft, Key_Greek_iota, 0x1F33,
Key_grave, Key_parenleft, Key_Greek_omicron, 0x1F43,
Key_grave, Key_parenleft, Key_Greek_upsilon, 0x1F53,
Key_grave, Key_parenleft, Key_Greek_omega, 0x1F63,
Key_grave, Key_parenright, Key_Greek_ALPHA, 0x1F0A,
Key_grave, Key_parenright, Key_Greek_EPSILON, 0x1F1A,
Key_grave, Key_parenright, Key_Greek_ETA, 0x1F2A,
Key_grave, Key_parenright, Key_Greek_IOTA, 0x1F3A,
Key_grave, Key_parenright, Key_Greek_OMICRON, 0x1F4A,
Key_grave, Key_parenright, Key_Greek_OMEGA, 0x1F6A,
Key_grave, Key_parenright, Key_Greek_alpha, 0x1F02,
Key_grave, Key_parenright, Key_Greek_epsilon, 0x1F12,
Key_grave, Key_parenright, Key_Greek_eta, 0x1F22,
Key_grave, Key_parenright, Key_Greek_iota, 0x1F32,
Key_grave, Key_parenright, Key_Greek_omicron, 0x1F42,
Key_grave, Key_parenright, Key_Greek_upsilon, 0x1F52,
Key_grave, Key_parenright, Key_Greek_omega, 0x1F62,
Key_grave, Key_plus, Key_O, 0x1EDC,
Key_grave, Key_plus, Key_U, 0x1EEA,
Key_grave, Key_plus, Key_o, 0x1EDD,
Key_grave, Key_plus, Key_u, 0x1EEB,
Key_grave, Key_asciicircum, Key_A, 0x1EA6,
Key_grave, Key_asciicircum, Key_E, 0x1EC0,
Key_grave, Key_asciicircum, Key_O, 0x1ED2,
Key_grave, Key_asciicircum, Key_a, 0x1EA7,
Key_grave, Key_asciicircum, Key_e, 0x1EC1,
Key_grave, Key_asciicircum, Key_o, 0x1ED3,
Key_grave, Key_underscore, Key_E, 0x1E14,
Key_grave, Key_underscore, Key_O, 0x1E50,
Key_grave, Key_underscore, Key_e, 0x1E15,
Key_grave, Key_underscore, Key_o, 0x1E51,
Key_grave, Key_b, Key_A, 0x1EB0,
Key_grave, Key_b, Key_a, 0x1EB1,
Key_grave, Key_macron, Key_E, 0x1E14,
Key_grave, Key_macron, Key_O, 0x1E50,
Key_grave, Key_macron, Key_e, 0x1E15,
Key_grave, Key_macron, Key_o, 0x1E51,
Key_grave, Key_dead_circumflex, Key_A, 0x1EA6,
Key_grave, Key_dead_circumflex, Key_E, 0x1EC0,
Key_grave, Key_dead_circumflex, Key_O, 0x1ED2,
Key_grave, Key_dead_circumflex, Key_a, 0x1EA7,
Key_grave, Key_dead_circumflex, Key_e, 0x1EC1,
Key_grave, Key_dead_circumflex, Key_o, 0x1ED3,
Key_grave, Key_dead_macron, Key_E, 0x1E14,
Key_grave, Key_dead_macron, Key_O, 0x1E50,
Key_grave, Key_dead_macron, Key_e, 0x1E15,
Key_grave, Key_dead_macron, Key_o, 0x1E51,
Key_grave, Key_dead_breve, Key_A, 0x1EB0,
Key_grave, Key_dead_breve, Key_a, 0x1EB1,
Key_grave, Key_dead_diaeresis, Key_U, 0x01DB,
Key_grave, Key_dead_diaeresis, Key_u, 0x01DC,
Key_grave, Key_dead_diaeresis, Key_Greek_iota, 0x1FD2,
Key_grave, Key_dead_diaeresis, Key_Greek_upsilon, 0x1FE2,
Key_grave, Key_dead_horn, Key_O, 0x1EDC,
Key_grave, Key_dead_horn, Key_U, 0x1EEA,
Key_grave, Key_dead_horn, Key_o, 0x1EDD,
Key_grave, Key_dead_horn, Key_u, 0x1EEB,
Key_grave, Key_dead_psili, Key_Greek_ALPHA, 0x1F0A,
Key_grave, Key_dead_psili, Key_Greek_EPSILON, 0x1F1A,
Key_grave, Key_dead_psili, Key_Greek_ETA, 0x1F2A,
Key_grave, Key_dead_psili, Key_Greek_IOTA, 0x1F3A,
Key_grave, Key_dead_psili, Key_Greek_OMICRON, 0x1F4A,
Key_grave, Key_dead_psili, Key_Greek_OMEGA, 0x1F6A,
Key_grave, Key_dead_psili, Key_Greek_alpha, 0x1F02,
Key_grave, Key_dead_psili, Key_Greek_epsilon, 0x1F12,
Key_grave, Key_dead_psili, Key_Greek_eta, 0x1F22,
Key_grave, Key_dead_psili, Key_Greek_iota, 0x1F32,
Key_grave, Key_dead_psili, Key_Greek_omicron, 0x1F42,
Key_grave, Key_dead_psili, Key_Greek_upsilon, 0x1F52,
Key_grave, Key_dead_psili, Key_Greek_omega, 0x1F62,
Key_grave, Key_dead_dasia, Key_Greek_ALPHA, 0x1F0B,
Key_grave, Key_dead_dasia, Key_Greek_EPSILON, 0x1F1B,
Key_grave, Key_dead_dasia, Key_Greek_ETA, 0x1F2B,
Key_grave, Key_dead_dasia, Key_Greek_IOTA, 0x1F3B,
Key_grave, Key_dead_dasia, Key_Greek_OMICRON, 0x1F4B,
Key_grave, Key_dead_dasia, Key_Greek_UPSILON, 0x1F5B,
Key_grave, Key_dead_dasia, Key_Greek_OMEGA, 0x1F6B,
Key_grave, Key_dead_dasia, Key_Greek_alpha, 0x1F03,
Key_grave, Key_dead_dasia, Key_Greek_epsilon, 0x1F13,
Key_grave, Key_dead_dasia, Key_Greek_eta, 0x1F23,
Key_grave, Key_dead_dasia, Key_Greek_iota, 0x1F33,
Key_grave, Key_dead_dasia, Key_Greek_omicron, 0x1F43,
Key_grave, Key_dead_dasia, Key_Greek_upsilon, 0x1F53,
Key_grave, Key_dead_dasia, Key_Greek_omega, 0x1F63,
Key_b, Key_exclam, Key_A, 0x1EB6,
Key_b, Key_exclam, Key_a, 0x1EB7,
Key_b, Key_comma, Key_E, 0x1E1C,
Key_b, Key_comma, Key_e, 0x1E1D,
Key_b, Key_cedilla, Key_E, 0x1E1C,
Key_b, Key_cedilla, Key_e, 0x1E1D,
Key_b, Key_dead_cedilla, Key_E, 0x1E1C,
Key_b, Key_dead_cedilla, Key_e, 0x1E1D,
Key_b, Key_dead_belowdot, Key_A, 0x1EB6,
Key_b, Key_dead_belowdot, Key_a, 0x1EB7,
Key_c, Key_quotedbl, Key_U, 0x01D9,
Key_c, Key_quotedbl, Key_u, 0x01DA,
Key_c, Key_dead_diaeresis, Key_U, 0x01D9,
Key_c, Key_dead_diaeresis, Key_u, 0x01DA,
Key_o, Key_apostrophe, Key_A, 0x01FA,
Key_o, Key_apostrophe, Key_a, 0x01FB,
Key_asciitilde, Key_quotedbl, Key_Greek_iota, 0x1FD7,
Key_asciitilde, Key_quotedbl, Key_Greek_upsilon, 0x1FE7,
Key_asciitilde, Key_parenleft, Key_Greek_ALPHA, 0x1F0F,
Key_asciitilde, Key_parenleft, Key_Greek_ETA, 0x1F2F,
Key_asciitilde, Key_parenleft, Key_Greek_IOTA, 0x1F3F,
Key_asciitilde, Key_parenleft, Key_Greek_UPSILON, 0x1F5F,
Key_asciitilde, Key_parenleft, Key_Greek_OMEGA, 0x1F6F,
Key_asciitilde, Key_parenleft, Key_Greek_alpha, 0x1F07,
Key_asciitilde, Key_parenleft, Key_Greek_eta, 0x1F27,
Key_asciitilde, Key_parenleft, Key_Greek_iota, 0x1F37,
Key_asciitilde, Key_parenleft, Key_Greek_upsilon, 0x1F57,
Key_asciitilde, Key_parenleft, Key_Greek_omega, 0x1F67,
Key_asciitilde, Key_parenright, Key_Greek_ALPHA, 0x1F0E,
Key_asciitilde, Key_parenright, Key_Greek_ETA, 0x1F2E,
Key_asciitilde, Key_parenright, Key_Greek_IOTA, 0x1F3E,
Key_asciitilde, Key_parenright, Key_Greek_OMEGA, 0x1F6E,
Key_asciitilde, Key_parenright, Key_Greek_alpha, 0x1F06,
Key_asciitilde, Key_parenright, Key_Greek_eta, 0x1F26,
Key_asciitilde, Key_parenright, Key_Greek_iota, 0x1F36,
Key_asciitilde, Key_parenright, Key_Greek_upsilon, 0x1F56,
Key_asciitilde, Key_parenright, Key_Greek_omega, 0x1F66,
Key_asciitilde, Key_plus, Key_O, 0x1EE0,
Key_asciitilde, Key_plus, Key_U, 0x1EEE,
Key_asciitilde, Key_plus, Key_o, 0x1EE1,
Key_asciitilde, Key_plus, Key_u, 0x1EEF,
Key_asciitilde, Key_asciicircum, Key_A, 0x1EAA,
Key_asciitilde, Key_asciicircum, Key_E, 0x1EC4,
Key_asciitilde, Key_asciicircum, Key_O, 0x1ED6,
Key_asciitilde, Key_asciicircum, Key_a, 0x1EAB,
Key_asciitilde, Key_asciicircum, Key_e, 0x1EC5,
Key_asciitilde, Key_asciicircum, Key_o, 0x1ED7,
Key_asciitilde, Key_b, Key_A, 0x1EB4,
Key_asciitilde, Key_b, Key_a, 0x1EB5,
Key_asciitilde, Key_dead_circumflex, Key_A, 0x1EAA,
Key_asciitilde, Key_dead_circumflex, Key_E, 0x1EC4,
Key_asciitilde, Key_dead_circumflex, Key_O, 0x1ED6,
Key_asciitilde, Key_dead_circumflex, Key_a, 0x1EAB,
Key_asciitilde, Key_dead_circumflex, Key_e, 0x1EC5,
Key_asciitilde, Key_dead_circumflex, Key_o, 0x1ED7,
Key_asciitilde, Key_dead_breve, Key_A, 0x1EB4,
Key_asciitilde, Key_dead_breve, Key_a, 0x1EB5,
Key_asciitilde, Key_dead_diaeresis, Key_Greek_iota, 0x1FD7,
Key_asciitilde, Key_dead_diaeresis, Key_Greek_upsilon, 0x1FE7,
Key_asciitilde, Key_dead_horn, Key_O, 0x1EE0,
Key_asciitilde, Key_dead_horn, Key_U, 0x1EEE,
Key_asciitilde, Key_dead_horn, Key_o, 0x1EE1,
Key_asciitilde, Key_dead_horn, Key_u, 0x1EEF,
Key_asciitilde, Key_dead_psili, Key_Greek_ALPHA, 0x1F0E,
Key_asciitilde, Key_dead_psili, Key_Greek_ETA, 0x1F2E,
Key_asciitilde, Key_dead_psili, Key_Greek_IOTA, 0x1F3E,
Key_asciitilde, Key_dead_psili, Key_Greek_OMEGA, 0x1F6E,
Key_asciitilde, Key_dead_psili, Key_Greek_alpha, 0x1F06,
Key_asciitilde, Key_dead_psili, Key_Greek_eta, 0x1F26,
Key_asciitilde, Key_dead_psili, Key_Greek_iota, 0x1F36,
Key_asciitilde, Key_dead_psili, Key_Greek_upsilon, 0x1F56,
Key_asciitilde, Key_dead_psili, Key_Greek_omega, 0x1F66,
Key_asciitilde, Key_dead_dasia, Key_Greek_ALPHA, 0x1F0F,
Key_asciitilde, Key_dead_dasia, Key_Greek_ETA, 0x1F2F,
Key_asciitilde, Key_dead_dasia, Key_Greek_IOTA, 0x1F3F,
Key_asciitilde, Key_dead_dasia, Key_Greek_UPSILON, 0x1F5F,
Key_asciitilde, Key_dead_dasia, Key_Greek_OMEGA, 0x1F6F,
Key_asciitilde, Key_dead_dasia, Key_Greek_alpha, 0x1F07,
Key_asciitilde, Key_dead_dasia, Key_Greek_eta, 0x1F27,
Key_asciitilde, Key_dead_dasia, Key_Greek_iota, 0x1F37,
Key_asciitilde, Key_dead_dasia, Key_Greek_upsilon, 0x1F57,
Key_asciitilde, Key_dead_dasia, Key_Greek_omega, 0x1F67,
Key_macron, Key_exclam, Key_L, 0x1E38,
Key_macron, Key_exclam, Key_R, 0x1E5C,
Key_macron, Key_exclam, Key_l, 0x1E39,
Key_macron, Key_exclam, Key_r, 0x1E5D,
Key_macron, Key_quotedbl, Key_A, 0x01DE,
Key_macron, Key_quotedbl, Key_O, 0x022A,
Key_macron, Key_quotedbl, Key_U, 0x01D5,
Key_macron, Key_quotedbl, Key_a, 0x01DF,
Key_macron, Key_quotedbl, Key_o, 0x022B,
Key_macron, Key_quotedbl, Key_u, 0x01D6,
Key_macron, Key_period, Key_A, 0x01E0,
Key_macron, Key_period, Key_O, 0x0230,
Key_macron, Key_period, Key_a, 0x01E1,
Key_macron, Key_period, Key_o, 0x0231,
Key_macron, Key_semicolon, Key_O, 0x01EC,
Key_macron, Key_semicolon, Key_o, 0x01ED,
Key_macron, Key_asciitilde, Key_O, 0x022C,
Key_macron, Key_asciitilde, Key_o, 0x022D,
Key_macron, Key_dead_tilde, Key_O, 0x022C,
Key_macron, Key_dead_tilde, Key_o, 0x022D,
Key_macron, Key_dead_abovedot, Key_A, 0x01E0,
Key_macron, Key_dead_abovedot, Key_O, 0x0230,
Key_macron, Key_dead_abovedot, Key_a, 0x01E1,
Key_macron, Key_dead_abovedot, Key_o, 0x0231,
Key_macron, Key_dead_diaeresis, Key_A, 0x01DE,
Key_macron, Key_dead_diaeresis, Key_O, 0x022A,
Key_macron, Key_dead_diaeresis, Key_U, 0x01D5,
Key_macron, Key_dead_diaeresis, Key_a, 0x01DF,
Key_macron, Key_dead_diaeresis, Key_o, 0x022B,
Key_macron, Key_dead_diaeresis, Key_u, 0x01D6,
Key_macron, Key_dead_ogonek, Key_O, 0x01EC,
Key_macron, Key_dead_ogonek, Key_o, 0x01ED,
Key_macron, Key_dead_belowdot, Key_L, 0x1E38,
Key_macron, Key_dead_belowdot, Key_R, 0x1E5C,
Key_macron, Key_dead_belowdot, Key_l, 0x1E39,
Key_macron, Key_dead_belowdot, Key_r, 0x1E5D,
Key_acute, Key_quotedbl, Key_I, 0x1E2E,
Key_acute, Key_quotedbl, Key_U, 0x01D7,
Key_acute, Key_quotedbl, Key_i, 0x1E2F,
Key_acute, Key_quotedbl, Key_u, 0x01D8,
Key_acute, Key_quotedbl, Key_Greek_iota, 0x0390,
Key_acute, Key_quotedbl, Key_Greek_upsilon, 0x03B0,
Key_acute, Key_parenleft, Key_Greek_ALPHA, 0x1F0D,
Key_acute, Key_parenleft, Key_Greek_EPSILON, 0x1F1D,
Key_acute, Key_parenleft, Key_Greek_ETA, 0x1F2D,
Key_acute, Key_parenleft, Key_Greek_IOTA, 0x1F3D,
Key_acute, Key_parenleft, Key_Greek_OMICRON, 0x1F4D,
Key_acute, Key_parenleft, Key_Greek_UPSILON, 0x1F5D,
Key_acute, Key_parenleft, Key_Greek_OMEGA, 0x1F6D,
Key_acute, Key_parenleft, Key_Greek_alpha, 0x1F05,
Key_acute, Key_parenleft, Key_Greek_epsilon, 0x1F15,
Key_acute, Key_parenleft, Key_Greek_eta, 0x1F25,
Key_acute, Key_parenleft, Key_Greek_iota, 0x1F35,
Key_acute, Key_parenleft, Key_Greek_omicron, 0x1F45,
Key_acute, Key_parenleft, Key_Greek_upsilon, 0x1F55,
Key_acute, Key_parenleft, Key_Greek_omega, 0x1F65,
Key_acute, Key_parenright, Key_Greek_ALPHA, 0x1F0C,
Key_acute, Key_parenright, Key_Greek_EPSILON, 0x1F1C,
Key_acute, Key_parenright, Key_Greek_ETA, 0x1F2C,
Key_acute, Key_parenright, Key_Greek_IOTA, 0x1F3C,
Key_acute, Key_parenright, Key_Greek_OMICRON, 0x1F4C,
Key_acute, Key_parenright, Key_Greek_OMEGA, 0x1F6C,
Key_acute, Key_parenright, Key_Greek_alpha, 0x1F04,
Key_acute, Key_parenright, Key_Greek_epsilon, 0x1F14,
Key_acute, Key_parenright, Key_Greek_eta, 0x1F24,
Key_acute, Key_parenright, Key_Greek_iota, 0x1F34,
Key_acute, Key_parenright, Key_Greek_omicron, 0x1F44,
Key_acute, Key_parenright, Key_Greek_upsilon, 0x1F54,
Key_acute, Key_parenright, Key_Greek_omega, 0x1F64,
Key_acute, Key_plus, Key_O, 0x1EDA,
Key_acute, Key_plus, Key_U, 0x1EE8,
Key_acute, Key_plus, Key_o, 0x1EDB,
Key_acute, Key_plus, Key_u, 0x1EE9,
Key_acute, Key_comma, Key_C, 0x1E08,
Key_acute, Key_comma, Key_c, 0x1E09,
Key_acute, Key_slash, Key_O, 0x01FE,
Key_acute, Key_slash, Key_o, 0x01FF,
Key_acute, Key_asciicircum, Key_A, 0x1EA4,
Key_acute, Key_asciicircum, Key_E, 0x1EBE,
Key_acute, Key_asciicircum, Key_O, 0x1ED0,
Key_acute, Key_asciicircum, Key_a, 0x1EA5,
Key_acute, Key_asciicircum, Key_e, 0x1EBF,
Key_acute, Key_asciicircum, Key_o, 0x1ED1,
Key_acute, Key_underscore, Key_E, 0x1E16,
Key_acute, Key_underscore, Key_O, 0x1E52,
Key_acute, Key_underscore, Key_e, 0x1E17,
Key_acute, Key_underscore, Key_o, 0x1E53,
Key_acute, Key_b, Key_A, 0x1EAE,
Key_acute, Key_b, Key_a, 0x1EAF,
Key_acute, Key_asciitilde, Key_O, 0x1E4C,
Key_acute, Key_asciitilde, Key_U, 0x1E78,
Key_acute, Key_asciitilde, Key_o, 0x1E4D,
Key_acute, Key_asciitilde, Key_u, 0x1E79,
Key_acute, Key_macron, Key_E, 0x1E16,
Key_acute, Key_macron, Key_O, 0x1E52,
Key_acute, Key_macron, Key_e, 0x1E17,
Key_acute, Key_macron, Key_o, 0x1E53,
Key_acute, Key_cedilla, Key_C, 0x1E08,
Key_acute, Key_cedilla, Key_c, 0x1E09,
Key_acute, Key_dead_circumflex, Key_A, 0x1EA4,
Key_acute, Key_dead_circumflex, Key_E, 0x1EBE,
Key_acute, Key_dead_circumflex, Key_O, 0x1ED0,
Key_acute, Key_dead_circumflex, Key_a, 0x1EA5,
Key_acute, Key_dead_circumflex, Key_e, 0x1EBF,
Key_acute, Key_dead_circumflex, Key_o, 0x1ED1,
Key_acute, Key_dead_tilde, Key_O, 0x1E4C,
Key_acute, Key_dead_tilde, Key_U, 0x1E78,
Key_acute, Key_dead_tilde, Key_o, 0x1E4D,
Key_acute, Key_dead_tilde, Key_u, 0x1E79,
Key_acute, Key_dead_macron, Key_E, 0x1E16,
Key_acute, Key_dead_macron, Key_O, 0x1E52,
Key_acute, Key_dead_macron, Key_e, 0x1E17,
Key_acute, Key_dead_macron, Key_o, 0x1E53,
Key_acute, Key_dead_breve, Key_A, 0x1EAE,
Key_acute, Key_dead_breve, Key_a, 0x1EAF,
Key_acute, Key_dead_diaeresis, Key_I, 0x1E2E,
Key_acute, Key_dead_diaeresis, Key_U, 0x01D7,
Key_acute, Key_dead_diaeresis, Key_i, 0x1E2F,
Key_acute, Key_dead_diaeresis, Key_u, 0x01D8,
Key_acute, Key_dead_diaeresis, Key_Greek_iota, 0x0390,
Key_acute, Key_dead_diaeresis, Key_Greek_upsilon, 0x03B0,
Key_acute, Key_dead_abovering, Key_A, 0x01FA,
Key_acute, Key_dead_abovering, Key_a, 0x01FB,
Key_acute, Key_dead_cedilla, Key_C, 0x1E08,
Key_acute, Key_dead_cedilla, Key_c, 0x1E09,
Key_acute, Key_dead_horn, Key_O, 0x1EDA,
Key_acute, Key_dead_horn, Key_U, 0x1EE8,
Key_acute, Key_dead_horn, Key_o, 0x1EDB,
Key_acute, Key_dead_horn, Key_u, 0x1EE9,
Key_acute, Key_dead_psili, Key_Greek_ALPHA, 0x1F0C,
Key_acute, Key_dead_psili, Key_Greek_EPSILON, 0x1F1C,
Key_acute, Key_dead_psili, Key_Greek_ETA, 0x1F2C,
Key_acute, Key_dead_psili, Key_Greek_IOTA, 0x1F3C,
Key_acute, Key_dead_psili, Key_Greek_OMICRON, 0x1F4C,
Key_acute, Key_dead_psili, Key_Greek_OMEGA, 0x1F6C,
Key_acute, Key_dead_psili, Key_Greek_alpha, 0x1F04,
Key_acute, Key_dead_psili, Key_Greek_epsilon, 0x1F14,
Key_acute, Key_dead_psili, Key_Greek_eta, 0x1F24,
Key_acute, Key_dead_psili, Key_Greek_iota, 0x1F34,
Key_acute, Key_dead_psili, Key_Greek_omicron, 0x1F44,
Key_acute, Key_dead_psili, Key_Greek_upsilon, 0x1F54,
Key_acute, Key_dead_psili, Key_Greek_omega, 0x1F64,
Key_acute, Key_dead_dasia, Key_Greek_ALPHA, 0x1F0D,
Key_acute, Key_dead_dasia, Key_Greek_EPSILON, 0x1F1D,
Key_acute, Key_dead_dasia, Key_Greek_ETA, 0x1F2D,
Key_acute, Key_dead_dasia, Key_Greek_IOTA, 0x1F3D,
Key_acute, Key_dead_dasia, Key_Greek_OMICRON, 0x1F4D,
Key_acute, Key_dead_dasia, Key_Greek_UPSILON, 0x1F5D,
Key_acute, Key_dead_dasia, Key_Greek_OMEGA, 0x1F6D,
Key_acute, Key_dead_dasia, Key_Greek_alpha, 0x1F05,
Key_acute, Key_dead_dasia, Key_Greek_epsilon, 0x1F15,
Key_acute, Key_dead_dasia, Key_Greek_eta, 0x1F25,
Key_acute, Key_dead_dasia, Key_Greek_iota, 0x1F35,
Key_acute, Key_dead_dasia, Key_Greek_omicron, 0x1F45,
Key_acute, Key_dead_dasia, Key_Greek_upsilon, 0x1F55,
Key_acute, Key_dead_dasia, Key_Greek_omega, 0x1F65,
Key_acute, Key_KP_Divide, Key_O, 0x01FE,
Key_acute, Key_KP_Divide, Key_o, 0x01FF,
0x05C1, 0x05BC, Key_hebrew_shin, 0xFB2C,
0x05C2, 0x05BC, Key_hebrew_shin, 0xFB2D,
Key_Greek_iota, Key_apostrophe, Key_Greek_alpha, 0x1FB4,
Key_Greek_iota, Key_apostrophe, Key_Greek_eta, 0x1FC4,
Key_Greek_iota, Key_apostrophe, Key_Greek_omega, 0x1FF4,
Key_Greek_iota, Key_apostrophe, 0x1F00, 0x1F84,
Key_Greek_iota, Key_apostrophe, 0x1F01, 0x1F85,
Key_Greek_iota, Key_apostrophe, 0x1F08, 0x1F8C,
Key_Greek_iota, Key_apostrophe, 0x1F09, 0x1F8D,
Key_Greek_iota, Key_apostrophe, 0x1F20, 0x1F94,
Key_Greek_iota, Key_apostrophe, 0x1F21, 0x1F95,
Key_Greek_iota, Key_apostrophe, 0x1F28, 0x1F9C,
Key_Greek_iota, Key_apostrophe, 0x1F29, 0x1F9D,
Key_Greek_iota, Key_apostrophe, 0x1F60, 0x1FA4,
Key_Greek_iota, Key_apostrophe, 0x1F61, 0x1FA5,
Key_Greek_iota, Key_apostrophe, 0x1F68, 0x1FAC,
Key_Greek_iota, Key_apostrophe, 0x1F69, 0x1FAD,
Key_Greek_iota, Key_parenleft, Key_Greek_ALPHA, 0x1F89,
Key_Greek_iota, Key_parenleft, Key_Greek_ETA, 0x1F99,
Key_Greek_iota, Key_parenleft, Key_Greek_OMEGA, 0x1FA9,
Key_Greek_iota, Key_parenleft, Key_Greek_alpha, 0x1F81,
Key_Greek_iota, Key_parenleft, Key_Greek_eta, 0x1F91,
Key_Greek_iota, Key_parenleft, Key_Greek_omega, 0x1FA1,
Key_Greek_iota, Key_parenright, Key_Greek_ALPHA, 0x1F88,
Key_Greek_iota, Key_parenright, Key_Greek_ETA, 0x1F98,
Key_Greek_iota, Key_parenright, Key_Greek_OMEGA, 0x1FA8,
Key_Greek_iota, Key_parenright, Key_Greek_alpha, 0x1F80,
Key_Greek_iota, Key_parenright, Key_Greek_eta, 0x1F90,
Key_Greek_iota, Key_parenright, Key_Greek_omega, 0x1FA0,
Key_Greek_iota, Key_grave, Key_Greek_alpha, 0x1FB2,
Key_Greek_iota, Key_grave, Key_Greek_eta, 0x1FC2,
Key_Greek_iota, Key_grave, Key_Greek_omega, 0x1FF2,
Key_Greek_iota, Key_grave, 0x1F00, 0x1F82,
Key_Greek_iota, Key_grave, 0x1F01, 0x1F83,
Key_Greek_iota, Key_grave, 0x1F08, 0x1F8A,
Key_Greek_iota, Key_grave, 0x1F09, 0x1F8B,
Key_Greek_iota, Key_grave, 0x1F20, 0x1F92,
Key_Greek_iota, Key_grave, 0x1F21, 0x1F93,
Key_Greek_iota, Key_grave, 0x1F28, 0x1F9A,
Key_Greek_iota, Key_grave, 0x1F29, 0x1F9B,
Key_Greek_iota, Key_grave, 0x1F60, 0x1FA2,
Key_Greek_iota, Key_grave, 0x1F61, 0x1FA3,
Key_Greek_iota, Key_grave, 0x1F68, 0x1FAA,
Key_Greek_iota, Key_grave, 0x1F69, 0x1FAB,
Key_Greek_iota, Key_asciitilde, Key_Greek_alpha, 0x1FB7,
Key_Greek_iota, Key_asciitilde, Key_Greek_eta, 0x1FC7,
Key_Greek_iota, Key_asciitilde, Key_Greek_omega, 0x1FF7,
Key_Greek_iota, Key_asciitilde, 0x1F00, 0x1F86,
Key_Greek_iota, Key_asciitilde, 0x1F01, 0x1F87,
Key_Greek_iota, Key_asciitilde, 0x1F08, 0x1F8E,
Key_Greek_iota, Key_asciitilde, 0x1F09, 0x1F8F,
Key_Greek_iota, Key_asciitilde, 0x1F20, 0x1F96,
Key_Greek_iota, Key_asciitilde, 0x1F21, 0x1F97,
Key_Greek_iota, Key_asciitilde, 0x1F28, 0x1F9E,
Key_Greek_iota, Key_asciitilde, 0x1F29, 0x1F9F,
Key_Greek_iota, Key_asciitilde, 0x1F60, 0x1FA6,
Key_Greek_iota, Key_asciitilde, 0x1F61, 0x1FA7,
Key_Greek_iota, Key_asciitilde, 0x1F68, 0x1FAE,
Key_Greek_iota, Key_asciitilde, 0x1F69, 0x1FAF,
Key_Greek_iota, Key_acute, Key_Greek_alpha, 0x1FB4,
Key_Greek_iota, Key_acute, Key_Greek_eta, 0x1FC4,
Key_Greek_iota, Key_acute, Key_Greek_omega, 0x1FF4,
Key_Greek_iota, Key_acute, 0x1F00, 0x1F84,
Key_Greek_iota, Key_acute, 0x1F01, 0x1F85,
Key_Greek_iota, Key_acute, 0x1F08, 0x1F8C,
Key_Greek_iota, Key_acute, 0x1F09, 0x1F8D,
Key_Greek_iota, Key_acute, 0x1F20, 0x1F94,
Key_Greek_iota, Key_acute, 0x1F21, 0x1F95,
Key_Greek_iota, Key_acute, 0x1F28, 0x1F9C,
Key_Greek_iota, Key_acute, 0x1F29, 0x1F9D,
Key_Greek_iota, Key_acute, 0x1F60, 0x1FA4,
Key_Greek_iota, Key_acute, 0x1F61, 0x1FA5,
Key_Greek_iota, Key_acute, 0x1F68, 0x1FAC,
Key_Greek_iota, Key_acute, 0x1F69, 0x1FAD,
Key_Greek_iota, Key_dead_grave, Key_Greek_alpha, 0x1FB2,
Key_Greek_iota, Key_dead_grave, Key_Greek_eta, 0x1FC2,
Key_Greek_iota, Key_dead_grave, Key_Greek_omega, 0x1FF2,
Key_Greek_iota, Key_dead_grave, 0x1F00, 0x1F82,
Key_Greek_iota, Key_dead_grave, 0x1F01, 0x1F83,
Key_Greek_iota, Key_dead_grave, 0x1F08, 0x1F8A,
Key_Greek_iota, Key_dead_grave, 0x1F09, 0x1F8B,
Key_Greek_iota, Key_dead_grave, 0x1F20, 0x1F92,
Key_Greek_iota, Key_dead_grave, 0x1F21, 0x1F93,
Key_Greek_iota, Key_dead_grave, 0x1F28, 0x1F9A,
Key_Greek_iota, Key_dead_grave, 0x1F29, 0x1F9B,
Key_Greek_iota, Key_dead_grave, 0x1F60, 0x1FA2,
Key_Greek_iota, Key_dead_grave, 0x1F61, 0x1FA3,
Key_Greek_iota, Key_dead_grave, 0x1F68, 0x1FAA,
Key_Greek_iota, Key_dead_grave, 0x1F69, 0x1FAB,
Key_Greek_iota, Key_dead_acute, Key_Greek_alpha, 0x1FB4,
Key_Greek_iota, Key_dead_acute, Key_Greek_eta, 0x1FC4,
Key_Greek_iota, Key_dead_acute, Key_Greek_omega, 0x1FF4,
Key_Greek_iota, Key_dead_acute, 0x1F00, 0x1F84,
Key_Greek_iota, Key_dead_acute, 0x1F01, 0x1F85,
Key_Greek_iota, Key_dead_acute, 0x1F08, 0x1F8C,
Key_Greek_iota, Key_dead_acute, 0x1F09, 0x1F8D,
Key_Greek_iota, Key_dead_acute, 0x1F20, 0x1F94,
Key_Greek_iota, Key_dead_acute, 0x1F21, 0x1F95,
Key_Greek_iota, Key_dead_acute, 0x1F28, 0x1F9C,
Key_Greek_iota, Key_dead_acute, 0x1F29, 0x1F9D,
Key_Greek_iota, Key_dead_acute, 0x1F60, 0x1FA4,
Key_Greek_iota, Key_dead_acute, 0x1F61, 0x1FA5,
Key_Greek_iota, Key_dead_acute, 0x1F68, 0x1FAC,
Key_Greek_iota, Key_dead_acute, 0x1F69, 0x1FAD,
Key_Greek_iota, Key_dead_tilde, Key_Greek_alpha, 0x1FB7,
Key_Greek_iota, Key_dead_tilde, Key_Greek_eta, 0x1FC7,
Key_Greek_iota, Key_dead_tilde, Key_Greek_omega, 0x1FF7,
Key_Greek_iota, Key_dead_tilde, 0x1F00, 0x1F86,
Key_Greek_iota, Key_dead_tilde, 0x1F01, 0x1F87,
Key_Greek_iota, Key_dead_tilde, 0x1F08, 0x1F8E,
Key_Greek_iota, Key_dead_tilde, 0x1F09, 0x1F8F,
Key_Greek_iota, Key_dead_tilde, 0x1F20, 0x1F96,
Key_Greek_iota, Key_dead_tilde, 0x1F21, 0x1F97,
Key_Greek_iota, Key_dead_tilde, 0x1F28, 0x1F9E,
Key_Greek_iota, Key_dead_tilde, 0x1F29, 0x1F9F,
Key_Greek_iota, Key_dead_tilde, 0x1F60, 0x1FA6,
Key_Greek_iota, Key_dead_tilde, 0x1F61, 0x1FA7,
Key_Greek_iota, Key_dead_tilde, 0x1F68, 0x1FAE,
Key_Greek_iota, Key_dead_tilde, 0x1F69, 0x1FAF,
Key_Greek_iota, Key_dead_psili, Key_Greek_ALPHA, 0x1F88,
Key_Greek_iota, Key_dead_psili, Key_Greek_ETA, 0x1F98,
Key_Greek_iota, Key_dead_psili, Key_Greek_OMEGA, 0x1FA8,
Key_Greek_iota, Key_dead_psili, Key_Greek_alpha, 0x1F80,
Key_Greek_iota, Key_dead_psili, Key_Greek_eta, 0x1F90,
Key_Greek_iota, Key_dead_psili, Key_Greek_omega, 0x1FA0,
Key_Greek_iota, Key_dead_dasia, Key_Greek_ALPHA, 0x1F89,
Key_Greek_iota, Key_dead_dasia, Key_Greek_ETA, 0x1F99,
Key_Greek_iota, Key_dead_dasia, Key_Greek_OMEGA, 0x1FA9,
Key_Greek_iota, Key_dead_dasia, Key_Greek_alpha, 0x1F81,
Key_Greek_iota, Key_dead_dasia, Key_Greek_eta, 0x1F91,
Key_Greek_iota, Key_dead_dasia, Key_Greek_omega, 0x1FA1,
Key_parenleft, Key_1, Key_0, Key_parenright, 0x2469,
Key_parenleft, Key_1, Key_1, Key_parenright, 0x246A,
Key_parenleft, Key_1, Key_2, Key_parenright, 0x246B,
Key_parenleft, Key_1, Key_3, Key_parenright, 0x246C,
Key_parenleft, Key_1, Key_4, Key_parenright, 0x246D,
Key_parenleft, Key_1, Key_5, Key_parenright, 0x246E,
Key_parenleft, Key_1, Key_6, Key_parenright, 0x246F,
Key_parenleft, Key_1, Key_7, Key_parenright, 0x2470,
Key_parenleft, Key_1, Key_8, Key_parenright, 0x2471,
Key_parenleft, Key_1, Key_9, Key_parenright, 0x2472,
Key_parenleft, Key_1, Key_KP_Space, Key_parenright, 0x246B,
Key_parenleft, Key_1, Key_KP_0, Key_parenright, 0x2469,
Key_parenleft, Key_1, Key_KP_1, Key_parenright, 0x246A,
Key_parenleft, Key_1, Key_KP_2, Key_parenright, 0x246B,
Key_parenleft, Key_1, Key_KP_3, Key_parenright, 0x246C,
Key_parenleft, Key_1, Key_KP_4, Key_parenright, 0x246D,
Key_parenleft, Key_1, Key_KP_5, Key_parenright, 0x246E,
Key_parenleft, Key_1, Key_KP_6, Key_parenright, 0x246F,
Key_parenleft, Key_1, Key_KP_7, Key_parenright, 0x2470,
Key_parenleft, Key_1, Key_KP_8, Key_parenright, 0x2471,
Key_parenleft, Key_1, Key_KP_9, Key_parenright, 0x2472,
Key_parenleft, Key_2, Key_0, Key_parenright, 0x2473,
Key_parenleft, Key_2, Key_1, Key_parenright, 0x3251,
Key_parenleft, Key_2, Key_2, Key_parenright, 0x3252,
Key_parenleft, Key_2, Key_3, Key_parenright, 0x3253,
Key_parenleft, Key_2, Key_4, Key_parenright, 0x3254,
Key_parenleft, Key_2, Key_5, Key_parenright, 0x3255,
Key_parenleft, Key_2, Key_6, Key_parenright, 0x3256,
Key_parenleft, Key_2, Key_7, Key_parenright, 0x3257,
Key_parenleft, Key_2, Key_8, Key_parenright, 0x3258,
Key_parenleft, Key_2, Key_9, Key_parenright, 0x3259,
Key_parenleft, Key_2, Key_KP_Space, Key_parenright, 0x3252,
Key_parenleft, Key_2, Key_KP_0, Key_parenright, 0x2473,
Key_parenleft, Key_2, Key_KP_1, Key_parenright, 0x3251,
Key_parenleft, Key_2, Key_KP_2, Key_parenright, 0x3252,
Key_parenleft, Key_2, Key_KP_3, Key_parenright, 0x3253,
Key_parenleft, Key_2, Key_KP_4, Key_parenright, 0x3254,
Key_parenleft, Key_2, Key_KP_5, Key_parenright, 0x3255,
Key_parenleft, Key_2, Key_KP_6, Key_parenright, 0x3256,
Key_parenleft, Key_2, Key_KP_7, Key_parenright, 0x3257,
Key_parenleft, Key_2, Key_KP_8, Key_parenright, 0x3258,
Key_parenleft, Key_2, Key_KP_9, Key_parenright, 0x3259,
Key_parenleft, Key_3, Key_0, Key_parenright, 0x325A,
Key_parenleft, Key_3, Key_1, Key_parenright, 0x325B,
Key_parenleft, Key_3, Key_2, Key_parenright, 0x325C,
Key_parenleft, Key_3, Key_3, Key_parenright, 0x325D,
Key_parenleft, Key_3, Key_4, Key_parenright, 0x325E,
Key_parenleft, Key_3, Key_5, Key_parenright, 0x325F,
Key_parenleft, Key_3, Key_6, Key_parenright, 0x32B1,
Key_parenleft, Key_3, Key_7, Key_parenright, 0x32B2,
Key_parenleft, Key_3, Key_8, Key_parenright, 0x32B3,
Key_parenleft, Key_3, Key_9, Key_parenright, 0x32B4,
Key_parenleft, Key_3, Key_KP_Space, Key_parenright, 0x325C,
Key_parenleft, Key_3, Key_KP_0, Key_parenright, 0x325A,
Key_parenleft, Key_3, Key_KP_1, Key_parenright, 0x325B,
Key_parenleft, Key_3, Key_KP_2, Key_parenright, 0x325C,
Key_parenleft, Key_3, Key_KP_3, Key_parenright, 0x325D,
Key_parenleft, Key_3, Key_KP_4, Key_parenright, 0x325E,
Key_parenleft, Key_3, Key_KP_5, Key_parenright, 0x325F,
Key_parenleft, Key_3, Key_KP_6, Key_parenright, 0x32B1,
Key_parenleft, Key_3, Key_KP_7, Key_parenright, 0x32B2,
Key_parenleft, Key_3, Key_KP_8, Key_parenright, 0x32B3,
Key_parenleft, Key_3, Key_KP_9, Key_parenright, 0x32B4,
Key_parenleft, Key_4, Key_0, Key_parenright, 0x32B5,
Key_parenleft, Key_4, Key_1, Key_parenright, 0x32B6,
Key_parenleft, Key_4, Key_2, Key_parenright, 0x32B7,
Key_parenleft, Key_4, Key_3, Key_parenright, 0x32B8,
Key_parenleft, Key_4, Key_4, Key_parenright, 0x32B9,
Key_parenleft, Key_4, Key_5, Key_parenright, 0x32BA,
Key_parenleft, Key_4, Key_6, Key_parenright, 0x32BB,
Key_parenleft, Key_4, Key_7, Key_parenright, 0x32BC,
Key_parenleft, Key_4, Key_8, Key_parenright, 0x32BD,
Key_parenleft, Key_4, Key_9, Key_parenright, 0x32BE,
Key_parenleft, Key_4, Key_KP_Space, Key_parenright, 0x32B7,
Key_parenleft, Key_4, Key_KP_0, Key_parenright, 0x32B5,
Key_parenleft, Key_4, Key_KP_1, Key_parenright, 0x32B6,
Key_parenleft, Key_4, Key_KP_2, Key_parenright, 0x32B7,
Key_parenleft, Key_4, Key_KP_3, Key_parenright, 0x32B8,
Key_parenleft, Key_4, Key_KP_4, Key_parenright, 0x32B9,
Key_parenleft, Key_4, Key_KP_5, Key_parenright, 0x32BA,
Key_parenleft, Key_4, Key_KP_6, Key_parenright, 0x32BB,
Key_parenleft, Key_4, Key_KP_7, Key_parenright, 0x32BC,
Key_parenleft, Key_4, Key_KP_8, Key_parenright, 0x32BD,
Key_parenleft, Key_4, Key_KP_9, Key_parenright, 0x32BE,
Key_parenleft, Key_5, Key_KP_0, Key_parenright, 0x32BF,
Key_parenleft, 0x1100, 0x1161, Key_parenright, 0x326E,
Key_parenleft, 0x1102, 0x1161, Key_parenright, 0x326F,
Key_parenleft, 0x1103, 0x1161, Key_parenright, 0x3270,
Key_parenleft, 0x1105, 0x1161, Key_parenright, 0x3271,
Key_parenleft, 0x1106, 0x1161, Key_parenright, 0x3272,
Key_parenleft, 0x1107, 0x1161, Key_parenright, 0x3273,
Key_parenleft, 0x1109, 0x1161, Key_parenright, 0x3274,
Key_parenleft, 0x110B, 0x1161, Key_parenright, 0x3275,
Key_parenleft, 0x110C, 0x1161, Key_parenright, 0x3276,
Key_parenleft, 0x110E, 0x1161, Key_parenright, 0x3277,
Key_parenleft, 0x110F, 0x1161, Key_parenright, 0x3278,
Key_parenleft, 0x1110, 0x1161, Key_parenright, 0x3279,
Key_parenleft, 0x1111, 0x1161, Key_parenright, 0x327A,
Key_parenleft, 0x1112, 0x1161, Key_parenright, 0x327B,
Key_parenleft, Key_KP_Space, Key_0, Key_parenright, 0x2473,
Key_parenleft, Key_KP_Space, Key_1, Key_parenright, 0x3251,
Key_parenleft, Key_KP_Space, Key_2, Key_parenright, 0x3252,
Key_parenleft, Key_KP_Space, Key_3, Key_parenright, 0x3253,
Key_parenleft, Key_KP_Space, Key_4, Key_parenright, 0x3254,
Key_parenleft, Key_KP_Space, Key_5, Key_parenright, 0x3255,
Key_parenleft, Key_KP_Space, Key_6, Key_parenright, 0x3256,
Key_parenleft, Key_KP_Space, Key_7, Key_parenright, 0x3257,
Key_parenleft, Key_KP_Space, Key_8, Key_parenright, 0x3258,
Key_parenleft, Key_KP_Space, Key_9, Key_parenright, 0x3259,
Key_parenleft, Key_KP_Space, Key_KP_Space, Key_parenright, 0x3252,
Key_parenleft, Key_KP_Space, Key_KP_0, Key_parenright, 0x2473,
Key_parenleft, Key_KP_Space, Key_KP_1, Key_parenright, 0x3251,
Key_parenleft, Key_KP_Space, Key_KP_2, Key_parenright, 0x3252,
Key_parenleft, Key_KP_Space, Key_KP_3, Key_parenright, 0x3253,
Key_parenleft, Key_KP_Space, Key_KP_4, Key_parenright, 0x3254,
Key_parenleft, Key_KP_Space, Key_KP_5, Key_parenright, 0x3255,
Key_parenleft, Key_KP_Space, Key_KP_6, Key_parenright, 0x3256,
Key_parenleft, Key_KP_Space, Key_KP_7, Key_parenright, 0x3257,
Key_parenleft, Key_KP_Space, Key_KP_8, Key_parenright, 0x3258,
Key_parenleft, Key_KP_Space, Key_KP_9, Key_parenright, 0x3259,
Key_parenleft, Key_KP_1, Key_0, Key_parenright, 0x2469,
Key_parenleft, Key_KP_1, Key_1, Key_parenright, 0x246A,
Key_parenleft, Key_KP_1, Key_2, Key_parenright, 0x246B,
Key_parenleft, Key_KP_1, Key_3, Key_parenright, 0x246C,
Key_parenleft, Key_KP_1, Key_4, Key_parenright, 0x246D,
Key_parenleft, Key_KP_1, Key_5, Key_parenright, 0x246E,
Key_parenleft, Key_KP_1, Key_6, Key_parenright, 0x246F,
Key_parenleft, Key_KP_1, Key_7, Key_parenright, 0x2470,
Key_parenleft, Key_KP_1, Key_8, Key_parenright, 0x2471,
Key_parenleft, Key_KP_1, Key_9, Key_parenright, 0x2472,
Key_parenleft, Key_KP_1, Key_KP_Space, Key_parenright, 0x246B,
Key_parenleft, Key_KP_1, Key_KP_0, Key_parenright, 0x2469,
Key_parenleft, Key_KP_1, Key_KP_1, Key_parenright, 0x246A,
Key_parenleft, Key_KP_1, Key_KP_2, Key_parenright, 0x246B,
Key_parenleft, Key_KP_1, Key_KP_3, Key_parenright, 0x246C,
Key_parenleft, Key_KP_1, Key_KP_4, Key_parenright, 0x246D,
Key_parenleft, Key_KP_1, Key_KP_5, Key_parenright, 0x246E,
Key_parenleft, Key_KP_1, Key_KP_6, Key_parenright, 0x246F,
Key_parenleft, Key_KP_1, Key_KP_7, Key_parenright, 0x2470,
Key_parenleft, Key_KP_1, Key_KP_8, Key_parenright, 0x2471,
Key_parenleft, Key_KP_1, Key_KP_9, Key_parenright, 0x2472,
Key_parenleft, Key_KP_2, Key_0, Key_parenright, 0x2473,
Key_parenleft, Key_KP_2, Key_1, Key_parenright, 0x3251,
Key_parenleft, Key_KP_2, Key_2, Key_parenright, 0x3252,
Key_parenleft, Key_KP_2, Key_3, Key_parenright, 0x3253,
Key_parenleft, Key_KP_2, Key_4, Key_parenright, 0x3254,
Key_parenleft, Key_KP_2, Key_5, Key_parenright, 0x3255,
Key_parenleft, Key_KP_2, Key_6, Key_parenright, 0x3256,
Key_parenleft, Key_KP_2, Key_7, Key_parenright, 0x3257,
Key_parenleft, Key_KP_2, Key_8, Key_parenright, 0x3258,
Key_parenleft, Key_KP_2, Key_9, Key_parenright, 0x3259,
Key_parenleft, Key_KP_2, Key_KP_Space, Key_parenright, 0x3252,
Key_parenleft, Key_KP_2, Key_KP_0, Key_parenright, 0x2473,
Key_parenleft, Key_KP_2, Key_KP_1, Key_parenright, 0x3251,
Key_parenleft, Key_KP_2, Key_KP_2, Key_parenright, 0x3252,
Key_parenleft, Key_KP_2, Key_KP_3, Key_parenright, 0x3253,
Key_parenleft, Key_KP_2, Key_KP_4, Key_parenright, 0x3254,
Key_parenleft, Key_KP_2, Key_KP_5, Key_parenright, 0x3255,
Key_parenleft, Key_KP_2, Key_KP_6, Key_parenright, 0x3256,
Key_parenleft, Key_KP_2, Key_KP_7, Key_parenright, 0x3257,
Key_parenleft, Key_KP_2, Key_KP_8, Key_parenright, 0x3258,
Key_parenleft, Key_KP_2, Key_KP_9, Key_parenright, 0x3259,
Key_parenleft, Key_KP_3, Key_0, Key_parenright, 0x325A,
Key_parenleft, Key_KP_3, Key_1, Key_parenright, 0x325B,
Key_parenleft, Key_KP_3, Key_2, Key_parenright, 0x325C,
Key_parenleft, Key_KP_3, Key_3, Key_parenright, 0x325D,
Key_parenleft, Key_KP_3, Key_4, Key_parenright, 0x325E,
Key_parenleft, Key_KP_3, Key_5, Key_parenright, 0x325F,
Key_parenleft, Key_KP_3, Key_6, Key_parenright, 0x32B1,
Key_parenleft, Key_KP_3, Key_7, Key_parenright, 0x32B2,
Key_parenleft, Key_KP_3, Key_8, Key_parenright, 0x32B3,
Key_parenleft, Key_KP_3, Key_9, Key_parenright, 0x32B4,
Key_parenleft, Key_KP_3, Key_KP_Space, Key_parenright, 0x325C,
Key_parenleft, Key_KP_3, Key_KP_0, Key_parenright, 0x325A,
Key_parenleft, Key_KP_3, Key_KP_1, Key_parenright, 0x325B,
Key_parenleft, Key_KP_3, Key_KP_2, Key_parenright, 0x325C,
Key_parenleft, Key_KP_3, Key_KP_3, Key_parenright, 0x325D,
Key_parenleft, Key_KP_3, Key_KP_4, Key_parenright, 0x325E,
Key_parenleft, Key_KP_3, Key_KP_5, Key_parenright, 0x325F,
Key_parenleft, Key_KP_3, Key_KP_6, Key_parenright, 0x32B1,
Key_parenleft, Key_KP_3, Key_KP_7, Key_parenright, 0x32B2,
Key_parenleft, Key_KP_3, Key_KP_8, Key_parenright, 0x32B3,
Key_parenleft, Key_KP_3, Key_KP_9, Key_parenright, 0x32B4,
Key_parenleft, Key_KP_4, Key_0, Key_parenright, 0x32B5,
Key_parenleft, Key_KP_4, Key_1, Key_parenright, 0x32B6,
Key_parenleft, Key_KP_4, Key_2, Key_parenright, 0x32B7,
Key_parenleft, Key_KP_4, Key_3, Key_parenright, 0x32B8,
Key_parenleft, Key_KP_4, Key_4, Key_parenright, 0x32B9,
Key_parenleft, Key_KP_4, Key_5, Key_parenright, 0x32BA,
Key_parenleft, Key_KP_4, Key_6, Key_parenright, 0x32BB,
Key_parenleft, Key_KP_4, Key_7, Key_parenright, 0x32BC,
Key_parenleft, Key_KP_4, Key_8, Key_parenright, 0x32BD,
Key_parenleft, Key_KP_4, Key_9, Key_parenright, 0x32BE,
Key_parenleft, Key_KP_4, Key_KP_Space, Key_parenright, 0x32B7,
Key_parenleft, Key_KP_4, Key_KP_0, Key_parenright, 0x32B5,
Key_parenleft, Key_KP_4, Key_KP_1, Key_parenright, 0x32B6,
Key_parenleft, Key_KP_4, Key_KP_2, Key_parenright, 0x32B7,
Key_parenleft, Key_KP_4, Key_KP_3, Key_parenright, 0x32B8,
Key_parenleft, Key_KP_4, Key_KP_4, Key_parenright, 0x32B9,
Key_parenleft, Key_KP_4, Key_KP_5, Key_parenright, 0x32BA,
Key_parenleft, Key_KP_4, Key_KP_6, Key_parenright, 0x32BB,
Key_parenleft, Key_KP_4, Key_KP_7, Key_parenright, 0x32BC,
Key_parenleft, Key_KP_4, Key_KP_8, Key_parenright, 0x32BD,
Key_parenleft, Key_KP_4, Key_KP_9, Key_parenright, 0x32BE,
Key_parenleft, Key_KP_5, Key_KP_0, Key_parenright, 0x32BF,
Key_Greek_iota, Key_apostrophe, Key_parenleft, Key_Greek_ALPHA, 0x1F8D,
Key_Greek_iota, Key_apostrophe, Key_parenleft, Key_Greek_ETA, 0x1F9D,
Key_Greek_iota, Key_apostrophe, Key_parenleft, Key_Greek_OMEGA, 0x1FAD,
Key_Greek_iota, Key_apostrophe, Key_parenleft, Key_Greek_alpha, 0x1F85,
Key_Greek_iota, Key_apostrophe, Key_parenleft, Key_Greek_eta, 0x1F95,
Key_Greek_iota, Key_apostrophe, Key_parenleft, Key_Greek_omega, 0x1FA5,
Key_Greek_iota, Key_apostrophe, Key_parenright, Key_Greek_ALPHA, 0x1F8C,
Key_Greek_iota, Key_apostrophe, Key_parenright, Key_Greek_ETA, 0x1F9C,
Key_Greek_iota, Key_apostrophe, Key_parenright, Key_Greek_OMEGA, 0x1FAC,
Key_Greek_iota, Key_apostrophe, Key_parenright, Key_Greek_alpha, 0x1F84,
Key_Greek_iota, Key_apostrophe, Key_parenright, Key_Greek_eta, 0x1F94,
Key_Greek_iota, Key_apostrophe, Key_parenright, Key_Greek_omega, 0x1FA4,
Key_Greek_iota, Key_apostrophe, Key_dead_psili, Key_Greek_ALPHA, 0x1F8C,
Key_Greek_iota, Key_apostrophe, Key_dead_psili, Key_Greek_ETA, 0x1F9C,
Key_Greek_iota, Key_apostrophe, Key_dead_psili, Key_Greek_OMEGA, 0x1FAC,
Key_Greek_iota, Key_apostrophe, Key_dead_psili, Key_Greek_alpha, 0x1F84,
Key_Greek_iota, Key_apostrophe, Key_dead_psili, Key_Greek_eta, 0x1F94,
Key_Greek_iota, Key_apostrophe, Key_dead_psili, Key_Greek_omega, 0x1FA4,
Key_Greek_iota, Key_apostrophe, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8D,
Key_Greek_iota, Key_apostrophe, Key_dead_dasia, Key_Greek_ETA, 0x1F9D,
Key_Greek_iota, Key_apostrophe, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAD,
Key_Greek_iota, Key_apostrophe, Key_dead_dasia, Key_Greek_alpha, 0x1F85,
Key_Greek_iota, Key_apostrophe, Key_dead_dasia, Key_Greek_eta, 0x1F95,
Key_Greek_iota, Key_apostrophe, Key_dead_dasia, Key_Greek_omega, 0x1FA5,
Key_Greek_iota, Key_grave, Key_parenleft, Key_Greek_ALPHA, 0x1F8B,
Key_Greek_iota, Key_grave, Key_parenleft, Key_Greek_ETA, 0x1F9B,
Key_Greek_iota, Key_grave, Key_parenleft, Key_Greek_OMEGA, 0x1FAB,
Key_Greek_iota, Key_grave, Key_parenleft, Key_Greek_alpha, 0x1F83,
Key_Greek_iota, Key_grave, Key_parenleft, Key_Greek_eta, 0x1F93,
Key_Greek_iota, Key_grave, Key_parenleft, Key_Greek_omega, 0x1FA3,
Key_Greek_iota, Key_grave, Key_parenright, Key_Greek_ALPHA, 0x1F8A,
Key_Greek_iota, Key_grave, Key_parenright, Key_Greek_ETA, 0x1F9A,
Key_Greek_iota, Key_grave, Key_parenright, Key_Greek_OMEGA, 0x1FAA,
Key_Greek_iota, Key_grave, Key_parenright, Key_Greek_alpha, 0x1F82,
Key_Greek_iota, Key_grave, Key_parenright, Key_Greek_eta, 0x1F92,
Key_Greek_iota, Key_grave, Key_parenright, Key_Greek_omega, 0x1FA2,
Key_Greek_iota, Key_grave, Key_dead_psili, Key_Greek_ALPHA, 0x1F8A,
Key_Greek_iota, Key_grave, Key_dead_psili, Key_Greek_ETA, 0x1F9A,
Key_Greek_iota, Key_grave, Key_dead_psili, Key_Greek_OMEGA, 0x1FAA,
Key_Greek_iota, Key_grave, Key_dead_psili, Key_Greek_alpha, 0x1F82,
Key_Greek_iota, Key_grave, Key_dead_psili, Key_Greek_eta, 0x1F92,
Key_Greek_iota, Key_grave, Key_dead_psili, Key_Greek_omega, 0x1FA2,
Key_Greek_iota, Key_grave, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8B,
Key_Greek_iota, Key_grave, Key_dead_dasia, Key_Greek_ETA, 0x1F9B,
Key_Greek_iota, Key_grave, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAB,
Key_Greek_iota, Key_grave, Key_dead_dasia, Key_Greek_alpha, 0x1F83,
Key_Greek_iota, Key_grave, Key_dead_dasia, Key_Greek_eta, 0x1F93,
Key_Greek_iota, Key_grave, Key_dead_dasia, Key_Greek_omega, 0x1FA3,
Key_Greek_iota, Key_asciitilde, Key_parenleft, Key_Greek_ALPHA, 0x1F8F,
Key_Greek_iota, Key_asciitilde, Key_parenleft, Key_Greek_ETA, 0x1F9F,
Key_Greek_iota, Key_asciitilde, Key_parenleft, Key_Greek_OMEGA, 0x1FAF,
Key_Greek_iota, Key_asciitilde, Key_parenleft, Key_Greek_alpha, 0x1F87,
Key_Greek_iota, Key_asciitilde, Key_parenleft, Key_Greek_eta, 0x1F97,
Key_Greek_iota, Key_asciitilde, Key_parenleft, Key_Greek_omega, 0x1FA7,
Key_Greek_iota, Key_asciitilde, Key_parenright, Key_Greek_ALPHA, 0x1F8E,
Key_Greek_iota, Key_asciitilde, Key_parenright, Key_Greek_ETA, 0x1F9E,
Key_Greek_iota, Key_asciitilde, Key_parenright, Key_Greek_OMEGA, 0x1FAE,
Key_Greek_iota, Key_asciitilde, Key_parenright, Key_Greek_alpha, 0x1F86,
Key_Greek_iota, Key_asciitilde, Key_parenright, Key_Greek_eta, 0x1F96,
Key_Greek_iota, Key_asciitilde, Key_parenright, Key_Greek_omega, 0x1FA6,
Key_Greek_iota, Key_asciitilde, Key_dead_psili, Key_Greek_ALPHA, 0x1F8E,
Key_Greek_iota, Key_asciitilde, Key_dead_psili, Key_Greek_ETA, 0x1F9E,
Key_Greek_iota, Key_asciitilde, Key_dead_psili, Key_Greek_OMEGA, 0x1FAE,
Key_Greek_iota, Key_asciitilde, Key_dead_psili, Key_Greek_alpha, 0x1F86,
Key_Greek_iota, Key_asciitilde, Key_dead_psili, Key_Greek_eta, 0x1F96,
Key_Greek_iota, Key_asciitilde, Key_dead_psili, Key_Greek_omega, 0x1FA6,
Key_Greek_iota, Key_asciitilde, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8F,
Key_Greek_iota, Key_asciitilde, Key_dead_dasia, Key_Greek_ETA, 0x1F9F,
Key_Greek_iota, Key_asciitilde, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAF,
Key_Greek_iota, Key_asciitilde, Key_dead_dasia, Key_Greek_alpha, 0x1F87,
Key_Greek_iota, Key_asciitilde, Key_dead_dasia, Key_Greek_eta, 0x1F97,
Key_Greek_iota, Key_asciitilde, Key_dead_dasia, Key_Greek_omega, 0x1FA7,
Key_Greek_iota, Key_acute, Key_parenleft, Key_Greek_ALPHA, 0x1F8D,
Key_Greek_iota, Key_acute, Key_parenleft, Key_Greek_ETA, 0x1F9D,
Key_Greek_iota, Key_acute, Key_parenleft, Key_Greek_OMEGA, 0x1FAD,
Key_Greek_iota, Key_acute, Key_parenleft, Key_Greek_alpha, 0x1F85,
Key_Greek_iota, Key_acute, Key_parenleft, Key_Greek_eta, 0x1F95,
Key_Greek_iota, Key_acute, Key_parenleft, Key_Greek_omega, 0x1FA5,
Key_Greek_iota, Key_acute, Key_parenright, Key_Greek_ALPHA, 0x1F8C,
Key_Greek_iota, Key_acute, Key_parenright, Key_Greek_ETA, 0x1F9C,
Key_Greek_iota, Key_acute, Key_parenright, Key_Greek_OMEGA, 0x1FAC,
Key_Greek_iota, Key_acute, Key_parenright, Key_Greek_alpha, 0x1F84,
Key_Greek_iota, Key_acute, Key_parenright, Key_Greek_eta, 0x1F94,
Key_Greek_iota, Key_acute, Key_parenright, Key_Greek_omega, 0x1FA4,
Key_Greek_iota, Key_acute, Key_dead_psili, Key_Greek_ALPHA, 0x1F8C,
Key_Greek_iota, Key_acute, Key_dead_psili, Key_Greek_ETA, 0x1F9C,
Key_Greek_iota, Key_acute, Key_dead_psili, Key_Greek_OMEGA, 0x1FAC,
Key_Greek_iota, Key_acute, Key_dead_psili, Key_Greek_alpha, 0x1F84,
Key_Greek_iota, Key_acute, Key_dead_psili, Key_Greek_eta, 0x1F94,
Key_Greek_iota, Key_acute, Key_dead_psili, Key_Greek_omega, 0x1FA4,
Key_Greek_iota, Key_acute, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8D,
Key_Greek_iota, Key_acute, Key_dead_dasia, Key_Greek_ETA, 0x1F9D,
Key_Greek_iota, Key_acute, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAD,
Key_Greek_iota, Key_acute, Key_dead_dasia, Key_Greek_alpha, 0x1F85,
Key_Greek_iota, Key_acute, Key_dead_dasia, Key_Greek_eta, 0x1F95,
Key_Greek_iota, Key_acute, Key_dead_dasia, Key_Greek_omega, 0x1FA5,
Key_Greek_iota, Key_dead_grave, Key_parenleft, Key_Greek_ALPHA, 0x1F8B,
Key_Greek_iota, Key_dead_grave, Key_parenleft, Key_Greek_ETA, 0x1F9B,
Key_Greek_iota, Key_dead_grave, Key_parenleft, Key_Greek_OMEGA, 0x1FAB,
Key_Greek_iota, Key_dead_grave, Key_parenleft, Key_Greek_alpha, 0x1F83,
Key_Greek_iota, Key_dead_grave, Key_parenleft, Key_Greek_eta, 0x1F93,
Key_Greek_iota, Key_dead_grave, Key_parenleft, Key_Greek_omega, 0x1FA3,
Key_Greek_iota, Key_dead_grave, Key_parenright, Key_Greek_ALPHA, 0x1F8A,
Key_Greek_iota, Key_dead_grave, Key_parenright, Key_Greek_ETA, 0x1F9A,
Key_Greek_iota, Key_dead_grave, Key_parenright, Key_Greek_OMEGA, 0x1FAA,
Key_Greek_iota, Key_dead_grave, Key_parenright, Key_Greek_alpha, 0x1F82,
Key_Greek_iota, Key_dead_grave, Key_parenright, Key_Greek_eta, 0x1F92,
Key_Greek_iota, Key_dead_grave, Key_parenright, Key_Greek_omega, 0x1FA2,
Key_Greek_iota, Key_dead_grave, Key_dead_psili, Key_Greek_ALPHA, 0x1F8A,
Key_Greek_iota, Key_dead_grave, Key_dead_psili, Key_Greek_ETA, 0x1F9A,
Key_Greek_iota, Key_dead_grave, Key_dead_psili, Key_Greek_OMEGA, 0x1FAA,
Key_Greek_iota, Key_dead_grave, Key_dead_psili, Key_Greek_alpha, 0x1F82,
Key_Greek_iota, Key_dead_grave, Key_dead_psili, Key_Greek_eta, 0x1F92,
Key_Greek_iota, Key_dead_grave, Key_dead_psili, Key_Greek_omega, 0x1FA2,
Key_Greek_iota, Key_dead_grave, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8B,
Key_Greek_iota, Key_dead_grave, Key_dead_dasia, Key_Greek_ETA, 0x1F9B,
Key_Greek_iota, Key_dead_grave, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAB,
Key_Greek_iota, Key_dead_grave, Key_dead_dasia, Key_Greek_alpha, 0x1F83,
Key_Greek_iota, Key_dead_grave, Key_dead_dasia, Key_Greek_eta, 0x1F93,
Key_Greek_iota, Key_dead_grave, Key_dead_dasia, Key_Greek_omega, 0x1FA3,
Key_Greek_iota, Key_dead_acute, Key_parenleft, Key_Greek_ALPHA, 0x1F8D,
Key_Greek_iota, Key_dead_acute, Key_parenleft, Key_Greek_ETA, 0x1F9D,
Key_Greek_iota, Key_dead_acute, Key_parenleft, Key_Greek_OMEGA, 0x1FAD,
Key_Greek_iota, Key_dead_acute, Key_parenleft, Key_Greek_alpha, 0x1F85,
Key_Greek_iota, Key_dead_acute, Key_parenleft, Key_Greek_eta, 0x1F95,
Key_Greek_iota, Key_dead_acute, Key_parenleft, Key_Greek_omega, 0x1FA5,
Key_Greek_iota, Key_dead_acute, Key_parenright, Key_Greek_ALPHA, 0x1F8C,
Key_Greek_iota, Key_dead_acute, Key_parenright, Key_Greek_ETA, 0x1F9C,
Key_Greek_iota, Key_dead_acute, Key_parenright, Key_Greek_OMEGA, 0x1FAC,
Key_Greek_iota, Key_dead_acute, Key_parenright, Key_Greek_alpha, 0x1F84,
Key_Greek_iota, Key_dead_acute, Key_parenright, Key_Greek_eta, 0x1F94,
Key_Greek_iota, Key_dead_acute, Key_parenright, Key_Greek_omega, 0x1FA4,
Key_Greek_iota, Key_dead_acute, Key_dead_psili, Key_Greek_ALPHA, 0x1F8C,
Key_Greek_iota, Key_dead_acute, Key_dead_psili, Key_Greek_ETA, 0x1F9C,
Key_Greek_iota, Key_dead_acute, Key_dead_psili, Key_Greek_OMEGA, 0x1FAC,
Key_Greek_iota, Key_dead_acute, Key_dead_psili, Key_Greek_alpha, 0x1F84,
Key_Greek_iota, Key_dead_acute, Key_dead_psili, Key_Greek_eta, 0x1F94,
Key_Greek_iota, Key_dead_acute, Key_dead_psili, Key_Greek_omega, 0x1FA4,
Key_Greek_iota, Key_dead_acute, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8D,
Key_Greek_iota, Key_dead_acute, Key_dead_dasia, Key_Greek_ETA, 0x1F9D,
Key_Greek_iota, Key_dead_acute, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAD,
Key_Greek_iota, Key_dead_acute, Key_dead_dasia, Key_Greek_alpha, 0x1F85,
Key_Greek_iota, Key_dead_acute, Key_dead_dasia, Key_Greek_eta, 0x1F95,
Key_Greek_iota, Key_dead_acute, Key_dead_dasia, Key_Greek_omega, 0x1FA5,
Key_Greek_iota, Key_dead_tilde, Key_parenleft, Key_Greek_ALPHA, 0x1F8F,
Key_Greek_iota, Key_dead_tilde, Key_parenleft, Key_Greek_ETA, 0x1F9F,
Key_Greek_iota, Key_dead_tilde, Key_parenleft, Key_Greek_OMEGA, 0x1FAF,
Key_Greek_iota, Key_dead_tilde, Key_parenleft, Key_Greek_alpha, 0x1F87,
Key_Greek_iota, Key_dead_tilde, Key_parenleft, Key_Greek_eta, 0x1F97,
Key_Greek_iota, Key_dead_tilde, Key_parenleft, Key_Greek_omega, 0x1FA7,
Key_Greek_iota, Key_dead_tilde, Key_parenright, Key_Greek_ALPHA, 0x1F8E,
Key_Greek_iota, Key_dead_tilde, Key_parenright, Key_Greek_ETA, 0x1F9E,
Key_Greek_iota, Key_dead_tilde, Key_parenright, Key_Greek_OMEGA, 0x1FAE,
Key_Greek_iota, Key_dead_tilde, Key_parenright, Key_Greek_alpha, 0x1F86,
Key_Greek_iota, Key_dead_tilde, Key_parenright, Key_Greek_eta, 0x1F96,
Key_Greek_iota, Key_dead_tilde, Key_parenright, Key_Greek_omega, 0x1FA6,
Key_Greek_iota, Key_dead_tilde, Key_dead_psili, Key_Greek_ALPHA, 0x1F8E,
Key_Greek_iota, Key_dead_tilde, Key_dead_psili, Key_Greek_ETA, 0x1F9E,
Key_Greek_iota, Key_dead_tilde, Key_dead_psili, Key_Greek_OMEGA, 0x1FAE,
Key_Greek_iota, Key_dead_tilde, Key_dead_psili, Key_Greek_alpha, 0x1F86,
Key_Greek_iota, Key_dead_tilde, Key_dead_psili, Key_Greek_eta, 0x1F96,
Key_Greek_iota, Key_dead_tilde, Key_dead_psili, Key_Greek_omega, 0x1FA6,
Key_Greek_iota, Key_dead_tilde, Key_dead_dasia, Key_Greek_ALPHA, 0x1F8F,
Key_Greek_iota, Key_dead_tilde, Key_dead_dasia, Key_Greek_ETA, 0x1F9F,
Key_Greek_iota, Key_dead_tilde, Key_dead_dasia, Key_Greek_OMEGA, 0x1FAF,
Key_Greek_iota, Key_dead_tilde, Key_dead_dasia, Key_Greek_alpha, 0x1F87,
Key_Greek_iota, Key_dead_tilde, Key_dead_dasia, Key_Greek_eta, 0x1F97,
};

#endif
