#line 1034 "ifupdown.nw"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <assert.h>
#line 1045 "ifupdown.nw"
#include "header.h"
#line 1273 "ifupdown.nw"
#include <errno.h>
#line 1407 "ifupdown.nw"
#include <ctype.h>
#line 1250 "ifupdown.nw"
static int get_line(char **result, size_t *result_len, FILE *f, int *line);
#line 1477 "ifupdown.nw"
static char *next_word(char *buf, char *word, int maxlen);
#line 1714 "ifupdown.nw"
static address_family *get_address_family(address_family *af[], char *name);
#line 1749 "ifupdown.nw"
static method *get_method(address_family *af, char *name);
#line 1810 "ifupdown.nw"
static int duplicate_if(interface_defn *ifa, interface_defn *ifb);
#line 1952 "ifupdown.nw"
allowup_defn *get_allowup(allowup_defn **allowups, char *name);

#line 1990 "ifupdown.nw"
allowup_defn *add_allow_up(char *filename, int line,
	 allowup_defn *allow_up, char *iface_name);
#line 1175 "ifupdown.nw"
interfaces_file *read_interfaces(char *filename) {
	
#line 1220 "ifupdown.nw"
FILE *f;
int line;
#line 1257 "ifupdown.nw"
char *buf = NULL;
size_t buf_len = 0;
#line 1457 "ifupdown.nw"
interface_defn *currif = NULL;
mapping_defn *currmap = NULL;
enum { NONE, IFACE, MAPPING } currently_processing = NONE;
#line 1468 "ifupdown.nw"
char firstword[80];
char *rest;
#line 1177 "ifupdown.nw"
	interfaces_file *defn;

	
#line 1197 "ifupdown.nw"
defn = malloc(sizeof(interfaces_file));
if (defn == NULL) {
	return NULL;
}
defn->allowups = NULL;
defn->mappings = NULL;
defn->ifaces = NULL;
#line 1180 "ifupdown.nw"
	
#line 1225 "ifupdown.nw"
f = fopen(filename, "r");
if ( f == NULL ) return NULL;
line = 0;

#line 1182 "ifupdown.nw"
	while (
#line 1265 "ifupdown.nw"
get_line(&buf,&buf_len,f,&line)
#line 1182 "ifupdown.nw"
                                             ) {
		
#line 1504 "ifupdown.nw"
rest = next_word(buf, firstword, 80);
if (rest == NULL) continue; /* blank line */

if (strcmp(firstword, "mapping") == 0) {
	
#line 1556 "ifupdown.nw"
currmap = malloc(sizeof(mapping_defn));
if (currmap == NULL) {
	
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1559 "ifupdown.nw"
}
#line 1563 "ifupdown.nw"
currmap->max_matches = 0;
currmap->n_matches = 0;
currmap->match = NULL;

while((rest = next_word(rest, firstword, 80))) {
	if (currmap->max_matches == currmap->n_matches) {
		char **tmp;
		currmap->max_matches = currmap->max_matches * 2 + 1;
		tmp = realloc(currmap->match, 
			sizeof(*tmp) * currmap->max_matches);
		if (tmp == NULL) {
			currmap->max_matches = (currmap->max_matches - 1) / 2;
			
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1576 "ifupdown.nw"
		}
		currmap->match = tmp;
	}

	currmap->match[currmap->n_matches++] = strdup(firstword);
}
#line 1585 "ifupdown.nw"
currmap->script = NULL;

currmap->max_mappings = 0;
currmap->n_mappings = 0;
currmap->mapping = NULL;
#line 1593 "ifupdown.nw"
{
	mapping_defn **where = &defn->mappings;
	while(*where != NULL) {
		where = &(*where)->next;
	}
	*where = currmap;
	currmap->next = NULL;
}
#line 1509 "ifupdown.nw"
	currently_processing = MAPPING;
} else if (strcmp(firstword, "iface") == 0) {
	
#line 1645 "ifupdown.nw"
{
	
#line 1678 "ifupdown.nw"
char iface_name[80];
char address_family_name[80];
char method_name[80];

#line 1648 "ifupdown.nw"
	
#line 1666 "ifupdown.nw"
currif = malloc(sizeof(interface_defn));
if (!currif) {
	
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1669 "ifupdown.nw"
}

#line 1650 "ifupdown.nw"
	
#line 1684 "ifupdown.nw"
rest = next_word(rest, iface_name, 80);
rest = next_word(rest, address_family_name, 80);
rest = next_word(rest, method_name, 80);

if (rest == NULL) {
	
#line 2046 "ifupdown.nw"
fprintf(stderr, "%s:%d: too few parameters for iface line\n", filename, line);
return NULL;
#line 1690 "ifupdown.nw"
}

if (rest[0] != '\0') {
	
#line 2051 "ifupdown.nw"
fprintf(stderr, "%s:%d: too many parameters for iface line\n", filename, line);
return NULL;
#line 1694 "ifupdown.nw"
}

#line 1652 "ifupdown.nw"
	
#line 1700 "ifupdown.nw"
currif->logical_iface = strdup(iface_name);
if (!currif->logical_iface) {
	
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1703 "ifupdown.nw"
}
#line 1653 "ifupdown.nw"
	
#line 1718 "ifupdown.nw"
currif->address_family = get_address_family(addr_fams, address_family_name);
if (!currif->address_family) {
	
#line 2056 "ifupdown.nw"
fprintf(stderr, "%s:%d: unknown address type\n", filename, line);
return NULL;
#line 1721 "ifupdown.nw"
}
#line 1654 "ifupdown.nw"
	
#line 1753 "ifupdown.nw"
currif->method = get_method(currif->address_family, method_name);
if (!currif->method) {
	
#line 2061 "ifupdown.nw"
fprintf(stderr, "%s:%d: unknown method\n", filename, line);
return NULL;
#line 1756 "ifupdown.nw"
	return NULL; /* FIXME */
}
#line 1655 "ifupdown.nw"
	
#line 1776 "ifupdown.nw"
currif->automatic = 1;
currif->max_options = 0;
currif->n_options = 0;
currif->option = NULL;

#line 1657 "ifupdown.nw"
	
#line 1792 "ifupdown.nw"
{
	interface_defn **where = &defn->ifaces; 
	while(*where != NULL) {
		if (duplicate_if(*where, currif)) {
			
#line 2066 "ifupdown.nw"
fprintf(stderr, "%s:%d: duplicate interface\n", filename, line);
return NULL;
#line 1797 "ifupdown.nw"
		}
		where = &(*where)->next;
	}

	*where = currif;
	currif->next = NULL;
}
#line 1658 "ifupdown.nw"
}
#line 1512 "ifupdown.nw"
	currently_processing = IFACE;
} else if (strcmp(firstword, "auto") == 0) {
	
#line 1931 "ifupdown.nw"
allowup_defn *auto_ups = get_allowup(&defn->allowups, "auto");
if (!auto_ups) {
	
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1934 "ifupdown.nw"
}
while((rest = next_word(rest, firstword, 80))) {
	if (!add_allow_up(filename, line, auto_ups, firstword))
		return NULL;
}
#line 1515 "ifupdown.nw"
	currently_processing = NONE;
} else if (strncmp(firstword, "allow-", 6) == 0 && strlen(firstword) > 6) {
	
#line 1941 "ifupdown.nw"
allowup_defn *allow_ups = get_allowup(&defn->allowups, firstword + 6);
if (!allow_ups) {
	
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1944 "ifupdown.nw"
}
while((rest = next_word(rest, firstword, 80))) {
	if (!add_allow_up(filename, line, allow_ups, firstword))
		return NULL;
}
#line 1518 "ifupdown.nw"
	currently_processing = NONE;
} else {
	
#line 1525 "ifupdown.nw"
switch(currently_processing) {
	case IFACE:
		
#line 1831 "ifupdown.nw"
if (strcmp(firstword, "post-up") == 0) {
	strcpy(firstword, "up");
}
if (strcmp(firstword, "pre-down") == 0) {
	strcpy(firstword, "down");
} 
#line 1840 "ifupdown.nw"
{
	int i;

	if (strlen (rest) == 0) {
		
#line 2092 "ifupdown.nw"
fprintf(stderr, "%s:%d: option with empty value\n", filename, line);
return NULL;
#line 1845 "ifupdown.nw"
	}

	if (strcmp(firstword, "pre-up") != 0 
	    && strcmp(firstword, "up") != 0
	    && strcmp(firstword, "down") != 0
	    && strcmp(firstword, "post-down") != 0)
        {
		for (i = 0; i < currif->n_options; i++) {
			if (strcmp(currif->option[i].name, firstword) == 0) {
				
#line 2077 "ifupdown.nw"
fprintf(stderr, "%s:%d: duplicate option\n", filename, line);
return NULL;
#line 1855 "ifupdown.nw"
			}
		}
	}
}
#line 1867 "ifupdown.nw"
if (currif->n_options >= currif->max_options) {
	
#line 1912 "ifupdown.nw"
{
	variable *opt;
	currif->max_options = currif->max_options + 10;
	opt = realloc(currif->option, sizeof(*opt) * currif->max_options);
	if (opt == NULL) {
		
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1918 "ifupdown.nw"
	}
	currif->option = opt;
}
#line 1869 "ifupdown.nw"
}

currif->option[currif->n_options].name = strdup(firstword);
currif->option[currif->n_options].value = strdup(rest);

if (!currif->option[currif->n_options].name) {
	
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1876 "ifupdown.nw"
}

if (!currif->option[currif->n_options].value) {
	
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1880 "ifupdown.nw"
}

currif->n_options++;	
#line 1528 "ifupdown.nw"
		break;
	case MAPPING:
		
#line 1608 "ifupdown.nw"
if (strcmp(firstword, "script") == 0) {
	
#line 1618 "ifupdown.nw"
if (currmap->script != NULL) {
	
#line 2082 "ifupdown.nw"
fprintf(stderr, "%s:%d: duplicate script in mapping\n", filename, line);
return NULL;
#line 1620 "ifupdown.nw"
} else {
	currmap->script = strdup(rest);
}
#line 1610 "ifupdown.nw"
} else if (strcmp(firstword, "map") == 0) {
	
#line 1626 "ifupdown.nw"
if (currmap->max_mappings == currmap->n_mappings) {
	char **opt;
	currmap->max_mappings = currmap->max_mappings * 2 + 1;
	opt = realloc(currmap->mapping, sizeof(*opt) * currmap->max_mappings);
	if (opt == NULL) {
		
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1632 "ifupdown.nw"
	}
	currmap->mapping = opt;
}
currmap->mapping[currmap->n_mappings] = strdup(rest);
currmap->n_mappings++;
#line 1612 "ifupdown.nw"
} else {
	
#line 2087 "ifupdown.nw"
fprintf(stderr, "%s:%d: misplaced option\n", filename, line);
return NULL;
#line 1614 "ifupdown.nw"
}
#line 1531 "ifupdown.nw"
		break;
	case NONE:
	default:
		
#line 2087 "ifupdown.nw"
fprintf(stderr, "%s:%d: misplaced option\n", filename, line);
return NULL;
#line 1535 "ifupdown.nw"
}
#line 1521 "ifupdown.nw"
}
#line 1184 "ifupdown.nw"
	}
	if (
#line 1277 "ifupdown.nw"
ferror(f) != 0
#line 1185 "ifupdown.nw"
                                           ) {
		
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1187 "ifupdown.nw"
	}

	
#line 1231 "ifupdown.nw"
fclose(f);
line = -1;
#line 1190 "ifupdown.nw"
	
#line 1207 "ifupdown.nw"
    currif = defn->ifaces;
    while (currif) {
       
#line 1890 "ifupdown.nw"
int metric_search_i = 0;
int metric_definition_found = 0;
for (; metric_search_i < currif->n_options; metric_search_i++) {
   if (!strcmp("metric", currif->option[metric_search_i].name)) {
	metric_definition_found = 1;
	break;
   }
}

if (!metric_definition_found) {
   
#line 1912 "ifupdown.nw"
{
	variable *opt;
	currif->max_options = currif->max_options + 10;
	opt = realloc(currif->option, sizeof(*opt) * currif->max_options);
	if (opt == NULL) {
		
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 1918 "ifupdown.nw"
	}
	currif->option = opt;
}
#line 1901 "ifupdown.nw"
   currif->option[currif->n_options].name = strdup("metric");
   currif->option[currif->n_options].value = strdup("100");
   currif->n_options++;
}

#line 1210 "ifupdown.nw"
       currif = currif->next;
    }

#line 1192 "ifupdown.nw"
	return defn;
}
#line 1290 "ifupdown.nw"
static int get_line(char **result, size_t *result_len, FILE *f, int *line) {
	
#line 1315 "ifupdown.nw"
size_t pos;

#line 1293 "ifupdown.nw"
	do {
		
#line 1322 "ifupdown.nw"
pos = 0;
#line 1295 "ifupdown.nw"
		
#line 1333 "ifupdown.nw"
do {
	
#line 1354 "ifupdown.nw"
if (*result_len - pos < 10) {
	char *newstr = realloc(*result, *result_len * 2 + 80);
	if (newstr == NULL) {
		return 0;
	}
	*result = newstr;
	*result_len = *result_len * 2 + 80;
}
#line 1335 "ifupdown.nw"
	
#line 1383 "ifupdown.nw"
if (!fgets(*result + pos, *result_len - pos, f)) {
	if (ferror(f) == 0 && pos == 0) return 0;
	if (ferror(f) != 0) return 0;
}
pos += strlen(*result + pos);
#line 1336 "ifupdown.nw"
} while(
#line 1374 "ifupdown.nw"
pos == *result_len - 1 && (*result)[pos-1] != '\n'
#line 1336 "ifupdown.nw"
                                   );

#line 1395 "ifupdown.nw"
if (pos != 0 && (*result)[pos-1] == '\n') {
	(*result)[--pos] = '\0';
}

#line 1340 "ifupdown.nw"
(*line)++;

assert( (*result)[pos] == '\0' );
#line 1296 "ifupdown.nw"
		
#line 1411 "ifupdown.nw"
{ 
	int first = 0; 
	while (isspace((*result)[first]) && (*result)[first]) {
		first++;
	}

	memmove(*result, *result + first, pos - first + 1);
	pos -= first;
}
#line 1297 "ifupdown.nw"
	} while (
#line 1435 "ifupdown.nw"
(*result)[0] == '#'
#line 1297 "ifupdown.nw"
                               );

	while (
#line 1439 "ifupdown.nw"
(*result)[pos-1] == '\\'
#line 1299 "ifupdown.nw"
                               ) {
		
#line 1443 "ifupdown.nw"
(*result)[--pos] = '\0';
#line 1301 "ifupdown.nw"
		
#line 1333 "ifupdown.nw"
do {
	
#line 1354 "ifupdown.nw"
if (*result_len - pos < 10) {
	char *newstr = realloc(*result, *result_len * 2 + 80);
	if (newstr == NULL) {
		return 0;
	}
	*result = newstr;
	*result_len = *result_len * 2 + 80;
}
#line 1335 "ifupdown.nw"
	
#line 1383 "ifupdown.nw"
if (!fgets(*result + pos, *result_len - pos, f)) {
	if (ferror(f) == 0 && pos == 0) return 0;
	if (ferror(f) != 0) return 0;
}
pos += strlen(*result + pos);
#line 1336 "ifupdown.nw"
} while(
#line 1374 "ifupdown.nw"
pos == *result_len - 1 && (*result)[pos-1] != '\n'
#line 1336 "ifupdown.nw"
                                   );

#line 1395 "ifupdown.nw"
if (pos != 0 && (*result)[pos-1] == '\n') {
	(*result)[--pos] = '\0';
}

#line 1340 "ifupdown.nw"
(*line)++;

assert( (*result)[pos] == '\0' );
#line 1302 "ifupdown.nw"
	}

	
#line 1423 "ifupdown.nw"
while (isspace((*result)[pos-1])) { /* remove trailing whitespace */
	pos--;
}
(*result)[pos] = '\0';

#line 1306 "ifupdown.nw"
	return 1;
}
#line 1481 "ifupdown.nw"
static char *next_word(char *buf, char *word, int maxlen) {
	if (!buf) return NULL;
	if (!*buf) return NULL;

	while(!isspace(*buf) && *buf) {
		if (maxlen-- > 1) *word++ = *buf;
		buf++;
	}
	if (maxlen > 0) *word = '\0';

	while(isspace(*buf) && *buf) buf++;

	return buf;
}
#line 1730 "ifupdown.nw"
static address_family *get_address_family(address_family *af[], char *name) {
	int i;
	for (i = 0; af[i]; i++) {
		if (strcmp(af[i]->name, name) == 0) {
			return af[i];
		}
	}
	return NULL;
}
#line 1761 "ifupdown.nw"
static method *get_method(address_family *af, char *name) {
	int i;
	for (i = 0; i < af->n_methods; i++) {
		if (strcmp(af->method[i].name, name) == 0) {
			return &af->method[i];
		}
	}
	return NULL;
}
#line 1814 "ifupdown.nw"
static int duplicate_if(interface_defn *ifa, interface_defn *ifb) {
	if (strcmp(ifa->logical_iface, ifb->logical_iface) != 0) return 0;
	if (ifa->address_family != ifb->address_family) return 0;
	return 1;
}
#line 1955 "ifupdown.nw"
allowup_defn *get_allowup(allowup_defn **allowups, char *name) {
	for (; *allowups; allowups = &(*allowups)->next) {
		if (strcmp((*allowups)->when, name) == 0) break;
	}
	if (*allowups == NULL) {
		*allowups = malloc(sizeof(allowup_defn));
		if (*allowups == NULL) return NULL;
		(*allowups)->when = strdup(name);
		(*allowups)->next = NULL;
		(*allowups)->max_interfaces = 0;
		(*allowups)->n_interfaces = 0;
		(*allowups)->interfaces = NULL;
	}
	return *allowups;
}
#line 1980 "ifupdown.nw"
allowup_defn *find_allowup(interfaces_file *defn, char *name) {
	allowup_defn *allowups = defn->allowups;
	for (; allowups; allowups = allowups->next) {
		if (strcmp(allowups->when, name) == 0) break;
	}
	return allowups;
}
#line 1995 "ifupdown.nw"
allowup_defn *add_allow_up(char *filename, int line,
	allowup_defn *allow_up, char *iface_name)
{
	
#line 2005 "ifupdown.nw"
{
	int i;

	for (i = 0; i < allow_up->n_interfaces; i++) {
		if (strcmp(iface_name, allow_up->interfaces[i]) == 0) {
			
#line 2071 "ifupdown.nw"
fprintf(stderr, "%s:%d: interface %s declared allow-%s twice\n", 
	filename, line, iface_name, allow_up->when);
return NULL;
#line 2011 "ifupdown.nw"
		}
	}
}
#line 1999 "ifupdown.nw"
	
#line 2017 "ifupdown.nw"
if (allow_up->n_interfaces == allow_up->max_interfaces) {
	char **tmp;
	allow_up->max_interfaces *= 2;
	allow_up->max_interfaces++;
	tmp = realloc(allow_up->interfaces, 
		sizeof(*tmp) * allow_up->max_interfaces);
	if (tmp == NULL) {
		
#line 2041 "ifupdown.nw"
perror(filename);
return NULL;
#line 2025 "ifupdown.nw"
	}
	allow_up->interfaces = tmp;
}

allow_up->interfaces[allow_up->n_interfaces] = strdup(iface_name);
allow_up->n_interfaces++;
#line 2000 "ifupdown.nw"
	return allow_up;
}
