/*
A small wrapper utility to load indicators and put them as menu items
into the gnome-panel using it's applet interface.

Copyright 2009 Canonical Ltd.

Authors:
    Ted Gould <ted@canonical.com>
    Christoph Korn <c_korn@gmx.de>
    Cody Russell <crussell@canonical.com>
    Conor Curran <conor.curran@canonical.com>
    Charles Kerr <charles.kerr@canonical.com>

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License version 3, as published
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranties of
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "config.h"

#include <unistd.h>
#include <locale.h>

#include <glib/gi18n.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>

#include <libdbusmenu-glib/server.h>

#include <gtk/gtk.h>

#include <libindicator/indicator-service.h>

#include "session-dbus.h"
#include "session-menu-mgr.h"
#include "shared-names.h"
#include "users-service-dbus.h"

static SessionDbus * session_dbus = NULL;
static GMainLoop * mainloop = NULL;


/* When the service interface starts to shutdown,
   we should follow it. */
void
service_shutdown (IndicatorService * service, gpointer user_data)
{
  if (mainloop != NULL)
    {
      g_debug ("Service shutdown");
      g_main_loop_quit (mainloop);
    }
}

static inline gboolean
is_greeter_mode (void)
{
  return !g_strcmp0 (g_getenv ("INDICATOR_GREETER_MODE"), "1");
}

/* Main, is well, main.  It brings everything up and throws
   us into the mainloop of no return. */
int
main (int argc, char ** argv)
{
  /* Setting up i18n and gettext.
     Apparently we need all of these. */
  setlocale (LC_ALL, "");
  bindtextdomain (GETTEXT_PACKAGE, GNOMELOCALEDIR);
  textdomain (GETTEXT_PACKAGE);

  IndicatorService * service = indicator_service_new_version (INDICATOR_SESSION_DBUS_NAME,
      		                                              INDICATOR_SESSION_DBUS_VERSION);
  g_signal_connect (G_OBJECT(service), INDICATOR_SERVICE_SIGNAL_SHUTDOWN,
                    G_CALLBACK(service_shutdown), NULL);

  session_dbus = session_dbus_new();

  SessionMenuMgr * menu_mgr = session_menu_mgr_new (session_dbus, is_greeter_mode());
  DbusmenuServer* server = dbusmenu_server_new (INDICATOR_SESSION_DBUS_OBJECT);
  dbusmenu_server_set_root (server, session_menu_mgr_get_menu (menu_mgr));

  mainloop = g_main_loop_new(NULL, FALSE);
  g_main_loop_run(mainloop);

  return 0;
}

