/***************************************************************************
                          dvbpanel.h  -  description
                             -------------------
    begin                : Mon Jan 19 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/07/21 19:40:30 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DVBPANEL_H
#define DVBPANEL_H

#include <qwidget.h>
#include <qcombobox.h>
#include <qtoolbutton.h>
#include <qptrlist.h>
#include <qtimer.h>
#include <qsplitter.h>

#include <kapp.h>
#include <kpushbutton.h>
#include <kled.h>
#include <klistview.h>
#include <kiconview.h>

#include "scandialog.h"
#include "dvbconfig.h"
#include "krecord.h"
#include "ts2rtp.h"
#include "cleaner.h"



class ChannelDesc;
class DvbStream;
class DvbPanel;



class DListView : public KListView
{
	Q_OBJECT
public:
	DListView( QWidget *parent );
protected:
	virtual QDragObject* dragObject();
};



class DIconViewItem : public KIconViewItem
{
public:
	DIconViewItem( DvbPanel *pan, QIconView *parent, const QString &text, const QPixmap &icon );
protected:
	void dropped( QDropEvent *e, const QValueList<QIconDragItem> & );
private:
	DvbPanel *panel;
};



class DvbPanel : public QWidget
{
	Q_OBJECT

public:

	DvbPanel( QWidget *parent=0, const char *name=0);
	~DvbPanel();
	bool getChannelList();
	bool saveChannelList();
	bool timeShiftMode();
	void setConfig();
	bool close();
	void enableLiveDvb( bool on );
	void checkFirstRun();
	void moveChannel( const QString &cat, const QString &name );

	QPtrList<ChannelDesc> channels;
	QPtrList<RecTimer> timers;
	QPtrList<DvbStream> dvb;
	QString fifoName;
	QString timeShiftFileName;
	Ts2Rtp *rtp;

public slots:

	void playLastChannel();
	void playNumChannel( int num );
	void stopLive();
	void setShiftLed( bool on );
	void setRecordLed( bool on );
	void setRecord();
	void setBroadcast();
	void pauseLiveTV();
	void killTimer( RecTimer *t );
	void showEvents();
	void showTimers();
	void scanner();
	void showConfigDialog();
	void next();
	void previous();
	void dvbOSD();

private:

	bool getTimerList();
	bool saveTimerList();
	void fillChannelList();
	QPtrList<Transponder> getSourcesStatus();
	void updateModeTimer( RecTimer *t );
	DvbStream* getWorkingDvb( int mode, ChannelDesc *chan );

	QPixmap tvPix, raPix, tvcPix, racPix;
	QSplitter *split;
	KIconView *iconView;
	DListView *channelsCb;
	QComboBox *audioComb;
	KPushButton *broadcastBtn, *recordBtn;
	QToolButton *dateBtn, *infoBtn, *channelsBtn, *configBtn;
	KLed *shiftLed, *recordLed;
	QTimer timersTimer;
	DVBconfig *dvbConfig;
	KRecord *timersDialog;
	int updown;
	unsigned long autocount;
	int currentChannelNumber;
	Cleaner *cleaner;
	int osdMode;
	QTimer osdTimer;
	QTimer showOsdTimer;
	QString currentCategory;

private slots:

	void checkTimers();
	void channelSelected( QListViewItem *it );
	void channelSelected( const QString &name );
	void audioSelected( int n );
	void dvbZap( ChannelDesc *chan );
	void finalZap( DvbStream *d, ChannelDesc *chan, bool setAudio, int napid=0 );
	void newTimer( QString channel, QString name, QDateTime begin, QTime duration );
	void dumpEvents();
	void resetOSD();
	void catContextMenu( QIconViewItem*, const QPoint& );
	void catSelected( QIconViewItem* );
	void channelNumberChanged( QListViewItem* );

signals:

	void zap( ChannelDesc* );
	void playDvb();
	void timersChanged();
	void dvbOpen( const QString &filename, const QString &chanName, int haveVideo );
	void dvbStop();
	void dvbPause( bool pauseLive );
	void setTimeShiftFilename( const QString& );
	void showPlayer();
	void showOSD( const QString &text, int duration, int priority );
	void showDvbOSD( const QStringList& );
	void isActiveBrowser( const QString& );
};

#endif
