/***************************************************************************
                           playlist.h
                             -------------------
    begin                : Die Apr 22 2003
    revision             : $Revision: 1.34 $
    last modified        : $Date: 2005/08/05 15:55:22 $ by $Author: gillata $
    copyright            : (C) 2003-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <kdialogbase.h>

#include <qwidget.h>
#include <qptrlist.h>

#include "urllistview.h"

class UrlListView;
class MRL;
class KURL;
class QListViewItem;
class QString;
class QLabel;
class QColor;
class QDropEvent;
class QPixmap;
class KLineEdit;
class KComboBox;
class KConfig;
class KPushButton;

class PlayList : public QWidget
{
	Q_OBJECT

public:
	PlayList(KComboBox*, QWidget *parent=0, const char *name=0);
	~PlayList();

	MRL getCurrent();  /* get current playlist entry */
	MRL getNext();
	MRL getPrevious();
	MRL getEntryWithNumber(int number);
	void setCurrentEntry(QListViewItem*, bool playIcon = true);

	QListViewItem* getLast();
	QListViewItem* getFirst();
	QListViewItem* findByURL(const QString&);

	/* insert a KURL(list) after a specific item */
	void add(const QString& url, QListViewItem* after);
	void add(const QStringList& urls, QListViewItem* after);
	void add(const MRL::List&, QListViewItem* after);

	void mergeMeta(const MRL&);

	bool isQueueMode() { return m_queue.count(); }

	void setPlaylist(const QString& name, bool clear = false);
	void nextPlaylist();
	void removeCurrentPlaylist();
	void loadConfig(KConfig*);
	void saveConfig(KConfig*);

	void setEndless(bool);
	void setRandom(bool);

	void useAlternateEncoding(bool);
	void setAlternateEncoding(const QString&);

	void setFileFilter(const QString& filter) { m_fileFilter = filter; }
	void savePlaylist(const QString&);
	void loadPlaylist(const QString&);

	void exportM3UPlaylist(const QString&);
	void exportPLSPlaylist(const QString&);
	
	const bool getReadMetaOnLoading() const { return m_metaOnLoading; }

	void toggleHideDockButton();

	QString mediadevice;

signals:
	void signalPlay(const MRL&);
	void signalPlaylistStatus(const QString&);
	void signalRequestForDVD();
	void signalRequestForVCD();
	void signalRequestForAudioCD();
	void signalToggleDockState();

public slots:
	void slotNewList();
	void slotSetReadMetaOnLoading(bool read) { m_metaOnLoading = read; }
	void slotSetAlternateColor(const QColor&);
	void slotUndockClicked();

protected:
	void closeEvent(QCloseEvent*);

private slots:
	void slotPlayDirect(QListViewItem* item);  /* doubleclick */
	void slotDropEvent(QDropEvent*, QListViewItem*);
	void slotCut();
	void slotPaste();
	void slotCopy();
	void slotSelectAll();
	void slotPlaylistFromSelected();
	void slotAddToQueue(MRL);
	void slotRemoveSelected();
	void slotFindText(const QString&);
	void slotSort(int);
	void slotPlaylistActivated(int);
	void slotNewPlaylistName(const QString&);

private:
	QListViewItem* insertItem(QListViewItem* after, const MRL&);
	void updateStatus();
	void createRandomList();
	void getMetaInfo(MRL& mrl, const QString& mimeName);
	void clearList();
	void saveCurrentPlaylist();
	/* helpers */
	static QString msToTimeString(int);
	static int timeStringToMs(const QString&);
	static bool endsWith(QString, QString, bool);
	static bool startsWith(QString, QString, bool);

private:
	QColor m_altCol;
	KComboBox* m_playlistSelector;
	KLineEdit* m_playlistFilter;
	QLabel* m_playlistName;
	int m_nextPlaylistNumber;
	QString m_playlistDirectory;
	int m_currentPlaylist;
	KPushButton* m_undockButton;

	MRL::List m_queue;

	uint m_playTime;
	uint m_playTimeVisible;
	uint m_countVisible;

	bool m_searchSelection;
	bool m_metaOnLoading;
	bool m_sortAscending;

	UrlListView* m_list;
	QListViewItem* m_currentEntry;
	MRL m_currentEntryMRL;

	QString m_fileFilter;
	QString m_metaInfoString;
	QString m_lastPlaylist;

	QPtrList<QListViewItem> m_randomList;
	int m_currentRandomListEntry;

	QPixmap m_isCurrentEntry;
	QPixmap m_cdPixmap;

	bool m_endless;
	bool m_random;

	bool m_useAlternateEncoding;
	QString m_alternateEncoding;
};

class QListBox;
class QStringList;

class SubtitleChooser : public KDialogBase
{
	Q_OBJECT
public:
	SubtitleChooser(QStringList, QString, QWidget *parent=0, const char *name = 0);
	virtual ~SubtitleChooser();

	QString getSelection();

private:
	QListBox *table;
};

class MovieChooser : public KDialogBase
{
	Q_OBJECT
public:
	MovieChooser(QStringList, QString, QWidget *parent=0, const char *name = 0);
	virtual ~MovieChooser();

	QString getSelection();

private:
	QListBox *table;
};


#endif
