/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                              *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Last modified: $Date: 2005/07/18 18:15:50 $ by $Author: juergenk $
 */

#include "startwindow.h"

#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpixmap.h>
#include <kpixmapeffect.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qcolor.h>

#include "startwindow.moc"

StartWindow::StartWindow(QWidget* parent, const char* name)
		: QWidget(parent, name), m_discIconsEnabled(true), m_dvbEnabled(false)
{
	setPaletteBackgroundColor(QColor("White"));
	QVBoxLayout* mainLayout = new QVBoxLayout(this);
	mainLayout->setAutoAdd(true);
	mainLayout->setSpacing(0);

	QLabel* label1 = new QLabel(this);
	label1->setPaletteBackgroundColor(QColor(238, 246, 255));
	label1->setText("<center><font size=\"7\" color=\"#000055\"><b>[Kaffeine Player]</b></font></center>");
	QLabel* label2 = new QLabel(this);
	label2->setPaletteBackgroundColor(QColor(238, 246, 255));
	label2->setText(QString("<center><font  size=\"5\" color=\"#000055\">") + VERSION + "</font></center>");

	KIconView* iconView = new KIconView(this);
	iconView->setSpacing(15);
	iconView->setFrameShape(QFrame::NoFrame); //remove the border
	iconView->setArrangement(QIconView::TopToBottom);
	iconView->setAutoArrange(true);
	iconView->setItemsMovable(false);
	iconView->setResizeMode(QIconView::Adjust);
	m_items[0] = new KIconViewItem(iconView, i18n("Play Playlist"), getIcon("player_play"));
	m_items[0]->setKey("1");
	m_items[1] = new KIconViewItem(iconView, i18n("Open Files"), getIcon("fileopen"));
	m_items[1]->setKey("2");
	m_items[2] = new KIconViewItem(iconView, i18n("Open URL"), getIcon("www"));
	m_items[2]->setKey("3");
	m_items[3] = new KIconViewItem(iconView, i18n("Open Directory"), getIcon("folder_video"));
	m_items[3]->setKey("4");
	m_items[4] = new KIconViewItem(iconView, i18n("Open DVD"), getIcon("dvd_unmount"));
	m_items[4]->setKey("5");
	m_items[5] = new KIconViewItem(iconView, i18n("Open VCD"), getIcon("cdrom_unmount"));
	m_items[5]->setKey("6");
	m_items[6] = new KIconViewItem(iconView, i18n("Open Audio-CD"), getIcon("cdaudio_unmount"));
	m_items[6]->setKey("7");
#ifdef HAVE_LINUX_DVB_FRONTEND_H

	m_items[7] = new KIconViewItem(iconView, i18n("DVB"), getIcon("tv", false));
	m_items[7]->setKey("8");
#endif

	connect(iconView, SIGNAL(executed(QIconViewItem*)), this, SLOT(slotItemExecuted(QIconViewItem*)));
}


StartWindow::~StartWindow()
{}

void StartWindow::enableDiscIcons(bool enable)
{
	if (m_discIconsEnabled && enable) //first time
		return;

	m_discIconsEnabled = enable;
	if (enable)
	{
		m_items[4]->setPixmap(getIcon("dvd_unmount"));
		m_items[5]->setPixmap(getIcon("cdrom_unmount"));
		m_items[6]->setPixmap(getIcon("cdaudio_unmount"));
	}
	else
	{
		m_items[4]->setPixmap(getIcon("dvd_unmount", false));
		m_items[5]->setPixmap(getIcon("cdrom_unmount", false));
		m_items[6]->setPixmap(getIcon("cdaudio_unmount", false));
	}
}

void StartWindow::enableDVBIcon(bool enable)
{
#ifdef HAVE_LINUX_DVB_FRONTEND_H
	m_dvbEnabled = enable;
	if (enable)
		m_items[7]->setPixmap(getIcon("tv"));
	else
		m_items[7]->setPixmap(getIcon("tv", false));
#endif
}

void StartWindow::slotItemExecuted(QIconViewItem* item)
{
	uint key = item->key().toUInt();

	if (!m_discIconsEnabled && (key == 5 || key ==  6 || key == 7))
		return;

	if (!m_dvbEnabled && key == 8)
		return;

	switch (key)
	{
		case 1:
		emit signalPlaylistPlay();
		break;
		case 2:
		emit signalOpenFile();
		break;
		case 3:
		emit signalOpenURL();
		break;
		case 4:
		emit signalOpenDirectory();
		break;
		case 5:
		emit signalOpenDVD();
		break;
		case 6:
		emit signalOpenVCD();
		break;
		case 7:
		emit signalOpenAudioCD();
		break;
		case 8:
		emit signalDVB();
		break;
		default:
		return;
	}
}

QPixmap StartWindow::getIcon(QString name, bool enabled)
{
	KPixmap pixmap = KPixmap(KGlobal::iconLoader()->loadIcon(name, KIcon::Desktop, 48));
	if (!enabled)
		pixmap = KPixmapEffect::fade(pixmap, 0.7, QColor("White"));
	return (QPixmap)pixmap;
}


