/***************************************************************************
                          	dvbcam.h
                             -------------------
    copyright            : (C) 2006 by Christoph Pfister
    email                :  christophpfister@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DVBCAM_H
#define DVBCAM_H

class DvbCamCamThread;
class DvbCamPmtThread;

class DvbCam
{
public:
	DvbCam(int adapter, int ca_device, int demux_device, int ci_type);
	~DvbCam();

	void restart(int service_id);
	void stop();
	bool running() { return isRunning; }
	int serviceId() { return sid; }

	static int probe( int adapter, int ca_device );

private:
	int Adapter;
	int CaDevice;
	int DemuxDevice;
	bool isRunning;
	int sid;
	int ciType;

	DvbCamCamThread *CamThread;
	DvbCamPmtThread *PmtThread;
};

#endif
