/***************************************************************************
                          ktimereditor.h  -  description
                             -------------------
    begin                : Wed Mar 31 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/08/09 09:36:21 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTIMEREDITOR_H
#define KTIMEREDITOR_H

#include <qdialog.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qdatetimeedit.h>
#include <qlabel.h>

#include <kpushbutton.h>

#include "channeldesc.h"
#include "gdvb.h"
#include "crontimer.h"



class KTimerEditor : public QDialog
{
	Q_OBJECT

public:

	KTimerEditor( bool newone, QStringList &chanList, RecTimer t, QWidget *parent );
	~KTimerEditor();

	KPushButton *okBtn, *cancelBtn, *repeatBtn;
	QLabel *repeatLab;
	QLineEdit *nameLe;
	QComboBox *channelComb, *typeComb;
	QDateTimeEdit *begin, *end;
	QTimeEdit *duration;
	RecTimer timer;

public slots:

	void setRepeat();

protected slots:

	virtual void accept();
	void setDuration( const QDateTime &dt );
	void setEnd( const QTime &t );
	void setMaxEnd( const QDateTime &dt );
};

#endif
