/*
 * dvbconfig.h
 *
 * Copyright (C) 2004-2005 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef DVBCONFIG_H
#define DVBCONFIG_H

#include <qspinbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qtoolbutton.h>
#include <qbuttongroup.h>

#include <kdialogbase.h>
#include <kpushbutton.h>
#include <kconfig.h>
#include <kio/job.h>
#include <kprogress.h>

#include <linux/dvb/frontend.h>

using namespace KIO;

class MSpinBox : public QSpinBox
{
	Q_OBJECT
public:
	MSpinBox( QWidget *parent, int devNum );
public slots:
	void slotValueChanged( int value );
signals:
	void signalValueChanged( int value, int devNum );
private:
	int deviceNumber;
};



class MPushButton : public KPushButton
{
	Q_OBJECT
public:
	MPushButton( QWidget *parent, int devNum, int lnbNum );
private slots:
	void isClicked();
signals:
	void clicked( int devnum, int lnbnum );
private:
	int deviceNumber;
	int lnbNumber;
};



class LNB
{
public:
	LNB();

	unsigned int switchFreq;
	unsigned int loFreq;
	unsigned int hiFreq;
};



class Device
{
public:
	Device( int anum, int tnum, fe_type_t t, const QString &n, bool as );
	int adapter, tuner;
	fe_type_t type;
	QString name;
	QString source;
	LNB lnb0, lnb1, lnb2, lnb3;
	bool canAutoscan;
};



class Category
{
public:
	Category( const QString &tname, const QString &ticon );
	QString name;
	QString icon;
};



class DVBconfig : public QObject
{
	Q_OBJECT

public:

	DVBconfig( const QString &dvbConf );
	~DVBconfig();
	void readConfig();
	void saveConfig();
	int readDvbChanOrder();
	void saveDvbChanOrder( int s, int col );
	void startup();
	static bool haveDvbDevice();
	bool loadDvbData( QWidget *parent );
	bool localData();
	QStringList getSourcesList( int devNum );
	bool haveData();
	bool firstRun();
	void addCategory( const QString &name, const QString &icon );
	void removeCategory( const QString &name );
	void changeIconCategory( const QString &name, const QString &icon );

	KConfig *config;
	QString recordDir, shiftDir;
	int beginMargin, endMargin, format, instantDuration;
	QSize epgSize, scanSize, timerSize;
	QPtrList<Device> devList;
	QPtrList<Category> categories;
	QString allIcon, tvIcon, radioIcon;
	QString dvbConfigDir;
	QString dvbConfigIconsDir;
	QString broadcastAddress;
	int broadcastPort, senderPort;
	int lastChannel;
	QValueList<int> splitSizes;
	QString defaultCharset;

private:

	KProgressDialog *downProgress;
	bool downloadFinished;

private slots:

	void setDownloadResult( KIO::Job *job );
	void setDownloadPercent( KIO::Job *job, unsigned long percent );
};



class KaffeineDvbPlugin;

class DvbConfigDialog : public KDialogBase
{
	Q_OBJECT

public:

	DvbConfigDialog( DVBconfig *dc, QWidget *parent, KaffeineDvbPlugin *p );
	~DvbConfigDialog();
	void setSource( QComboBox *box, QString s, int sat );

	QLineEdit *recordDirLe, *shiftDirLe, *broadcastLe;
	QSpinBox *beginSpin, *endSpin, *instantDurationSpin, *bportSpin, *sportSpin;
	QSpinBox *satNumber[4];
	QComboBox *sat0[4];
	QComboBox *sat1[4];
	QComboBox *sat2[4];
	QComboBox *sat3[4];
	MPushButton *lnb0[4];
	MPushButton *lnb1[4];
	MPushButton *lnb2[4];
	MPushButton *lnb3[4];
	QComboBox *formatComb;
	KPushButton *updateBtn, *dumpBtn;
	QToolButton *recordDirBtn, *shiftDirBtn;
	QFrame *broadcastPage, *miscPage, *recordPage, *dvbPage[4];
	DVBconfig *dvbConfig;
	QComboBox *charsetComb;

private slots:

	void setRecordDir();
	void setShiftDir();
	void satNumberChanged( int value, int devNum );
	void downloadData();
	void setLnb( int devNum, int lnbNum );

protected slots:

	virtual void accept();
};



class LnbConfig : public KDialogBase
{
	Q_OBJECT

public:

	LnbConfig( LNB *b, QWidget *parent );

protected slots:

	virtual void accept();
	void setDual( int id );
	void setUniversal();
	void setCBandMono();
	void setCBandMulti();

private:

	QSpinBox *slof;
	QSpinBox *lo, *hi, *single, *vertical, *horizontal;
	QLabel *slofLab, *loLab, *hiLab, *singleLab, *verticalLab, *horizontalLab;
	QButtonGroup *nLO;
	QPushButton *univ, *cmono, *cmulti;

	LNB *lnb;
};

#endif /* DVBCONFIG_H */
