#!/usr/bin/env python

from sizeview_ui import SizeViewUI
from qt import *
import sys

class SizeViewApplication(QApplication):
    """ Boilerplate """
    def __init__(self, args,devicename):
        QApplication.__init__(self,args)
        
        self.maindialog = SizeView(None,devicename)
        
        self.setMainWidget(self.maindialog)
        self.maindialog.show()
        self.exec_loop()     

class SizeView(SizeViewUI):
    devicename = ""
    partitions = {}
    partitionwidgets = []
    cols = 2 # number of rows
    devicename = ""
    
    def __init__(self,parent,devicename):
        self.devicename = devicename
        SizeViewUI.__init__(self,parent)
        self.readSize()
        
        for part in self.partitions:
            pwidg = PartitionGroup(part,self)
            pwidg.setSizeLabel(self.getLabel(self.partitions[part]))
            self.partitionwidgets.append(pwidg)
            print self.getLabel(self.partitions[part])

        # How many rows do we need?
        self.rows = len(self.partitions)/self.cols
        self.rows += len(self.partitions)%self.cols

        self.partitionlayout = QGridLayout(None,self.rows,self.cols,0,6,"partitionlayout")
        
        c = r = 0
        # Add partitions to layoutwidget
        for pw in self.partitionwidgets:
            self.partitionlayout.addWidget(pw,r,c)
            c += 1 
            if c >= self.rows:
                # Next rows
                r += 1
                c = 0
            
        self.layout().addLayout(self.partitionlayout,1,0)
        
    def readSize(self):
        fhandle = open("/proc/partitions","r")
        for line in fhandle.readlines():
            try:
                major,minor,blocks,name = line.split()
    
                if name == self.devicename:
                    self.totalsize = blocks
                if name[:len(self.devicename)] == self.devicename and len(name) > len(self.devicename):
                    self.partitions[name] = blocks
            except ValueError:
                pass
                
    def __show__(self):
        print self.partitions
        print "Device", self.devicename, self.getLabel(self.totalsize)
        for p in self.partitions:
            print p, self.partitions[p], self.getLabel(self.partitions[p])
        
    def getLabel(self,blocks):
        blocks = int(blocks) # 1K blocks now.
        if blocks<1024:
            return str(blocks)+" Kb"
        if blocks<1024*1024:
            return str(round(float(blocks)/1024.0,1))+" Mb"
        blocks /= 1024
        if blocks<1024*1024:
            return str(round(float(blocks)/1024.0,1))+" Gb"
        blocks /= 1024
        return str(round(float(blocks)/1024.0,1))+" Tb"
        
class PartitionGroup(QGroupBox):
    
    blocksize = 0
    sizelabel = "0 Mb"
    devicename = "/dev/"
    title = "Partition"
    
    def __init__(self,title,parent):
        
        QGroupBox.__init__(self,parent)
        self.devicename += title
        
        self.setTitle("Partition "+self.devicename)
        
        self.setSizePolicy(QSizePolicy(QSizePolicy.Preferred,QSizePolicy.Preferred,0,0,self.sizePolicy().hasHeightForWidth()))
        self.setMinimumSize(QSize(150,160))
        self.setAlignment(QGroupBox.AlignCenter)
        self.setColumnLayout(0,Qt.Vertical)
        self.layout().setSpacing(6)
        self.layout().setMargin(11)
        self.pglayout = QGridLayout(self.layout())
        self.pglayout.setAlignment(Qt.AlignTop)

        self.partpixmap = PartitionView(self,"partpixmap_1")
        self.pglayout.addWidget(self.partpixmap,0,0)

    def setSizeLabel(self,label):
        self.sizelabel = label
        self.setTitle(self.title+" "+self.devicename+" "+self.sizelabel)

class PartitionView(QLabel):
    
    def __init__(self,parent,title):
        self.pixmapsize = 128
        QLabel.__init__(self,parent,title)
        
        self.setSizePolicy(QSizePolicy(QSizePolicy.Fixed,QSizePolicy.Fixed,0,0,self.sizePolicy().hasHeightForWidth()))
        self.setMinimumSize(QSize(self.pixmapsize,self.pixmapsize))        
        self.setPixmap(PartitionPixmap(self.pixmapsize))        
        self.setScaledContents(1)
        self.setAlignment(QLabel.AlignCenter)
        
class PartitionPixmap(QPixmap):
    
    def __init__(self,pmsize):
        QPixmap.__init__(self,QSize(pmsize,pmsize))
        self.pmsize = pmsize
        self.paintMe()
        
    def paintMe(self):
        p = QPainter(self)
        p.begin(self)
        # TODO: Lookup background color
        bgcolor = QColor(239,239,239)
        self.fill(bgcolor) # grey

        p.setPen(QPen(QColor(211,51,97),2))
        
        diff = 10
        w = h = self.pmsize-diff
        #Draws an ellipse with center at (x + w/2, y + h/2) and size (w, h).
        p.drawEllipse(diff/2,diff/2,w,h)        
        p.end()

if __name__ == "__main__":
    device = "hda"
    app = SizeViewApplication(sys.argv,device)
