#!/usr/bin/python
###########################################################################
# ktimerdialog.py - description                                           #
# ------------------------------                                          #
# begin     : Mon Jul 26 2004                                             #
# copyright : (C) 2004 by Simon Edwards                                   #
# email     : simon@simonzone.com                                         #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################
# Based on Hamish Rodda's ktimerdialog.cpp.

from qt import *
from kdecore import *
from kdeui import *

class KTimerDialog(KDialogBase):
    CountDown = 0
    CountUp = 1
    Manual = 2

    def __init__(self, msec, style, parent, name, modal, caption="", \
            buttonmask=KDialogBase.Ok|KDialogBase.Cancel|KDialogBase.Apply, \
            defaultbutton=KDialogBase.Cancel, separator=False, \
            user1=KGuiItem(), user2=KGuiItem(), user3=KGuiItem()):
        """Parameters:

        msec - integer, timeout in milliseconds
        style - TimerStyle object.
        parent - parent QWidget
        name - String
        model - boolean.
        caption - String
        buttonmask - integer
        defaultbutton - ButtonCode
        separator - boolean
        user1 - KGuiItem
        user2 - KGuiItem
        user3 - KGuiItem
        """

        KDialogBase.__init__(self,parent, name, modal, caption, buttonmask, defaultbutton, \
                 separator, user1, user2, user3 )

        self.totaltimer = QTimer(self)
        self.updatetimer = QTimer(self)
        self.msectotal = self.msecremaining = msec
        self.updateinterval = 1000
        self.tstyle = style

        # default to cancelling the dialog on timeout
        if buttonmask & self.Cancel:
            self.buttonontimeout = self.Cancel

        self.connect(self.totaltimer, SIGNAL("timeout()"), self.slotInternalTimeout)
        self.connect(self.updatetimer, SIGNAL("timeout()"), self.slotUpdateTime)

        # create the widgets
        self.mainwidget = QVBox(self, "mainWidget")
        self.timerwidget = QHBox(self.mainwidget, "timerWidget")
        self.timerlabel = QLabel(self.timerwidget)
        self.timerprogress = QProgressBar(self.timerwidget)
        self.timerprogress.setTotalSteps(self.msectotal)
        self.timerprogress.setPercentageVisible(False)
        self.setMainWidget(self.mainwidget)
        self.slotUpdateTime(False)

    def show(self):
        self.msecremaining = self.msectotal
        self.slotUpdateTime(False)
        KDialogBase.show(self)
        self.totaltimer.start(self.msectotal, True)
        self.updatetimer.start(self.updateinterval, False)

    def exec_loop(self):
        self.totaltimer.start(self.msectotal, True)
        self.updatetimer.start(self.updateinterval, False)
        return KDialogBase.exec_loop(self)

    def setMainWidget(self, newmainwidget):
        # yuck, here goes.
        newwidget = QVBox(self)

        if newmainwidget.parentWidget()!=self.mainwidget:
            newmainwidget.reparent(newwidget, 0, QPoint(0,0))
        else:
            newwidget.insertChild(newmainwidget)

        self.timerwidget.reparent(newwidget, 0, QPoint(0, 0))

        self.mainwidget = newwidget
        KDialogBase.setMainWidget(self, self.mainwidget)

    def setRefreshInterval(self, msec):
        self.updateinterval = msec;
        if self.updatetimer.isActive():
            self.updatetimer.changeInterval(self.updateinterval)

    def timeoutButton(self):
        return self.buttonontimeout

    def setTimeoutButton(self, newbutton):
        self.buttonontimeout = newbutton

    def timerStyle(self):
        return self.tstyle

    def setTimerStyle(self, newstyle):
        self.tstyle = newstyle

    def slotUpdateTime(self, update=True):
        if update:
            if self.tstyle==self.CountDown:
                    self.msecremaining -= self.updateinterval
            elif self.tstyle==self.CountUp:
                    self.msecremaining += self.updateinterval

        self.timerprogress.setProgress(self.msecremaining)
        self.timerlabel.setText( i18n("%1 seconds remaining:").arg(self.msecremaining/1000.0) )

    def slotInternalTimeout(self):
        #self.emit(SIGNAL("timerTimeout()"), () )
        if self.buttonontimeout==self.Help:
            self.slotHelp()
        elif self.buttonontimeout==self.Default:
            self.slotDefault()
        elif self.buttonontimeout==self.Ok:
            self.slotOk()
        elif self.buttonontimeout==self.Apply:
            self.applyPressed()
        elif self.buttonontimeout==self.Try:
            self.slotTry()
        elif self.buttonontimeout==self.Cancel:
            self.slotCancel()
        elif self.buttonontimeout==self.Close:
            self.slotClose()
        #case User1:
        #    slotUser1();
        #case User2:
        #    slotUser2();
        #    break;
        elif self.buttonontimeout==self.User3:
            self.slotUser3()
        elif self.buttonontimeout==self.No:
            self.slotNo()
        elif self.buttonontimeout==self.Yes:
            self.slotCancel()
        elif self.buttonontimeout==self.Details:
            self.slotDetails()
