<?php
// todo: set bool, empty string
// TODO: QColor::getRgb(int* r, int* g, int* b)
    /**
     *	This file contains a couple of basic tests
     *
     *	- test fetching constants, the opcode handler has been overwritten
     *	- test __toString()
     *	- test QString
     *	- test returning values and objects
     *  - test returning references
     */

    require_once('testHelper.php');

    require_once('PHPUnit/Framework/TestCase.php');
    require_once('PHPUnit/Framework/TestSuite.php');

    class QtBasicTestCase extends PHPUnit_Framework_TestCase {
    
	private $app;
    
	public function __construct($name="") {
	    parent::__construct($name);
	}

	// try to fetch a string constant
	function testFetchStringConstant() {
	    echo "\ntesting foo::a";
	    $this->assertEquals(foo::a, "a", "Could not fetch string constant!");
	    echo " passed";
	}

	// try to fetch a numeric constant
	function testFetchNumConstant() {
	    echo "\ntesting foo::b";
	    $this->assertEquals(foo::b, 24, "Could not fetch numeric constant!");
	    echo " passed";
	}

	// try to fetch a Qt constant
	function testQtConstant() {
	    echo "\ntesting Qt::Horizontal";
	    $this->assertTrue(Qt::Horizontal == 1, "Could not fetch constant from Qt!");
	    echo " passed";
	}

	// try to call a static method
	function testCallStaticMethod() {
	    echo "\ntesting foo::staticMethod()";
	    $this->assertEquals(foo::staticMethod(), "staticMethod", "Could not call a static method!");
	    echo " passed";
	}

	// try to call a static Qt method
	function testCallStaticQtMethod() {
	    echo "\ntesting foo::tr()";
	    $this->assertEquals(foo::tr("hello") == "hello", "Could not call a static Qt method!");
	    echo " passed";
	}

	// try to call a parent Qt method within a method
	function testCallParentQtMethod() {
	    echo "\ntesting parent::blockSignals() within foo::blockSignals()";
	    $o = new QObject();
	    $p = new foo($o);
	    // set blockSignals to true, so we can test it
	    $p->blockSignals(true); 
    	    $this->assertTrue($p->blockSignals(true), "Could not call a parent Qt method!");
	    echo " passed";
	}

	// try to call a static Qt method within a static PHP method
	function testCallStaticQtMethodWithinStaticPHPMethod() {
	    echo "\ntesting foo::staticTrMethod()";
	    $this->assertEquals(foo::staticTrMethod("hello") == "hello", "Could not call a static Qt method!");
	    echo " passed";
	}

	// test the __toString() method
	function testQString() {
	    echo "\ntesting QString::__toString()";
	    $s = new QString("hello");
	    $this->assertEquals($s->__toString(), "hello", "Could not handle __toString()!");
	    echo " passed";
	}

	// try to append a PHP string to a QString
	function testQStringAppendString() {
	    echo "\ntesting QString::append(\"hello\")";
	    $s = new QString("hello");
	    $s->append(" world");
	    $this->assertEquals($s->__toString(), "hello world", "Could append simple string to QString!");
	    echo " passed";
	}

	// try to create an instance of QApplication
	function testQApplication() {
	    echo "\ntesting creation of QApplication";
	    $argc=1;
	    $argv=array("argv");
	    $this->app = new QApplication($argc,$argv);
	    $this->assertTrue(is_object($this->app), "Could not create an instance of QApplication!");
	    echo " passed";
	}

	// try to append a QString to a QString
	function testQStringAppendObject() {
	    echo "\ntesting QString::append(new QString(\"hello\"))";
	    $s = new QString("hello");
	    $t = new QString(" world");
	    $s->append($t);
	    $this->assertEquals($s->__toString(), "hello world", "Could not append QString to QString!");
	    echo " passed";
	}

	// test methods of an derivated object
	function testUnknownMethod() {
	    echo "\ntesting derivated object";
	    $date = new QObject();
	    $foo = new foo($date);
	    $foo->parent();
	    $foo->testMethod();
//	    $foo->___();	// method not defined
	    echo " passed";
	}

	function testAmbiguousMethodCall() {
	    echo "\ntesting ambiguous method call";
	    $w = new QWidget();
	    $w->setPalette(new QPalette(new QColor(250, 250, 200)));
	    echo " passed";
	}

	function testTr(){
	    echo "\ntesting global tr()";
	    $s = tr("hello world");
	    $this->assertEquals($s->__toString(), "hello world", "tr() doesnt work!");
	    echo " passed";
	}

	function testInterlacedStaticMethodCall(){
	    echo "\ntesting interlaced static method call";
	    QTimer::singleShot(100,QApplication::instance(),SLOT("quit()"));
	    echo " passed";
	}

    }    
    
?>