//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Collections.Generic;

	/// <remarks>
	///  Abstract base class for simple word macro substitutors. Use this instead of
	///  the functions in the KMacroExpander namespace if speculatively pre-filling
	///  the substitution map would be too expensive.
	///  A typical application:
	///  <pre>
	///  class MyClass {
	///  ...
	///    private:
	///      string m_str;
	///  ...
	///    friend class MyExpander;
	///  }
	///  class MyExpander : public KWordMacroExpander {
	///    public      MyExpander( MyClass _that ), that( _that ) {}
	///    protected:
	///      bool expandMacro( stringstr, List<string>ret );
	///    private:
	///      MyClass that;
	///  }
	///  bool MyExpander.ExpandMacro( stringstr, List<string>ret )
	///  {
	///    if (str == "macro") {
	///      ret += complexOperation( that.M_str );
	///      return true;
	///    }
	///    return false;
	///  }
	///  ... MyClass....(...)
	///  {
	///    string str;
	///    ...
	///    MyExpander mx( this );
	///    mx.expandMacrosShellQuote( str );
	///    ...
	///  }
	///  </pre>
	///  Alternatively MyClass could inherit from KWordMacroExpander directly.
	/// </remarks>		<author> Oswald Buddenhagen <ossi@kde.org>
	///  </author>
	/// 		<short>    Abstract base class for simple word macro substitutors.</short>

	[SmokeClass("KWordMacroExpander")]
	public abstract class KWordMacroExpander : KMacroExpanderBase {
 		protected KWordMacroExpander(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KWordMacroExpander), this);
		}
		/// <remarks>
		///  Constructor.
		/// <param> name="c" escape char indicating start of macros, or char.Null for none
		///      </param></remarks>		<short>    Constructor.</short>
		public KWordMacroExpander(char c) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KWordMacroExpander#", "KWordMacroExpander(QChar)", typeof(void), typeof(char), c);
		}
		public KWordMacroExpander() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KWordMacroExpander", "KWordMacroExpander()", typeof(void));
		}
		[SmokeMethod("expandPlainMacro(const QString&, int, QStringList&)")]
		protected override int ExpandPlainMacro(string str, int pos, List<string> ret) {
			return (int) interceptor.Invoke("expandPlainMacro$$?", "expandPlainMacro(const QString&, int, QStringList&)", typeof(int), typeof(string), str, typeof(int), pos, typeof(List<string>), ret);
		}
		[SmokeMethod("expandEscapedMacro(const QString&, int, QStringList&)")]
		protected override int ExpandEscapedMacro(string str, int pos, List<string> ret) {
			return (int) interceptor.Invoke("expandEscapedMacro$$?", "expandEscapedMacro(const QString&, int, QStringList&)", typeof(int), typeof(string), str, typeof(int), pos, typeof(List<string>), ret);
		}
		/// <remarks>
		///  Return substitution list <code>ret</code> for string macro <code>str.</code>
		/// <param> name="str" the macro to expand
		/// </param><param> name="ret" return variable reference. It is guaranteed to be empty
		///   when expandMacro is entered.
		/// </param></remarks>		<return> @c true iff <code>chr</code> was a recognized macro name
		///      </return>
		/// 		<short>    Return substitution list <code>ret</code> for string macro <code>str.</code></short>
		[SmokeMethod("expandMacro(const QString&, QStringList&)")]
		protected abstract bool ExpandMacro(string str, List<string> ret);
	}
}
