/****************************************************************************
** $Id: ABCentralWidget.java 138072 2002-02-22 18:13:06Z rdale $
**
** Copyright ( C ) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
import org.kde.qt.*;
import java.util.*;

public class ABCentralWidget extends QWidget
{
    protected QGridLayout mainGrid;
    protected QTabWidget tabWidget;
    protected QListView listView;
    protected QPushButton add, change, find;
    protected QLineEdit iFirstName, iLastName, iAddress, iEMail,
        sFirstName, sLastName, sAddress, sEMail;
    protected QCheckBox cFirstName, cLastName, cAddress, cEMail;


public ABCentralWidget( QWidget parent, String name )
{
    super( parent, name );
    mainGrid = new QGridLayout( this, 2, 1, 5, 5 );

    setupTabWidget();
    setupListView();

    mainGrid.setRowStretch( 0, 0 );
    mainGrid.setRowStretch( 1, 1 );
}

public ABCentralWidget( QWidget parent )
{
	this(parent, null);
}

public void save( String filename )
{
    if ( listView.firstChild() == null )
        return;

    QFile f = new QFile( filename );
    if ( !f.open( QIODevice.IO_WriteOnly ) )
        return;

    QTextStream t = new QTextStream( f );

    Iterator it = listView.itemList().iterator();
	while ( it.hasNext() ) {
		QListViewItem currentItem = (QListViewItem) it.next();
        for ( int i = 0; i < 4; i++ ) {
			t.writeRawBytes( currentItem.text(i), currentItem.text(i).length() );
			t.writeRawBytes( "\n", 1 );
		}
	}
    
	f.close();
}

public void load( String filename )
{
    listView.clear();

    QFile f = new QFile( filename );
    if ( !f.open( QIODevice.IO_ReadOnly ) )
        return;

    QTextStream t = new QTextStream( f );

    while ( !t.atEnd() ) {
        QListViewItem item = new QListViewItem( listView );
        for ( int i = 0; i < 4; i++ )
            item.setText( i, t.readLine() );
    }

    f.close();
}

public void setupTabWidget()
{
    tabWidget = new QTabWidget( this );

    QWidget input = new QWidget( tabWidget );
    QGridLayout grid1 = new QGridLayout( input, 2, 5, 5, 5 );

    QLabel liFirstName = new QLabel( "First &Name", input );
    liFirstName.resize( liFirstName.sizeHint() );
    grid1.addWidget( liFirstName, 0, 0 );

    QLabel liLastName = new QLabel( "&Last Name", input );
    liLastName.resize( liLastName.sizeHint() );
    grid1.addWidget( liLastName, 0, 1 );

    QLabel liAddress = new QLabel( "Add&ress", input );
    liAddress.resize( liAddress.sizeHint() );
    grid1.addWidget( liAddress, 0, 2 );

    QLabel liEMail = new QLabel( "&E-Mail", input );
    liEMail.resize( liEMail.sizeHint() );
    grid1.addWidget( liEMail, 0, 3 );

    add = new QPushButton( "A&dd", input );
    add.resize( add.sizeHint() );
    grid1.addWidget( add, 0, 4 );
    connect( add, SIGNAL( "clicked()" ), this, SLOT( "addEntry()" ) );

    iFirstName = new QLineEdit( input );
    iFirstName.resize( iFirstName.sizeHint() );
    grid1.addWidget( iFirstName, 1, 0 );
    liFirstName.setBuddy( iFirstName );

    iLastName = new QLineEdit( input );
    iLastName.resize( iLastName.sizeHint() );
    grid1.addWidget( iLastName, 1, 1 );
    liLastName.setBuddy( iLastName );

    iAddress = new QLineEdit( input );
    iAddress.resize( iAddress.sizeHint() );
    grid1.addWidget( iAddress, 1, 2 );
    liAddress.setBuddy( iAddress );

    iEMail = new QLineEdit( input );
    iEMail.resize( iEMail.sizeHint() );
    grid1.addWidget( iEMail, 1, 3 );
    liEMail.setBuddy( iEMail );

    change = new QPushButton( "&Change", input );
    change.resize( change.sizeHint() );
    grid1.addWidget( change, 1, 4 );
    connect( change, SIGNAL( "clicked()" ), this, SLOT( "changeEntry()" ) );

    tabWidget.addTab( input, "&Add/Change Entry" );

    // --------------------------------------

    QWidget search = new QWidget( this );
    QGridLayout grid2 = new QGridLayout( search, 2, 5, 5, 5 );

    cFirstName = new QCheckBox( "First &Name", search );
    cFirstName.resize( cFirstName.sizeHint() );
    grid2.addWidget( cFirstName, 0, 0 );
    connect( cFirstName, SIGNAL( "clicked()" ), this, SLOT( "toggleFirstName()" ) );

    cLastName = new QCheckBox( "&Last Name", search );
    cLastName.resize( cLastName.sizeHint() );
    grid2.addWidget( cLastName, 0, 1 );
    connect( cLastName, SIGNAL( "clicked()" ), this, SLOT( "toggleLastName()" ) );

    cAddress = new QCheckBox( "Add&ress", search );
    cAddress.resize( cAddress.sizeHint() );
    grid2.addWidget( cAddress, 0, 2 );
    connect( cAddress, SIGNAL( "clicked()" ), this, SLOT( "toggleAddress()" ) );

    cEMail = new QCheckBox( "&E-Mail", search );
    cEMail.resize( cEMail.sizeHint() );
    grid2.addWidget( cEMail, 0, 3 );
    connect( cEMail, SIGNAL( "clicked()" ), this, SLOT( "toggleEMail()" ) );

    sFirstName = new QLineEdit( search );
    sFirstName.resize( sFirstName.sizeHint() );
    grid2.addWidget( sFirstName, 1, 0 );

    sLastName = new QLineEdit( search );
    sLastName.resize( sLastName.sizeHint() );
    grid2.addWidget( sLastName, 1, 1 );

    sAddress = new QLineEdit( search );
    sAddress.resize( sAddress.sizeHint() );
    grid2.addWidget( sAddress, 1, 2 );

    sEMail = new QLineEdit( search );
    sEMail.resize( sEMail.sizeHint() );
    grid2.addWidget( sEMail, 1, 3 );

    find = new QPushButton( "F&ind", search );
    find.resize( find.sizeHint() );
    grid2.addWidget( find, 1, 4 );
    connect( find, SIGNAL( "clicked()" ), this, SLOT( "findEntries()" ) );

    cFirstName.setChecked( true );
    sFirstName.setEnabled( true );
    sLastName.setEnabled( false );
    sAddress.setEnabled( false );
    sEMail.setEnabled( false );

    tabWidget.addTab( search, "&Search" );

    mainGrid.addWidget( tabWidget, 0, 0 );
}

public void setupListView()
{
    listView = new QListView( this );
    listView.addColumn( "First Name" );
    listView.addColumn( "Last Name" );
    listView.addColumn( "Address" );
    listView.addColumn( "E-Mail" );

    listView.setSelectionMode( QListView.Extended );

    connect( listView, SIGNAL( "clicked( QListViewItem )" ), this, SLOT( "itemSelected( QListViewItem )" ) );

    mainGrid.addWidget( listView, 1, 0 );
    listView.setAllColumnsShowFocus( true );
}

public void addEntry()
{
    if ( !iFirstName.text().equals("") || !iLastName.text().equals("") ||
         !iAddress.text().equals("") || !iEMail.text().equals("") ) {
        QListViewItem item = new QListViewItem( listView );
        item.setText( 0, iFirstName.text() );
        item.setText( 1, iLastName.text() );
        item.setText( 2, iAddress.text() );
        item.setText( 3, iEMail.text() );
    }

    iFirstName.setText( "" );
    iLastName.setText( "" );
    iAddress.setText( "" );
    iEMail.setText( "" );
}

public void changeEntry()
{
    QListViewItem item = listView.currentItem();

    if ( item != null &&
         ( !iFirstName.text().equals("") || !iLastName.text().equals("") ||
         !iAddress.text().equals("") || !iEMail.text().equals("") ) ) {
        item.setText( 0, iFirstName.text() );
        item.setText( 1, iLastName.text() );
        item.setText( 2, iAddress.text() );
        item.setText( 3, iEMail.text() );
    }
}

public void selectionChanged()
{
    iFirstName.setText( "" );
    iLastName.setText( "" );
    iAddress.setText( "" );
    iEMail.setText( "" );
}

public void itemSelected( QListViewItem item )
{
    item.setSelected( true );
    item.repaint();

    iFirstName.setText( item.text( 0 ) );
    iLastName.setText( item.text( 1 ) );
    iAddress.setText( item.text( 2 ) );
    iEMail.setText( item.text( 3 ) );
}

public void toggleFirstName()
{
    sFirstName.setText( "" );

    if ( cFirstName.isChecked() ) {
        sFirstName.setEnabled( true );
        sFirstName.setFocus();
    }
    else
        sFirstName.setEnabled( false );
}

public void toggleLastName()
{
    sLastName.setText( "" );

    if ( cLastName.isChecked() ) {
        sLastName.setEnabled( true );
        sLastName.setFocus();
    }
    else
        sLastName.setEnabled( false );
}

public void toggleAddress()
{
    sAddress.setText( "" );

    if ( cAddress.isChecked() ) {
        sAddress.setEnabled( true );
        sAddress.setFocus();
    }
    else
        sAddress.setEnabled( false );
}

public void toggleEMail()
{
    sEMail.setText( "" );

    if ( cEMail.isChecked() ) {
        sEMail.setEnabled( true );
        sEMail.setFocus();
    }
    else
        sEMail.setEnabled( false );
}

public void findEntries()
{
    if ( !cFirstName.isChecked() &&
         !cLastName.isChecked() &&
         !cAddress.isChecked() &&
         !cEMail.isChecked() ) {
        listView.clearSelection();
        return;
    }
    
	Iterator it = listView.itemList().iterator();
	while ( it.hasNext() ) {
		QListViewItem currentItem = (QListViewItem) it.next();
        boolean select = true;

        if ( cFirstName.isChecked() ) {
            if ( select && currentItem.text( 0 ).indexOf( sFirstName.text() ) != -1 )
                select = true;
            else
                select = false;
        }
        if ( cLastName.isChecked() ) {
            if ( select && currentItem.text( 1 ).indexOf( sLastName.text() ) != -1 )
                select = true;
            else
                select = false;
        }
        if ( cAddress.isChecked() ) {
            if ( select && currentItem.text( 2 ).indexOf( sAddress.text() ) != -1 )
                select = true;
            else
                select = false;
        }
        if ( cEMail.isChecked() ) {
            if ( select && currentItem.text( 3 ).indexOf( sEMail.text() ) != -1 )
                select = true;
            else
                select = false;
        }

        if ( select )
            currentItem.setSelected( true );
        else
           currentItem.setSelected( false );
       currentItem.repaint();
    }
}

}
