


#include <qcstring.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qcanvas.h>
#include "qcanvasline_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasLineImp::QCanvasLineImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasLineImp::~QCanvasLineImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasLineImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasLineImp *meth = new QCanvasLineImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasLineImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_setPoints_3, "setPoints" },
        { Method_startPoint_4, "startPoint" },
        { Method_endPoint_5, "endPoint" },
        { Method_rtti_6, "rtti" },
        { Method_setPen_7, "setPen" },
        { Method_moveBy_8, "moveBy" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasLineImp *meth = new QCanvasLineImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a QCanvasLine pointer from an Object.
 */
QCanvasLine *QCanvasLineImp::toQCanvasLine( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QCanvasLine *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QCanvasLine" )
        return 0;

    return op->toNative<QCanvasLine>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasLineImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasLine_1:
             return QCanvasLine_1( exec, args );
             break;

         default:
             break;
    }

    QString msg = i18n("QCanvasLineCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object QCanvasLineImp::QCanvasLine_1( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter QCanvas *
    return KJS::Object();

    QCanvas * arg0; // Dummy


    // We should now create an instance of the QCanvasLine object

    QCanvasLine *ret = new QCanvasLine(

          arg0 );


}

KJS::Value QCanvasLineImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasLineImp::toQCanvasLine( self );

    switch( id ) {

    case Method_setPoints_3:
        return setPoints_3( exec, self, args );
        break;

    case Method_startPoint_4:
        return startPoint_4( exec, self, args );
        break;

    case Method_endPoint_5:
        return endPoint_5( exec, self, args );
        break;

    case Method_rtti_6:
        return rtti_6( exec, self, args );
        break;

    case Method_setPen_7:
        return setPen_7( exec, self, args );
        break;

    case Method_moveBy_8:
        return moveBy_8( exec, self, args );
        break;

    default:
        break;
    }

    QString msg = i18n( "QCanvasLineImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value QCanvasLineImp::setPoints_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

    int arg3 = extractInt(exec, args, 3);

      instance->setPoints(
       arg0,
       arg1,
       arg2,
       arg3 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasLineImp::startPoint_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    QPoint ret;
      ret = instance->startPoint(  );

       return convertToValue( exec, ret );

}

KJS::Value QCanvasLineImp::endPoint_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    QPoint ret;
      ret = instance->endPoint(  );

       return convertToValue( exec, ret );

}

KJS::Value QCanvasLineImp::rtti_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasLineImp::setPen_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QPen
    return KJS::Value();

    QPen arg0; // Dummy

      instance->setPen(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasLineImp::moveBy_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

    double arg1 = extractDouble(exec, args, 1);

      instance->moveBy(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


