"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

urls = ["http://slashdot.org", "http://www.kde.org", "http://www.riverbankcomputing.co.uk", "http://yahoo.com"]

import sys

from kdecore import KApplication, KCmdLineArgs, KAboutData, KURL
from kdeui import KMainWindow, KEdit

class MainWin (KMainWindow):
    def __init__ (self, *args):
        apply (KMainWindow.__init__, (self,) + args)

        self.setGeometry (0, 0, 400, 600)

        self.edit = KEdit (self)
        self.setCentralWidget (self.edit)

        self.edit.insertLine ("KURL Demo\n")
        self.edit.insertLine ("Adding these urls:\n")
        for url in urls:
            self.edit.insertLine ("    %s" % url)

        self.edit.insertLine ("\nCreating KURLs (iterating to print):\n")
        urlList = KURL.List ()
        for url in urls:
            urlList.append (KURL (url))

        for url in urlList:
            self.edit.insertLine ("     %s" % url.url ())

        self.edit.insertLine ("\nFirst url -- urlList [0]:\n")
        self.edit.insertLine ("    " + str (urlList [0]))
        self.edit.insertLine ("    " + str (urlList [0].url ()))

        self.edit.insertLine ("\nLast url -- urlList [-1]:\n")
        self.edit.insertLine ("    " + str (urlList [-1]))
        self.edit.insertLine ("    " + str (urlList [-1].url ()))

        self.edit.insertLine ("\nMiddle urls -- urlList [2:4]:\n")
        ulist = urlList [2:4]
        for url in ulist:
            self.edit.insertLine ("    " + str (url))
            self.edit.insertLine ("    " + str (url.url ()))

        self.edit.insertLine ("\nLength of urlList -- len (urlList):\n")
        self.edit.insertLine ("    Length = %i" % len (urlList))

        self.edit.insertLine ('\nurl in urlList? -- KURL ("http://yahoo.com") in urlList\n')
        self.edit.insertLine ('    KURL ("http://yahoo.com") in urlList = %i' % (KURL ("http://yahoo.com") in urlList))


#-------------------- main ------------------------------------------------

description = "A basic application template"
version     = "1.0"
aboutData   = KAboutData ("", "",\
    version, description, KAboutData.License_GPL,\
    "(C) 2003 whoever the author is")

aboutData.addAuthor ("author1", "whatever they did", "email@somedomain")
aboutData.addAuthor ("author2", "they did something else", "another@email.address")

KCmdLineArgs.init (sys.argv, aboutData)

KCmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = KApplication ()
mainWindow = MainWin (None, "main window")
mainWindow.show()
app.exec_loop()
